# Моделі параметрів Cookie { #cookie-parameter-models }

Якщо у Вас є група **cookies**, які пов'язані між собою, Ви можете створити **Pydantic-модель**, щоб оголосити їх. 🍪

Це дозволить Вам повторно **використовувати модель** у **різних місцях**, а також оголосити валідацію та метадані для всіх параметрів одночасно. 😎

/// note | Примітка

Це підтримується з версії FastAPI `0.115.0`. 🤓

///

/// tip | Порада

Ця ж техніка застосовується до `Query`, `Cookie` та `Header`. 😎

///

## Cookie з Pydantic-моделлю { #cookies-with-a-pydantic-model }

Оголосіть **cookie**-параметри, які Вам потрібні, у **Pydantic-моделі**, а потім оголосіть параметр як `Cookie`:

{* ../../docs_src/cookie_param_models/tutorial001_an_py310.py hl[9:12,16] *}

**FastAPI** буде **витягувати** дані для **кожного поля** з **cookies**, отриманих у запиті, і передавати Вам Pydantic-модель, яку Ви визначили.

## Перевірка у документації { #check-the-docs }

Ви можете побачити визначені cookies в інтерфейсі документації за адресою `/docs`:

<div class="screenshot">
<img src="/img/tutorial/cookie-param-models/image01.png">
</div>

/// info | Інформація

Майте на увазі, що оскільки **браузери обробляють cookies** особливим чином і «за лаштунками», вони **не** дозволяють **JavaScript** легко з ними працювати.

Якщо Ви зайдете до **інтерфейсу документації API** за адресою `/docs`, Ви зможете побачити **документацію** для cookies у Ваших *операціях шляху*.

Але навіть якщо Ви заповните дані й натиснете "Execute", оскільки інтерфейс документації працює з **JavaScript**, cookies не будуть відправлені, і Ви побачите **помилку**, ніби Ви не ввели жодних значень.

///

## Заборона додаткових cookie { #forbid-extra-cookies }

У деяких спеціальних випадках (ймовірно, не дуже поширених) Ви можете захотіти **обмежити** cookies, які хочете отримувати.

Ваша API тепер має можливість контролювати власну <abbr title="This is a joke, just in case. It has nothing to do with cookie consents, but it's funny that even the API can now reject the poor cookies. Have a cookie. 🍪">згоду на cookie</abbr>. 🤪🍪

Ви можете використовувати налаштування моделі Pydantic, щоб `forbid` будь-які `extra` поля:

{* ../../docs_src/cookie_param_models/tutorial002_an_py310.py hl[10] *}

Якщо клієнт спробує надіслати якісь **додаткові cookies**, він отримає відповідь з **помилкою**.

Бідні банери cookie, які так старанно намагаються отримати Вашу згоду, щоб <abbr title="This is another joke. Don't pay attention to me. Have some coffee for your cookie. ☕">API її відхилила</abbr>. 🍪

Наприклад, якщо клієнт спробує надіслати cookie `santa_tracker` зі значенням `good-list-please`, він отримає відповідь з помилкою, яка повідомить, що `santa_tracker` <abbr title="Santa disapproves the lack of cookies. 🎅 Okay, no more cookie jokes.">cookie не дозволено</abbr>:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["cookie", "santa_tracker"],
            "msg": "Extra inputs are not permitted",
            "input": "good-list-please",
        }
    ]
}
```

## Підсумок { #summary }

Ви можете використовувати **Pydantic-моделі** для оголошення <abbr title="Have a last cookie before you go. 🍪">**cookies**</abbr> у **FastAPI**. 😎
