info = {
    "name": "sk",
    "date_order": "DMY",
    "january": [
        "jan",
        "január",
        "januára"
    ],
    "february": [
        "feb",
        "február",
        "februára"
    ],
    "march": [
        "mar",
        "marca",
        "marec"
    ],
    "april": [
        "apr",
        "apríl",
        "apríla"
    ],
    "may": [
        "máj",
        "mája"
    ],
    "june": [
        "jún",
        "júna"
    ],
    "july": [
        "júl",
        "júla"
    ],
    "august": [
        "aug",
        "august",
        "augusta"
    ],
    "september": [
        "sep",
        "september",
        "septembra"
    ],
    "october": [
        "okt",
        "október",
        "októbra"
    ],
    "november": [
        "nov",
        "november",
        "novembra"
    ],
    "december": [
        "dec",
        "december",
        "decembra"
    ],
    "monday": [
        "po",
        "pondelok"
    ],
    "tuesday": [
        "ut",
        "utorok"
    ],
    "wednesday": [
        "st",
        "streda",
        "stredu"
    ],
    "thursday": [
        "št",
        "štvrtok"
    ],
    "friday": [
        "pi",
        "piatok"
    ],
    "saturday": [
        "so",
        "sobota",
        "sobotu"
    ],
    "sunday": [
        "ne",
        "nedeľa",
        "nedeľu"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "r",
        "rok"
    ],
    "month": [
        "mes",
        "mesiac"
    ],
    "week": [
        "týž",
        "týždeň"
    ],
    "day": [
        "d",
        "deň"
    ],
    "hour": [
        "h",
        "hodina"
    ],
    "minute": [
        "min",
        "minúta"
    ],
    "second": [
        "s",
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "dnes"
        ],
        "0 hour ago": [
            "v tejto hodine"
        ],
        "0 minute ago": [
            "v tejto minúte"
        ],
        "0 month ago": [
            "tento mesiac"
        ],
        "0 second ago": [
            "teraz"
        ],
        "0 week ago": [
            "tento týždeň"
        ],
        "0 year ago": [
            "tento rok"
        ],
        "1 day ago": [
            "včera"
        ],
        "1 month ago": [
            "minulý mesiac"
        ],
        "1 week ago": [
            "minulý týždeň"
        ],
        "1 year ago": [
            "minulý rok"
        ],
        "in 1 day": [
            "zajtra"
        ],
        "in 1 month": [
            "budúci mesiac"
        ],
        "in 1 week": [
            "budúci týždeň"
        ],
        "in 1 year": [
            "budúci rok"
        ],
        "2 day ago": [
            "predvčerom"
        ],
        "in 2 days": [
            "pozajtra"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "pred (\\d+[.,]?\\d*) d",
            "pred (\\d+[.,]?\\d*) dňami",
            "pred (\\d+[.,]?\\d*) dňom"
        ],
        "\\1 hour ago": [
            "pred (\\d+[.,]?\\d*) h",
            "pred (\\d+[.,]?\\d*) hodinami",
            "pred (\\d+[.,]?\\d*) hodinou"
        ],
        "\\1 minute ago": [
            "pred (\\d+[.,]?\\d*) min",
            "pred (\\d+[.,]?\\d*) minútami",
            "pred (\\d+[.,]?\\d*) minútou"
        ],
        "\\1 month ago": [
            "pred (\\d+[.,]?\\d*) mes",
            "pred (\\d+[.,]?\\d*) mesiacmi",
            "pred (\\d+[.,]?\\d*) mesiacom"
        ],
        "\\1 second ago": [
            "pred (\\d+[.,]?\\d*) s",
            "pred (\\d+[.,]?\\d*) sekundami",
            "pred (\\d+[.,]?\\d*) sekundou"
        ],
        "\\1 week ago": [
            "pred (\\d+[.,]?\\d*) týž",
            "pred (\\d+[.,]?\\d*) týždňami",
            "pred (\\d+[.,]?\\d*) týždňom"
        ],
        "\\1 year ago": [
            "pred (\\d+[.,]?\\d*) r",
            "pred (\\d+[.,]?\\d*) rokmi",
            "pred (\\d+[.,]?\\d*) rokom"
        ],
        "in \\1 day": [
            "o (\\d+[.,]?\\d*) d",
            "o (\\d+[.,]?\\d*) deň",
            "o (\\d+[.,]?\\d*) dní",
            "o (\\d+[.,]?\\d*) dni"
        ],
        "in \\1 hour": [
            "o (\\d+[.,]?\\d*) h",
            "o (\\d+[.,]?\\d*) hodinu",
            "o (\\d+[.,]?\\d*) hodín",
            "o (\\d+[.,]?\\d*) hodiny"
        ],
        "in \\1 minute": [
            "o (\\d+[.,]?\\d*) min",
            "o (\\d+[.,]?\\d*) minút",
            "o (\\d+[.,]?\\d*) minútu",
            "o (\\d+[.,]?\\d*) minúty"
        ],
        "in \\1 month": [
            "o (\\d+[.,]?\\d*) mes",
            "o (\\d+[.,]?\\d*) mesiac",
            "o (\\d+[.,]?\\d*) mesiacov",
            "o (\\d+[.,]?\\d*) mesiace"
        ],
        "in \\1 second": [
            "o (\\d+[.,]?\\d*) s",
            "o (\\d+[.,]?\\d*) sekundu",
            "o (\\d+[.,]?\\d*) sekúnd",
            "o (\\d+[.,]?\\d*) sekundy"
        ],
        "in \\1 week": [
            "o (\\d+[.,]?\\d*) týž",
            "o (\\d+[.,]?\\d*) týždeň",
            "o (\\d+[.,]?\\d*) týždňov",
            "o (\\d+[.,]?\\d*) týždne"
        ],
        "in \\1 year": [
            "o (\\d+[.,]?\\d*) r",
            "o (\\d+[.,]?\\d*) rok",
            "o (\\d+[.,]?\\d*) rokov",
            "o (\\d+[.,]?\\d*) roky"
        ]
    },
    "locale_specific": {},
    "skip": [
        "v",
        "vo",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "pred"
    ],
    "in": [
        "o",
        "za"
    ],
    "simplifications": [
        {
            "pred sekundou": "pred 1 sekundou"
        },
        {
            "pred minútou": "pred 1 minútou"
        },
        {
            "pred hodinou": "pred 1 hodinou"
        },
        {
            "pred týždňom": "pred 1 týždňom"
        },
        {
            "pred mesiacom": "pred 1 mesiacom"
        },
        {
            "pred rokom": "pred 1 rokom"
        },
        {
            "pred pol rokom": "pred 6 mesiacmi"
        },
        {
            "o sekundu": "o 1 sekundu"
        },
        {
            "o minútu": "o 1 minútu"
        },
        {
            "o hodinu": "o 1 hodinu"
        },
        {
            "o týždeň": "o 1 týždeň"
        },
        {
            "o mesiac": "o 1 mesiac"
        },
        {
            "o rok": "o 1 rok"
        },
        {
            "o pol roka": "o 6 mesiacov"
        }
    ]
}
