import SCons.Builder
import SCons.Node.FS
import SCons.Util
tars=['tar', 'gtar']
TarBuilder=SCons.Builder.Builder(action='$TARCOM', source_factory=SCons.Node.FS.default_fs.Entry,
				   suffix='$TARSUFFIX', multi=1)
def generate(env):
    try:
        bld=env['BUILDERS']['Tar']
    except KeyError:
        bld=TarBuilder
        env['BUILDERS']['Tar']=bld
    env['TAR']       =env.Detect(tars) or 'gtar'
    env['TARFLAGS']  =SCons.Util.CLVar('-c')
    env['TARCOM']    ='$TAR $TARFLAGS -f $TARGET $SOURCES'
    env['TARSUFFIX'] ='.tar'
def exists(env):
    return env.Detect(tars)
