/* Conversion tables for KS C 5601-1992 based encoding conversion.
   Copyright (C) 1998, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Jungshik Shin <jshin@pantheon.yale.edu>, 1998.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <stdint.h>
#include "ksc5601.h"

/*
egrep  '# HANGUL SYLL' < /cdrom/unix/mappings/eastasia/ksc/ksc5601.txt | \
egrep -v '^0x[4-9AD-F]' | egrep -v '^0x..([4-9].|A0)' | \
perl tab21.pl > ksc_hangul1.tb

----------
   $n=0;
   while (<>) {
     local($ksc, $ucs4, %rest) = split;
     local($u)=hex($ucs4);
     local($k)=hex($ksc);
     printf ("\n ") if ($n % 8 eq 0);
     ++$n;
     printf (" 0x%04x,", $u);
   }
   printf ("\n");
---------

  2350 Hangul syllables defined in KS C 5601 are assigned
  row 16 - row 40 (with each row having 94 pre-composed syllables).

  No gap exists and all of them are sorted in Unicode 2.0 in the same
  order as in KS C 5601 so that we can use the single table to convert
  between KS C 5601-1987 based encodings(EUC-KR, ISO-2022-KR)
  and UCS-4.

*/


const uint16_t __ksc5601_hangul_to_ucs[KSC5601_HANGUL]=
{
  0xac00, 0xac01, 0xac04, 0xac07, 0xac08, 0xac09, 0xac0a, 0xac10,
  0xac11, 0xac12, 0xac13, 0xac14, 0xac15, 0xac16, 0xac17, 0xac19,
  0xac1a, 0xac1b, 0xac1c, 0xac1d, 0xac20, 0xac24, 0xac2c, 0xac2d,
  0xac2f, 0xac30, 0xac31, 0xac38, 0xac39, 0xac3c, 0xac40, 0xac4b,
  0xac4d, 0xac54, 0xac58, 0xac5c, 0xac70, 0xac71, 0xac74, 0xac77,
  0xac78, 0xac7a, 0xac80, 0xac81, 0xac83, 0xac84, 0xac85, 0xac86,
  0xac89, 0xac8a, 0xac8b, 0xac8c, 0xac90, 0xac94, 0xac9c, 0xac9d,
  0xac9f, 0xaca0, 0xaca1, 0xaca8, 0xaca9, 0xacaa, 0xacac, 0xacaf,
  0xacb0, 0xacb8, 0xacb9, 0xacbb, 0xacbc, 0xacbd, 0xacc1, 0xacc4,
  0xacc8, 0xaccc, 0xacd5, 0xacd7, 0xace0, 0xace1, 0xace4, 0xace7,
  0xace8, 0xacea, 0xacec, 0xacef, 0xacf0, 0xacf1, 0xacf3, 0xacf5,
  0xacf6, 0xacfc, 0xacfd, 0xad00, 0xad04, 0xad06, 0xad0c, 0xad0d,
  0xad0f, 0xad11, 0xad18, 0xad1c, 0xad20, 0xad29, 0xad2c, 0xad2d,
  0xad34, 0xad35, 0xad38, 0xad3c, 0xad44, 0xad45, 0xad47, 0xad49,
  0xad50, 0xad54, 0xad58, 0xad61, 0xad63, 0xad6c, 0xad6d, 0xad70,
  0xad73, 0xad74, 0xad75, 0xad76, 0xad7b, 0xad7c, 0xad7d, 0xad7f,
  0xad81, 0xad82, 0xad88, 0xad89, 0xad8c, 0xad90, 0xad9c, 0xad9d,
  0xada4, 0xadb7, 0xadc0, 0xadc1, 0xadc4, 0xadc8, 0xadd0, 0xadd1,
  0xadd3, 0xaddc, 0xade0, 0xade4, 0xadf8, 0xadf9, 0xadfc, 0xadff,
  0xae00, 0xae01, 0xae08, 0xae09, 0xae0b, 0xae0d, 0xae14, 0xae30,
  0xae31, 0xae34, 0xae37, 0xae38, 0xae3a, 0xae40, 0xae41, 0xae43,
  0xae45, 0xae46, 0xae4a, 0xae4c, 0xae4d, 0xae4e, 0xae50, 0xae54,
  0xae56, 0xae5c, 0xae5d, 0xae5f, 0xae60, 0xae61, 0xae65, 0xae68,
  0xae69, 0xae6c, 0xae70, 0xae78, 0xae79, 0xae7b, 0xae7c, 0xae7d,
  0xae84, 0xae85, 0xae8c, 0xaebc, 0xaebd, 0xaebe, 0xaec0, 0xaec4,
  0xaecc, 0xaecd, 0xaecf, 0xaed0, 0xaed1, 0xaed8, 0xaed9, 0xaedc,
  0xaee8, 0xaeeb, 0xaeed, 0xaef4, 0xaef8, 0xaefc, 0xaf07, 0xaf08,
  0xaf0d, 0xaf10, 0xaf2c, 0xaf2d, 0xaf30, 0xaf32, 0xaf34, 0xaf3c,
  0xaf3d, 0xaf3f, 0xaf41, 0xaf42, 0xaf43, 0xaf48, 0xaf49, 0xaf50,
  0xaf5c, 0xaf5d, 0xaf64, 0xaf65, 0xaf79, 0xaf80, 0xaf84, 0xaf88,
  0xaf90, 0xaf91, 0xaf95, 0xaf9c, 0xafb8, 0xafb9, 0xafbc, 0xafc0,
  0xafc7, 0xafc8, 0xafc9, 0xafcb, 0xafcd, 0xafce, 0xafd4, 0xafdc,
  0xafe8, 0xafe9, 0xaff0, 0xaff1, 0xaff4, 0xaff8, 0xb000, 0xb001,
  0xb004, 0xb00c, 0xb010, 0xb014, 0xb01c, 0xb01d, 0xb028, 0xb044,
  0xb045, 0xb048, 0xb04a, 0xb04c, 0xb04e, 0xb053, 0xb054, 0xb055,
  0xb057, 0xb059, 0xb05d, 0xb07c, 0xb07d, 0xb080, 0xb084, 0xb08c,
  0xb08d, 0xb08f, 0xb091, 0xb098, 0xb099, 0xb09a, 0xb09c, 0xb09f,
  0xb0a0, 0xb0a1, 0xb0a2, 0xb0a8, 0xb0a9, 0xb0ab, 0xb0ac, 0xb0ad,
  0xb0ae, 0xb0af, 0xb0b1, 0xb0b3, 0xb0b4, 0xb0b5, 0xb0b8, 0xb0bc,
  0xb0c4, 0xb0c5, 0xb0c7, 0xb0c8, 0xb0c9, 0xb0d0, 0xb0d1, 0xb0d4,
  0xb0d8, 0xb0e0, 0xb0e5, 0xb108, 0xb109, 0xb10b, 0xb10c, 0xb110,
  0xb112, 0xb113, 0xb118, 0xb119, 0xb11b, 0xb11c, 0xb11d, 0xb123,
  0xb124, 0xb125, 0xb128, 0xb12c, 0xb134, 0xb135, 0xb137, 0xb138,
  0xb139, 0xb140, 0xb141, 0xb144, 0xb148, 0xb150, 0xb151, 0xb154,
  0xb155, 0xb158, 0xb15c, 0xb160, 0xb178, 0xb179, 0xb17c, 0xb180,
  0xb182, 0xb188, 0xb189, 0xb18b, 0xb18d, 0xb192, 0xb193, 0xb194,
  0xb198, 0xb19c, 0xb1a8, 0xb1cc, 0xb1d0, 0xb1d4, 0xb1dc, 0xb1dd,
  0xb1df, 0xb1e8, 0xb1e9, 0xb1ec, 0xb1f0, 0xb1f9, 0xb1fb, 0xb1fd,
  0xb204, 0xb205, 0xb208, 0xb20b, 0xb20c, 0xb214, 0xb215, 0xb217,
  0xb219, 0xb220, 0xb234, 0xb23c, 0xb258, 0xb25c, 0xb260, 0xb268,
  0xb269, 0xb274, 0xb275, 0xb27c, 0xb284, 0xb285, 0xb289, 0xb290,
  0xb291, 0xb294, 0xb298, 0xb299, 0xb29a, 0xb2a0, 0xb2a1, 0xb2a3,
  0xb2a5, 0xb2a6, 0xb2aa, 0xb2ac, 0xb2b0, 0xb2b4, 0xb2c8, 0xb2c9,
  0xb2cc, 0xb2d0, 0xb2d2, 0xb2d8, 0xb2d9, 0xb2db, 0xb2dd, 0xb2e2,
  0xb2e4, 0xb2e5, 0xb2e6, 0xb2e8, 0xb2eb, 0xb2ec, 0xb2ed, 0xb2ee,
  0xb2ef, 0xb2f3, 0xb2f4, 0xb2f5, 0xb2f7, 0xb2f8, 0xb2f9, 0xb2fa,
  0xb2fb, 0xb2ff, 0xb300, 0xb301, 0xb304, 0xb308, 0xb310, 0xb311,
  0xb313, 0xb314, 0xb315, 0xb31c, 0xb354, 0xb355, 0xb356, 0xb358,
  0xb35b, 0xb35c, 0xb35e, 0xb35f, 0xb364, 0xb365, 0xb367, 0xb369,
  0xb36b, 0xb36e, 0xb370, 0xb371, 0xb374, 0xb378, 0xb380, 0xb381,
  0xb383, 0xb384, 0xb385, 0xb38c, 0xb390, 0xb394, 0xb3a0, 0xb3a1,
  0xb3a8, 0xb3ac, 0xb3c4, 0xb3c5, 0xb3c8, 0xb3cb, 0xb3cc, 0xb3ce,
  0xb3d0, 0xb3d4, 0xb3d5, 0xb3d7, 0xb3d9, 0xb3db, 0xb3dd, 0xb3e0,
  0xb3e4, 0xb3e8, 0xb3fc, 0xb410, 0xb418, 0xb41c, 0xb420, 0xb428,
  0xb429, 0xb42b, 0xb434, 0xb450, 0xb451, 0xb454, 0xb458, 0xb460,
  0xb461, 0xb463, 0xb465, 0xb46c, 0xb480, 0xb488, 0xb49d, 0xb4a4,
  0xb4a8, 0xb4ac, 0xb4b5, 0xb4b7, 0xb4b9, 0xb4c0, 0xb4c4, 0xb4c8,
  0xb4d0, 0xb4d5, 0xb4dc, 0xb4dd, 0xb4e0, 0xb4e3, 0xb4e4, 0xb4e6,
  0xb4ec, 0xb4ed, 0xb4ef, 0xb4f1, 0xb4f8, 0xb514, 0xb515, 0xb518,
  0xb51b, 0xb51c, 0xb524, 0xb525, 0xb527, 0xb528, 0xb529, 0xb52a,
  0xb530, 0xb531, 0xb534, 0xb538, 0xb540, 0xb541, 0xb543, 0xb544,
  0xb545, 0xb54b, 0xb54c, 0xb54d, 0xb550, 0xb554, 0xb55c, 0xb55d,
  0xb55f, 0xb560, 0xb561, 0xb5a0, 0xb5a1, 0xb5a4, 0xb5a8, 0xb5aa,
  0xb5ab, 0xb5b0, 0xb5b1, 0xb5b3, 0xb5b4, 0xb5b5, 0xb5bb, 0xb5bc,
  0xb5bd, 0xb5c0, 0xb5c4, 0xb5cc, 0xb5cd, 0xb5cf, 0xb5d0, 0xb5d1,
  0xb5d8, 0xb5ec, 0xb610, 0xb611, 0xb614, 0xb618, 0xb625, 0xb62c,
  0xb634, 0xb648, 0xb664, 0xb668, 0xb69c, 0xb69d, 0xb6a0, 0xb6a4,
  0xb6ab, 0xb6ac, 0xb6b1, 0xb6d4, 0xb6f0, 0xb6f4, 0xb6f8, 0xb700,
  0xb701, 0xb705, 0xb728, 0xb729, 0xb72c, 0xb72f, 0xb730, 0xb738,
  0xb739, 0xb73b, 0xb744, 0xb748, 0xb74c, 0xb754, 0xb755, 0xb760,
  0xb764, 0xb768, 0xb770, 0xb771, 0xb773, 0xb775, 0xb77c, 0xb77d,
  0xb780, 0xb784, 0xb78c, 0xb78d, 0xb78f, 0xb790, 0xb791, 0xb792,
  0xb796, 0xb797, 0xb798, 0xb799, 0xb79c, 0xb7a0, 0xb7a8, 0xb7a9,
  0xb7ab, 0xb7ac, 0xb7ad, 0xb7b4, 0xb7b5, 0xb7b8, 0xb7c7, 0xb7c9,
  0xb7ec, 0xb7ed, 0xb7f0, 0xb7f4, 0xb7fc, 0xb7fd, 0xb7ff, 0xb800,
  0xb801, 0xb807, 0xb808, 0xb809, 0xb80c, 0xb810, 0xb818, 0xb819,
  0xb81b, 0xb81d, 0xb824, 0xb825, 0xb828, 0xb82c, 0xb834, 0xb835,
  0xb837, 0xb838, 0xb839, 0xb840, 0xb844, 0xb851, 0xb853, 0xb85c,
  0xb85d, 0xb860, 0xb864, 0xb86c, 0xb86d, 0xb86f, 0xb871, 0xb878,
  0xb87c, 0xb88d, 0xb8a8, 0xb8b0, 0xb8b4, 0xb8b8, 0xb8c0, 0xb8c1,
  0xb8c3, 0xb8c5, 0xb8cc, 0xb8d0, 0xb8d4, 0xb8dd, 0xb8df, 0xb8e1,
  0xb8e8, 0xb8e9, 0xb8ec, 0xb8f0, 0xb8f8, 0xb8f9, 0xb8fb, 0xb8fd,
  0xb904, 0xb918, 0xb920, 0xb93c, 0xb93d, 0xb940, 0xb944, 0xb94c,
  0xb94f, 0xb951, 0xb958, 0xb959, 0xb95c, 0xb960, 0xb968, 0xb969,
  0xb96b, 0xb96d, 0xb974, 0xb975, 0xb978, 0xb97c, 0xb984, 0xb985,
  0xb987, 0xb989, 0xb98a, 0xb98d, 0xb98e, 0xb9ac, 0xb9ad, 0xb9b0,
  0xb9b4, 0xb9bc, 0xb9bd, 0xb9bf, 0xb9c1, 0xb9c8, 0xb9c9, 0xb9cc,
  0xb9ce, 0xb9cf, 0xb9d0, 0xb9d1, 0xb9d2, 0xb9d8, 0xb9d9, 0xb9db,
  0xb9dd, 0xb9de, 0xb9e1, 0xb9e3, 0xb9e4, 0xb9e5, 0xb9e8, 0xb9ec,
  0xb9f4, 0xb9f5, 0xb9f7, 0xb9f8, 0xb9f9, 0xb9fa, 0xba00, 0xba01,
  0xba08, 0xba15, 0xba38, 0xba39, 0xba3c, 0xba40, 0xba42, 0xba48,
  0xba49, 0xba4b, 0xba4d, 0xba4e, 0xba53, 0xba54, 0xba55, 0xba58,
  0xba5c, 0xba64, 0xba65, 0xba67, 0xba68, 0xba69, 0xba70, 0xba71,
  0xba74, 0xba78, 0xba83, 0xba84, 0xba85, 0xba87, 0xba8c, 0xbaa8,
  0xbaa9, 0xbaab, 0xbaac, 0xbab0, 0xbab2, 0xbab8, 0xbab9, 0xbabb,
  0xbabd, 0xbac4, 0xbac8, 0xbad8, 0xbad9, 0xbafc, 0xbb00, 0xbb04,
  0xbb0d, 0xbb0f, 0xbb11, 0xbb18, 0xbb1c, 0xbb20, 0xbb29, 0xbb2b,
  0xbb34, 0xbb35, 0xbb36, 0xbb38, 0xbb3b, 0xbb3c, 0xbb3d, 0xbb3e,
  0xbb44, 0xbb45, 0xbb47, 0xbb49, 0xbb4d, 0xbb4f, 0xbb50, 0xbb54,
  0xbb58, 0xbb61, 0xbb63, 0xbb6c, 0xbb88, 0xbb8c, 0xbb90, 0xbba4,
  0xbba8, 0xbbac, 0xbbb4, 0xbbb7, 0xbbc0, 0xbbc4, 0xbbc8, 0xbbd0,
  0xbbd3, 0xbbf8, 0xbbf9, 0xbbfc, 0xbbff, 0xbc00, 0xbc02, 0xbc08,
  0xbc09, 0xbc0b, 0xbc0c, 0xbc0d, 0xbc0f, 0xbc11, 0xbc14, 0xbc15,
  0xbc16, 0xbc17, 0xbc18, 0xbc1b, 0xbc1c, 0xbc1d, 0xbc1e, 0xbc1f,
  0xbc24, 0xbc25, 0xbc27, 0xbc29, 0xbc2d, 0xbc30, 0xbc31, 0xbc34,
  0xbc38, 0xbc40, 0xbc41, 0xbc43, 0xbc44, 0xbc45, 0xbc49, 0xbc4c,
  0xbc4d, 0xbc50, 0xbc5d, 0xbc84, 0xbc85, 0xbc88, 0xbc8b, 0xbc8c,
  0xbc8e, 0xbc94, 0xbc95, 0xbc97, 0xbc99, 0xbc9a, 0xbca0, 0xbca1,
  0xbca4, 0xbca7, 0xbca8, 0xbcb0, 0xbcb1, 0xbcb3, 0xbcb4, 0xbcb5,
  0xbcbc, 0xbcbd, 0xbcc0, 0xbcc4, 0xbccd, 0xbccf, 0xbcd0, 0xbcd1,
  0xbcd5, 0xbcd8, 0xbcdc, 0xbcf4, 0xbcf5, 0xbcf6, 0xbcf8, 0xbcfc,
  0xbd04, 0xbd05, 0xbd07, 0xbd09, 0xbd10, 0xbd14, 0xbd24, 0xbd2c,
  0xbd40, 0xbd48, 0xbd49, 0xbd4c, 0xbd50, 0xbd58, 0xbd59, 0xbd64,
  0xbd68, 0xbd80, 0xbd81, 0xbd84, 0xbd87, 0xbd88, 0xbd89, 0xbd8a,
  0xbd90, 0xbd91, 0xbd93, 0xbd95, 0xbd99, 0xbd9a, 0xbd9c, 0xbda4,
  0xbdb0, 0xbdb8, 0xbdd4, 0xbdd5, 0xbdd8, 0xbddc, 0xbde9, 0xbdf0,
  0xbdf4, 0xbdf8, 0xbe00, 0xbe03, 0xbe05, 0xbe0c, 0xbe0d, 0xbe10,
  0xbe14, 0xbe1c, 0xbe1d, 0xbe1f, 0xbe44, 0xbe45, 0xbe48, 0xbe4c,
  0xbe4e, 0xbe54, 0xbe55, 0xbe57, 0xbe59, 0xbe5a, 0xbe5b, 0xbe60,
  0xbe61, 0xbe64, 0xbe68, 0xbe6a, 0xbe70, 0xbe71, 0xbe73, 0xbe74,
  0xbe75, 0xbe7b, 0xbe7c, 0xbe7d, 0xbe80, 0xbe84, 0xbe8c, 0xbe8d,
  0xbe8f, 0xbe90, 0xbe91, 0xbe98, 0xbe99, 0xbea8, 0xbed0, 0xbed1,
  0xbed4, 0xbed7, 0xbed8, 0xbee0, 0xbee3, 0xbee4, 0xbee5, 0xbeec,
  0xbf01, 0xbf08, 0xbf09, 0xbf18, 0xbf19, 0xbf1b, 0xbf1c, 0xbf1d,
  0xbf40, 0xbf41, 0xbf44, 0xbf48, 0xbf50, 0xbf51, 0xbf55, 0xbf94,
  0xbfb0, 0xbfc5, 0xbfcc, 0xbfcd, 0xbfd0, 0xbfd4, 0xbfdc, 0xbfdf,
  0xbfe1, 0xc03c, 0xc051, 0xc058, 0xc05c, 0xc060, 0xc068, 0xc069,
  0xc090, 0xc091, 0xc094, 0xc098, 0xc0a0, 0xc0a1, 0xc0a3, 0xc0a5,
  0xc0ac, 0xc0ad, 0xc0af, 0xc0b0, 0xc0b3, 0xc0b4, 0xc0b5, 0xc0b6,
  0xc0bc, 0xc0bd, 0xc0bf, 0xc0c0, 0xc0c1, 0xc0c5, 0xc0c8, 0xc0c9,
  0xc0cc, 0xc0d0, 0xc0d8, 0xc0d9, 0xc0db, 0xc0dc, 0xc0dd, 0xc0e4,
  0xc0e5, 0xc0e8, 0xc0ec, 0xc0f4, 0xc0f5, 0xc0f7, 0xc0f9, 0xc100,
  0xc104, 0xc108, 0xc110, 0xc115, 0xc11c, 0xc11d, 0xc11e, 0xc11f,
  0xc120, 0xc123, 0xc124, 0xc126, 0xc127, 0xc12c, 0xc12d, 0xc12f,
  0xc130, 0xc131, 0xc136, 0xc138, 0xc139, 0xc13c, 0xc140, 0xc148,
  0xc149, 0xc14b, 0xc14c, 0xc14d, 0xc154, 0xc155, 0xc158, 0xc15c,
  0xc164, 0xc165, 0xc167, 0xc168, 0xc169, 0xc170, 0xc174, 0xc178,
  0xc185, 0xc18c, 0xc18d, 0xc18e, 0xc190, 0xc194, 0xc196, 0xc19c,
  0xc19d, 0xc19f, 0xc1a1, 0xc1a5, 0xc1a8, 0xc1a9, 0xc1ac, 0xc1b0,
  0xc1bd, 0xc1c4, 0xc1c8, 0xc1cc, 0xc1d4, 0xc1d7, 0xc1d8, 0xc1e0,
  0xc1e4, 0xc1e8, 0xc1f0, 0xc1f1, 0xc1f3, 0xc1fc, 0xc1fd, 0xc200,
  0xc204, 0xc20c, 0xc20d, 0xc20f, 0xc211, 0xc218, 0xc219, 0xc21c,
  0xc21f, 0xc220, 0xc228, 0xc229, 0xc22b, 0xc22d, 0xc22f, 0xc231,
  0xc232, 0xc234, 0xc248, 0xc250, 0xc251, 0xc254, 0xc258, 0xc260,
  0xc265, 0xc26c, 0xc26d, 0xc270, 0xc274, 0xc27c, 0xc27d, 0xc27f,
  0xc281, 0xc288, 0xc289, 0xc290, 0xc298, 0xc29b, 0xc29d, 0xc2a4,
  0xc2a5, 0xc2a8, 0xc2ac, 0xc2ad, 0xc2b4, 0xc2b5, 0xc2b7, 0xc2b9,
  0xc2dc, 0xc2dd, 0xc2e0, 0xc2e3, 0xc2e4, 0xc2eb, 0xc2ec, 0xc2ed,
  0xc2ef, 0xc2f1, 0xc2f6, 0xc2f8, 0xc2f9, 0xc2fb, 0xc2fc, 0xc300,
  0xc308, 0xc309, 0xc30c, 0xc30d, 0xc313, 0xc314, 0xc315, 0xc318,
  0xc31c, 0xc324, 0xc325, 0xc328, 0xc329, 0xc345, 0xc368, 0xc369,
  0xc36c, 0xc370, 0xc372, 0xc378, 0xc379, 0xc37c, 0xc37d, 0xc384,
  0xc388, 0xc38c, 0xc3c0, 0xc3d8, 0xc3d9, 0xc3dc, 0xc3df, 0xc3e0,
  0xc3e2, 0xc3e8, 0xc3e9, 0xc3ed, 0xc3f4, 0xc3f5, 0xc3f8, 0xc408,
  0xc410, 0xc424, 0xc42c, 0xc430, 0xc434, 0xc43c, 0xc43d, 0xc448,
  0xc464, 0xc465, 0xc468, 0xc46c, 0xc474, 0xc475, 0xc479, 0xc480,
  0xc494, 0xc49c, 0xc4b8, 0xc4bc, 0xc4e9, 0xc4f0, 0xc4f1, 0xc4f4,
  0xc4f8, 0xc4fa, 0xc4ff, 0xc500, 0xc501, 0xc50c, 0xc510, 0xc514,
  0xc51c, 0xc528, 0xc529, 0xc52c, 0xc530, 0xc538, 0xc539, 0xc53b,
  0xc53d, 0xc544, 0xc545, 0xc548, 0xc549, 0xc54a, 0xc54c, 0xc54d,
  0xc54e, 0xc553, 0xc554, 0xc555, 0xc557, 0xc558, 0xc559, 0xc55d,
  0xc55e, 0xc560, 0xc561, 0xc564, 0xc568, 0xc570, 0xc571, 0xc573,
  0xc574, 0xc575, 0xc57c, 0xc57d, 0xc580, 0xc584, 0xc587, 0xc58c,
  0xc58d, 0xc58f, 0xc591, 0xc595, 0xc597, 0xc598, 0xc59c, 0xc5a0,
  0xc5a9, 0xc5b4, 0xc5b5, 0xc5b8, 0xc5b9, 0xc5bb, 0xc5bc, 0xc5bd,
  0xc5be, 0xc5c4, 0xc5c5, 0xc5c6, 0xc5c7, 0xc5c8, 0xc5c9, 0xc5ca,
  0xc5cc, 0xc5ce, 0xc5d0, 0xc5d1, 0xc5d4, 0xc5d8, 0xc5e0, 0xc5e1,
  0xc5e3, 0xc5e5, 0xc5ec, 0xc5ed, 0xc5ee, 0xc5f0, 0xc5f4, 0xc5f6,
  0xc5f7, 0xc5fc, 0xc5fd, 0xc5fe, 0xc5ff, 0xc600, 0xc601, 0xc605,
  0xc606, 0xc607, 0xc608, 0xc60c, 0xc610, 0xc618, 0xc619, 0xc61b,
  0xc61c, 0xc624, 0xc625, 0xc628, 0xc62c, 0xc62d, 0xc62e, 0xc630,
  0xc633, 0xc634, 0xc635, 0xc637, 0xc639, 0xc63b, 0xc640, 0xc641,
  0xc644, 0xc648, 0xc650, 0xc651, 0xc653, 0xc654, 0xc655, 0xc65c,
  0xc65d, 0xc660, 0xc66c, 0xc66f, 0xc671, 0xc678, 0xc679, 0xc67c,
  0xc680, 0xc688, 0xc689, 0xc68b, 0xc68d, 0xc694, 0xc695, 0xc698,
  0xc69c, 0xc6a4, 0xc6a5, 0xc6a7, 0xc6a9, 0xc6b0, 0xc6b1, 0xc6b4,
  0xc6b8, 0xc6b9, 0xc6ba, 0xc6c0, 0xc6c1, 0xc6c3, 0xc6c5, 0xc6cc,
  0xc6cd, 0xc6d0, 0xc6d4, 0xc6dc, 0xc6dd, 0xc6e0, 0xc6e1, 0xc6e8,
  0xc6e9, 0xc6ec, 0xc6f0, 0xc6f8, 0xc6f9, 0xc6fd, 0xc704, 0xc705,
  0xc708, 0xc70c, 0xc714, 0xc715, 0xc717, 0xc719, 0xc720, 0xc721,
  0xc724, 0xc728, 0xc730, 0xc731, 0xc733, 0xc735, 0xc737, 0xc73c,
  0xc73d, 0xc740, 0xc744, 0xc74a, 0xc74c, 0xc74d, 0xc74f, 0xc751,
  0xc752, 0xc753, 0xc754, 0xc755, 0xc756, 0xc757, 0xc758, 0xc75c,
  0xc760, 0xc768, 0xc76b, 0xc774, 0xc775, 0xc778, 0xc77c, 0xc77d,
  0xc77e, 0xc783, 0xc784, 0xc785, 0xc787, 0xc788, 0xc789, 0xc78a,
  0xc78e, 0xc790, 0xc791, 0xc794, 0xc796, 0xc797, 0xc798, 0xc79a,
  0xc7a0, 0xc7a1, 0xc7a3, 0xc7a4, 0xc7a5, 0xc7a6, 0xc7ac, 0xc7ad,
  0xc7b0, 0xc7b4, 0xc7bc, 0xc7bd, 0xc7bf, 0xc7c0, 0xc7c1, 0xc7c8,
  0xc7c9, 0xc7cc, 0xc7ce, 0xc7d0, 0xc7d8, 0xc7dd, 0xc7e4, 0xc7e8,
  0xc7ec, 0xc800, 0xc801, 0xc804, 0xc808, 0xc80a, 0xc810, 0xc811,
  0xc813, 0xc815, 0xc816, 0xc81c, 0xc81d, 0xc820, 0xc824, 0xc82c,
  0xc82d, 0xc82f, 0xc831, 0xc838, 0xc83c, 0xc840, 0xc848, 0xc849,
  0xc84c, 0xc84d, 0xc854, 0xc870, 0xc871, 0xc874, 0xc878, 0xc87a,
  0xc880, 0xc881, 0xc883, 0xc885, 0xc886, 0xc887, 0xc88b, 0xc88c,
  0xc88d, 0xc894, 0xc89d, 0xc89f, 0xc8a1, 0xc8a8, 0xc8bc, 0xc8bd,
  0xc8c4, 0xc8c8, 0xc8cc, 0xc8d4, 0xc8d5, 0xc8d7, 0xc8d9, 0xc8e0,
  0xc8e1, 0xc8e4, 0xc8f5, 0xc8fc, 0xc8fd, 0xc900, 0xc904, 0xc905,
  0xc906, 0xc90c, 0xc90d, 0xc90f, 0xc911, 0xc918, 0xc92c, 0xc934,
  0xc950, 0xc951, 0xc954, 0xc958, 0xc960, 0xc961, 0xc963, 0xc96c,
  0xc970, 0xc974, 0xc97c, 0xc988, 0xc989, 0xc98c, 0xc990, 0xc998,
  0xc999, 0xc99b, 0xc99d, 0xc9c0, 0xc9c1, 0xc9c4, 0xc9c7, 0xc9c8,
  0xc9ca, 0xc9d0, 0xc9d1, 0xc9d3, 0xc9d5, 0xc9d6, 0xc9d9, 0xc9da,
  0xc9dc, 0xc9dd, 0xc9e0, 0xc9e2, 0xc9e4, 0xc9e7, 0xc9ec, 0xc9ed,
  0xc9ef, 0xc9f0, 0xc9f1, 0xc9f8, 0xc9f9, 0xc9fc, 0xca00, 0xca08,
  0xca09, 0xca0b, 0xca0c, 0xca0d, 0xca14, 0xca18, 0xca29, 0xca4c,
  0xca4d, 0xca50, 0xca54, 0xca5c, 0xca5d, 0xca5f, 0xca60, 0xca61,
  0xca68, 0xca7d, 0xca84, 0xca98, 0xcabc, 0xcabd, 0xcac0, 0xcac4,
  0xcacc, 0xcacd, 0xcacf, 0xcad1, 0xcad3, 0xcad8, 0xcad9, 0xcae0,
  0xcaec, 0xcaf4, 0xcb08, 0xcb10, 0xcb14, 0xcb18, 0xcb20, 0xcb21,
  0xcb41, 0xcb48, 0xcb49, 0xcb4c, 0xcb50, 0xcb58, 0xcb59, 0xcb5d,
  0xcb64, 0xcb78, 0xcb79, 0xcb9c, 0xcbb8, 0xcbd4, 0xcbe4, 0xcbe7,
  0xcbe9, 0xcc0c, 0xcc0d, 0xcc10, 0xcc14, 0xcc1c, 0xcc1d, 0xcc21,
  0xcc22, 0xcc27, 0xcc28, 0xcc29, 0xcc2c, 0xcc2e, 0xcc30, 0xcc38,
  0xcc39, 0xcc3b, 0xcc3c, 0xcc3d, 0xcc3e, 0xcc44, 0xcc45, 0xcc48,
  0xcc4c, 0xcc54, 0xcc55, 0xcc57, 0xcc58, 0xcc59, 0xcc60, 0xcc64,
  0xcc66, 0xcc68, 0xcc70, 0xcc75, 0xcc98, 0xcc99, 0xcc9c, 0xcca0,
  0xcca8, 0xcca9, 0xccab, 0xccac, 0xccad, 0xccb4, 0xccb5, 0xccb8,
  0xccbc, 0xccc4, 0xccc5, 0xccc7, 0xccc9, 0xccd0, 0xccd4, 0xcce4,
  0xccec, 0xccf0, 0xcd01, 0xcd08, 0xcd09, 0xcd0c, 0xcd10, 0xcd18,
  0xcd19, 0xcd1b, 0xcd1d, 0xcd24, 0xcd28, 0xcd2c, 0xcd39, 0xcd5c,
  0xcd60, 0xcd64, 0xcd6c, 0xcd6d, 0xcd6f, 0xcd71, 0xcd78, 0xcd88,
  0xcd94, 0xcd95, 0xcd98, 0xcd9c, 0xcda4, 0xcda5, 0xcda7, 0xcda9,
  0xcdb0, 0xcdc4, 0xcdcc, 0xcdd0, 0xcde8, 0xcdec, 0xcdf0, 0xcdf8,
  0xcdf9, 0xcdfb, 0xcdfd, 0xce04, 0xce08, 0xce0c, 0xce14, 0xce19,
  0xce20, 0xce21, 0xce24, 0xce28, 0xce30, 0xce31, 0xce33, 0xce35,
  0xce58, 0xce59, 0xce5c, 0xce5f, 0xce60, 0xce61, 0xce68, 0xce69,
  0xce6b, 0xce6d, 0xce74, 0xce75, 0xce78, 0xce7c, 0xce84, 0xce85,
  0xce87, 0xce89, 0xce90, 0xce91, 0xce94, 0xce98, 0xcea0, 0xcea1,
  0xcea3, 0xcea4, 0xcea5, 0xceac, 0xcead, 0xcec1, 0xcee4, 0xcee5,
  0xcee8, 0xceeb, 0xceec, 0xcef4, 0xcef5, 0xcef7, 0xcef8, 0xcef9,
  0xcf00, 0xcf01, 0xcf04, 0xcf08, 0xcf10, 0xcf11, 0xcf13, 0xcf15,
  0xcf1c, 0xcf20, 0xcf24, 0xcf2c, 0xcf2d, 0xcf2f, 0xcf30, 0xcf31,
  0xcf38, 0xcf54, 0xcf55, 0xcf58, 0xcf5c, 0xcf64, 0xcf65, 0xcf67,
  0xcf69, 0xcf70, 0xcf71, 0xcf74, 0xcf78, 0xcf80, 0xcf85, 0xcf8c,
  0xcfa1, 0xcfa8, 0xcfb0, 0xcfc4, 0xcfe0, 0xcfe1, 0xcfe4, 0xcfe8,
  0xcff0, 0xcff1, 0xcff3, 0xcff5, 0xcffc, 0xd000, 0xd004, 0xd011,
  0xd018, 0xd02d, 0xd034, 0xd035, 0xd038, 0xd03c, 0xd044, 0xd045,
  0xd047, 0xd049, 0xd050, 0xd054, 0xd058, 0xd060, 0xd06c, 0xd06d,
  0xd070, 0xd074, 0xd07c, 0xd07d, 0xd081, 0xd0a4, 0xd0a5, 0xd0a8,
  0xd0ac, 0xd0b4, 0xd0b5, 0xd0b7, 0xd0b9, 0xd0c0, 0xd0c1, 0xd0c4,
  0xd0c8, 0xd0c9, 0xd0d0, 0xd0d1, 0xd0d3, 0xd0d4, 0xd0d5, 0xd0dc,
  0xd0dd, 0xd0e0, 0xd0e4, 0xd0ec, 0xd0ed, 0xd0ef, 0xd0f0, 0xd0f1,
  0xd0f8, 0xd10d, 0xd130, 0xd131, 0xd134, 0xd138, 0xd13a, 0xd140,
  0xd141, 0xd143, 0xd144, 0xd145, 0xd14c, 0xd14d, 0xd150, 0xd154,
  0xd15c, 0xd15d, 0xd15f, 0xd161, 0xd168, 0xd16c, 0xd17c, 0xd184,
  0xd188, 0xd1a0, 0xd1a1, 0xd1a4, 0xd1a8, 0xd1b0, 0xd1b1, 0xd1b3,
  0xd1b5, 0xd1ba, 0xd1bc, 0xd1c0, 0xd1d8, 0xd1f4, 0xd1f8, 0xd207,
  0xd209, 0xd210, 0xd22c, 0xd22d, 0xd230, 0xd234, 0xd23c, 0xd23d,
  0xd23f, 0xd241, 0xd248, 0xd25c, 0xd264, 0xd280, 0xd281, 0xd284,
  0xd288, 0xd290, 0xd291, 0xd295, 0xd29c, 0xd2a0, 0xd2a4, 0xd2ac,
  0xd2b1, 0xd2b8, 0xd2b9, 0xd2bc, 0xd2bf, 0xd2c0, 0xd2c2, 0xd2c8,
  0xd2c9, 0xd2cb, 0xd2d4, 0xd2d8, 0xd2dc, 0xd2e4, 0xd2e5, 0xd2f0,
  0xd2f1, 0xd2f4, 0xd2f8, 0xd300, 0xd301, 0xd303, 0xd305, 0xd30c,
  0xd30d, 0xd30e, 0xd310, 0xd314, 0xd316, 0xd31c, 0xd31d, 0xd31f,
  0xd320, 0xd321, 0xd325, 0xd328, 0xd329, 0xd32c, 0xd330, 0xd338,
  0xd339, 0xd33b, 0xd33c, 0xd33d, 0xd344, 0xd345, 0xd37c, 0xd37d,
  0xd380, 0xd384, 0xd38c, 0xd38d, 0xd38f, 0xd390, 0xd391, 0xd398,
  0xd399, 0xd39c, 0xd3a0, 0xd3a8, 0xd3a9, 0xd3ab, 0xd3ad, 0xd3b4,
  0xd3b8, 0xd3bc, 0xd3c4, 0xd3c5, 0xd3c8, 0xd3c9, 0xd3d0, 0xd3d8,
  0xd3e1, 0xd3e3, 0xd3ec, 0xd3ed, 0xd3f0, 0xd3f4, 0xd3fc, 0xd3fd,
  0xd3ff, 0xd401, 0xd408, 0xd41d, 0xd440, 0xd444, 0xd45c, 0xd460,
  0xd464, 0xd46d, 0xd46f, 0xd478, 0xd479, 0xd47c, 0xd47f, 0xd480,
  0xd482, 0xd488, 0xd489, 0xd48b, 0xd48d, 0xd494, 0xd4a9, 0xd4cc,
  0xd4d0, 0xd4d4, 0xd4dc, 0xd4df, 0xd4e8, 0xd4ec, 0xd4f0, 0xd4f8,
  0xd4fb, 0xd4fd, 0xd504, 0xd508, 0xd50c, 0xd514, 0xd515, 0xd517,
  0xd53c, 0xd53d, 0xd540, 0xd544, 0xd54c, 0xd54d, 0xd54f, 0xd551,
  0xd558, 0xd559, 0xd55c, 0xd560, 0xd565, 0xd568, 0xd569, 0xd56b,
  0xd56d, 0xd574, 0xd575, 0xd578, 0xd57c, 0xd584, 0xd585, 0xd587,
  0xd588, 0xd589, 0xd590, 0xd5a5, 0xd5c8, 0xd5c9, 0xd5cc, 0xd5d0,
  0xd5d2, 0xd5d8, 0xd5d9, 0xd5db, 0xd5dd, 0xd5e4, 0xd5e5, 0xd5e8,
  0xd5ec, 0xd5f4, 0xd5f5, 0xd5f7, 0xd5f9, 0xd600, 0xd601, 0xd604,
  0xd608, 0xd610, 0xd611, 0xd613, 0xd614, 0xd615, 0xd61c, 0xd620,
  0xd624, 0xd62d, 0xd638, 0xd639, 0xd63c, 0xd640, 0xd645, 0xd648,
  0xd649, 0xd64b, 0xd64d, 0xd651, 0xd654, 0xd655, 0xd658, 0xd65c,
  0xd667, 0xd669, 0xd670, 0xd671, 0xd674, 0xd683, 0xd685, 0xd68c,
  0xd68d, 0xd690, 0xd694, 0xd69d, 0xd69f, 0xd6a1, 0xd6a8, 0xd6ac,
  0xd6b0, 0xd6b9, 0xd6bb, 0xd6c4, 0xd6c5, 0xd6c8, 0xd6cc, 0xd6d1,
  0xd6d4, 0xd6d7, 0xd6d9, 0xd6e0, 0xd6e4, 0xd6e8, 0xd6f0, 0xd6f5,
  0xd6fc, 0xd6fd, 0xd700, 0xd704, 0xd711, 0xd718, 0xd719, 0xd71c,
  0xd720, 0xd728, 0xd729, 0xd72b, 0xd72d, 0xd734, 0xd735, 0xd738,
  0xd73c, 0xd744, 0xd747, 0xd749, 0xd750, 0xd751, 0xd754, 0xd756,
  0xd757, 0xd758, 0xd759, 0xd760, 0xd761, 0xd763, 0xd765, 0xd769,
  0xd76c, 0xd770, 0xd774, 0xd77c, 0xd77d, 0xd781, 0xd788, 0xd789,
  0xd78c, 0xd790, 0xd798, 0xd799, 0xd79b, 0xd79d
};

/*  Mapping table between symbols defined in KS C 5601-1992
    and UCS-4. It's used to convert symbols in  EUC-KR, ISO-2022-KR,
    Johab, UHC to UCS-4.

egrep '^0xA[1-C]' < /cdrom/unix/mappings/eastasia/ksc/ksc5601.txt | \
grep -v '# HANGUL SYLLABLE' | perl tab11.pl  > ksc_sym1.tb

   $n=0;
   while (<>) {
     local($ksc, $ucs4, %rest) = split;
     local($u)=hex($ucs4);
     local($k)=hex($ksc);
     printf ("\n ") if ($n % 4 eq 0);
     ++$n;
     printf (" [0x%04x] = 0x%04x,",
             int(($k - 0xa1a1) / 256) * 94 + (($k - 0xa1a1) & 0xff), $u);
   }
   printf ("\n");

*/

const uint16_t __ksc5601_sym_to_ucs[] =
{
  [0x0000] = 0x3000, [0x0001] = 0x3001, [0x0002] = 0x3002, [0x0003] = 0x00b7,
  [0x0004] = 0x2025, [0x0005] = 0x2026, [0x0006] = 0x00a8, [0x0007] = 0x3003,
  [0x0008] = 0x00ad, [0x0009] = 0x2015, [0x000a] = 0x2225, [0x000b] = 0xff3c,
  [0x000c] = 0x223c, [0x000d] = 0x2018, [0x000e] = 0x2019, [0x000f] = 0x201c,
  [0x0010] = 0x201d, [0x0011] = 0x3014, [0x0012] = 0x3015, [0x0013] = 0x3008,
  [0x0014] = 0x3009, [0x0015] = 0x300a, [0x0016] = 0x300b, [0x0017] = 0x300c,
  [0x0018] = 0x300d, [0x0019] = 0x300e, [0x001a] = 0x300f, [0x001b] = 0x3010,
  [0x001c] = 0x3011, [0x001d] = 0x00b1, [0x001e] = 0x00d7, [0x001f] = 0x00f7,
  [0x0020] = 0x2260, [0x0021] = 0x2264, [0x0022] = 0x2265, [0x0023] = 0x221e,
  [0x0024] = 0x2234, [0x0025] = 0x00b0, [0x0026] = 0x2032, [0x0027] = 0x2033,
  [0x0028] = 0x2103, [0x0029] = 0x212b, [0x002a] = 0xffe0, [0x002b] = 0xffe1,
  [0x002c] = 0xffe5, [0x002d] = 0x2642, [0x002e] = 0x2640, [0x002f] = 0x2220,
  [0x0030] = 0x22a5, [0x0031] = 0x2312, [0x0032] = 0x2202, [0x0033] = 0x2207,
  [0x0034] = 0x2261, [0x0035] = 0x2252, [0x0036] = 0x00a7, [0x0037] = 0x203b,
  [0x0038] = 0x2606, [0x0039] = 0x2605, [0x003a] = 0x25cb, [0x003b] = 0x25cf,
  [0x003c] = 0x25ce, [0x003d] = 0x25c7, [0x003e] = 0x25c6, [0x003f] = 0x25a1,
  [0x0040] = 0x25a0, [0x0041] = 0x25b3, [0x0042] = 0x25b2, [0x0043] = 0x25bd,
  [0x0044] = 0x25bc, [0x0045] = 0x2192, [0x0046] = 0x2190, [0x0047] = 0x2191,
  [0x0048] = 0x2193, [0x0049] = 0x2194, [0x004a] = 0x3013, [0x004b] = 0x226a,
  [0x004c] = 0x226b, [0x004d] = 0x221a, [0x004e] = 0x223d, [0x004f] = 0x221d,
  [0x0050] = 0x2235, [0x0051] = 0x222b, [0x0052] = 0x222c, [0x0053] = 0x2208,
  [0x0054] = 0x220b, [0x0055] = 0x2286, [0x0056] = 0x2287, [0x0057] = 0x2282,
  [0x0058] = 0x2283, [0x0059] = 0x222a, [0x005a] = 0x2229, [0x005b] = 0x2227,
  [0x005c] = 0x2228, [0x005d] = 0xffe2, [0x005e] = 0x21d2, [0x005f] = 0x21d4,
  [0x0060] = 0x2200, [0x0061] = 0x2203, [0x0062] = 0x00b4, [0x0063] = 0xff5e,
  [0x0064] = 0x02c7, [0x0065] = 0x02d8, [0x0066] = 0x02dd, [0x0067] = 0x02da,
  [0x0068] = 0x02d9, [0x0069] = 0x00b8, [0x006a] = 0x02db, [0x006b] = 0x00a1,
  [0x006c] = 0x00bf, [0x006d] = 0x02d0, [0x006e] = 0x222e, [0x006f] = 0x2211,
  [0x0070] = 0x220f, [0x0071] = 0x00a4, [0x0072] = 0x2109, [0x0073] = 0x2030,
  [0x0074] = 0x25c1, [0x0075] = 0x25c0, [0x0076] = 0x25b7, [0x0077] = 0x25b6,
  [0x0078] = 0x2664, [0x0079] = 0x2660, [0x007a] = 0x2661, [0x007b] = 0x2665,
  [0x007c] = 0x2667, [0x007d] = 0x2663, [0x007e] = 0x2299, [0x007f] = 0x25c8,
  [0x0080] = 0x25a3, [0x0081] = 0x25d0, [0x0082] = 0x25d1, [0x0083] = 0x2592,
  [0x0084] = 0x25a4, [0x0085] = 0x25a5, [0x0086] = 0x25a8, [0x0087] = 0x25a7,
  [0x0088] = 0x25a6, [0x0089] = 0x25a9, [0x008a] = 0x2668, [0x008b] = 0x260f,
  [0x008c] = 0x260e, [0x008d] = 0x261c, [0x008e] = 0x261e, [0x008f] = 0x00b6,
  [0x0090] = 0x2020, [0x0091] = 0x2021, [0x0092] = 0x2195, [0x0093] = 0x2197,
  [0x0094] = 0x2199, [0x0095] = 0x2196, [0x0096] = 0x2198, [0x0097] = 0x266d,
  [0x0098] = 0x2669, [0x0099] = 0x266a, [0x009a] = 0x266c, [0x009b] = 0x327f,
  [0x009c] = 0x321c, [0x009d] = 0x2116, [0x009e] = 0x33c7, [0x009f] = 0x2122,
  [0x00a0] = 0x33c2, [0x00a1] = 0x33d8, [0x00a2] = 0x2121, [0x00a3] = 0x20ac,
  [0x00a4] = 0x00ae, [0x00bc] = 0xff01, [0x00bd] = 0xff02, [0x00be] = 0xff03,
  [0x00bf] = 0xff04, [0x00c0] = 0xff05, [0x00c1] = 0xff06, [0x00c2] = 0xff07,
  [0x00c3] = 0xff08, [0x00c4] = 0xff09, [0x00c5] = 0xff0a, [0x00c6] = 0xff0b,
  [0x00c7] = 0xff0c, [0x00c8] = 0xff0d, [0x00c9] = 0xff0e, [0x00ca] = 0xff0f,
  [0x00cb] = 0xff10, [0x00cc] = 0xff11, [0x00cd] = 0xff12, [0x00ce] = 0xff13,
  [0x00cf] = 0xff14, [0x00d0] = 0xff15, [0x00d1] = 0xff16, [0x00d2] = 0xff17,
  [0x00d3] = 0xff18, [0x00d4] = 0xff19, [0x00d5] = 0xff1a, [0x00d6] = 0xff1b,
  [0x00d7] = 0xff1c, [0x00d8] = 0xff1d, [0x00d9] = 0xff1e, [0x00da] = 0xff1f,
  [0x00db] = 0xff20, [0x00dc] = 0xff21, [0x00dd] = 0xff22, [0x00de] = 0xff23,
  [0x00df] = 0xff24, [0x00e0] = 0xff25, [0x00e1] = 0xff26, [0x00e2] = 0xff27,
  [0x00e3] = 0xff28, [0x00e4] = 0xff29, [0x00e5] = 0xff2a, [0x00e6] = 0xff2b,
  [0x00e7] = 0xff2c, [0x00e8] = 0xff2d, [0x00e9] = 0xff2e, [0x00ea] = 0xff2f,
  [0x00eb] = 0xff30, [0x00ec] = 0xff31, [0x00ed] = 0xff32, [0x00ee] = 0xff33,
  [0x00ef] = 0xff34, [0x00f0] = 0xff35, [0x00f1] = 0xff36, [0x00f2] = 0xff37,
  [0x00f3] = 0xff38, [0x00f4] = 0xff39, [0x00f5] = 0xff3a, [0x00f6] = 0xff3b,
  [0x00f7] = 0xffe6, [0x00f8] = 0xff3d, [0x00f9] = 0xff3e, [0x00fa] = 0xff3f,
  [0x00fb] = 0xff40, [0x00fc] = 0xff41, [0x00fd] = 0xff42, [0x00fe] = 0xff43,
  [0x00ff] = 0xff44, [0x0100] = 0xff45, [0x0101] = 0xff46, [0x0102] = 0xff47,
  [0x0103] = 0xff48, [0x0104] = 0xff49, [0x0105] = 0xff4a, [0x0106] = 0xff4b,
  [0x0107] = 0xff4c, [0x0108] = 0xff4d, [0x0109] = 0xff4e, [0x010a] = 0xff4f,
  [0x010b] = 0xff50, [0x010c] = 0xff51, [0x010d] = 0xff52, [0x010e] = 0xff53,
  [0x010f] = 0xff54, [0x0110] = 0xff55, [0x0111] = 0xff56, [0x0112] = 0xff57,
  [0x0113] = 0xff58, [0x0114] = 0xff59, [0x0115] = 0xff5a, [0x0116] = 0xff5b,
  [0x0117] = 0xff5c, [0x0118] = 0xff5d, [0x0119] = 0xffe3, [0x011a] = 0x3131,
  [0x011b] = 0x3132, [0x011c] = 0x3133, [0x011d] = 0x3134, [0x011e] = 0x3135,
  [0x011f] = 0x3136, [0x0120] = 0x3137, [0x0121] = 0x3138, [0x0122] = 0x3139,
  [0x0123] = 0x313a, [0x0124] = 0x313b, [0x0125] = 0x313c, [0x0126] = 0x313d,
  [0x0127] = 0x313e, [0x0128] = 0x313f, [0x0129] = 0x3140, [0x012a] = 0x3141,
  [0x012b] = 0x3142, [0x012c] = 0x3143, [0x012d] = 0x3144, [0x012e] = 0x3145,
  [0x012f] = 0x3146, [0x0130] = 0x3147, [0x0131] = 0x3148, [0x0132] = 0x3149,
  [0x0133] = 0x314a, [0x0134] = 0x314b, [0x0135] = 0x314c, [0x0136] = 0x314d,
  [0x0137] = 0x314e, [0x0138] = 0x314f, [0x0139] = 0x3150, [0x013a] = 0x3151,
  [0x013b] = 0x3152, [0x013c] = 0x3153, [0x013d] = 0x3154, [0x013e] = 0x3155,
  [0x013f] = 0x3156, [0x0140] = 0x3157, [0x0141] = 0x3158, [0x0142] = 0x3159,
  [0x0143] = 0x315a, [0x0144] = 0x315b, [0x0145] = 0x315c, [0x0146] = 0x315d,
  [0x0147] = 0x315e, [0x0148] = 0x315f, [0x0149] = 0x3160, [0x014a] = 0x3161,
  [0x014b] = 0x3162, [0x014c] = 0x3163, [0x014d] = 0x3164, [0x014e] = 0x3165,
  [0x014f] = 0x3166, [0x0150] = 0x3167, [0x0151] = 0x3168, [0x0152] = 0x3169,
  [0x0153] = 0x316a, [0x0154] = 0x316b, [0x0155] = 0x316c, [0x0156] = 0x316d,
  [0x0157] = 0x316e, [0x0158] = 0x316f, [0x0159] = 0x3170, [0x015a] = 0x3171,
  [0x015b] = 0x3172, [0x015c] = 0x3173, [0x015d] = 0x3174, [0x015e] = 0x3175,
  [0x015f] = 0x3176, [0x0160] = 0x3177, [0x0161] = 0x3178, [0x0162] = 0x3179,
  [0x0163] = 0x317a, [0x0164] = 0x317b, [0x0165] = 0x317c, [0x0166] = 0x317d,
  [0x0167] = 0x317e, [0x0168] = 0x317f, [0x0169] = 0x3180, [0x016a] = 0x3181,
  [0x016b] = 0x3182, [0x016c] = 0x3183, [0x016d] = 0x3184, [0x016e] = 0x3185,
  [0x016f] = 0x3186, [0x0170] = 0x3187, [0x0171] = 0x3188, [0x0172] = 0x3189,
  [0x0173] = 0x318a, [0x0174] = 0x318b, [0x0175] = 0x318c, [0x0176] = 0x318d,
  [0x0177] = 0x318e, [0x0178] = 0x2170, [0x0179] = 0x2171, [0x017a] = 0x2172,
  [0x017b] = 0x2173, [0x017c] = 0x2174, [0x017d] = 0x2175, [0x017e] = 0x2176,
  [0x017f] = 0x2177, [0x0180] = 0x2178, [0x0181] = 0x2179, [0x0187] = 0x2160,
  [0x0188] = 0x2161, [0x0189] = 0x2162, [0x018a] = 0x2163, [0x018b] = 0x2164,
  [0x018c] = 0x2165, [0x018d] = 0x2166, [0x018e] = 0x2167, [0x018f] = 0x2168,
  [0x0190] = 0x2169, [0x0198] = 0x0391, [0x0199] = 0x0392, [0x019a] = 0x0393,
  [0x019b] = 0x0394, [0x019c] = 0x0395, [0x019d] = 0x0396, [0x019e] = 0x0397,
  [0x019f] = 0x0398, [0x01a0] = 0x0399, [0x01a1] = 0x039a, [0x01a2] = 0x039b,
  [0x01a3] = 0x039c, [0x01a4] = 0x039d, [0x01a5] = 0x039e, [0x01a6] = 0x039f,
  [0x01a7] = 0x03a0, [0x01a8] = 0x03a1, [0x01a9] = 0x03a3, [0x01aa] = 0x03a4,
  [0x01ab] = 0x03a5, [0x01ac] = 0x03a6, [0x01ad] = 0x03a7, [0x01ae] = 0x03a8,
  [0x01af] = 0x03a9, [0x01b8] = 0x03b1, [0x01b9] = 0x03b2, [0x01ba] = 0x03b3,
  [0x01bb] = 0x03b4, [0x01bc] = 0x03b5, [0x01bd] = 0x03b6, [0x01be] = 0x03b7,
  [0x01bf] = 0x03b8, [0x01c0] = 0x03b9, [0x01c1] = 0x03ba, [0x01c2] = 0x03bb,
  [0x01c3] = 0x03bc, [0x01c4] = 0x03bd, [0x01c5] = 0x03be, [0x01c6] = 0x03bf,
  [0x01c7] = 0x03c0, [0x01c8] = 0x03c1, [0x01c9] = 0x03c3, [0x01ca] = 0x03c4,
  [0x01cb] = 0x03c5, [0x01cc] = 0x03c6, [0x01cd] = 0x03c7, [0x01ce] = 0x03c8,
  [0x01cf] = 0x03c9, [0x01d6] = 0x2500, [0x01d7] = 0x2502, [0x01d8] = 0x250c,
  [0x01d9] = 0x2510, [0x01da] = 0x2518, [0x01db] = 0x2514, [0x01dc] = 0x251c,
  [0x01dd] = 0x252c, [0x01de] = 0x2524, [0x01df] = 0x2534, [0x01e0] = 0x253c,
  [0x01e1] = 0x2501, [0x01e2] = 0x2503, [0x01e3] = 0x250f, [0x01e4] = 0x2513,
  [0x01e5] = 0x251b, [0x01e6] = 0x2517, [0x01e7] = 0x2523, [0x01e8] = 0x2533,
  [0x01e9] = 0x252b, [0x01ea] = 0x253b, [0x01eb] = 0x254b, [0x01ec] = 0x2520,
  [0x01ed] = 0x252f, [0x01ee] = 0x2528, [0x01ef] = 0x2537, [0x01f0] = 0x253f,
  [0x01f1] = 0x251d, [0x01f2] = 0x2530, [0x01f3] = 0x2525, [0x01f4] = 0x2538,
  [0x01f5] = 0x2542, [0x01f6] = 0x2512, [0x01f7] = 0x2511, [0x01f8] = 0x251a,
  [0x01f9] = 0x2519, [0x01fa] = 0x2516, [0x01fb] = 0x2515, [0x01fc] = 0x250e,
  [0x01fd] = 0x250d, [0x01fe] = 0x251e, [0x01ff] = 0x251f, [0x0200] = 0x2521,
  [0x0201] = 0x2522, [0x0202] = 0x2526, [0x0203] = 0x2527, [0x0204] = 0x2529,
  [0x0205] = 0x252a, [0x0206] = 0x252d, [0x0207] = 0x252e, [0x0208] = 0x2531,
  [0x0209] = 0x2532, [0x020a] = 0x2535, [0x020b] = 0x2536, [0x020c] = 0x2539,
  [0x020d] = 0x253a, [0x020e] = 0x253d, [0x020f] = 0x253e, [0x0210] = 0x2540,
  [0x0211] = 0x2541, [0x0212] = 0x2543, [0x0213] = 0x2544, [0x0214] = 0x2545,
  [0x0215] = 0x2546, [0x0216] = 0x2547, [0x0217] = 0x2548, [0x0218] = 0x2549,
  [0x0219] = 0x254a, [0x0234] = 0x3395, [0x0235] = 0x3396, [0x0236] = 0x3397,
  [0x0237] = 0x2113, [0x0238] = 0x3398, [0x0239] = 0x33c4, [0x023a] = 0x33a3,
  [0x023b] = 0x33a4, [0x023c] = 0x33a5, [0x023d] = 0x33a6, [0x023e] = 0x3399,
  [0x023f] = 0x339a, [0x0240] = 0x339b, [0x0241] = 0x339c, [0x0242] = 0x339d,
  [0x0243] = 0x339e, [0x0244] = 0x339f, [0x0245] = 0x33a0, [0x0246] = 0x33a1,
  [0x0247] = 0x33a2, [0x0248] = 0x33ca, [0x0249] = 0x338d, [0x024a] = 0x338e,
  [0x024b] = 0x338f, [0x024c] = 0x33cf, [0x024d] = 0x3388, [0x024e] = 0x3389,
  [0x024f] = 0x33c8, [0x0250] = 0x33a7, [0x0251] = 0x33a8, [0x0252] = 0x33b0,
  [0x0253] = 0x33b1, [0x0254] = 0x33b2, [0x0255] = 0x33b3, [0x0256] = 0x33b4,
  [0x0257] = 0x33b5, [0x0258] = 0x33b6, [0x0259] = 0x33b7, [0x025a] = 0x33b8,
  [0x025b] = 0x33b9, [0x025c] = 0x3380, [0x025d] = 0x3381, [0x025e] = 0x3382,
  [0x025f] = 0x3383, [0x0260] = 0x3384, [0x0261] = 0x33ba, [0x0262] = 0x33bb,
  [0x0263] = 0x33bc, [0x0264] = 0x33bd, [0x0265] = 0x33be, [0x0266] = 0x33bf,
  [0x0267] = 0x3390, [0x0268] = 0x3391, [0x0269] = 0x3392, [0x026a] = 0x3393,
  [0x026b] = 0x3394, [0x026c] = 0x2126, [0x026d] = 0x33c0, [0x026e] = 0x33c1,
  [0x026f] = 0x338a, [0x0270] = 0x338b, [0x0271] = 0x338c, [0x0272] = 0x33d6,
  [0x0273] = 0x33c5, [0x0274] = 0x33ad, [0x0275] = 0x33ae, [0x0276] = 0x33af,
  [0x0277] = 0x33db, [0x0278] = 0x33a9, [0x0279] = 0x33aa, [0x027a] = 0x33ab,
  [0x027b] = 0x33ac, [0x027c] = 0x33dd, [0x027d] = 0x33d0, [0x027e] = 0x33d3,
  [0x027f] = 0x33c3, [0x0280] = 0x33c9, [0x0281] = 0x33dc, [0x0282] = 0x33c6,
  [0x0292] = 0x00c6, [0x0293] = 0x00d0, [0x0294] = 0x00aa, [0x0295] = 0x0126,
  [0x0297] = 0x0132, [0x0299] = 0x013f, [0x029a] = 0x0141, [0x029b] = 0x00d8,
  [0x029c] = 0x0152, [0x029d] = 0x00ba, [0x029e] = 0x00de, [0x029f] = 0x0166,
  [0x02a0] = 0x014a, [0x02a2] = 0x3260, [0x02a3] = 0x3261, [0x02a4] = 0x3262,
  [0x02a5] = 0x3263, [0x02a6] = 0x3264, [0x02a7] = 0x3265, [0x02a8] = 0x3266,
  [0x02a9] = 0x3267, [0x02aa] = 0x3268, [0x02ab] = 0x3269, [0x02ac] = 0x326a,
  [0x02ad] = 0x326b, [0x02ae] = 0x326c, [0x02af] = 0x326d, [0x02b0] = 0x326e,
  [0x02b1] = 0x326f, [0x02b2] = 0x3270, [0x02b3] = 0x3271, [0x02b4] = 0x3272,
  [0x02b5] = 0x3273, [0x02b6] = 0x3274, [0x02b7] = 0x3275, [0x02b8] = 0x3276,
  [0x02b9] = 0x3277, [0x02ba] = 0x3278, [0x02bb] = 0x3279, [0x02bc] = 0x327a,
  [0x02bd] = 0x327b, [0x02be] = 0x24d0, [0x02bf] = 0x24d1, [0x02c0] = 0x24d2,
  [0x02c1] = 0x24d3, [0x02c2] = 0x24d4, [0x02c3] = 0x24d5, [0x02c4] = 0x24d6,
  [0x02c5] = 0x24d7, [0x02c6] = 0x24d8, [0x02c7] = 0x24d9, [0x02c8] = 0x24da,
  [0x02c9] = 0x24db, [0x02ca] = 0x24dc, [0x02cb] = 0x24dd, [0x02cc] = 0x24de,
  [0x02cd] = 0x24df, [0x02ce] = 0x24e0, [0x02cf] = 0x24e1, [0x02d0] = 0x24e2,
  [0x02d1] = 0x24e3, [0x02d2] = 0x24e4, [0x02d3] = 0x24e5, [0x02d4] = 0x24e6,
  [0x02d5] = 0x24e7, [0x02d6] = 0x24e8, [0x02d7] = 0x24e9, [0x02d8] = 0x2460,
  [0x02d9] = 0x2461, [0x02da] = 0x2462, [0x02db] = 0x2463, [0x02dc] = 0x2464,
  [0x02dd] = 0x2465, [0x02de] = 0x2466, [0x02df] = 0x2467, [0x02e0] = 0x2468,
  [0x02e1] = 0x2469, [0x02e2] = 0x246a, [0x02e3] = 0x246b, [0x02e4] = 0x246c,
  [0x02e5] = 0x246d, [0x02e6] = 0x246e, [0x02e7] = 0x00bd, [0x02e8] = 0x2153,
  [0x02e9] = 0x2154, [0x02ea] = 0x00bc, [0x02eb] = 0x00be, [0x02ec] = 0x215b,
  [0x02ed] = 0x215c, [0x02ee] = 0x215d, [0x02ef] = 0x215e, [0x02f0] = 0x00e6,
  [0x02f1] = 0x0111, [0x02f2] = 0x00f0, [0x02f3] = 0x0127, [0x02f4] = 0x0131,
  [0x02f5] = 0x0133, [0x02f6] = 0x0138, [0x02f7] = 0x0140, [0x02f8] = 0x0142,
  [0x02f9] = 0x00f8, [0x02fa] = 0x0153, [0x02fb] = 0x00df, [0x02fc] = 0x00fe,
  [0x02fd] = 0x0167, [0x02fe] = 0x014b, [0x02ff] = 0x0149, [0x0300] = 0x3200,
  [0x0301] = 0x3201, [0x0302] = 0x3202, [0x0303] = 0x3203, [0x0304] = 0x3204,
  [0x0305] = 0x3205, [0x0306] = 0x3206, [0x0307] = 0x3207, [0x0308] = 0x3208,
  [0x0309] = 0x3209, [0x030a] = 0x320a, [0x030b] = 0x320b, [0x030c] = 0x320c,
  [0x030d] = 0x320d, [0x030e] = 0x320e, [0x030f] = 0x320f, [0x0310] = 0x3210,
  [0x0311] = 0x3211, [0x0312] = 0x3212, [0x0313] = 0x3213, [0x0314] = 0x3214,
  [0x0315] = 0x3215, [0x0316] = 0x3216, [0x0317] = 0x3217, [0x0318] = 0x3218,
  [0x0319] = 0x3219, [0x031a] = 0x321a, [0x031b] = 0x321b, [0x031c] = 0x249c,
  [0x031d] = 0x249d, [0x031e] = 0x249e, [0x031f] = 0x249f, [0x0320] = 0x24a0,
  [0x0321] = 0x24a1, [0x0322] = 0x24a2, [0x0323] = 0x24a3, [0x0324] = 0x24a4,
  [0x0325] = 0x24a5, [0x0326] = 0x24a6, [0x0327] = 0x24a7, [0x0328] = 0x24a8,
  [0x0329] = 0x24a9, [0x032a] = 0x24aa, [0x032b] = 0x24ab, [0x032c] = 0x24ac,
  [0x032d] = 0x24ad, [0x032e] = 0x24ae, [0x032f] = 0x24af, [0x0330] = 0x24b0,
  [0x0331] = 0x24b1, [0x0332] = 0x24b2, [0x0333] = 0x24b3, [0x0334] = 0x24b4,
  [0x0335] = 0x24b5, [0x0336] = 0x2474, [0x0337] = 0x2475, [0x0338] = 0x2476,
  [0x0339] = 0x2477, [0x033a] = 0x2478, [0x033b] = 0x2479, [0x033c] = 0x247a,
  [0x033d] = 0x247b, [0x033e] = 0x247c, [0x033f] = 0x247d, [0x0340] = 0x247e,
  [0x0341] = 0x247f, [0x0342] = 0x2480, [0x0343] = 0x2481, [0x0344] = 0x2482,
  [0x0345] = 0x00b9, [0x0346] = 0x00b2, [0x0347] = 0x00b3, [0x0348] = 0x2074,
  [0x0349] = 0x207f, [0x034a] = 0x2081, [0x034b] = 0x2082, [0x034c] = 0x2083,
  [0x034d] = 0x2084, [0x034e] = 0x3041, [0x034f] = 0x3042, [0x0350] = 0x3043,
  [0x0351] = 0x3044, [0x0352] = 0x3045, [0x0353] = 0x3046, [0x0354] = 0x3047,
  [0x0355] = 0x3048, [0x0356] = 0x3049, [0x0357] = 0x304a, [0x0358] = 0x304b,
  [0x0359] = 0x304c, [0x035a] = 0x304d, [0x035b] = 0x304e, [0x035c] = 0x304f,
  [0x035d] = 0x3050, [0x035e] = 0x3051, [0x035f] = 0x3052, [0x0360] = 0x3053,
  [0x0361] = 0x3054, [0x0362] = 0x3055, [0x0363] = 0x3056, [0x0364] = 0x3057,
  [0x0365] = 0x3058, [0x0366] = 0x3059, [0x0367] = 0x305a, [0x0368] = 0x305b,
  [0x0369] = 0x305c, [0x036a] = 0x305d, [0x036b] = 0x305e, [0x036c] = 0x305f,
  [0x036d] = 0x3060, [0x036e] = 0x3061, [0x036f] = 0x3062, [0x0370] = 0x3063,
  [0x0371] = 0x3064, [0x0372] = 0x3065, [0x0373] = 0x3066, [0x0374] = 0x3067,
  [0x0375] = 0x3068, [0x0376] = 0x3069, [0x0377] = 0x306a, [0x0378] = 0x306b,
  [0x0379] = 0x306c, [0x037a] = 0x306d, [0x037b] = 0x306e, [0x037c] = 0x306f,
  [0x037d] = 0x3070, [0x037e] = 0x3071, [0x037f] = 0x3072, [0x0380] = 0x3073,
  [0x0381] = 0x3074, [0x0382] = 0x3075, [0x0383] = 0x3076, [0x0384] = 0x3077,
  [0x0385] = 0x3078, [0x0386] = 0x3079, [0x0387] = 0x307a, [0x0388] = 0x307b,
  [0x0389] = 0x307c, [0x038a] = 0x307d, [0x038b] = 0x307e, [0x038c] = 0x307f,
  [0x038d] = 0x3080, [0x038e] = 0x3081, [0x038f] = 0x3082, [0x0390] = 0x3083,
  [0x0391] = 0x3084, [0x0392] = 0x3085, [0x0393] = 0x3086, [0x0394] = 0x3087,
  [0x0395] = 0x3088, [0x0396] = 0x3089, [0x0397] = 0x308a, [0x0398] = 0x308b,
  [0x0399] = 0x308c, [0x039a] = 0x308d, [0x039b] = 0x308e, [0x039c] = 0x308f,
  [0x039d] = 0x3090, [0x039e] = 0x3091, [0x039f] = 0x3092, [0x03a0] = 0x3093,
  [0x03ac] = 0x30a1, [0x03ad] = 0x30a2, [0x03ae] = 0x30a3, [0x03af] = 0x30a4,
  [0x03b0] = 0x30a5, [0x03b1] = 0x30a6, [0x03b2] = 0x30a7, [0x03b3] = 0x30a8,
  [0x03b4] = 0x30a9, [0x03b5] = 0x30aa, [0x03b6] = 0x30ab, [0x03b7] = 0x30ac,
  [0x03b8] = 0x30ad, [0x03b9] = 0x30ae, [0x03ba] = 0x30af, [0x03bb] = 0x30b0,
  [0x03bc] = 0x30b1, [0x03bd] = 0x30b2, [0x03be] = 0x30b3, [0x03bf] = 0x30b4,
  [0x03c0] = 0x30b5, [0x03c1] = 0x30b6, [0x03c2] = 0x30b7, [0x03c3] = 0x30b8,
  [0x03c4] = 0x30b9, [0x03c5] = 0x30ba, [0x03c6] = 0x30bb, [0x03c7] = 0x30bc,
  [0x03c8] = 0x30bd, [0x03c9] = 0x30be, [0x03ca] = 0x30bf, [0x03cb] = 0x30c0,
  [0x03cc] = 0x30c1, [0x03cd] = 0x30c2, [0x03ce] = 0x30c3, [0x03cf] = 0x30c4,
  [0x03d0] = 0x30c5, [0x03d1] = 0x30c6, [0x03d2] = 0x30c7, [0x03d3] = 0x30c8,
  [0x03d4] = 0x30c9, [0x03d5] = 0x30ca, [0x03d6] = 0x30cb, [0x03d7] = 0x30cc,
  [0x03d8] = 0x30cd, [0x03d9] = 0x30ce, [0x03da] = 0x30cf, [0x03db] = 0x30d0,
  [0x03dc] = 0x30d1, [0x03dd] = 0x30d2, [0x03de] = 0x30d3, [0x03df] = 0x30d4,
  [0x03e0] = 0x30d5, [0x03e1] = 0x30d6, [0x03e2] = 0x30d7, [0x03e3] = 0x30d8,
  [0x03e4] = 0x30d9, [0x03e5] = 0x30da, [0x03e6] = 0x30db, [0x03e7] = 0x30dc,
  [0x03e8] = 0x30dd, [0x03e9] = 0x30de, [0x03ea] = 0x30df, [0x03eb] = 0x30e0,
  [0x03ec] = 0x30e1, [0x03ed] = 0x30e2, [0x03ee] = 0x30e3, [0x03ef] = 0x30e4,
  [0x03f0] = 0x30e5, [0x03f1] = 0x30e6, [0x03f2] = 0x30e7, [0x03f3] = 0x30e8,
  [0x03f4] = 0x30e9, [0x03f5] = 0x30ea, [0x03f6] = 0x30eb, [0x03f7] = 0x30ec,
  [0x03f8] = 0x30ed, [0x03f9] = 0x30ee, [0x03fa] = 0x30ef, [0x03fb] = 0x30f0,
  [0x03fc] = 0x30f1, [0x03fd] = 0x30f2, [0x03fe] = 0x30f3, [0x03ff] = 0x30f4,
  [0x0400] = 0x30f5, [0x0401] = 0x30f6, [0x040a] = 0x0410, [0x040b] = 0x0411,
  [0x040c] = 0x0412, [0x040d] = 0x0413, [0x040e] = 0x0414, [0x040f] = 0x0415,
  [0x0410] = 0x0401, [0x0411] = 0x0416, [0x0412] = 0x0417, [0x0413] = 0x0418,
  [0x0414] = 0x0419, [0x0415] = 0x041a, [0x0416] = 0x041b, [0x0417] = 0x041c,
  [0x0418] = 0x041d, [0x0419] = 0x041e, [0x041a] = 0x041f, [0x041b] = 0x0420,
  [0x041c] = 0x0421, [0x041d] = 0x0422, [0x041e] = 0x0423, [0x041f] = 0x0424,
  [0x0420] = 0x0425, [0x0421] = 0x0426, [0x0422] = 0x0427, [0x0423] = 0x0428,
  [0x0424] = 0x0429, [0x0425] = 0x042a, [0x0426] = 0x042b, [0x0427] = 0x042c,
  [0x0428] = 0x042d, [0x0429] = 0x042e, [0x042a] = 0x042f, [0x043a] = 0x0430,
  [0x043b] = 0x0431, [0x043c] = 0x0432, [0x043d] = 0x0433, [0x043e] = 0x0434,
  [0x043f] = 0x0435, [0x0440] = 0x0451, [0x0441] = 0x0436, [0x0442] = 0x0437,
  [0x0443] = 0x0438, [0x0444] = 0x0439, [0x0445] = 0x043a, [0x0446] = 0x043b,
  [0x0447] = 0x043c, [0x0448] = 0x043d, [0x0449] = 0x043e, [0x044a] = 0x043f,
  [0x044b] = 0x0440, [0x044c] = 0x0441, [0x044d] = 0x0442, [0x044e] = 0x0443,
  [0x044f] = 0x0444, [0x0450] = 0x0445, [0x0451] = 0x0446, [0x0452] = 0x0447,
  [0x0453] = 0x0448, [0x0454] = 0x0449, [0x0455] = 0x044a, [0x0456] = 0x044b,
  [0x0457] = 0x044c, [0x0458] = 0x044d, [0x0459] = 0x044e, [0x045a] = 0x044f
};


/*

 Mapping table from UCS4 to symbols defined in KS C 5601-1987.

egrep '^0xA[1-C]' /cdrom/unix/mappings/eastasia/ksc/ksc5601.txt | \
grep -v '# HANGUL SYLLABLE' | awk '{print $2, $1}' | sort -u |
perl tab12.pl > ksc_sym2.tb

   $n=0;
   print " ";
   while (<>) {
     local($ucs4, $ksc, %rest) = split;
     local($u)=hex($ucs4);
     local($k)=hex($ksc);
     local($ku)=int(($k - 0xa1a1) / 256) * 94 + (($k - 0xa1a1) & 0xff);
     local($h)=0x21+int($ku/0x5e);
     local($l)=0x21+int($ku%0x5e);
     $n++;
     printf (" {0x%04x, \"\\x%x\\x%x\"},", $u, $h, $l);
     print "\n " if $n %3 == 0;
   }
   print "\n";

*/

const struct map __ksc5601_sym_from_ucs[KSC5601_SYMBOL] =
{
  {0x00a1, "\x22\x2e"}, {0x00a4, "\x22\x34"}, {0x00a7, "\x21\x57"},
  {0x00a8, "\x21\x27"}, {0x00aa, "\x28\x23"}, {0x00ad, "\x21\x29"},
  {0x00ae, "\x22\x67"}, {0x00b0, "\x21\x46"}, {0x00b1, "\x21\x3e"},
  {0x00b2, "\x29\x77"}, {0x00b3, "\x29\x78"}, {0x00b4, "\x22\x25"},
  {0x00b6, "\x22\x52"}, {0x00b7, "\x21\x24"}, {0x00b8, "\x22\x2c"},
  {0x00b9, "\x29\x76"}, {0x00ba, "\x28\x2c"}, {0x00bc, "\x28\x79"},
  {0x00bd, "\x28\x76"}, {0x00be, "\x28\x7a"}, {0x00bf, "\x22\x2f"},
  {0x00c6, "\x28\x21"}, {0x00d0, "\x28\x22"}, {0x00d7, "\x21\x3f"},
  {0x00d8, "\x28\x2a"}, {0x00de, "\x28\x2d"}, {0x00df, "\x29\x2c"},
  {0x00e6, "\x29\x21"}, {0x00f0, "\x29\x23"}, {0x00f7, "\x21\x40"},
  {0x00f8, "\x29\x2a"}, {0x00fe, "\x29\x2d"}, {0x0111, "\x29\x22"},
  {0x0126, "\x28\x24"}, {0x0127, "\x29\x24"}, {0x0131, "\x29\x25"},
  {0x0132, "\x28\x26"}, {0x0133, "\x29\x26"}, {0x0138, "\x29\x27"},
  {0x013f, "\x28\x28"}, {0x0140, "\x29\x28"}, {0x0141, "\x28\x29"},
  {0x0142, "\x29\x29"}, {0x0149, "\x29\x30"}, {0x014a, "\x28\x2f"},
  {0x014b, "\x29\x2f"}, {0x0152, "\x28\x2b"}, {0x0153, "\x29\x2b"},
  {0x0166, "\x28\x2e"}, {0x0167, "\x29\x2e"}, {0x02c7, "\x22\x27"},
  {0x02d0, "\x22\x30"}, {0x02d8, "\x22\x28"}, {0x02d9, "\x22\x2b"},
  {0x02da, "\x22\x2a"}, {0x02db, "\x22\x2d"}, {0x02dd, "\x22\x29"},
  {0x0391, "\x25\x41"}, {0x0392, "\x25\x42"}, {0x0393, "\x25\x43"},
  {0x0394, "\x25\x44"}, {0x0395, "\x25\x45"}, {0x0396, "\x25\x46"},
  {0x0397, "\x25\x47"}, {0x0398, "\x25\x48"}, {0x0399, "\x25\x49"},
  {0x039a, "\x25\x4a"}, {0x039b, "\x25\x4b"}, {0x039c, "\x25\x4c"},
  {0x039d, "\x25\x4d"}, {0x039e, "\x25\x4e"}, {0x039f, "\x25\x4f"},
  {0x03a0, "\x25\x50"}, {0x03a1, "\x25\x51"}, {0x03a3, "\x25\x52"},
  {0x03a4, "\x25\x53"}, {0x03a5, "\x25\x54"}, {0x03a6, "\x25\x55"},
  {0x03a7, "\x25\x56"}, {0x03a8, "\x25\x57"}, {0x03a9, "\x25\x58"},
  {0x03b1, "\x25\x61"}, {0x03b2, "\x25\x62"}, {0x03b3, "\x25\x63"},
  {0x03b4, "\x25\x64"}, {0x03b5, "\x25\x65"}, {0x03b6, "\x25\x66"},
  {0x03b7, "\x25\x67"}, {0x03b8, "\x25\x68"}, {0x03b9, "\x25\x69"},
  {0x03ba, "\x25\x6a"}, {0x03bb, "\x25\x6b"}, {0x03bc, "\x25\x6c"},
  {0x03bd, "\x25\x6d"}, {0x03be, "\x25\x6e"}, {0x03bf, "\x25\x6f"},
  {0x03c0, "\x25\x70"}, {0x03c1, "\x25\x71"}, {0x03c3, "\x25\x72"},
  {0x03c4, "\x25\x73"}, {0x03c5, "\x25\x74"}, {0x03c6, "\x25\x75"},
  {0x03c7, "\x25\x76"}, {0x03c8, "\x25\x77"}, {0x03c9, "\x25\x78"},
  {0x0401, "\x2c\x27"}, {0x0410, "\x2c\x21"}, {0x0411, "\x2c\x22"},
  {0x0412, "\x2c\x23"}, {0x0413, "\x2c\x24"}, {0x0414, "\x2c\x25"},
  {0x0415, "\x2c\x26"}, {0x0416, "\x2c\x28"}, {0x0417, "\x2c\x29"},
  {0x0418, "\x2c\x2a"}, {0x0419, "\x2c\x2b"}, {0x041a, "\x2c\x2c"},
  {0x041b, "\x2c\x2d"}, {0x041c, "\x2c\x2e"}, {0x041d, "\x2c\x2f"},
  {0x041e, "\x2c\x30"}, {0x041f, "\x2c\x31"}, {0x0420, "\x2c\x32"},
  {0x0421, "\x2c\x33"}, {0x0422, "\x2c\x34"}, {0x0423, "\x2c\x35"},
  {0x0424, "\x2c\x36"}, {0x0425, "\x2c\x37"}, {0x0426, "\x2c\x38"},
  {0x0427, "\x2c\x39"}, {0x0428, "\x2c\x3a"}, {0x0429, "\x2c\x3b"},
  {0x042a, "\x2c\x3c"}, {0x042b, "\x2c\x3d"}, {0x042c, "\x2c\x3e"},
  {0x042d, "\x2c\x3f"}, {0x042e, "\x2c\x40"}, {0x042f, "\x2c\x41"},
  {0x0430, "\x2c\x51"}, {0x0431, "\x2c\x52"}, {0x0432, "\x2c\x53"},
  {0x0433, "\x2c\x54"}, {0x0434, "\x2c\x55"}, {0x0435, "\x2c\x56"},
  {0x0436, "\x2c\x58"}, {0x0437, "\x2c\x59"}, {0x0438, "\x2c\x5a"},
  {0x0439, "\x2c\x5b"}, {0x043a, "\x2c\x5c"}, {0x043b, "\x2c\x5d"},
  {0x043c, "\x2c\x5e"}, {0x043d, "\x2c\x5f"}, {0x043e, "\x2c\x60"},
  {0x043f, "\x2c\x61"}, {0x0440, "\x2c\x62"}, {0x0441, "\x2c\x63"},
  {0x0442, "\x2c\x64"}, {0x0443, "\x2c\x65"}, {0x0444, "\x2c\x66"},
  {0x0445, "\x2c\x67"}, {0x0446, "\x2c\x68"}, {0x0447, "\x2c\x69"},
  {0x0448, "\x2c\x6a"}, {0x0449, "\x2c\x6b"}, {0x044a, "\x2c\x6c"},
  {0x044b, "\x2c\x6d"}, {0x044c, "\x2c\x6e"}, {0x044d, "\x2c\x6f"},
  {0x044e, "\x2c\x70"}, {0x044f, "\x2c\x71"}, {0x0451, "\x2c\x57"},
  {0x2015, "\x21\x2a"}, {0x2018, "\x21\x2e"}, {0x2019, "\x21\x2f"},
  {0x201c, "\x21\x30"}, {0x201d, "\x21\x31"}, {0x2020, "\x22\x53"},
  {0x2021, "\x22\x54"}, {0x2025, "\x21\x25"}, {0x2026, "\x21\x26"},
  {0x2030, "\x22\x36"}, {0x2032, "\x21\x47"}, {0x2033, "\x21\x48"},
  {0x203b, "\x21\x58"}, {0x2074, "\x29\x79"}, {0x207f, "\x29\x7a"},
  {0x2081, "\x29\x7b"}, {0x2082, "\x29\x7c"}, {0x2083, "\x29\x7d"},
  {0x2084, "\x29\x7e"}, {0x20ac, "\x22\x66"}, {0x2103, "\x21\x49"},
  {0x2109, "\x22\x35"}, {0x2113, "\x27\x24"}, {0x2116, "\x22\x60"},
  {0x2121, "\x22\x65"}, {0x2122, "\x22\x62"}, {0x2126, "\x27\x59"},
  {0x212b, "\x21\x4a"}, {0x2153, "\x28\x77"}, {0x2154, "\x28\x78"},
  {0x215b, "\x28\x7b"}, {0x215c, "\x28\x7c"}, {0x215d, "\x28\x7d"},
  {0x215e, "\x28\x7e"}, {0x2160, "\x25\x30"}, {0x2161, "\x25\x31"},
  {0x2162, "\x25\x32"}, {0x2163, "\x25\x33"}, {0x2164, "\x25\x34"},
  {0x2165, "\x25\x35"}, {0x2166, "\x25\x36"}, {0x2167, "\x25\x37"},
  {0x2168, "\x25\x38"}, {0x2169, "\x25\x39"}, {0x2170, "\x25\x21"},
  {0x2171, "\x25\x22"}, {0x2172, "\x25\x23"}, {0x2173, "\x25\x24"},
  {0x2174, "\x25\x25"}, {0x2175, "\x25\x26"}, {0x2176, "\x25\x27"},
  {0x2177, "\x25\x28"}, {0x2178, "\x25\x29"}, {0x2179, "\x25\x2a"},
  {0x2190, "\x21\x67"}, {0x2191, "\x21\x68"}, {0x2192, "\x21\x66"},
  {0x2193, "\x21\x69"}, {0x2194, "\x21\x6a"}, {0x2195, "\x22\x55"},
  {0x2196, "\x22\x58"}, {0x2197, "\x22\x56"}, {0x2198, "\x22\x59"},
  {0x2199, "\x22\x57"}, {0x21d2, "\x22\x21"}, {0x21d4, "\x22\x22"},
  {0x2200, "\x22\x23"}, {0x2202, "\x21\x53"}, {0x2203, "\x22\x24"},
  {0x2207, "\x21\x54"}, {0x2208, "\x21\x74"}, {0x220b, "\x21\x75"},
  {0x220f, "\x22\x33"}, {0x2211, "\x22\x32"}, {0x221a, "\x21\x6e"},
  {0x221d, "\x21\x70"}, {0x221e, "\x21\x44"}, {0x2220, "\x21\x50"},
  {0x2225, "\x21\x2b"}, {0x2227, "\x21\x7c"}, {0x2228, "\x21\x7d"},
  {0x2229, "\x21\x7b"}, {0x222a, "\x21\x7a"}, {0x222b, "\x21\x72"},
  {0x222c, "\x21\x73"}, {0x222e, "\x22\x31"}, {0x2234, "\x21\x45"},
  {0x2235, "\x21\x71"}, {0x223c, "\x21\x2d"}, {0x223d, "\x21\x6f"},
  {0x2252, "\x21\x56"}, {0x2260, "\x21\x41"}, {0x2261, "\x21\x55"},
  {0x2264, "\x21\x42"}, {0x2265, "\x21\x43"}, {0x226a, "\x21\x6c"},
  {0x226b, "\x21\x6d"}, {0x2282, "\x21\x78"}, {0x2283, "\x21\x79"},
  {0x2286, "\x21\x76"}, {0x2287, "\x21\x77"}, {0x2299, "\x22\x41"},
  {0x22a5, "\x21\x51"}, {0x2312, "\x21\x52"}, {0x2460, "\x28\x67"},
  {0x2461, "\x28\x68"}, {0x2462, "\x28\x69"}, {0x2463, "\x28\x6a"},
  {0x2464, "\x28\x6b"}, {0x2465, "\x28\x6c"}, {0x2466, "\x28\x6d"},
  {0x2467, "\x28\x6e"}, {0x2468, "\x28\x6f"}, {0x2469, "\x28\x70"},
  {0x246a, "\x28\x71"}, {0x246b, "\x28\x72"}, {0x246c, "\x28\x73"},
  {0x246d, "\x28\x74"}, {0x246e, "\x28\x75"}, {0x2474, "\x29\x67"},
  {0x2475, "\x29\x68"}, {0x2476, "\x29\x69"}, {0x2477, "\x29\x6a"},
  {0x2478, "\x29\x6b"}, {0x2479, "\x29\x6c"}, {0x247a, "\x29\x6d"},
  {0x247b, "\x29\x6e"}, {0x247c, "\x29\x6f"}, {0x247d, "\x29\x70"},
  {0x247e, "\x29\x71"}, {0x247f, "\x29\x72"}, {0x2480, "\x29\x73"},
  {0x2481, "\x29\x74"}, {0x2482, "\x29\x75"}, {0x249c, "\x29\x4d"},
  {0x249d, "\x29\x4e"}, {0x249e, "\x29\x4f"}, {0x249f, "\x29\x50"},
  {0x24a0, "\x29\x51"}, {0x24a1, "\x29\x52"}, {0x24a2, "\x29\x53"},
  {0x24a3, "\x29\x54"}, {0x24a4, "\x29\x55"}, {0x24a5, "\x29\x56"},
  {0x24a6, "\x29\x57"}, {0x24a7, "\x29\x58"}, {0x24a8, "\x29\x59"},
  {0x24a9, "\x29\x5a"}, {0x24aa, "\x29\x5b"}, {0x24ab, "\x29\x5c"},
  {0x24ac, "\x29\x5d"}, {0x24ad, "\x29\x5e"}, {0x24ae, "\x29\x5f"},
  {0x24af, "\x29\x60"}, {0x24b0, "\x29\x61"}, {0x24b1, "\x29\x62"},
  {0x24b2, "\x29\x63"}, {0x24b3, "\x29\x64"}, {0x24b4, "\x29\x65"},
  {0x24b5, "\x29\x66"}, {0x24d0, "\x28\x4d"}, {0x24d1, "\x28\x4e"},
  {0x24d2, "\x28\x4f"}, {0x24d3, "\x28\x50"}, {0x24d4, "\x28\x51"},
  {0x24d5, "\x28\x52"}, {0x24d6, "\x28\x53"}, {0x24d7, "\x28\x54"},
  {0x24d8, "\x28\x55"}, {0x24d9, "\x28\x56"}, {0x24da, "\x28\x57"},
  {0x24db, "\x28\x58"}, {0x24dc, "\x28\x59"}, {0x24dd, "\x28\x5a"},
  {0x24de, "\x28\x5b"}, {0x24df, "\x28\x5c"}, {0x24e0, "\x28\x5d"},
  {0x24e1, "\x28\x5e"}, {0x24e2, "\x28\x5f"}, {0x24e3, "\x28\x60"},
  {0x24e4, "\x28\x61"}, {0x24e5, "\x28\x62"}, {0x24e6, "\x28\x63"},
  {0x24e7, "\x28\x64"}, {0x24e8, "\x28\x65"}, {0x24e9, "\x28\x66"},
  {0x2500, "\x26\x21"}, {0x2501, "\x26\x2c"}, {0x2502, "\x26\x22"},
  {0x2503, "\x26\x2d"}, {0x250c, "\x26\x23"}, {0x250d, "\x26\x48"},
  {0x250e, "\x26\x47"}, {0x250f, "\x26\x2e"}, {0x2510, "\x26\x24"},
  {0x2511, "\x26\x42"}, {0x2512, "\x26\x41"}, {0x2513, "\x26\x2f"},
  {0x2514, "\x26\x26"}, {0x2515, "\x26\x46"}, {0x2516, "\x26\x45"},
  {0x2517, "\x26\x31"}, {0x2518, "\x26\x25"}, {0x2519, "\x26\x44"},
  {0x251a, "\x26\x43"}, {0x251b, "\x26\x30"}, {0x251c, "\x26\x27"},
  {0x251d, "\x26\x3c"}, {0x251e, "\x26\x49"}, {0x251f, "\x26\x4a"},
  {0x2520, "\x26\x37"}, {0x2521, "\x26\x4b"}, {0x2522, "\x26\x4c"},
  {0x2523, "\x26\x32"}, {0x2524, "\x26\x29"}, {0x2525, "\x26\x3e"},
  {0x2526, "\x26\x4d"}, {0x2527, "\x26\x4e"}, {0x2528, "\x26\x39"},
  {0x2529, "\x26\x4f"}, {0x252a, "\x26\x50"}, {0x252b, "\x26\x34"},
  {0x252c, "\x26\x28"}, {0x252d, "\x26\x51"}, {0x252e, "\x26\x52"},
  {0x252f, "\x26\x38"}, {0x2530, "\x26\x3d"}, {0x2531, "\x26\x53"},
  {0x2532, "\x26\x54"}, {0x2533, "\x26\x33"}, {0x2534, "\x26\x2a"},
  {0x2535, "\x26\x55"}, {0x2536, "\x26\x56"}, {0x2537, "\x26\x3a"},
  {0x2538, "\x26\x3f"}, {0x2539, "\x26\x57"}, {0x253a, "\x26\x58"},
  {0x253b, "\x26\x35"}, {0x253c, "\x26\x2b"}, {0x253d, "\x26\x59"},
  {0x253e, "\x26\x5a"}, {0x253f, "\x26\x3b"}, {0x2540, "\x26\x5b"},
  {0x2541, "\x26\x5c"}, {0x2542, "\x26\x40"}, {0x2543, "\x26\x5d"},
  {0x2544, "\x26\x5e"}, {0x2545, "\x26\x5f"}, {0x2546, "\x26\x60"},
  {0x2547, "\x26\x61"}, {0x2548, "\x26\x62"}, {0x2549, "\x26\x63"},
  {0x254a, "\x26\x64"}, {0x254b, "\x26\x36"}, {0x2592, "\x22\x46"},
  {0x25a0, "\x21\x61"}, {0x25a1, "\x21\x60"}, {0x25a3, "\x22\x43"},
  {0x25a4, "\x22\x47"}, {0x25a5, "\x22\x48"}, {0x25a6, "\x22\x4b"},
  {0x25a7, "\x22\x4a"}, {0x25a8, "\x22\x49"}, {0x25a9, "\x22\x4c"},
  {0x25b2, "\x21\x63"}, {0x25b3, "\x21\x62"}, {0x25b6, "\x22\x3a"},
  {0x25b7, "\x22\x39"}, {0x25bc, "\x21\x65"}, {0x25bd, "\x21\x64"},
  {0x25c0, "\x22\x38"}, {0x25c1, "\x22\x37"}, {0x25c6, "\x21\x5f"},
  {0x25c7, "\x21\x5e"}, {0x25c8, "\x22\x42"}, {0x25cb, "\x21\x5b"},
  {0x25ce, "\x21\x5d"}, {0x25cf, "\x21\x5c"}, {0x25d0, "\x22\x44"},
  {0x25d1, "\x22\x45"}, {0x2605, "\x21\x5a"}, {0x2606, "\x21\x59"},
  {0x260e, "\x22\x4f"}, {0x260f, "\x22\x4e"}, {0x261c, "\x22\x50"},
  {0x261e, "\x22\x51"}, {0x2640, "\x21\x4f"}, {0x2642, "\x21\x4e"},
  {0x2660, "\x22\x3c"}, {0x2661, "\x22\x3d"}, {0x2663, "\x22\x40"},
  {0x2664, "\x22\x3b"}, {0x2665, "\x22\x3e"}, {0x2667, "\x22\x3f"},
  {0x2668, "\x22\x4d"}, {0x2669, "\x22\x5b"}, {0x266a, "\x22\x5c"},
  {0x266c, "\x22\x5d"}, {0x266d, "\x22\x5a"}, {0x3000, "\x21\x21"},
  {0x3001, "\x21\x22"}, {0x3002, "\x21\x23"}, {0x3003, "\x21\x28"},
  {0x3008, "\x21\x34"}, {0x3009, "\x21\x35"}, {0x300a, "\x21\x36"},
  {0x300b, "\x21\x37"}, {0x300c, "\x21\x38"}, {0x300d, "\x21\x39"},
  {0x300e, "\x21\x3a"}, {0x300f, "\x21\x3b"}, {0x3010, "\x21\x3c"},
  {0x3011, "\x21\x3d"}, {0x3013, "\x21\x6b"}, {0x3014, "\x21\x32"},
  {0x3015, "\x21\x33"}, {0x3041, "\x2a\x21"}, {0x3042, "\x2a\x22"},
  {0x3043, "\x2a\x23"}, {0x3044, "\x2a\x24"}, {0x3045, "\x2a\x25"},
  {0x3046, "\x2a\x26"}, {0x3047, "\x2a\x27"}, {0x3048, "\x2a\x28"},
  {0x3049, "\x2a\x29"}, {0x304a, "\x2a\x2a"}, {0x304b, "\x2a\x2b"},
  {0x304c, "\x2a\x2c"}, {0x304d, "\x2a\x2d"}, {0x304e, "\x2a\x2e"},
  {0x304f, "\x2a\x2f"}, {0x3050, "\x2a\x30"}, {0x3051, "\x2a\x31"},
  {0x3052, "\x2a\x32"}, {0x3053, "\x2a\x33"}, {0x3054, "\x2a\x34"},
  {0x3055, "\x2a\x35"}, {0x3056, "\x2a\x36"}, {0x3057, "\x2a\x37"},
  {0x3058, "\x2a\x38"}, {0x3059, "\x2a\x39"}, {0x305a, "\x2a\x3a"},
  {0x305b, "\x2a\x3b"}, {0x305c, "\x2a\x3c"}, {0x305d, "\x2a\x3d"},
  {0x305e, "\x2a\x3e"}, {0x305f, "\x2a\x3f"}, {0x3060, "\x2a\x40"},
  {0x3061, "\x2a\x41"}, {0x3062, "\x2a\x42"}, {0x3063, "\x2a\x43"},
  {0x3064, "\x2a\x44"}, {0x3065, "\x2a\x45"}, {0x3066, "\x2a\x46"},
  {0x3067, "\x2a\x47"}, {0x3068, "\x2a\x48"}, {0x3069, "\x2a\x49"},
  {0x306a, "\x2a\x4a"}, {0x306b, "\x2a\x4b"}, {0x306c, "\x2a\x4c"},
  {0x306d, "\x2a\x4d"}, {0x306e, "\x2a\x4e"}, {0x306f, "\x2a\x4f"},
  {0x3070, "\x2a\x50"}, {0x3071, "\x2a\x51"}, {0x3072, "\x2a\x52"},
  {0x3073, "\x2a\x53"}, {0x3074, "\x2a\x54"}, {0x3075, "\x2a\x55"},
  {0x3076, "\x2a\x56"}, {0x3077, "\x2a\x57"}, {0x3078, "\x2a\x58"},
  {0x3079, "\x2a\x59"}, {0x307a, "\x2a\x5a"}, {0x307b, "\x2a\x5b"},
  {0x307c, "\x2a\x5c"}, {0x307d, "\x2a\x5d"}, {0x307e, "\x2a\x5e"},
  {0x307f, "\x2a\x5f"}, {0x3080, "\x2a\x60"}, {0x3081, "\x2a\x61"},
  {0x3082, "\x2a\x62"}, {0x3083, "\x2a\x63"}, {0x3084, "\x2a\x64"},
  {0x3085, "\x2a\x65"}, {0x3086, "\x2a\x66"}, {0x3087, "\x2a\x67"},
  {0x3088, "\x2a\x68"}, {0x3089, "\x2a\x69"}, {0x308a, "\x2a\x6a"},
  {0x308b, "\x2a\x6b"}, {0x308c, "\x2a\x6c"}, {0x308d, "\x2a\x6d"},
  {0x308e, "\x2a\x6e"}, {0x308f, "\x2a\x6f"}, {0x3090, "\x2a\x70"},
  {0x3091, "\x2a\x71"}, {0x3092, "\x2a\x72"}, {0x3093, "\x2a\x73"},
  {0x30a1, "\x2b\x21"}, {0x30a2, "\x2b\x22"}, {0x30a3, "\x2b\x23"},
  {0x30a4, "\x2b\x24"}, {0x30a5, "\x2b\x25"}, {0x30a6, "\x2b\x26"},
  {0x30a7, "\x2b\x27"}, {0x30a8, "\x2b\x28"}, {0x30a9, "\x2b\x29"},
  {0x30aa, "\x2b\x2a"}, {0x30ab, "\x2b\x2b"}, {0x30ac, "\x2b\x2c"},
  {0x30ad, "\x2b\x2d"}, {0x30ae, "\x2b\x2e"}, {0x30af, "\x2b\x2f"},
  {0x30b0, "\x2b\x30"}, {0x30b1, "\x2b\x31"}, {0x30b2, "\x2b\x32"},
  {0x30b3, "\x2b\x33"}, {0x30b4, "\x2b\x34"}, {0x30b5, "\x2b\x35"},
  {0x30b6, "\x2b\x36"}, {0x30b7, "\x2b\x37"}, {0x30b8, "\x2b\x38"},
  {0x30b9, "\x2b\x39"}, {0x30ba, "\x2b\x3a"}, {0x30bb, "\x2b\x3b"},
  {0x30bc, "\x2b\x3c"}, {0x30bd, "\x2b\x3d"}, {0x30be, "\x2b\x3e"},
  {0x30bf, "\x2b\x3f"}, {0x30c0, "\x2b\x40"}, {0x30c1, "\x2b\x41"},
  {0x30c2, "\x2b\x42"}, {0x30c3, "\x2b\x43"}, {0x30c4, "\x2b\x44"},
  {0x30c5, "\x2b\x45"}, {0x30c6, "\x2b\x46"}, {0x30c7, "\x2b\x47"},
  {0x30c8, "\x2b\x48"}, {0x30c9, "\x2b\x49"}, {0x30ca, "\x2b\x4a"},
  {0x30cb, "\x2b\x4b"}, {0x30cc, "\x2b\x4c"}, {0x30cd, "\x2b\x4d"},
  {0x30ce, "\x2b\x4e"}, {0x30cf, "\x2b\x4f"}, {0x30d0, "\x2b\x50"},
  {0x30d1, "\x2b\x51"}, {0x30d2, "\x2b\x52"}, {0x30d3, "\x2b\x53"},
  {0x30d4, "\x2b\x54"}, {0x30d5, "\x2b\x55"}, {0x30d6, "\x2b\x56"},
  {0x30d7, "\x2b\x57"}, {0x30d8, "\x2b\x58"}, {0x30d9, "\x2b\x59"},
  {0x30da, "\x2b\x5a"}, {0x30db, "\x2b\x5b"}, {0x30dc, "\x2b\x5c"},
  {0x30dd, "\x2b\x5d"}, {0x30de, "\x2b\x5e"}, {0x30df, "\x2b\x5f"},
  {0x30e0, "\x2b\x60"}, {0x30e1, "\x2b\x61"}, {0x30e2, "\x2b\x62"},
  {0x30e3, "\x2b\x63"}, {0x30e4, "\x2b\x64"}, {0x30e5, "\x2b\x65"},
  {0x30e6, "\x2b\x66"}, {0x30e7, "\x2b\x67"}, {0x30e8, "\x2b\x68"},
  {0x30e9, "\x2b\x69"}, {0x30ea, "\x2b\x6a"}, {0x30eb, "\x2b\x6b"},
  {0x30ec, "\x2b\x6c"}, {0x30ed, "\x2b\x6d"}, {0x30ee, "\x2b\x6e"},
  {0x30ef, "\x2b\x6f"}, {0x30f0, "\x2b\x70"}, {0x30f1, "\x2b\x71"},
  {0x30f2, "\x2b\x72"}, {0x30f3, "\x2b\x73"}, {0x30f4, "\x2b\x74"},
  {0x30f5, "\x2b\x75"}, {0x30f6, "\x2b\x76"}, {0x3131, "\x24\x21"},
  {0x3132, "\x24\x22"}, {0x3133, "\x24\x23"}, {0x3134, "\x24\x24"},
  {0x3135, "\x24\x25"}, {0x3136, "\x24\x26"}, {0x3137, "\x24\x27"},
  {0x3138, "\x24\x28"}, {0x3139, "\x24\x29"}, {0x313a, "\x24\x2a"},
  {0x313b, "\x24\x2b"}, {0x313c, "\x24\x2c"}, {0x313d, "\x24\x2d"},
  {0x313e, "\x24\x2e"}, {0x313f, "\x24\x2f"}, {0x3140, "\x24\x30"},
  {0x3141, "\x24\x31"}, {0x3142, "\x24\x32"}, {0x3143, "\x24\x33"},
  {0x3144, "\x24\x34"}, {0x3145, "\x24\x35"}, {0x3146, "\x24\x36"},
  {0x3147, "\x24\x37"}, {0x3148, "\x24\x38"}, {0x3149, "\x24\x39"},
  {0x314a, "\x24\x3a"}, {0x314b, "\x24\x3b"}, {0x314c, "\x24\x3c"},
  {0x314d, "\x24\x3d"}, {0x314e, "\x24\x3e"}, {0x314f, "\x24\x3f"},
  {0x3150, "\x24\x40"}, {0x3151, "\x24\x41"}, {0x3152, "\x24\x42"},
  {0x3153, "\x24\x43"}, {0x3154, "\x24\x44"}, {0x3155, "\x24\x45"},
  {0x3156, "\x24\x46"}, {0x3157, "\x24\x47"}, {0x3158, "\x24\x48"},
  {0x3159, "\x24\x49"}, {0x315a, "\x24\x4a"}, {0x315b, "\x24\x4b"},
  {0x315c, "\x24\x4c"}, {0x315d, "\x24\x4d"}, {0x315e, "\x24\x4e"},
  {0x315f, "\x24\x4f"}, {0x3160, "\x24\x50"}, {0x3161, "\x24\x51"},
  {0x3162, "\x24\x52"}, {0x3163, "\x24\x53"}, {0x3164, "\x24\x54"},
  {0x3165, "\x24\x55"}, {0x3166, "\x24\x56"}, {0x3167, "\x24\x57"},
  {0x3168, "\x24\x58"}, {0x3169, "\x24\x59"}, {0x316a, "\x24\x5a"},
  {0x316b, "\x24\x5b"}, {0x316c, "\x24\x5c"}, {0x316d, "\x24\x5d"},
  {0x316e, "\x24\x5e"}, {0x316f, "\x24\x5f"}, {0x3170, "\x24\x60"},
  {0x3171, "\x24\x61"}, {0x3172, "\x24\x62"}, {0x3173, "\x24\x63"},
  {0x3174, "\x24\x64"}, {0x3175, "\x24\x65"}, {0x3176, "\x24\x66"},
  {0x3177, "\x24\x67"}, {0x3178, "\x24\x68"}, {0x3179, "\x24\x69"},
  {0x317a, "\x24\x6a"}, {0x317b, "\x24\x6b"}, {0x317c, "\x24\x6c"},
  {0x317d, "\x24\x6d"}, {0x317e, "\x24\x6e"}, {0x317f, "\x24\x6f"},
  {0x3180, "\x24\x70"}, {0x3181, "\x24\x71"}, {0x3182, "\x24\x72"},
  {0x3183, "\x24\x73"}, {0x3184, "\x24\x74"}, {0x3185, "\x24\x75"},
  {0x3186, "\x24\x76"}, {0x3187, "\x24\x77"}, {0x3188, "\x24\x78"},
  {0x3189, "\x24\x79"}, {0x318a, "\x24\x7a"}, {0x318b, "\x24\x7b"},
  {0x318c, "\x24\x7c"}, {0x318d, "\x24\x7d"}, {0x318e, "\x24\x7e"},
  {0x3200, "\x29\x31"}, {0x3201, "\x29\x32"}, {0x3202, "\x29\x33"},
  {0x3203, "\x29\x34"}, {0x3204, "\x29\x35"}, {0x3205, "\x29\x36"},
  {0x3206, "\x29\x37"}, {0x3207, "\x29\x38"}, {0x3208, "\x29\x39"},
  {0x3209, "\x29\x3a"}, {0x320a, "\x29\x3b"}, {0x320b, "\x29\x3c"},
  {0x320c, "\x29\x3d"}, {0x320d, "\x29\x3e"}, {0x320e, "\x29\x3f"},
  {0x320f, "\x29\x40"}, {0x3210, "\x29\x41"}, {0x3211, "\x29\x42"},
  {0x3212, "\x29\x43"}, {0x3213, "\x29\x44"}, {0x3214, "\x29\x45"},
  {0x3215, "\x29\x46"}, {0x3216, "\x29\x47"}, {0x3217, "\x29\x48"},
  {0x3218, "\x29\x49"}, {0x3219, "\x29\x4a"}, {0x321a, "\x29\x4b"},
  {0x321b, "\x29\x4c"}, {0x321c, "\x22\x5f"}, {0x3260, "\x28\x31"},
  {0x3261, "\x28\x32"}, {0x3262, "\x28\x33"}, {0x3263, "\x28\x34"},
  {0x3264, "\x28\x35"}, {0x3265, "\x28\x36"}, {0x3266, "\x28\x37"},
  {0x3267, "\x28\x38"}, {0x3268, "\x28\x39"}, {0x3269, "\x28\x3a"},
  {0x326a, "\x28\x3b"}, {0x326b, "\x28\x3c"}, {0x326c, "\x28\x3d"},
  {0x326d, "\x28\x3e"}, {0x326e, "\x28\x3f"}, {0x326f, "\x28\x40"},
  {0x3270, "\x28\x41"}, {0x3271, "\x28\x42"}, {0x3272, "\x28\x43"},
  {0x3273, "\x28\x44"}, {0x3274, "\x28\x45"}, {0x3275, "\x28\x46"},
  {0x3276, "\x28\x47"}, {0x3277, "\x28\x48"}, {0x3278, "\x28\x49"},
  {0x3279, "\x28\x4a"}, {0x327a, "\x28\x4b"}, {0x327b, "\x28\x4c"},
  {0x327f, "\x22\x5e"}, {0x3380, "\x27\x49"}, {0x3381, "\x27\x4a"},
  {0x3382, "\x27\x4b"}, {0x3383, "\x27\x4c"}, {0x3384, "\x27\x4d"},
  {0x3388, "\x27\x3a"}, {0x3389, "\x27\x3b"}, {0x338a, "\x27\x5c"},
  {0x338b, "\x27\x5d"}, {0x338c, "\x27\x5e"}, {0x338d, "\x27\x36"},
  {0x338e, "\x27\x37"}, {0x338f, "\x27\x38"}, {0x3390, "\x27\x54"},
  {0x3391, "\x27\x55"}, {0x3392, "\x27\x56"}, {0x3393, "\x27\x57"},
  {0x3394, "\x27\x58"}, {0x3395, "\x27\x21"}, {0x3396, "\x27\x22"},
  {0x3397, "\x27\x23"}, {0x3398, "\x27\x25"}, {0x3399, "\x27\x2b"},
  {0x339a, "\x27\x2c"}, {0x339b, "\x27\x2d"}, {0x339c, "\x27\x2e"},
  {0x339d, "\x27\x2f"}, {0x339e, "\x27\x30"}, {0x339f, "\x27\x31"},
  {0x33a0, "\x27\x32"}, {0x33a1, "\x27\x33"}, {0x33a2, "\x27\x34"},
  {0x33a3, "\x27\x27"}, {0x33a4, "\x27\x28"}, {0x33a5, "\x27\x29"},
  {0x33a6, "\x27\x2a"}, {0x33a7, "\x27\x3d"}, {0x33a8, "\x27\x3e"},
  {0x33a9, "\x27\x65"}, {0x33aa, "\x27\x66"}, {0x33ab, "\x27\x67"},
  {0x33ac, "\x27\x68"}, {0x33ad, "\x27\x61"}, {0x33ae, "\x27\x62"},
  {0x33af, "\x27\x63"}, {0x33b0, "\x27\x3f"}, {0x33b1, "\x27\x40"},
  {0x33b2, "\x27\x41"}, {0x33b3, "\x27\x42"}, {0x33b4, "\x27\x43"},
  {0x33b5, "\x27\x44"}, {0x33b6, "\x27\x45"}, {0x33b7, "\x27\x46"},
  {0x33b8, "\x27\x47"}, {0x33b9, "\x27\x48"}, {0x33ba, "\x27\x4e"},
  {0x33bb, "\x27\x4f"}, {0x33bc, "\x27\x50"}, {0x33bd, "\x27\x51"},
  {0x33be, "\x27\x52"}, {0x33bf, "\x27\x53"}, {0x33c0, "\x27\x5a"},
  {0x33c1, "\x27\x5b"}, {0x33c2, "\x22\x63"}, {0x33c3, "\x27\x6c"},
  {0x33c4, "\x27\x26"}, {0x33c5, "\x27\x60"}, {0x33c6, "\x27\x6f"},
  {0x33c7, "\x22\x61"}, {0x33c8, "\x27\x3c"}, {0x33c9, "\x27\x6d"},
  {0x33ca, "\x27\x35"}, {0x33cf, "\x27\x39"}, {0x33d0, "\x27\x6a"},
  {0x33d3, "\x27\x6b"}, {0x33d6, "\x27\x5f"}, {0x33d8, "\x22\x64"},
  {0x33db, "\x27\x64"}, {0x33dc, "\x27\x6e"}, {0x33dd, "\x27\x69"},
  {0xff01, "\x23\x21"}, {0xff02, "\x23\x22"}, {0xff03, "\x23\x23"},
  {0xff04, "\x23\x24"}, {0xff05, "\x23\x25"}, {0xff06, "\x23\x26"},
  {0xff07, "\x23\x27"}, {0xff08, "\x23\x28"}, {0xff09, "\x23\x29"},
  {0xff0a, "\x23\x2a"}, {0xff0b, "\x23\x2b"}, {0xff0c, "\x23\x2c"},
  {0xff0d, "\x23\x2d"}, {0xff0e, "\x23\x2e"}, {0xff0f, "\x23\x2f"},
  {0xff10, "\x23\x30"}, {0xff11, "\x23\x31"}, {0xff12, "\x23\x32"},
  {0xff13, "\x23\x33"}, {0xff14, "\x23\x34"}, {0xff15, "\x23\x35"},
  {0xff16, "\x23\x36"}, {0xff17, "\x23\x37"}, {0xff18, "\x23\x38"},
  {0xff19, "\x23\x39"}, {0xff1a, "\x23\x3a"}, {0xff1b, "\x23\x3b"},
  {0xff1c, "\x23\x3c"}, {0xff1d, "\x23\x3d"}, {0xff1e, "\x23\x3e"},
  {0xff1f, "\x23\x3f"}, {0xff20, "\x23\x40"}, {0xff21, "\x23\x41"},
  {0xff22, "\x23\x42"}, {0xff23, "\x23\x43"}, {0xff24, "\x23\x44"},
  {0xff25, "\x23\x45"}, {0xff26, "\x23\x46"}, {0xff27, "\x23\x47"},
  {0xff28, "\x23\x48"}, {0xff29, "\x23\x49"}, {0xff2a, "\x23\x4a"},
  {0xff2b, "\x23\x4b"}, {0xff2c, "\x23\x4c"}, {0xff2d, "\x23\x4d"},
  {0xff2e, "\x23\x4e"}, {0xff2f, "\x23\x4f"}, {0xff30, "\x23\x50"},
  {0xff31, "\x23\x51"}, {0xff32, "\x23\x52"}, {0xff33, "\x23\x53"},
  {0xff34, "\x23\x54"}, {0xff35, "\x23\x55"}, {0xff36, "\x23\x56"},
  {0xff37, "\x23\x57"}, {0xff38, "\x23\x58"}, {0xff39, "\x23\x59"},
  {0xff3a, "\x23\x5a"}, {0xff3b, "\x23\x5b"}, {0xff3c, "\x21\x2c"},
  {0xff3d, "\x23\x5d"}, {0xff3e, "\x23\x5e"}, {0xff3f, "\x23\x5f"},
  {0xff40, "\x23\x60"}, {0xff41, "\x23\x61"}, {0xff42, "\x23\x62"},
  {0xff43, "\x23\x63"}, {0xff44, "\x23\x64"}, {0xff45, "\x23\x65"},
  {0xff46, "\x23\x66"}, {0xff47, "\x23\x67"}, {0xff48, "\x23\x68"},
  {0xff49, "\x23\x69"}, {0xff4a, "\x23\x6a"}, {0xff4b, "\x23\x6b"},
  {0xff4c, "\x23\x6c"}, {0xff4d, "\x23\x6d"}, {0xff4e, "\x23\x6e"},
  {0xff4f, "\x23\x6f"}, {0xff50, "\x23\x70"}, {0xff51, "\x23\x71"},
  {0xff52, "\x23\x72"}, {0xff53, "\x23\x73"}, {0xff54, "\x23\x74"},
  {0xff55, "\x23\x75"}, {0xff56, "\x23\x76"}, {0xff57, "\x23\x77"},
  {0xff58, "\x23\x78"}, {0xff59, "\x23\x79"}, {0xff5a, "\x23\x7a"},
  {0xff5b, "\x23\x7b"}, {0xff5c, "\x23\x7c"}, {0xff5d, "\x23\x7d"},
  {0xff5e, "\x22\x26"}, {0xffe0, "\x21\x4b"}, {0xffe1, "\x21\x4c"},
  {0xffe2, "\x21\x7e"}, {0xffe3, "\x23\x7e"}, {0xffe5, "\x21\x4d"},
  {0xffe6, "\x23\x5c"}
};

/*
egrep  '^0x.*# <CJK>' < /cdrom/unix/mappings/eastasia/ksc/ksc5601.txt | \
perl tab21.pl > ksc_hanja1.tb


   $n=0;
   while (<>) {
     local($ksc, $ucs4, %rest) = split;
     local($u)=hex($ucs4);
     local($k)=hex($ksc);
     printf ("\n ") if ($n % 8 eq 0);
     ++$n;
     printf (" 0x%04x,", $u);
   }
   printf ("\n");
*/

const uint16_t __ksc5601_hanja_to_ucs[KSC5601_HANJA]=
{
  0x4f3d, 0x4f73, 0x5047, 0x50f9, 0x52a0, 0x53ef, 0x5475, 0x54e5,
  0x5609, 0x5ac1, 0x5bb6, 0x6687, 0x67b6, 0x67b7, 0x67ef, 0x6b4c,
  0x73c2, 0x75c2, 0x7a3c, 0x82db, 0x8304, 0x8857, 0x8888, 0x8a36,
  0x8cc8, 0x8dcf, 0x8efb, 0x8fe6, 0x99d5, 0x523b, 0x5374, 0x5404,
  0x606a, 0x6164, 0x6bbc, 0x73cf, 0x811a, 0x89ba, 0x89d2, 0x95a3,
  0x4f83, 0x520a, 0x58be, 0x5978, 0x59e6, 0x5e72, 0x5e79, 0x61c7,
  0x63c0, 0x6746, 0x67ec, 0x687f, 0x6f97, 0x764e, 0x770b, 0x78f5,
  0x7a08, 0x7aff, 0x7c21, 0x809d, 0x826e, 0x8271, 0x8aeb, 0x9593,
  0x4e6b, 0x559d, 0x66f7, 0x6e34, 0x78a3, 0x7aed, 0x845b, 0x8910,
  0x874e, 0x97a8, 0x52d8, 0x574e, 0x582a, 0x5d4c, 0x611f, 0x61be,
  0x6221, 0x6562, 0x67d1, 0x6a44, 0x6e1b, 0x7518, 0x75b3, 0x76e3,
  0x77b0, 0x7d3a, 0x90af, 0x9451, 0x9452, 0x9f95, 0x5323, 0x5cac,
  0x7532, 0x80db, 0x9240, 0x9598, 0x525b, 0x5808, 0x59dc, 0x5ca1,
  0x5d17, 0x5eb7, 0x5f3a, 0x5f4a, 0x6177, 0x6c5f, 0x757a, 0x7586,
  0x7ce0, 0x7d73, 0x7db1, 0x7f8c, 0x8154, 0x8221, 0x8591, 0x8941,
  0x8b1b, 0x92fc, 0x964d, 0x9c47, 0x4ecb, 0x4ef7, 0x500b, 0x51f1,
  0x584f, 0x6137, 0x613e, 0x6168, 0x6539, 0x69ea, 0x6f11, 0x75a5,
  0x7686, 0x76d6, 0x7b87, 0x82a5, 0x84cb, 0xf900, 0x93a7, 0x958b,
  0x5580, 0x5ba2, 0x5751, 0xf901, 0x7cb3, 0x7fb9, 0x91b5, 0x5028,
  0x53bb, 0x5c45, 0x5de8, 0x62d2, 0x636e, 0x64da, 0x64e7, 0x6e20,
  0x70ac, 0x795b, 0x8ddd, 0x8e1e, 0xf902, 0x907d, 0x9245, 0x92f8,
  0x4e7e, 0x4ef6, 0x5065, 0x5dfe, 0x5efa, 0x6106, 0x6957, 0x8171,
  0x8654, 0x8e47, 0x9375, 0x9a2b, 0x4e5e, 0x5091, 0x6770, 0x6840,
  0x5109, 0x528d, 0x5292, 0x6aa2, 0x77bc, 0x9210, 0x9ed4, 0x52ab,
  0x602f, 0x8ff2, 0x5048, 0x61a9, 0x63ed, 0x64ca, 0x683c, 0x6a84,
  0x6fc0, 0x8188, 0x89a1, 0x9694, 0x5805, 0x727d, 0x72ac, 0x7504,
  0x7d79, 0x7e6d, 0x80a9, 0x898b, 0x8b74, 0x9063, 0x9d51, 0x6289,
  0x6c7a, 0x6f54, 0x7d50, 0x7f3a, 0x8a23, 0x517c, 0x614a, 0x7b9d,
  0x8b19, 0x9257, 0x938c, 0x4eac, 0x4fd3, 0x501e, 0x50be, 0x5106,
  0x52c1, 0x52cd, 0x537f, 0x5770, 0x5883, 0x5e9a, 0x5f91, 0x6176,
  0x61ac, 0x64ce, 0x656c, 0x666f, 0x66bb, 0x66f4, 0x6897, 0x6d87,
  0x7085, 0x70f1, 0x749f, 0x74a5, 0x74ca, 0x75d9, 0x786c, 0x78ec,
  0x7adf, 0x7af6, 0x7d45, 0x7d93, 0x8015, 0x803f, 0x811b, 0x8396,
  0x8b66, 0x8f15, 0x9015, 0x93e1, 0x9803, 0x9838, 0x9a5a, 0x9be8,
  0x4fc2, 0x5553, 0x583a, 0x5951, 0x5b63, 0x5c46, 0x60b8, 0x6212,
  0x6842, 0x68b0, 0x68e8, 0x6eaa, 0x754c, 0x7678, 0x78ce, 0x7a3d,
  0x7cfb, 0x7e6b, 0x7e7c, 0x8a08, 0x8aa1, 0x8c3f, 0x968e, 0x9dc4,
  0x53e4, 0x53e9, 0x544a, 0x5471, 0x56fa, 0x59d1, 0x5b64, 0x5c3b,
  0x5eab, 0x62f7, 0x6537, 0x6545, 0x6572, 0x66a0, 0x67af, 0x69c1,
  0x6cbd, 0x75fc, 0x7690, 0x777e, 0x7a3f, 0x7f94, 0x8003, 0x80a1,
  0x818f, 0x82e6, 0x82fd, 0x83f0, 0x85c1, 0x8831, 0x88b4, 0x8aa5,
  0xf903, 0x8f9c, 0x932e, 0x96c7, 0x9867, 0x9ad8, 0x9f13, 0x54ed,
  0x659b, 0x66f2, 0x688f, 0x7a40, 0x8c37, 0x9d60, 0x56f0, 0x5764,
  0x5d11, 0x6606, 0x68b1, 0x68cd, 0x6efe, 0x7428, 0x889e, 0x9be4,
  0x6c68, 0xf904, 0x9aa8, 0x4f9b, 0x516c, 0x5171, 0x529f, 0x5b54,
  0x5de5, 0x6050, 0x606d, 0x62f1, 0x63a7, 0x653b, 0x73d9, 0x7a7a,
  0x86a3, 0x8ca2, 0x978f, 0x4e32, 0x5be1, 0x6208, 0x679c, 0x74dc,
  0x79d1, 0x83d3, 0x8a87, 0x8ab2, 0x8de8, 0x904e, 0x934b, 0x9846,
  0x5ed3, 0x69e8, 0x85ff, 0x90ed, 0xf905, 0x51a0, 0x5b98, 0x5bec,
  0x6163, 0x68fa, 0x6b3e, 0x704c, 0x742f, 0x74d8, 0x7ba1, 0x7f50,
  0x83c5, 0x89c0, 0x8cab, 0x95dc, 0x9928, 0x522e, 0x605d, 0x62ec,
  0x9002, 0x4f8a, 0x5149, 0x5321, 0x58d9, 0x5ee3, 0x66e0, 0x6d38,
  0x709a, 0x72c2, 0x73d6, 0x7b50, 0x80f1, 0x945b, 0x5366, 0x639b,
  0x7f6b, 0x4e56, 0x5080, 0x584a, 0x58de, 0x602a, 0x6127, 0x62d0,
  0x69d0, 0x9b41, 0x5b8f, 0x7d18, 0x80b1, 0x8f5f, 0x4ea4, 0x50d1,
  0x54ac, 0x55ac, 0x5b0c, 0x5da0, 0x5de7, 0x652a, 0x654e, 0x6821,
  0x6a4b, 0x72e1, 0x768e, 0x77ef, 0x7d5e, 0x7ff9, 0x81a0, 0x854e,
  0x86df, 0x8f03, 0x8f4e, 0x90ca, 0x9903, 0x9a55, 0x9bab, 0x4e18,
  0x4e45, 0x4e5d, 0x4ec7, 0x4ff1, 0x5177, 0x52fe, 0x5340, 0x53e3,
  0x53e5, 0x548e, 0x5614, 0x5775, 0x57a2, 0x5bc7, 0x5d87, 0x5ed0,
  0x61fc, 0x62d8, 0x6551, 0x67b8, 0x67e9, 0x69cb, 0x6b50, 0x6bc6,
  0x6bec, 0x6c42, 0x6e9d, 0x7078, 0x72d7, 0x7396, 0x7403, 0x77bf,
  0x77e9, 0x7a76, 0x7d7f, 0x8009, 0x81fc, 0x8205, 0x820a, 0x82df,
  0x8862, 0x8b33, 0x8cfc, 0x8ec0, 0x9011, 0x90b1, 0x9264, 0x92b6,
  0x99d2, 0x9a45, 0x9ce9, 0x9dd7, 0x9f9c, 0x570b, 0x5c40, 0x83ca,
  0x97a0, 0x97ab, 0x9eb4, 0x541b, 0x7a98, 0x7fa4, 0x88d9, 0x8ecd,
  0x90e1, 0x5800, 0x5c48, 0x6398, 0x7a9f, 0x5bae, 0x5f13, 0x7a79,
  0x7aae, 0x828e, 0x8eac, 0x5026, 0x5238, 0x52f8, 0x5377, 0x5708,
  0x62f3, 0x6372, 0x6b0a, 0x6dc3, 0x7737, 0x53a5, 0x7357, 0x8568,
  0x8e76, 0x95d5, 0x673a, 0x6ac3, 0x6f70, 0x8a6d, 0x8ecc, 0x994b,
  0xf906, 0x6677, 0x6b78, 0x8cb4, 0x9b3c, 0xf907, 0x53eb, 0x572d,
  0x594e, 0x63c6, 0x69fb, 0x73ea, 0x7845, 0x7aba, 0x7ac5, 0x7cfe,
  0x8475, 0x898f, 0x8d73, 0x9035, 0x95a8, 0x52fb, 0x5747, 0x7547,
  0x7b60, 0x83cc, 0x921e, 0xf908, 0x6a58, 0x514b, 0x524b, 0x5287,
  0x621f, 0x68d8, 0x6975, 0x9699, 0x50c5, 0x52a4, 0x52e4, 0x61c3,
  0x65a4, 0x6839, 0x69ff, 0x747e, 0x7b4b, 0x82b9, 0x83eb, 0x89b2,
  0x8b39, 0x8fd1, 0x9949, 0xf909, 0x4eca, 0x5997, 0x64d2, 0x6611,
  0x6a8e, 0x7434, 0x7981, 0x79bd, 0x82a9, 0x887e, 0x887f, 0x895f,
  0xf90a, 0x9326, 0x4f0b, 0x53ca, 0x6025, 0x6271, 0x6c72, 0x7d1a,
  0x7d66, 0x4e98, 0x5162, 0x77dc, 0x80af, 0x4f01, 0x4f0e, 0x5176,
  0x5180, 0x55dc, 0x5668, 0x573b, 0x57fa, 0x57fc, 0x5914, 0x5947,
  0x5993, 0x5bc4, 0x5c90, 0x5d0e, 0x5df1, 0x5e7e, 0x5fcc, 0x6280,
  0x65d7, 0x65e3, 0x671e, 0x671f, 0x675e, 0x68cb, 0x68c4, 0x6a5f,
  0x6b3a, 0x6c23, 0x6c7d, 0x6c82, 0x6dc7, 0x7398, 0x7426, 0x742a,
  0x7482, 0x74a3, 0x7578, 0x757f, 0x7881, 0x78ef, 0x7941, 0x7947,
  0x7948, 0x797a, 0x7b95, 0x7d00, 0x7dba, 0x7f88, 0x8006, 0x802d,
  0x808c, 0x8a18, 0x8b4f, 0x8c48, 0x8d77, 0x9321, 0x9324, 0x98e2,
  0x9951, 0x9a0e, 0x9a0f, 0x9a65, 0x9e92, 0x7dca, 0x4f76, 0x5409,
  0x62ee, 0x6854, 0x91d1, 0x55ab, 0x513a, 0xf90b, 0xf90c, 0x5a1c,
  0x61e6, 0xf90d, 0x62cf, 0x62ff, 0xf90e, 0xf90f, 0xf910, 0xf911,
  0xf912, 0xf913, 0x90a3, 0xf914, 0xf915, 0xf916, 0xf917, 0xf918,
  0x8afe, 0xf919, 0xf91a, 0xf91b, 0xf91c, 0x6696, 0xf91d, 0x7156,
  0xf91e, 0xf91f, 0x96e3, 0xf920, 0x634f, 0x637a, 0x5357, 0xf921,
  0x678f, 0x6960, 0x6e73, 0xf922, 0x7537, 0xf923, 0xf924, 0xf925,
  0x7d0d, 0xf926, 0xf927, 0x8872, 0x56ca, 0x5a18, 0xf928, 0xf929,
  0xf92a, 0xf92b, 0xf92c, 0x4e43, 0xf92d, 0x5167, 0x5948, 0x67f0,
  0x8010, 0xf92e, 0x5973, 0x5e74, 0x649a, 0x79ca, 0x5ff5, 0x606c,
  0x62c8, 0x637b, 0x5be7, 0x5bd7, 0x52aa, 0xf92f, 0x5974, 0x5f29,
  0x6012, 0xf930, 0xf931, 0xf932, 0x7459, 0xf933, 0xf934, 0xf935,
  0xf936, 0xf937, 0xf938, 0x99d1, 0xf939, 0xf93a, 0xf93b, 0xf93c,
  0xf93d, 0xf93e, 0xf93f, 0xf940, 0xf941, 0xf942, 0xf943, 0x6fc3,
  0xf944, 0xf945, 0x81bf, 0x8fb2, 0x60f1, 0xf946, 0xf947, 0x8166,
  0xf948, 0xf949, 0x5c3f, 0xf94a, 0xf94b, 0xf94c, 0xf94d, 0xf94e,
  0xf94f, 0xf950, 0xf951, 0x5ae9, 0x8a25, 0x677b, 0x7d10, 0xf952,
  0xf953, 0xf954, 0xf955, 0xf956, 0xf957, 0x80fd, 0xf958, 0xf959,
  0x5c3c, 0x6ce5, 0x533f, 0x6eba, 0x591a, 0x8336, 0x4e39, 0x4eb6,
  0x4f46, 0x55ae, 0x5718, 0x58c7, 0x5f56, 0x65b7, 0x65e6, 0x6a80,
  0x6bb5, 0x6e4d, 0x77ed, 0x7aef, 0x7c1e, 0x7dde, 0x86cb, 0x8892,
  0x9132, 0x935b, 0x64bb, 0x6fbe, 0x737a, 0x75b8, 0x9054, 0x5556,
  0x574d, 0x61ba, 0x64d4, 0x66c7, 0x6de1, 0x6e5b, 0x6f6d, 0x6fb9,
  0x75f0, 0x8043, 0x81bd, 0x8541, 0x8983, 0x8ac7, 0x8b5a, 0x931f,
  0x6c93, 0x7553, 0x7b54, 0x8e0f, 0x905d, 0x5510, 0x5802, 0x5858,
  0x5e62, 0x6207, 0x649e, 0x68e0, 0x7576, 0x7cd6, 0x87b3, 0x9ee8,
  0x4ee3, 0x5788, 0x576e, 0x5927, 0x5c0d, 0x5cb1, 0x5e36, 0x5f85,
  0x6234, 0x64e1, 0x73b3, 0x81fa, 0x888b, 0x8cb8, 0x968a, 0x9edb,
  0x5b85, 0x5fb7, 0x60b3, 0x5012, 0x5200, 0x5230, 0x5716, 0x5835,
  0x5857, 0x5c0e, 0x5c60, 0x5cf6, 0x5d8b, 0x5ea6, 0x5f92, 0x60bc,
  0x6311, 0x6389, 0x6417, 0x6843, 0x68f9, 0x6ac2, 0x6dd8, 0x6e21,
  0x6ed4, 0x6fe4, 0x71fe, 0x76dc, 0x7779, 0x79b1, 0x7a3b, 0x8404,
  0x89a9, 0x8ced, 0x8df3, 0x8e48, 0x9003, 0x9014, 0x9053, 0x90fd,
  0x934d, 0x9676, 0x97dc, 0x6bd2, 0x7006, 0x7258, 0x72a2, 0x7368,
  0x7763, 0x79bf, 0x7be4, 0x7e9b, 0x8b80, 0x58a9, 0x60c7, 0x6566,
  0x65fd, 0x66be, 0x6c8c, 0x711e, 0x71c9, 0x8c5a, 0x9813, 0x4e6d,
  0x7a81, 0x4edd, 0x51ac, 0x51cd, 0x52d5, 0x540c, 0x61a7, 0x6771,
  0x6850, 0x68df, 0x6d1e, 0x6f7c, 0x75bc, 0x77b3, 0x7ae5, 0x80f4,
  0x8463, 0x9285, 0x515c, 0x6597, 0x675c, 0x6793, 0x75d8, 0x7ac7,
  0x8373, 0xf95a, 0x8c46, 0x9017, 0x982d, 0x5c6f, 0x81c0, 0x829a,
  0x9041, 0x906f, 0x920d, 0x5f97, 0x5d9d, 0x6a59, 0x71c8, 0x767b,
  0x7b49, 0x85e4, 0x8b04, 0x9127, 0x9a30, 0x5587, 0x61f6, 0xf95b,
  0x7669, 0x7f85, 0x863f, 0x87ba, 0x88f8, 0x908f, 0xf95c, 0x6d1b,
  0x70d9, 0x73de, 0x7d61, 0x843d, 0xf95d, 0x916a, 0x99f1, 0xf95e,
  0x4e82, 0x5375, 0x6b04, 0x6b12, 0x703e, 0x721b, 0x862d, 0x9e1e,
  0x524c, 0x8fa3, 0x5d50, 0x64e5, 0x652c, 0x6b16, 0x6feb, 0x7c43,
  0x7e9c, 0x85cd, 0x8964, 0x89bd, 0x62c9, 0x81d8, 0x881f, 0x5eca,
  0x6717, 0x6d6a, 0x72fc, 0x7405, 0x746f, 0x8782, 0x90de, 0x4f86,
  0x5d0d, 0x5fa0, 0x840a, 0x51b7, 0x63a0, 0x7565, 0x4eae, 0x5006,
  0x5169, 0x51c9, 0x6881, 0x6a11, 0x7cae, 0x7cb1, 0x7ce7, 0x826f,
  0x8ad2, 0x8f1b, 0x91cf, 0x4fb6, 0x5137, 0x52f5, 0x5442, 0x5eec,
  0x616e, 0x623e, 0x65c5, 0x6ada, 0x6ffe, 0x792a, 0x85dc, 0x8823,
  0x95ad, 0x9a62, 0x9a6a, 0x9e97, 0x9ece, 0x529b, 0x66c6, 0x6b77,
  0x701d, 0x792b, 0x8f62, 0x9742, 0x6190, 0x6200, 0x6523, 0x6f23,
  0x7149, 0x7489, 0x7df4, 0x806f, 0x84ee, 0x8f26, 0x9023, 0x934a,
  0x51bd, 0x5217, 0x52a3, 0x6d0c, 0x70c8, 0x88c2, 0x5ec9, 0x6582,
  0x6bae, 0x6fc2, 0x7c3e, 0x7375, 0x4ee4, 0x4f36, 0x56f9, 0xf95f,
  0x5cba, 0x5dba, 0x601c, 0x73b2, 0x7b2d, 0x7f9a, 0x7fce, 0x8046,
  0x901e, 0x9234, 0x96f6, 0x9748, 0x9818, 0x9f61, 0x4f8b, 0x6fa7,
  0x79ae, 0x91b4, 0x96b7, 0x52de, 0xf960, 0x6488, 0x64c4, 0x6ad3,
  0x6f5e, 0x7018, 0x7210, 0x76e7, 0x8001, 0x8606, 0x865c, 0x8def,
  0x8f05, 0x9732, 0x9b6f, 0x9dfa, 0x9e75, 0x788c, 0x797f, 0x7da0,
  0x83c9, 0x9304, 0x9e7f, 0x9e93, 0x8ad6, 0x58df, 0x5f04, 0x6727,
  0x7027, 0x74cf, 0x7c60, 0x807e, 0x5121, 0x7028, 0x7262, 0x78ca,
  0x8cc2, 0x8cda, 0x8cf4, 0x96f7, 0x4e86, 0x50da, 0x5bee, 0x5ed6,
  0x6599, 0x71ce, 0x7642, 0x77ad, 0x804a, 0x84fc, 0x907c, 0x9b27,
  0x9f8d, 0x58d8, 0x5a41, 0x5c62, 0x6a13, 0x6dda, 0x6f0f, 0x763b,
  0x7d2f, 0x7e37, 0x851e, 0x8938, 0x93e4, 0x964b, 0x5289, 0x65d2,
  0x67f3, 0x69b4, 0x6d41, 0x6e9c, 0x700f, 0x7409, 0x7460, 0x7559,
  0x7624, 0x786b, 0x8b2c, 0x985e, 0x516d, 0x622e, 0x9678, 0x4f96,
  0x502b, 0x5d19, 0x6dea, 0x7db8, 0x8f2a, 0x5f8b, 0x6144, 0x6817,
  0xf961, 0x9686, 0x52d2, 0x808b, 0x51dc, 0x51cc, 0x695e, 0x7a1c,
  0x7dbe, 0x83f1, 0x9675, 0x4fda, 0x5229, 0x5398, 0x540f, 0x550e,
  0x5c65, 0x60a7, 0x674e, 0x68a8, 0x6d6c, 0x7281, 0x72f8, 0x7406,
  0x7483, 0xf962, 0x75e2, 0x7c6c, 0x7f79, 0x7fb8, 0x8389, 0x88cf,
  0x88e1, 0x91cc, 0x91d0, 0x96e2, 0x9bc9, 0x541d, 0x6f7e, 0x71d0,
  0x7498, 0x85fa, 0x8eaa, 0x96a3, 0x9c57, 0x9e9f, 0x6797, 0x6dcb,
  0x7433, 0x81e8, 0x9716, 0x782c, 0x7acb, 0x7b20, 0x7c92, 0x6469,
  0x746a, 0x75f2, 0x78bc, 0x78e8, 0x99ac, 0x9b54, 0x9ebb, 0x5bde,
  0x5e55, 0x6f20, 0x819c, 0x83ab, 0x9088, 0x4e07, 0x534d, 0x5a29,
  0x5dd2, 0x5f4e, 0x6162, 0x633d, 0x6669, 0x66fc, 0x6eff, 0x6f2b,
  0x7063, 0x779e, 0x842c, 0x8513, 0x883b, 0x8f13, 0x9945, 0x9c3b,
  0x551c, 0x62b9, 0x672b, 0x6cab, 0x8309, 0x896a, 0x977a, 0x4ea1,
  0x5984, 0x5fd8, 0x5fd9, 0x671b, 0x7db2, 0x7f54, 0x8292, 0x832b,
  0x83bd, 0x8f1e, 0x9099, 0x57cb, 0x59b9, 0x5a92, 0x5bd0, 0x6627,
  0x679a, 0x6885, 0x6bcf, 0x7164, 0x7f75, 0x8cb7, 0x8ce3, 0x9081,
  0x9b45, 0x8108, 0x8c8a, 0x964c, 0x9a40, 0x9ea5, 0x5b5f, 0x6c13,
  0x731b, 0x76f2, 0x76df, 0x840c, 0x51aa, 0x8993, 0x514d, 0x5195,
  0x52c9, 0x68c9, 0x6c94, 0x7704, 0x7720, 0x7dbf, 0x7dec, 0x9762,
  0x9eb5, 0x6ec5, 0x8511, 0x51a5, 0x540d, 0x547d, 0x660e, 0x669d,
  0x6927, 0x6e9f, 0x76bf, 0x7791, 0x8317, 0x84c2, 0x879f, 0x9169,
  0x9298, 0x9cf4, 0x8882, 0x4fae, 0x5192, 0x52df, 0x59c6, 0x5e3d,
  0x6155, 0x6478, 0x6479, 0x66ae, 0x67d0, 0x6a21, 0x6bcd, 0x6bdb,
  0x725f, 0x7261, 0x7441, 0x7738, 0x77db, 0x8017, 0x82bc, 0x8305,
  0x8b00, 0x8b28, 0x8c8c, 0x6728, 0x6c90, 0x7267, 0x76ee, 0x7766,
  0x7a46, 0x9da9, 0x6b7f, 0x6c92, 0x5922, 0x6726, 0x8499, 0x536f,
  0x5893, 0x5999, 0x5edf, 0x63cf, 0x6634, 0x6773, 0x6e3a, 0x732b,
  0x7ad7, 0x82d7, 0x9328, 0x52d9, 0x5deb, 0x61ae, 0x61cb, 0x620a,
  0x62c7, 0x64ab, 0x65e0, 0x6959, 0x6b66, 0x6bcb, 0x7121, 0x73f7,
  0x755d, 0x7e46, 0x821e, 0x8302, 0x856a, 0x8aa3, 0x8cbf, 0x9727,
  0x9d61, 0x58a8, 0x9ed8, 0x5011, 0x520e, 0x543b, 0x554f, 0x6587,
  0x6c76, 0x7d0a, 0x7d0b, 0x805e, 0x868a, 0x9580, 0x96ef, 0x52ff,
  0x6c95, 0x7269, 0x5473, 0x5a9a, 0x5c3e, 0x5d4b, 0x5f4c, 0x5fae,
  0x672a, 0x68b6, 0x6963, 0x6e3c, 0x6e44, 0x7709, 0x7c73, 0x7f8e,
  0x8587, 0x8b0e, 0x8ff7, 0x9761, 0x9ef4, 0x5cb7, 0x60b6, 0x610d,
  0x61ab, 0x654f, 0x65fb, 0x65fc, 0x6c11, 0x6cef, 0x739f, 0x73c9,
  0x7de1, 0x9594, 0x5bc6, 0x871c, 0x8b10, 0x525d, 0x535a, 0x62cd,
  0x640f, 0x64b2, 0x6734, 0x6a38, 0x6cca, 0x73c0, 0x749e, 0x7b94,
  0x7c95, 0x7e1b, 0x818a, 0x8236, 0x8584, 0x8feb, 0x96f9, 0x99c1,
  0x4f34, 0x534a, 0x53cd, 0x53db, 0x62cc, 0x642c, 0x6500, 0x6591,
  0x69c3, 0x6cee, 0x6f58, 0x73ed, 0x7554, 0x7622, 0x76e4, 0x76fc,
  0x78d0, 0x78fb, 0x792c, 0x7d46, 0x822c, 0x87e0, 0x8fd4, 0x9812,
  0x98ef, 0x52c3, 0x62d4, 0x64a5, 0x6e24, 0x6f51, 0x767c, 0x8dcb,
  0x91b1, 0x9262, 0x9aee, 0x9b43, 0x5023, 0x508d, 0x574a, 0x59a8,
  0x5c28, 0x5e47, 0x5f77, 0x623f, 0x653e, 0x65b9, 0x65c1, 0x6609,
  0x678b, 0x699c, 0x6ec2, 0x78c5, 0x7d21, 0x80aa, 0x8180, 0x822b,
  0x82b3, 0x84a1, 0x868c, 0x8a2a, 0x8b17, 0x90a6, 0x9632, 0x9f90,
  0x500d, 0x4ff3, 0xf963, 0x57f9, 0x5f98, 0x62dc, 0x6392, 0x676f,
  0x6e43, 0x7119, 0x76c3, 0x80cc, 0x80da, 0x88f4, 0x88f5, 0x8919,
  0x8ce0, 0x8f29, 0x914d, 0x966a, 0x4f2f, 0x4f70, 0x5e1b, 0x67cf,
  0x6822, 0x767d, 0x767e, 0x9b44, 0x5e61, 0x6a0a, 0x7169, 0x71d4,
  0x756a, 0xf964, 0x7e41, 0x8543, 0x85e9, 0x98dc, 0x4f10, 0x7b4f,
  0x7f70, 0x95a5, 0x51e1, 0x5e06, 0x68b5, 0x6c3e, 0x6c4e, 0x6cdb,
  0x72af, 0x7bc4, 0x8303, 0x6cd5, 0x743a, 0x50fb, 0x5288, 0x58c1,
  0x64d8, 0x6a97, 0x74a7, 0x7656, 0x78a7, 0x8617, 0x95e2, 0x9739,
  0xf965, 0x535e, 0x5f01, 0x8b8a, 0x8fa8, 0x8faf, 0x908a, 0x5225,
  0x77a5, 0x9c49, 0x9f08, 0x4e19, 0x5002, 0x5175, 0x5c5b, 0x5e77,
  0x661e, 0x663a, 0x67c4, 0x68c5, 0x70b3, 0x7501, 0x75c5, 0x79c9,
  0x7add, 0x8f27, 0x9920, 0x9a08, 0x4fdd, 0x5821, 0x5831, 0x5bf6,
  0x666e, 0x6b65, 0x6d11, 0x6e7a, 0x6f7d, 0x73e4, 0x752b, 0x83e9,
  0x88dc, 0x8913, 0x8b5c, 0x8f14, 0x4f0f, 0x50d5, 0x5310, 0x535c,
  0x5b93, 0x5fa9, 0x670d, 0x798f, 0x8179, 0x832f, 0x8514, 0x8907,
  0x8986, 0x8f39, 0x8f3b, 0x99a5, 0x9c12, 0x672c, 0x4e76, 0x4ff8,
  0x5949, 0x5c01, 0x5cef, 0x5cf0, 0x6367, 0x68d2, 0x70fd, 0x71a2,
  0x742b, 0x7e2b, 0x84ec, 0x8702, 0x9022, 0x92d2, 0x9cf3, 0x4e0d,
  0x4ed8, 0x4fef, 0x5085, 0x5256, 0x526f, 0x5426, 0x5490, 0x57e0,
  0x592b, 0x5a66, 0x5b5a, 0x5b75, 0x5bcc, 0x5e9c, 0xf966, 0x6276,
  0x6577, 0x65a7, 0x6d6e, 0x6ea5, 0x7236, 0x7b26, 0x7c3f, 0x7f36,
  0x8150, 0x8151, 0x819a, 0x8240, 0x8299, 0x83a9, 0x8a03, 0x8ca0,
  0x8ce6, 0x8cfb, 0x8d74, 0x8dba, 0x90e8, 0x91dc, 0x961c, 0x9644,
  0x99d9, 0x9ce7, 0x5317, 0x5206, 0x5429, 0x5674, 0x58b3, 0x5954,
  0x596e, 0x5fff, 0x61a4, 0x626e, 0x6610, 0x6c7e, 0x711a, 0x76c6,
  0x7c89, 0x7cde, 0x7d1b, 0x82ac, 0x8cc1, 0x96f0, 0xf967, 0x4f5b,
  0x5f17, 0x5f7f, 0x62c2, 0x5d29, 0x670b, 0x68da, 0x787c, 0x7e43,
  0x9d6c, 0x4e15, 0x5099, 0x5315, 0x532a, 0x5351, 0x5983, 0x5a62,
  0x5e87, 0x60b2, 0x618a, 0x6249, 0x6279, 0x6590, 0x6787, 0x69a7,
  0x6bd4, 0x6bd6, 0x6bd7, 0x6bd8, 0x6cb8, 0xf968, 0x7435, 0x75fa,
  0x7812, 0x7891, 0x79d5, 0x79d8, 0x7c83, 0x7dcb, 0x7fe1, 0x80a5,
  0x813e, 0x81c2, 0x83f2, 0x871a, 0x88e8, 0x8ab9, 0x8b6c, 0x8cbb,
  0x9119, 0x975e, 0x98db, 0x9f3b, 0x56ac, 0x5b2a, 0x5f6c, 0x658c,
  0x6ab3, 0x6baf, 0x6d5c, 0x6ff1, 0x7015, 0x725d, 0x73ad, 0x8ca7,
  0x8cd3, 0x983b, 0x6191, 0x6c37, 0x8058, 0x9a01, 0x4e4d, 0x4e8b,
  0x4e9b, 0x4ed5, 0x4f3a, 0x4f3c, 0x4f7f, 0x4fdf, 0x50ff, 0x53f2,
  0x53f8, 0x5506, 0x55e3, 0x56db, 0x58eb, 0x5962, 0x5a11, 0x5beb,
  0x5bfa, 0x5c04, 0x5df3, 0x5e2b, 0x5f99, 0x601d, 0x6368, 0x659c,
  0x65af, 0x67f6, 0x67fb, 0x68ad, 0x6b7b, 0x6c99, 0x6cd7, 0x6e23,
  0x7009, 0x7345, 0x7802, 0x793e, 0x7940, 0x7960, 0x79c1, 0x7be9,
  0x7d17, 0x7d72, 0x8086, 0x820d, 0x838e, 0x84d1, 0x86c7, 0x88df,
  0x8a50, 0x8a5e, 0x8b1d, 0x8cdc, 0x8d66, 0x8fad, 0x90aa, 0x98fc,
  0x99df, 0x9e9d, 0x524a, 0xf969, 0x6714, 0xf96a, 0x5098, 0x522a,
  0x5c71, 0x6563, 0x6c55, 0x73ca, 0x7523, 0x759d, 0x7b97, 0x849c,
  0x9178, 0x9730, 0x4e77, 0x6492, 0x6bba, 0x715e, 0x85a9, 0x4e09,
  0xf96b, 0x6749, 0x68ee, 0x6e17, 0x829f, 0x8518, 0x886b, 0x63f7,
  0x6f81, 0x9212, 0x98af, 0x4e0a, 0x50b7, 0x50cf, 0x511f, 0x5546,
  0x55aa, 0x5617, 0x5b40, 0x5c19, 0x5ce0, 0x5e38, 0x5e8a, 0x5ea0,
  0x5ec2, 0x60f3, 0x6851, 0x6a61, 0x6e58, 0x723d, 0x7240, 0x72c0,
  0x76f8, 0x7965, 0x7bb1, 0x7fd4, 0x88f3, 0x89f4, 0x8a73, 0x8c61,
  0x8cde, 0x971c, 0x585e, 0x74bd, 0x8cfd, 0x55c7, 0xf96c, 0x7a61,
  0x7d22, 0x8272, 0x7272, 0x751f, 0x7525, 0xf96d, 0x7b19, 0x5885,
  0x58fb, 0x5dbc, 0x5e8f, 0x5eb6, 0x5f90, 0x6055, 0x6292, 0x637f,
  0x654d, 0x6691, 0x66d9, 0x66f8, 0x6816, 0x68f2, 0x7280, 0x745e,
  0x7b6e, 0x7d6e, 0x7dd6, 0x7f72, 0x80e5, 0x8212, 0x85af, 0x897f,
  0x8a93, 0x901d, 0x92e4, 0x9ecd, 0x9f20, 0x5915, 0x596d, 0x5e2d,
  0x60dc, 0x6614, 0x6673, 0x6790, 0x6c50, 0x6dc5, 0x6f5f, 0x77f3,
  0x78a9, 0x84c6, 0x91cb, 0x932b, 0x4ed9, 0x50ca, 0x5148, 0x5584,
  0x5b0b, 0x5ba3, 0x6247, 0x657e, 0x65cb, 0x6e32, 0x717d, 0x7401,
  0x7444, 0x7487, 0x74bf, 0x766c, 0x79aa, 0x7dda, 0x7e55, 0x7fa8,
  0x817a, 0x81b3, 0x8239, 0x861a, 0x87ec, 0x8a75, 0x8de3, 0x9078,
  0x9291, 0x9425, 0x994d, 0x9bae, 0x5368, 0x5c51, 0x6954, 0x6cc4,
  0x6d29, 0x6e2b, 0x820c, 0x859b, 0x893b, 0x8a2d, 0x8aaa, 0x96ea,
  0x9f67, 0x5261, 0x66b9, 0x6bb2, 0x7e96, 0x87fe, 0x8d0d, 0x9583,
  0x965d, 0x651d, 0x6d89, 0x71ee, 0xf96e, 0x57ce, 0x59d3, 0x5bac,
  0x6027, 0x60fa, 0x6210, 0x661f, 0x665f, 0x7329, 0x73f9, 0x76db,
  0x7701, 0x7b6c, 0x8056, 0x8072, 0x8165, 0x8aa0, 0x9192, 0x4e16,
  0x52e2, 0x6b72, 0x6d17, 0x7a05, 0x7b39, 0x7d30, 0xf96f, 0x8cb0,
  0x53ec, 0x562f, 0x5851, 0x5bb5, 0x5c0f, 0x5c11, 0x5de2, 0x6240,
  0x6383, 0x6414, 0x662d, 0x68b3, 0x6cbc, 0x6d88, 0x6eaf, 0x701f,
  0x70a4, 0x71d2, 0x7526, 0x758f, 0x758e, 0x7619, 0x7b11, 0x7be0,
  0x7c2b, 0x7d20, 0x7d39, 0x852c, 0x856d, 0x8607, 0x8a34, 0x900d,
  0x9061, 0x90b5, 0x92b7, 0x97f6, 0x9a37, 0x4fd7, 0x5c6c, 0x675f,
  0x6d91, 0x7c9f, 0x7e8c, 0x8b16, 0x8d16, 0x901f, 0x5b6b, 0x5dfd,
  0x640d, 0x84c0, 0x905c, 0x98e1, 0x7387, 0x5b8b, 0x609a, 0x677e,
  0x6dde, 0x8a1f, 0x8aa6, 0x9001, 0x980c, 0x5237, 0xf970, 0x7051,
  0x788e, 0x9396, 0x8870, 0x91d7, 0x4fee, 0x53d7, 0x55fd, 0x56da,
  0x5782, 0x58fd, 0x5ac2, 0x5b88, 0x5cab, 0x5cc0, 0x5e25, 0x6101,
  0x620d, 0x624b, 0x6388, 0x641c, 0x6536, 0x6578, 0x6a39, 0x6b8a,
  0x6c34, 0x6d19, 0x6f31, 0x71e7, 0x72e9, 0x7378, 0x7407, 0x74b2,
  0x7626, 0x7761, 0x79c0, 0x7a57, 0x7aea, 0x7cb9, 0x7d8f, 0x7dac,
  0x7e61, 0x7f9e, 0x8129, 0x8331, 0x8490, 0x84da, 0x85ea, 0x8896,
  0x8ab0, 0x8b90, 0x8f38, 0x9042, 0x9083, 0x916c, 0x9296, 0x92b9,
  0x968b, 0x96a7, 0x96a8, 0x96d6, 0x9700, 0x9808, 0x9996, 0x9ad3,
  0x9b1a, 0x53d4, 0x587e, 0x5919, 0x5b70, 0x5bbf, 0x6dd1, 0x6f5a,
  0x719f, 0x7421, 0x74b9, 0x8085, 0x83fd, 0x5de1, 0x5f87, 0x5faa,
  0x6042, 0x65ec, 0x6812, 0x696f, 0x6a53, 0x6b89, 0x6d35, 0x6df3,
  0x73e3, 0x76fe, 0x77ac, 0x7b4d, 0x7d14, 0x8123, 0x821c, 0x8340,
  0x84f4, 0x8563, 0x8a62, 0x8ac4, 0x9187, 0x931e, 0x9806, 0x99b4,
  0x620c, 0x8853, 0x8ff0, 0x9265, 0x5d07, 0x5d27, 0x5d69, 0x745f,
  0x819d, 0x8768, 0x6fd5, 0x62fe, 0x7fd2, 0x8936, 0x8972, 0x4e1e,
  0x4e58, 0x50e7, 0x52dd, 0x5347, 0x627f, 0x6607, 0x7e69, 0x8805,
  0x965e, 0x4f8d, 0x5319, 0x5636, 0x59cb, 0x5aa4, 0x5c38, 0x5c4e,
  0x5c4d, 0x5e02, 0x5f11, 0x6043, 0x65bd, 0x662f, 0x6642, 0x67be,
  0x67f4, 0x731c, 0x77e2, 0x793a, 0x7fc5, 0x8494, 0x84cd, 0x8996,
  0x8a66, 0x8a69, 0x8ae1, 0x8c55, 0x8c7a, 0x57f4, 0x5bd4, 0x5f0f,
  0x606f, 0x62ed, 0x690d, 0x6b96, 0x6e5c, 0x7184, 0x7bd2, 0x8755,
  0x8b58, 0x8efe, 0x98df, 0x98fe, 0x4f38, 0x4f81, 0x4fe1, 0x547b,
  0x5a20, 0x5bb8, 0x613c, 0x65b0, 0x6668, 0x71fc, 0x7533, 0x795e,
  0x7d33, 0x814e, 0x81e3, 0x8398, 0x85aa, 0x85ce, 0x8703, 0x8a0a,
  0x8eab, 0x8f9b, 0xf971, 0x8fc5, 0x5931, 0x5ba4, 0x5be6, 0x6089,
  0x5be9, 0x5c0b, 0x5fc3, 0x6c81, 0xf972, 0x6df1, 0x700b, 0x751a,
  0x82af, 0x8af6, 0x4ec0, 0x5341, 0xf973, 0x96d9, 0x6c0f, 0x4e9e,
  0x4fc4, 0x5152, 0x555e, 0x5a25, 0x5ce8, 0x6211, 0x7259, 0x82bd,
  0x83aa, 0x86fe, 0x8859, 0x8a1d, 0x963f, 0x96c5, 0x9913, 0x9d09,
  0x9d5d, 0x580a, 0x5cb3, 0x5dbd, 0x5e44, 0x60e1, 0x6115, 0x63e1,
  0x6a02, 0x6e25, 0x9102, 0x9354, 0x984e, 0x9c10, 0x9f77, 0x5b89,
  0x5cb8, 0x6309, 0x664f, 0x6848, 0x773c, 0x96c1, 0x978d, 0x9854,
  0x9b9f, 0x65a1, 0x8b01, 0x8ecb, 0x95bc, 0x5535, 0x5ca9, 0x5dd6,
  0x5eb5, 0x6697, 0x764c, 0x83f4, 0x95c7, 0x58d3, 0x62bc, 0x72ce,
  0x9d28, 0x4ef0, 0x592e, 0x600f, 0x663b, 0x6b83, 0x79e7, 0x9d26,
  0x5393, 0x54c0, 0x57c3, 0x5d16, 0x611b, 0x66d6, 0x6daf, 0x788d,
  0x827e, 0x9698, 0x9744, 0x5384, 0x627c, 0x6396, 0x6db2, 0x7e0a,
  0x814b, 0x984d, 0x6afb, 0x7f4c, 0x9daf, 0x9e1a, 0x4e5f, 0x503b,
  0x51b6, 0x591c, 0x60f9, 0x63f6, 0x6930, 0x723a, 0x8036, 0xf974,
  0x91ce, 0x5f31, 0xf975, 0xf976, 0x7d04, 0x82e5, 0x846f, 0x84bb,
  0x85e5, 0x8e8d, 0xf977, 0x4f6f, 0xf978, 0xf979, 0x58e4, 0x5b43,
  0x6059, 0x63da, 0x6518, 0x656d, 0x6698, 0xf97a, 0x694a, 0x6a23,
  0x6d0b, 0x7001, 0x716c, 0x75d2, 0x760d, 0x79b3, 0x7a70, 0xf97b,
  0x7f8a, 0xf97c, 0x8944, 0xf97d, 0x8b93, 0x91c0, 0x967d, 0xf97e,
  0x990a, 0x5704, 0x5fa1, 0x65bc, 0x6f01, 0x7600, 0x79a6, 0x8a9e,
  0x99ad, 0x9b5a, 0x9f6c, 0x5104, 0x61b6, 0x6291, 0x6a8d, 0x81c6,
  0x5043, 0x5830, 0x5f66, 0x7109, 0x8a00, 0x8afa, 0x5b7c, 0x8616,
  0x4ffa, 0x513c, 0x56b4, 0x5944, 0x63a9, 0x6df9, 0x5daa, 0x696d,
  0x5186, 0x4e88, 0x4f59, 0xf97f, 0xf980, 0xf981, 0x5982, 0xf982,
  0xf983, 0x6b5f, 0x6c5d, 0xf984, 0x74b5, 0x7916, 0xf985, 0x8207,
  0x8245, 0x8339, 0x8f3f, 0x8f5d, 0xf986, 0x9918, 0xf987, 0xf988,
  0xf989, 0x4ea6, 0xf98a, 0x57df, 0x5f79, 0x6613, 0xf98b, 0xf98c,
  0x75ab, 0x7e79, 0x8b6f, 0xf98d, 0x9006, 0x9a5b, 0x56a5, 0x5827,
  0x59f8, 0x5a1f, 0x5bb4, 0xf98e, 0x5ef6, 0xf98f, 0xf990, 0x6350,
  0x633b, 0xf991, 0x693d, 0x6c87, 0x6cbf, 0x6d8e, 0x6d93, 0x6df5,
  0x6f14, 0xf992, 0x70df, 0x7136, 0x7159, 0xf993, 0x71c3, 0x71d5,
  0xf994, 0x784f, 0x786f, 0xf995, 0x7b75, 0x7de3, 0xf996, 0x7e2f,
  0xf997, 0x884d, 0x8edf, 0xf998, 0xf999, 0xf99a, 0x925b, 0xf99b,
  0x9cf6, 0xf99c, 0xf99d, 0xf99e, 0x6085, 0x6d85, 0xf99f, 0x71b1,
  0xf9a0, 0xf9a1, 0x95b1, 0x53ad, 0xf9a2, 0xf9a3, 0xf9a4, 0x67d3,
  0xf9a5, 0x708e, 0x7130, 0x7430, 0x8276, 0x82d2, 0xf9a6, 0x95bb,
  0x9ae5, 0x9e7d, 0x66c4, 0xf9a7, 0x71c1, 0x8449, 0xf9a8, 0xf9a9,
  0x584b, 0xf9aa, 0xf9ab, 0x5db8, 0x5f71, 0xf9ac, 0x6620, 0x668e,
  0x6979, 0x69ae, 0x6c38, 0x6cf3, 0x6e36, 0x6f41, 0x6fda, 0x701b,
  0x702f, 0x7150, 0x71df, 0x7370, 0xf9ad, 0x745b, 0xf9ae, 0x74d4,
  0x76c8, 0x7a4e, 0x7e93, 0xf9af, 0xf9b0, 0x82f1, 0x8a60, 0x8fce,
  0xf9b1, 0x9348, 0xf9b2, 0x9719, 0xf9b3, 0xf9b4, 0x4e42, 0x502a,
  0xf9b5, 0x5208, 0x53e1, 0x66f3, 0x6c6d, 0x6fca, 0x730a, 0x777f,
  0x7a62, 0x82ae, 0x85dd, 0x8602, 0xf9b6, 0x88d4, 0x8a63, 0x8b7d,
  0x8c6b, 0xf9b7, 0x92b3, 0xf9b8, 0x9713, 0x9810, 0x4e94, 0x4f0d,
  0x4fc9, 0x50b2, 0x5348, 0x543e, 0x5433, 0x55da, 0x5862, 0x58ba,
  0x5967, 0x5a1b, 0x5be4, 0x609f, 0xf9b9, 0x61ca, 0x6556, 0x65ff,
  0x6664, 0x68a7, 0x6c5a, 0x6fb3, 0x70cf, 0x71ac, 0x7352, 0x7b7d,
  0x8708, 0x8aa4, 0x9c32, 0x9f07, 0x5c4b, 0x6c83, 0x7344, 0x7389,
  0x923a, 0x6eab, 0x7465, 0x761f, 0x7a69, 0x7e15, 0x860a, 0x5140,
  0x58c5, 0x64c1, 0x74ee, 0x7515, 0x7670, 0x7fc1, 0x9095, 0x96cd,
  0x9954, 0x6e26, 0x74e6, 0x7aa9, 0x7aaa, 0x81e5, 0x86d9, 0x8778,
  0x8a1b, 0x5a49, 0x5b8c, 0x5b9b, 0x68a1, 0x6900, 0x6d63, 0x73a9,
  0x7413, 0x742c, 0x7897, 0x7de9, 0x7feb, 0x8118, 0x8155, 0x839e,
  0x8c4c, 0x962e, 0x9811, 0x66f0, 0x5f80, 0x65fa, 0x6789, 0x6c6a,
  0x738b, 0x502d, 0x5a03, 0x6b6a, 0x77ee, 0x5916, 0x5d6c, 0x5dcd,
  0x7325, 0x754f, 0xf9ba, 0xf9bb, 0x50e5, 0x51f9, 0x582f, 0x592d,
  0x5996, 0x59da, 0x5be5, 0xf9bc, 0xf9bd, 0x5da2, 0x62d7, 0x6416,
  0x6493, 0x64fe, 0xf9be, 0x66dc, 0xf9bf, 0x6a48, 0xf9c0, 0x71ff,
  0x7464, 0xf9c1, 0x7a88, 0x7aaf, 0x7e47, 0x7e5e, 0x8000, 0x8170,
  0xf9c2, 0x87ef, 0x8981, 0x8b20, 0x9059, 0xf9c3, 0x9080, 0x9952,
  0x617e, 0x6b32, 0x6d74, 0x7e1f, 0x8925, 0x8fb1, 0x4fd1, 0x50ad,
  0x5197, 0x52c7, 0x57c7, 0x5889, 0x5bb9, 0x5eb8, 0x6142, 0x6995,
  0x6d8c, 0x6e67, 0x6eb6, 0x7194, 0x7462, 0x7528, 0x752c, 0x8073,
  0x8338, 0x84c9, 0x8e0a, 0x9394, 0x93de, 0xf9c4, 0x4e8e, 0x4f51,
  0x5076, 0x512a, 0x53c8, 0x53cb, 0x53f3, 0x5b87, 0x5bd3, 0x5c24,
  0x611a, 0x6182, 0x65f4, 0x725b, 0x7397, 0x7440, 0x76c2, 0x7950,
  0x7991, 0x79b9, 0x7d06, 0x7fbd, 0x828b, 0x85d5, 0x865e, 0x8fc2,
  0x9047, 0x90f5, 0x91ea, 0x9685, 0x96e8, 0x96e9, 0x52d6, 0x5f67,
  0x65ed, 0x6631, 0x682f, 0x715c, 0x7a36, 0x90c1, 0x980a, 0x4e91,
  0xf9c5, 0x6a52, 0x6b9e, 0x6f90, 0x7189, 0x8018, 0x82b8, 0x8553,
  0x904b, 0x9695, 0x96f2, 0x97fb, 0x851a, 0x9b31, 0x4e90, 0x718a,
  0x96c4, 0x5143, 0x539f, 0x54e1, 0x5713, 0x5712, 0x57a3, 0x5a9b,
  0x5ac4, 0x5bc3, 0x6028, 0x613f, 0x63f4, 0x6c85, 0x6d39, 0x6e72,
  0x6e90, 0x7230, 0x733f, 0x7457, 0x82d1, 0x8881, 0x8f45, 0x9060,
  0xf9c6, 0x9662, 0x9858, 0x9d1b, 0x6708, 0x8d8a, 0x925e, 0x4f4d,
  0x5049, 0x50de, 0x5371, 0x570d, 0x59d4, 0x5a01, 0x5c09, 0x6170,
  0x6690, 0x6e2d, 0x7232, 0x744b, 0x7def, 0x80c3, 0x840e, 0x8466,
  0x853f, 0x875f, 0x885b, 0x8918, 0x8b02, 0x9055, 0x97cb, 0x9b4f,
  0x4e73, 0x4f91, 0x5112, 0x516a, 0xf9c7, 0x552f, 0x55a9, 0x5b7a,
  0x5ba5, 0x5e7c, 0x5e7d, 0x5ebe, 0x60a0, 0x60df, 0x6108, 0x6109,
  0x63c4, 0x6538, 0x6709, 0xf9c8, 0x67d4, 0x67da, 0xf9c9, 0x6961,
  0x6962, 0x6cb9, 0x6d27, 0xf9ca, 0x6e38, 0xf9cb, 0x6fe1, 0x7336,
  0x7337, 0xf9cc, 0x745c, 0x7531, 0xf9cd, 0x7652, 0xf9ce, 0xf9cf,
  0x7dad, 0x81fe, 0x8438, 0x88d5, 0x8a98, 0x8adb, 0x8aed, 0x8e30,
  0x8e42, 0x904a, 0x903e, 0x907a, 0x9149, 0x91c9, 0x936e, 0xf9d0,
  0xf9d1, 0x5809, 0xf9d2, 0x6bd3, 0x8089, 0x80b2, 0xf9d3, 0xf9d4,
  0x5141, 0x596b, 0x5c39, 0xf9d5, 0xf9d6, 0x6f64, 0x73a7, 0x80e4,
  0x8d07, 0xf9d7, 0x9217, 0x958f, 0xf9d8, 0xf9d9, 0xf9da, 0xf9db,
  0x807f, 0x620e, 0x701c, 0x7d68, 0x878d, 0xf9dc, 0x57a0, 0x6069,
  0x6147, 0x6bb7, 0x8abe, 0x9280, 0x96b1, 0x4e59, 0x541f, 0x6deb,
  0x852d, 0x9670, 0x97f3, 0x98ee, 0x63d6, 0x6ce3, 0x9091, 0x51dd,
  0x61c9, 0x81ba, 0x9df9, 0x4f9d, 0x501a, 0x5100, 0x5b9c, 0x610f,
  0x61ff, 0x64ec, 0x6905, 0x6bc5, 0x7591, 0x77e3, 0x7fa9, 0x8264,
  0x858f, 0x87fb, 0x8863, 0x8abc, 0x8b70, 0x91ab, 0x4e8c, 0x4ee5,
  0x4f0a, 0xf9dd, 0xf9de, 0x5937, 0x59e8, 0xf9df, 0x5df2, 0x5f1b,
  0x5f5b, 0x6021, 0xf9e0, 0xf9e1, 0xf9e2, 0xf9e3, 0x723e, 0x73e5,
  0xf9e4, 0x7570, 0x75cd, 0xf9e5, 0x79fb, 0xf9e6, 0x800c, 0x8033,
  0x8084, 0x82e1, 0x8351, 0xf9e7, 0xf9e8, 0x8cbd, 0x8cb3, 0x9087,
  0xf9e9, 0xf9ea, 0x98f4, 0x990c, 0xf9eb, 0xf9ec, 0x7037, 0x76ca,
  0x7fca, 0x7fcc, 0x7ffc, 0x8b1a, 0x4eba, 0x4ec1, 0x5203, 0x5370,
  0xf9ed, 0x54bd, 0x56e0, 0x59fb, 0x5bc5, 0x5f15, 0x5fcd, 0x6e6e,
  0xf9ee, 0xf9ef, 0x7d6a, 0x8335, 0xf9f0, 0x8693, 0x8a8d, 0xf9f1,
  0x976d, 0x9777, 0xf9f2, 0xf9f3, 0x4e00, 0x4f5a, 0x4f7e, 0x58f9,
  0x65e5, 0x6ea2, 0x9038, 0x93b0, 0x99b9, 0x4efb, 0x58ec, 0x598a,
  0x59d9, 0x6041, 0xf9f4, 0xf9f5, 0x7a14, 0xf9f6, 0x834f, 0x8cc3,
  0x5165, 0x5344, 0xf9f7, 0xf9f8, 0xf9f9, 0x4ecd, 0x5269, 0x5b55,
  0x82bf, 0x4ed4, 0x523a, 0x54a8, 0x59c9, 0x59ff, 0x5b50, 0x5b57,
  0x5b5c, 0x6063, 0x6148, 0x6ecb, 0x7099, 0x716e, 0x7386, 0x74f7,
  0x75b5, 0x78c1, 0x7d2b, 0x8005, 0x81ea, 0x8328, 0x8517, 0x85c9,
  0x8aee, 0x8cc7, 0x96cc, 0x4f5c, 0x52fa, 0x56bc, 0x65ab, 0x6628,
  0x707c, 0x70b8, 0x7235, 0x7dbd, 0x828d, 0x914c, 0x96c0, 0x9d72,
  0x5b71, 0x68e7, 0x6b98, 0x6f7a, 0x76de, 0x5c91, 0x66ab, 0x6f5b,
  0x7bb4, 0x7c2a, 0x8836, 0x96dc, 0x4e08, 0x4ed7, 0x5320, 0x5834,
  0x58bb, 0x58ef, 0x596c, 0x5c07, 0x5e33, 0x5e84, 0x5f35, 0x638c,
  0x66b2, 0x6756, 0x6a1f, 0x6aa3, 0x6b0c, 0x6f3f, 0x7246, 0xf9fa,
  0x7350, 0x748b, 0x7ae0, 0x7ca7, 0x8178, 0x81df, 0x81e7, 0x838a,
  0x846c, 0x8523, 0x8594, 0x85cf, 0x88dd, 0x8d13, 0x91ac, 0x9577,
  0x969c, 0x518d, 0x54c9, 0x5728, 0x5bb0, 0x624d, 0x6750, 0x683d,
  0x6893, 0x6e3d, 0x6ed3, 0x707d, 0x7e21, 0x88c1, 0x8ca1, 0x8f09,
  0x9f4b, 0x9f4e, 0x722d, 0x7b8f, 0x8acd, 0x931a, 0x4f47, 0x4f4e,
  0x5132, 0x5480, 0x59d0, 0x5e95, 0x62b5, 0x6775, 0x696e, 0x6a17,
  0x6cae, 0x6e1a, 0x72d9, 0x732a, 0x75bd, 0x7bb8, 0x7d35, 0x82e7,
  0x83f9, 0x8457, 0x85f7, 0x8a5b, 0x8caf, 0x8e87, 0x9019, 0x90b8,
  0x96ce, 0x9f5f, 0x52e3, 0x540a, 0x5ae1, 0x5bc2, 0x6458, 0x6575,
  0x6ef4, 0x72c4, 0xf9fb, 0x7684, 0x7a4d, 0x7b1b, 0x7c4d, 0x7e3e,
  0x7fdf, 0x837b, 0x8b2b, 0x8cca, 0x8d64, 0x8de1, 0x8e5f, 0x8fea,
  0x8ff9, 0x9069, 0x93d1, 0x4f43, 0x4f7a, 0x50b3, 0x5168, 0x5178,
  0x524d, 0x526a, 0x5861, 0x587c, 0x5960, 0x5c08, 0x5c55, 0x5edb,
  0x609b, 0x6230, 0x6813, 0x6bbf, 0x6c08, 0x6fb1, 0x714e, 0x7420,
  0x7530, 0x7538, 0x7551, 0x7672, 0x7b4c, 0x7b8b, 0x7bad, 0x7bc6,
  0x7e8f, 0x8a6e, 0x8f3e, 0x8f49, 0x923f, 0x9293, 0x9322, 0x942b,
  0x96fb, 0x985a, 0x986b, 0x991e, 0x5207, 0x622a, 0x6298, 0x6d59,
  0x7664, 0x7aca, 0x7bc0, 0x7d76, 0x5360, 0x5cbe, 0x5e97, 0x6f38,
  0x70b9, 0x7c98, 0x9711, 0x9b8e, 0x9ede, 0x63a5, 0x647a, 0x8776,
  0x4e01, 0x4e95, 0x4ead, 0x505c, 0x5075, 0x5448, 0x59c3, 0x5b9a,
  0x5e40, 0x5ead, 0x5ef7, 0x5f81, 0x60c5, 0x633a, 0x653f, 0x6574,
  0x65cc, 0x6676, 0x6678, 0x67fe, 0x6968, 0x6a89, 0x6b63, 0x6c40,
  0x6dc0, 0x6de8, 0x6e1f, 0x6e5e, 0x701e, 0x70a1, 0x738e, 0x73fd,
  0x753a, 0x775b, 0x7887, 0x798e, 0x7a0b, 0x7a7d, 0x7cbe, 0x7d8e,
  0x8247, 0x8a02, 0x8aea, 0x8c9e, 0x912d, 0x914a, 0x91d8, 0x9266,
  0x92cc, 0x9320, 0x9706, 0x9756, 0x975c, 0x9802, 0x9f0e, 0x5236,
  0x5291, 0x557c, 0x5824, 0x5e1d, 0x5f1f, 0x608c, 0x63d0, 0x68af,
  0x6fdf, 0x796d, 0x7b2c, 0x81cd, 0x85ba, 0x88fd, 0x8af8, 0x8e44,
  0x918d, 0x9664, 0x969b, 0x973d, 0x984c, 0x9f4a, 0x4fce, 0x5146,
  0x51cb, 0x52a9, 0x5632, 0x5f14, 0x5f6b, 0x63aa, 0x64cd, 0x65e9,
  0x6641, 0x66fa, 0x66f9, 0x671d, 0x689d, 0x68d7, 0x69fd, 0x6f15,
  0x6f6e, 0x7167, 0x71e5, 0x722a, 0x74aa, 0x773a, 0x7956, 0x795a,
  0x79df, 0x7a20, 0x7a95, 0x7c97, 0x7cdf, 0x7d44, 0x7e70, 0x8087,
  0x85fb, 0x86a4, 0x8a54, 0x8abf, 0x8d99, 0x8e81, 0x9020, 0x906d,
  0x91e3, 0x963b, 0x96d5, 0x9ce5, 0x65cf, 0x7c07, 0x8db3, 0x93c3,
  0x5b58, 0x5c0a, 0x5352, 0x62d9, 0x731d, 0x5027, 0x5b97, 0x5f9e,
  0x60b0, 0x616b, 0x68d5, 0x6dd9, 0x742e, 0x7a2e, 0x7d42, 0x7d9c,
  0x7e31, 0x816b, 0x8e2a, 0x8e35, 0x937e, 0x9418, 0x4f50, 0x5750,
  0x5de6, 0x5ea7, 0x632b, 0x7f6a, 0x4e3b, 0x4f4f, 0x4f8f, 0x505a,
  0x59dd, 0x80c4, 0x546a, 0x5468, 0x55fe, 0x594f, 0x5b99, 0x5dde,
  0x5eda, 0x665d, 0x6731, 0x67f1, 0x682a, 0x6ce8, 0x6d32, 0x6e4a,
  0x6f8d, 0x70b7, 0x73e0, 0x7587, 0x7c4c, 0x7d02, 0x7d2c, 0x7da2,
  0x821f, 0x86db, 0x8a3b, 0x8a85, 0x8d70, 0x8e8a, 0x8f33, 0x9031,
  0x914e, 0x9152, 0x9444, 0x99d0, 0x7af9, 0x7ca5, 0x4fca, 0x5101,
  0x51c6, 0x57c8, 0x5bef, 0x5cfb, 0x6659, 0x6a3d, 0x6d5a, 0x6e96,
  0x6fec, 0x710c, 0x756f, 0x7ae3, 0x8822, 0x9021, 0x9075, 0x96cb,
  0x99ff, 0x8301, 0x4e2d, 0x4ef2, 0x8846, 0x91cd, 0x537d, 0x6adb,
  0x696b, 0x6c41, 0x847a, 0x589e, 0x618e, 0x66fe, 0x62ef, 0x70dd,
  0x7511, 0x75c7, 0x7e52, 0x84b8, 0x8b49, 0x8d08, 0x4e4b, 0x53ea,
  0x54ab, 0x5730, 0x5740, 0x5fd7, 0x6301, 0x6307, 0x646f, 0x652f,
  0x65e8, 0x667a, 0x679d, 0x67b3, 0x6b62, 0x6c60, 0x6c9a, 0x6f2c,
  0x77e5, 0x7825, 0x7949, 0x7957, 0x7d19, 0x80a2, 0x8102, 0x81f3,
  0x829d, 0x82b7, 0x8718, 0x8a8c, 0xf9fc, 0x8d04, 0x8dbe, 0x9072,
  0x76f4, 0x7a19, 0x7a37, 0x7e54, 0x8077, 0x5507, 0x55d4, 0x5875,
  0x632f, 0x6422, 0x6649, 0x664b, 0x686d, 0x699b, 0x6b84, 0x6d25,
  0x6eb1, 0x73cd, 0x7468, 0x74a1, 0x755b, 0x75b9, 0x76e1, 0x771e,
  0x778b, 0x79e6, 0x7e09, 0x7e1d, 0x81fb, 0x852f, 0x8897, 0x8a3a,
  0x8cd1, 0x8eeb, 0x8fb0, 0x9032, 0x93ad, 0x9663, 0x9673, 0x9707,
  0x4f84, 0x53f1, 0x59ea, 0x5ac9, 0x5e19, 0x684e, 0x74c6, 0x75be,
  0x79e9, 0x7a92, 0x81a3, 0x86ed, 0x8cea, 0x8dcc, 0x8fed, 0x659f,
  0x6715, 0xf9fd, 0x57f7, 0x6f57, 0x7ddd, 0x8f2f, 0x93f6, 0x96c6,
  0x5fb5, 0x61f2, 0x6f84, 0x4e14, 0x4f98, 0x501f, 0x53c9, 0x55df,
  0x5d6f, 0x5dee, 0x6b21, 0x6b64, 0x78cb, 0x7b9a, 0xf9fe, 0x8e49,
  0x8eca, 0x906e, 0x6349, 0x643e, 0x7740, 0x7a84, 0x932f, 0x947f,
  0x9f6a, 0x64b0, 0x6faf, 0x71e6, 0x74a8, 0x74da, 0x7ac4, 0x7c12,
  0x7e82, 0x7cb2, 0x7e98, 0x8b9a, 0x8d0a, 0x947d, 0x9910, 0x994c,
  0x5239, 0x5bdf, 0x64e6, 0x672d, 0x7d2e, 0x50ed, 0x53c3, 0x5879,
  0x6158, 0x6159, 0x61fa, 0x65ac, 0x7ad9, 0x8b92, 0x8b96, 0x5009,
  0x5021, 0x5275, 0x5531, 0x5a3c, 0x5ee0, 0x5f70, 0x6134, 0x655e,
  0x660c, 0x6636, 0x66a2, 0x69cd, 0x6ec4, 0x6f32, 0x7316, 0x7621,
  0x7a93, 0x8139, 0x8259, 0x83d6, 0x84bc, 0x50b5, 0x57f0, 0x5bc0,
  0x5be8, 0x5f69, 0x63a1, 0x7826, 0x7db5, 0x83dc, 0x8521, 0x91c7,
  0x91f5, 0x518a, 0x67f5, 0x7b56, 0x8cac, 0x51c4, 0x59bb, 0x60bd,
  0x8655, 0x501c, 0xf9ff, 0x5254, 0x5c3a, 0x617d, 0x621a, 0x62d3,
  0x64f2, 0x65a5, 0x6ecc, 0x7620, 0x810a, 0x8e60, 0x965f, 0x96bb,
  0x4edf, 0x5343, 0x5598, 0x5929, 0x5ddd, 0x64c5, 0x6cc9, 0x6dfa,
  0x7394, 0x7a7f, 0x821b, 0x85a6, 0x8ce4, 0x8e10, 0x9077, 0x91e7,
  0x95e1, 0x9621, 0x97c6, 0x51f8, 0x54f2, 0x5586, 0x5fb9, 0x64a4,
  0x6f88, 0x7db4, 0x8f1f, 0x8f4d, 0x9435, 0x50c9, 0x5c16, 0x6cbe,
  0x6dfb, 0x751b, 0x77bb, 0x7c3d, 0x7c64, 0x8a79, 0x8ac2, 0x581e,
  0x59be, 0x5e16, 0x6377, 0x7252, 0x758a, 0x776b, 0x8adc, 0x8cbc,
  0x8f12, 0x5ef3, 0x6674, 0x6df8, 0x807d, 0x83c1, 0x8acb, 0x9751,
  0x9bd6, 0xfa00, 0x5243, 0x66ff, 0x6d95, 0x6eef, 0x7de0, 0x8ae6,
  0x902e, 0x905e, 0x9ad4, 0x521d, 0x527f, 0x54e8, 0x6194, 0x6284,
  0x62db, 0x68a2, 0x6912, 0x695a, 0x6a35, 0x7092, 0x7126, 0x785d,
  0x7901, 0x790e, 0x79d2, 0x7a0d, 0x8096, 0x8278, 0x82d5, 0x8349,
  0x8549, 0x8c82, 0x8d85, 0x9162, 0x918b, 0x91ae, 0x4fc3, 0x56d1,
  0x71ed, 0x77d7, 0x8700, 0x89f8, 0x5bf8, 0x5fd6, 0x6751, 0x90a8,
  0x53e2, 0x585a, 0x5bf5, 0x60a4, 0x6181, 0x6460, 0x7e3d, 0x8070,
  0x8525, 0x9283, 0x64ae, 0x50ac, 0x5d14, 0x6700, 0x589c, 0x62bd,
  0x63a8, 0x690e, 0x6978, 0x6a1e, 0x6e6b, 0x76ba, 0x79cb, 0x82bb,
  0x8429, 0x8acf, 0x8da8, 0x8ffd, 0x9112, 0x914b, 0x919c, 0x9310,
  0x9318, 0x939a, 0x96db, 0x9a36, 0x9c0d, 0x4e11, 0x755c, 0x795d,
  0x7afa, 0x7b51, 0x7bc9, 0x7e2e, 0x84c4, 0x8e59, 0x8e74, 0x8ef8,
  0x9010, 0x6625, 0x693f, 0x7443, 0x51fa, 0x672e, 0x9edc, 0x5145,
  0x5fe0, 0x6c96, 0x87f2, 0x885d, 0x8877, 0x60b4, 0x81b5, 0x8403,
  0x8d05, 0x53d6, 0x5439, 0x5634, 0x5a36, 0x5c31, 0x708a, 0x7fe0,
  0x805a, 0x8106, 0x81ed, 0x8da3, 0x9189, 0x9a5f, 0x9df2, 0x5074,
  0x4ec4, 0x53a0, 0x60fb, 0x6e2c, 0x5c64, 0x4f88, 0x5024, 0x55e4,
  0x5cd9, 0x5e5f, 0x6065, 0x6894, 0x6cbb, 0x6dc4, 0x71be, 0x75d4,
  0x75f4, 0x7661, 0x7a1a, 0x7a49, 0x7dc7, 0x7dfb, 0x7f6e, 0x81f4,
  0x86a9, 0x8f1c, 0x96c9, 0x99b3, 0x9f52, 0x5247, 0x52c5, 0x98ed,
  0x89aa, 0x4e03, 0x67d2, 0x6f06, 0x4fb5, 0x5be2, 0x6795, 0x6c88,
  0x6d78, 0x741b, 0x7827, 0x91dd, 0x937c, 0x87c4, 0x79e4, 0x7a31,
  0x5feb, 0x4ed6, 0x54a4, 0x553e, 0x58ae, 0x59a5, 0x60f0, 0x6253,
  0x62d6, 0x6736, 0x6955, 0x8235, 0x9640, 0x99b1, 0x99dd, 0x502c,
  0x5353, 0x5544, 0x577c, 0xfa01, 0x6258, 0xfa02, 0x64e2, 0x666b,
  0x67dd, 0x6fc1, 0x6fef, 0x7422, 0x7438, 0x8a17, 0x9438, 0x5451,
  0x5606, 0x5766, 0x5f48, 0x619a, 0x6b4e, 0x7058, 0x70ad, 0x7dbb,
  0x8a95, 0x596a, 0x812b, 0x63a2, 0x7708, 0x803d, 0x8caa, 0x5854,
  0x642d, 0x69bb, 0x5b95, 0x5e11, 0x6e6f, 0xfa03, 0x8569, 0x514c,
  0x53f0, 0x592a, 0x6020, 0x614b, 0x6b86, 0x6c70, 0x6cf0, 0x7b1e,
  0x80ce, 0x82d4, 0x8dc6, 0x90b0, 0x98b1, 0xfa04, 0x64c7, 0x6fa4,
  0x6491, 0x6504, 0x514e, 0x5410, 0x571f, 0x8a0e, 0x615f, 0x6876,
  0xfa05, 0x75db, 0x7b52, 0x7d71, 0x901a, 0x5806, 0x69cc, 0x817f,
  0x892a, 0x9000, 0x9839, 0x5078, 0x5957, 0x59ac, 0x6295, 0x900f,
  0x9b2a, 0x615d, 0x7279, 0x95d6, 0x5761, 0x5a46, 0x5df4, 0x628a,
  0x64ad, 0x64fa, 0x6777, 0x6ce2, 0x6d3e, 0x722c, 0x7436, 0x7834,
  0x7f77, 0x82ad, 0x8ddb, 0x9817, 0x5224, 0x5742, 0x677f, 0x7248,
  0x74e3, 0x8ca9, 0x8fa6, 0x9211, 0x962a, 0x516b, 0x53ed, 0x634c,
  0x4f69, 0x5504, 0x6096, 0x6557, 0x6c9b, 0x6d7f, 0x724c, 0x72fd,
  0x7a17, 0x8987, 0x8c9d, 0x5f6d, 0x6f8e, 0x70f9, 0x81a8, 0x610e,
  0x4fbf, 0x504f, 0x6241, 0x7247, 0x7bc7, 0x7de8, 0x7fe9, 0x904d,
  0x97ad, 0x9a19, 0x8cb6, 0x576a, 0x5e73, 0x67b0, 0x840d, 0x8a55,
  0x5420, 0x5b16, 0x5e63, 0x5ee2, 0x5f0a, 0x6583, 0x80ba, 0x853d,
  0x9589, 0x965b, 0x4f48, 0x5305, 0x530d, 0x530f, 0x5486, 0x54fa,
  0x5703, 0x5e03, 0x6016, 0x629b, 0x62b1, 0x6355, 0xfa06, 0x6ce1,
  0x6d66, 0x75b1, 0x7832, 0x80de, 0x812f, 0x82de, 0x8461, 0x84b2,
  0x888d, 0x8912, 0x900b, 0x92ea, 0x98fd, 0x9b91, 0x5e45, 0x66b4,
  0x66dd, 0x7011, 0x7206, 0xfa07, 0x4ff5, 0x527d, 0x5f6a, 0x6153,
  0x6753, 0x6a19, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8c79, 0x98c7,
  0x98c4, 0x9a43, 0x54c1, 0x7a1f, 0x6953, 0x8af7, 0x8c4a, 0x98a8,
  0x99ae, 0x5f7c, 0x62ab, 0x75b2, 0x76ae, 0x88ab, 0x907f, 0x9642,
  0x5339, 0x5f3c, 0x5fc5, 0x6ccc, 0x73cc, 0x7562, 0x758b, 0x7b46,
  0x82fe, 0x999d, 0x4e4f, 0x903c, 0x4e0b, 0x4f55, 0x53a6, 0x590f,
  0x5ec8, 0x6630, 0x6cb3, 0x7455, 0x8377, 0x8766, 0x8cc0, 0x9050,
  0x971e, 0x9c15, 0x58d1, 0x5b78, 0x8650, 0x8b14, 0x9db4, 0x5bd2,
  0x6068, 0x608d, 0x65f1, 0x6c57, 0x6f22, 0x6fa3, 0x701a, 0x7f55,
  0x7ff0, 0x9591, 0x9592, 0x9650, 0x97d3, 0x5272, 0x8f44, 0x51fd,
  0x542b, 0x54b8, 0x5563, 0x558a, 0x6abb, 0x6db5, 0x7dd8, 0x8266,
  0x929c, 0x9677, 0x9e79, 0x5408, 0x54c8, 0x76d2, 0x86e4, 0x95a4,
  0x95d4, 0x965c, 0x4ea2, 0x4f09, 0x59ee, 0x5ae6, 0x5df7, 0x6052,
  0x6297, 0x676d, 0x6841, 0x6c86, 0x6e2f, 0x7f38, 0x809b, 0x822a,
  0xfa08, 0xfa09, 0x9805, 0x4ea5, 0x5055, 0x54b3, 0x5793, 0x595a,
  0x5b69, 0x5bb3, 0x61c8, 0x6977, 0x6d77, 0x7023, 0x87f9, 0x89e3,
  0x8a72, 0x8ae7, 0x9082, 0x99ed, 0x9ab8, 0x52be, 0x6838, 0x5016,
  0x5e78, 0x674f, 0x8347, 0x884c, 0x4eab, 0x5411, 0x56ae, 0x73e6,
  0x9115, 0x97ff, 0x9909, 0x9957, 0x9999, 0x5653, 0x589f, 0x865b,
  0x8a31, 0x61b2, 0x6af6, 0x737b, 0x8ed2, 0x6b47, 0x96aa, 0x9a57,
  0x5955, 0x7200, 0x8d6b, 0x9769, 0x4fd4, 0x5cf4, 0x5f26, 0x61f8,
  0x665b, 0x6ceb, 0x70ab, 0x7384, 0x73b9, 0x73fe, 0x7729, 0x774d,
  0x7d43, 0x7d62, 0x7e23, 0x8237, 0x8852, 0xfa0a, 0x8ce2, 0x9249,
  0x986f, 0x5b51, 0x7a74, 0x8840, 0x9801, 0x5acc, 0x4fe0, 0x5354,
  0x593e, 0x5cfd, 0x633e, 0x6d79, 0x72f9, 0x8105, 0x8107, 0x83a2,
  0x92cf, 0x9830, 0x4ea8, 0x5144, 0x5211, 0x578b, 0x5f62, 0x6cc2,
  0x6ece, 0x7005, 0x7050, 0x70af, 0x7192, 0x73e9, 0x7469, 0x834a,
  0x87a2, 0x8861, 0x9008, 0x90a2, 0x93a3, 0x99a8, 0x516e, 0x5f57,
  0x60e0, 0x6167, 0x66b3, 0x8559, 0x8e4a, 0x91af, 0x978b, 0x4e4e,
  0x4e92, 0x547c, 0x58d5, 0x58fa, 0x597d, 0x5cb5, 0x5f27, 0x6236,
  0x6248, 0x660a, 0x6667, 0x6beb, 0x6d69, 0x6dcf, 0x6e56, 0x6ef8,
  0x6f94, 0x6fe0, 0x6fe9, 0x705d, 0x72d0, 0x7425, 0x745a, 0x74e0,
  0x7693, 0x795c, 0x7cca, 0x7e1e, 0x80e1, 0x82a6, 0x846b, 0x84bf,
  0x864e, 0x865f, 0x8774, 0x8b77, 0x8c6a, 0x93ac, 0x9800, 0x9865,
  0x60d1, 0x6216, 0x9177, 0x5a5a, 0x660f, 0x6df7, 0x6e3e, 0x743f,
  0x9b42, 0x5ffd, 0x60da, 0x7b0f, 0x54c4, 0x5f18, 0x6c5e, 0x6cd3,
  0x6d2a, 0x70d8, 0x7d05, 0x8679, 0x8a0c, 0x9d3b, 0x5316, 0x548c,
  0x5b05, 0x6a3a, 0x706b, 0x7575, 0x798d, 0x79be, 0x82b1, 0x83ef,
  0x8a71, 0x8b41, 0x8ca8, 0x9774, 0xfa0b, 0x64f4, 0x652b, 0x78ba,
  0x78bb, 0x7a6b, 0x4e38, 0x559a, 0x5950, 0x5ba6, 0x5e7b, 0x60a3,
  0x63db, 0x6b61, 0x6665, 0x6853, 0x6e19, 0x7165, 0x74b0, 0x7d08,
  0x9084, 0x9a69, 0x9c25, 0x6d3b, 0x6ed1, 0x733e, 0x8c41, 0x95ca,
  0x51f0, 0x5e4c, 0x5fa8, 0x604d, 0x60f6, 0x6130, 0x614c, 0x6643,
  0x6644, 0x69a5, 0x6cc1, 0x6e5f, 0x6ec9, 0x6f62, 0x714c, 0x749c,
  0x7687, 0x7bc1, 0x7c27, 0x8352, 0x8757, 0x9051, 0x968d, 0x9ec3,
  0x532f, 0x56de, 0x5efb, 0x5f8a, 0x6062, 0x6094, 0x61f7, 0x6666,
  0x6703, 0x6a9c, 0x6dee, 0x6fae, 0x7070, 0x736a, 0x7e6a, 0x81be,
  0x8334, 0x86d4, 0x8aa8, 0x8cc4, 0x5283, 0x7372, 0x5b96, 0x6a6b,
  0x9404, 0x54ee, 0x5686, 0x5b5d, 0x6548, 0x6585, 0x66c9, 0x689f,
  0x6d8d, 0x6dc6, 0x723b, 0x80b4, 0x9175, 0x9a4d, 0x4faf, 0x5019,
  0x539a, 0x540e, 0x543c, 0x5589, 0x55c5, 0x5e3f, 0x5f8c, 0x673d,
  0x7166, 0x73dd, 0x9005, 0x52db, 0x52f3, 0x5864, 0x58ce, 0x7104,
  0x718f, 0x71fb, 0x85b0, 0x8a13, 0x6688, 0x85a8, 0x55a7, 0x6684,
  0x714a, 0x8431, 0x5349, 0x5599, 0x6bc1, 0x5f59, 0x5fbd, 0x63ee,
  0x6689, 0x7147, 0x8af1, 0x8f1d, 0x9ebe, 0x4f11, 0x643a, 0x70cb,
  0x7566, 0x8667, 0x6064, 0x8b4e, 0x9df8, 0x5147, 0x51f6, 0x5308,
  0x6d36, 0x80f8, 0x9ed1, 0x6615, 0x6b23, 0x7098, 0x75d5, 0x5403,
  0x5c79, 0x7d07, 0x8a16, 0x6b20, 0x6b3d, 0x6b46, 0x5438, 0x6070,
  0x6d3d, 0x7fd5, 0x8208, 0x50d6, 0x51de, 0x559c, 0x566b, 0x56cd,
  0x59ec, 0x5b09, 0x5e0c, 0x6199, 0x6198, 0x6231, 0x665e, 0x66e6,
  0x7199, 0x71b9, 0x71ba, 0x72a7, 0x79a7, 0x7a00, 0x7fb2, 0x8a70
};

/*
egrep  '^0x.*# <CJK>' < /cdrom/unix/mappings/eastasia/ksc/ksc5601.txt | \
awk '{print $2,$1}' | sort -u | perl tab12.pl > ksc_hanja2.tb

   $n=0;
   print " ";
   while (<>) {
     local($ucs4, $ksc, %rest) = split;
     local($u)=hex($ucs4);
     local($k)=hex($ksc);
     local($ku)=int(($k - 0xa1a1) / 256) * 94 + (($k - 0xa1a1) & 0xff);
     local($h)=0x21+int($ku/0x5e);
     local($l)=0x21+int($ku%0x5e);
     $n++;
     printf (" {0x%04x, \"\\x%x\\x%x\"},", $u, $h, $l);
     print "\n " if $n %3 == 0;
   }
   print "\n";

*/

const struct map __ksc5601_hanja_from_ucs[KSC5601_HANJA] =
{
  {0x4e00, "\x6c\x69"}, {0x4e01, "\x6f\x4b"}, {0x4e03, "\x76\x52"},
  {0x4e07, "\x58\x32"}, {0x4e08, "\x6d\x5b"}, {0x4e09, "\x5f\x32"},
  {0x4e0a, "\x5f\x3e"}, {0x4e0b, "\x79\x3b"}, {0x4e0d, "\x5c\x74"},
  {0x4e11, "\x75\x64"}, {0x4e14, "\x73\x26"}, {0x4e15, "\x5d\x60"},
  {0x4e16, "\x61\x26"}, {0x4e18, "\x4e\x78"}, {0x4e19, "\x5c\x30"},
  {0x4e1e, "\x63\x2a"}, {0x4e2d, "\x71\x69"}, {0x4e32, "\x4d\x7a"},
  {0x4e38, "\x7c\x2f"}, {0x4e39, "\x53\x21"}, {0x4e3b, "\x71\x2b"},
  {0x4e42, "\x67\x51"}, {0x4e43, "\x52\x2c"}, {0x4e45, "\x4e\x79"},
  {0x4e4b, "\x71\x7d"}, {0x4e4d, "\x5e\x3f"}, {0x4e4e, "\x7b\x3a"},
  {0x4e4f, "\x79\x39"}, {0x4e56, "\x4e\x52"}, {0x4e58, "\x63\x2b"},
  {0x4e59, "\x6b\x60"}, {0x4e5d, "\x4e\x7a"}, {0x4e5e, "\x4b\x77"},
  {0x4e5f, "\x65\x25"}, {0x4e6b, "\x4a\x61"}, {0x4e6d, "\x54\x4c"},
  {0x4e73, "\x6a\x61"}, {0x4e76, "\x5c\x63"}, {0x4e77, "\x5f\x2d"},
  {0x4e7e, "\x4b\x6b"}, {0x4e82, "\x55\x2f"}, {0x4e86, "\x56\x75"},
  {0x4e88, "\x65\x78"}, {0x4e8b, "\x5e\x40"}, {0x4e8c, "\x6c\x23"},
  {0x4e8e, "\x69\x4d"}, {0x4e90, "\x6a\x27"}, {0x4e91, "\x69\x76"},
  {0x4e92, "\x7b\x3b"}, {0x4e94, "\x67\x69"}, {0x4e95, "\x6f\x4c"},
  {0x4e98, "\x50\x66"}, {0x4e9b, "\x5e\x41"}, {0x4e9e, "\x64\x2c"},
  {0x4ea1, "\x58\x4c"}, {0x4ea2, "\x79\x71"}, {0x4ea4, "\x4e\x5f"},
  {0x4ea5, "\x7a\x24"}, {0x4ea6, "\x66\x32"}, {0x4ea8, "\x7a\x7b"},
  {0x4eab, "\x7a\x3d"}, {0x4eac, "\x4c\x48"}, {0x4ead, "\x6f\x4d"},
  {0x4eae, "\x55\x55"}, {0x4eb6, "\x53\x22"}, {0x4eba, "\x6c\x51"},
  {0x4ec0, "\x64\x27"}, {0x4ec1, "\x6c\x52"}, {0x4ec4, "\x76\x31"},
  {0x4ec7, "\x4e\x7b"}, {0x4eca, "\x50\x51"}, {0x4ecb, "\x4b\x3f"},
  {0x4ecd, "\x6d\x24"}, {0x4ed4, "\x6d\x28"}, {0x4ed5, "\x5e\x42"},
  {0x4ed6, "\x76\x62"}, {0x4ed7, "\x6d\x5c"}, {0x4ed8, "\x5c\x75"},
  {0x4ed9, "\x60\x39"}, {0x4edd, "\x54\x4e"}, {0x4edf, "\x74\x35"},
  {0x4ee3, "\x53\x5b"}, {0x4ee4, "\x56\x35"}, {0x4ee5, "\x6c\x24"},
  {0x4ef0, "\x64\x66"}, {0x4ef2, "\x71\x6a"}, {0x4ef6, "\x4b\x6c"},
  {0x4ef7, "\x4b\x40"}, {0x4efb, "\x6c\x72"}, {0x4f01, "\x50\x6a"},
  {0x4f09, "\x79\x72"}, {0x4f0a, "\x6c\x25"}, {0x4f0b, "\x50\x5f"},
  {0x4f0d, "\x67\x6a"}, {0x4f0e, "\x50\x6b"}, {0x4f0f, "\x5c\x51"},
  {0x4f10, "\x5b\x69"}, {0x4f11, "\x7d\x4c"}, {0x4f2f, "\x5b\x57"},
  {0x4f34, "\x5a\x61"}, {0x4f36, "\x56\x36"}, {0x4f38, "\x63\x5f"},
  {0x4f3a, "\x5e\x43"}, {0x4f3c, "\x5e\x44"}, {0x4f3d, "\x4a\x21"},
  {0x4f43, "\x6e\x6c"}, {0x4f46, "\x53\x23"}, {0x4f47, "\x6e\x37"},
  {0x4f48, "\x78\x4f"}, {0x4f4d, "\x6a\x48"}, {0x4f4e, "\x6e\x38"},
  {0x4f4f, "\x71\x2c"}, {0x4f50, "\x71\x25"}, {0x4f51, "\x69\x4e"},
  {0x4f55, "\x79\x3c"}, {0x4f59, "\x65\x79"}, {0x4f5a, "\x6c\x6a"},
  {0x4f5b, "\x5d\x56"}, {0x4f5c, "\x6d\x42"}, {0x4f69, "\x78\x25"},
  {0x4f6f, "\x65\x3a"}, {0x4f70, "\x5b\x58"}, {0x4f73, "\x4a\x22"},
  {0x4f76, "\x51\x4d"}, {0x4f7a, "\x6e\x6d"}, {0x4f7e, "\x6c\x6b"},
  {0x4f7f, "\x5e\x45"}, {0x4f81, "\x63\x60"}, {0x4f83, "\x4a\x49"},
  {0x4f84, "\x72\x69"}, {0x4f86, "\x55\x4e"}, {0x4f88, "\x76\x36"},
  {0x4f8a, "\x4e\x42"}, {0x4f8b, "\x56\x47"}, {0x4f8d, "\x63\x34"},
  {0x4f8f, "\x71\x2d"}, {0x4f91, "\x6a\x62"}, {0x4f96, "\x57\x42"},
  {0x4f98, "\x73\x27"}, {0x4f9b, "\x4d\x6a"}, {0x4f9d, "\x6b\x6e"},
  {0x4fae, "\x59\x32"}, {0x4faf, "\x7d\x25"}, {0x4fb5, "\x76\x55"},
  {0x4fb6, "\x55\x62"}, {0x4fbf, "\x78\x35"}, {0x4fc2, "\x4c\x75"},
  {0x4fc3, "\x75\x35"}, {0x4fc4, "\x64\x2d"}, {0x4fc9, "\x67\x6b"},
  {0x4fca, "\x71\x55"}, {0x4fce, "\x70\x3b"}, {0x4fd1, "\x69\x35"},
  {0x4fd3, "\x4c\x49"}, {0x4fd4, "\x7a\x55"}, {0x4fd7, "\x61\x54"},
  {0x4fda, "\x57\x56"}, {0x4fdd, "\x5c\x41"}, {0x4fdf, "\x5e\x46"},
  {0x4fe0, "\x7a\x6f"}, {0x4fe1, "\x63\x61"}, {0x4fee, "\x61\x73"},
  {0x4fef, "\x5c\x76"}, {0x4ff1, "\x4e\x7c"}, {0x4ff3, "\x5b\x44"},
  {0x4ff5, "\x78\x71"}, {0x4ff8, "\x5c\x64"}, {0x4ffa, "\x65\x6f"},
  {0x5002, "\x5c\x31"}, {0x5006, "\x55\x56"}, {0x5009, "\x73\x5a"},
  {0x500b, "\x4b\x41"}, {0x500d, "\x5b\x43"}, {0x5011, "\x59\x7a"},
  {0x5012, "\x53\x6e"}, {0x5016, "\x7a\x38"}, {0x5019, "\x7d\x26"},
  {0x501a, "\x6b\x6f"}, {0x501c, "\x74\x26"}, {0x501e, "\x4c\x4a"},
  {0x501f, "\x73\x28"}, {0x5021, "\x73\x5b"}, {0x5023, "\x5b\x27"},
  {0x5024, "\x76\x37"}, {0x5026, "\x4f\x66"}, {0x5027, "\x70\x72"},
  {0x5028, "\x4b\x5a"}, {0x502a, "\x67\x52"}, {0x502b, "\x57\x43"},
  {0x502c, "\x76\x70"}, {0x502d, "\x68\x5e"}, {0x503b, "\x65\x26"},
  {0x5043, "\x65\x67"}, {0x5047, "\x4a\x23"}, {0x5048, "\x4c\x27"},
  {0x5049, "\x6a\x49"}, {0x504f, "\x78\x36"}, {0x5055, "\x7a\x25"},
  {0x505a, "\x71\x2e"}, {0x505c, "\x6f\x4e"}, {0x5065, "\x4b\x6d"},
  {0x5074, "\x76\x30"}, {0x5075, "\x6f\x4f"}, {0x5076, "\x69\x4f"},
  {0x5078, "\x77\x5e"}, {0x5080, "\x4e\x53"}, {0x5085, "\x5c\x77"},
  {0x508d, "\x5b\x28"}, {0x5091, "\x4b\x78"}, {0x5098, "\x5f\x21"},
  {0x5099, "\x5d\x61"}, {0x50ac, "\x75\x4a"}, {0x50ad, "\x69\x36"},
  {0x50b2, "\x67\x6c"}, {0x50b3, "\x6e\x6e"}, {0x50b5, "\x73\x70"},
  {0x50b7, "\x5f\x3f"}, {0x50be, "\x4c\x4b"}, {0x50c5, "\x50\x41"},
  {0x50c9, "\x74\x52"}, {0x50ca, "\x60\x3a"}, {0x50cf, "\x5f\x40"},
  {0x50d1, "\x4e\x60"}, {0x50d5, "\x5c\x52"}, {0x50d6, "\x7d\x6a"},
  {0x50da, "\x56\x76"}, {0x50de, "\x6a\x4a"}, {0x50e5, "\x68\x69"},
  {0x50e7, "\x63\x2c"}, {0x50ed, "\x73\x50"}, {0x50f9, "\x4a\x24"},
  {0x50fb, "\x5b\x78"}, {0x50ff, "\x5e\x47"}, {0x5100, "\x6b\x70"},
  {0x5101, "\x71\x56"}, {0x5104, "\x65\x62"}, {0x5106, "\x4c\x4c"},
  {0x5109, "\x4b\x7b"}, {0x5112, "\x6a\x63"}, {0x511f, "\x5f\x41"},
  {0x5121, "\x56\x6d"}, {0x512a, "\x69\x50"}, {0x5132, "\x6e\x39"},
  {0x5137, "\x55\x63"}, {0x513a, "\x51\x53"}, {0x513c, "\x65\x70"},
  {0x5140, "\x68\x34"}, {0x5141, "\x6b\x43"}, {0x5143, "\x6a\x2a"},
  {0x5144, "\x7a\x7c"}, {0x5145, "\x75\x76"}, {0x5146, "\x70\x3c"},
  {0x5147, "\x7d\x54"}, {0x5148, "\x60\x3b"}, {0x5149, "\x4e\x43"},
  {0x514b, "\x50\x3a"}, {0x514c, "\x77\x3a"}, {0x514d, "\x58\x73"},
  {0x514e, "\x77\x4d"}, {0x5152, "\x64\x2e"}, {0x515c, "\x54\x5f"},
  {0x5162, "\x50\x67"}, {0x5165, "\x6c\x7d"}, {0x5167, "\x52\x2e"},
  {0x5168, "\x6e\x6f"}, {0x5169, "\x55\x57"}, {0x516a, "\x6a\x64"},
  {0x516b, "\x78\x22"}, {0x516c, "\x4d\x6b"}, {0x516d, "\x57\x3f"},
  {0x516e, "\x7b\x31"}, {0x5171, "\x4d\x6c"}, {0x5175, "\x5c\x32"},
  {0x5176, "\x50\x6c"}, {0x5177, "\x4e\x7d"}, {0x5178, "\x6e\x70"},
  {0x517c, "\x4c\x42"}, {0x5180, "\x50\x6d"}, {0x5186, "\x65\x77"},
  {0x518a, "\x73\x7c"}, {0x518d, "\x6e\x22"}, {0x5192, "\x59\x33"},
  {0x5195, "\x58\x74"}, {0x5197, "\x69\x37"}, {0x51a0, "\x4e\x2e"},
  {0x51a5, "\x59\x22"}, {0x51aa, "\x58\x71"}, {0x51ac, "\x54\x4f"},
  {0x51b6, "\x65\x27"}, {0x51b7, "\x55\x52"}, {0x51bd, "\x56\x29"},
  {0x51c4, "\x74\x22"}, {0x51c6, "\x71\x57"}, {0x51c9, "\x55\x58"},
  {0x51cb, "\x70\x3d"}, {0x51cc, "\x57\x50"}, {0x51cd, "\x54\x50"},
  {0x51dc, "\x57\x4f"}, {0x51dd, "\x6b\x6a"}, {0x51de, "\x7d\x6b"},
  {0x51e1, "\x5b\x6d"}, {0x51f0, "\x7c\x45"}, {0x51f1, "\x4b\x42"},
  {0x51f6, "\x7d\x55"}, {0x51f8, "\x74\x48"}, {0x51f9, "\x68\x6a"},
  {0x51fa, "\x75\x73"}, {0x51fd, "\x79\x5e"}, {0x5200, "\x53\x6f"},
  {0x5203, "\x6c\x53"}, {0x5206, "\x5d\x42"}, {0x5207, "\x6f\x37"},
  {0x5208, "\x67\x54"}, {0x520a, "\x4a\x4a"}, {0x520e, "\x59\x7b"},
  {0x5211, "\x7a\x7d"}, {0x5217, "\x56\x2a"}, {0x521d, "\x74\x78"},
  {0x5224, "\x77\x77"}, {0x5225, "\x5c\x2c"}, {0x5229, "\x57\x57"},
  {0x522a, "\x5f\x22"}, {0x522e, "\x4e\x3e"}, {0x5230, "\x53\x70"},
  {0x5236, "\x70\x24"}, {0x5237, "\x61\x6c"}, {0x5238, "\x4f\x67"},
  {0x5239, "\x73\x4b"}, {0x523a, "\x6d\x29"}, {0x523b, "\x4a\x3e"},
  {0x5243, "\x74\x6f"}, {0x5247, "\x76\x4e"}, {0x524a, "\x5e\x7b"},
  {0x524b, "\x50\x3b"}, {0x524c, "\x55\x37"}, {0x524d, "\x6e\x71"},
  {0x5254, "\x74\x28"}, {0x5256, "\x5c\x78"}, {0x525b, "\x4b\x27"},
  {0x525d, "\x5a\x4e"}, {0x5261, "\x60\x66"}, {0x5269, "\x6d\x25"},
  {0x526a, "\x6e\x72"}, {0x526f, "\x5c\x79"}, {0x5272, "\x79\x5c"},
  {0x5275, "\x73\x5c"}, {0x527d, "\x78\x72"}, {0x527f, "\x74\x79"},
  {0x5283, "\x7c\x71"}, {0x5287, "\x50\x3c"}, {0x5288, "\x5b\x79"},
  {0x5289, "\x57\x31"}, {0x528d, "\x4b\x7c"}, {0x5291, "\x70\x25"},
  {0x5292, "\x4b\x7d"}, {0x529b, "\x55\x74"}, {0x529f, "\x4d\x6d"},
  {0x52a0, "\x4a\x25"}, {0x52a3, "\x56\x2b"}, {0x52a4, "\x50\x42"},
  {0x52a9, "\x70\x3e"}, {0x52aa, "\x52\x3d"}, {0x52ab, "\x4c\x24"},
  {0x52be, "\x7a\x36"}, {0x52c1, "\x4c\x4d"}, {0x52c3, "\x5a\x7a"},
  {0x52c5, "\x76\x4f"}, {0x52c7, "\x69\x38"}, {0x52c9, "\x58\x75"},
  {0x52cd, "\x4c\x4e"}, {0x52d2, "\x57\x4d"}, {0x52d5, "\x54\x51"},
  {0x52d6, "\x69\x6d"}, {0x52d8, "\x4a\x6b"}, {0x52d9, "\x59\x62"},
  {0x52db, "\x7d\x32"}, {0x52dd, "\x63\x2d"}, {0x52de, "\x56\x4c"},
  {0x52df, "\x59\x34"}, {0x52e2, "\x61\x27"}, {0x52e3, "\x6e\x53"},
  {0x52e4, "\x50\x43"}, {0x52f3, "\x7d\x33"}, {0x52f5, "\x55\x64"},
  {0x52f8, "\x4f\x68"}, {0x52fa, "\x6d\x43"}, {0x52fb, "\x50\x32"},
  {0x52fe, "\x4e\x7e"}, {0x52ff, "\x5a\x28"}, {0x5305, "\x78\x50"},
  {0x5308, "\x7d\x56"}, {0x530d, "\x78\x51"}, {0x530f, "\x78\x52"},
  {0x5310, "\x5c\x53"}, {0x5315, "\x5d\x62"}, {0x5316, "\x7b\x79"},
  {0x5317, "\x5d\x41"}, {0x5319, "\x63\x35"}, {0x5320, "\x6d\x5d"},
  {0x5321, "\x4e\x44"}, {0x5323, "\x4b\x21"}, {0x532a, "\x5d\x63"},
  {0x532f, "\x7c\x5d"}, {0x5339, "\x79\x2f"}, {0x533f, "\x52\x7b"},
  {0x5340, "\x4f\x21"}, {0x5341, "\x64\x28"}, {0x5343, "\x74\x36"},
  {0x5344, "\x6c\x7e"}, {0x5347, "\x63\x2e"}, {0x5348, "\x67\x6d"},
  {0x5349, "\x7d\x41"}, {0x534a, "\x5a\x62"}, {0x534d, "\x58\x33"},
  {0x5351, "\x5d\x64"}, {0x5352, "\x70\x6f"}, {0x5353, "\x76\x71"},
  {0x5354, "\x7a\x70"}, {0x5357, "\x51\x75"}, {0x535a, "\x5a\x4f"},
  {0x535c, "\x5c\x54"}, {0x535e, "\x5c\x26"}, {0x5360, "\x6f\x3f"},
  {0x5366, "\x4e\x4f"}, {0x5368, "\x60\x59"}, {0x536f, "\x59\x56"},
  {0x5370, "\x6c\x54"}, {0x5371, "\x6a\x4b"}, {0x5374, "\x4a\x3f"},
  {0x5375, "\x55\x30"}, {0x5377, "\x4f\x69"}, {0x537d, "\x71\x6d"},
  {0x537f, "\x4c\x4f"}, {0x5384, "\x64\x78"}, {0x5393, "\x64\x6d"},
  {0x5398, "\x57\x58"}, {0x539a, "\x7d\x27"}, {0x539f, "\x6a\x2b"},
  {0x53a0, "\x76\x32"}, {0x53a5, "\x4f\x70"}, {0x53a6, "\x79\x3d"},
  {0x53ad, "\x66\x74"}, {0x53bb, "\x4b\x5b"}, {0x53c3, "\x73\x51"},
  {0x53c8, "\x69\x51"}, {0x53c9, "\x73\x29"}, {0x53ca, "\x50\x60"},
  {0x53cb, "\x69\x52"}, {0x53cd, "\x5a\x63"}, {0x53d4, "\x62\x52"},
  {0x53d6, "\x76\x22"}, {0x53d7, "\x61\x74"}, {0x53db, "\x5a\x64"},
  {0x53e1, "\x67\x55"}, {0x53e2, "\x75\x3f"}, {0x53e3, "\x4f\x22"},
  {0x53e4, "\x4d\x2f"}, {0x53e5, "\x4f\x23"}, {0x53e9, "\x4d\x30"},
  {0x53ea, "\x71\x7e"}, {0x53eb, "\x50\x23"}, {0x53ec, "\x61\x2f"},
  {0x53ed, "\x78\x23"}, {0x53ef, "\x4a\x26"}, {0x53f0, "\x77\x3b"},
  {0x53f1, "\x72\x6a"}, {0x53f2, "\x5e\x48"}, {0x53f3, "\x69\x53"},
  {0x53f8, "\x5e\x49"}, {0x5403, "\x7d\x5e"}, {0x5404, "\x4a\x40"},
  {0x5408, "\x79\x6a"}, {0x5409, "\x51\x4e"}, {0x540a, "\x6e\x54"},
  {0x540c, "\x54\x52"}, {0x540d, "\x59\x23"}, {0x540e, "\x7d\x28"},
  {0x540f, "\x57\x59"}, {0x5410, "\x77\x4e"}, {0x5411, "\x7a\x3e"},
  {0x541b, "\x4f\x56"}, {0x541d, "\x57\x70"}, {0x541f, "\x6b\x61"},
  {0x5420, "\x78\x45"}, {0x5426, "\x5c\x7a"}, {0x5429, "\x5d\x43"},
  {0x542b, "\x79\x5f"}, {0x5433, "\x67\x6f"}, {0x5438, "\x7d\x65"},
  {0x5439, "\x76\x23"}, {0x543b, "\x59\x7c"}, {0x543c, "\x7d\x29"},
  {0x543e, "\x67\x6e"}, {0x5442, "\x55\x65"}, {0x5448, "\x6f\x50"},
  {0x544a, "\x4d\x31"}, {0x5451, "\x77\x22"}, {0x5468, "\x71\x32"},
  {0x546a, "\x71\x31"}, {0x5471, "\x4d\x32"}, {0x5473, "\x5a\x2b"},
  {0x5475, "\x4a\x27"}, {0x547b, "\x63\x62"}, {0x547c, "\x7b\x3c"},
  {0x547d, "\x59\x24"}, {0x5480, "\x6e\x3a"}, {0x5486, "\x78\x53"},
  {0x548c, "\x7b\x7a"}, {0x548e, "\x4f\x24"}, {0x5490, "\x5c\x7b"},
  {0x54a4, "\x76\x63"}, {0x54a8, "\x6d\x2a"}, {0x54ab, "\x72\x21"},
  {0x54ac, "\x4e\x61"}, {0x54b3, "\x7a\x26"}, {0x54b8, "\x79\x60"},
  {0x54bd, "\x6c\x56"}, {0x54c0, "\x64\x6e"}, {0x54c1, "\x79\x21"},
  {0x54c4, "\x7b\x6f"}, {0x54c8, "\x79\x6b"}, {0x54c9, "\x6e\x23"},
  {0x54e1, "\x6a\x2c"}, {0x54e5, "\x4a\x28"}, {0x54e8, "\x74\x7a"},
  {0x54ed, "\x4d\x56"}, {0x54ee, "\x7c\x76"}, {0x54f2, "\x74\x49"},
  {0x54fa, "\x78\x54"}, {0x5504, "\x78\x26"}, {0x5506, "\x5e\x4a"},
  {0x5507, "\x72\x46"}, {0x550e, "\x57\x5a"}, {0x5510, "\x53\x50"},
  {0x551c, "\x58\x45"}, {0x552f, "\x6a\x66"}, {0x5531, "\x73\x5d"},
  {0x5535, "\x64\x5a"}, {0x553e, "\x76\x64"}, {0x5544, "\x76\x72"},
  {0x5546, "\x5f\x42"}, {0x554f, "\x59\x7d"}, {0x5553, "\x4c\x76"},
  {0x5556, "\x53\x3a"}, {0x555e, "\x64\x2f"}, {0x5563, "\x79\x61"},
  {0x557c, "\x70\x26"}, {0x5580, "\x4b\x53"}, {0x5584, "\x60\x3c"},
  {0x5586, "\x74\x4a"}, {0x5587, "\x54\x7a"}, {0x5589, "\x7d\x2a"},
  {0x558a, "\x79\x62"}, {0x5598, "\x74\x37"}, {0x5599, "\x7d\x42"},
  {0x559a, "\x7c\x30"}, {0x559c, "\x7d\x6c"}, {0x559d, "\x4a\x62"},
  {0x55a7, "\x7d\x3d"}, {0x55a9, "\x6a\x67"}, {0x55aa, "\x5f\x43"},
  {0x55ab, "\x51\x52"}, {0x55ac, "\x4e\x62"}, {0x55ae, "\x53\x24"},
  {0x55c5, "\x7d\x2b"}, {0x55c7, "\x5f\x60"}, {0x55d4, "\x72\x47"},
  {0x55da, "\x67\x70"}, {0x55dc, "\x50\x6e"}, {0x55df, "\x73\x2a"},
  {0x55e3, "\x5e\x4b"}, {0x55e4, "\x76\x38"}, {0x55fd, "\x61\x75"},
  {0x55fe, "\x71\x33"}, {0x5606, "\x77\x23"}, {0x5609, "\x4a\x29"},
  {0x5614, "\x4f\x25"}, {0x5617, "\x5f\x44"}, {0x562f, "\x61\x30"},
  {0x5632, "\x70\x3f"}, {0x5634, "\x76\x24"}, {0x5636, "\x63\x36"},
  {0x5653, "\x7a\x46"}, {0x5668, "\x50\x6f"}, {0x566b, "\x7d\x6d"},
  {0x5674, "\x5d\x44"}, {0x5686, "\x7c\x77"}, {0x56a5, "\x66\x3f"},
  {0x56ac, "\x5e\x2d"}, {0x56ae, "\x7a\x3f"}, {0x56b4, "\x65\x71"},
  {0x56bc, "\x6d\x44"}, {0x56ca, "\x52\x25"}, {0x56cd, "\x7d\x6e"},
  {0x56d1, "\x75\x36"}, {0x56da, "\x61\x76"}, {0x56db, "\x5e\x4c"},
  {0x56de, "\x7c\x5e"}, {0x56e0, "\x6c\x57"}, {0x56f0, "\x4d\x5d"},
  {0x56f9, "\x56\x37"}, {0x56fa, "\x4d\x33"}, {0x5703, "\x78\x55"},
  {0x5704, "\x65\x58"}, {0x5708, "\x4f\x6a"}, {0x570b, "\x4f\x50"},
  {0x570d, "\x6a\x4c"}, {0x5712, "\x6a\x2e"}, {0x5713, "\x6a\x2d"},
  {0x5716, "\x53\x71"}, {0x5718, "\x53\x25"}, {0x571f, "\x77\x4f"},
  {0x5728, "\x6e\x24"}, {0x572d, "\x50\x24"}, {0x5730, "\x72\x22"},
  {0x573b, "\x50\x70"}, {0x5740, "\x72\x23"}, {0x5742, "\x77\x78"},
  {0x5747, "\x50\x33"}, {0x574a, "\x5b\x29"}, {0x574d, "\x53\x3b"},
  {0x574e, "\x4a\x6c"}, {0x5750, "\x71\x26"}, {0x5751, "\x4b\x55"},
  {0x5761, "\x77\x67"}, {0x5764, "\x4d\x5e"}, {0x5766, "\x77\x24"},
  {0x576a, "\x78\x40"}, {0x576e, "\x53\x5d"}, {0x5770, "\x4c\x50"},
  {0x5775, "\x4f\x26"}, {0x577c, "\x76\x73"}, {0x5782, "\x61\x77"},
  {0x5788, "\x53\x5c"}, {0x578b, "\x7a\x7e"}, {0x5793, "\x7a\x27"},
  {0x57a0, "\x6b\x59"}, {0x57a2, "\x4f\x27"}, {0x57a3, "\x6a\x2f"},
  {0x57c3, "\x64\x6f"}, {0x57c7, "\x69\x39"}, {0x57c8, "\x71\x58"},
  {0x57cb, "\x58\x58"}, {0x57ce, "\x60\x72"}, {0x57df, "\x66\x34"},
  {0x57e0, "\x5c\x7c"}, {0x57f0, "\x73\x71"}, {0x57f4, "\x63\x50"},
  {0x57f7, "\x72\x7b"}, {0x57f9, "\x5b\x46"}, {0x57fa, "\x50\x71"},
  {0x57fc, "\x50\x72"}, {0x5800, "\x4f\x5c"}, {0x5802, "\x53\x51"},
  {0x5805, "\x4c\x31"}, {0x5806, "\x77\x58"}, {0x5808, "\x4b\x28"},
  {0x5809, "\x6b\x3c"}, {0x580a, "\x64\x3e"}, {0x581e, "\x74\x5c"},
  {0x5821, "\x5c\x42"}, {0x5824, "\x70\x27"}, {0x5827, "\x66\x40"},
  {0x582a, "\x4a\x6d"}, {0x582f, "\x68\x6b"}, {0x5830, "\x65\x68"},
  {0x5831, "\x5c\x43"}, {0x5834, "\x6d\x5e"}, {0x5835, "\x53\x72"},
  {0x583a, "\x4c\x77"}, {0x584a, "\x4e\x54"}, {0x584b, "\x67\x2b"},
  {0x584f, "\x4b\x43"}, {0x5851, "\x61\x31"}, {0x5854, "\x77\x32"},
  {0x5857, "\x53\x73"}, {0x5858, "\x53\x52"}, {0x585a, "\x75\x40"},
  {0x585e, "\x5f\x5d"}, {0x5861, "\x6e\x73"}, {0x5862, "\x67\x71"},
  {0x5864, "\x7d\x34"}, {0x5875, "\x72\x48"}, {0x5879, "\x73\x52"},
  {0x587c, "\x6e\x74"}, {0x587e, "\x62\x53"}, {0x5883, "\x4c\x51"},
  {0x5885, "\x5f\x6a"}, {0x5889, "\x69\x3a"}, {0x5893, "\x59\x57"},
  {0x589c, "\x75\x4d"}, {0x589e, "\x71\x72"}, {0x589f, "\x7a\x47"},
  {0x58a8, "\x59\x78"}, {0x58a9, "\x54\x42"}, {0x58ae, "\x76\x65"},
  {0x58b3, "\x5d\x45"}, {0x58ba, "\x67\x72"}, {0x58bb, "\x6d\x5f"},
  {0x58be, "\x4a\x4b"}, {0x58c1, "\x5b\x7a"}, {0x58c5, "\x68\x35"},
  {0x58c7, "\x53\x26"}, {0x58ce, "\x7d\x35"}, {0x58d1, "\x79\x49"},
  {0x58d3, "\x64\x62"}, {0x58d5, "\x7b\x3d"}, {0x58d8, "\x57\x24"},
  {0x58d9, "\x4e\x45"}, {0x58de, "\x4e\x55"}, {0x58df, "\x56\x66"},
  {0x58e4, "\x65\x3d"}, {0x58eb, "\x5e\x4d"}, {0x58ec, "\x6c\x73"},
  {0x58ef, "\x6d\x60"}, {0x58f9, "\x6c\x6c"}, {0x58fa, "\x7b\x3e"},
  {0x58fb, "\x5f\x6b"}, {0x58fd, "\x61\x78"}, {0x590f, "\x79\x3e"},
  {0x5914, "\x50\x73"}, {0x5915, "\x60\x2a"}, {0x5916, "\x68\x62"},
  {0x5919, "\x62\x54"}, {0x591a, "\x52\x7d"}, {0x591c, "\x65\x28"},
  {0x5922, "\x59\x53"}, {0x5927, "\x53\x5e"}, {0x5929, "\x74\x38"},
  {0x592a, "\x77\x3c"}, {0x592b, "\x5c\x7d"}, {0x592d, "\x68\x6c"},
  {0x592e, "\x64\x67"}, {0x5931, "\x63\x77"}, {0x5937, "\x6c\x28"},
  {0x593e, "\x7a\x71"}, {0x5944, "\x65\x72"}, {0x5947, "\x50\x74"},
  {0x5948, "\x52\x2f"}, {0x5949, "\x5c\x65"}, {0x594e, "\x50\x25"},
  {0x594f, "\x71\x34"}, {0x5950, "\x7c\x31"}, {0x5951, "\x4c\x78"},
  {0x5954, "\x5d\x46"}, {0x5955, "\x7a\x51"}, {0x5957, "\x77\x5f"},
  {0x595a, "\x7a\x28"}, {0x5960, "\x6e\x75"}, {0x5962, "\x5e\x4e"},
  {0x5967, "\x67\x73"}, {0x596a, "\x77\x2c"}, {0x596b, "\x6b\x44"},
  {0x596c, "\x6d\x61"}, {0x596d, "\x60\x2b"}, {0x596e, "\x5d\x47"},
  {0x5973, "\x52\x33"}, {0x5974, "\x52\x3f"}, {0x5978, "\x4a\x4c"},
  {0x597d, "\x7b\x3f"}, {0x5982, "\x65\x7d"}, {0x5983, "\x5d\x65"},
  {0x5984, "\x58\x4d"}, {0x598a, "\x6c\x74"}, {0x5993, "\x50\x75"},
  {0x5996, "\x68\x6d"}, {0x5997, "\x50\x52"}, {0x5999, "\x59\x58"},
  {0x59a5, "\x76\x66"}, {0x59a8, "\x5b\x2a"}, {0x59ac, "\x77\x60"},
  {0x59b9, "\x58\x59"}, {0x59bb, "\x74\x23"}, {0x59be, "\x74\x5d"},
  {0x59c3, "\x6f\x51"}, {0x59c6, "\x59\x35"}, {0x59c9, "\x6d\x2b"},
  {0x59cb, "\x63\x37"}, {0x59d0, "\x6e\x3b"}, {0x59d1, "\x4d\x34"},
  {0x59d3, "\x60\x73"}, {0x59d4, "\x6a\x4d"}, {0x59d9, "\x6c\x75"},
  {0x59da, "\x68\x6e"}, {0x59dc, "\x4b\x29"}, {0x59dd, "\x71\x2f"},
  {0x59e6, "\x4a\x4d"}, {0x59e8, "\x6c\x29"}, {0x59ea, "\x72\x6b"},
  {0x59ec, "\x7d\x6f"}, {0x59ee, "\x79\x73"}, {0x59f8, "\x66\x41"},
  {0x59fb, "\x6c\x58"}, {0x59ff, "\x6d\x2c"}, {0x5a01, "\x6a\x4e"},
  {0x5a03, "\x68\x5f"}, {0x5a11, "\x5e\x4f"}, {0x5a18, "\x52\x26"},
  {0x5a1b, "\x67\x74"}, {0x5a1c, "\x51\x56"}, {0x5a1f, "\x66\x42"},
  {0x5a20, "\x63\x63"}, {0x5a25, "\x64\x30"}, {0x5a29, "\x58\x34"},
  {0x5a36, "\x76\x25"}, {0x5a3c, "\x73\x5e"}, {0x5a41, "\x57\x25"},
  {0x5a46, "\x77\x68"}, {0x5a49, "\x68\x46"}, {0x5a5a, "\x7b\x66"},
  {0x5a62, "\x5d\x66"}, {0x5a66, "\x5c\x7e"}, {0x5a92, "\x58\x5a"},
  {0x5a9a, "\x5a\x2c"}, {0x5a9b, "\x6a\x30"}, {0x5aa4, "\x63\x38"},
  {0x5ac1, "\x4a\x2a"}, {0x5ac2, "\x61\x79"}, {0x5ac4, "\x6a\x31"},
  {0x5ac9, "\x72\x6c"}, {0x5acc, "\x7a\x6e"}, {0x5ae1, "\x6e\x55"},
  {0x5ae6, "\x79\x74"}, {0x5ae9, "\x52\x6c"}, {0x5b05, "\x7b\x7b"},
  {0x5b09, "\x7d\x70"}, {0x5b0b, "\x60\x3d"}, {0x5b0c, "\x4e\x63"},
  {0x5b16, "\x78\x46"}, {0x5b2a, "\x5e\x2e"}, {0x5b40, "\x5f\x45"},
  {0x5b43, "\x65\x3e"}, {0x5b50, "\x6d\x2d"}, {0x5b51, "\x7a\x6a"},
  {0x5b54, "\x4d\x6e"}, {0x5b55, "\x6d\x26"}, {0x5b57, "\x6d\x2e"},
  {0x5b58, "\x70\x6d"}, {0x5b5a, "\x5d\x21"}, {0x5b5c, "\x6d\x2f"},
  {0x5b5d, "\x7c\x78"}, {0x5b5f, "\x58\x6b"}, {0x5b63, "\x4c\x79"},
  {0x5b64, "\x4d\x35"}, {0x5b69, "\x7a\x29"}, {0x5b6b, "\x61\x5d"},
  {0x5b70, "\x62\x55"}, {0x5b71, "\x6d\x4f"}, {0x5b75, "\x5d\x22"},
  {0x5b78, "\x79\x4a"}, {0x5b7a, "\x6a\x68"}, {0x5b7c, "\x65\x6d"},
  {0x5b85, "\x53\x6b"}, {0x5b87, "\x69\x54"}, {0x5b88, "\x61\x7a"},
  {0x5b89, "\x64\x4c"}, {0x5b8b, "\x61\x64"}, {0x5b8c, "\x68\x47"},
  {0x5b8f, "\x4e\x5b"}, {0x5b93, "\x5c\x55"}, {0x5b95, "\x77\x35"},
  {0x5b96, "\x7c\x73"}, {0x5b97, "\x70\x73"}, {0x5b98, "\x4e\x2f"},
  {0x5b99, "\x71\x35"}, {0x5b9a, "\x6f\x52"}, {0x5b9b, "\x68\x48"},
  {0x5b9c, "\x6b\x71"}, {0x5ba2, "\x4b\x54"}, {0x5ba3, "\x60\x3e"},
  {0x5ba4, "\x63\x78"}, {0x5ba5, "\x6a\x69"}, {0x5ba6, "\x7c\x32"},
  {0x5bac, "\x60\x74"}, {0x5bae, "\x4f\x60"}, {0x5bb0, "\x6e\x25"},
  {0x5bb3, "\x7a\x2a"}, {0x5bb4, "\x66\x43"}, {0x5bb5, "\x61\x32"},
  {0x5bb6, "\x4a\x2b"}, {0x5bb8, "\x63\x64"}, {0x5bb9, "\x69\x3b"},
  {0x5bbf, "\x62\x56"}, {0x5bc0, "\x73\x72"}, {0x5bc2, "\x6e\x56"},
  {0x5bc3, "\x6a\x32"}, {0x5bc4, "\x50\x76"}, {0x5bc5, "\x6c\x59"},
  {0x5bc6, "\x5a\x4b"}, {0x5bc7, "\x4f\x28"}, {0x5bcc, "\x5d\x23"},
  {0x5bd0, "\x58\x5b"}, {0x5bd2, "\x79\x4e"}, {0x5bd3, "\x69\x55"},
  {0x5bd4, "\x63\x51"}, {0x5bd7, "\x52\x3c"}, {0x5bde, "\x58\x2c"},
  {0x5bdf, "\x73\x4c"}, {0x5be1, "\x4d\x7b"}, {0x5be2, "\x76\x56"},
  {0x5be4, "\x67\x75"}, {0x5be5, "\x68\x6f"}, {0x5be6, "\x63\x79"},
  {0x5be7, "\x52\x3b"}, {0x5be8, "\x73\x73"}, {0x5be9, "\x63\x7b"},
  {0x5beb, "\x5e\x50"}, {0x5bec, "\x4e\x30"}, {0x5bee, "\x56\x77"},
  {0x5bef, "\x71\x59"}, {0x5bf5, "\x75\x41"}, {0x5bf6, "\x5c\x44"},
  {0x5bf8, "\x75\x3b"}, {0x5bfa, "\x5e\x51"}, {0x5c01, "\x5c\x66"},
  {0x5c04, "\x5e\x52"}, {0x5c07, "\x6d\x62"}, {0x5c08, "\x6e\x76"},
  {0x5c09, "\x6a\x4f"}, {0x5c0a, "\x70\x6e"}, {0x5c0b, "\x63\x7c"},
  {0x5c0d, "\x53\x5f"}, {0x5c0e, "\x53\x74"}, {0x5c0f, "\x61\x33"},
  {0x5c11, "\x61\x34"}, {0x5c16, "\x74\x53"}, {0x5c19, "\x5f\x46"},
  {0x5c24, "\x69\x56"}, {0x5c28, "\x5b\x2b"}, {0x5c31, "\x76\x26"},
  {0x5c38, "\x63\x39"}, {0x5c39, "\x6b\x45"}, {0x5c3a, "\x74\x29"},
  {0x5c3b, "\x4d\x36"}, {0x5c3c, "\x52\x79"}, {0x5c3e, "\x5a\x2d"},
  {0x5c3f, "\x52\x63"}, {0x5c40, "\x4f\x51"}, {0x5c45, "\x4b\x5c"},
  {0x5c46, "\x4c\x7a"}, {0x5c48, "\x4f\x5d"}, {0x5c4b, "\x68\x29"},
  {0x5c4d, "\x63\x3b"}, {0x5c4e, "\x63\x3a"}, {0x5c51, "\x60\x5a"},
  {0x5c55, "\x6e\x77"}, {0x5c5b, "\x5c\x33"}, {0x5c60, "\x53\x75"},
  {0x5c62, "\x57\x26"}, {0x5c64, "\x76\x35"}, {0x5c65, "\x57\x5b"},
  {0x5c6c, "\x61\x55"}, {0x5c6f, "\x54\x6a"}, {0x5c71, "\x5f\x23"},
  {0x5c79, "\x7d\x5f"}, {0x5c90, "\x50\x77"}, {0x5c91, "\x6d\x54"},
  {0x5ca1, "\x4b\x2a"}, {0x5ca9, "\x64\x5b"}, {0x5cab, "\x61\x7b"},
  {0x5cac, "\x4b\x22"}, {0x5cb1, "\x53\x60"}, {0x5cb3, "\x64\x3f"},
  {0x5cb5, "\x7b\x40"}, {0x5cb7, "\x5a\x3e"}, {0x5cb8, "\x64\x4d"},
  {0x5cba, "\x56\x39"}, {0x5cbe, "\x6f\x40"}, {0x5cc0, "\x61\x7c"},
  {0x5cd9, "\x76\x39"}, {0x5ce0, "\x5f\x47"}, {0x5ce8, "\x64\x31"},
  {0x5cef, "\x5c\x67"}, {0x5cf0, "\x5c\x68"}, {0x5cf4, "\x7a\x56"},
  {0x5cf6, "\x53\x76"}, {0x5cfb, "\x71\x5a"}, {0x5cfd, "\x7a\x72"},
  {0x5d07, "\x62\x7d"}, {0x5d0d, "\x55\x4f"}, {0x5d0e, "\x50\x78"},
  {0x5d11, "\x4d\x5f"}, {0x5d14, "\x75\x4b"}, {0x5d16, "\x64\x70"},
  {0x5d17, "\x4b\x2b"}, {0x5d19, "\x57\x44"}, {0x5d27, "\x62\x7e"},
  {0x5d29, "\x5d\x5a"}, {0x5d4b, "\x5a\x2e"}, {0x5d4c, "\x4a\x6e"},
  {0x5d50, "\x55\x39"}, {0x5d69, "\x63\x21"}, {0x5d6c, "\x68\x63"},
  {0x5d6f, "\x73\x2b"}, {0x5d87, "\x4f\x29"}, {0x5d8b, "\x53\x77"},
  {0x5d9d, "\x54\x71"}, {0x5da0, "\x4e\x64"}, {0x5da2, "\x68\x72"},
  {0x5daa, "\x65\x75"}, {0x5db8, "\x67\x2e"}, {0x5dba, "\x56\x3a"},
  {0x5dbc, "\x5f\x6c"}, {0x5dbd, "\x64\x40"}, {0x5dcd, "\x68\x64"},
  {0x5dd2, "\x58\x35"}, {0x5dd6, "\x64\x5c"}, {0x5ddd, "\x74\x39"},
  {0x5dde, "\x71\x36"}, {0x5de1, "\x62\x5e"}, {0x5de2, "\x61\x35"},
  {0x5de5, "\x4d\x6f"}, {0x5de6, "\x71\x27"}, {0x5de7, "\x4e\x65"},
  {0x5de8, "\x4b\x5d"}, {0x5deb, "\x59\x63"}, {0x5dee, "\x73\x2c"},
  {0x5df1, "\x50\x79"}, {0x5df2, "\x6c\x2b"}, {0x5df3, "\x5e\x53"},
  {0x5df4, "\x77\x69"}, {0x5df7, "\x79\x75"}, {0x5dfd, "\x61\x5e"},
  {0x5dfe, "\x4b\x6e"}, {0x5e02, "\x63\x3c"}, {0x5e03, "\x78\x56"},
  {0x5e06, "\x5b\x6e"}, {0x5e0c, "\x7d\x71"}, {0x5e11, "\x77\x36"},
  {0x5e16, "\x74\x5e"}, {0x5e19, "\x72\x6d"}, {0x5e1b, "\x5b\x59"},
  {0x5e1d, "\x70\x28"}, {0x5e25, "\x61\x7d"}, {0x5e2b, "\x5e\x54"},
  {0x5e2d, "\x60\x2c"}, {0x5e33, "\x6d\x63"}, {0x5e36, "\x53\x61"},
  {0x5e38, "\x5f\x48"}, {0x5e3d, "\x59\x36"}, {0x5e3f, "\x7d\x2c"},
  {0x5e40, "\x6f\x53"}, {0x5e44, "\x64\x41"}, {0x5e45, "\x78\x6b"},
  {0x5e47, "\x5b\x2c"}, {0x5e4c, "\x7c\x46"}, {0x5e55, "\x58\x2d"},
  {0x5e5f, "\x76\x3a"}, {0x5e61, "\x5b\x5f"}, {0x5e62, "\x53\x53"},
  {0x5e63, "\x78\x47"}, {0x5e72, "\x4a\x4e"}, {0x5e73, "\x78\x41"},
  {0x5e74, "\x52\x34"}, {0x5e77, "\x5c\x34"}, {0x5e78, "\x7a\x39"},
  {0x5e79, "\x4a\x4f"}, {0x5e7b, "\x7c\x33"}, {0x5e7c, "\x6a\x6a"},
  {0x5e7d, "\x6a\x6b"}, {0x5e7e, "\x50\x7a"}, {0x5e84, "\x6d\x64"},
  {0x5e87, "\x5d\x67"}, {0x5e8a, "\x5f\x49"}, {0x5e8f, "\x5f\x6d"},
  {0x5e95, "\x6e\x3c"}, {0x5e97, "\x6f\x41"}, {0x5e9a, "\x4c\x52"},
  {0x5e9c, "\x5d\x24"}, {0x5ea0, "\x5f\x4a"}, {0x5ea6, "\x53\x78"},
  {0x5ea7, "\x71\x28"}, {0x5eab, "\x4d\x37"}, {0x5ead, "\x6f\x54"},
  {0x5eb5, "\x64\x5d"}, {0x5eb6, "\x5f\x6e"}, {0x5eb7, "\x4b\x2c"},
  {0x5eb8, "\x69\x3c"}, {0x5ebe, "\x6a\x6c"}, {0x5ec2, "\x5f\x4b"},
  {0x5ec8, "\x79\x3f"}, {0x5ec9, "\x56\x2f"}, {0x5eca, "\x55\x46"},
  {0x5ed0, "\x4f\x2a"}, {0x5ed3, "\x4e\x29"}, {0x5ed6, "\x56\x78"},
  {0x5eda, "\x71\x37"}, {0x5edb, "\x6e\x78"}, {0x5edf, "\x59\x59"},
  {0x5ee0, "\x73\x5f"}, {0x5ee2, "\x78\x48"}, {0x5ee3, "\x4e\x46"},
  {0x5eec, "\x55\x66"}, {0x5ef3, "\x74\x66"}, {0x5ef6, "\x66\x45"},
  {0x5ef7, "\x6f\x55"}, {0x5efa, "\x4b\x6f"}, {0x5efb, "\x7c\x5f"},
  {0x5f01, "\x5c\x27"}, {0x5f04, "\x56\x67"}, {0x5f0a, "\x78\x49"},
  {0x5f0f, "\x63\x52"}, {0x5f11, "\x63\x3d"}, {0x5f13, "\x4f\x61"},
  {0x5f14, "\x70\x40"}, {0x5f15, "\x6c\x5a"}, {0x5f17, "\x5d\x57"},
  {0x5f18, "\x7b\x70"}, {0x5f1b, "\x6c\x2c"}, {0x5f1f, "\x70\x29"},
  {0x5f26, "\x7a\x57"}, {0x5f27, "\x7b\x41"}, {0x5f29, "\x52\x40"},
  {0x5f31, "\x65\x30"}, {0x5f35, "\x6d\x65"}, {0x5f3a, "\x4b\x2d"},
  {0x5f3c, "\x79\x30"}, {0x5f48, "\x77\x25"}, {0x5f4a, "\x4b\x2e"},
  {0x5f4c, "\x5a\x2f"}, {0x5f4e, "\x58\x36"}, {0x5f56, "\x53\x27"},
  {0x5f57, "\x7b\x32"}, {0x5f59, "\x7d\x44"}, {0x5f5b, "\x6c\x2d"},
  {0x5f62, "\x7b\x21"}, {0x5f66, "\x65\x69"}, {0x5f67, "\x69\x6e"},
  {0x5f69, "\x73\x74"}, {0x5f6a, "\x78\x73"}, {0x5f6b, "\x70\x41"},
  {0x5f6c, "\x5e\x2f"}, {0x5f6d, "\x78\x30"}, {0x5f70, "\x73\x60"},
  {0x5f71, "\x67\x2f"}, {0x5f77, "\x5b\x2d"}, {0x5f79, "\x66\x35"},
  {0x5f7c, "\x79\x28"}, {0x5f7f, "\x5d\x58"}, {0x5f80, "\x68\x59"},
  {0x5f81, "\x6f\x56"}, {0x5f85, "\x53\x62"}, {0x5f87, "\x62\x5f"},
  {0x5f8a, "\x7c\x60"}, {0x5f8b, "\x57\x48"}, {0x5f8c, "\x7d\x2d"},
  {0x5f90, "\x5f\x6f"}, {0x5f91, "\x4c\x53"}, {0x5f92, "\x53\x79"},
  {0x5f97, "\x54\x70"}, {0x5f98, "\x5b\x47"}, {0x5f99, "\x5e\x55"},
  {0x5f9e, "\x70\x74"}, {0x5fa0, "\x55\x50"}, {0x5fa1, "\x65\x59"},
  {0x5fa8, "\x7c\x47"}, {0x5fa9, "\x5c\x56"}, {0x5faa, "\x62\x60"},
  {0x5fae, "\x5a\x30"}, {0x5fb5, "\x73\x23"}, {0x5fb7, "\x53\x6c"},
  {0x5fb9, "\x74\x4b"}, {0x5fbd, "\x7d\x45"}, {0x5fc3, "\x63\x7d"},
  {0x5fc5, "\x79\x31"}, {0x5fcc, "\x50\x7b"}, {0x5fcd, "\x6c\x5b"},
  {0x5fd6, "\x75\x3c"}, {0x5fd7, "\x72\x24"}, {0x5fd8, "\x58\x4e"},
  {0x5fd9, "\x58\x4f"}, {0x5fe0, "\x75\x77"}, {0x5feb, "\x76\x61"},
  {0x5ff5, "\x52\x37"}, {0x5ffd, "\x7b\x6c"}, {0x5fff, "\x5d\x48"},
  {0x600f, "\x64\x68"}, {0x6012, "\x52\x41"}, {0x6016, "\x78\x57"},
  {0x601c, "\x56\x3b"}, {0x601d, "\x5e\x56"}, {0x6020, "\x77\x3d"},
  {0x6021, "\x6c\x2e"}, {0x6025, "\x50\x61"}, {0x6027, "\x60\x75"},
  {0x6028, "\x6a\x33"}, {0x602a, "\x4e\x56"}, {0x602f, "\x4c\x25"},
  {0x6041, "\x6c\x76"}, {0x6042, "\x62\x61"}, {0x6043, "\x63\x3e"},
  {0x604d, "\x7c\x48"}, {0x6050, "\x4d\x70"}, {0x6052, "\x79\x76"},
  {0x6055, "\x5f\x70"}, {0x6059, "\x65\x3f"}, {0x605d, "\x4e\x3f"},
  {0x6062, "\x7c\x61"}, {0x6063, "\x6d\x30"}, {0x6064, "\x7d\x51"},
  {0x6065, "\x76\x3b"}, {0x6068, "\x79\x4f"}, {0x6069, "\x6b\x5a"},
  {0x606a, "\x4a\x41"}, {0x606c, "\x52\x38"}, {0x606d, "\x4d\x71"},
  {0x606f, "\x63\x53"}, {0x6070, "\x7d\x66"}, {0x6085, "\x66\x6d"},
  {0x6089, "\x63\x7a"}, {0x608c, "\x70\x2a"}, {0x608d, "\x79\x50"},
  {0x6094, "\x7c\x62"}, {0x6096, "\x78\x27"}, {0x609a, "\x61\x65"},
  {0x609b, "\x6e\x79"}, {0x609f, "\x67\x76"}, {0x60a0, "\x6a\x6d"},
  {0x60a3, "\x7c\x34"}, {0x60a4, "\x75\x42"}, {0x60a7, "\x57\x5c"},
  {0x60b0, "\x70\x75"}, {0x60b2, "\x5d\x68"}, {0x60b3, "\x53\x6d"},
  {0x60b4, "\x75\x7c"}, {0x60b6, "\x5a\x3f"}, {0x60b8, "\x4c\x7b"},
  {0x60bc, "\x53\x7a"}, {0x60bd, "\x74\x24"}, {0x60c5, "\x6f\x57"},
  {0x60c7, "\x54\x43"}, {0x60d1, "\x7b\x63"}, {0x60da, "\x7b\x6d"},
  {0x60dc, "\x60\x2d"}, {0x60df, "\x6a\x6e"}, {0x60e0, "\x7b\x33"},
  {0x60e1, "\x64\x42"}, {0x60f0, "\x76\x67"}, {0x60f1, "\x52\x5d"},
  {0x60f3, "\x5f\x4c"}, {0x60f6, "\x7c\x49"}, {0x60f9, "\x65\x29"},
  {0x60fa, "\x60\x76"}, {0x60fb, "\x76\x33"}, {0x6101, "\x61\x7e"},
  {0x6106, "\x4b\x70"}, {0x6108, "\x6a\x6f"}, {0x6109, "\x6a\x70"},
  {0x610d, "\x5a\x40"}, {0x610e, "\x78\x34"}, {0x610f, "\x6b\x72"},
  {0x6115, "\x64\x43"}, {0x611a, "\x69\x57"}, {0x611b, "\x64\x71"},
  {0x611f, "\x4a\x6f"}, {0x6127, "\x4e\x57"}, {0x6130, "\x7c\x4a"},
  {0x6134, "\x73\x61"}, {0x6137, "\x4b\x44"}, {0x613c, "\x63\x65"},
  {0x613e, "\x4b\x45"}, {0x613f, "\x6a\x34"}, {0x6142, "\x69\x3d"},
  {0x6144, "\x57\x49"}, {0x6147, "\x6b\x5b"}, {0x6148, "\x6d\x31"},
  {0x614a, "\x4c\x43"}, {0x614b, "\x77\x3e"}, {0x614c, "\x7c\x4b"},
  {0x6153, "\x78\x74"}, {0x6155, "\x59\x37"}, {0x6158, "\x73\x53"},
  {0x6159, "\x73\x54"}, {0x615d, "\x77\x64"}, {0x615f, "\x77\x51"},
  {0x6162, "\x58\x37"}, {0x6163, "\x4e\x31"}, {0x6164, "\x4a\x42"},
  {0x6167, "\x7b\x34"}, {0x6168, "\x4b\x46"}, {0x616b, "\x70\x76"},
  {0x616e, "\x55\x67"}, {0x6170, "\x6a\x50"}, {0x6176, "\x4c\x54"},
  {0x6177, "\x4b\x2f"}, {0x617d, "\x74\x2a"}, {0x617e, "\x69\x2f"},
  {0x6181, "\x75\x43"}, {0x6182, "\x69\x58"}, {0x618a, "\x5d\x69"},
  {0x618e, "\x71\x73"}, {0x6190, "\x55\x7b"}, {0x6191, "\x5e\x3b"},
  {0x6194, "\x74\x7b"}, {0x6198, "\x7d\x73"}, {0x6199, "\x7d\x72"},
  {0x619a, "\x77\x26"}, {0x61a4, "\x5d\x49"}, {0x61a7, "\x54\x53"},
  {0x61a9, "\x4c\x28"}, {0x61ab, "\x5a\x41"}, {0x61ac, "\x4c\x55"},
  {0x61ae, "\x59\x64"}, {0x61b2, "\x7a\x4a"}, {0x61b6, "\x65\x63"},
  {0x61ba, "\x53\x3c"}, {0x61be, "\x4a\x70"}, {0x61c3, "\x50\x44"},
  {0x61c7, "\x4a\x50"}, {0x61c8, "\x7a\x2b"}, {0x61c9, "\x6b\x6b"},
  {0x61ca, "\x67\x78"}, {0x61cb, "\x59\x65"}, {0x61e6, "\x51\x57"},
  {0x61f2, "\x73\x24"}, {0x61f6, "\x54\x7b"}, {0x61f7, "\x7c\x63"},
  {0x61f8, "\x7a\x58"}, {0x61fa, "\x73\x55"}, {0x61fc, "\x4f\x2b"},
  {0x61ff, "\x6b\x73"}, {0x6200, "\x55\x7c"}, {0x6207, "\x53\x54"},
  {0x6208, "\x4d\x7c"}, {0x620a, "\x59\x66"}, {0x620c, "\x62\x79"},
  {0x620d, "\x62\x21"}, {0x620e, "\x6b\x54"}, {0x6210, "\x60\x77"},
  {0x6211, "\x64\x32"}, {0x6212, "\x4c\x7c"}, {0x6216, "\x7b\x64"},
  {0x621a, "\x74\x2b"}, {0x621f, "\x50\x3d"}, {0x6221, "\x4a\x71"},
  {0x622a, "\x6f\x38"}, {0x622e, "\x57\x40"}, {0x6230, "\x6e\x7a"},
  {0x6231, "\x7d\x74"}, {0x6234, "\x53\x63"}, {0x6236, "\x7b\x42"},
  {0x623e, "\x55\x68"}, {0x623f, "\x5b\x2e"}, {0x6240, "\x61\x36"},
  {0x6241, "\x78\x37"}, {0x6247, "\x60\x3f"}, {0x6248, "\x7b\x43"},
  {0x6249, "\x5d\x6a"}, {0x624b, "\x62\x22"}, {0x624d, "\x6e\x26"},
  {0x6253, "\x76\x68"}, {0x6258, "\x76\x75"}, {0x626e, "\x5d\x4a"},
  {0x6271, "\x50\x62"}, {0x6276, "\x5d\x26"}, {0x6279, "\x5d\x6b"},
  {0x627c, "\x64\x79"}, {0x627f, "\x63\x2f"}, {0x6280, "\x50\x7c"},
  {0x6284, "\x74\x7c"}, {0x6289, "\x4c\x3c"}, {0x628a, "\x77\x6a"},
  {0x6291, "\x65\x64"}, {0x6292, "\x5f\x71"}, {0x6295, "\x77\x61"},
  {0x6297, "\x79\x77"}, {0x6298, "\x6f\x39"}, {0x629b, "\x78\x58"},
  {0x62ab, "\x79\x29"}, {0x62b1, "\x78\x59"}, {0x62b5, "\x6e\x3d"},
  {0x62b9, "\x58\x46"}, {0x62bc, "\x64\x63"}, {0x62bd, "\x75\x4e"},
  {0x62c2, "\x5d\x59"}, {0x62c7, "\x59\x67"}, {0x62c8, "\x52\x39"},
  {0x62c9, "\x55\x43"}, {0x62cc, "\x5a\x65"}, {0x62cd, "\x5a\x50"},
  {0x62cf, "\x51\x59"}, {0x62d0, "\x4e\x58"}, {0x62d2, "\x4b\x5e"},
  {0x62d3, "\x74\x2c"}, {0x62d4, "\x5a\x7b"}, {0x62d6, "\x76\x69"},
  {0x62d7, "\x68\x73"}, {0x62d8, "\x4f\x2c"}, {0x62d9, "\x70\x70"},
  {0x62db, "\x74\x7d"}, {0x62dc, "\x5b\x48"}, {0x62ec, "\x4e\x40"},
  {0x62ed, "\x63\x54"}, {0x62ee, "\x51\x4f"}, {0x62ef, "\x71\x75"},
  {0x62f1, "\x4d\x72"}, {0x62f3, "\x4f\x6b"}, {0x62f7, "\x4d\x38"},
  {0x62fe, "\x63\x26"}, {0x62ff, "\x51\x5a"}, {0x6301, "\x72\x25"},
  {0x6307, "\x72\x26"}, {0x6309, "\x64\x4e"}, {0x6311, "\x53\x7b"},
  {0x632b, "\x71\x29"}, {0x632f, "\x72\x49"}, {0x633a, "\x6f\x58"},
  {0x633b, "\x66\x49"}, {0x633d, "\x58\x38"}, {0x633e, "\x7a\x73"},
  {0x6349, "\x73\x35"}, {0x634c, "\x78\x24"}, {0x634f, "\x51\x73"},
  {0x6350, "\x66\x48"}, {0x6355, "\x78\x5a"}, {0x6367, "\x5c\x69"},
  {0x6368, "\x5e\x57"}, {0x636e, "\x4b\x5f"}, {0x6372, "\x4f\x6c"},
  {0x6377, "\x74\x5f"}, {0x637a, "\x51\x74"}, {0x637b, "\x52\x3a"},
  {0x637f, "\x5f\x72"}, {0x6383, "\x61\x37"}, {0x6388, "\x62\x23"},
  {0x6389, "\x53\x7c"}, {0x638c, "\x6d\x66"}, {0x6392, "\x5b\x49"},
  {0x6396, "\x64\x7a"}, {0x6398, "\x4f\x5e"}, {0x639b, "\x4e\x50"},
  {0x63a0, "\x55\x53"}, {0x63a1, "\x73\x75"}, {0x63a2, "\x77\x2e"},
  {0x63a5, "\x6f\x48"}, {0x63a7, "\x4d\x73"}, {0x63a8, "\x75\x4f"},
  {0x63a9, "\x65\x73"}, {0x63aa, "\x70\x42"}, {0x63c0, "\x4a\x51"},
  {0x63c4, "\x6a\x71"}, {0x63c6, "\x50\x26"}, {0x63cf, "\x59\x5a"},
  {0x63d0, "\x70\x2b"}, {0x63d6, "\x6b\x67"}, {0x63da, "\x65\x40"},
  {0x63db, "\x7c\x35"}, {0x63e1, "\x64\x44"}, {0x63ed, "\x4c\x29"},
  {0x63ee, "\x7d\x46"}, {0x63f4, "\x6a\x35"}, {0x63f6, "\x65\x2a"},
  {0x63f7, "\x5f\x3a"}, {0x640d, "\x61\x5f"}, {0x640f, "\x5a\x51"},
  {0x6414, "\x61\x38"}, {0x6416, "\x68\x74"}, {0x6417, "\x53\x7d"},
  {0x641c, "\x62\x24"}, {0x6422, "\x72\x4a"}, {0x642c, "\x5a\x66"},
  {0x642d, "\x77\x33"}, {0x643a, "\x7d\x4d"}, {0x643e, "\x73\x36"},
  {0x6458, "\x6e\x57"}, {0x6460, "\x75\x44"}, {0x6469, "\x58\x24"},
  {0x646f, "\x72\x27"}, {0x6478, "\x59\x38"}, {0x6479, "\x59\x39"},
  {0x647a, "\x6f\x49"}, {0x6488, "\x56\x4e"}, {0x6491, "\x77\x4b"},
  {0x6492, "\x5f\x2e"}, {0x6493, "\x68\x75"}, {0x649a, "\x52\x35"},
  {0x649e, "\x53\x55"}, {0x64a4, "\x74\x4c"}, {0x64a5, "\x5a\x7c"},
  {0x64ab, "\x59\x68"}, {0x64ad, "\x77\x6b"}, {0x64ae, "\x75\x49"},
  {0x64b0, "\x73\x3c"}, {0x64b2, "\x5a\x52"}, {0x64bb, "\x53\x35"},
  {0x64c1, "\x68\x36"}, {0x64c4, "\x56\x4f"}, {0x64c5, "\x74\x3a"},
  {0x64c7, "\x77\x49"}, {0x64ca, "\x4c\x2a"}, {0x64cd, "\x70\x43"},
  {0x64ce, "\x4c\x56"}, {0x64d2, "\x50\x53"}, {0x64d4, "\x53\x3d"},
  {0x64d8, "\x5b\x7b"}, {0x64da, "\x4b\x60"}, {0x64e1, "\x53\x64"},
  {0x64e2, "\x76\x77"}, {0x64e5, "\x55\x3a"}, {0x64e6, "\x73\x4d"},
  {0x64e7, "\x4b\x61"}, {0x64ec, "\x6b\x74"}, {0x64f2, "\x74\x2d"},
  {0x64f4, "\x7c\x2a"}, {0x64fa, "\x77\x6c"}, {0x64fe, "\x68\x76"},
  {0x6500, "\x5a\x67"}, {0x6504, "\x77\x4c"}, {0x6518, "\x65\x41"},
  {0x651d, "\x60\x6e"}, {0x6523, "\x55\x7d"}, {0x652a, "\x4e\x66"},
  {0x652b, "\x7c\x2b"}, {0x652c, "\x55\x3b"}, {0x652f, "\x72\x28"},
  {0x6536, "\x62\x25"}, {0x6537, "\x4d\x39"}, {0x6538, "\x6a\x72"},
  {0x6539, "\x4b\x47"}, {0x653b, "\x4d\x74"}, {0x653e, "\x5b\x2f"},
  {0x653f, "\x6f\x59"}, {0x6545, "\x4d\x3a"}, {0x6548, "\x7c\x79"},
  {0x654d, "\x5f\x73"}, {0x654e, "\x4e\x67"}, {0x654f, "\x5a\x42"},
  {0x6551, "\x4f\x2d"}, {0x6556, "\x67\x79"}, {0x6557, "\x78\x28"},
  {0x655e, "\x73\x62"}, {0x6562, "\x4a\x72"}, {0x6563, "\x5f\x24"},
  {0x6566, "\x54\x44"}, {0x656c, "\x4c\x57"}, {0x656d, "\x65\x42"},
  {0x6572, "\x4d\x3b"}, {0x6574, "\x6f\x5a"}, {0x6575, "\x6e\x58"},
  {0x6577, "\x5d\x27"}, {0x6578, "\x62\x26"}, {0x657e, "\x60\x40"},
  {0x6582, "\x56\x30"}, {0x6583, "\x78\x4a"}, {0x6585, "\x7c\x7a"},
  {0x6587, "\x59\x7e"}, {0x658c, "\x5e\x30"}, {0x6590, "\x5d\x6c"},
  {0x6591, "\x5a\x68"}, {0x6597, "\x54\x60"}, {0x6599, "\x56\x79"},
  {0x659b, "\x4d\x57"}, {0x659c, "\x5e\x58"}, {0x659f, "\x72\x78"},
  {0x65a1, "\x64\x56"}, {0x65a4, "\x50\x45"}, {0x65a5, "\x74\x2e"},
  {0x65a7, "\x5d\x28"}, {0x65ab, "\x6d\x45"}, {0x65ac, "\x73\x56"},
  {0x65af, "\x5e\x59"}, {0x65b0, "\x63\x66"}, {0x65b7, "\x53\x28"},
  {0x65b9, "\x5b\x30"}, {0x65bc, "\x65\x5a"}, {0x65bd, "\x63\x3f"},
  {0x65c1, "\x5b\x31"}, {0x65c5, "\x55\x69"}, {0x65cb, "\x60\x41"},
  {0x65cc, "\x6f\x5b"}, {0x65cf, "\x70\x69"}, {0x65d2, "\x57\x32"},
  {0x65d7, "\x50\x7d"}, {0x65e0, "\x59\x69"}, {0x65e3, "\x50\x7e"},
  {0x65e5, "\x6c\x6d"}, {0x65e6, "\x53\x29"}, {0x65e8, "\x72\x29"},
  {0x65e9, "\x70\x44"}, {0x65ec, "\x62\x62"}, {0x65ed, "\x69\x6f"},
  {0x65f1, "\x79\x51"}, {0x65f4, "\x69\x59"}, {0x65fa, "\x68\x5a"},
  {0x65fb, "\x5a\x43"}, {0x65fc, "\x5a\x44"}, {0x65fd, "\x54\x45"},
  {0x65ff, "\x67\x7a"}, {0x6606, "\x4d\x60"}, {0x6607, "\x63\x30"},
  {0x6609, "\x5b\x32"}, {0x660a, "\x7b\x44"}, {0x660c, "\x73\x63"},
  {0x660e, "\x59\x25"}, {0x660f, "\x7b\x67"}, {0x6610, "\x5d\x4b"},
  {0x6611, "\x50\x54"}, {0x6613, "\x66\x36"}, {0x6614, "\x60\x2e"},
  {0x6615, "\x7d\x5a"}, {0x661e, "\x5c\x35"}, {0x661f, "\x60\x78"},
  {0x6620, "\x67\x31"}, {0x6625, "\x75\x70"}, {0x6627, "\x58\x5c"},
  {0x6628, "\x6d\x46"}, {0x662d, "\x61\x39"}, {0x662f, "\x63\x40"},
  {0x6630, "\x79\x40"}, {0x6631, "\x69\x70"}, {0x6634, "\x59\x5b"},
  {0x6636, "\x73\x64"}, {0x663a, "\x5c\x36"}, {0x663b, "\x64\x69"},
  {0x6641, "\x70\x45"}, {0x6642, "\x63\x41"}, {0x6643, "\x7c\x4c"},
  {0x6644, "\x7c\x4d"}, {0x6649, "\x72\x4b"}, {0x664b, "\x72\x4c"},
  {0x664f, "\x64\x4f"}, {0x6659, "\x71\x5b"}, {0x665b, "\x7a\x59"},
  {0x665d, "\x71\x38"}, {0x665e, "\x7d\x75"}, {0x665f, "\x60\x79"},
  {0x6664, "\x67\x7b"}, {0x6665, "\x7c\x37"}, {0x6666, "\x7c\x64"},
  {0x6667, "\x7b\x45"}, {0x6668, "\x63\x67"}, {0x6669, "\x58\x39"},
  {0x666b, "\x76\x78"}, {0x666e, "\x5c\x45"}, {0x666f, "\x4c\x58"},
  {0x6673, "\x60\x2f"}, {0x6674, "\x74\x67"}, {0x6676, "\x6f\x5c"},
  {0x6677, "\x4f\x7c"}, {0x6678, "\x6f\x5d"}, {0x667a, "\x72\x2a"},
  {0x6684, "\x7d\x3e"}, {0x6687, "\x4a\x2c"}, {0x6688, "\x7d\x3b"},
  {0x6689, "\x7d\x47"}, {0x668e, "\x67\x32"}, {0x6690, "\x6a\x51"},
  {0x6691, "\x5f\x74"}, {0x6696, "\x51\x6c"}, {0x6697, "\x64\x5e"},
  {0x6698, "\x65\x43"}, {0x669d, "\x59\x26"}, {0x66a0, "\x4d\x3c"},
  {0x66a2, "\x73\x65"}, {0x66ab, "\x6d\x55"}, {0x66ae, "\x59\x3a"},
  {0x66b2, "\x6d\x67"}, {0x66b3, "\x7b\x35"}, {0x66b4, "\x78\x6c"},
  {0x66b9, "\x60\x67"}, {0x66bb, "\x4c\x59"}, {0x66be, "\x54\x46"},
  {0x66c4, "\x67\x25"}, {0x66c6, "\x55\x75"}, {0x66c7, "\x53\x3e"},
  {0x66c9, "\x7c\x7b"}, {0x66d6, "\x64\x72"}, {0x66d9, "\x5f\x75"},
  {0x66dc, "\x68\x78"}, {0x66dd, "\x78\x6d"}, {0x66e0, "\x4e\x47"},
  {0x66e6, "\x7d\x76"}, {0x66f0, "\x68\x58"}, {0x66f2, "\x4d\x58"},
  {0x66f3, "\x67\x56"}, {0x66f4, "\x4c\x5a"}, {0x66f7, "\x4a\x63"},
  {0x66f8, "\x5f\x76"}, {0x66f9, "\x70\x47"}, {0x66fa, "\x70\x46"},
  {0x66fc, "\x58\x3a"}, {0x66fe, "\x71\x74"}, {0x66ff, "\x74\x70"},
  {0x6700, "\x75\x4c"}, {0x6703, "\x7c\x65"}, {0x6708, "\x6a\x45"},
  {0x6709, "\x6a\x73"}, {0x670b, "\x5d\x5b"}, {0x670d, "\x5c\x57"},
  {0x6714, "\x5e\x7d"}, {0x6715, "\x72\x79"}, {0x6717, "\x55\x47"},
  {0x671b, "\x58\x50"}, {0x671d, "\x70\x48"}, {0x671e, "\x51\x21"},
  {0x671f, "\x51\x22"}, {0x6726, "\x59\x54"}, {0x6727, "\x56\x68"},
  {0x6728, "\x59\x4a"}, {0x672a, "\x5a\x31"}, {0x672b, "\x58\x47"},
  {0x672c, "\x5c\x62"}, {0x672d, "\x73\x4e"}, {0x672e, "\x75\x74"},
  {0x6731, "\x71\x39"}, {0x6734, "\x5a\x53"}, {0x6736, "\x76\x6a"},
  {0x673a, "\x4f\x75"}, {0x673d, "\x7d\x2e"}, {0x6746, "\x4a\x52"},
  {0x6749, "\x5f\x34"}, {0x674e, "\x57\x5d"}, {0x674f, "\x7a\x3a"},
  {0x6750, "\x6e\x27"}, {0x6751, "\x75\x3d"}, {0x6753, "\x78\x75"},
  {0x6756, "\x6d\x68"}, {0x675c, "\x54\x61"}, {0x675e, "\x51\x23"},
  {0x675f, "\x61\x56"}, {0x676d, "\x79\x78"}, {0x676f, "\x5b\x4a"},
  {0x6770, "\x4b\x79"}, {0x6771, "\x54\x54"}, {0x6773, "\x59\x5c"},
  {0x6775, "\x6e\x3e"}, {0x6777, "\x77\x6d"}, {0x677b, "\x52\x6e"},
  {0x677e, "\x61\x66"}, {0x677f, "\x77\x79"}, {0x6787, "\x5d\x6d"},
  {0x6789, "\x68\x5b"}, {0x678b, "\x5b\x33"}, {0x678f, "\x51\x77"},
  {0x6790, "\x60\x30"}, {0x6793, "\x54\x62"}, {0x6795, "\x76\x57"},
  {0x6797, "\x57\x79"}, {0x679a, "\x58\x5d"}, {0x679c, "\x4d\x7d"},
  {0x679d, "\x72\x2b"}, {0x67af, "\x4d\x3d"}, {0x67b0, "\x78\x42"},
  {0x67b3, "\x72\x2c"}, {0x67b6, "\x4a\x2d"}, {0x67b7, "\x4a\x2e"},
  {0x67b8, "\x4f\x2e"}, {0x67be, "\x63\x42"}, {0x67c4, "\x5c\x37"},
  {0x67cf, "\x5b\x5a"}, {0x67d0, "\x59\x3b"}, {0x67d1, "\x4a\x73"},
  {0x67d2, "\x76\x53"}, {0x67d3, "\x66\x78"}, {0x67d4, "\x6a\x75"},
  {0x67da, "\x6a\x76"}, {0x67dd, "\x76\x79"}, {0x67e9, "\x4f\x2f"},
  {0x67ec, "\x4a\x53"}, {0x67ef, "\x4a\x2f"}, {0x67f0, "\x52\x30"},
  {0x67f1, "\x71\x3a"}, {0x67f3, "\x57\x33"}, {0x67f4, "\x63\x43"},
  {0x67f5, "\x73\x7d"}, {0x67f6, "\x5e\x5a"}, {0x67fb, "\x5e\x5b"},
  {0x67fe, "\x6f\x5e"}, {0x6812, "\x62\x63"}, {0x6813, "\x6e\x7b"},
  {0x6816, "\x5f\x77"}, {0x6817, "\x57\x4a"}, {0x6821, "\x4e\x68"},
  {0x6822, "\x5b\x5b"}, {0x682a, "\x71\x3b"}, {0x682f, "\x69\x71"},
  {0x6838, "\x7a\x37"}, {0x6839, "\x50\x46"}, {0x683c, "\x4c\x2b"},
  {0x683d, "\x6e\x28"}, {0x6840, "\x4b\x7a"}, {0x6841, "\x79\x79"},
  {0x6842, "\x4c\x7d"}, {0x6843, "\x53\x7e"}, {0x6848, "\x64\x50"},
  {0x684e, "\x72\x6e"}, {0x6850, "\x54\x55"}, {0x6851, "\x5f\x4d"},
  {0x6853, "\x7c\x38"}, {0x6854, "\x51\x50"}, {0x686d, "\x72\x4d"},
  {0x6876, "\x77\x52"}, {0x687f, "\x4a\x54"}, {0x6881, "\x55\x59"},
  {0x6885, "\x58\x5e"}, {0x688f, "\x4d\x59"}, {0x6893, "\x6e\x29"},
  {0x6894, "\x76\x3c"}, {0x6897, "\x4c\x5b"}, {0x689d, "\x70\x49"},
  {0x689f, "\x7c\x7c"}, {0x68a1, "\x68\x49"}, {0x68a2, "\x74\x7e"},
  {0x68a7, "\x67\x7c"}, {0x68a8, "\x57\x5e"}, {0x68ad, "\x5e\x5c"},
  {0x68af, "\x70\x2c"}, {0x68b0, "\x4c\x7e"}, {0x68b1, "\x4d\x61"},
  {0x68b3, "\x61\x3a"}, {0x68b5, "\x5b\x6f"}, {0x68b6, "\x5a\x32"},
  {0x68c4, "\x51\x25"}, {0x68c5, "\x5c\x38"}, {0x68c9, "\x58\x76"},
  {0x68cb, "\x51\x24"}, {0x68cd, "\x4d\x62"}, {0x68d2, "\x5c\x6a"},
  {0x68d5, "\x70\x77"}, {0x68d7, "\x70\x4a"}, {0x68d8, "\x50\x3e"},
  {0x68da, "\x5d\x5c"}, {0x68df, "\x54\x56"}, {0x68e0, "\x53\x56"},
  {0x68e7, "\x6d\x50"}, {0x68e8, "\x4d\x21"}, {0x68ee, "\x5f\x35"},
  {0x68f2, "\x5f\x78"}, {0x68f9, "\x54\x21"}, {0x68fa, "\x4e\x32"},
  {0x6900, "\x68\x4a"}, {0x6905, "\x6b\x75"}, {0x690d, "\x63\x55"},
  {0x690e, "\x75\x50"}, {0x6912, "\x75\x21"}, {0x6927, "\x59\x27"},
  {0x6930, "\x65\x2b"}, {0x693d, "\x66\x4b"}, {0x693f, "\x75\x71"},
  {0x694a, "\x65\x45"}, {0x6953, "\x79\x23"}, {0x6954, "\x60\x5b"},
  {0x6955, "\x76\x6b"}, {0x6957, "\x4b\x71"}, {0x6959, "\x59\x6a"},
  {0x695a, "\x75\x22"}, {0x695e, "\x57\x51"}, {0x6960, "\x51\x78"},
  {0x6961, "\x6a\x78"}, {0x6962, "\x6a\x79"}, {0x6963, "\x5a\x33"},
  {0x6968, "\x6f\x5f"}, {0x696b, "\x71\x6f"}, {0x696d, "\x65\x76"},
  {0x696e, "\x6e\x3f"}, {0x696f, "\x62\x64"}, {0x6975, "\x50\x3f"},
  {0x6977, "\x7a\x2c"}, {0x6978, "\x75\x51"}, {0x6979, "\x67\x33"},
  {0x6995, "\x69\x3e"}, {0x699b, "\x72\x4e"}, {0x699c, "\x5b\x34"},
  {0x69a5, "\x7c\x4e"}, {0x69a7, "\x5d\x6e"}, {0x69ae, "\x67\x34"},
  {0x69b4, "\x57\x34"}, {0x69bb, "\x77\x34"}, {0x69c1, "\x4d\x3e"},
  {0x69c3, "\x5a\x69"}, {0x69cb, "\x4f\x30"}, {0x69cc, "\x77\x59"},
  {0x69cd, "\x73\x66"}, {0x69d0, "\x4e\x59"}, {0x69e8, "\x4e\x2a"},
  {0x69ea, "\x4b\x48"}, {0x69fb, "\x50\x27"}, {0x69fd, "\x70\x4b"},
  {0x69ff, "\x50\x47"}, {0x6a02, "\x64\x45"}, {0x6a0a, "\x5b\x60"},
  {0x6a11, "\x55\x5a"}, {0x6a13, "\x57\x27"}, {0x6a17, "\x6e\x40"},
  {0x6a19, "\x78\x76"}, {0x6a1e, "\x75\x52"}, {0x6a1f, "\x6d\x69"},
  {0x6a21, "\x59\x3c"}, {0x6a23, "\x65\x46"}, {0x6a35, "\x75\x23"},
  {0x6a38, "\x5a\x54"}, {0x6a39, "\x62\x27"}, {0x6a3a, "\x7b\x7c"},
  {0x6a3d, "\x71\x5c"}, {0x6a44, "\x4a\x74"}, {0x6a48, "\x68\x7a"},
  {0x6a4b, "\x4e\x69"}, {0x6a52, "\x69\x78"}, {0x6a53, "\x62\x65"},
  {0x6a58, "\x50\x39"}, {0x6a59, "\x54\x72"}, {0x6a5f, "\x51\x26"},
  {0x6a61, "\x5f\x4e"}, {0x6a6b, "\x7c\x74"}, {0x6a80, "\x53\x2a"},
  {0x6a84, "\x4c\x2c"}, {0x6a89, "\x6f\x60"}, {0x6a8d, "\x65\x65"},
  {0x6a8e, "\x50\x55"}, {0x6a97, "\x5b\x7c"}, {0x6a9c, "\x7c\x66"},
  {0x6aa2, "\x4b\x7e"}, {0x6aa3, "\x6d\x6a"}, {0x6ab3, "\x5e\x31"},
  {0x6abb, "\x79\x63"}, {0x6ac2, "\x54\x22"}, {0x6ac3, "\x4f\x76"},
  {0x6ad3, "\x56\x50"}, {0x6ada, "\x55\x6a"}, {0x6adb, "\x71\x6e"},
  {0x6af6, "\x7a\x4b"}, {0x6afb, "\x65\x21"}, {0x6b04, "\x55\x31"},
  {0x6b0a, "\x4f\x6d"}, {0x6b0c, "\x6d\x6b"}, {0x6b12, "\x55\x32"},
  {0x6b16, "\x55\x3c"}, {0x6b20, "\x7d\x62"}, {0x6b21, "\x73\x2d"},
  {0x6b23, "\x7d\x5b"}, {0x6b32, "\x69\x30"}, {0x6b3a, "\x51\x27"},
  {0x6b3d, "\x7d\x63"}, {0x6b3e, "\x4e\x33"}, {0x6b46, "\x7d\x64"},
  {0x6b47, "\x7a\x4e"}, {0x6b4c, "\x4a\x30"}, {0x6b4e, "\x77\x27"},
  {0x6b50, "\x4f\x31"}, {0x6b5f, "\x66\x22"}, {0x6b61, "\x7c\x36"},
  {0x6b62, "\x72\x2d"}, {0x6b63, "\x6f\x61"}, {0x6b64, "\x73\x2e"},
  {0x6b65, "\x5c\x46"}, {0x6b66, "\x59\x6b"}, {0x6b6a, "\x68\x60"},
  {0x6b72, "\x61\x28"}, {0x6b77, "\x55\x76"}, {0x6b78, "\x4f\x7d"},
  {0x6b7b, "\x5e\x5d"}, {0x6b7f, "\x59\x51"}, {0x6b83, "\x64\x6a"},
  {0x6b84, "\x72\x4f"}, {0x6b86, "\x77\x3f"}, {0x6b89, "\x62\x66"},
  {0x6b8a, "\x62\x28"}, {0x6b96, "\x63\x56"}, {0x6b98, "\x6d\x51"},
  {0x6b9e, "\x69\x79"}, {0x6bae, "\x56\x31"}, {0x6baf, "\x5e\x32"},
  {0x6bb2, "\x60\x68"}, {0x6bb5, "\x53\x2b"}, {0x6bb7, "\x6b\x5c"},
  {0x6bba, "\x5f\x2f"}, {0x6bbc, "\x4a\x43"}, {0x6bbf, "\x6e\x7c"},
  {0x6bc1, "\x7d\x43"}, {0x6bc5, "\x6b\x76"}, {0x6bc6, "\x4f\x32"},
  {0x6bcb, "\x59\x6c"}, {0x6bcd, "\x59\x3d"}, {0x6bcf, "\x58\x5f"},
  {0x6bd2, "\x54\x38"}, {0x6bd3, "\x6b\x3e"}, {0x6bd4, "\x5d\x6f"},
  {0x6bd6, "\x5d\x70"}, {0x6bd7, "\x5d\x71"}, {0x6bd8, "\x5d\x72"},
  {0x6bdb, "\x59\x3e"}, {0x6beb, "\x7b\x46"}, {0x6bec, "\x4f\x33"},
  {0x6c08, "\x6e\x7d"}, {0x6c0f, "\x64\x2b"}, {0x6c11, "\x5a\x45"},
  {0x6c13, "\x58\x6c"}, {0x6c23, "\x51\x28"}, {0x6c34, "\x62\x29"},
  {0x6c37, "\x5e\x3c"}, {0x6c38, "\x67\x35"}, {0x6c3e, "\x5b\x70"},
  {0x6c40, "\x6f\x62"}, {0x6c41, "\x71\x70"}, {0x6c42, "\x4f\x34"},
  {0x6c4e, "\x5b\x71"}, {0x6c50, "\x60\x31"}, {0x6c55, "\x5f\x25"},
  {0x6c57, "\x79\x52"}, {0x6c5a, "\x67\x7d"}, {0x6c5d, "\x66\x23"},
  {0x6c5e, "\x7b\x71"}, {0x6c5f, "\x4b\x30"}, {0x6c60, "\x72\x2e"},
  {0x6c68, "\x4d\x67"}, {0x6c6a, "\x68\x5c"}, {0x6c6d, "\x67\x57"},
  {0x6c70, "\x77\x40"}, {0x6c72, "\x50\x63"}, {0x6c76, "\x5a\x21"},
  {0x6c7a, "\x4c\x3d"}, {0x6c7d, "\x51\x29"}, {0x6c7e, "\x5d\x4c"},
  {0x6c81, "\x63\x7e"}, {0x6c82, "\x51\x2a"}, {0x6c83, "\x68\x2a"},
  {0x6c85, "\x6a\x36"}, {0x6c86, "\x79\x7a"}, {0x6c87, "\x66\x4c"},
  {0x6c88, "\x76\x58"}, {0x6c8c, "\x54\x47"}, {0x6c90, "\x59\x4b"},
  {0x6c92, "\x59\x52"}, {0x6c93, "\x53\x4b"}, {0x6c94, "\x58\x77"},
  {0x6c95, "\x5a\x29"}, {0x6c96, "\x75\x78"}, {0x6c99, "\x5e\x5e"},
  {0x6c9a, "\x72\x2f"}, {0x6c9b, "\x78\x29"}, {0x6cab, "\x58\x48"},
  {0x6cae, "\x6e\x41"}, {0x6cb3, "\x79\x41"}, {0x6cb8, "\x5d\x73"},
  {0x6cb9, "\x6a\x7a"}, {0x6cbb, "\x76\x3d"}, {0x6cbc, "\x61\x3b"},
  {0x6cbd, "\x4d\x3f"}, {0x6cbe, "\x74\x54"}, {0x6cbf, "\x66\x4d"},
  {0x6cc1, "\x7c\x4f"}, {0x6cc2, "\x7b\x22"}, {0x6cc4, "\x60\x5c"},
  {0x6cc9, "\x74\x3b"}, {0x6cca, "\x5a\x55"}, {0x6ccc, "\x79\x32"},
  {0x6cd3, "\x7b\x72"}, {0x6cd5, "\x5b\x76"}, {0x6cd7, "\x5e\x5f"},
  {0x6cdb, "\x5b\x72"}, {0x6ce1, "\x78\x5c"}, {0x6ce2, "\x77\x6e"},
  {0x6ce3, "\x6b\x68"}, {0x6ce5, "\x52\x7a"}, {0x6ce8, "\x71\x3c"},
  {0x6ceb, "\x7a\x5a"}, {0x6cee, "\x5a\x6a"}, {0x6cef, "\x5a\x46"},
  {0x6cf0, "\x77\x41"}, {0x6cf3, "\x67\x36"}, {0x6d0b, "\x65\x47"},
  {0x6d0c, "\x56\x2c"}, {0x6d11, "\x5c\x47"}, {0x6d17, "\x61\x29"},
  {0x6d19, "\x62\x2a"}, {0x6d1b, "\x55\x26"}, {0x6d1e, "\x54\x57"},
  {0x6d25, "\x72\x50"}, {0x6d27, "\x6a\x7b"}, {0x6d29, "\x60\x5d"},
  {0x6d2a, "\x7b\x73"}, {0x6d32, "\x71\x3d"}, {0x6d35, "\x62\x67"},
  {0x6d36, "\x7d\x57"}, {0x6d38, "\x4e\x48"}, {0x6d39, "\x6a\x37"},
  {0x6d3b, "\x7c\x40"}, {0x6d3d, "\x7d\x67"}, {0x6d3e, "\x77\x6f"},
  {0x6d41, "\x57\x35"}, {0x6d59, "\x6f\x3a"}, {0x6d5a, "\x71\x5d"},
  {0x6d5c, "\x5e\x33"}, {0x6d63, "\x68\x4b"}, {0x6d66, "\x78\x5d"},
  {0x6d69, "\x7b\x47"}, {0x6d6a, "\x55\x48"}, {0x6d6c, "\x57\x5f"},
  {0x6d6e, "\x5d\x29"}, {0x6d74, "\x69\x31"}, {0x6d77, "\x7a\x2d"},
  {0x6d78, "\x76\x59"}, {0x6d79, "\x7a\x74"}, {0x6d7f, "\x78\x2a"},
  {0x6d85, "\x66\x6e"}, {0x6d87, "\x4c\x5c"}, {0x6d88, "\x61\x3c"},
  {0x6d89, "\x60\x6f"}, {0x6d8c, "\x69\x3f"}, {0x6d8d, "\x7c\x7d"},
  {0x6d8e, "\x66\x4e"}, {0x6d91, "\x61\x57"}, {0x6d93, "\x66\x4f"},
  {0x6d95, "\x74\x71"}, {0x6daf, "\x64\x73"}, {0x6db2, "\x64\x7b"},
  {0x6db5, "\x79\x64"}, {0x6dc0, "\x6f\x63"}, {0x6dc3, "\x4f\x6e"},
  {0x6dc4, "\x76\x3e"}, {0x6dc5, "\x60\x32"}, {0x6dc6, "\x7c\x7e"},
  {0x6dc7, "\x51\x2b"}, {0x6dcb, "\x57\x7a"}, {0x6dcf, "\x7b\x48"},
  {0x6dd1, "\x62\x57"}, {0x6dd8, "\x54\x23"}, {0x6dd9, "\x70\x78"},
  {0x6dda, "\x57\x28"}, {0x6dde, "\x61\x67"}, {0x6de1, "\x53\x3f"},
  {0x6de8, "\x6f\x64"}, {0x6dea, "\x57\x45"}, {0x6deb, "\x6b\x62"},
  {0x6dee, "\x7c\x67"}, {0x6df1, "\x64\x22"}, {0x6df3, "\x62\x68"},
  {0x6df5, "\x66\x50"}, {0x6df7, "\x7b\x68"}, {0x6df8, "\x74\x68"},
  {0x6df9, "\x65\x74"}, {0x6dfa, "\x74\x3c"}, {0x6dfb, "\x74\x55"},
  {0x6e17, "\x5f\x36"}, {0x6e19, "\x7c\x39"}, {0x6e1a, "\x6e\x42"},
  {0x6e1b, "\x4a\x75"}, {0x6e1f, "\x6f\x65"}, {0x6e20, "\x4b\x62"},
  {0x6e21, "\x54\x24"}, {0x6e23, "\x5e\x60"}, {0x6e24, "\x5a\x7d"},
  {0x6e25, "\x64\x46"}, {0x6e26, "\x68\x3e"}, {0x6e2b, "\x60\x5e"},
  {0x6e2c, "\x76\x34"}, {0x6e2d, "\x6a\x52"}, {0x6e2f, "\x79\x7b"},
  {0x6e32, "\x60\x42"}, {0x6e34, "\x4a\x64"}, {0x6e36, "\x67\x37"},
  {0x6e38, "\x6a\x7d"}, {0x6e3a, "\x59\x5d"}, {0x6e3c, "\x5a\x34"},
  {0x6e3d, "\x6e\x2a"}, {0x6e3e, "\x7b\x69"}, {0x6e43, "\x5b\x4b"},
  {0x6e44, "\x5a\x35"}, {0x6e4a, "\x71\x3e"}, {0x6e4d, "\x53\x2c"},
  {0x6e56, "\x7b\x49"}, {0x6e58, "\x5f\x4f"}, {0x6e5b, "\x53\x40"},
  {0x6e5c, "\x63\x57"}, {0x6e5e, "\x6f\x66"}, {0x6e5f, "\x7c\x50"},
  {0x6e67, "\x69\x40"}, {0x6e6b, "\x75\x53"}, {0x6e6e, "\x6c\x5c"},
  {0x6e6f, "\x77\x37"}, {0x6e72, "\x6a\x38"}, {0x6e73, "\x51\x79"},
  {0x6e7a, "\x5c\x48"}, {0x6e90, "\x6a\x39"}, {0x6e96, "\x71\x5e"},
  {0x6e9c, "\x57\x36"}, {0x6e9d, "\x4f\x35"}, {0x6e9f, "\x59\x28"},
  {0x6ea2, "\x6c\x6e"}, {0x6ea5, "\x5d\x2a"}, {0x6eaa, "\x4d\x22"},
  {0x6eab, "\x68\x2e"}, {0x6eaf, "\x61\x3d"}, {0x6eb1, "\x72\x51"},
  {0x6eb6, "\x69\x41"}, {0x6eba, "\x52\x7c"}, {0x6ec2, "\x5b\x35"},
  {0x6ec4, "\x73\x67"}, {0x6ec5, "\x58\x7e"}, {0x6ec9, "\x7c\x51"},
  {0x6ecb, "\x6d\x32"}, {0x6ecc, "\x74\x2f"}, {0x6ece, "\x7b\x23"},
  {0x6ed1, "\x7c\x41"}, {0x6ed3, "\x6e\x2b"}, {0x6ed4, "\x54\x25"},
  {0x6eef, "\x74\x72"}, {0x6ef4, "\x6e\x59"}, {0x6ef8, "\x7b\x4a"},
  {0x6efe, "\x4d\x63"}, {0x6eff, "\x58\x3b"}, {0x6f01, "\x65\x5b"},
  {0x6f02, "\x78\x77"}, {0x6f06, "\x76\x54"}, {0x6f0f, "\x57\x29"},
  {0x6f11, "\x4b\x49"}, {0x6f14, "\x66\x51"}, {0x6f15, "\x70\x4c"},
  {0x6f20, "\x58\x2e"}, {0x6f22, "\x79\x53"}, {0x6f23, "\x55\x7e"},
  {0x6f2b, "\x58\x3c"}, {0x6f2c, "\x72\x30"}, {0x6f31, "\x62\x2b"},
  {0x6f32, "\x73\x68"}, {0x6f38, "\x6f\x42"}, {0x6f3f, "\x6d\x6c"},
  {0x6f41, "\x67\x38"}, {0x6f51, "\x5a\x7e"}, {0x6f54, "\x4c\x3e"},
  {0x6f57, "\x72\x7c"}, {0x6f58, "\x5a\x6b"}, {0x6f5a, "\x62\x58"},
  {0x6f5b, "\x6d\x56"}, {0x6f5e, "\x56\x51"}, {0x6f5f, "\x60\x33"},
  {0x6f62, "\x7c\x52"}, {0x6f64, "\x6b\x48"}, {0x6f6d, "\x53\x41"},
  {0x6f6e, "\x70\x4d"}, {0x6f70, "\x4f\x77"}, {0x6f7a, "\x6d\x52"},
  {0x6f7c, "\x54\x58"}, {0x6f7d, "\x5c\x49"}, {0x6f7e, "\x57\x71"},
  {0x6f81, "\x5f\x3b"}, {0x6f84, "\x73\x25"}, {0x6f88, "\x74\x4d"},
  {0x6f8d, "\x71\x3f"}, {0x6f8e, "\x78\x31"}, {0x6f90, "\x69\x7a"},
  {0x6f94, "\x7b\x4b"}, {0x6f97, "\x4a\x55"}, {0x6fa3, "\x79\x54"},
  {0x6fa4, "\x77\x4a"}, {0x6fa7, "\x56\x48"}, {0x6fae, "\x7c\x68"},
  {0x6faf, "\x73\x3d"}, {0x6fb1, "\x6e\x7e"}, {0x6fb3, "\x67\x7e"},
  {0x6fb9, "\x53\x42"}, {0x6fbe, "\x53\x36"}, {0x6fc0, "\x4c\x2d"},
  {0x6fc1, "\x76\x7a"}, {0x6fc2, "\x56\x32"}, {0x6fc3, "\x52\x58"},
  {0x6fca, "\x67\x58"}, {0x6fd5, "\x63\x25"}, {0x6fda, "\x67\x39"},
  {0x6fdf, "\x70\x2d"}, {0x6fe0, "\x7b\x4c"}, {0x6fe1, "\x6b\x21"},
  {0x6fe4, "\x54\x26"}, {0x6fe9, "\x7b\x4d"}, {0x6feb, "\x55\x3d"},
  {0x6fec, "\x71\x5f"}, {0x6fef, "\x76\x7b"}, {0x6ff1, "\x5e\x34"},
  {0x6ffe, "\x55\x6b"}, {0x7001, "\x65\x48"}, {0x7005, "\x7b\x24"},
  {0x7006, "\x54\x39"}, {0x7009, "\x5e\x61"}, {0x700b, "\x64\x23"},
  {0x700f, "\x57\x37"}, {0x7011, "\x78\x6e"}, {0x7015, "\x5e\x35"},
  {0x7018, "\x56\x52"}, {0x701a, "\x79\x55"}, {0x701b, "\x67\x3a"},
  {0x701c, "\x6b\x55"}, {0x701d, "\x55\x77"}, {0x701e, "\x6f\x67"},
  {0x701f, "\x61\x3e"}, {0x7023, "\x7a\x2e"}, {0x7027, "\x56\x69"},
  {0x7028, "\x56\x6e"}, {0x702f, "\x67\x3b"}, {0x7037, "\x6c\x4b"},
  {0x703e, "\x55\x33"}, {0x704c, "\x4e\x34"}, {0x7050, "\x7b\x25"},
  {0x7051, "\x61\x6e"}, {0x7058, "\x77\x28"}, {0x705d, "\x7b\x4e"},
  {0x7063, "\x58\x3d"}, {0x706b, "\x7b\x7d"}, {0x7070, "\x7c\x69"},
  {0x7078, "\x4f\x36"}, {0x707c, "\x6d\x47"}, {0x707d, "\x6e\x2c"},
  {0x7085, "\x4c\x5d"}, {0x708a, "\x76\x27"}, {0x708e, "\x66\x7a"},
  {0x7092, "\x75\x24"}, {0x7098, "\x7d\x5c"}, {0x7099, "\x6d\x33"},
  {0x709a, "\x4e\x49"}, {0x70a1, "\x6f\x68"}, {0x70a4, "\x61\x3f"},
  {0x70ab, "\x7a\x5b"}, {0x70ac, "\x4b\x63"}, {0x70ad, "\x77\x29"},
  {0x70af, "\x7b\x26"}, {0x70b3, "\x5c\x39"}, {0x70b7, "\x71\x40"},
  {0x70b8, "\x6d\x48"}, {0x70b9, "\x6f\x43"}, {0x70c8, "\x56\x2d"},
  {0x70cb, "\x7d\x4e"}, {0x70cf, "\x68\x21"}, {0x70d8, "\x7b\x74"},
  {0x70d9, "\x55\x27"}, {0x70dd, "\x71\x76"}, {0x70df, "\x66\x53"},
  {0x70f1, "\x4c\x5e"}, {0x70f9, "\x78\x32"}, {0x70fd, "\x5c\x6b"},
  {0x7104, "\x7d\x36"}, {0x7109, "\x65\x6a"}, {0x710c, "\x71\x60"},
  {0x7119, "\x5b\x4c"}, {0x711a, "\x5d\x4d"}, {0x711e, "\x54\x48"},
  {0x7121, "\x59\x6d"}, {0x7126, "\x75\x25"}, {0x7130, "\x66\x7b"},
  {0x7136, "\x66\x54"}, {0x7147, "\x7d\x48"}, {0x7149, "\x56\x21"},
  {0x714a, "\x7d\x3f"}, {0x714c, "\x7c\x53"}, {0x714e, "\x6f\x21"},
  {0x7150, "\x67\x3c"}, {0x7156, "\x51\x6e"}, {0x7159, "\x66\x55"},
  {0x715c, "\x69\x72"}, {0x715e, "\x5f\x30"}, {0x7164, "\x58\x60"},
  {0x7165, "\x7c\x3a"}, {0x7166, "\x7d\x2f"}, {0x7167, "\x70\x4e"},
  {0x7169, "\x5b\x61"}, {0x716c, "\x65\x49"}, {0x716e, "\x6d\x34"},
  {0x717d, "\x60\x43"}, {0x7184, "\x63\x58"}, {0x7189, "\x69\x7b"},
  {0x718a, "\x6a\x28"}, {0x718f, "\x7d\x37"}, {0x7192, "\x7b\x27"},
  {0x7194, "\x69\x42"}, {0x7199, "\x7d\x77"}, {0x719f, "\x62\x59"},
  {0x71a2, "\x5c\x6c"}, {0x71ac, "\x68\x22"}, {0x71b1, "\x66\x70"},
  {0x71b9, "\x7d\x78"}, {0x71ba, "\x7d\x79"}, {0x71be, "\x76\x3f"},
  {0x71c1, "\x67\x27"}, {0x71c3, "\x66\x57"}, {0x71c8, "\x54\x73"},
  {0x71c9, "\x54\x49"}, {0x71ce, "\x56\x7a"}, {0x71d0, "\x57\x72"},
  {0x71d2, "\x61\x40"}, {0x71d4, "\x5b\x62"}, {0x71d5, "\x66\x58"},
  {0x71df, "\x67\x3d"}, {0x71e5, "\x70\x4f"}, {0x71e6, "\x73\x3e"},
  {0x71e7, "\x62\x2c"}, {0x71ed, "\x75\x37"}, {0x71ee, "\x60\x70"},
  {0x71fb, "\x7d\x38"}, {0x71fc, "\x63\x68"}, {0x71fe, "\x54\x27"},
  {0x71ff, "\x68\x7c"}, {0x7200, "\x7a\x52"}, {0x7206, "\x78\x6f"},
  {0x7210, "\x56\x53"}, {0x721b, "\x55\x34"}, {0x722a, "\x70\x50"},
  {0x722c, "\x77\x70"}, {0x722d, "\x6e\x33"}, {0x7230, "\x6a\x3a"},
  {0x7232, "\x6a\x53"}, {0x7235, "\x6d\x49"}, {0x7236, "\x5d\x2b"},
  {0x723a, "\x65\x2c"}, {0x723b, "\x7d\x21"}, {0x723d, "\x5f\x50"},
  {0x723e, "\x6c\x33"}, {0x7240, "\x5f\x51"}, {0x7246, "\x6d\x6d"},
  {0x7247, "\x78\x38"}, {0x7248, "\x77\x7a"}, {0x724c, "\x78\x2b"},
  {0x7252, "\x74\x60"}, {0x7258, "\x54\x3a"}, {0x7259, "\x64\x33"},
  {0x725b, "\x69\x5a"}, {0x725d, "\x5e\x36"}, {0x725f, "\x59\x3f"},
  {0x7261, "\x59\x40"}, {0x7262, "\x56\x6f"}, {0x7267, "\x59\x4c"},
  {0x7269, "\x5a\x2a"}, {0x7272, "\x5f\x65"}, {0x7279, "\x77\x65"},
  {0x727d, "\x4c\x32"}, {0x7280, "\x5f\x79"}, {0x7281, "\x57\x60"},
  {0x72a2, "\x54\x3b"}, {0x72a7, "\x7d\x7a"}, {0x72ac, "\x4c\x33"},
  {0x72af, "\x5b\x73"}, {0x72c0, "\x5f\x52"}, {0x72c2, "\x4e\x4a"},
  {0x72c4, "\x6e\x5a"}, {0x72ce, "\x64\x64"}, {0x72d0, "\x7b\x4f"},
  {0x72d7, "\x4f\x37"}, {0x72d9, "\x6e\x43"}, {0x72e1, "\x4e\x6a"},
  {0x72e9, "\x62\x2d"}, {0x72f8, "\x57\x61"}, {0x72f9, "\x7a\x75"},
  {0x72fc, "\x55\x49"}, {0x72fd, "\x78\x2c"}, {0x730a, "\x67\x59"},
  {0x7316, "\x73\x69"}, {0x731b, "\x58\x6d"}, {0x731c, "\x63\x44"},
  {0x731d, "\x70\x71"}, {0x7325, "\x68\x65"}, {0x7329, "\x60\x7a"},
  {0x732a, "\x6e\x44"}, {0x732b, "\x59\x5e"}, {0x7336, "\x6b\x22"},
  {0x7337, "\x6b\x23"}, {0x733e, "\x7c\x42"}, {0x733f, "\x6a\x3b"},
  {0x7344, "\x68\x2b"}, {0x7345, "\x5e\x62"}, {0x7350, "\x6d\x6f"},
  {0x7352, "\x68\x23"}, {0x7357, "\x4f\x71"}, {0x7368, "\x54\x3c"},
  {0x736a, "\x7c\x6a"}, {0x7370, "\x67\x3e"}, {0x7372, "\x7c\x72"},
  {0x7375, "\x56\x34"}, {0x7378, "\x62\x2e"}, {0x737a, "\x53\x37"},
  {0x737b, "\x7a\x4c"}, {0x7384, "\x7a\x5c"}, {0x7386, "\x6d\x35"},
  {0x7387, "\x61\x63"}, {0x7389, "\x68\x2c"}, {0x738b, "\x68\x5d"},
  {0x738e, "\x6f\x69"}, {0x7394, "\x74\x3d"}, {0x7396, "\x4f\x38"},
  {0x7397, "\x69\x5b"}, {0x7398, "\x51\x2c"}, {0x739f, "\x5a\x47"},
  {0x73a7, "\x6b\x49"}, {0x73a9, "\x68\x4c"}, {0x73ad, "\x5e\x37"},
  {0x73b2, "\x56\x3c"}, {0x73b3, "\x53\x65"}, {0x73b9, "\x7a\x5d"},
  {0x73c0, "\x5a\x56"}, {0x73c2, "\x4a\x31"}, {0x73c9, "\x5a\x48"},
  {0x73ca, "\x5f\x26"}, {0x73cc, "\x79\x33"}, {0x73cd, "\x72\x52"},
  {0x73cf, "\x4a\x44"}, {0x73d6, "\x4e\x4b"}, {0x73d9, "\x4d\x75"},
  {0x73dd, "\x7d\x30"}, {0x73de, "\x55\x28"}, {0x73e0, "\x71\x41"},
  {0x73e3, "\x62\x69"}, {0x73e4, "\x5c\x4a"}, {0x73e5, "\x6c\x34"},
  {0x73e6, "\x7a\x40"}, {0x73e9, "\x7b\x28"}, {0x73ea, "\x50\x28"},
  {0x73ed, "\x5a\x6c"}, {0x73f7, "\x59\x6e"}, {0x73f9, "\x60\x7b"},
  {0x73fd, "\x6f\x6a"}, {0x73fe, "\x7a\x5e"}, {0x7401, "\x60\x44"},
  {0x7403, "\x4f\x39"}, {0x7405, "\x55\x4a"}, {0x7406, "\x57\x62"},
  {0x7407, "\x62\x2f"}, {0x7409, "\x57\x38"}, {0x7413, "\x68\x4d"},
  {0x741b, "\x76\x5a"}, {0x7420, "\x6f\x22"}, {0x7421, "\x62\x5a"},
  {0x7422, "\x76\x7c"}, {0x7425, "\x7b\x50"}, {0x7426, "\x51\x2d"},
  {0x7428, "\x4d\x64"}, {0x742a, "\x51\x2e"}, {0x742b, "\x5c\x6d"},
  {0x742c, "\x68\x4e"}, {0x742e, "\x70\x79"}, {0x742f, "\x4e\x35"},
  {0x7430, "\x66\x7c"}, {0x7433, "\x57\x7b"}, {0x7434, "\x50\x56"},
  {0x7435, "\x5d\x75"}, {0x7436, "\x77\x71"}, {0x7438, "\x76\x7d"},
  {0x743a, "\x5b\x77"}, {0x743f, "\x7b\x6a"}, {0x7440, "\x69\x5c"},
  {0x7441, "\x59\x41"}, {0x7443, "\x75\x72"}, {0x7444, "\x60\x45"},
  {0x744b, "\x6a\x54"}, {0x7455, "\x79\x42"}, {0x7457, "\x6a\x3c"},
  {0x7459, "\x52\x45"}, {0x745a, "\x7b\x51"}, {0x745b, "\x67\x40"},
  {0x745c, "\x6b\x25"}, {0x745e, "\x5f\x7a"}, {0x745f, "\x63\x22"},
  {0x7460, "\x57\x39"}, {0x7462, "\x69\x43"}, {0x7464, "\x68\x7d"},
  {0x7465, "\x68\x2f"}, {0x7468, "\x72\x53"}, {0x7469, "\x7b\x29"},
  {0x746a, "\x58\x25"}, {0x746f, "\x55\x4b"}, {0x747e, "\x50\x48"},
  {0x7482, "\x51\x2f"}, {0x7483, "\x57\x63"}, {0x7487, "\x60\x46"},
  {0x7489, "\x56\x22"}, {0x748b, "\x6d\x70"}, {0x7498, "\x57\x73"},
  {0x749c, "\x7c\x54"}, {0x749e, "\x5a\x57"}, {0x749f, "\x4c\x5f"},
  {0x74a1, "\x72\x54"}, {0x74a3, "\x51\x30"}, {0x74a5, "\x4c\x60"},
  {0x74a7, "\x5b\x7d"}, {0x74a8, "\x73\x3f"}, {0x74aa, "\x70\x51"},
  {0x74b0, "\x7c\x3b"}, {0x74b2, "\x62\x30"}, {0x74b5, "\x66\x25"},
  {0x74b9, "\x62\x5b"}, {0x74bd, "\x5f\x5e"}, {0x74bf, "\x60\x47"},
  {0x74c6, "\x72\x6f"}, {0x74ca, "\x4c\x61"}, {0x74cf, "\x56\x6a"},
  {0x74d4, "\x67\x42"}, {0x74d8, "\x4e\x36"}, {0x74da, "\x73\x40"},
  {0x74dc, "\x4d\x7e"}, {0x74e0, "\x7b\x52"}, {0x74e2, "\x78\x78"},
  {0x74e3, "\x77\x7b"}, {0x74e6, "\x68\x3f"}, {0x74ee, "\x68\x37"},
  {0x74f7, "\x6d\x36"}, {0x7501, "\x5c\x3a"}, {0x7504, "\x4c\x34"},
  {0x7511, "\x71\x77"}, {0x7515, "\x68\x38"}, {0x7518, "\x4a\x76"},
  {0x751a, "\x64\x24"}, {0x751b, "\x74\x56"}, {0x751f, "\x5f\x66"},
  {0x7523, "\x5f\x27"}, {0x7525, "\x5f\x67"}, {0x7526, "\x61\x41"},
  {0x7528, "\x69\x44"}, {0x752b, "\x5c\x4b"}, {0x752c, "\x69\x45"},
  {0x7530, "\x6f\x23"}, {0x7531, "\x6b\x26"}, {0x7532, "\x4b\x23"},
  {0x7533, "\x63\x69"}, {0x7537, "\x51\x7b"}, {0x7538, "\x6f\x24"},
  {0x753a, "\x6f\x6b"}, {0x7547, "\x50\x34"}, {0x754c, "\x4d\x23"},
  {0x754f, "\x68\x66"}, {0x7551, "\x6f\x25"}, {0x7553, "\x53\x4c"},
  {0x7554, "\x5a\x6d"}, {0x7559, "\x57\x3a"}, {0x755b, "\x72\x55"},
  {0x755c, "\x75\x65"}, {0x755d, "\x59\x6f"}, {0x7562, "\x79\x34"},
  {0x7565, "\x55\x54"}, {0x7566, "\x7d\x4f"}, {0x756a, "\x5b\x63"},
  {0x756f, "\x71\x61"}, {0x7570, "\x6c\x36"}, {0x7575, "\x7b\x7e"},
  {0x7576, "\x53\x57"}, {0x7578, "\x51\x31"}, {0x757a, "\x4b\x31"},
  {0x757f, "\x51\x32"}, {0x7586, "\x4b\x32"}, {0x7587, "\x71\x42"},
  {0x758a, "\x74\x61"}, {0x758b, "\x79\x35"}, {0x758e, "\x61\x43"},
  {0x758f, "\x61\x42"}, {0x7591, "\x6b\x77"}, {0x759d, "\x5f\x28"},
  {0x75a5, "\x4b\x4a"}, {0x75ab, "\x66\x39"}, {0x75b1, "\x78\x5e"},
  {0x75b2, "\x79\x2a"}, {0x75b3, "\x4a\x77"}, {0x75b5, "\x6d\x37"},
  {0x75b8, "\x53\x38"}, {0x75b9, "\x72\x56"}, {0x75bc, "\x54\x59"},
  {0x75bd, "\x6e\x45"}, {0x75be, "\x72\x70"}, {0x75c2, "\x4a\x32"},
  {0x75c5, "\x5c\x3b"}, {0x75c7, "\x71\x78"}, {0x75cd, "\x6c\x37"},
  {0x75d2, "\x65\x4a"}, {0x75d4, "\x76\x40"}, {0x75d5, "\x7d\x5d"},
  {0x75d8, "\x54\x63"}, {0x75d9, "\x4c\x62"}, {0x75db, "\x77\x54"},
  {0x75e2, "\x57\x65"}, {0x75f0, "\x53\x43"}, {0x75f2, "\x58\x26"},
  {0x75f4, "\x76\x41"}, {0x75fa, "\x5d\x76"}, {0x75fc, "\x4d\x40"},
  {0x7600, "\x65\x5c"}, {0x760d, "\x65\x4b"}, {0x7619, "\x61\x44"},
  {0x761f, "\x68\x30"}, {0x7620, "\x74\x30"}, {0x7621, "\x73\x6a"},
  {0x7622, "\x5a\x6e"}, {0x7624, "\x57\x3b"}, {0x7626, "\x62\x31"},
  {0x763b, "\x57\x2a"}, {0x7642, "\x56\x7b"}, {0x764c, "\x64\x5f"},
  {0x764e, "\x4a\x56"}, {0x7652, "\x6b\x28"}, {0x7656, "\x5b\x7e"},
  {0x7661, "\x76\x42"}, {0x7664, "\x6f\x3b"}, {0x7669, "\x54\x7d"},
  {0x766c, "\x60\x48"}, {0x7670, "\x68\x39"}, {0x7672, "\x6f\x26"},
  {0x7678, "\x4d\x24"}, {0x767b, "\x54\x74"}, {0x767c, "\x5b\x21"},
  {0x767d, "\x5b\x5c"}, {0x767e, "\x5b\x5d"}, {0x7684, "\x6e\x5c"},
  {0x7686, "\x4b\x4b"}, {0x7687, "\x7c\x55"}, {0x768e, "\x4e\x6b"},
  {0x7690, "\x4d\x41"}, {0x7693, "\x7b\x53"}, {0x76ae, "\x79\x2b"},
  {0x76ba, "\x75\x54"}, {0x76bf, "\x59\x29"}, {0x76c2, "\x69\x5d"},
  {0x76c3, "\x5b\x4d"}, {0x76c6, "\x5d\x4e"}, {0x76c8, "\x67\x43"},
  {0x76ca, "\x6c\x4c"}, {0x76d2, "\x79\x6c"}, {0x76d6, "\x4b\x4c"},
  {0x76db, "\x60\x7c"}, {0x76dc, "\x54\x28"}, {0x76de, "\x6d\x53"},
  {0x76df, "\x58\x6f"}, {0x76e1, "\x72\x57"}, {0x76e3, "\x4a\x78"},
  {0x76e4, "\x5a\x6f"}, {0x76e7, "\x56\x54"}, {0x76ee, "\x59\x4d"},
  {0x76f2, "\x58\x6e"}, {0x76f4, "\x72\x41"}, {0x76f8, "\x5f\x53"},
  {0x76fc, "\x5a\x70"}, {0x76fe, "\x62\x6a"}, {0x7701, "\x60\x7d"},
  {0x7704, "\x58\x78"}, {0x7708, "\x77\x2f"}, {0x7709, "\x5a\x36"},
  {0x770b, "\x4a\x57"}, {0x771e, "\x72\x58"}, {0x7720, "\x58\x79"},
  {0x7729, "\x7a\x5f"}, {0x7737, "\x4f\x6f"}, {0x7738, "\x59\x42"},
  {0x773a, "\x70\x52"}, {0x773c, "\x64\x51"}, {0x7740, "\x73\x37"},
  {0x774d, "\x7a\x60"}, {0x775b, "\x6f\x6c"}, {0x7761, "\x62\x32"},
  {0x7763, "\x54\x3d"}, {0x7766, "\x59\x4e"}, {0x776b, "\x74\x62"},
  {0x7779, "\x54\x29"}, {0x777e, "\x4d\x42"}, {0x777f, "\x67\x5a"},
  {0x778b, "\x72\x59"}, {0x7791, "\x59\x2a"}, {0x779e, "\x58\x3e"},
  {0x77a5, "\x5c\x2d"}, {0x77ac, "\x62\x6b"}, {0x77ad, "\x56\x7c"},
  {0x77b0, "\x4a\x79"}, {0x77b3, "\x54\x5a"}, {0x77bb, "\x74\x57"},
  {0x77bc, "\x4c\x21"}, {0x77bf, "\x4f\x3a"}, {0x77d7, "\x75\x38"},
  {0x77db, "\x59\x43"}, {0x77dc, "\x50\x68"}, {0x77e2, "\x63\x45"},
  {0x77e3, "\x6b\x78"}, {0x77e5, "\x72\x31"}, {0x77e9, "\x4f\x3b"},
  {0x77ed, "\x53\x2d"}, {0x77ee, "\x68\x61"}, {0x77ef, "\x4e\x6c"},
  {0x77f3, "\x60\x34"}, {0x7802, "\x5e\x63"}, {0x7812, "\x5d\x77"},
  {0x7825, "\x72\x32"}, {0x7826, "\x73\x76"}, {0x7827, "\x76\x5b"},
  {0x782c, "\x57\x7e"}, {0x7832, "\x78\x5f"}, {0x7834, "\x77\x72"},
  {0x7845, "\x50\x29"}, {0x784f, "\x66\x5a"}, {0x785d, "\x75\x26"},
  {0x786b, "\x57\x3c"}, {0x786c, "\x4c\x63"}, {0x786f, "\x66\x5b"},
  {0x787c, "\x5d\x5d"}, {0x7881, "\x51\x33"}, {0x7887, "\x6f\x6d"},
  {0x788c, "\x56\x5e"}, {0x788d, "\x64\x74"}, {0x788e, "\x61\x6f"},
  {0x7891, "\x5d\x78"}, {0x7897, "\x68\x4f"}, {0x78a3, "\x4a\x65"},
  {0x78a7, "\x5c\x21"}, {0x78a9, "\x60\x35"}, {0x78ba, "\x7c\x2c"},
  {0x78bb, "\x7c\x2d"}, {0x78bc, "\x58\x27"}, {0x78c1, "\x6d\x38"},
  {0x78c5, "\x5b\x36"}, {0x78ca, "\x56\x70"}, {0x78cb, "\x73\x2f"},
  {0x78ce, "\x4d\x25"}, {0x78d0, "\x5a\x71"}, {0x78e8, "\x58\x28"},
  {0x78ec, "\x4c\x64"}, {0x78ef, "\x51\x34"}, {0x78f5, "\x4a\x58"},
  {0x78fb, "\x5a\x72"}, {0x7901, "\x75\x27"}, {0x790e, "\x75\x28"},
  {0x7916, "\x66\x26"}, {0x792a, "\x55\x6c"}, {0x792b, "\x55\x78"},
  {0x792c, "\x5a\x73"}, {0x793a, "\x63\x46"}, {0x793e, "\x5e\x64"},
  {0x7940, "\x5e\x65"}, {0x7941, "\x51\x35"}, {0x7947, "\x51\x36"},
  {0x7948, "\x51\x37"}, {0x7949, "\x72\x33"}, {0x7950, "\x69\x5e"},
  {0x7956, "\x70\x53"}, {0x7957, "\x72\x34"}, {0x795a, "\x70\x54"},
  {0x795b, "\x4b\x64"}, {0x795c, "\x7b\x54"}, {0x795d, "\x75\x66"},
  {0x795e, "\x63\x6a"}, {0x7960, "\x5e\x66"}, {0x7965, "\x5f\x54"},
  {0x7968, "\x78\x79"}, {0x796d, "\x70\x2e"}, {0x797a, "\x51\x38"},
  {0x797f, "\x56\x5f"}, {0x7981, "\x50\x57"}, {0x798d, "\x7c\x21"},
  {0x798e, "\x6f\x6e"}, {0x798f, "\x5c\x58"}, {0x7991, "\x69\x5f"},
  {0x79a6, "\x65\x5d"}, {0x79a7, "\x7d\x7b"}, {0x79aa, "\x60\x49"},
  {0x79ae, "\x56\x49"}, {0x79b1, "\x54\x2a"}, {0x79b3, "\x65\x4c"},
  {0x79b9, "\x69\x60"}, {0x79bd, "\x50\x58"}, {0x79be, "\x7c\x22"},
  {0x79bf, "\x54\x3e"}, {0x79c0, "\x62\x33"}, {0x79c1, "\x5e\x67"},
  {0x79c9, "\x5c\x3c"}, {0x79ca, "\x52\x36"}, {0x79cb, "\x75\x55"},
  {0x79d1, "\x4e\x21"}, {0x79d2, "\x75\x29"}, {0x79d5, "\x5d\x79"},
  {0x79d8, "\x5d\x7a"}, {0x79df, "\x70\x55"}, {0x79e4, "\x76\x5f"},
  {0x79e6, "\x72\x5a"}, {0x79e7, "\x64\x6b"}, {0x79e9, "\x72\x71"},
  {0x79fb, "\x6c\x39"}, {0x7a00, "\x7d\x7c"}, {0x7a05, "\x61\x2a"},
  {0x7a08, "\x4a\x59"}, {0x7a0b, "\x6f\x6f"}, {0x7a0d, "\x75\x2a"},
  {0x7a14, "\x6c\x79"}, {0x7a17, "\x78\x2d"}, {0x7a19, "\x72\x42"},
  {0x7a1a, "\x76\x43"}, {0x7a1c, "\x57\x52"}, {0x7a1f, "\x79\x22"},
  {0x7a20, "\x70\x56"}, {0x7a2e, "\x70\x7a"}, {0x7a31, "\x76\x60"},
  {0x7a36, "\x69\x73"}, {0x7a37, "\x72\x43"}, {0x7a3b, "\x54\x2b"},
  {0x7a3c, "\x4a\x33"}, {0x7a3d, "\x4d\x26"}, {0x7a3f, "\x4d\x43"},
  {0x7a40, "\x4d\x5a"}, {0x7a46, "\x59\x4f"}, {0x7a49, "\x76\x44"},
  {0x7a4d, "\x6e\x5d"}, {0x7a4e, "\x67\x44"}, {0x7a57, "\x62\x34"},
  {0x7a61, "\x5f\x62"}, {0x7a62, "\x67\x5b"}, {0x7a69, "\x68\x31"},
  {0x7a6b, "\x7c\x2e"}, {0x7a70, "\x65\x4d"}, {0x7a74, "\x7a\x6b"},
  {0x7a76, "\x4f\x3c"}, {0x7a79, "\x4f\x62"}, {0x7a7a, "\x4d\x76"},
  {0x7a7d, "\x6f\x70"}, {0x7a7f, "\x74\x3e"}, {0x7a81, "\x54\x4d"},
  {0x7a84, "\x73\x38"}, {0x7a88, "\x69\x21"}, {0x7a92, "\x72\x72"},
  {0x7a93, "\x73\x6b"}, {0x7a95, "\x70\x57"}, {0x7a98, "\x4f\x57"},
  {0x7a9f, "\x4f\x5f"}, {0x7aa9, "\x68\x40"}, {0x7aaa, "\x68\x41"},
  {0x7aae, "\x4f\x63"}, {0x7aaf, "\x69\x22"}, {0x7aba, "\x50\x2a"},
  {0x7ac4, "\x73\x41"}, {0x7ac5, "\x50\x2b"}, {0x7ac7, "\x54\x64"},
  {0x7aca, "\x6f\x3c"}, {0x7acb, "\x58\x21"}, {0x7ad7, "\x59\x5f"},
  {0x7ad9, "\x73\x57"}, {0x7add, "\x5c\x3d"}, {0x7adf, "\x4c\x65"},
  {0x7ae0, "\x6d\x71"}, {0x7ae3, "\x71\x62"}, {0x7ae5, "\x54\x5b"},
  {0x7aea, "\x62\x35"}, {0x7aed, "\x4a\x66"}, {0x7aef, "\x53\x2e"},
  {0x7af6, "\x4c\x66"}, {0x7af9, "\x71\x53"}, {0x7afa, "\x75\x67"},
  {0x7aff, "\x4a\x5a"}, {0x7b0f, "\x7b\x6e"}, {0x7b11, "\x61\x45"},
  {0x7b19, "\x5f\x69"}, {0x7b1b, "\x6e\x5e"}, {0x7b1e, "\x77\x42"},
  {0x7b20, "\x58\x22"}, {0x7b26, "\x5d\x2c"}, {0x7b2c, "\x70\x2f"},
  {0x7b2d, "\x56\x3d"}, {0x7b39, "\x61\x2b"}, {0x7b46, "\x79\x36"},
  {0x7b49, "\x54\x75"}, {0x7b4b, "\x50\x49"}, {0x7b4c, "\x6f\x27"},
  {0x7b4d, "\x62\x6c"}, {0x7b4f, "\x5b\x6a"}, {0x7b50, "\x4e\x4c"},
  {0x7b51, "\x75\x68"}, {0x7b52, "\x77\x55"}, {0x7b54, "\x53\x4d"},
  {0x7b56, "\x73\x7e"}, {0x7b60, "\x50\x35"}, {0x7b6c, "\x60\x7e"},
  {0x7b6e, "\x5f\x7b"}, {0x7b75, "\x66\x5d"}, {0x7b7d, "\x68\x24"},
  {0x7b87, "\x4b\x4d"}, {0x7b8b, "\x6f\x28"}, {0x7b8f, "\x6e\x34"},
  {0x7b94, "\x5a\x58"}, {0x7b95, "\x51\x39"}, {0x7b97, "\x5f\x29"},
  {0x7b9a, "\x73\x30"}, {0x7b9d, "\x4c\x44"}, {0x7ba1, "\x4e\x37"},
  {0x7bad, "\x6f\x29"}, {0x7bb1, "\x5f\x55"}, {0x7bb4, "\x6d\x57"},
  {0x7bb8, "\x6e\x46"}, {0x7bc0, "\x6f\x3d"}, {0x7bc1, "\x7c\x56"},
  {0x7bc4, "\x5b\x74"}, {0x7bc6, "\x6f\x2a"}, {0x7bc7, "\x78\x39"},
  {0x7bc9, "\x75\x69"}, {0x7bd2, "\x63\x59"}, {0x7be0, "\x61\x46"},
  {0x7be4, "\x54\x3f"}, {0x7be9, "\x5e\x68"}, {0x7c07, "\x70\x6a"},
  {0x7c12, "\x73\x42"}, {0x7c1e, "\x53\x2f"}, {0x7c21, "\x4a\x5b"},
  {0x7c27, "\x7c\x57"}, {0x7c2a, "\x6d\x58"}, {0x7c2b, "\x61\x47"},
  {0x7c3d, "\x74\x58"}, {0x7c3e, "\x56\x33"}, {0x7c3f, "\x5d\x2d"},
  {0x7c43, "\x55\x3e"}, {0x7c4c, "\x71\x43"}, {0x7c4d, "\x6e\x5f"},
  {0x7c60, "\x56\x6b"}, {0x7c64, "\x74\x59"}, {0x7c6c, "\x57\x66"},
  {0x7c73, "\x5a\x37"}, {0x7c83, "\x5d\x7b"}, {0x7c89, "\x5d\x4f"},
  {0x7c92, "\x58\x23"}, {0x7c95, "\x5a\x59"}, {0x7c97, "\x70\x58"},
  {0x7c98, "\x6f\x44"}, {0x7c9f, "\x61\x58"}, {0x7ca5, "\x71\x54"},
  {0x7ca7, "\x6d\x72"}, {0x7cae, "\x55\x5b"}, {0x7cb1, "\x55\x5c"},
  {0x7cb2, "\x73\x44"}, {0x7cb3, "\x4b\x57"}, {0x7cb9, "\x62\x36"},
  {0x7cbe, "\x6f\x71"}, {0x7cca, "\x7b\x55"}, {0x7cd6, "\x53\x58"},
  {0x7cde, "\x5d\x50"}, {0x7cdf, "\x70\x59"}, {0x7ce0, "\x4b\x33"},
  {0x7ce7, "\x55\x5d"}, {0x7cfb, "\x4d\x27"}, {0x7cfe, "\x50\x2c"},
  {0x7d00, "\x51\x3a"}, {0x7d02, "\x71\x44"}, {0x7d04, "\x65\x33"},
  {0x7d05, "\x7b\x75"}, {0x7d06, "\x69\x61"}, {0x7d07, "\x7d\x60"},
  {0x7d08, "\x7c\x3c"}, {0x7d0a, "\x5a\x22"}, {0x7d0b, "\x5a\x23"},
  {0x7d0d, "\x52\x21"}, {0x7d10, "\x52\x6f"}, {0x7d14, "\x62\x6d"},
  {0x7d17, "\x5e\x69"}, {0x7d18, "\x4e\x5c"}, {0x7d19, "\x72\x35"},
  {0x7d1a, "\x50\x64"}, {0x7d1b, "\x5d\x51"}, {0x7d20, "\x61\x48"},
  {0x7d21, "\x5b\x37"}, {0x7d22, "\x5f\x63"}, {0x7d2b, "\x6d\x39"},
  {0x7d2c, "\x71\x45"}, {0x7d2e, "\x73\x4f"}, {0x7d2f, "\x57\x2b"},
  {0x7d30, "\x61\x2c"}, {0x7d33, "\x63\x6b"}, {0x7d35, "\x6e\x47"},
  {0x7d39, "\x61\x49"}, {0x7d3a, "\x4a\x7a"}, {0x7d42, "\x70\x7b"},
  {0x7d43, "\x7a\x61"}, {0x7d44, "\x70\x5a"}, {0x7d45, "\x4c\x67"},
  {0x7d46, "\x5a\x74"}, {0x7d50, "\x4c\x3f"}, {0x7d5e, "\x4e\x6d"},
  {0x7d61, "\x55\x29"}, {0x7d62, "\x7a\x62"}, {0x7d66, "\x50\x65"},
  {0x7d68, "\x6b\x56"}, {0x7d6a, "\x6c\x5f"}, {0x7d6e, "\x5f\x7c"},
  {0x7d71, "\x77\x56"}, {0x7d72, "\x5e\x6a"}, {0x7d73, "\x4b\x34"},
  {0x7d76, "\x6f\x3e"}, {0x7d79, "\x4c\x35"}, {0x7d7f, "\x4f\x3d"},
  {0x7d8e, "\x6f\x72"}, {0x7d8f, "\x62\x37"}, {0x7d93, "\x4c\x68"},
  {0x7d9c, "\x70\x7c"}, {0x7da0, "\x56\x60"}, {0x7da2, "\x71\x46"},
  {0x7dac, "\x62\x38"}, {0x7dad, "\x6b\x2b"}, {0x7db1, "\x4b\x35"},
  {0x7db2, "\x58\x51"}, {0x7db4, "\x74\x4e"}, {0x7db5, "\x73\x77"},
  {0x7db8, "\x57\x46"}, {0x7dba, "\x51\x3b"}, {0x7dbb, "\x77\x2a"},
  {0x7dbd, "\x6d\x4a"}, {0x7dbe, "\x57\x53"}, {0x7dbf, "\x58\x7a"},
  {0x7dc7, "\x76\x45"}, {0x7dca, "\x51\x4c"}, {0x7dcb, "\x5d\x7c"},
  {0x7dd6, "\x5f\x7d"}, {0x7dd8, "\x79\x65"}, {0x7dda, "\x60\x4a"},
  {0x7ddd, "\x72\x7d"}, {0x7dde, "\x53\x30"}, {0x7de0, "\x74\x73"},
  {0x7de1, "\x5a\x49"}, {0x7de3, "\x66\x5e"}, {0x7de8, "\x78\x3a"},
  {0x7de9, "\x68\x50"}, {0x7dec, "\x58\x7b"}, {0x7def, "\x6a\x55"},
  {0x7df4, "\x56\x23"}, {0x7dfb, "\x76\x46"}, {0x7e09, "\x72\x5b"},
  {0x7e0a, "\x64\x7c"}, {0x7e15, "\x68\x32"}, {0x7e1b, "\x5a\x5a"},
  {0x7e1d, "\x72\x5c"}, {0x7e1e, "\x7b\x56"}, {0x7e1f, "\x69\x32"},
  {0x7e21, "\x6e\x2d"}, {0x7e23, "\x7a\x63"}, {0x7e2b, "\x5c\x6e"},
  {0x7e2e, "\x75\x6a"}, {0x7e2f, "\x66\x60"}, {0x7e31, "\x70\x7d"},
  {0x7e37, "\x57\x2c"}, {0x7e3d, "\x75\x45"}, {0x7e3e, "\x6e\x60"},
  {0x7e41, "\x5b\x65"}, {0x7e43, "\x5d\x5e"}, {0x7e46, "\x59\x70"},
  {0x7e47, "\x69\x23"}, {0x7e52, "\x71\x79"}, {0x7e54, "\x72\x44"},
  {0x7e55, "\x60\x4b"}, {0x7e5e, "\x69\x24"}, {0x7e61, "\x62\x39"},
  {0x7e69, "\x63\x31"}, {0x7e6a, "\x7c\x6b"}, {0x7e6b, "\x4d\x28"},
  {0x7e6d, "\x4c\x36"}, {0x7e70, "\x70\x5b"}, {0x7e79, "\x66\x3a"},
  {0x7e7c, "\x4d\x29"}, {0x7e82, "\x73\x43"}, {0x7e8c, "\x61\x59"},
  {0x7e8f, "\x6f\x2b"}, {0x7e93, "\x67\x45"}, {0x7e96, "\x60\x69"},
  {0x7e98, "\x73\x45"}, {0x7e9b, "\x54\x40"}, {0x7e9c, "\x55\x3f"},
  {0x7f36, "\x5d\x2e"}, {0x7f38, "\x79\x7c"}, {0x7f3a, "\x4c\x40"},
  {0x7f4c, "\x65\x22"}, {0x7f50, "\x4e\x38"}, {0x7f54, "\x58\x52"},
  {0x7f55, "\x79\x56"}, {0x7f6a, "\x71\x2a"}, {0x7f6b, "\x4e\x51"},
  {0x7f6e, "\x76\x47"}, {0x7f70, "\x5b\x6b"}, {0x7f72, "\x5f\x7e"},
  {0x7f75, "\x58\x61"}, {0x7f77, "\x77\x73"}, {0x7f79, "\x57\x67"},
  {0x7f85, "\x54\x7e"}, {0x7f88, "\x51\x3c"}, {0x7f8a, "\x65\x4f"},
  {0x7f8c, "\x4b\x36"}, {0x7f8e, "\x5a\x38"}, {0x7f94, "\x4d\x44"},
  {0x7f9a, "\x56\x3e"}, {0x7f9e, "\x62\x3a"}, {0x7fa4, "\x4f\x58"},
  {0x7fa8, "\x60\x4c"}, {0x7fa9, "\x6b\x79"}, {0x7fb2, "\x7d\x7d"},
  {0x7fb8, "\x57\x68"}, {0x7fb9, "\x4b\x58"}, {0x7fbd, "\x69\x62"},
  {0x7fc1, "\x68\x3a"}, {0x7fc5, "\x63\x47"}, {0x7fca, "\x6c\x4d"},
  {0x7fcc, "\x6c\x4e"}, {0x7fce, "\x56\x3f"}, {0x7fd2, "\x63\x27"},
  {0x7fd4, "\x5f\x56"}, {0x7fd5, "\x7d\x68"}, {0x7fdf, "\x6e\x61"},
  {0x7fe0, "\x76\x28"}, {0x7fe1, "\x5d\x7d"}, {0x7fe9, "\x78\x3b"},
  {0x7feb, "\x68\x51"}, {0x7ff0, "\x79\x57"}, {0x7ff9, "\x4e\x6e"},
  {0x7ffc, "\x6c\x4f"}, {0x8000, "\x69\x25"}, {0x8001, "\x56\x55"},
  {0x8003, "\x4d\x45"}, {0x8005, "\x6d\x3a"}, {0x8006, "\x51\x3d"},
  {0x8009, "\x4f\x3e"}, {0x800c, "\x6c\x3b"}, {0x8010, "\x52\x31"},
  {0x8015, "\x4c\x69"}, {0x8017, "\x59\x44"}, {0x8018, "\x69\x7c"},
  {0x802d, "\x51\x3e"}, {0x8033, "\x6c\x3c"}, {0x8036, "\x65\x2d"},
  {0x803d, "\x77\x30"}, {0x803f, "\x4c\x6a"}, {0x8043, "\x53\x44"},
  {0x8046, "\x56\x40"}, {0x804a, "\x56\x7d"}, {0x8056, "\x61\x21"},
  {0x8058, "\x5e\x3d"}, {0x805a, "\x76\x29"}, {0x805e, "\x5a\x24"},
  {0x806f, "\x56\x24"}, {0x8070, "\x75\x46"}, {0x8072, "\x61\x22"},
  {0x8073, "\x69\x46"}, {0x8077, "\x72\x45"}, {0x807d, "\x74\x69"},
  {0x807e, "\x56\x6c"}, {0x807f, "\x6b\x53"}, {0x8084, "\x6c\x3d"},
  {0x8085, "\x62\x5c"}, {0x8086, "\x5e\x6b"}, {0x8087, "\x70\x5c"},
  {0x8089, "\x6b\x3f"}, {0x808b, "\x57\x4e"}, {0x808c, "\x51\x3f"},
  {0x8096, "\x75\x2b"}, {0x809b, "\x79\x7d"}, {0x809d, "\x4a\x5c"},
  {0x80a1, "\x4d\x46"}, {0x80a2, "\x72\x36"}, {0x80a5, "\x5d\x7e"},
  {0x80a9, "\x4c\x37"}, {0x80aa, "\x5b\x38"}, {0x80af, "\x50\x69"},
  {0x80b1, "\x4e\x5d"}, {0x80b2, "\x6b\x40"}, {0x80b4, "\x7d\x22"},
  {0x80ba, "\x78\x4b"}, {0x80c3, "\x6a\x56"}, {0x80c4, "\x71\x30"},
  {0x80cc, "\x5b\x4e"}, {0x80ce, "\x77\x43"}, {0x80da, "\x5b\x4f"},
  {0x80db, "\x4b\x24"}, {0x80de, "\x78\x60"}, {0x80e1, "\x7b\x57"},
  {0x80e4, "\x6b\x4a"}, {0x80e5, "\x60\x21"}, {0x80f1, "\x4e\x4d"},
  {0x80f4, "\x54\x5c"}, {0x80f8, "\x7d\x58"}, {0x80fd, "\x52\x76"},
  {0x8102, "\x72\x37"}, {0x8105, "\x7a\x76"}, {0x8106, "\x76\x2a"},
  {0x8107, "\x7a\x77"}, {0x8108, "\x58\x66"}, {0x810a, "\x74\x31"},
  {0x8118, "\x68\x52"}, {0x811a, "\x4a\x45"}, {0x811b, "\x4c\x6b"},
  {0x8123, "\x62\x6e"}, {0x8129, "\x62\x3b"}, {0x812b, "\x77\x2d"},
  {0x812f, "\x78\x61"}, {0x8139, "\x73\x6c"}, {0x813e, "\x5e\x21"},
  {0x814b, "\x64\x7d"}, {0x814e, "\x63\x6c"}, {0x8150, "\x5d\x2f"},
  {0x8151, "\x5d\x30"}, {0x8154, "\x4b\x37"}, {0x8155, "\x68\x53"},
  {0x8165, "\x61\x23"}, {0x8166, "\x52\x60"}, {0x816b, "\x70\x7e"},
  {0x8170, "\x69\x26"}, {0x8171, "\x4b\x72"}, {0x8178, "\x6d\x73"},
  {0x8179, "\x5c\x59"}, {0x817a, "\x60\x4d"}, {0x817f, "\x77\x5a"},
  {0x8180, "\x5b\x39"}, {0x8188, "\x4c\x2e"}, {0x818a, "\x5a\x5b"},
  {0x818f, "\x4d\x47"}, {0x819a, "\x5d\x31"}, {0x819c, "\x58\x2f"},
  {0x819d, "\x63\x23"}, {0x81a0, "\x4e\x6f"}, {0x81a3, "\x72\x73"},
  {0x81a8, "\x78\x33"}, {0x81b3, "\x60\x4e"}, {0x81b5, "\x75\x7d"},
  {0x81ba, "\x6b\x6c"}, {0x81bd, "\x53\x45"}, {0x81be, "\x7c\x6c"},
  {0x81bf, "\x52\x5b"}, {0x81c0, "\x54\x6b"}, {0x81c2, "\x5e\x22"},
  {0x81c6, "\x65\x66"}, {0x81cd, "\x70\x30"}, {0x81d8, "\x55\x44"},
  {0x81df, "\x6d\x74"}, {0x81e3, "\x63\x6d"}, {0x81e5, "\x68\x42"},
  {0x81e7, "\x6d\x75"}, {0x81e8, "\x57\x7c"}, {0x81ea, "\x6d\x3b"},
  {0x81ed, "\x76\x2b"}, {0x81f3, "\x72\x38"}, {0x81f4, "\x76\x48"},
  {0x81fa, "\x53\x66"}, {0x81fb, "\x72\x5d"}, {0x81fc, "\x4f\x3f"},
  {0x81fe, "\x6b\x2c"}, {0x8205, "\x4f\x40"}, {0x8207, "\x66\x28"},
  {0x8208, "\x7d\x69"}, {0x820a, "\x4f\x41"}, {0x820c, "\x60\x5f"},
  {0x820d, "\x5e\x6c"}, {0x8212, "\x60\x22"}, {0x821b, "\x74\x3f"},
  {0x821c, "\x62\x6f"}, {0x821e, "\x59\x71"}, {0x821f, "\x71\x47"},
  {0x8221, "\x4b\x38"}, {0x822a, "\x79\x7e"}, {0x822b, "\x5b\x3a"},
  {0x822c, "\x5a\x75"}, {0x8235, "\x76\x6c"}, {0x8236, "\x5a\x5c"},
  {0x8237, "\x7a\x64"}, {0x8239, "\x60\x4f"}, {0x8240, "\x5d\x32"},
  {0x8245, "\x66\x29"}, {0x8247, "\x6f\x73"}, {0x8259, "\x73\x6d"},
  {0x8264, "\x6b\x7a"}, {0x8266, "\x79\x66"}, {0x826e, "\x4a\x5d"},
  {0x826f, "\x55\x5e"}, {0x8271, "\x4a\x5e"}, {0x8272, "\x5f\x64"},
  {0x8276, "\x66\x7d"}, {0x8278, "\x75\x2c"}, {0x827e, "\x64\x75"},
  {0x828b, "\x69\x63"}, {0x828d, "\x6d\x4b"}, {0x828e, "\x4f\x64"},
  {0x8292, "\x58\x53"}, {0x8299, "\x5d\x33"}, {0x829a, "\x54\x6c"},
  {0x829d, "\x72\x39"}, {0x829f, "\x5f\x37"}, {0x82a5, "\x4b\x4e"},
  {0x82a6, "\x7b\x58"}, {0x82a9, "\x50\x59"}, {0x82ac, "\x5d\x52"},
  {0x82ad, "\x77\x74"}, {0x82ae, "\x67\x5c"}, {0x82af, "\x64\x25"},
  {0x82b1, "\x7c\x23"}, {0x82b3, "\x5b\x3b"}, {0x82b7, "\x72\x3a"},
  {0x82b8, "\x69\x7d"}, {0x82b9, "\x50\x4a"}, {0x82bb, "\x75\x56"},
  {0x82bc, "\x59\x45"}, {0x82bd, "\x64\x34"}, {0x82bf, "\x6d\x27"},
  {0x82d1, "\x6a\x3d"}, {0x82d2, "\x66\x7e"}, {0x82d4, "\x77\x44"},
  {0x82d5, "\x75\x2d"}, {0x82d7, "\x59\x60"}, {0x82db, "\x4a\x34"},
  {0x82de, "\x78\x62"}, {0x82df, "\x4f\x42"}, {0x82e1, "\x6c\x3e"},
  {0x82e5, "\x65\x34"}, {0x82e6, "\x4d\x48"}, {0x82e7, "\x6e\x48"},
  {0x82f1, "\x67\x48"}, {0x82fd, "\x4d\x49"}, {0x82fe, "\x79\x37"},
  {0x8301, "\x71\x68"}, {0x8302, "\x59\x72"}, {0x8303, "\x5b\x75"},
  {0x8304, "\x4a\x35"}, {0x8305, "\x59\x46"}, {0x8309, "\x58\x49"},
  {0x8317, "\x59\x2b"}, {0x8328, "\x6d\x3c"}, {0x832b, "\x58\x54"},
  {0x832f, "\x5c\x5a"}, {0x8331, "\x62\x3c"}, {0x8334, "\x7c\x6d"},
  {0x8335, "\x6c\x60"}, {0x8336, "\x52\x7e"}, {0x8338, "\x69\x47"},
  {0x8339, "\x66\x2a"}, {0x8340, "\x62\x70"}, {0x8347, "\x7a\x3b"},
  {0x8349, "\x75\x2e"}, {0x834a, "\x7b\x2a"}, {0x834f, "\x6c\x7b"},
  {0x8351, "\x6c\x3f"}, {0x8352, "\x7c\x58"}, {0x8373, "\x54\x65"},
  {0x8377, "\x79\x43"}, {0x837b, "\x6e\x62"}, {0x8389, "\x57\x69"},
  {0x838a, "\x6d\x76"}, {0x838e, "\x5e\x6d"}, {0x8396, "\x4c\x6c"},
  {0x8398, "\x63\x6e"}, {0x839e, "\x68\x54"}, {0x83a2, "\x7a\x78"},
  {0x83a9, "\x5d\x34"}, {0x83aa, "\x64\x35"}, {0x83ab, "\x58\x30"},
  {0x83bd, "\x58\x55"}, {0x83c1, "\x74\x6a"}, {0x83c5, "\x4e\x39"},
  {0x83c9, "\x56\x61"}, {0x83ca, "\x4f\x52"}, {0x83cc, "\x50\x36"},
  {0x83d3, "\x4e\x22"}, {0x83d6, "\x73\x6e"}, {0x83dc, "\x73\x78"},
  {0x83e9, "\x5c\x4c"}, {0x83eb, "\x50\x4b"}, {0x83ef, "\x7c\x24"},
  {0x83f0, "\x4d\x4a"}, {0x83f1, "\x57\x54"}, {0x83f2, "\x5e\x23"},
  {0x83f4, "\x64\x60"}, {0x83f9, "\x6e\x49"}, {0x83fd, "\x62\x5d"},
  {0x8403, "\x75\x7e"}, {0x8404, "\x54\x2c"}, {0x840a, "\x55\x51"},
  {0x840c, "\x58\x70"}, {0x840d, "\x78\x43"}, {0x840e, "\x6a\x57"},
  {0x8429, "\x75\x57"}, {0x842c, "\x58\x3f"}, {0x8431, "\x7d\x40"},
  {0x8438, "\x6b\x2d"}, {0x843d, "\x55\x2a"}, {0x8449, "\x67\x28"},
  {0x8457, "\x6e\x4a"}, {0x845b, "\x4a\x67"}, {0x8461, "\x78\x63"},
  {0x8463, "\x54\x5d"}, {0x8466, "\x6a\x58"}, {0x846b, "\x7b\x59"},
  {0x846c, "\x6d\x77"}, {0x846f, "\x65\x35"}, {0x8475, "\x50\x2d"},
  {0x847a, "\x71\x71"}, {0x8490, "\x62\x3d"}, {0x8494, "\x63\x48"},
  {0x8499, "\x59\x55"}, {0x849c, "\x5f\x2a"}, {0x84a1, "\x5b\x3c"},
  {0x84b2, "\x78\x64"}, {0x84b8, "\x71\x7a"}, {0x84bb, "\x65\x36"},
  {0x84bc, "\x73\x6f"}, {0x84bf, "\x7b\x5a"}, {0x84c0, "\x61\x60"},
  {0x84c2, "\x59\x2c"}, {0x84c4, "\x75\x6b"}, {0x84c6, "\x60\x36"},
  {0x84c9, "\x69\x48"}, {0x84cb, "\x4b\x4f"}, {0x84cd, "\x63\x49"},
  {0x84d1, "\x5e\x6e"}, {0x84da, "\x62\x3e"}, {0x84ec, "\x5c\x6f"},
  {0x84ee, "\x56\x25"}, {0x84f4, "\x62\x71"}, {0x84fc, "\x56\x7e"},
  {0x8511, "\x59\x21"}, {0x8513, "\x58\x40"}, {0x8514, "\x5c\x5b"},
  {0x8517, "\x6d\x3d"}, {0x8518, "\x5f\x38"}, {0x851a, "\x6a\x25"},
  {0x851e, "\x57\x2d"}, {0x8521, "\x73\x79"}, {0x8523, "\x6d\x78"},
  {0x8525, "\x75\x47"}, {0x852c, "\x61\x4a"}, {0x852d, "\x6b\x63"},
  {0x852f, "\x72\x5e"}, {0x853d, "\x78\x4c"}, {0x853f, "\x6a\x59"},
  {0x8541, "\x53\x46"}, {0x8543, "\x5b\x66"}, {0x8549, "\x75\x2f"},
  {0x854e, "\x4e\x70"}, {0x8553, "\x69\x7e"}, {0x8559, "\x7b\x36"},
  {0x8563, "\x62\x72"}, {0x8568, "\x4f\x72"}, {0x8569, "\x77\x39"},
  {0x856a, "\x59\x73"}, {0x856d, "\x61\x4b"}, {0x8584, "\x5a\x5d"},
  {0x8587, "\x5a\x39"}, {0x858f, "\x6b\x7b"}, {0x8591, "\x4b\x39"},
  {0x8594, "\x6d\x79"}, {0x859b, "\x60\x60"}, {0x85a6, "\x74\x40"},
  {0x85a8, "\x7d\x3c"}, {0x85a9, "\x5f\x31"}, {0x85aa, "\x63\x6f"},
  {0x85af, "\x60\x23"}, {0x85b0, "\x7d\x39"}, {0x85ba, "\x70\x31"},
  {0x85c1, "\x4d\x4b"}, {0x85c9, "\x6d\x3e"}, {0x85cd, "\x55\x40"},
  {0x85ce, "\x63\x70"}, {0x85cf, "\x6d\x7a"}, {0x85d5, "\x69\x64"},
  {0x85dc, "\x55\x6d"}, {0x85dd, "\x67\x5d"}, {0x85e4, "\x54\x76"},
  {0x85e5, "\x65\x37"}, {0x85e9, "\x5b\x67"}, {0x85ea, "\x62\x3f"},
  {0x85f7, "\x6e\x4b"}, {0x85fa, "\x57\x74"}, {0x85fb, "\x70\x5d"},
  {0x85ff, "\x4e\x2b"}, {0x8602, "\x67\x5e"}, {0x8606, "\x56\x56"},
  {0x8607, "\x61\x4c"}, {0x860a, "\x68\x33"}, {0x8616, "\x65\x6e"},
  {0x8617, "\x5c\x22"}, {0x861a, "\x60\x50"}, {0x862d, "\x55\x35"},
  {0x863f, "\x55\x21"}, {0x864e, "\x7b\x5b"}, {0x8650, "\x79\x4b"},
  {0x8654, "\x4b\x73"}, {0x8655, "\x74\x25"}, {0x865b, "\x7a\x48"},
  {0x865c, "\x56\x57"}, {0x865e, "\x69\x65"}, {0x865f, "\x7b\x5c"},
  {0x8667, "\x7d\x50"}, {0x8679, "\x7b\x76"}, {0x868a, "\x5a\x25"},
  {0x868c, "\x5b\x3d"}, {0x8693, "\x6c\x62"}, {0x86a3, "\x4d\x77"},
  {0x86a4, "\x70\x5e"}, {0x86a9, "\x76\x49"}, {0x86c7, "\x5e\x6f"},
  {0x86cb, "\x53\x31"}, {0x86d4, "\x7c\x6e"}, {0x86d9, "\x68\x43"},
  {0x86db, "\x71\x48"}, {0x86df, "\x4e\x71"}, {0x86e4, "\x79\x6d"},
  {0x86ed, "\x72\x74"}, {0x86fe, "\x64\x36"}, {0x8700, "\x75\x39"},
  {0x8702, "\x5c\x70"}, {0x8703, "\x63\x71"}, {0x8708, "\x68\x25"},
  {0x8718, "\x72\x3b"}, {0x871a, "\x5e\x24"}, {0x871c, "\x5a\x4c"},
  {0x874e, "\x4a\x69"}, {0x8755, "\x63\x5a"}, {0x8757, "\x7c\x59"},
  {0x875f, "\x6a\x5a"}, {0x8766, "\x79\x44"}, {0x8768, "\x63\x24"},
  {0x8774, "\x7b\x5d"}, {0x8776, "\x6f\x4a"}, {0x8778, "\x68\x44"},
  {0x8782, "\x55\x4c"}, {0x878d, "\x6b\x57"}, {0x879f, "\x59\x2d"},
  {0x87a2, "\x7b\x2b"}, {0x87b3, "\x53\x59"}, {0x87ba, "\x55\x22"},
  {0x87c4, "\x76\x5e"}, {0x87e0, "\x5a\x76"}, {0x87ec, "\x60\x51"},
  {0x87ef, "\x69\x28"}, {0x87f2, "\x75\x79"}, {0x87f9, "\x7a\x2f"},
  {0x87fb, "\x6b\x7c"}, {0x87fe, "\x60\x6a"}, {0x8805, "\x63\x32"},
  {0x881f, "\x55\x45"}, {0x8822, "\x71\x63"}, {0x8823, "\x55\x6e"},
  {0x8831, "\x4d\x4c"}, {0x8836, "\x6d\x59"}, {0x883b, "\x58\x41"},
  {0x8840, "\x7a\x6c"}, {0x8846, "\x71\x6b"}, {0x884c, "\x7a\x3c"},
  {0x884d, "\x66\x62"}, {0x8852, "\x7a\x65"}, {0x8853, "\x62\x7a"},
  {0x8857, "\x4a\x36"}, {0x8859, "\x64\x37"}, {0x885b, "\x6a\x5b"},
  {0x885d, "\x75\x7a"}, {0x8861, "\x7b\x2c"}, {0x8862, "\x4f\x43"},
  {0x8863, "\x6b\x7d"}, {0x8868, "\x78\x7a"}, {0x886b, "\x5f\x39"},
  {0x8870, "\x61\x71"}, {0x8872, "\x52\x24"}, {0x8877, "\x75\x7b"},
  {0x887e, "\x50\x5a"}, {0x887f, "\x50\x5b"}, {0x8881, "\x6a\x3e"},
  {0x8882, "\x59\x31"}, {0x8888, "\x4a\x37"}, {0x888b, "\x53\x67"},
  {0x888d, "\x78\x65"}, {0x8892, "\x53\x32"}, {0x8896, "\x62\x40"},
  {0x8897, "\x72\x5f"}, {0x889e, "\x4d\x65"}, {0x88ab, "\x79\x2c"},
  {0x88b4, "\x4d\x4d"}, {0x88c1, "\x6e\x2e"}, {0x88c2, "\x56\x2e"},
  {0x88cf, "\x57\x6a"}, {0x88d4, "\x67\x60"}, {0x88d5, "\x6b\x2e"},
  {0x88d9, "\x4f\x59"}, {0x88dc, "\x5c\x4d"}, {0x88dd, "\x6d\x7b"},
  {0x88df, "\x5e\x70"}, {0x88e1, "\x57\x6b"}, {0x88e8, "\x5e\x25"},
  {0x88f3, "\x5f\x57"}, {0x88f4, "\x5b\x50"}, {0x88f5, "\x5b\x51"},
  {0x88f8, "\x55\x23"}, {0x88fd, "\x70\x32"}, {0x8907, "\x5c\x5c"},
  {0x8910, "\x4a\x68"}, {0x8912, "\x78\x66"}, {0x8913, "\x5c\x4e"},
  {0x8918, "\x6a\x5c"}, {0x8919, "\x5b\x52"}, {0x8925, "\x69\x33"},
  {0x892a, "\x77\x5b"}, {0x8936, "\x63\x28"}, {0x8938, "\x57\x2e"},
  {0x893b, "\x60\x61"}, {0x8941, "\x4b\x3a"}, {0x8944, "\x65\x51"},
  {0x895f, "\x50\x5c"}, {0x8964, "\x55\x41"}, {0x896a, "\x58\x4a"},
  {0x8972, "\x63\x29"}, {0x897f, "\x60\x24"}, {0x8981, "\x69\x29"},
  {0x8983, "\x53\x47"}, {0x8986, "\x5c\x5d"}, {0x8987, "\x78\x2e"},
  {0x898b, "\x4c\x38"}, {0x898f, "\x50\x2e"}, {0x8993, "\x58\x72"},
  {0x8996, "\x63\x4a"}, {0x89a1, "\x4c\x2f"}, {0x89a9, "\x54\x2d"},
  {0x89aa, "\x76\x51"}, {0x89b2, "\x50\x4c"}, {0x89ba, "\x4a\x46"},
  {0x89bd, "\x55\x42"}, {0x89c0, "\x4e\x3a"}, {0x89d2, "\x4a\x47"},
  {0x89e3, "\x7a\x30"}, {0x89f4, "\x5f\x58"}, {0x89f8, "\x75\x3a"},
  {0x8a00, "\x65\x6b"}, {0x8a02, "\x6f\x74"}, {0x8a03, "\x5d\x35"},
  {0x8a08, "\x4d\x2a"}, {0x8a0a, "\x63\x72"}, {0x8a0c, "\x7b\x77"},
  {0x8a0e, "\x77\x50"}, {0x8a13, "\x7d\x3a"}, {0x8a16, "\x7d\x61"},
  {0x8a17, "\x76\x7e"}, {0x8a18, "\x51\x40"}, {0x8a1b, "\x68\x45"},
  {0x8a1d, "\x64\x38"}, {0x8a1f, "\x61\x68"}, {0x8a23, "\x4c\x41"},
  {0x8a25, "\x52\x6d"}, {0x8a2a, "\x5b\x3e"}, {0x8a2d, "\x60\x62"},
  {0x8a31, "\x7a\x49"}, {0x8a34, "\x61\x4d"}, {0x8a36, "\x4a\x38"},
  {0x8a3a, "\x72\x60"}, {0x8a3b, "\x71\x49"}, {0x8a50, "\x5e\x71"},
  {0x8a54, "\x70\x5f"}, {0x8a55, "\x78\x44"}, {0x8a5b, "\x6e\x4c"},
  {0x8a5e, "\x5e\x72"}, {0x8a60, "\x67\x49"}, {0x8a62, "\x62\x73"},
  {0x8a63, "\x67\x61"}, {0x8a66, "\x63\x4b"}, {0x8a69, "\x63\x4c"},
  {0x8a6d, "\x4f\x78"}, {0x8a6e, "\x6f\x2c"}, {0x8a70, "\x7d\x7e"},
  {0x8a71, "\x7c\x25"}, {0x8a72, "\x7a\x31"}, {0x8a73, "\x5f\x59"},
  {0x8a75, "\x60\x52"}, {0x8a79, "\x74\x5a"}, {0x8a85, "\x71\x4a"},
  {0x8a87, "\x4e\x23"}, {0x8a8c, "\x72\x3c"}, {0x8a8d, "\x6c\x63"},
  {0x8a93, "\x60\x25"}, {0x8a95, "\x77\x2b"}, {0x8a98, "\x6b\x2f"},
  {0x8a9e, "\x65\x5e"}, {0x8aa0, "\x61\x24"}, {0x8aa1, "\x4d\x2b"},
  {0x8aa3, "\x59\x74"}, {0x8aa4, "\x68\x26"}, {0x8aa5, "\x4d\x4e"},
  {0x8aa6, "\x61\x69"}, {0x8aa8, "\x7c\x6f"}, {0x8aaa, "\x60\x63"},
  {0x8ab0, "\x62\x41"}, {0x8ab2, "\x4e\x24"}, {0x8ab9, "\x5e\x26"},
  {0x8abc, "\x6b\x7e"}, {0x8abe, "\x6b\x5d"}, {0x8abf, "\x70\x60"},
  {0x8ac2, "\x74\x5b"}, {0x8ac4, "\x62\x74"}, {0x8ac7, "\x53\x48"},
  {0x8acb, "\x74\x6b"}, {0x8acd, "\x6e\x35"}, {0x8acf, "\x75\x58"},
  {0x8ad2, "\x55\x5f"}, {0x8ad6, "\x56\x65"}, {0x8adb, "\x6b\x30"},
  {0x8adc, "\x74\x63"}, {0x8ae1, "\x63\x4d"}, {0x8ae6, "\x74\x74"},
  {0x8ae7, "\x7a\x32"}, {0x8aea, "\x6f\x75"}, {0x8aeb, "\x4a\x5f"},
  {0x8aed, "\x6b\x31"}, {0x8aee, "\x6d\x3f"}, {0x8af1, "\x7d\x49"},
  {0x8af6, "\x64\x26"}, {0x8af7, "\x79\x24"}, {0x8af8, "\x70\x33"},
  {0x8afa, "\x65\x6c"}, {0x8afe, "\x51\x67"}, {0x8b00, "\x59\x47"},
  {0x8b01, "\x64\x57"}, {0x8b02, "\x6a\x5d"}, {0x8b04, "\x54\x77"},
  {0x8b0e, "\x5a\x3a"}, {0x8b10, "\x5a\x4d"}, {0x8b14, "\x79\x4c"},
  {0x8b16, "\x61\x5a"}, {0x8b17, "\x5b\x3f"}, {0x8b19, "\x4c\x45"},
  {0x8b1a, "\x6c\x50"}, {0x8b1b, "\x4b\x3b"}, {0x8b1d, "\x5e\x73"},
  {0x8b20, "\x69\x2a"}, {0x8b28, "\x59\x48"}, {0x8b2b, "\x6e\x63"},
  {0x8b2c, "\x57\x3d"}, {0x8b33, "\x4f\x44"}, {0x8b39, "\x50\x4d"},
  {0x8b41, "\x7c\x26"}, {0x8b49, "\x71\x7b"}, {0x8b4e, "\x7d\x52"},
  {0x8b4f, "\x51\x41"}, {0x8b58, "\x63\x5b"}, {0x8b5a, "\x53\x49"},
  {0x8b5c, "\x5c\x4f"}, {0x8b66, "\x4c\x6d"}, {0x8b6c, "\x5e\x27"},
  {0x8b6f, "\x66\x3b"}, {0x8b70, "\x6c\x21"}, {0x8b74, "\x4c\x39"},
  {0x8b77, "\x7b\x5e"}, {0x8b7d, "\x67\x62"}, {0x8b80, "\x54\x41"},
  {0x8b8a, "\x5c\x28"}, {0x8b90, "\x62\x42"}, {0x8b92, "\x73\x58"},
  {0x8b93, "\x65\x53"}, {0x8b96, "\x73\x59"}, {0x8b9a, "\x73\x46"},
  {0x8c37, "\x4d\x5b"}, {0x8c3f, "\x4d\x2c"}, {0x8c41, "\x7c\x43"},
  {0x8c46, "\x54\x67"}, {0x8c48, "\x51\x42"}, {0x8c4a, "\x79\x25"},
  {0x8c4c, "\x68\x55"}, {0x8c55, "\x63\x4e"}, {0x8c5a, "\x54\x4a"},
  {0x8c61, "\x5f\x5a"}, {0x8c6a, "\x7b\x5f"}, {0x8c6b, "\x67\x63"},
  {0x8c79, "\x78\x7b"}, {0x8c7a, "\x63\x4f"}, {0x8c82, "\x75\x30"},
  {0x8c8a, "\x58\x67"}, {0x8c8c, "\x59\x49"}, {0x8c9d, "\x78\x2f"},
  {0x8c9e, "\x6f\x76"}, {0x8ca0, "\x5d\x36"}, {0x8ca1, "\x6e\x2f"},
  {0x8ca2, "\x4d\x78"}, {0x8ca7, "\x5e\x38"}, {0x8ca8, "\x7c\x27"},
  {0x8ca9, "\x77\x7c"}, {0x8caa, "\x77\x31"}, {0x8cab, "\x4e\x3b"},
  {0x8cac, "\x74\x21"}, {0x8caf, "\x6e\x4d"}, {0x8cb0, "\x61\x2e"},
  {0x8cb3, "\x6c\x43"}, {0x8cb4, "\x4f\x7e"}, {0x8cb6, "\x78\x3f"},
  {0x8cb7, "\x58\x62"}, {0x8cb8, "\x53\x68"}, {0x8cbb, "\x5e\x28"},
  {0x8cbc, "\x74\x64"}, {0x8cbd, "\x6c\x42"}, {0x8cbf, "\x59\x75"},
  {0x8cc0, "\x79\x45"}, {0x8cc1, "\x5d\x53"}, {0x8cc2, "\x56\x71"},
  {0x8cc3, "\x6c\x7c"}, {0x8cc4, "\x7c\x70"}, {0x8cc7, "\x6d\x40"},
  {0x8cc8, "\x4a\x39"}, {0x8cca, "\x6e\x64"}, {0x8cd1, "\x72\x61"},
  {0x8cd3, "\x5e\x39"}, {0x8cda, "\x56\x72"}, {0x8cdc, "\x5e\x74"},
  {0x8cde, "\x5f\x5b"}, {0x8ce0, "\x5b\x53"}, {0x8ce2, "\x7a\x67"},
  {0x8ce3, "\x58\x63"}, {0x8ce4, "\x74\x41"}, {0x8ce6, "\x5d\x37"},
  {0x8cea, "\x72\x75"}, {0x8ced, "\x54\x2e"}, {0x8cf4, "\x56\x73"},
  {0x8cfb, "\x5d\x38"}, {0x8cfc, "\x4f\x45"}, {0x8cfd, "\x5f\x5f"},
  {0x8d04, "\x72\x3e"}, {0x8d05, "\x76\x21"}, {0x8d07, "\x6b\x4b"},
  {0x8d08, "\x71\x7c"}, {0x8d0a, "\x73\x47"}, {0x8d0d, "\x60\x6b"},
  {0x8d13, "\x6d\x7c"}, {0x8d16, "\x61\x5b"}, {0x8d64, "\x6e\x65"},
  {0x8d66, "\x5e\x75"}, {0x8d6b, "\x7a\x53"}, {0x8d70, "\x71\x4b"},
  {0x8d73, "\x50\x2f"}, {0x8d74, "\x5d\x39"}, {0x8d77, "\x51\x43"},
  {0x8d85, "\x75\x31"}, {0x8d8a, "\x6a\x46"}, {0x8d99, "\x70\x61"},
  {0x8da3, "\x76\x2c"}, {0x8da8, "\x75\x59"}, {0x8db3, "\x70\x6b"},
  {0x8dba, "\x5d\x3a"}, {0x8dbe, "\x72\x3f"}, {0x8dc6, "\x77\x45"},
  {0x8dcb, "\x5b\x22"}, {0x8dcc, "\x72\x76"}, {0x8dcf, "\x4a\x3a"},
  {0x8ddb, "\x77\x75"}, {0x8ddd, "\x4b\x65"}, {0x8de1, "\x6e\x66"},
  {0x8de3, "\x60\x53"}, {0x8de8, "\x4e\x25"}, {0x8def, "\x56\x58"},
  {0x8df3, "\x54\x2f"}, {0x8e0a, "\x69\x49"}, {0x8e0f, "\x53\x4e"},
  {0x8e10, "\x74\x42"}, {0x8e1e, "\x4b\x66"}, {0x8e2a, "\x71\x21"},
  {0x8e30, "\x6b\x32"}, {0x8e35, "\x71\x22"}, {0x8e42, "\x6b\x33"},
  {0x8e44, "\x70\x34"}, {0x8e47, "\x4b\x74"}, {0x8e48, "\x54\x30"},
  {0x8e49, "\x73\x32"}, {0x8e4a, "\x7b\x37"}, {0x8e59, "\x75\x6c"},
  {0x8e5f, "\x6e\x67"}, {0x8e60, "\x74\x32"}, {0x8e74, "\x75\x6d"},
  {0x8e76, "\x4f\x73"}, {0x8e81, "\x70\x62"}, {0x8e87, "\x6e\x4e"},
  {0x8e8a, "\x71\x4c"}, {0x8e8d, "\x65\x38"}, {0x8eaa, "\x57\x75"},
  {0x8eab, "\x63\x73"}, {0x8eac, "\x4f\x65"}, {0x8ec0, "\x4f\x46"},
  {0x8eca, "\x73\x33"}, {0x8ecb, "\x64\x58"}, {0x8ecc, "\x4f\x79"},
  {0x8ecd, "\x4f\x5a"}, {0x8ed2, "\x7a\x4d"}, {0x8edf, "\x66\x63"},
  {0x8eeb, "\x72\x62"}, {0x8ef8, "\x75\x6e"}, {0x8efb, "\x4a\x3b"},
  {0x8efe, "\x63\x5c"}, {0x8f03, "\x4e\x72"}, {0x8f05, "\x56\x59"},
  {0x8f09, "\x6e\x30"}, {0x8f12, "\x74\x65"}, {0x8f13, "\x58\x42"},
  {0x8f14, "\x5c\x50"}, {0x8f15, "\x4c\x6e"}, {0x8f1b, "\x55\x60"},
  {0x8f1c, "\x76\x4a"}, {0x8f1d, "\x7d\x4a"}, {0x8f1e, "\x58\x56"},
  {0x8f1f, "\x74\x4f"}, {0x8f26, "\x56\x26"}, {0x8f27, "\x5c\x3e"},
  {0x8f29, "\x5b\x54"}, {0x8f2a, "\x57\x47"}, {0x8f2f, "\x72\x7e"},
  {0x8f33, "\x71\x4d"}, {0x8f38, "\x62\x43"}, {0x8f39, "\x5c\x5e"},
  {0x8f3b, "\x5c\x5f"}, {0x8f3e, "\x6f\x2d"}, {0x8f3f, "\x66\x2b"},
  {0x8f44, "\x79\x5d"}, {0x8f45, "\x6a\x3f"}, {0x8f49, "\x6f\x2e"},
  {0x8f4d, "\x74\x50"}, {0x8f4e, "\x4e\x73"}, {0x8f5d, "\x66\x2c"},
  {0x8f5f, "\x4e\x5e"}, {0x8f62, "\x55\x79"}, {0x8f9b, "\x63\x74"},
  {0x8f9c, "\x4d\x50"}, {0x8fa3, "\x55\x38"}, {0x8fa6, "\x77\x7d"},
  {0x8fa8, "\x5c\x29"}, {0x8fad, "\x5e\x76"}, {0x8faf, "\x5c\x2a"},
  {0x8fb0, "\x72\x63"}, {0x8fb1, "\x69\x34"}, {0x8fb2, "\x52\x5c"},
  {0x8fc2, "\x69\x66"}, {0x8fc5, "\x63\x76"}, {0x8fce, "\x67\x4a"},
  {0x8fd1, "\x50\x4e"}, {0x8fd4, "\x5a\x77"}, {0x8fe6, "\x4a\x3c"},
  {0x8fea, "\x6e\x68"}, {0x8feb, "\x5a\x5e"}, {0x8fed, "\x72\x77"},
  {0x8ff0, "\x62\x7b"}, {0x8ff2, "\x4c\x26"}, {0x8ff7, "\x5a\x3b"},
  {0x8ff9, "\x6e\x69"}, {0x8ffd, "\x75\x5a"}, {0x9000, "\x77\x5c"},
  {0x9001, "\x61\x6a"}, {0x9002, "\x4e\x41"}, {0x9003, "\x54\x31"},
  {0x9005, "\x7d\x31"}, {0x9006, "\x66\x3d"}, {0x9008, "\x7b\x2d"},
  {0x900b, "\x78\x67"}, {0x900d, "\x61\x4e"}, {0x900f, "\x77\x62"},
  {0x9010, "\x75\x6f"}, {0x9011, "\x4f\x47"}, {0x9014, "\x54\x32"},
  {0x9015, "\x4c\x6f"}, {0x9017, "\x54\x68"}, {0x9019, "\x6e\x4f"},
  {0x901a, "\x77\x57"}, {0x901d, "\x60\x26"}, {0x901e, "\x56\x41"},
  {0x901f, "\x61\x5c"}, {0x9020, "\x70\x63"}, {0x9021, "\x71\x64"},
  {0x9022, "\x5c\x71"}, {0x9023, "\x56\x27"}, {0x902e, "\x74\x75"},
  {0x9031, "\x71\x4e"}, {0x9032, "\x72\x64"}, {0x9035, "\x50\x30"},
  {0x9038, "\x6c\x6f"}, {0x903c, "\x79\x3a"}, {0x903e, "\x6b\x35"},
  {0x9041, "\x54\x6d"}, {0x9042, "\x62\x44"}, {0x9047, "\x69\x67"},
  {0x904a, "\x6b\x34"}, {0x904b, "\x6a\x21"}, {0x904d, "\x78\x3c"},
  {0x904e, "\x4e\x26"}, {0x9050, "\x79\x46"}, {0x9051, "\x7c\x5a"},
  {0x9053, "\x54\x33"}, {0x9054, "\x53\x39"}, {0x9055, "\x6a\x5e"},
  {0x9059, "\x69\x2b"}, {0x905c, "\x61\x61"}, {0x905d, "\x53\x4f"},
  {0x905e, "\x74\x76"}, {0x9060, "\x6a\x40"}, {0x9061, "\x61\x4f"},
  {0x9063, "\x4c\x3a"}, {0x9069, "\x6e\x6a"}, {0x906d, "\x70\x64"},
  {0x906e, "\x73\x34"}, {0x906f, "\x54\x6e"}, {0x9072, "\x72\x40"},
  {0x9075, "\x71\x65"}, {0x9077, "\x74\x43"}, {0x9078, "\x60\x54"},
  {0x907a, "\x6b\x36"}, {0x907c, "\x57\x21"}, {0x907d, "\x4b\x68"},
  {0x907f, "\x79\x2d"}, {0x9080, "\x69\x2d"}, {0x9081, "\x58\x64"},
  {0x9082, "\x7a\x33"}, {0x9083, "\x62\x45"}, {0x9084, "\x7c\x3d"},
  {0x9087, "\x6c\x44"}, {0x9088, "\x58\x31"}, {0x908a, "\x5c\x2b"},
  {0x908f, "\x55\x24"}, {0x9091, "\x6b\x69"}, {0x9095, "\x68\x3b"},
  {0x9099, "\x58\x57"}, {0x90a2, "\x7b\x2e"}, {0x90a3, "\x51\x61"},
  {0x90a6, "\x5b\x40"}, {0x90a8, "\x75\x3e"}, {0x90aa, "\x5e\x77"},
  {0x90af, "\x4a\x7b"}, {0x90b0, "\x77\x46"}, {0x90b1, "\x4f\x48"},
  {0x90b5, "\x61\x50"}, {0x90b8, "\x6e\x50"}, {0x90c1, "\x69\x74"},
  {0x90ca, "\x4e\x74"}, {0x90de, "\x55\x4d"}, {0x90e1, "\x4f\x5b"},
  {0x90e8, "\x5d\x3b"}, {0x90ed, "\x4e\x2c"}, {0x90f5, "\x69\x68"},
  {0x90fd, "\x54\x34"}, {0x9102, "\x64\x47"}, {0x9112, "\x75\x5b"},
  {0x9115, "\x7a\x41"}, {0x9119, "\x5e\x29"}, {0x9127, "\x54\x78"},
  {0x912d, "\x6f\x77"}, {0x9132, "\x53\x33"}, {0x9149, "\x6b\x37"},
  {0x914a, "\x6f\x78"}, {0x914b, "\x75\x5c"}, {0x914c, "\x6d\x4c"},
  {0x914d, "\x5b\x55"}, {0x914e, "\x71\x4f"}, {0x9152, "\x71\x50"},
  {0x9162, "\x75\x32"}, {0x9169, "\x59\x2e"}, {0x916a, "\x55\x2c"},
  {0x916c, "\x62\x46"}, {0x9175, "\x7d\x23"}, {0x9177, "\x7b\x65"},
  {0x9178, "\x5f\x2b"}, {0x9187, "\x62\x75"}, {0x9189, "\x76\x2d"},
  {0x918b, "\x75\x33"}, {0x918d, "\x70\x35"}, {0x9192, "\x61\x25"},
  {0x919c, "\x75\x5d"}, {0x91ab, "\x6c\x22"}, {0x91ac, "\x6d\x7d"},
  {0x91ae, "\x75\x34"}, {0x91af, "\x7b\x38"}, {0x91b1, "\x5b\x23"},
  {0x91b4, "\x56\x4a"}, {0x91b5, "\x4b\x59"}, {0x91c0, "\x65\x54"},
  {0x91c7, "\x73\x7a"}, {0x91c9, "\x6b\x38"}, {0x91cb, "\x60\x37"},
  {0x91cc, "\x57\x6c"}, {0x91cd, "\x71\x6c"}, {0x91ce, "\x65\x2f"},
  {0x91cf, "\x55\x61"}, {0x91d0, "\x57\x6d"}, {0x91d1, "\x51\x51"},
  {0x91d7, "\x61\x72"}, {0x91d8, "\x6f\x79"}, {0x91dc, "\x5d\x3c"},
  {0x91dd, "\x76\x5c"}, {0x91e3, "\x70\x65"}, {0x91e7, "\x74\x44"},
  {0x91ea, "\x69\x69"}, {0x91f5, "\x73\x7b"}, {0x920d, "\x54\x6f"},
  {0x9210, "\x4c\x22"}, {0x9211, "\x77\x7e"}, {0x9212, "\x5f\x3c"},
  {0x9217, "\x6b\x4d"}, {0x921e, "\x50\x37"}, {0x9234, "\x56\x42"},
  {0x923a, "\x68\x2d"}, {0x923f, "\x6f\x2f"}, {0x9240, "\x4b\x25"},
  {0x9245, "\x4b\x69"}, {0x9249, "\x7a\x68"}, {0x9257, "\x4c\x46"},
  {0x925b, "\x66\x67"}, {0x925e, "\x6a\x47"}, {0x9262, "\x5b\x24"},
  {0x9264, "\x4f\x49"}, {0x9265, "\x62\x7c"}, {0x9266, "\x6f\x7a"},
  {0x9280, "\x6b\x5e"}, {0x9283, "\x75\x48"}, {0x9285, "\x54\x5e"},
  {0x9291, "\x60\x55"}, {0x9293, "\x6f\x30"}, {0x9296, "\x62\x47"},
  {0x9298, "\x59\x2f"}, {0x929c, "\x79\x67"}, {0x92b3, "\x67\x65"},
  {0x92b6, "\x4f\x4a"}, {0x92b7, "\x61\x51"}, {0x92b9, "\x62\x48"},
  {0x92cc, "\x6f\x7b"}, {0x92cf, "\x7a\x79"}, {0x92d2, "\x5c\x72"},
  {0x92e4, "\x60\x27"}, {0x92ea, "\x78\x68"}, {0x92f8, "\x4b\x6a"},
  {0x92fc, "\x4b\x3c"}, {0x9304, "\x56\x62"}, {0x9310, "\x75\x5e"},
  {0x9318, "\x75\x5f"}, {0x931a, "\x6e\x36"}, {0x931e, "\x62\x76"},
  {0x931f, "\x53\x4a"}, {0x9320, "\x6f\x7c"}, {0x9321, "\x51\x44"},
  {0x9322, "\x6f\x31"}, {0x9324, "\x51\x45"}, {0x9326, "\x50\x5e"},
  {0x9328, "\x59\x61"}, {0x932b, "\x60\x38"}, {0x932e, "\x4d\x51"},
  {0x932f, "\x73\x39"}, {0x9348, "\x67\x4c"}, {0x934a, "\x56\x28"},
  {0x934b, "\x4e\x27"}, {0x934d, "\x54\x35"}, {0x9354, "\x64\x48"},
  {0x935b, "\x53\x34"}, {0x936e, "\x6b\x39"}, {0x9375, "\x4b\x75"},
  {0x937c, "\x76\x5d"}, {0x937e, "\x71\x23"}, {0x938c, "\x4c\x47"},
  {0x9394, "\x69\x4a"}, {0x9396, "\x61\x70"}, {0x939a, "\x75\x60"},
  {0x93a3, "\x7b\x2f"}, {0x93a7, "\x4b\x51"}, {0x93ac, "\x7b\x60"},
  {0x93ad, "\x72\x65"}, {0x93b0, "\x6c\x70"}, {0x93c3, "\x70\x6c"},
  {0x93d1, "\x6e\x6b"}, {0x93de, "\x69\x4b"}, {0x93e1, "\x4c\x70"},
  {0x93e4, "\x57\x2f"}, {0x93f6, "\x73\x21"}, {0x9404, "\x7c\x75"},
  {0x9418, "\x71\x24"}, {0x9425, "\x60\x56"}, {0x942b, "\x6f\x32"},
  {0x9435, "\x74\x51"}, {0x9438, "\x77\x21"}, {0x9444, "\x71\x51"},
  {0x9451, "\x4a\x7c"}, {0x9452, "\x4a\x7d"}, {0x945b, "\x4e\x4e"},
  {0x947d, "\x73\x48"}, {0x947f, "\x73\x3a"}, {0x9577, "\x6d\x7e"},
  {0x9580, "\x5a\x26"}, {0x9583, "\x60\x6c"}, {0x9589, "\x78\x4d"},
  {0x958b, "\x4b\x52"}, {0x958f, "\x6b\x4e"}, {0x9591, "\x79\x58"},
  {0x9592, "\x79\x59"}, {0x9593, "\x4a\x60"}, {0x9594, "\x5a\x4a"},
  {0x9598, "\x4b\x26"}, {0x95a3, "\x4a\x48"}, {0x95a4, "\x79\x6e"},
  {0x95a5, "\x5b\x6c"}, {0x95a8, "\x50\x31"}, {0x95ad, "\x55\x6f"},
  {0x95b1, "\x66\x73"}, {0x95bb, "\x67\x22"}, {0x95bc, "\x64\x59"},
  {0x95c7, "\x64\x61"}, {0x95ca, "\x7c\x44"}, {0x95d4, "\x79\x6f"},
  {0x95d5, "\x4f\x74"}, {0x95d6, "\x77\x66"}, {0x95dc, "\x4e\x3c"},
  {0x95e1, "\x74\x45"}, {0x95e2, "\x5c\x23"}, {0x961c, "\x5d\x3d"},
  {0x9621, "\x74\x46"}, {0x962a, "\x78\x21"}, {0x962e, "\x68\x56"},
  {0x9632, "\x5b\x41"}, {0x963b, "\x70\x66"}, {0x963f, "\x64\x39"},
  {0x9640, "\x76\x6d"}, {0x9642, "\x79\x2e"}, {0x9644, "\x5d\x3e"},
  {0x964b, "\x57\x30"}, {0x964c, "\x58\x68"}, {0x964d, "\x4b\x3d"},
  {0x9650, "\x79\x5a"}, {0x965b, "\x78\x4e"}, {0x965c, "\x79\x70"},
  {0x965d, "\x60\x6d"}, {0x965e, "\x63\x33"}, {0x965f, "\x74\x33"},
  {0x9662, "\x6a\x42"}, {0x9663, "\x72\x66"}, {0x9664, "\x70\x36"},
  {0x966a, "\x5b\x56"}, {0x9670, "\x6b\x64"}, {0x9673, "\x72\x67"},
  {0x9675, "\x57\x55"}, {0x9676, "\x54\x36"}, {0x9677, "\x79\x68"},
  {0x9678, "\x57\x41"}, {0x967d, "\x65\x55"}, {0x9685, "\x69\x6a"},
  {0x9686, "\x57\x4c"}, {0x968a, "\x53\x69"}, {0x968b, "\x62\x49"},
  {0x968d, "\x7c\x5b"}, {0x968e, "\x4d\x2d"}, {0x9694, "\x4c\x30"},
  {0x9695, "\x6a\x22"}, {0x9698, "\x64\x76"}, {0x9699, "\x50\x40"},
  {0x969b, "\x70\x37"}, {0x969c, "\x6e\x21"}, {0x96a3, "\x57\x76"},
  {0x96a7, "\x62\x4a"}, {0x96a8, "\x62\x4b"}, {0x96aa, "\x7a\x4f"},
  {0x96b1, "\x6b\x5f"}, {0x96b7, "\x56\x4b"}, {0x96bb, "\x74\x34"},
  {0x96c0, "\x6d\x4d"}, {0x96c1, "\x64\x52"}, {0x96c4, "\x6a\x29"},
  {0x96c5, "\x64\x3a"}, {0x96c6, "\x73\x22"}, {0x96c7, "\x4d\x52"},
  {0x96c9, "\x76\x4b"}, {0x96cb, "\x71\x66"}, {0x96cc, "\x6d\x41"},
  {0x96cd, "\x68\x3c"}, {0x96ce, "\x6e\x51"}, {0x96d5, "\x70\x67"},
  {0x96d6, "\x62\x4c"}, {0x96d9, "\x64\x2a"}, {0x96db, "\x75\x61"},
  {0x96dc, "\x6d\x5a"}, {0x96e2, "\x57\x6e"}, {0x96e3, "\x51\x71"},
  {0x96e8, "\x69\x6b"}, {0x96e9, "\x69\x6c"}, {0x96ea, "\x60\x64"},
  {0x96ef, "\x5a\x27"}, {0x96f0, "\x5d\x54"}, {0x96f2, "\x6a\x23"},
  {0x96f6, "\x56\x43"}, {0x96f7, "\x56\x74"}, {0x96f9, "\x5a\x5f"},
  {0x96fb, "\x6f\x33"}, {0x9700, "\x62\x4d"}, {0x9706, "\x6f\x7d"},
  {0x9707, "\x72\x68"}, {0x9711, "\x6f\x45"}, {0x9713, "\x67\x67"},
  {0x9716, "\x57\x7d"}, {0x9719, "\x67\x4e"}, {0x971c, "\x5f\x5c"},
  {0x971e, "\x79\x47"}, {0x9727, "\x59\x76"}, {0x9730, "\x5f\x2c"},
  {0x9732, "\x56\x5a"}, {0x9739, "\x5c\x24"}, {0x973d, "\x70\x38"},
  {0x9742, "\x55\x7a"}, {0x9744, "\x64\x77"}, {0x9748, "\x56\x44"},
  {0x9751, "\x74\x6c"}, {0x9756, "\x6f\x7e"}, {0x975c, "\x70\x21"},
  {0x975e, "\x5e\x2a"}, {0x9761, "\x5a\x3c"}, {0x9762, "\x58\x7c"},
  {0x9769, "\x7a\x54"}, {0x976d, "\x6c\x65"}, {0x9774, "\x7c\x28"},
  {0x9777, "\x6c\x66"}, {0x977a, "\x58\x4b"}, {0x978b, "\x7b\x39"},
  {0x978d, "\x64\x53"}, {0x978f, "\x4d\x79"}, {0x97a0, "\x4f\x53"},
  {0x97a8, "\x4a\x6a"}, {0x97ab, "\x4f\x54"}, {0x97ad, "\x78\x3d"},
  {0x97c6, "\x74\x47"}, {0x97cb, "\x6a\x5f"}, {0x97d3, "\x79\x5b"},
  {0x97dc, "\x54\x37"}, {0x97f3, "\x6b\x65"}, {0x97f6, "\x61\x52"},
  {0x97fb, "\x6a\x24"}, {0x97ff, "\x7a\x42"}, {0x9800, "\x7b\x61"},
  {0x9801, "\x7a\x6d"}, {0x9802, "\x70\x22"}, {0x9803, "\x4c\x71"},
  {0x9805, "\x7a\x23"}, {0x9806, "\x62\x77"}, {0x9808, "\x62\x4e"},
  {0x980a, "\x69\x75"}, {0x980c, "\x61\x6b"}, {0x9810, "\x67\x68"},
  {0x9811, "\x68\x57"}, {0x9812, "\x5a\x78"}, {0x9813, "\x54\x4b"},
  {0x9817, "\x77\x76"}, {0x9818, "\x56\x45"}, {0x982d, "\x54\x69"},
  {0x9830, "\x7a\x7a"}, {0x9838, "\x4c\x72"}, {0x9839, "\x77\x5d"},
  {0x983b, "\x5e\x3a"}, {0x9846, "\x4e\x28"}, {0x984c, "\x70\x39"},
  {0x984d, "\x64\x7e"}, {0x984e, "\x64\x49"}, {0x9854, "\x64\x54"},
  {0x9858, "\x6a\x43"}, {0x985a, "\x6f\x34"}, {0x985e, "\x57\x3e"},
  {0x9865, "\x7b\x62"}, {0x9867, "\x4d\x53"}, {0x986b, "\x6f\x35"},
  {0x986f, "\x7a\x69"}, {0x98a8, "\x79\x26"}, {0x98af, "\x5f\x3d"},
  {0x98b1, "\x77\x47"}, {0x98c4, "\x78\x7d"}, {0x98c7, "\x78\x7c"},
  {0x98db, "\x5e\x2b"}, {0x98dc, "\x5b\x68"}, {0x98df, "\x63\x5d"},
  {0x98e1, "\x61\x62"}, {0x98e2, "\x51\x46"}, {0x98ed, "\x76\x50"},
  {0x98ee, "\x6b\x66"}, {0x98ef, "\x5a\x79"}, {0x98f4, "\x6c\x47"},
  {0x98fc, "\x5e\x78"}, {0x98fd, "\x78\x69"}, {0x98fe, "\x63\x5e"},
  {0x9903, "\x4e\x75"}, {0x9909, "\x7a\x43"}, {0x990a, "\x65\x57"},
  {0x990c, "\x6c\x48"}, {0x9910, "\x73\x49"}, {0x9913, "\x64\x3b"},
  {0x9918, "\x66\x2e"}, {0x991e, "\x6f\x36"}, {0x9920, "\x5c\x3f"},
  {0x9928, "\x4e\x3d"}, {0x9945, "\x58\x43"}, {0x9949, "\x50\x4f"},
  {0x994b, "\x4f\x7a"}, {0x994c, "\x73\x4a"}, {0x994d, "\x60\x57"},
  {0x9951, "\x51\x47"}, {0x9952, "\x69\x2e"}, {0x9954, "\x68\x3d"},
  {0x9957, "\x7a\x44"}, {0x9996, "\x62\x4f"}, {0x9999, "\x7a\x45"},
  {0x999d, "\x79\x38"}, {0x99a5, "\x5c\x60"}, {0x99a8, "\x7b\x30"},
  {0x99ac, "\x58\x29"}, {0x99ad, "\x65\x5f"}, {0x99ae, "\x79\x27"},
  {0x99b1, "\x76\x6e"}, {0x99b3, "\x76\x4c"}, {0x99b4, "\x62\x78"},
  {0x99b9, "\x6c\x71"}, {0x99c1, "\x5a\x60"}, {0x99d0, "\x71\x52"},
  {0x99d1, "\x52\x4c"}, {0x99d2, "\x4f\x4b"}, {0x99d5, "\x4a\x3d"},
  {0x99d9, "\x5d\x3f"}, {0x99dd, "\x76\x6f"}, {0x99df, "\x5e\x79"},
  {0x99ed, "\x7a\x34"}, {0x99f1, "\x55\x2d"}, {0x99ff, "\x71\x67"},
  {0x9a01, "\x5e\x3e"}, {0x9a08, "\x5c\x40"}, {0x9a0e, "\x51\x48"},
  {0x9a0f, "\x51\x49"}, {0x9a19, "\x78\x3e"}, {0x9a2b, "\x4b\x76"},
  {0x9a30, "\x54\x79"}, {0x9a36, "\x75\x62"}, {0x9a37, "\x61\x53"},
  {0x9a40, "\x58\x69"}, {0x9a43, "\x78\x7e"}, {0x9a45, "\x4f\x4c"},
  {0x9a4d, "\x7d\x24"}, {0x9a55, "\x4e\x76"}, {0x9a57, "\x7a\x50"},
  {0x9a5a, "\x4c\x73"}, {0x9a5b, "\x66\x3e"}, {0x9a5f, "\x76\x2e"},
  {0x9a62, "\x55\x70"}, {0x9a65, "\x51\x4a"}, {0x9a69, "\x7c\x3e"},
  {0x9a6a, "\x55\x71"}, {0x9aa8, "\x4d\x69"}, {0x9ab8, "\x7a\x35"},
  {0x9ad3, "\x62\x50"}, {0x9ad4, "\x74\x77"}, {0x9ad8, "\x4d\x54"},
  {0x9ae5, "\x67\x23"}, {0x9aee, "\x5b\x25"}, {0x9b1a, "\x62\x51"},
  {0x9b27, "\x57\x22"}, {0x9b2a, "\x77\x63"}, {0x9b31, "\x6a\x26"},
  {0x9b3c, "\x50\x21"}, {0x9b41, "\x4e\x5a"}, {0x9b42, "\x7b\x6b"},
  {0x9b43, "\x5b\x26"}, {0x9b44, "\x5b\x5e"}, {0x9b45, "\x58\x65"},
  {0x9b4f, "\x6a\x60"}, {0x9b54, "\x58\x2a"}, {0x9b5a, "\x65\x60"},
  {0x9b6f, "\x56\x5b"}, {0x9b8e, "\x6f\x46"}, {0x9b91, "\x78\x6a"},
  {0x9b9f, "\x64\x55"}, {0x9bab, "\x4e\x77"}, {0x9bae, "\x60\x58"},
  {0x9bc9, "\x57\x6f"}, {0x9bd6, "\x74\x6d"}, {0x9be4, "\x4d\x66"},
  {0x9be8, "\x4c\x74"}, {0x9c0d, "\x75\x63"}, {0x9c10, "\x64\x4a"},
  {0x9c12, "\x5c\x61"}, {0x9c15, "\x79\x48"}, {0x9c25, "\x7c\x3f"},
  {0x9c32, "\x68\x27"}, {0x9c3b, "\x58\x44"}, {0x9c47, "\x4b\x3e"},
  {0x9c49, "\x5c\x2e"}, {0x9c57, "\x57\x77"}, {0x9ce5, "\x70\x68"},
  {0x9ce7, "\x5d\x40"}, {0x9ce9, "\x4f\x4d"}, {0x9cf3, "\x5c\x73"},
  {0x9cf4, "\x59\x30"}, {0x9cf6, "\x66\x69"}, {0x9d09, "\x64\x3c"},
  {0x9d1b, "\x6a\x44"}, {0x9d26, "\x64\x6c"}, {0x9d28, "\x64\x65"},
  {0x9d3b, "\x7b\x78"}, {0x9d51, "\x4c\x3b"}, {0x9d5d, "\x64\x3d"},
  {0x9d60, "\x4d\x5c"}, {0x9d61, "\x59\x77"}, {0x9d6c, "\x5d\x5f"},
  {0x9d72, "\x6d\x4e"}, {0x9da9, "\x59\x50"}, {0x9daf, "\x65\x23"},
  {0x9db4, "\x79\x4d"}, {0x9dc4, "\x4d\x2e"}, {0x9dd7, "\x4f\x4e"},
  {0x9df2, "\x76\x2f"}, {0x9df8, "\x7d\x53"}, {0x9df9, "\x6b\x6d"},
  {0x9dfa, "\x56\x5c"}, {0x9e1a, "\x65\x24"}, {0x9e1e, "\x55\x36"},
  {0x9e75, "\x56\x5d"}, {0x9e79, "\x79\x69"}, {0x9e7d, "\x67\x24"},
  {0x9e7f, "\x56\x63"}, {0x9e92, "\x51\x4b"}, {0x9e93, "\x56\x64"},
  {0x9e97, "\x55\x72"}, {0x9e9d, "\x5e\x7a"}, {0x9e9f, "\x57\x78"},
  {0x9ea5, "\x58\x6a"}, {0x9eb4, "\x4f\x55"}, {0x9eb5, "\x58\x7d"},
  {0x9ebb, "\x58\x2b"}, {0x9ebe, "\x7d\x4b"}, {0x9ec3, "\x7c\x5c"},
  {0x9ecd, "\x60\x28"}, {0x9ece, "\x55\x73"}, {0x9ed1, "\x7d\x59"},
  {0x9ed4, "\x4c\x23"}, {0x9ed8, "\x59\x79"}, {0x9edb, "\x53\x6a"},
  {0x9edc, "\x75\x75"}, {0x9ede, "\x6f\x47"}, {0x9ee8, "\x53\x5a"},
  {0x9ef4, "\x5a\x3d"}, {0x9f07, "\x68\x28"}, {0x9f08, "\x5c\x2f"},
  {0x9f0e, "\x70\x23"}, {0x9f13, "\x4d\x55"}, {0x9f20, "\x60\x29"},
  {0x9f3b, "\x5e\x2c"}, {0x9f4a, "\x70\x3a"}, {0x9f4b, "\x6e\x31"},
  {0x9f4e, "\x6e\x32"}, {0x9f52, "\x76\x4d"}, {0x9f5f, "\x6e\x52"},
  {0x9f61, "\x56\x46"}, {0x9f67, "\x60\x65"}, {0x9f6a, "\x73\x3b"},
  {0x9f6c, "\x65\x61"}, {0x9f77, "\x64\x4b"}, {0x9f8d, "\x57\x23"},
  {0x9f90, "\x5b\x42"}, {0x9f95, "\x4a\x7e"}, {0x9f9c, "\x4f\x4f"},
  {0xf900, "\x4b\x50"}, {0xf901, "\x4b\x56"}, {0xf902, "\x4b\x67"},
  {0xf903, "\x4d\x4f"}, {0xf904, "\x4d\x68"}, {0xf905, "\x4e\x2d"},
  {0xf906, "\x4f\x7b"}, {0xf907, "\x50\x22"}, {0xf908, "\x50\x38"},
  {0xf909, "\x50\x50"}, {0xf90a, "\x50\x5d"}, {0xf90b, "\x51\x54"},
  {0xf90c, "\x51\x55"}, {0xf90d, "\x51\x58"}, {0xf90e, "\x51\x5b"},
  {0xf90f, "\x51\x5c"}, {0xf910, "\x51\x5d"}, {0xf911, "\x51\x5e"},
  {0xf912, "\x51\x5f"}, {0xf913, "\x51\x60"}, {0xf914, "\x51\x62"},
  {0xf915, "\x51\x63"}, {0xf916, "\x51\x64"}, {0xf917, "\x51\x65"},
  {0xf918, "\x51\x66"}, {0xf919, "\x51\x68"}, {0xf91a, "\x51\x69"},
  {0xf91b, "\x51\x6a"}, {0xf91c, "\x51\x6b"}, {0xf91d, "\x51\x6d"},
  {0xf91e, "\x51\x6f"}, {0xf91f, "\x51\x70"}, {0xf920, "\x51\x72"},
  {0xf921, "\x51\x76"}, {0xf922, "\x51\x7a"}, {0xf923, "\x51\x7c"},
  {0xf924, "\x51\x7d"}, {0xf925, "\x51\x7e"}, {0xf926, "\x52\x22"},
  {0xf927, "\x52\x23"}, {0xf928, "\x52\x27"}, {0xf929, "\x52\x28"},
  {0xf92a, "\x52\x29"}, {0xf92b, "\x52\x2a"}, {0xf92c, "\x52\x2b"},
  {0xf92d, "\x52\x2d"}, {0xf92e, "\x52\x32"}, {0xf92f, "\x52\x3e"},
  {0xf930, "\x52\x42"}, {0xf931, "\x52\x43"}, {0xf932, "\x52\x44"},
  {0xf933, "\x52\x46"}, {0xf934, "\x52\x47"}, {0xf935, "\x52\x48"},
  {0xf936, "\x52\x49"}, {0xf937, "\x52\x4a"}, {0xf938, "\x52\x4b"},
  {0xf939, "\x52\x4d"}, {0xf93a, "\x52\x4e"}, {0xf93b, "\x52\x4f"},
  {0xf93c, "\x52\x50"}, {0xf93d, "\x52\x51"}, {0xf93e, "\x52\x52"},
  {0xf93f, "\x52\x53"}, {0xf940, "\x52\x54"}, {0xf941, "\x52\x55"},
  {0xf942, "\x52\x56"}, {0xf943, "\x52\x57"}, {0xf944, "\x52\x59"},
  {0xf945, "\x52\x5a"}, {0xf946, "\x52\x5e"}, {0xf947, "\x52\x5f"},
  {0xf948, "\x52\x61"}, {0xf949, "\x52\x62"}, {0xf94a, "\x52\x64"},
  {0xf94b, "\x52\x65"}, {0xf94c, "\x52\x66"}, {0xf94d, "\x52\x67"},
  {0xf94e, "\x52\x68"}, {0xf94f, "\x52\x69"}, {0xf950, "\x52\x6a"},
  {0xf951, "\x52\x6b"}, {0xf952, "\x52\x70"}, {0xf953, "\x52\x71"},
  {0xf954, "\x52\x72"}, {0xf955, "\x52\x73"}, {0xf956, "\x52\x74"},
  {0xf957, "\x52\x75"}, {0xf958, "\x52\x77"}, {0xf959, "\x52\x78"},
  {0xf95a, "\x54\x66"}, {0xf95b, "\x54\x7c"}, {0xf95c, "\x55\x25"},
  {0xf95d, "\x55\x2b"}, {0xf95e, "\x55\x2e"}, {0xf95f, "\x56\x38"},
  {0xf960, "\x56\x4d"}, {0xf961, "\x57\x4b"}, {0xf962, "\x57\x64"},
  {0xf963, "\x5b\x45"}, {0xf964, "\x5b\x64"}, {0xf965, "\x5c\x25"},
  {0xf966, "\x5d\x25"}, {0xf967, "\x5d\x55"}, {0xf968, "\x5d\x74"},
  {0xf969, "\x5e\x7c"}, {0xf96a, "\x5e\x7e"}, {0xf96b, "\x5f\x33"},
  {0xf96c, "\x5f\x61"}, {0xf96d, "\x5f\x68"}, {0xf96e, "\x60\x71"},
  {0xf96f, "\x61\x2d"}, {0xf970, "\x61\x6d"}, {0xf971, "\x63\x75"},
  {0xf972, "\x64\x21"}, {0xf973, "\x64\x29"}, {0xf974, "\x65\x2e"},
  {0xf975, "\x65\x31"}, {0xf976, "\x65\x32"}, {0xf977, "\x65\x39"},
  {0xf978, "\x65\x3b"}, {0xf979, "\x65\x3c"}, {0xf97a, "\x65\x44"},
  {0xf97b, "\x65\x4e"}, {0xf97c, "\x65\x50"}, {0xf97d, "\x65\x52"},
  {0xf97e, "\x65\x56"}, {0xf97f, "\x65\x7a"}, {0xf980, "\x65\x7b"},
  {0xf981, "\x65\x7c"}, {0xf982, "\x65\x7e"}, {0xf983, "\x66\x21"},
  {0xf984, "\x66\x24"}, {0xf985, "\x66\x27"}, {0xf986, "\x66\x2d"},
  {0xf987, "\x66\x2f"}, {0xf988, "\x66\x30"}, {0xf989, "\x66\x31"},
  {0xf98a, "\x66\x33"}, {0xf98b, "\x66\x37"}, {0xf98c, "\x66\x38"},
  {0xf98d, "\x66\x3c"}, {0xf98e, "\x66\x44"}, {0xf98f, "\x66\x46"},
  {0xf990, "\x66\x47"}, {0xf991, "\x66\x4a"}, {0xf992, "\x66\x52"},
  {0xf993, "\x66\x56"}, {0xf994, "\x66\x59"}, {0xf995, "\x66\x5c"},
  {0xf996, "\x66\x5f"}, {0xf997, "\x66\x61"}, {0xf998, "\x66\x64"},
  {0xf999, "\x66\x65"}, {0xf99a, "\x66\x66"}, {0xf99b, "\x66\x68"},
  {0xf99c, "\x66\x6a"}, {0xf99d, "\x66\x6b"}, {0xf99e, "\x66\x6c"},
  {0xf99f, "\x66\x6f"}, {0xf9a0, "\x66\x71"}, {0xf9a1, "\x66\x72"},
  {0xf9a2, "\x66\x75"}, {0xf9a3, "\x66\x76"}, {0xf9a4, "\x66\x77"},
  {0xf9a5, "\x66\x79"}, {0xf9a6, "\x67\x21"}, {0xf9a7, "\x67\x26"},
  {0xf9a8, "\x67\x29"}, {0xf9a9, "\x67\x2a"}, {0xf9aa, "\x67\x2c"},
  {0xf9ab, "\x67\x2d"}, {0xf9ac, "\x67\x30"}, {0xf9ad, "\x67\x3f"},
  {0xf9ae, "\x67\x41"}, {0xf9af, "\x67\x46"}, {0xf9b0, "\x67\x47"},
  {0xf9b1, "\x67\x4b"}, {0xf9b2, "\x67\x4d"}, {0xf9b3, "\x67\x4f"},
  {0xf9b4, "\x67\x50"}, {0xf9b5, "\x67\x53"}, {0xf9b6, "\x67\x5f"},
  {0xf9b7, "\x67\x64"}, {0xf9b8, "\x67\x66"}, {0xf9b9, "\x67\x77"},
  {0xf9ba, "\x68\x67"}, {0xf9bb, "\x68\x68"}, {0xf9bc, "\x68\x70"},
  {0xf9bd, "\x68\x71"}, {0xf9be, "\x68\x77"}, {0xf9bf, "\x68\x79"},
  {0xf9c0, "\x68\x7b"}, {0xf9c1, "\x68\x7e"}, {0xf9c2, "\x69\x27"},
  {0xf9c3, "\x69\x2c"}, {0xf9c4, "\x69\x4c"}, {0xf9c5, "\x69\x77"},
  {0xf9c6, "\x6a\x41"}, {0xf9c7, "\x6a\x65"}, {0xf9c8, "\x6a\x74"},
  {0xf9c9, "\x6a\x77"}, {0xf9ca, "\x6a\x7c"}, {0xf9cb, "\x6a\x7e"},
  {0xf9cc, "\x6b\x24"}, {0xf9cd, "\x6b\x27"}, {0xf9ce, "\x6b\x29"},
  {0xf9cf, "\x6b\x2a"}, {0xf9d0, "\x6b\x3a"}, {0xf9d1, "\x6b\x3b"},
  {0xf9d2, "\x6b\x3d"}, {0xf9d3, "\x6b\x41"}, {0xf9d4, "\x6b\x42"},
  {0xf9d5, "\x6b\x46"}, {0xf9d6, "\x6b\x47"}, {0xf9d7, "\x6b\x4c"},
  {0xf9d8, "\x6b\x4f"}, {0xf9d9, "\x6b\x50"}, {0xf9da, "\x6b\x51"},
  {0xf9db, "\x6b\x52"}, {0xf9dc, "\x6b\x58"}, {0xf9dd, "\x6c\x26"},
  {0xf9de, "\x6c\x27"}, {0xf9df, "\x6c\x2a"}, {0xf9e0, "\x6c\x2f"},
  {0xf9e1, "\x6c\x30"}, {0xf9e2, "\x6c\x31"}, {0xf9e3, "\x6c\x32"},
  {0xf9e4, "\x6c\x35"}, {0xf9e5, "\x6c\x38"}, {0xf9e6, "\x6c\x3a"},
  {0xf9e7, "\x6c\x40"}, {0xf9e8, "\x6c\x41"}, {0xf9e9, "\x6c\x45"},
  {0xf9ea, "\x6c\x46"}, {0xf9eb, "\x6c\x49"}, {0xf9ec, "\x6c\x4a"},
  {0xf9ed, "\x6c\x55"}, {0xf9ee, "\x6c\x5d"}, {0xf9ef, "\x6c\x5e"},
  {0xf9f0, "\x6c\x61"}, {0xf9f1, "\x6c\x64"}, {0xf9f2, "\x6c\x67"},
  {0xf9f3, "\x6c\x68"}, {0xf9f4, "\x6c\x77"}, {0xf9f5, "\x6c\x78"},
  {0xf9f6, "\x6c\x7a"}, {0xf9f7, "\x6d\x21"}, {0xf9f8, "\x6d\x22"},
  {0xf9f9, "\x6d\x23"}, {0xf9fa, "\x6d\x6e"}, {0xf9fb, "\x6e\x5b"},
  {0xf9fc, "\x72\x3d"}, {0xf9fd, "\x72\x7a"}, {0xf9fe, "\x73\x31"},
  {0xf9ff, "\x74\x27"}, {0xfa00, "\x74\x6e"}, {0xfa01, "\x76\x74"},
  {0xfa02, "\x76\x76"}, {0xfa03, "\x77\x38"}, {0xfa04, "\x77\x48"},
  {0xfa05, "\x77\x53"}, {0xfa06, "\x78\x5b"}, {0xfa07, "\x78\x70"},
  {0xfa08, "\x7a\x21"}, {0xfa09, "\x7a\x22"}, {0xfa0a, "\x7a\x66"},
  {0xfa0b, "\x7c\x29"},
};
