/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore1.ConnectionPoints;
import com.sun.electric.tool.routing.experimentalLeeMoore1.FindVirtualEndInterface;
import com.sun.electric.tool.routing.experimentalLeeMoore1.FindVirtualEnd_ProjectedAndRandomized;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Route;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.RoutingArray;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Tupel;
import com.sun.electric.tool.routing.experimentalLeeMoore1.RoutingPart;
import com.sun.electric.tool.routing.experimentalLeeMoore1.Wiring;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkPartition;
import com.sun.electric.tool.routing.experimentalLeeMoore1.WorkPool;
import com.sun.electric.tool.routing.experimentalLeeMoore1.yana;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerThread
implements Runnable {
    public static final boolean X_DIRECTION = true;
    public static final boolean Y_DIRECTION = false;
    private static long DEADLINE;
    private static int MAXLAYER;
    protected static boolean[][][] regionBoundaries;
    private static RoutingArray ra;
    protected static int size_x;
    protected static int size_y;
    private static FindVirtualEndInterface findVirtualEndAlgorithm;
    private static int NUMPARTITIONS;
    private int id;
    private boolean DEBUG = false;
    List<WiringJob> wj = new ArrayList<WiringJob>();

    public static void init(WorkerThread[] workerObjects, int countLayers, RoutingArray ra, List<RoutingFrame.RoutingSegment> segmentsToRoute, int maxRunTime, boolean output2) {
        DEADLINE = System.currentTimeMillis() + (long)maxRunTime;
        MAXLAYER = countLayers;
        WorkerThread.ra = ra;
        NUMPARTITIONS = yana.numPartitions;
        size_x = ra.size_x;
        size_y = ra.size_y;
        WorkPool.init(segmentsToRoute, NUMPARTITIONS, size_x, size_y, output2);
        WorkPool.printPartitionBorders();
        regionBoundaries = new boolean[size_x][size_y][MAXLAYER];
        for (int i = 0; i < size_x; ++i) {
            for (int j = 0; j < size_y; ++j) {
                for (int k = 0; k < MAXLAYER; ++k) {
                    WorkerThread.regionBoundaries[i][j][k] = true;
                }
            }
        }
        ArrayList<Tupel> blocked = ra.getBlocked();
        for (Tupel t : blocked) {
            for (int i = 0; i < MAXLAYER; ++i) {
                WorkerThread.regionBoundaries[t.getX_InsideRoutingArray()][t.getY_InsideRoutingArray()][i] = false;
            }
        }
        findVirtualEndAlgorithm = new FindVirtualEnd_ProjectedAndRandomized(true, false, MAXLAYER, output2);
    }

    public WorkerThread(int id) {
        this.id = id;
    }

    @Override
    public void run() {
        if (this.DEBUG) {
            System.out.println("Thread-" + this.id + " running...");
        }
        this.changeRoutingSegmentToRoutingPart();
        if (this.DEBUG) {
            System.out.println("Thread-" + this.id + " allocating work to partitions...");
        }
        this.allocateRoutingPartsToWorkPartitions();
        try {
            yana.barrierRouting.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
        System.gc();
        WorkPartition wp = WorkPool.getWorkFromPartition();
        while (wp != null) {
            if (this.DEBUG) {
                System.out.println("Thread-" + this.id + ": routing partition " + wp.id + " containing " + wp.routingParts.size() + " routingparts");
            }
            RoutingPart rp = wp.routingParts.poll();
            while (rp != null) {
                if (System.currentTimeMillis() > DEADLINE) {
                    System.out.println("Timeout...");
                    return;
                }
                Tupel start = rp.start;
                Tupel end = rp.end;
                if (this.DEBUG) {
                    String sys_out = "THREAD " + this.id + ": ";
                    sys_out = sys_out + "Routing netID " + rp.rs.getNetID() + ": ";
                    sys_out = sys_out + "[" + rp.rs.getStartEnd().getLocation().getX() + "," + rp.rs.getStartEnd().getLocation().getY() + "@" + rp.rs.getStartLayers().get(0).getName() + "]";
                    sys_out = sys_out + "->[" + rp.rs.getFinishEnd().getLocation().getX() + "," + rp.rs.getFinishEnd().getLocation().getY() + "@" + rp.rs.getFinishLayers().get(0).getName() + "]";
                    sys_out = sys_out + "; part " + start + "->" + end;
                    System.out.println(sys_out);
                    System.out.println("Borders: " + WorkPool.getLowIndexIn_X(wp.id) + "," + WorkPool.getHighIndexIn_X(wp.id) + "; " + WorkPool.getLowIndexIn_Y(wp.id) + "," + WorkPool.getHighIndexIn_Y(wp.id));
                }
                if (!start.isEqual(end)) {
                    Route r = ra.route(start, end, wp.tb, rp.rs.getNetID());
                    if (r != null) {
                        this.wj.add(new WiringJob(rp, r.getEdgePoints(), r.isReversed()));
                    } else {
                        yana.markSegmentAsUnroutable(rp.rs);
                    }
                }
                yana.updateProgress();
                rp = wp.routingParts.poll();
            }
            wp = WorkPool.getWorkFromPartition();
        }
        if (this.DEBUG) {
            System.out.println("Thread-" + this.id + " finished routing");
        }
        try {
            yana.barrierWiring.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
        for (WiringJob wjob : this.wj) {
            if (!yana.isRouteable(wjob.rp.rs)) continue;
            if (wjob.isConnectionPoints) {
                Wiring.connect(wjob.rp.rs, wjob.rp1, wjob.rp2);
                continue;
            }
            Wiring.connect(wjob.rp, wjob.route, wjob.isReversed);
        }
        if (this.DEBUG) {
            System.out.println("Thread-" + this.id + " finished wiring");
        }
    }

    private void changeRoutingSegmentToRoutingPart() {
        RoutingFrame.RoutingSegment rs = WorkPool.getRoutingSegment();
        while (rs != null) {
            WorkPool.addPartToGlobalRoutingQueue(new RoutingPart(rs));
            rs = WorkPool.getRoutingSegment();
        }
    }

    private void allocateRoutingPartsToWorkPartitions() {
        block0: while (WorkPool.getSegmentCounter() != 0) {
            while (WorkPool.getGlobalRoutingQueueSize() != 0) {
                int indexStart;
                RoutingPart rp = WorkPool.getPartFromGlobalRoutingQueue();
                if (rp == null) {
                    Thread.yield();
                    continue block0;
                }
                Tupel start = rp.start;
                Tupel end = rp.end;
                int indexEnd = WorkPool.getResponsiblePartitionID_ForPoint(end.getX_InsideRoutingArray(), end.getY_InsideRoutingArray());
                if (indexEnd == (indexStart = WorkPool.getResponsiblePartitionID_ForPoint(start.getX_InsideRoutingArray(), start.getY_InsideRoutingArray()))) {
                    WorkPool.addWorkToPartition(rp, indexStart);
                    WorkPool.decreaseSegmentCounter();
                    continue;
                }
                ConnectionPoints connectionPoints = findVirtualEndAlgorithm.findVirtualEnd(rp, indexStart);
                while (connectionPoints.areValid() && !this.blockConnectingPoint(connectionPoints.getInnerPoint(), connectionPoints.getOuterPoint())) {
                    connectionPoints = findVirtualEndAlgorithm.findVirtualEnd(rp, indexStart);
                }
                if (!connectionPoints.areValid()) {
                    if (this.DEBUG) {
                        System.out.println("Part of a RoutingSegment could not be routed");
                    }
                    yana.markSegmentAsUnroutable(rp.rs);
                    WorkPool.decreaseSegmentCounter();
                    continue;
                }
                RoutingFrame.RoutePoint[] borderPoints = Wiring.getRoutePoints(connectionPoints.getInnerPoint(), connectionPoints.getOuterPoint());
                this.wj.add(new WiringJob(rp, borderPoints[0], borderPoints[1], false));
                ra.setBlocked(connectionPoints.getTupels());
                RoutingPart prefixRoutingPart = rp.getPrefixPart(connectionPoints.getInnerPoint(), borderPoints[0]);
                RoutingPart suffixRoutingPart = rp.getSuffixPart(connectionPoints.getOuterPoint(), borderPoints[1]);
                WorkPool.addPartToGlobalRoutingQueue(suffixRoutingPart);
                WorkPool.addWorkToPartition(prefixRoutingPart, indexStart);
                WorkPool.increaseAdditionalSegments();
            }
        }
    }

    private synchronized boolean blockConnectingPoint(Tupel pointA, Tupel pointB) {
        int PAX = pointA.getX_InsideRoutingArray();
        int PBX = pointB.getX_InsideRoutingArray();
        int PAY = pointA.getY_InsideRoutingArray();
        int PBY = pointB.getY_InsideRoutingArray();
        if (PAX == -1 || PAY == -1 || PBX == -1 || PBY == -1) {
            System.out.println(" CRITICAL ERROR: we've got company! (a crash is approaching)");
        }
        if (Math.abs(PAX - PBX) == 1) {
            int minX;
            if (PAY - PBY != 0 || pointA.getLayer() - pointB.getLayer() != 0) {
                return false;
            }
            int n = minX = PAX < PBX ? PAX : PBX;
            if (regionBoundaries[minX][PAY][pointA.getLayer()]) {
                WorkerThread.regionBoundaries[minX][PAY][pointA.getLayer()] = false;
                WorkerThread.regionBoundaries[minX + 1][PAY][pointA.getLayer()] = false;
                return true;
            }
            return false;
        }
        if (Math.abs(PAY - PBY) == 1) {
            int minY;
            if (PAX - PBX != 0 || pointA.getLayer() - pointB.getLayer() != 0) {
                return false;
            }
            int n = minY = PAY < PBY ? PAY : PBY;
            if (regionBoundaries[PAX][minY][pointA.getLayer()]) {
                WorkerThread.regionBoundaries[PAX][minY][pointA.getLayer()] = false;
                WorkerThread.regionBoundaries[PAX][minY + 1][pointA.getLayer()] = false;
                return true;
            }
            return false;
        }
        return false;
    }

    protected static Tupel getMiddlePoint(Tupel p) {
        int x = p.getX_InsideRoutingArray();
        int y = p.getY_InsideRoutingArray();
        int workerID = WorkPool.getResponsiblePartitionID_ForPoint(x, y);
        int lowX = WorkPool.getLowIndexIn_X(workerID);
        int hiX = WorkPool.getHighIndexIn_X(workerID);
        int lowY = WorkPool.getLowIndexIn_Y(workerID);
        int hiY = WorkPool.getHighIndexIn_Y(workerID);
        return new Tupel((hiX - lowX) / 2 + lowX, (hiY - lowY) / 2 + lowY, p.getLayer(), false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WiringJob {
        RoutingPart rp;
        List<Tupel> route;
        RoutingFrame.RoutePoint rp1;
        RoutingFrame.RoutePoint rp2;
        boolean isConnectionPoints;
        boolean isReversed;

        public WiringJob(RoutingPart rp, List<Tupel> route, boolean isReversed) {
            this.rp = rp;
            this.route = route;
            this.isConnectionPoints = false;
            this.isReversed = isReversed;
            this.rp1 = null;
            this.rp2 = null;
        }

        public WiringJob(RoutingPart rp, RoutingFrame.RoutePoint rp1, RoutingFrame.RoutePoint rp2, boolean isReversed) {
            this.rp = rp;
            this.route = null;
            this.rp1 = rp1;
            this.rp2 = rp2;
            this.isConnectionPoints = true;
            this.isReversed = isReversed;
        }
    }
}

