/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.PrintStream;

class ErrorHighArc
extends ErrorHighlight {
    private final int arcId;

    public ErrorHighArc(VarContext con, ArcInst ai) {
        super(ai.getParent(), con);
        this.arcId = ai.getArcId();
    }

    boolean containsObject(Cell c, Object obj) {
        EDatabase database = c.getDatabase();
        return this.getCell(database) == c && this.getObject(database) == obj;
    }

    Object getObject(EDatabase database) {
        Cell cell = this.getCell(database);
        if (cell == null) {
            return null;
        }
        return cell.getArcById(this.arcId);
    }

    void xmlDescription(PrintStream msg, EDatabase database) {
        ArcInst ai = (ArcInst)this.getObject(database);
        msg.append("\t\t<ERRORTYPEGEOM ");
        msg.append("geomName=\"" + ai.getD().name + "\" ");
        msg.append("cellName=\"" + ai.getParent().describe(false) + "\"");
        msg.append(" />\n");
    }

    boolean isValid(EDatabase database) {
        return this.getObject(database) != null;
    }

    public void addToHighlighter(Highlighter h, EDatabase database) {
        ArcInst ai = (ArcInst)this.getObject(database);
        if (ai != null) {
            h.addElectricObject(ai, ai.getParent());
        }
    }
}

