/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.dialogs.About;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.net.URL;

public class HelpMenu {
    static EMenu makeMenu() {
        return new EMenu("_Help", !Client.isOSMac() ? new EMenuItem("_About Electric..."){

            public void run() {
                HelpMenu.aboutCommand();
            }
        } : null, !Client.isOSMac() ? EMenuItem.SEPARATOR : null, new EMenuItem("_User's Manual..."){

            public void run() {
                ManualViewer.userManualCommand();
            }
        }, ManualViewer.hasRussianManual() ? new EMenuItem("User's Manual (_Russian)..."){

            public void run() {
                ManualViewer.userManualRussianCommand();
            }
        } : null, new EMenuItem("Show _Key Bindings"){

            public void run() {
                MenuCommands.menuBar().keyBindingManager.printKeyBindings();
            }
        }, new EMenu("_3D Showcase", new EMenuItem("_Load Library"){

            public void run() {
                ManualViewer.loadSamplesLibrary("floatingGates", "topCell");
            }
        }, new EMenuItem("_3D View of Cage Cell"){

            public void run() {
                ManualViewer.open3DSample("floatingGates", "topCell", "3D ShowCase");
            }
        }, new EMenuItem("_Animate Cage Cell"){

            public void run() {
                ManualViewer.animate3DSample("demoCage.j3d");
            }
        }), new EMenu("_Load Built-in Libraries", new EMenuItem("_Sample Cells"){

            public void run() {
                ManualViewer.loadSamplesLibrary("samples", "tech-MOSISCMOS");
            }
        }, new EMenuItem("_MOSIS CMOS Pads"){

            public void run() {
                HelpMenu.loadBuiltInLibraryCommand("pads4u");
            }
        }, new EMenuItem("MI_PS Cells"){

            public void run() {
                HelpMenu.loadBuiltInLibraryCommand("mipscells");
            }
        }), Job.getDebug() ? EMenuItem.SEPARATOR : null, Job.getDebug() ? new EMenuItem("Make fake circuitry MoCMOS"){

            public void run() {
                HelpMenu.makeFakeCircuitryCommand("mocmos", true);
            }
        } : null, Job.getDebug() ? new EMenuItem("Make fake circuitry TSMC90"){

            public void run() {
                HelpMenu.makeFakeCircuitryCommand("tsmc90", true);
            }
        } : null, Job.getDebug() ? new EMenuItem("Make fake analog simulation window"){

            public void run() {
                HelpMenu.makeFakeWaveformCommand();
            }
        } : null, Job.getDebug() ? new EMenuItem("Make fake interval simulation window"){

            public void run() {
                HelpMenu.makeFakeIntervalWaveformCommand();
            }
        } : null);
    }

    public static void aboutCommand() {
        About dialog = new About((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void loadBuiltInLibraryCommand(String libName) {
        if (Library.findLibrary(libName) != null) {
            return;
        }
        URL url = LibFile.getLibFile(libName + ".jelib");
        FileMenu.ReadLibrary job = new FileMenu.ReadLibrary(url, FileType.JELIB, null, null);
    }

    private static void makeFakeCircuitryCommand(String tech, boolean asJob) {
        try {
            Class<?> makeFakeCircuitry = Class.forName("com.sun.electric.plugins.tests.MakeFakeCircuitry");
            Method makeMethod = makeFakeCircuitry.getDeclaredMethod("makeFakeCircuitryCommand", String.class, String.class, Boolean.class);
            makeMethod.invoke(null, "noname", tech, new Boolean(asJob));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void makeFakeWaveformCommand() {
        int i;
        int numEvents = 100;
        Stimuli sd = new Stimuli();
        Analysis an = new Analysis(sd, Analysis.ANALYSIS_SIGNALS);
        double timeStep = 1.0E-10;
        an.buildCommonTime(numEvents);
        for (i = 0; i < numEvents; ++i) {
            an.setCommonTime(i, (double)i * timeStep);
        }
        for (i = 0; i < 18; ++i) {
            AnalogSignal as = new AnalogSignal(an);
            as.setSignalName("Signal" + (i + 1));
            as.buildValues(numEvents);
            for (int k = 0; k < numEvents; ++k) {
                as.setValue(k, Math.sin((double)(k + i * 10) / (2.0 + (double)(i * 2))) * 4.0);
            }
        }
        sd.setCell(null);
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        WaveformWindow ww = (WaveformWindow)wf.getContent();
        for (int i2 = 0; i2 < 6; ++i2) {
            Panel wp = new Panel(ww, true, Analysis.ANALYSIS_SIGNALS);
            wp.setYAxisRange(-5.0, 5.0);
            for (int j = 0; j < (i2 + 1) * 3; ++j) {
                AnalogSignal as = (AnalogSignal)an.getSignals().get(j);
                WaveSignal wsig = new WaveSignal(wp, as);
            }
        }
    }

    private static void makeFakeIntervalWaveformCommand() {
        Stimuli sd = new Stimuli();
        Analysis an = new Analysis(sd, Analysis.ANALYSIS_SIGNALS);
        double timeStep = 1.0E-10;
        for (int i = 0; i < 6; ++i) {
            IntervalAnalogSignal as = new IntervalAnalogSignal(an, 1.0E-10, i);
        }
        sd.setCell(null);
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        WaveformWindow ww = (WaveformWindow)wf.getContent();
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            Panel wp = new Panel(ww, true, Analysis.ANALYSIS_SIGNALS);
            wp.setYAxisRange(-5.0, 5.0);
            for (int j = 0; j <= i; ++j) {
                AnalogSignal as = (AnalogSignal)an.getSignals().get(k++);
                WaveSignal wsig = new WaveSignal(wp, as);
            }
        }
    }

    private static class IntervalAnalogSignal
    extends AnalogSignal {
        private final int signalIndex;
        private final double timeStep;

        private IntervalAnalogSignal(Analysis an, double timeStep, int signalIndex) {
            super(an);
            this.signalIndex = signalIndex;
            this.timeStep = timeStep;
            this.setSignalName("Signal" + (signalIndex + 1));
        }

        public void getEvent(int sweep, int index, double[] result) {
            result[0] = (double)index * this.timeStep;
            double lowValue = Math.sin((double)(index + this.signalIndex * 10) / (2.0 + (double)(this.signalIndex * 2))) * 4.0;
            double increment = Math.sin((double)(index + this.signalIndex * 5) / (2.0 + (double)this.signalIndex));
            result[1] = Math.min(lowValue, lowValue + increment);
            result[2] = Math.max(lowValue, lowValue + increment);
        }

        public int getNumEvents(int sweep) {
            return 100;
        }
    }
}

