/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class EDIFTab
extends PreferencePanel {
    private JPanel edif;
    private JButton edifBrowse;
    private JCheckBox edifCadenceCompatibility;
    private JTextField edifConfigFile;
    private JTextField edifInputScale;
    private JCheckBox edifUseSchematicView;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;

    public EDIFTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.edif;
    }

    public String getName() {
        return "EDIF";
    }

    public void init() {
        this.edifUseSchematicView.setSelected(IOTool.isEDIFUseSchematicView());
        this.edifInputScale.setText(TextUtils.formatDouble(IOTool.getEDIFInputScale()));
        this.edifCadenceCompatibility.setSelected(IOTool.isEDIFCadenceCompatibility());
        this.edifConfigFile.setText(IOTool.getEDIFConfigurationFile());
    }

    public void term() {
        String currentConfigFile;
        boolean currentCadenceCompatibility;
        double currentInputScale;
        boolean currentUseSchematicView = this.edifUseSchematicView.isSelected();
        if (currentUseSchematicView != IOTool.isEDIFUseSchematicView()) {
            IOTool.setEDIFUseSchematicView(currentUseSchematicView);
        }
        if ((currentInputScale = TextUtils.atof(this.edifInputScale.getText())) != IOTool.getEDIFInputScale()) {
            IOTool.setEDIFInputScale(currentInputScale);
        }
        if ((currentCadenceCompatibility = this.edifCadenceCompatibility.isSelected()) != IOTool.isEDIFCadenceCompatibility()) {
            IOTool.setEDIFCadenceCompatibility(currentCadenceCompatibility);
        }
        if (!(currentConfigFile = this.edifConfigFile.getText()).equals(IOTool.getEDIFConfigurationFile())) {
            IOTool.setEDIFConfigurationFile(currentConfigFile);
        }
    }

    private void initComponents() {
        this.edif = new JPanel();
        this.edifUseSchematicView = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.edifInputScale = new JTextField();
        this.jLabel1 = new JLabel();
        this.edifConfigFile = new JTextField();
        this.edifBrowse = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.edifCadenceCompatibility = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EDIFTab.this.closeDialog(evt);
            }
        });
        this.edif.setLayout(new GridBagLayout());
        this.edifUseSchematicView.setText("Use Schematic View when writing");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.edifUseSchematicView, gridBagConstraints);
        this.jLabel13.setText("Scale by:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.jLabel13, gridBagConstraints);
        this.edifInputScale.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.edifInputScale, gridBagConstraints);
        this.jLabel1.setText("Configuration file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.jLabel1, gridBagConstraints);
        this.edifConfigFile.setMinimumSize(new Dimension(200, 20));
        this.edifConfigFile.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.edifConfigFile, gridBagConstraints);
        this.edifBrowse.setText("Browse...");
        this.edifBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EDIFTab.this.edifBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.edifBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.edif.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel2.setText("The configuration file provides overrides for controlling");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.edif.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("EDIF reading and writing.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.edif.add((Component)this.jLabel3, gridBagConstraints);
        this.edifCadenceCompatibility.setText("Cadence compatibility");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.edifCadenceCompatibility, gridBagConstraints);
        this.jLabel4.setText("when reading");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.edif.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.edif, gridBagConstraints);
        this.pack();
    }

    private void edifBrowseActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.edifConfigFile.setText(fileName);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

