/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight2;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityLogger {
    private static final boolean TEST_VERSION = Version.getVersion().getDetail() != 999;
    private static boolean logMenuActivations;
    private static boolean logJobs;
    private static boolean logTimeStamps;
    private static boolean exceptionLogged;
    private static PrintWriter out;
    private static String outputFile;
    private static int loggedCount;

    public static synchronized void initialize(boolean logMenuActivations, boolean logJobs, boolean useTimeStamps) {
        ActivityLogger.logMenuActivations = logMenuActivations;
        ActivityLogger.logJobs = logJobs;
        logTimeStamps = useTimeStamps;
        outputFile = Client.isOSMac() ? System.getProperty("user.home") + File.separator + outputFile : System.getProperty("user.dir") + File.separator + outputFile;
        try {
            FileOutputStream fos = new FileOutputStream(outputFile, false);
            BufferedOutputStream bout = new BufferedOutputStream(fos);
            out = new PrintWriter(bout);
        }
        catch (IOException e) {
            System.out.println("Warning: Activity Log disabled: " + e.getMessage());
        }
        if (out != null) {
            out.println("Electric " + Version.getVersionInformation());
        }
    }

    public static synchronized void finished() {
        if (out != null) {
            out.close();
        }
        if (exceptionLogged && TEST_VERSION) {
            Job.getUserInterface().showInformationMessage(new String[]{"Exception logged.  Please send ", "   \"" + outputFile + "\"", "to the developers"}, "Exception Logged");
        }
    }

    public static synchronized void logMenuActivated(String menuDescription) {
        List<Highlight2> savedContents;
        if (out == null) {
            return;
        }
        if (!logMenuActivations) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        out.println("Menu Activated: " + menuDescription);
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd != null && (savedContents = wnd.saveHighlightList()) != null) {
            ActivityLogger.logHighlights(savedContents, wnd.getHighlightOffset());
        }
    }

    public static synchronized void logToolBarButtonActivated(String buttonName) {
        if (out == null) {
            return;
        }
        if (!logMenuActivations) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        out.println("ToolBarButton Activated: " + buttonName);
    }

    public static synchronized void logJobStarted(String jobName, Job.Type jobType, Cell cell, List<Highlight2> savedHighlights, Point2D savedHighlightsOffset) {
        if (out == null) {
            return;
        }
        if (!logJobs) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        String cellName = cell == null ? "none" : cell.libDescribe();
        Exception e = new Exception("stack trace");
        out.println("Job Started [Current Cell: " + cellName + "] " + jobName + ", " + (Object)((Object)jobType));
        ActivityLogger.logHighlights(savedHighlights, savedHighlightsOffset);
    }

    public static synchronized void logHighlights(List<Highlight2> highlights, Point2D offset) {
        if (out == null) {
            return;
        }
        if (highlights.size() == 0) {
            return;
        }
        out.println("Currently highlighted: ");
        for (Highlight2 h : highlights) {
            out.println("    " + h.describe());
        }
    }

    public static synchronized void logTime(long time) {
        if (out == null) {
            return;
        }
        if (!logTimeStamps) {
            return;
        }
        Date date = new Date(time);
        out.println("Time: " + date);
    }

    public static synchronized void logException(Throwable e) {
        if (out != null) {
            ActivityLogger.printDelimeter(true);
            e.printStackTrace(out);
            out.flush();
        }
        e.printStackTrace(System.out);
        String msg1 = "Exception Caught!!!";
        String msg2 = "The exception below has been logged in '" + outputFile + "'.";
        String msg3 = "Please help us and report error to developers using 'Bugzilla'. In case of no access, send logfile to the developers.";
        String msg4 = e.toString();
        String[] msg = TEST_VERSION ? new String[]{msg1, msg2, msg3, msg4} : new String[]{msg1, msg2, msg4};
        Job.getUserInterface().showErrorMessage(msg, "Exception Caught");
        exceptionLogged = true;
    }

    public static synchronized void logMessage(String msg) {
        if (out == null) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        out.println(msg);
    }

    public static synchronized void logThreadMessage(String msg) {
        if (out == null) {
            return;
        }
        ActivityLogger.printDelimeter(false);
        out.println(msg);
    }

    private static synchronized void printDelimeter(boolean printThreadInfo) {
        if (out == null) {
            return;
        }
        out.println("--------------- " + loggedCount + " --------------");
        Exception e = new Exception("stack trace");
        if (logTimeStamps) {
            Date date = new Date(System.currentTimeMillis());
            out.println("  " + date);
        }
        ++loggedCount;
    }

    static {
        out = null;
        outputFile = "electric.log";
        loggedCount = 0;
    }
}

