/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.JobManager;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.JobTree;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientJobManager
extends JobManager {
    private static final String CLASS_NAME = Job.class.getName();
    private static final Logger logger = Logger.getLogger("com.sun.electric.tool.job");
    private final String serverMachineName;
    private final int port;
    private static DataOutputStream clientOutputStream;
    private static int numStarted;
    private volatile boolean jobTreeChanged;
    private static Job clientJob;
    private final FIFO clientFifo = new FIFO();
    private static volatile int clientNumExamine;
    private static Snapshot clientSnapshot;
    private final ClientInvoke clientInvoke = new ClientInvoke();

    public ClientJobManager(String serverMachineName, int serverPort) {
        this.serverMachineName = serverMachineName;
        this.port = serverPort;
    }

    void writeEJob(EJob ejob) throws IOException {
        clientOutputStream.writeInt(ejob.jobId);
        clientOutputStream.writeUTF(ejob.jobType.toString());
        clientOutputStream.writeUTF(ejob.jobName);
        clientOutputStream.writeInt(ejob.serializedJob.length);
        clientOutputStream.write(ejob.serializedJob);
        clientOutputStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runLoop() {
        logger.entering(CLASS_NAME, "clinetLoop", this.port);
        SnapshotReader reader = null;
        Snapshot oldSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
        Snapshot currentSnapshot = EDatabase.clientDatabase().backup();
        assert (currentSnapshot == oldSnapshot);
        try {
            System.out.println("Attempting to connect to port " + this.port + " ...");
            Socket socket = new Socket(this.serverMachineName, this.port);
            reader = new SnapshotReader(new DataInputStream(new BufferedInputStream(socket.getInputStream())), EDatabase.clientDatabase().getIdManager());
            clientOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            int protocolVersion = reader.readInt();
            if (protocolVersion != 13) {
                System.out.println("Client's protocol version 13 is incompatible with Server's protocol version " + protocolVersion);
                System.exit(1);
            }
            System.out.println("Connected");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        logger.logp(Level.FINER, CLASS_NAME, "clientLoop", "initTechnologies begin");
        Technology.initAllTechnologies();
        User.getUserTool().init();
        logger.logp(Level.FINER, CLASS_NAME, "clientLoop", "initTechnologies end");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                logger.entering(CLASS_NAME, "InitializeWindows");
                TopLevel.InitializeWindows();
                WindowFrame.wantToOpenCurrentLibrary(true, null);
                logger.exiting(CLASS_NAME, "InitializeWindows");
            }
        });
        boolean firstSnapshot = false;
        try {
            block9: while (true) {
                logger.logp(Level.FINEST, CLASS_NAME, "clientLoop", "readTag");
                byte tag = reader.readByte();
                switch (tag) {
                    case 1: {
                        logger.logp(Level.FINER, CLASS_NAME, "clientLoop", "readSnapshot begin {0}", this.clientFifo.numPut);
                        currentSnapshot = Snapshot.readSnapshot(reader, currentSnapshot);
                        logger.logp(Level.FINER, CLASS_NAME, "clientLoop", "readSnapshot end");
                        if (firstSnapshot) continue block9;
                        SwingUtilities.invokeLater(new SnapshotDatabaseChangeRun(clientSnapshot, currentSnapshot));
                        if (Job.currentUI != null) {
                            Job.getExtendedUserInterface().showSnapshot(currentSnapshot, true);
                        }
                        clientSnapshot = currentSnapshot;
                        firstSnapshot = true;
                        continue block9;
                    }
                    case 2: {
                        boolean hasSerializedJob;
                        logger.logp(Level.FINER, CLASS_NAME, "clientLoop", "readResult begin {0}", this.clientFifo.numPut);
                        Integer jobId = reader.readInt();
                        String jobName = reader.readString();
                        Job.Type jobType = Job.Type.valueOf(reader.readString());
                        EJob ejob = new EJob(null, jobId, jobType, jobName, null);
                        ejob.state = EJob.State.valueOf(reader.readString());
                        ejob.oldSnapshot = oldSnapshot;
                        ejob.newSnapshot = currentSnapshot;
                        oldSnapshot = currentSnapshot;
                        long timeStamp = reader.readLong();
                        Client.EJobEvent ejobEvent = new Client.EJobEvent(ejob, ejob.state, timeStamp);
                        if (ejob.state == EJob.State.WAITING && (hasSerializedJob = reader.readBoolean())) {
                            ejob.serializedJob = reader.readBytes();
                        }
                        if (ejob.state == EJob.State.SERVER_DONE) {
                            ejob.serializedResult = reader.readBytes();
                        }
                        this.clientFifo.put(ejobEvent);
                        logger.logp(Level.FINER, CLASS_NAME, "clientLoop", "readResult end {0}", jobId);
                        continue block9;
                    }
                    case 3: {
                        logger.logp(Level.FINEST, CLASS_NAME, "clientLoop", "readStr begin");
                        String str = reader.readString();
                        Client.PrintEvent printEvent = new Client.PrintEvent(null, str);
                        logger.logp(Level.FINEST, CLASS_NAME, "clientLoop", "readStr end {0}", str);
                        this.clientFifo.put(printEvent);
                        continue block9;
                    }
                }
                logger.logp(Level.SEVERE, CLASS_NAME, "clientLoop", "bad tag {0}", tag);
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError();
        }
        catch (IOException e) {
            reader = null;
            logger.logp(Level.INFO, CLASS_NAME, "clientLoop", "failed", e);
            System.out.println("END OF FILE reading from server");
            return;
        }
    }

    @Override
    void addJob(EJob ejob, boolean onMySnapshot) {
        assert (SwingUtilities.isEventDispatchThread());
        if (onMySnapshot) {
            this.waitingJobs.add(0, ejob);
        } else {
            this.waitingJobs.add(ejob);
        }
        if (ejob.getJob().getDisplay()) {
            this.jobTreeChanged = true;
        }
        SwingUtilities.invokeLater(this.clientInvoke);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopLevel.setBusyCursor(ClientJobManager.this.isChangeJobQueuedOrRunning());
            }
        });
    }

    @Override
    void wantUpdateGui() {
        this.jobTreeChanged = true;
        SwingUtilities.invokeLater(this.clientInvoke);
    }

    @Override
    void removeJob(Job j) {
        if (j.started) {
            Iterator it = this.startedJobs.iterator();
            while (it.hasNext()) {
                EJob ejob = (EJob)it.next();
                if (ejob.getJob() != j) continue;
                it.remove();
            }
        } else {
            Iterator it = this.waitingJobs.iterator();
            while (it.hasNext()) {
                EJob ejob = (EJob)it.next();
                if (ejob.getJob() != j) continue;
                it.remove();
            }
        }
        if (j.getDisplay()) {
            this.jobTreeChanged = true;
            SwingUtilities.invokeLater(this.clientInvoke);
        }
    }

    @Override
    EJob selectEJob(EJob finishedEJob) {
        return null;
    }

    @Override
    void setProgress(EJob ejob, String progress) {
        ejob.progress = progress;
    }

    private boolean isChangeJobQueuedOrRunning() {
        for (EJob ejob : this.startedJobs) {
            Job job = ejob.getJob();
            if (job != null && job.finished || ejob.jobType != Job.Type.CHANGE) continue;
            return true;
        }
        for (EJob ejob : this.waitingJobs) {
            if (ejob.jobType != Job.Type.CHANGE) continue;
            return true;
        }
        return false;
    }

    @Override
    Iterator<Job> getAllJobs() {
        Job job;
        ArrayList<Job> jobsList = new ArrayList<Job>();
        for (EJob ejob : this.startedJobs) {
            job = ejob.getJob();
            if (job == null) continue;
            jobsList.add(job);
        }
        for (EJob ejob : this.waitingJobs) {
            job = ejob.getJob();
            if (job == null) continue;
            jobsList.add(job);
        }
        return jobsList.iterator();
    }

    static {
        clientNumExamine = 0;
        clientSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
    }

    private static class SnapshotDatabaseChangeRun
    implements Runnable {
        private Snapshot oldSnapshot;
        private Snapshot newSnapshot;

        private SnapshotDatabaseChangeRun(Snapshot oldSnapshot, Snapshot newSnapshot) {
            this.oldSnapshot = oldSnapshot;
            this.newSnapshot = newSnapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EDatabase database = EDatabase.clientDatabase();
            database.lock(true);
            try {
                database.checkFresh(this.oldSnapshot);
                database.lowLevelSetCanUndoing(true);
                database.getNetworkManager().startBatch();
                database.undo(this.newSnapshot);
                database.getNetworkManager().endBatch();
                database.lowLevelSetCanUndoing(false);
            }
            finally {
                database.unlock();
            }
        }
    }

    private class ClientInvoke
    implements Runnable {
        private final String CLASS_NAME = this.getClass().getName();

        private ClientInvoke() {
        }

        public void run() {
            logger.entering(this.CLASS_NAME, "run");
            assert (SwingUtilities.isEventDispatchThread());
            while (true) {
                logger.logp(Level.FINEST, this.CLASS_NAME, "run", "before get");
                if (ClientJobManager.this.jobTreeChanged) {
                    ClientJobManager.this.jobTreeChanged = false;
                    ArrayList<Job> jobs = new ArrayList<Job>();
                    Iterator<Job> it = Job.getAllJobs();
                    while (it.hasNext()) {
                        Job j = it.next();
                        if (!j.getDisplay()) continue;
                        jobs.add(j);
                    }
                    JobTree.update(jobs);
                }
                int numGet = ClientJobManager.this.clientFifo.numGet;
                Client.ServerEvent o = ClientJobManager.this.clientFifo.get();
                if (o == null) break;
                if (o instanceof Client.EJobEvent) {
                    Client.EJobEvent ejobEvent = (Client.EJobEvent)o;
                    EJob ejob_ = ejobEvent.ejob;
                    int jobId = ejob_.jobId;
                    logger.logp(Level.FINER, this.CLASS_NAME, "run", "result begin {0}", numGet);
                    if (ejob_.newSnapshot != clientSnapshot) {
                        new SnapshotDatabaseChangeRun(clientSnapshot, ejob_.newSnapshot).run();
                        clientSnapshot = ejob_.newSnapshot;
                    }
                    if (Job.currentUI != null) {
                        Job.getExtendedUserInterface().showSnapshot(ejobEvent.ejob.newSnapshot, ejobEvent.ejob.jobType == Job.Type.UNDO);
                        continue;
                    }
                    if (ejob_.state != EJob.State.SERVER_DONE) continue;
                    EJob ejob = null;
                    for (EJob ej : ClientJobManager.this.startedJobs) {
                        if (ej.jobId != jobId) continue;
                        ejob = ej;
                        break;
                    }
                    if (ejob == null) {
                        System.out.println("Can't find EJob " + jobId);
                        continue;
                    }
                    ejob.serializedResult = ejob.serializedResult;
                    Job job = ejob.getJob();
                    if (job != null) {
                        Job.runTerminate(ejob);
                        if (job.deleteWhenDone) {
                            ClientJobManager.this.startedJobs.remove(job);
                            TopLevel.setBusyCursor(ClientJobManager.this.isChangeJobQueuedOrRunning());
                        }
                        logger.logp(Level.FINER, this.CLASS_NAME, "run", "result end {0}", ejob.jobName);
                        continue;
                    }
                    logger.logp(Level.WARNING, this.CLASS_NAME, "run", "result of unknown job {0}", o);
                    System.out.println("Job " + jobId + " was not found in startedJobs");
                    continue;
                }
                if (!(o instanceof Client.PrintEvent)) continue;
                logger.logp(Level.FINEST, this.CLASS_NAME, "run", "string begin");
                if (Job.currentUI != null) {
                    Job.currentUI.addEvent(o);
                }
                logger.logp(Level.FINEST, this.CLASS_NAME, "run", "string end {0}", o);
            }
            if (ClientJobManager.this.waitingJobs.isEmpty()) {
                logger.exiting(this.CLASS_NAME, "run");
                return;
            }
            EJob ejob = (EJob)ClientJobManager.this.waitingJobs.remove(0);
            Job job = ejob.clientJob;
            if (ejob.jobType == Job.Type.EXAMINE) {
                logger.logp(Level.FINER, this.CLASS_NAME, "run", "Schedule EXAMINE {0}", job);
                try {
                    job.doIt();
                }
                catch (JobException e) {
                    e.printStackTrace();
                }
            } else {
                logger.logp(Level.FINER, this.CLASS_NAME, "run", "Schedule {0}", job);
                ejob.jobId = ++numStarted;
                Throwable e = ejob.serialize(EDatabase.clientDatabase());
                if (e != null) {
                    System.out.println("Job " + this + " was not launched in CLIENT mode");
                    e.printStackTrace(System.out);
                } else {
                    try {
                        ClientJobManager.this.writeEJob(ejob);
                        ejob.getJob().started = true;
                        ClientJobManager.this.startedJobs.add(ejob);
                        clientJob = job;
                    }
                    catch (IOException ee) {
                        System.out.println("Job " + this + " was not launched in CLIENT mode");
                        ee.printStackTrace(System.out);
                    }
                }
            }
            logger.exiting(this.CLASS_NAME, "run");
        }
    }

    private class FIFO {
        private final String CLASS_NAME = ClientJobManager.access$000() + ".FIFO";
        private final ArrayList<Client.ServerEvent> queueF = new ArrayList();
        private final ArrayList<Client.ServerEvent> queueT = new ArrayList();
        private boolean getC = false;
        private int getIndex = 0;
        private int numGet;
        private int numPut;

        private FIFO() {
        }

        private synchronized void put(Client.ServerEvent o) {
            ArrayList<Client.ServerEvent> thatQ;
            logger.logp(Level.FINEST, this.CLASS_NAME, "put", "ENTRY");
            if (this.getC) {
                ArrayList<Client.ServerEvent> thisQ = this.queueT;
                thatQ = this.queueF;
            } else {
                ArrayList<Client.ServerEvent> thisQ = this.queueF;
                thatQ = this.queueT;
            }
            boolean empty = this.numGet == this.numPut;
            thatQ.add(o);
            ++this.numPut;
            if (empty) {
                logger.logp(Level.FINEST, this.CLASS_NAME, "put", "invokeLater(clientInvoke)");
                SwingUtilities.invokeLater(ClientJobManager.this.clientInvoke);
            }
            logger.logp(Level.FINEST, this.CLASS_NAME, "put", "RETURN");
        }

        private synchronized Client.ServerEvent get() {
            ArrayList<Client.ServerEvent> thatQ;
            ArrayList<Client.ServerEvent> thisQ;
            logger.logp(Level.FINEST, this.CLASS_NAME, "get", "ENTRY");
            if (this.numGet == this.numPut) {
                return null;
            }
            if (this.getC) {
                thisQ = this.queueT;
                thatQ = this.queueF;
            } else {
                thisQ = this.queueF;
                thatQ = this.queueT;
            }
            Client.ServerEvent o = null;
            if (this.getIndex < thisQ.size()) {
                o = thisQ.set(this.getIndex++, null);
            } else {
                o = thatQ.set(0, null);
                this.getIndex = 1;
                this.getC = !this.getC;
                thisQ.clear();
            }
            ++this.numGet;
            logger.logp(Level.FINEST, this.CLASS_NAME, "get", "RETURN");
            return o;
        }
    }
}

