/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.Highlight;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class InteractiveRouter
extends Router {
    private List startRouteHighlights = new ArrayList();
    private boolean started;
    private ElectricObject badStartObject;
    private ElectricObject badEndObject;

    public InteractiveRouter() {
        this.verbose = true;
        this.started = false;
        this.badEndObject = null;
        this.badStartObject = null;
    }

    public abstract String toString();

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElement var3, Point2D var4);

    public void startInteractiveRoute() {
        this.startRouteHighlights.clear();
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            this.startRouteHighlights.add(h);
        }
        Highlight.clear();
        this.started = true;
    }

    public void cancelInteractiveRoute() {
        Highlight.clear();
        Highlight.setHighlightList(this.startRouteHighlights);
        Highlight.finished();
        this.started = false;
    }

    public void makeRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute();
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked);
        Highlight.clear();
        Highlight.setHighlightList(this.startRouteHighlights);
        this.createRoute(route, cell);
        this.started = false;
    }

    public boolean makeVerticalRoute(PortInst startPort, ArcProto arc) {
        if (startPort.getPortProto().connectsTo(arc)) {
            return true;
        }
        if (!this.started) {
            this.startInteractiveRoute();
        }
        RouteElement startRE = RouteElement.existingPortInst(startPort, null);
        Route route = new Route();
        route.add(startRE);
        route.setStart(startRE);
        route.setEnd(startRE);
        VerticalRoute vroute = new VerticalRoute(startRE, arc);
        if (!vroute.specifyRoute()) {
            this.cancelInteractiveRoute();
            return false;
        }
        vroute.buildRoute(route, startRE.getCell(), startRE.getLocation());
        Highlight.clear();
        Highlight.setHighlightList(this.startRouteHighlights);
        this.createRoute(route, startPort.getNodeInst().getParent());
        this.started = false;
        return true;
    }

    public void highlightRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute();
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked);
        this.highlightRoute(route);
    }

    public void highlightRoute(Route route) {
        if (!this.started) {
            this.startInteractiveRoute();
        }
        Highlight.clear();
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElement e = (RouteElement)it.next();
            e.addHighlightArea();
        }
        Highlight.finished();
    }

    protected Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        Route route = new Route();
        if (cell == null) {
            return route;
        }
        RouteElement startRE = null;
        RouteElement endRE = null;
        if (startObj instanceof ArcInst && endObj instanceof ArcInst && this.connectIntersectingArcs(route, (ArcInst)startObj, (ArcInst)endObj)) {
            return route;
        }
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(0.0, 0.0);
        InteractiveRouter.getConnectingPoints(startObj, endObj, clicked, startPoint, endPoint);
        PortInst existingStartPort = null;
        PortInst existingEndPort = null;
        boolean reverseRoute = false;
        if (startObj instanceof PortInst) {
            existingStartPort = (PortInst)startObj;
            startRE = RouteElement.existingPortInst(existingStartPort, startPoint);
        }
        if (startObj instanceof ArcInst) {
            startRE = this.findArcConnectingPoint(route, (ArcInst)startObj, startPoint);
            reverseRoute = true;
        }
        if (startObj instanceof NodeInst && (existingStartPort = ((NodeInst)startObj).findClosestPortInst(clicked)) != null) {
            startRE = RouteElement.existingPortInst(existingStartPort, startPoint);
        }
        if (startRE == null) {
            if (startObj != this.badStartObject) {
                System.out.println("  Can't route from " + startObj + ", no ports");
            }
            this.badStartObject = startObj;
            return route;
        }
        if (endObj != null) {
            if (endObj instanceof PortInst) {
                existingEndPort = (PortInst)endObj;
                endRE = RouteElement.existingPortInst(existingEndPort, endPoint);
            }
            if (endObj instanceof ArcInst) {
                endRE = this.findArcConnectingPoint(route, (ArcInst)endObj, endPoint);
                reverseRoute = false;
            }
            if (endObj instanceof NodeInst && (existingEndPort = ((NodeInst)endObj).findClosestPortInst(clicked)) != null) {
                endRE = RouteElement.existingPortInst(existingEndPort, endPoint);
            }
            if (endRE == null) {
                if (endObj != this.badEndObject) {
                    System.out.println("  Can't route to " + endObj + ", no ports");
                }
                this.badEndObject = endObj;
                endObj = null;
            }
        }
        if (endObj == null) {
            PortInst startPort;
            ArcProto useArc = null;
            if (startObj instanceof PortInst) {
                startPort = (PortInst)startObj;
                useArc = InteractiveRouter.getArcToUse(startPort.getPortProto(), null);
            }
            if (startObj instanceof ArcInst) {
                ArcInst startArc = (ArcInst)startObj;
                useArc = startArc.getProto();
            }
            if (startObj instanceof NodeInst) {
                startPort = ((NodeInst)startObj).findClosestPortInst(clicked);
                useArc = InteractiveRouter.getArcToUse(startPort.getPortProto(), null);
            }
            if (!(useArc instanceof PrimitiveArc)) {
                System.out.println("  Don't know how to determine pin for arc " + useArc);
                return new Route();
            }
            PrimitiveNode pn = ((PrimitiveArc)useArc).findOverridablePinProto();
            SizeOffset so = pn.getProtoSizeOffset();
            endRE = RouteElement.newNode(cell, pn, pn.getPort(0), endPoint, pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset());
        }
        if (reverseRoute) {
            RouteElement re = startRE;
            startRE = endRE;
            endRE = re;
        }
        if (existingEndPort != null && existingEndPort == existingStartPort) {
            return new Route();
        }
        route.add(startRE);
        route.setStart(startRE);
        route.setEnd(startRE);
        if (this.planRoute(route, cell, endRE, clicked)) {
            return route;
        }
        return new Route();
    }

    protected static void getConnectingPoints(ElectricObject startObj, ElectricObject endObj, Point2D clicked, Point2D startPoint, Point2D endPoint) {
        double upperBoundY;
        double lowerBoundY;
        Poly startPoly = InteractiveRouter.getConnectingSite(startObj, clicked);
        Poly endPoly = InteractiveRouter.getConnectingSite(endObj, clicked);
        Rectangle2D startBounds = startPoly.getBounds2D();
        startPoint.setLocation(startBounds.getCenterX(), startBounds.getCenterY());
        if (endPoly == null) {
            if (startObj instanceof ArcInst) {
                double x = InteractiveRouter.getClosestValue(startBounds.getMinX(), startBounds.getMaxX(), clicked.getX());
                double y = InteractiveRouter.getClosestValue(startBounds.getMinY(), startBounds.getMaxY(), clicked.getY());
                startPoint.setLocation(x, y);
            }
            endPoint.setLocation(InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked));
            return;
        }
        Rectangle2D endBounds = endPoly.getBounds2D();
        endPoint.setLocation(endBounds.getCenterX(), endBounds.getCenterY());
        double lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX());
        double upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX());
        if (lowerBoundX <= upperBoundX) {
            double x = InteractiveRouter.getClosestValue(lowerBoundX, upperBoundX, clicked.getX());
            startPoint.setLocation(x, startPoint.getY());
            endPoint.setLocation(x, endPoint.getY());
        }
        if ((lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY())) <= (upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY()))) {
            double y = InteractiveRouter.getClosestValue(lowerBoundY, upperBoundY, clicked.getY());
            startPoint.setLocation(startPoint.getX(), y);
            endPoint.setLocation(endPoint.getX(), y);
        }
    }

    protected static Poly getConnectingSite(ElectricObject obj, Point2D clicked) {
        PortInst pi;
        if (obj instanceof NodeInst) {
            pi = ((NodeInst)obj).findClosestPortInst(clicked);
            if (pi == null) {
                return null;
            }
            obj = pi;
        }
        if (obj instanceof PortInst) {
            pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            PortProto pp = pi.getPortProto();
            boolean compressPort = false;
            if (ni.getProto() instanceof PrimitiveNode) {
                compressPort = true;
            }
            Poly poly = ni.getShapeOfPort(pp, clicked, compressPort);
            return poly;
        }
        if (obj instanceof ArcInst) {
            ArcInst arc = (ArcInst)obj;
            Point2D[] points = new Point2D[]{arc.getHead().getLocation(), arc.getTail().getLocation()};
            Poly poly = new Poly(points);
            return poly;
        }
        return null;
    }

    protected static double getClosestValue(double min, double max, double clicked) {
        if (clicked >= max) {
            return max;
        }
        if (clicked <= min) {
            return min;
        }
        return clicked;
    }

    protected static Point2D getClosestOrthogonalPoint(Point2D startPoint, Point2D clicked) {
        Point2D.Double newPoint = Math.abs(startPoint.getX() - clicked.getX()) < Math.abs(startPoint.getY() - clicked.getY()) ? new Point2D.Double(startPoint.getX(), clicked.getY()) : new Point2D.Double(clicked.getX(), startPoint.getY());
        return newPoint;
    }

    protected RouteElement findArcConnectingPoint(Route route, ArcInst arc, Point2D clicked) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head = arc.getHead().getLocation();
        Point2D tail = arc.getTail().getLocation();
        RouteElement headRE = RouteElement.existingPortInst(arc.getHead().getPortInst(), null);
        RouteElement tailRE = RouteElement.existingPortInst(arc.getTail().getPortInst(), null);
        RouteElement startRE = null;
        Point2D minXpin = null;
        Point2D minYpin = null;
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
            minXpin = head;
        } else {
            minX = tail.getX();
            maxX = head.getX();
            minXpin = tail;
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
            minYpin = head;
        } else {
            minY = tail.getY();
            maxY = head.getY();
            minYpin = tail;
        }
        if (head.getX() == tail.getX()) {
            if (clicked.getY() > minY && clicked.getY() < maxY) {
                Point2D.Double location = new Point2D.Double(head.getX(), clicked.getY());
                startRE = this.bisectArc(route, arc, location);
            } else {
                startRE = clicked.getY() <= minY ? (minYpin == head ? headRE : tailRE) : (minYpin == head ? tailRE : headRE);
            }
        } else if (head.getY() == tail.getY()) {
            if (clicked.getX() > minX && clicked.getX() < maxX) {
                Point2D.Double location = new Point2D.Double(clicked.getX(), head.getY());
                startRE = this.bisectArc(route, arc, location);
            } else {
                startRE = clicked.getX() <= minX ? (minXpin == head ? headRE : tailRE) : (minXpin == head ? tailRE : headRE);
            }
        } else {
            double tailDist;
            double headDist = clicked.distance(head);
            startRE = headDist < (tailDist = clicked.distance(tail)) ? headRE : tailRE;
        }
        return startRE;
    }

    protected boolean connectIntersectingArcs(Route route, ArcInst startArc, ArcInst endArc) {
        double y;
        Point2D startHead = startArc.getHead().getLocation();
        Point2D startTail = startArc.getTail().getLocation();
        double startSlope = (startTail.getY() - startHead.getY()) / (startTail.getX() - startHead.getX());
        double startYint = startTail.getY() - startSlope * startTail.getX();
        Point2D endHead = endArc.getHead().getLocation();
        Point2D endTail = endArc.getTail().getLocation();
        double endSlope = (endTail.getY() - endHead.getY()) / (endTail.getX() - endHead.getX());
        double endYint = endTail.getY() - endSlope * endTail.getX();
        if (startSlope == endSlope) {
            return false;
        }
        Point2D.Double point = null;
        if (Double.isInfinite(startSlope)) {
            if (this.withinBounds(startHead.getX(), endHead.getX(), endTail.getX())) {
                y = endSlope * startHead.getX() + endYint;
                point = new Point2D.Double(startHead.getX(), y);
            }
        } else if (Double.isInfinite(endSlope)) {
            if (this.withinBounds(endHead.getX(), startHead.getX(), startTail.getX())) {
                y = startSlope * endHead.getX() + startYint;
                point = new Point2D.Double(endHead.getX(), y);
            }
        } else {
            double x = (endYint - startYint) / (startSlope - endSlope);
            double y2 = startSlope * x + startYint;
            Point2D.Double tryPoint = new Point2D.Double(x, y2);
            if (this.onSegment(tryPoint, new Line2D.Double(startHead, startTail)) && this.onSegment(tryPoint, new Line2D.Double(endHead, endTail))) {
                point = tryPoint;
            }
        }
        if (point == null) {
            return false;
        }
        RouteElement startRE = this.bisectArc(route, startArc, point);
        RouteElement endRE = this.bisectArc(route, endArc, point);
        route.setStart(startRE);
        route.setEnd(startRE);
        ArcProto useArc = InteractiveRouter.getArcToUse(startRE.getPortProto(), endRE.getPortProto());
        if (useArc != null) {
            InteractiveRouter.replaceRouteElementArcPin(route, endRE, startRE);
        } else {
            VerticalRoute vroute = new VerticalRoute(route.getEnd(), endRE);
            if (!vroute.specifyRoute()) {
                System.out.println("Can't route vertically between " + startArc + " and " + endArc);
                return false;
            }
            vroute.buildRoute(route, endRE.getCell(), point);
        }
        return true;
    }

    protected RouteElement bisectArc(Route route, ArcInst arc, Point2D bisectPoint) {
        Cell cell = arc.getParent();
        PrimitiveNode pn = ((PrimitiveArc)arc.getProto()).findOverridablePinProto();
        SizeOffset so = pn.getProtoSizeOffset();
        double width = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
        double height = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
        RouteElement newPinRE = RouteElement.newNode(cell, pn, pn.getPort(0), bisectPoint, width, height);
        newPinRE.setBisectArcPin(true);
        RouteElement headRE = RouteElement.existingPortInst(arc.getHead().getPortInst(), null);
        RouteElement tailRE = RouteElement.existingPortInst(arc.getTail().getPortInst(), null);
        headRE.setShowHighlight(false);
        tailRE.setShowHighlight(false);
        String name = arc.getName();
        RouteElement newHeadArcRE = RouteElement.newArc(cell, arc.getProto(), arc.getWidth(), headRE, newPinRE, name);
        RouteElement newTailArcRE = RouteElement.newArc(cell, arc.getProto(), arc.getWidth(), newPinRE, tailRE, null);
        newHeadArcRE.setShowHighlight(false);
        newTailArcRE.setShowHighlight(false);
        RouteElement deleteArcRE = RouteElement.deleteArc(arc);
        route.add(deleteArcRE);
        route.add(headRE);
        route.add(tailRE);
        route.add(newHeadArcRE);
        route.add(newTailArcRE);
        return newPinRE;
    }

    protected boolean withinBounds(double point, double bound1, double bound2) {
        double max;
        double min;
        if (bound1 < bound2) {
            min = bound1;
            max = bound2;
        } else {
            min = bound2;
            max = bound1;
        }
        return point >= min && point <= max;
    }

    protected boolean onSegment(Point2D point, Line2D line) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head = line.getP1();
        Point2D tail = line.getP2();
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
        } else {
            minX = tail.getX();
            maxX = head.getX();
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
        } else {
            minY = tail.getY();
            maxY = head.getY();
        }
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }
}

