---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab cluster graph`

Queries the Kubernetes object graph, using the GitLab Agent for Kubernetes. (EXPERIMENTAL)

## Synopsis

This command starts a web server that shows a live view of the Kubernetes object graph in a browser.
It uses the GitLab Agent for Kubernetes running in the cluster.
It requires:

- Version 18.1 or later of GitLab and the GitLab Agent.
- At least the Developer role in the agent project.
- This command requires a personal access token or project access token
  for authentication. The token must have the `read_api` and `k8s_proxy` scopes.

Leave feedback in [issue 7900](https://gitlab.com/gitlab-org/cli/-/issues/7900).

### Resource filtering

To filter resources, namespaces, and select root objects, use
[Common Expression Language (CEL)](https://cel.dev/).

`object_selector_expression`: Filters objects. The expression must return a boolean. These variables are available:

- `obj`: The Kubernetes object being evaluated.
- `group`: The group of the object.
- `version`: The version of the object.
- `resource`: The resource name of the object, like `pods` for the `Pod` kind.
- `namespace`: The namespace of the object.
- `name`: The name of the object.
- `labels`: The labels of the object.
- `annotations`: The annotations of the object.

`resource_selector_expression`: Filters Kubernetes discovery information to include or exclude resources
from the watch request. The expression must return a boolean. These variables are available:

- `group`: The group of the object.
- `version`: The version of the object.
- `resource`: The resource name of the object, like `pods` for the `Pod` kind.
- `namespaced`: The scope of group, version, and resource. Can be `bool`, `true`, or `false`.

To select root objects, use the `--root-expression` flag. When set, only objects that are directly
or transitively reachable from root objects are shown. This flag uses the same variables
as `object_selector_expression`, and must return a boolean. Multiple values are joined with `OR`
statements. If any match, the object is used as root.

For more information about using [label selectors](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors)
and [field selectors](https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors/) to select namespaces, see the Kubernetes documentation.

### Advanced usage

Apart from high-level ways to construct the query, this command enables
you to construct and send the query using all underlying API features.
To understand what is possible, and how to do it, see the
[technical design doc](https://gitlab.com/gitlab-org/cluster-integration/gitlab-agent/-/blob/master/doc/graph_api.md)

The user should have permission to access the agent project.
For more information, see [Grant users Kubernetes access](https://docs.gitlab.com/user/clusters/agent/user_access/).

This feature is experimental. It might be broken or removed without any prior notice.
Read more about what experimental features mean at
<https://docs.gitlab.com/policy/development_stages_support/>

Use experimental features at your own risk.

```plaintext
glab cluster graph [flags]
```

## Examples

```console
# Run the default query for agent 123
$ glab cluster graph -R user/project -a 123

# Show common resources from the core and RBAC groups
$ glab cluster graph -R user/project -a 123 --core --rbac

# Show certain resources
$ glab cluster graph -R user/project -a 123 --resource=pods --resource=configmaps

# Same as above, but more compact
$ glab cluster graph -R user/project -a 123 -r={pods,configmaps}

# Select a certain namespace
$ glab cluster graph -R user/project -a 123 -n={my-ns,my-stuff}

# Select all namespaces that have a certain annotation
$ glab cluster graph -R user/project -a 123 --ns-expression='"my-annotation" in annotations'

# Advanced usage - pass the full query directly via stdin.
# The query below watches service accounts in all namespaces except for the kube-system.
$ Q='{"queries":[{"include":{"resource_selector_expression":"resource == \"serviceaccounts\""}}],"namespaces":{"object_selector_expression":"name != \"kube-system\""}}'

$ echo -n "$Q" | glab cluster graph -R user/project -a 123 --stdin

# Roots filtering
$ glab cluster graph -R user/project -a 123 --root-expression 'group == "" && resource == "pods"'
```

## Options

```plaintext
  -a, --agent int                     The numerical Agent ID to connect to.
      --apps                          Watch deployments, replicasets, daemonsets, and statefulsets in apps/v1 group.
      --batch                         Watch jobs and cronjobs in the batch/v1 group.
      --cluster-rbac                  Watch clusterroles and clusterrolebindings in the rbac.authorization.k8s.io/v1 group.
      --core                          Watch pods, secrets, configmaps, and serviceaccounts in the core/v1 group
      --crd                           Watch customresourcedefinitions in the apiextensions.k8s.io/v1 group.
      --ignore-arc-direction          Ignore arc direction when evaluating roots connectivity. GitLab and agent 18.3+ required.
      --listen-addr string            Address to listen on. (default "localhost:0")
      --listen-net string             Network on which to listen for connections. (default "tcp")
      --log-watch-request             Log watch request to stdout. Helpful for debugging.
  -n, --namespace stringArray         Namespaces to watch. If not specified, all namespaces are watched with label and field selectors filtering.
      --ns-expression string          CEL expression to select namespaces. Evaluated before a namespace is watched and on any updates for the namespace object.
      --ns-field-selector string      Field selector to select namespaces.
      --ns-label-selector string      Label selector to select namespaces.
      --rbac                          Watch roles, and rolebindings in the rbac.authorization.k8s.io/v1 group.
  -r, --resource stringArray          A list of resources to watch. You can see the list of resources your cluster supports by running 'kubectl api-resources'.
      --root-expression stringArray   CEL expression to select root objects. GitLab and agent 18.3+ required.
      --stdin                         Read watch request from standard input.
```

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
