/* wptProxySettingsDlg.cpp - Dialog for the proxy settings
 *	Copyright (C) 2002, 2003, 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptKeyserver.h"
#include "wptW32API.h"
#include "wptErrors.h"
#include "wptNLS.h"
#include "wptKeyserver.h"


static int
check_number (HWND dlg, int id)
{
    char buf[32];
    size_t i;

    GetDlgItemText (dlg, id, buf, 31);
    for (i=0; i < strlen (buf); i++) {
	if (!isdigit (buf[i]))
	    return -1;
    }
    return 0;
}


static int
read_proxy (HWND dlg, keyserver_proxy_ctx * ctx)
{
    char t[512];
    int ncount = 0, pos = 0;
    
    ncount = GetDlgItemText( dlg, IDC_PROXY_PWD, t, sizeof t -1 );
    if( ncount )
        ctx->pass = strdup( t );
    ncount = GetDlgItemText( dlg, IDC_PROXY_USER, t, sizeof t -1 );
    if( ncount )
        ctx->user = strdup( t );
    ncount = GetDlgItemText( dlg, IDC_PROXY_HOST, t, sizeof t -1 );
    if( ncount ) {
	if (!strncmp (t, "http://", 7))
	    pos = 7;
        ctx->host = strdup (t + pos);
    }    
    if (check_number (dlg, IDC_PROXY_PORT)) {
	msg_box (dlg, _("Invalid port number."), _("Proxy Settings"), MB_ERR);
	return -1;
    }

    ctx->port = GetDlgItemInt( dlg, IDC_PROXY_PORT, NULL, FALSE );
    if( ctx->port < 0 || ctx->port > 65535 ) {
	msg_box( dlg, _("Please select a value from 0-65535 for the port"), _("Proxy Settings"), MB_INFO );
	return -1;
    }
    if( ctx->user && !ctx->pass || !ctx->user && ctx->pass ) {
	msg_box( dlg, _("When you want to use authentication, "
		                "please fill out both fields."), _("Proxy Settings"), MB_ERR );
	return -1;
    }
    if( ctx->host && !ctx->port || !ctx->host && ctx->port ) {
	msg_box( dlg, _("Please enter a host name and a port."), _("Proxy Settings"), MB_INFO );
	return -1;
    }
    return 0;
} /* read_proxy */


BOOL CALLBACK
keyserver_proxy_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    const char *proxy = NULL, * user, * pass;
    int port = 0;
    int rc = 0;
    
    switch ( msg ) {
    case WM_INITDIALOG:
        proxy = kserver_get_proxy( &port );
        if( proxy ) {
            SetDlgItemText( dlg, IDC_PROXY_HOST, proxy );
            SetDlgItemInt( dlg, IDC_PROXY_PORT, port, FALSE );
            user = kserver_get_proxy_info( PROXY_USER );
            if( user )
                SetDlgItemText( dlg, IDC_PROXY_USER, user );
            pass = kserver_get_proxy_info( PROXY_PASS );
            if( pass )
                SetDlgItemText( dlg, IDC_PROXY_PWD, pass );
        }
	center_window( dlg );
	SetForegroundWindow( dlg );
        break;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE )
            EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD( wparam ) ) {
        case IDOK:
	    keyserver_proxy_ctx ctx;            
	    memset (&ctx, 0, sizeof (ctx));
	    if (read_proxy (dlg, &ctx)) 
		return FALSE;
	    kserver_change_proxy (&ctx);
	    proxy_release (&ctx);
            EndDialog (dlg, TRUE);
            return TRUE;
            
        case IDCANCEL:
            EndDialog (dlg, FALSE);
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* keyserver_proxy_dlg_proc */
