/* common-status.c
 *      Copyright (C) 2004 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#include <stdlib.h>
#include <stdio.h>

#include "types.h"
#include "context.h"
#include "common-status.h"
#include "util.h"


gpgme_error_t
_gpgme_nodata_status_handler (gpg_status_code_t code,
                              const char * args, int * ret)
{
    *ret = 0;

    switch (code) {
    case STATUS_NODATA:
        if (args)
            *ret = atoi (args);
        else
            *ret = -1;
        break;

    case STATUS_UNEXPECTED:
        *ret = 1;
        break;
    }

    return 0;
}


gpgme_error_t
_gpgme_sigtrust_status_handler (gpg_status_code_t code,
                                const char * args,
                                int * retval)
{
    *retval = 0;

    switch (code) {
    case STATUS_TRUST_UNDEFINED:
        *retval = GPGME_VALIDITY_UNDEFINED;
        break;

    case STATUS_TRUST_NEVER:
        *retval = GPGME_VALIDITY_NEVER;
        break;

    case STATUS_TRUST_MARGINAL:
        *retval = GPGME_VALIDITY_MARGINAL;
        break;

    case STATUS_TRUST_FULLY:
        *retval = GPGME_VALIDITY_FULL;
        break;

    case STATUS_TRUST_ULTIMATE:
        *retval = GPGME_VALIDITY_ULTIMATE;
        break;
    }
    return 0;
}


gpgme_error_t
_gpgme_pass_status_handler (gpg_status_code_t code,
                            const char *args,
                            int *r_bad_pass, int *r_no_pass,
                            char **r_info)
{
    int bad_pass = *r_bad_pass;
    int no_pass = *r_no_pass;
    char * p;

    switch (code) {
    case STATUS_BAD_PASSPHRASE:
        bad_pass++;
        break;

    case STATUS_GOOD_PASSPHRASE:
        bad_pass = 0;
        break;

    case STATUS_NEED_PASSPHRASE:
    case STATUS_NEED_PASSPHRASE_SYM:
        DEBUG1 ("pass_status_handler: %s\r\n", args);
        safe_free (*r_info);
        p = *r_info = strdup (args);
        if (!p)
            return GPGME_Out_Of_Core;
        break;

    case STATUS_MISSING_PASSPHRASE:
        DEBUG0 ("missing passphrase - stop\n");
        no_pass = 1;
        break;
    }

    *r_bad_pass = bad_pass;
    *r_no_pass = no_pass;

    return 0;
}
