//------------------------------ $Keywords ----------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeePassPhrase.cpp - Passphrase dialog
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 1 $ $Revision: 4 $
/*
$History: **** V 1.0 by kfitzner ****
$History: * gpgeepassphrase.ddp - 2005-05-13 5:47:28 PM - 51 Bytes
$History: * gpgeepassphrase.cpp - 2005-05-13 11:14:15 PM - 6683 Bytes
$History: * gpgeepassphrase.dfm - 2005-05-07 1:54:58 PM - 7129 Bytes
$History: * gpgeepassphrase.h - 2005-05-05 5:24:40 AM - 2858 Bytes
$History: * Initial check-in
$History: **** V 1.1 by kfitzner ****
$History: * gpgeepassphrase.cpp - 2005-05-16 11:41:19 PM - 7011 Bytes
$History: * gpgeepassphrase.dfm - 2005-05-07 1:54:58 PM - 7129 Bytes
$History: * gpgeepassphrase.h - 2005-05-05 5:24:40 AM - 2858 Bytes
$History: * gpgeepassphrase.ddp - 2005-05-16 11:40:52 PM - 51 Bytes
$History: * Remove thememgr linkage
$History: **** V 1.2 by kfitzner ****
$History: * gpgeepassphrase.cpp - 2005-07-29 2:51:15 PM - 8155 Bytes
$History: * gpgeepassphrase.dfm - 2005-05-07 1:54:58 PM - 7129 Bytes
$History: * gpgeepassphrase.h - 2005-07-25 7:58:12 AM - 2853 Bytes
$History: * gpgeepassphrase.ddp - 2005-07-25 8:55:10 AM - 51 Bytes
$History: * Lock passphrase memory pages to prevent swapping
$History: **** V 1.3 by kfitzner ****
$History: * gpgeepassphrase.cpp - 2005-08-08 6:47:55 AM - 8476 Bytes
$History: * gpgeepassphrase.dfm - 2005-05-07 1:54:58 PM - 7129 Bytes
$History: * gpgeepassphrase.h - 2005-08-08 6:36:40 AM - 2789 Bytes
$History: * gpgeepassphrase.ddp - 2005-08-08 6:36:40 AM - 51 Bytes
$History: * License change - remove option for later versions of GPL
$History: **** Latest ** V 1.4 by kfitzner ** 2005-10-06 8:28:34 PM ****
$History: * Add language support - now all forms' visual elements 
$History: * are stored in the string table (strings.rc)
*/
//----------------------------  $NoKeywords ---------------------------------


//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 21 Mar 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// A fairly simple form - a passphrase requester.  The main interface is the
// GetPassphrase() method.
//
// 20 July 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// The requester now locks the memory pages that correspond to the
// passphrase control.  This prevents it from swapping out the passphrase to
// virtual memory.
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "GPGeeUtility.h"
#include "TProgramLog.h"
#include "GPGeePassPhrase.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TformGPGeePassPhrase *formGPGeePassPhrase;

//---------------------------------------------------------------------------
// Form constructor
//
__fastcall TformGPGeePassPhrase::TformGPGeePassPhrase(TComponent* Owner): TForm(Owner)
{
  __ENTERFUNCTION__;

  MemoryLocked = NULL;

  __RETURNFUNCTION__;
}  // __fastcall TformGPGeePassPhrase::TformGPGeePassPhrase(TComponent* Owner): TForm(Owner)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Form destructor
//
__fastcall TformGPGeePassPhrase::~TformGPGeePassPhrase()
{
  __ENTERFUNCTION__;
  // Overwrite the passphrase with junk so it isn't left floating around in
  // unallocated memory after the form is deleted
  edtPassphrase->Text = String().StringOfChar('*', edtPassphrase->Text.Length());
  if (MemoryLocked)
    VirtualUnlock(MemoryLocked, 1024);
  __RETURNFUNCTION__;
}  // __fastcall TformGPGeePassPhrase::~TformGPGeePassPhrase()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// The form's OnShow event handler - most of the form's inititialisation is
// done here.
//
void __fastcall TformGPGeePassPhrase::FormShow(TObject *Sender)
{
  __ENTERFUNCTION__;

  // Read in the language strings for the form's visual text labels and change them on the form.  Borland's language
  // editor is capable of doing this, but it's much easier for translators if we can give them a single resource
  // string table to translate instead of forcing them to use Borland's translation tool.
  this->Caption          = GetMessage(FORM_PASS_CAPTION);
  lblPassphrase->Caption = GetMessage(FORM_PASS_CAPTION);
  btnPPOk->Caption       = GetMessage(FORM_BTN_OK);
  btnPPCancel->Caption   = GetMessage(FORM_BTN_CANCEL);
  chbHideTyping->Caption = GetMessage(FORM_PASS_CHECK_HIDE);
  lblHeading->Caption    = GetMessage(FORM_PASS_LABEL_SECRET);
  lblUser->Caption       = GetMessage(FORM_PASS_LABEL_USER);
  lblId->Caption         = GetMessage(FORM_PASS_LABEL_ID);
  lblType->Caption       = GetMessage(FORM_PASS_LABEL_TYPE);
  lblSize->Caption       = GetMessage(FORM_PASS_LABEL_SIZE);
  lblDate->Caption       = GetMessage(FORM_PASS_LABEL_DATE);

  if (!sKeyId.IsEmpty()) {
    pnlSymmetric->Width = 0;
    pnlSymmetric->Height = 0;
    pnlSymmetric->Visible = false;
    edtUser->Text = sKeyUser;
    edtId->Text   = sKeyId;
    edtType->Text = sKeyType;
    edtSize->Text = sKeySize;
    edtDate->Text = sKeyCreationDate;
  } else {
    if (!sKeyUser.IsEmpty())
      lblCaption->Caption = sKeyUser;
    else
      lblCaption->Caption = GetMessage(MSG_QUERY_GPGEE_SYMENCRYPT);

    lblCaption->Width = 401;
    lblCaption->Top = (pnlSymmetric->Height - 4) / 2 - lblCaption->Height / 2;
  } // if (!sKeyUser.IsEmpty())
  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeePassPhrase::FormActivateFirst(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// chbHideTyping OnClick event handler
// Hide or unhide the passphrase
void __fastcall TformGPGeePassPhrase::chbHideTypingClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  edtPassphrase->PasswordChar = chbHideTyping->Checked?'*':'\0';
  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeePassPhrase::chbHideTypingClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// edtPassphrase OnChange event handler
// Turn on or off the Ok button depending on whether there is text in the
// passphrase control.
void __fastcall TformGPGeePassPhrase::edtPassphraseChange(TObject *Sender)
{
  void *LockPage;

  __ENTERFUNCTION__;

  btnPPOk->Enabled = !edtPassphrase->Text.IsEmpty();

  // Lock the page in memory containing the passphrase edit box text to prevent the memory from being swapped out
  LockPage = (void *)(edtPassphrase->Text.data());
  if (LockPage) {
    if (MemoryLocked && MemoryLocked != LockPage)
      VirtualUnlock(MemoryLocked, 1024);
    VirtualLock(LockPage, 1024);
    MemoryLocked = LockPage;
  } else {
    if (MemoryLocked)
      VirtualUnlock(MemoryLocked, 1024);
  }  // if (LockPage)

  __RETURNFUNCTION__;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Interface function to pull up the form preloaded with the info about the
// key that the system is asking for the passphrase to unlock
//
int __fastcall TformGPGeePassPhrase::GetPassphrase(AnsiString User, AnsiString Id, AnsiString Type, AnsiString Size, AnsiString Date)
{
  int retval;

  __ENTERFUNCTION__;
  sKeyUser = User;
  sKeyId = Id;
  sKeyType = Type;
  sKeySize = Size;
  sKeyCreationDate = Date;
  retval = ShowModal();
  __RETURNFUNCTION(retval);
}  // int __fastcall TformGPGeePassPhrase::GetPassphrase(AnsiString User, AnsiString Id, AnsiString Type, AnsiString Size, AnsiString Date)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Alternative interface funtion to pull up the form - this one doesn't
// display any key information, just the string Caption.  If Caption is empty
// then the stock string "Enter passphrase for symmetric encryption:" is
// used.
//
int __fastcall TformGPGeePassPhrase::GetPassphrase(AnsiString Caption)
{
  int retval;

  __ENTERFUNCTION__;
  sKeyUser = Caption;
  retval = ShowModal();
  __RETURNFUNCTION(retval);
}  // int __fastcall TformGPGeePassPhrase::GetPassphrase(AnsiString Caption)
//---------------------------------------------------------------------------

