/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.mode;

import gnu.crypto.mode.IMode;
import gnu.crypto.mode.ModeFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.HashMap;
import java.util.Map;

public class TestOfCBC
implements Testlet {
    private byte[] key;
    private byte[] iv;
    private byte[] pt1;
    private byte[] ct1;
    private byte[] pt2;
    private byte[] ct2;
    private byte[] pt3;
    private byte[] ct3;
    private byte[] pt4;
    private byte[] ct4;
    private byte[] pt;
    private byte[] ct;
    private IMode mode;
    private Map attributes = new HashMap();

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfCBC.testAES128");
        this.key = Util.toBytesFromUnicode((String)"\u2b7e\u1516\u28ae\ud2a6\uabf7\u1588\u09cf\u4f3c");
        this.iv = Util.toBytesFromUnicode((String)"\u0001\u0203\u0405\u0607\u0809\u0a0b\u0c0d\u0e0f");
        this.pt1 = Util.toBytesFromUnicode((String)"\u6bc1\ubee2\u2e40\u9f96\ue93d\u7e11\u7393\u172a");
        this.ct1 = Util.toBytesFromUnicode((String)"\u7649\uabac\u8119\ub246\ucee9\u8e9b\u12e9\u197d");
        this.pt2 = Util.toBytesFromUnicode((String)"\uae2d\u8a57\u1e03\uac9c\u9eb7\u6fac\u45af\u8e51");
        this.ct2 = Util.toBytesFromUnicode((String)"\u5086\ucb9b\u5072\u19ee\u95db\u113a\u9176\u78b2");
        this.pt3 = Util.toBytesFromUnicode((String)"\u30c8\u1c46\ua35c\ue411\ue5fb\uc119\u1a0a\u52ef");
        this.ct3 = Util.toBytesFromUnicode((String)"\u73be\ud6b8\ue3c1\u743b\u7116\ue69e\u2222\u9516");
        this.pt4 = Util.toBytesFromUnicode((String)"\uf69f\u2445\udf4f\u9b17\uad2b\u417b\ue66c\u3710");
        this.ct4 = Util.toBytesFromUnicode((String)"\u3ff1\ucaa1\u681f\uac09\u120e\uca30\u7586\ue1a7");
        this.pt = new byte[16];
        this.ct = new byte[16];
        this.mode = ModeFactory.getInstance((String)"cbc", (String)"aes", (int)16);
        this.attributes.clear();
        this.attributes.put("gnu.crypto.mode.iv", this.iv);
        this.attributes.put("gnu.crypto.cipher.key.material", this.key);
        try {
            this.attributes.put("gnu.crypto.mode.state", new Integer(1));
            this.mode.init(this.attributes);
            this.mode.update(this.pt1, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct1), "CBC-AES128-Encrypt block #1");
            this.mode.update(this.pt2, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct2), "CBC-AES128-Encrypt block #2");
            this.mode.update(this.pt3, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct3), "CBC-AES128-Encrypt block #3");
            this.mode.update(this.pt4, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct4), "CBC-AES128-Encrypt block #4");
            this.mode.reset();
            this.attributes.put("gnu.crypto.mode.state", new Integer(2));
            this.mode.init(this.attributes);
            this.mode.update(this.ct1, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt1), "CBC-AES128-Decrypt block #1");
            this.mode.update(this.ct2, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt2), "CBC-AES128-Decrypt block #2");
            this.mode.update(this.ct3, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt3), "CBC-AES128-Decrypt block #3");
            this.mode.update(this.ct4, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt4), "CBC-AES128-Decrypt block #4");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfCBC.testAES128");
        }
        harness.checkPoint("TestOfCBC.testAES192");
        this.key = Util.toBytesFromUnicode((String)"\u8e73\ub0f7\uda0e\u6452\uc810\uf32b\u8090\u79e5\u62f8\uead2\u522c\u6b7b");
        this.iv = Util.toBytesFromUnicode((String)"\u0001\u0203\u0405\u0607\u0809\u0a0b\u0c0d\u0e0f");
        this.pt1 = Util.toBytesFromUnicode((String)"\u6bc1\ubee2\u2e40\u9f96\ue93d\u7e11\u7393\u172a");
        this.ct1 = Util.toBytesFromUnicode((String)"\u4f02\u1db2\u43bc\u633d\u7178\u183a\u9fa0\u71e8");
        this.pt2 = Util.toBytesFromUnicode((String)"\uae2d\u8a57\u1e03\uac9c\u9eb7\u6fac\u45af\u8e51");
        this.ct2 = Util.toBytesFromUnicode((String)"\ub4d9\uada9\uad7d\uedf4\ue5e7\u3876\u3f69\u145a");
        this.pt3 = Util.toBytesFromUnicode((String)"\u30c8\u1c46\ua35c\ue411\ue5fb\uc119\u1a0a\u52ef");
        this.ct3 = Util.toBytesFromUnicode((String)"\u571b\u2420\u12fb\u7ae0\u7fa9\ubaac\u3df1\u02e0");
        this.pt4 = Util.toBytesFromUnicode((String)"\uf69f\u2445\udf4f\u9b17\uad2b\u417b\ue66c\u3710");
        this.ct4 = Util.toBytesFromUnicode((String)"\u08b0\ue279\u8859\u8881\ud920\ua9e6\u4f56\u15cd");
        this.ct = new byte[16];
        this.pt = new byte[16];
        this.mode = ModeFactory.getInstance((String)"cbc", (String)"aes", (int)16);
        this.attributes.clear();
        this.attributes.put("gnu.crypto.mode.iv", this.iv);
        this.attributes.put("gnu.crypto.cipher.key.material", this.key);
        try {
            this.attributes.put("gnu.crypto.mode.state", new Integer(1));
            this.mode.init(this.attributes);
            this.mode.update(this.pt1, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct1), "CBC-AES192-Decrypt block #1");
            this.mode.update(this.pt2, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct2), "CBC-AES192-Decrypt block #2");
            this.mode.update(this.pt3, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct3), "CBC-AES192-Decrypt block #3");
            this.mode.update(this.pt4, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct4), "CBC-AES192-Decrypt block #4");
            this.mode.reset();
            this.attributes.put("gnu.crypto.mode.state", new Integer(2));
            this.mode.init(this.attributes);
            this.mode.update(this.ct1, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt1), "CBC-AES192-Decrypt block #1");
            this.mode.update(this.ct2, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt2), "CBC-AES192-Decrypt block #2");
            this.mode.update(this.ct3, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt3), "CBC-AES192-Decrypt block #3");
            this.mode.update(this.ct4, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt4), "CBC-AES192-Decrypt block #4");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfCBC.testAES192");
        }
        harness.checkPoint("TestOfCBC.testAES256");
        this.key = Util.toBytesFromUnicode((String)"\u603d\ueb10\u15ca\u71be\u2b73\uaef0\u857d\u7781\u1f35\u2c07\u3b61\u08d7\u2d98\u10a3\u0914\udff4");
        this.iv = Util.toBytesFromUnicode((String)"\u0001\u0203\u0405\u0607\u0809\u0a0b\u0c0d\u0e0f");
        this.pt1 = Util.toBytesFromUnicode((String)"\u6bc1\ubee2\u2e40\u9f96\ue93d\u7e11\u7393\u172a");
        this.ct1 = Util.toBytesFromUnicode((String)"\uf58c\u4c04\ud6e5\uf1ba\u779e\uabfb\u5f7b\ufbd6");
        this.pt2 = Util.toBytesFromUnicode((String)"\uae2d\u8a57\u1e03\uac9c\u9eb7\u6fac\u45af\u8e51");
        this.ct2 = Util.toBytesFromUnicode((String)"\u9cfc\u4e96\u7edb\u808d\u679f\u777b\uc670\u2c7d");
        this.pt3 = Util.toBytesFromUnicode((String)"\u30c8\u1c46\ua35c\ue411\ue5fb\uc119\u1a0a\u52ef");
        this.ct3 = Util.toBytesFromUnicode((String)"\u39f2\u3369\ua9d9\ubacf\ua530\ue263\u0423\u1461");
        this.pt4 = Util.toBytesFromUnicode((String)"\uf69f\u2445\udf4f\u9b17\uad2b\u417b\ue66c\u3710");
        this.ct4 = Util.toBytesFromUnicode((String)"\ub2eb\u05e2\uc39b\ue9fc\uda6c\u1907\u8c6a\u9d1b");
        this.ct = new byte[16];
        this.pt = new byte[16];
        this.mode = ModeFactory.getInstance((String)"cbc", (String)"aes", (int)16);
        this.attributes.clear();
        this.attributes.put("gnu.crypto.mode.iv", this.iv);
        this.attributes.put("gnu.crypto.cipher.key.material", this.key);
        try {
            this.attributes.put("gnu.crypto.mode.state", new Integer(1));
            this.mode.init(this.attributes);
            this.mode.update(this.pt1, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct1), "CBC-AES256-Decrypt block #1");
            this.mode.update(this.pt2, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct2), "CBC-AES256-Decrypt block #2");
            this.mode.update(this.pt3, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct3), "CBC-AES256-Decrypt block #3");
            this.mode.update(this.pt4, 0, this.ct, 0);
            harness.check(Util.areEqual((byte[])this.ct, (byte[])this.ct4), "CBC-AES256-Decrypt block #4");
            this.mode.reset();
            this.attributes.put("gnu.crypto.mode.state", new Integer(2));
            this.mode.init(this.attributes);
            this.mode.update(this.ct1, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt1), "CBC-AES256-Decrypt block #1");
            this.mode.update(this.ct2, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt2), "CBC-AES256-Decrypt block #2");
            this.mode.update(this.ct3, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt3), "CBC-AES256-Decrypt block #3");
            this.mode.update(this.ct4, 0, this.pt, 0);
            harness.check(Util.areEqual((byte[])this.pt, (byte[])this.pt4), "CBC-AES256-Decrypt block #4");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfCBC.testAES256");
        }
    }
}

