/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.MD4;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class TestOfMD4
implements Testlet {
    private IMessageDigest algorithm;
    private IMessageDigest clone;

    public void test(TestHarness harness) {
        String exp;
        byte[] md;
        harness.checkPoint("TestOfMD4");
        try {
            this.algorithm = new MD4();
            harness.check(this.algorithm.selfTest(), "selfTest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.selfTest");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("a".getBytes(), 0, 1);
            md = this.algorithm.digest();
            exp = "BDE52CB31DE33E46245E05FBDBD6FB24";
            harness.check(exp.equals(Util.toString((byte[])md)), "testA");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testA");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("abc".getBytes(), 0, 3);
            md = this.algorithm.digest();
            exp = "A448017AAF21D8525FC10AE87AA6729D";
            harness.check(exp.equals(Util.toString((byte[])md)), "testABC");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testABC");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("message digest".getBytes(), 0, 14);
            md = this.algorithm.digest();
            exp = "D9130A8164549FE818874806E1C7014B";
            harness.check(exp.equals(Util.toString((byte[])md)), "testMessageDigest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testMessageDigest");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            md = this.algorithm.digest();
            exp = "D79E1C308AA5BBCDEEA8ED63DF412DA9";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAlphabet");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testAlphabet");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes(), 0, 62);
            md = this.algorithm.digest();
            exp = "043F8582F241DB351CE627E153E7F0E4";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAsciiSubset");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testAsciiSubset");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes(), 0, 80);
            md = this.algorithm.digest();
            exp = "E33B4DDC9C38F2199C3E7B164FCC0536";
            harness.check(exp.equals(Util.toString((byte[])md)), "testEightyNumerics");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testEightyNumerics");
        }
        try {
            this.algorithm = new MD4();
            this.algorithm.update("a".getBytes(), 0, 1);
            this.clone = (IMessageDigest)this.algorithm.clone();
            md = this.algorithm.digest();
            exp = "BDE52CB31DE33E46245E05FBDBD6FB24";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #1");
            this.clone.update("bc".getBytes(), 0, 2);
            md = this.clone.digest();
            exp = "A448017AAF21D8525FC10AE87AA6729D";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD4.testCloning");
        }
    }
}

