/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.basic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.model.sitemap.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.basic.internal.render.AbstractWidgetRenderer;
import org.openhab.ui.basic.render.RenderException;
import org.openhab.ui.basic.render.WidgetRenderer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class SliderRenderer
extends AbstractWidgetRenderer {
    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Slider;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Slider s = (Slider)w;
        String snippetName = "slider";
        String snippet = this.getSnippet(snippetName);
        String frequency = s.getFrequency() == 0 ? "200" : Integer.toString(s.getFrequency());
        String unit = this.getUnitForWidget(w);
        snippet = this.preprocessSnippet(snippet, w);
        snippet = StringUtils.replace((String)snippet, (String)"%frequency%", (String)frequency);
        snippet = StringUtils.replace((String)snippet, (String)"%switch%", (String)(s.isSwitchEnabled() ? "1" : "0"));
        snippet = StringUtils.replace((String)snippet, (String)"%unit%", (String)unit);
        snippet = StringUtils.replace((String)snippet, (String)"%minValue%", (String)this.minValueOf(s));
        snippet = StringUtils.replace((String)snippet, (String)"%maxValue%", (String)this.maxValueOf(s));
        snippet = StringUtils.replace((String)snippet, (String)"%step%", (String)this.stepOf(s));
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }

    private String maxValueOf(Slider slider) {
        if (slider.getMaxValue() != null) {
            return slider.getMaxValue().toString();
        }
        return "100";
    }

    private String minValueOf(Slider slider) {
        if (slider.getMinValue() != null) {
            return slider.getMinValue().toString();
        }
        return "0";
    }

    private String stepOf(Slider slider) {
        if (slider.getStep() != null) {
            return slider.getStep().toString();
        }
        return "1";
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

