/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.basic.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebAppConfig {
    private static final String DEFAULT_SITEMAP = "default";
    public static final String THEME_NAME_DEFAULT = "default";
    public static final String THEME_NAME_DARK = "dark";
    private static final String DEFAULT_THEME = "default";
    private String defaultSitemap = "default";
    private String theme = "default";
    private List<String> cssClassList = new ArrayList<String>();
    private static final Map<String, String> CSS_CLASSES = new HashMap<String, String>();
    private static final Map<String, Boolean> CSS_DEFAULT_VALUES;
    private static final String CONFIG_ENABLE_ICONS = "enableIcons";
    private static final String CONFIG_CONDENSED_LAYOUT = "condensedLayout";
    private static final String CONFIG_CAPITALIZE = "capitalizeValues";

    static {
        CSS_CLASSES.put(CONFIG_ENABLE_ICONS, "ui-icons-enabled");
        CSS_CLASSES.put(CONFIG_CONDENSED_LAYOUT, "ui-layout-condensed");
        CSS_CLASSES.put(CONFIG_CAPITALIZE, "ui-capitalize-values");
        CSS_DEFAULT_VALUES = new HashMap<String, Boolean>();
        CSS_DEFAULT_VALUES.put(CONFIG_ENABLE_ICONS, true);
        CSS_DEFAULT_VALUES.put(CONFIG_CONDENSED_LAYOUT, false);
        CSS_DEFAULT_VALUES.put(CONFIG_CAPITALIZE, false);
    }

    private void applyCssClasses(Map<String, Object> configProps) {
        this.cssClassList.clear();
        for (String key : CSS_CLASSES.keySet()) {
            Boolean value = CSS_DEFAULT_VALUES.get(key);
            if (configProps.containsKey(key)) {
                value = configProps.get(key).toString().equalsIgnoreCase("true");
            }
            if (!value.booleanValue()) continue;
            this.cssClassList.add(CSS_CLASSES.get(key));
        }
    }

    public void applyConfig(Map<String, Object> configProps) {
        String configDefaultSitemap = (String)configProps.get("defaultSitemap");
        String configTheme = (String)configProps.get("theme");
        if (configDefaultSitemap == null) {
            configDefaultSitemap = "default";
        }
        if (configTheme == null) {
            configTheme = "default";
        }
        this.defaultSitemap = configDefaultSitemap;
        this.theme = configTheme;
        this.applyCssClasses(configProps);
    }

    public String getDefaultSitemap() {
        return this.defaultSitemap;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getCssClassList() {
        String result = " ";
        for (String item : this.cssClassList) {
            result = String.valueOf(result) + item + " ";
        }
        return result;
    }
}

