/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Filter;
import org.eclipse.dali.internal.utility.SimpleFilter;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;

public class FilteringIteratorTests
extends TestCase {
    private static final String PREFIX = "prefix";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.FilteringIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.FilteringIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public FilteringIteratorTests(String name) {
        super(name);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            String string = (String)stream.next();
            if (!string.equals("prefix3")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        FilteringIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = this.buildAcceptIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        FilteringIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testAcceptHasNext() {
        int i = 0;
        Iterator stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testAcceptNext() {
        Iterator stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)((String)stream.next()).startsWith(PREFIX));
        }
    }

    public void testInnerHasNext() {
        int i = 0;
        Iterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testInnerNext() {
        Iterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)((String)stream.next()).startsWith(PREFIX));
        }
    }

    public void testRejectHasNext() {
        int i = 0;
        Iterator stream = this.buildRejectIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)2, (int)i);
    }

    public void testRejectNext() {
        Iterator stream = this.buildRejectIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertFalse((String)"bogus reject", (boolean)((String)stream.next()).startsWith(PREFIX));
        }
    }

    public void testBothHasNext() {
        int i = 0;
        Iterator stream = this.buildBothIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testLoadNext() {
        Iterator stream = this.buildInnerIterator2();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)((String)stream.next()).startsWith(PREFIX));
        }
    }

    private Iterator buildFilteredIterator(Iterator nestedIterator, Filter filter) {
        return new FilteringIterator(nestedIterator, filter);
    }

    private Iterator buildInnerFilteredIterator(Iterator nestedIterator) {
        return new FilteringIterator(nestedIterator){

            protected boolean accept(Object next) {
                return ((String)next).startsWith(FilteringIteratorTests.PREFIX);
            }
        };
    }

    String getPrefix() {
        return PREFIX;
    }

    private Iterator buildInnerFilteredIterator2(Iterator nestedIterator) {
        return new FilteringIterator(nestedIterator){

            protected boolean accept(Object next) {
                return ((String)next).startsWith(FilteringIteratorTests.this.getPrefix());
            }
        };
    }

    private Iterator buildNestedIterator() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("prefix1");
        c.add("prefix2");
        c.add("prefix3");
        c.add("4");
        c.add("prefix5");
        c.add("prefix6");
        c.add("prefix7");
        c.add("8");
        return c.iterator();
    }

    private Iterator buildAcceptIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildAcceptFilter(PREFIX));
    }

    private Iterator buildInnerIterator() {
        return this.buildInnerFilteredIterator(this.buildNestedIterator());
    }

    private Iterator buildInnerIterator2() {
        return this.buildInnerFilteredIterator2(this.buildNestedIterator());
    }

    private Filter buildAcceptFilter(String prefix) {
        return new SimpleFilter(prefix){

            public boolean accept(Object next) {
                return ((String)next).startsWith((String)this.criterion);
            }
        };
    }

    private Iterator buildRejectIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildRejectFilter(PREFIX));
    }

    private Filter buildRejectFilter(String prefix) {
        return new SimpleFilter(prefix){

            public boolean reject(Object next) {
                return ((String)next).startsWith((String)this.criterion);
            }
        };
    }

    private Iterator buildBothIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildBothFilter(PREFIX));
    }

    private Filter buildBothFilter(String prefix) {
        return new SimpleFilter(prefix){

            public boolean reject(Object next) {
                return ((String)next).startsWith((String)this.criterion);
            }

            public boolean accept(Object next) {
                return ((String)next).startsWith((String)this.criterion);
            }
        };
    }
}

