/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.ReadOnlyListIterator;

public class ReadOnlyListIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.ReadOnlyListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.ReadOnlyListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ReadOnlyListIteratorTests(String name) {
        super(name);
    }

    public void testHasNextAndHasPrevious() {
        int i = 0;
        ListIterator stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ReadOnlyListIteratorTests.assertEquals((int)this.buildList().size(), (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        ReadOnlyListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNextAndPrevious() {
        ListIterator nestedListIterator = this.buildNestedListIterator();
        ListIterator stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", nestedListIterator.next(), stream.next());
        }
        while (stream.hasPrevious()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", nestedListIterator.previous(), stream.previous());
        }
    }

    public void testNextIndexAndPreviousIndex() {
        ListIterator nestedListIterator = this.buildNestedListIterator();
        ListIterator stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)stream.nextIndex());
            nestedListIterator.next();
            stream.next();
        }
        ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)this.buildList().size(), (int)stream.nextIndex());
        while (stream.hasPrevious()) {
            ReadOnlyListIteratorTests.assertEquals((String)"bogus element", (int)nestedListIterator.previousIndex(), (int)stream.previousIndex());
            nestedListIterator.previous();
            stream.previous();
        }
        ReadOnlyListIteratorTests.assertEquals((String)"bogus index", (int)-1, (int)stream.previousIndex());
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator stream = this.buildReadOnlyListIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReadOnlyListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemove() {
        boolean exCaught = false;
        ListIterator stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testSet() {
        boolean exCaught = false;
        ListIterator stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.set("bogus");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testAdd() {
        boolean exCaught = false;
        ListIterator stream = this.buildReadOnlyListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.add("bogus");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private ListIterator buildReadOnlyListIterator() {
        return this.buildReadOnlyListIterator(this.buildNestedListIterator());
    }

    private ListIterator buildReadOnlyListIterator(ListIterator nestedListIterator) {
        return new ReadOnlyListIterator(nestedListIterator);
    }

    private ListIterator buildNestedListIterator() {
        return this.buildList().listIterator();
    }

    private List buildList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("one");
        l.add("two");
        l.add("three");
        l.add("four");
        l.add("five");
        l.add("six");
        l.add("seven");
        l.add("eight");
        return l;
    }
}

