/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.projects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class TestPlatformProject {
    private IProject project;

    public static void waitForJobs() {
        while (Platform.getJobManager().currentJob() != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public TestPlatformProject() throws CoreException {
        this("TestProject", false);
    }

    public TestPlatformProject(boolean autoBuild) throws CoreException {
        this("TestProject", autoBuild);
    }

    public TestPlatformProject(String projectName, boolean autoBuild) throws CoreException {
        this.buildPlatformProject(projectName, autoBuild);
    }

    private void buildPlatformProject(String projectName, boolean autoBuild) throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(autoBuild);
        ResourcesPlugin.getWorkspace().setDescription(description);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject(projectName);
        this.project.create(null);
        this.project.open(null);
    }

    public IProject getProject() {
        return this.project;
    }

    public void addProjectNature(String natureId) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        String[] oldNatureIds = description.getNatureIds();
        String[] newNatureIds = new String[oldNatureIds.length + 1];
        System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
        newNatureIds[oldNatureIds.length] = natureId;
        description.setNatureIds(newNatureIds);
        this.project.setDescription(description, null);
    }

    public void removeProjectNature(String natureId) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int size = prevNatures.length;
        int newsize = 0;
        String[] newNatures = new String[size];
        int i = 0;
        while (i < size) {
            if (!prevNatures[i].equals(natureId)) {
                newNatures[newsize++] = prevNatures[i];
            }
            ++i;
        }
        String[] temp = newNatures;
        newNatures = new String[newsize];
        System.arraycopy(temp, 0, newNatures, 0, newsize);
        description.setNatureIds(newNatures);
        this.project.setDescription(description, null);
    }

    public IFolder createFolder(String folderName) throws CoreException {
        return this.createFolder((IContainer)this.project, (IPath)new Path(folderName));
    }

    public IFolder createFolder(IContainer container, String folderName) throws CoreException {
        return this.createFolder(container, (IPath)new Path(folderName));
    }

    public IFolder createFolder(IContainer container, IPath folderPath) throws CoreException {
        IFolder folder = container.getFolder(folderPath);
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        return folder;
    }

    public IFile createFile(String fileName, String source) throws CoreException {
        return this.createFile((IContainer)this.project, fileName, source);
    }

    public IFile createFile(IContainer container, String fileName, String source) throws CoreException {
        return this.createFile(container, (IPath)new Path(fileName), source);
    }

    public IFile createFile(IContainer container, IPath filePath, String source) throws CoreException {
        return this.createFile(container, filePath, new ByteArrayInputStream(source.getBytes()));
    }

    public IFile createFile(IContainer container, IPath filePath, InputStream source) throws CoreException {
        IFile file = container.getFile(filePath);
        if (!file.exists()) {
            file.create(source, false, null);
        }
        return file;
    }

    public void openProject() throws CoreException {
        this.project.open(null);
        TestPlatformProject.waitForJobs();
    }

    public void closeProject() throws CoreException {
        this.project.close(null);
        TestPlatformProject.waitForJobs();
    }

    public void dispose() throws CoreException {
        this.project.delete(true, true, null);
        int i = 0;
        while (this.project.exists()) {
            System.out.println("Project still exists " + i++);
            TestPlatformProject.waitForJobs();
        }
    }
}

