/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.projects;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dali.core.tests.projects.TestPlatformProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.launching.JavaRuntime;

public class TestJavaProject
extends TestPlatformProject {
    private IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;

    public TestJavaProject(boolean autoBuild) throws CoreException {
        this("TestJavaProject", autoBuild);
    }

    public TestJavaProject() throws CoreException {
        this("TestJavaProject", false);
    }

    public TestJavaProject(String projectName, boolean autoBuild) throws CoreException {
        super(projectName, autoBuild);
        this.buildJavaProject();
    }

    private void buildJavaProject() throws CoreException {
        this.setJavaNature();
        this.javaProject = JavaCore.create((IProject)this.getProject());
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.sourceFolder = this.createSourceFolder();
        this.createBinFolder();
        this.addSystemLibraries();
        this.javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", "1.5");
        this.javaProject.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        this.javaProject.setOption("org.eclipse.jdt.core.compiler.source", "1.5");
    }

    public void setJavaNature() throws CoreException {
        this.addProjectNature("org.eclipse.jdt.core.javanature");
    }

    private void createBinFolder() throws CoreException {
        IFolder binFolder = this.createFolder("bin");
        IPath outputLocation = binFolder.getFullPath();
        this.javaProject.setOutputLocation(outputLocation, null);
    }

    private IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder folder = this.createFolder("src");
        IPackageFragmentRoot root = this.javaProject.getPackageFragmentRoot((IResource)folder);
        this.addClasspathEntry(JavaCore.newSourceEntry((IPath)root.getPath()));
        return root;
    }

    private void addSystemLibraries() throws JavaModelException {
        this.addClasspathEntry(JavaRuntime.getDefaultJREContainerEntry());
    }

    private void addClasspathEntry(IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = entry;
        this.javaProject.setRawClasspath(newEntries, null);
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IPackageFragment createPackage(String packageName) throws CoreException {
        return this.sourceFolder.createPackageFragment(packageName, false, null);
    }

    public IType createType(IPackageFragment pkg, String cuName, String source) throws CoreException {
        StringBuffer sb = new StringBuffer();
        sb.append("package " + pkg.getElementName() + ";\n");
        sb.append("\n");
        sb.append(source);
        ICompilationUnit cu = pkg.createCompilationUnit(cuName, sb.toString(), false, null);
        return cu.getTypes()[0];
    }

    public void openProject() throws CoreException {
        super.openProject();
        this.javaProject = JavaCore.create((IProject)this.getProject());
        this.sourceFolder = this.javaProject.getPackageFragmentRoot((IResource)this.getProject().getFolder("src"));
    }

    public void closeProject() throws CoreException {
        super.closeProject();
        this.javaProject = null;
        this.sourceFolder = null;
    }

    public void dispose() throws CoreException {
        this.waitForIndexer();
        super.dispose();
    }

    private void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, null, 8, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new TypeNameRequestor(){}, 3, null);
    }
}

