/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.model;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.core.tests.junitx.TestCase;
import org.eclipse.dali.core.tests.projects.TestDaliProject;

public class PersistenceBuilderTests
extends TestCase {
    private TestDaliProject project;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.model.PersistenceBuilderTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public PersistenceBuilderTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new TestDaliProject();
        this.project.setPersistenceNature();
    }

    protected void tearDown() throws Exception {
        this.project.dispose();
        super.tearDown();
    }

    private void doFullBuild() throws CoreException {
        TestProgressMonitor testProgressMonitor = new TestProgressMonitor();
        this.project.getProject().build(6, (IProgressMonitor)testProgressMonitor);
        while (!testProgressMonitor.finished) {
            this.waitForJobs();
        }
    }

    public void testSimpleFullBuild() throws CoreException {
        IFile file = this.project.createFile((IContainer)this.project.getProject().getFolder("src"), "TestEntity.java", "@Entity public class TestEntity { @Id public String getId() { return null; } public void setId(String id) {} }");
        this.doFullBuild();
        PersistenceBuilderTests.assertTrue((file.findMarkers("org.eclipse.dali.core.validationProblemMarker", true, 2).length == 0 ? 1 : 0) != 0);
        file.delete(true, false, null);
        file = this.project.createFile((IContainer)this.project.getProject().getFolder("src"), "TestEntity2.java", "@Entity public class TestEntity2 { public String getId() { return null; } public void setId(String id) {} }");
        this.doFullBuild();
        PersistenceBuilderTests.assertTrue((file.findMarkers("org.eclipse.dali.core.validationProblemMarker", true, 2).length > 0 ? 1 : 0) != 0);
    }

    public void testFullBuildWithReferences() throws CoreException {
        IFile file = this.project.createFile((IContainer)this.project.getProject().getFolder("src"), "TestEntity.java", "@Entity public class TestEntity { @Id public String getId() { return null; } public void setId(String id) {} @OneToOne public TestTargetEntity getTarget() { return null; } public void setTarget(TestTargetEntity target) {} }");
        this.doFullBuild();
        PersistenceBuilderTests.assertTrue((file.findMarkers("org.eclipse.dali.core.validationProblemMarker", true, 2).length > 0 ? 1 : 0) != 0);
        IFile file2 = this.project.createFile((IContainer)this.project.getProject().getFolder("src"), "TestTargetEntity.java", "@Entity public class TestTargetEntity { @Id public String getId() { return null; } public void setId(String id) {} }");
        this.doFullBuild();
        PersistenceBuilderTests.assertTrue((file2.findMarkers("org.eclipse.dali.core.validationProblemMarker", true, 2).length == 0 ? 1 : 0) != 0);
        PersistenceBuilderTests.assertTrue((file.findMarkers("org.eclipse.dali.core.validationProblemMarker", true, 2).length == 0 ? 1 : 0) != 0);
        file2.delete(true, false, null);
        this.doFullBuild();
        PersistenceBuilderTests.assertTrue((file.findMarkers("org.eclipse.dali.core.validationProblemMarker", true, 2).length > 0 ? 1 : 0) != 0);
    }

    private static class TestProgressMonitor
    implements IProgressMonitor {
        boolean finished = false;

        private TestProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            this.finished = true;
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void reset() {
            this.finished = false;
        }

        public void setCanceled(boolean b) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

