/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.dali.orm.impl.TableImpl;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class StringAnnotationElementAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    private StringAnnotationElementAdapter stringAnnotationElementAdapter;
    private StringAnnotationElementAdapter stringAnnotationElementValueAdapter;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.StringAnnotationElementAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public StringAnnotationElementAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        this.stringAnnotationElementAdapter = new StringAnnotationElementAdapter(this.buildAnnotationElementInfo());
        this.stringAnnotationElementValueAdapter = new StringAnnotationElementAdapter(this.buildAnnotationElementValueInfo());
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildAnnotationElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                StringAnnotationElementAdapterTests.this.testClassType.getTypeMapping().getTable().setSpecifiedName(newValue);
            }

            public String persValue() {
                return StringAnnotationElementAdapterTests.this.testClassType.getTypeMapping().getTable().getSpecifiedName();
            }

            public String defaultValue() {
                return null;
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Table";
            }

            public Member member() {
                return ((JavaPersistentTypeModelAdapter)StringAnnotationElementAdapterTests.this.testClassType.getModelAdapter()).getType();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildAnnotationElementValueInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                StringAnnotationElementAdapterTests.this.testClassType.getTypeMapping().getTable().setSpecifiedName(newValue);
            }

            public String persValue() {
                return StringAnnotationElementAdapterTests.this.testClassType.getTypeMapping().getTable().getSpecifiedName();
            }

            public String defaultValue() {
                return null;
            }

            public String annotationElementName() {
                return "value";
            }

            public String annotationName() {
                return "Table";
            }

            public Member member() {
                return StringAnnotationElementAdapterTests.this.getType();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private Type getType() {
        return ((JavaPersistentTypeModelAdapter)this.testClassType.getModelAdapter()).getType();
    }

    protected void tearDown() throws Exception {
        this.stringAnnotationElementAdapter = null;
        this.stringAnnotationElementValueAdapter = null;
        this.project.dispose();
        this.project = null;
        super.tearDown();
    }

    private void setStringInPersistenceModel() {
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen("bar");
        boolean changed = this.stringAnnotationElementAdapter.updateJavaElement();
        StringAnnotationElementAdapterTests.assertEquals((boolean)true, (boolean)changed);
        Annotation tableAnnotation = this.getType().getAnnotation("Table");
        StringAnnotationElementAdapterTests.assertNotNull((String)"Table annotation should have been added", (Object)tableAnnotation);
        StringAnnotationElementAdapterTests.assertTrue((String)"Table annotation is not a NormalAnnotation", (boolean)tableAnnotation.isNormalAnnotation());
        MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)((NormalAnnotation)tableAnnotation), (String)"name");
        StringAnnotationElementAdapterTests.assertNotNull((Object)valuePair);
        StringAnnotationElementAdapterTests.assertEquals((String)"MemberValuePair value is not \"bar\"", (String)"bar", (String)ASTTools.stringValue((MemberValuePair)valuePair));
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen("foo");
        changed = this.stringAnnotationElementAdapter.updateJavaElement();
        tableAnnotation = this.getType().getAnnotation("Table");
        valuePair = ASTTools.memberValuePair((NormalAnnotation)((NormalAnnotation)tableAnnotation), (String)"name");
        StringAnnotationElementAdapterTests.assertEquals((boolean)true, (boolean)changed);
        StringAnnotationElementAdapterTests.assertEquals((String)"MemberValuePair value is not \"foo\"", (String)"foo", (String)ASTTools.stringValue((MemberValuePair)valuePair));
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen("foo");
        changed = this.stringAnnotationElementAdapter.updateJavaElement();
        StringAnnotationElementAdapterTests.assertEquals((boolean)false, (boolean)changed);
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen(null);
        changed = this.stringAnnotationElementAdapter.updateJavaElement();
        StringAnnotationElementAdapterTests.assertEquals((boolean)true, (boolean)changed);
        StringAnnotationElementAdapterTests.assertNull((Object)this.getType().getAnnotation("Table"));
    }

    public void testSetStringInPersistenceModelNoAnnotation() {
        boolean changed = this.stringAnnotationElementAdapter.updateJavaElement();
        StringAnnotationElementAdapterTests.assertEquals((boolean)false, (boolean)changed);
        StringAnnotationElementAdapterTests.assertNull((Object)this.getType().getAnnotation("Table"));
        this.setStringInPersistenceModel();
    }

    public void testSetStringInPersistenceModelMarkerAnnotation() {
        this.getType().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MarkerAnnotation newAnnotation = ASTTools.newMarkerAnnotation((AST)bodyDeclaration.getAST(), (String)"Table");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)newAnnotation);
            }
        });
        this.setStringInPersistenceModel();
    }

    public void testSetStringInPersistenceModelNormalAnnotation() {
        this.getType().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation newAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"Table");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)newAnnotation);
            }
        });
        this.setStringInPersistenceModel();
    }

    public void testSetStringInPersistenceModelSingleMemberAnnotation() {
        this.getType().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation newAnnotation = ASTTools.newSingleMemberAnnotation((AST)bodyDeclaration.getAST(), (String)"Table");
                newAnnotation.setValue((Expression)ASTTools.newStringLiteral((AST)bodyDeclaration.getAST(), (String)"foo"));
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)newAnnotation);
            }
        });
        this.setStringInPersistenceModel();
    }

    public void setValueAnnotationSetStringInPersistenceModel() {
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen("bar");
        boolean changed = this.stringAnnotationElementValueAdapter.updateJavaElement();
        StringAnnotationElementAdapterTests.assertEquals((boolean)true, (boolean)changed);
        Annotation tableAnnotation = this.getType().getAnnotation("Table");
        StringAnnotationElementAdapterTests.assertNotNull((String)"Table annotation should have been added", (Object)tableAnnotation);
        StringAnnotationElementAdapterTests.assertTrue((String)"Table annotation is not a SingleMemberAnnotation", (boolean)tableAnnotation.isSingleMemberAnnotation());
        Expression value = ((SingleMemberAnnotation)tableAnnotation).getValue();
        StringAnnotationElementAdapterTests.assertNotNull((Object)value);
        StringAnnotationElementAdapterTests.assertEquals((int)45, (int)value.getNodeType());
        StringAnnotationElementAdapterTests.assertEquals((String)"MemberValuePair value is not \"bar\"", (String)"bar", (String)((StringLiteral)value).getLiteralValue());
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen("foo");
        changed = this.stringAnnotationElementValueAdapter.updateJavaElement();
        tableAnnotation = this.getType().getAnnotation("Table");
        value = ((SingleMemberAnnotation)tableAnnotation).getValue();
        StringAnnotationElementAdapterTests.assertEquals((boolean)true, (boolean)changed);
        StringAnnotationElementAdapterTests.assertNotNull((Object)value);
        StringAnnotationElementAdapterTests.assertEquals((int)45, (int)value.getNodeType());
        StringAnnotationElementAdapterTests.assertEquals((String)"MemberValuePair value is not \"foo\"", (String)"foo", (String)((StringLiteral)value).getLiteralValue());
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen("foo");
        changed = this.stringAnnotationElementValueAdapter.updateJavaElement();
        tableAnnotation = this.getType().getAnnotation("Table");
        StringAnnotationElementAdapterTests.assertEquals((boolean)false, (boolean)changed);
        ((TableImpl)((Entity)this.testClassType.getTypeMapping()).getTable()).setSpecifiedNameGen(null);
        changed = this.stringAnnotationElementValueAdapter.updateJavaElement();
        StringAnnotationElementAdapterTests.assertEquals((boolean)true, (boolean)changed);
        StringAnnotationElementAdapterTests.assertNull((Object)this.getType().getAnnotation("Table"));
    }

    public void testSetValueAnnotationSetStringInPersistenceModelMarkerAnnotation() {
        this.getType().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MarkerAnnotation newAnnotation = ASTTools.newMarkerAnnotation((AST)bodyDeclaration.getAST(), (String)"Table");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)newAnnotation);
            }
        });
        this.setValueAnnotationSetStringInPersistenceModel();
    }

    public void testSetValueAnnotationSetStringInPersistenceModelNormalAnnotation() {
        this.getType().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation newAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"Table");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)newAnnotation);
            }
        });
        this.setValueAnnotationSetStringInPersistenceModel();
    }

    public void testSetValueAnnotationSetStringInPersistenceModelSingleMemberAnnotation() {
        this.getType().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation newAnnotation = ASTTools.newSingleMemberAnnotation((AST)bodyDeclaration.getAST(), (String)"Table");
                newAnnotation.setValue((Expression)ASTTools.newStringLiteral((AST)bodyDeclaration.getAST(), (String)"foo"));
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)newAnnotation);
            }
        });
        this.setValueAnnotationSetStringInPersistenceModel();
    }
}

