/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.pipeline.stage.resolve.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.environment.InstallLog;
import org.eclipse.virgo.kernel.install.pipeline.stage.PipelineStage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.BundleException;

public final class QuasiInstallStage
implements PipelineStage {
    @Override
    public void process(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        QuasiFramework quasiFramework = installEnvironment.getQuasiFramework();
        installGraph.visit((GraphNode.DirectedAcyclicGraphVisitor)new InstallVisitor(quasiFramework, installEnvironment.getInstallLog()));
    }

    private static class InstallVisitor
    implements GraphNode.DirectedAcyclicGraphVisitor<InstallArtifact> {
        private final QuasiFramework quasiFramework;
        private final InstallLog installLog;

        public InstallVisitor(QuasiFramework quasiFramework, InstallLog installLog) {
            this.quasiFramework = quasiFramework;
            this.installLog = installLog;
        }

        public boolean visit(GraphNode<InstallArtifact> graph) {
            InstallArtifact installArtifact = (InstallArtifact)graph.getValue();
            if (installArtifact instanceof BundleInstallArtifact) {
                PlanDescriptor.Provisioning provisioning = this.getProvisioning(graph);
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                try {
                    BundleManifest bundleManifest = bundleInstallArtifact.getBundleManifest();
                    File location = bundleInstallArtifact.getArtifactFS().getFile();
                    QuasiBundle quasiBundle = this.quasiFramework.install(location.toURI(), bundleManifest);
                    quasiBundle.setProvisioning(provisioning);
                    bundleInstallArtifact.setQuasiBundle(quasiBundle);
                }
                catch (IOException e) {
                    this.installLog.log(bundleInstallArtifact, "failed to read bundle manifest", e.getMessage());
                    throw new RuntimeException("failed to read bundle manifest", e);
                }
                catch (BundleException e) {
                    this.installLog.log(bundleInstallArtifact, "failed to install bundle in side state", e.getMessage());
                    throw new RuntimeException("failed to install bundle in side state", e);
                }
            }
            return true;
        }

        private PlanDescriptor.Provisioning getProvisioning(GraphNode<InstallArtifact> artifactGraphNode) {
            PlanDescriptor.Provisioning provisioning;
            List parents = artifactGraphNode.getParents();
            if (parents.isEmpty()) {
                provisioning = PlanDescriptor.Provisioning.AUTO;
            } else {
                boolean allParentsDisabled = true;
                for (GraphNode parent : parents) {
                    InstallArtifact parentInstallArtifact = (InstallArtifact)parent.getValue();
                    if (parentInstallArtifact instanceof PlanInstallArtifact) {
                        if (((PlanInstallArtifact)parentInstallArtifact).getProvisioning() != PlanDescriptor.Provisioning.AUTO) continue;
                        allParentsDisabled = false;
                        continue;
                    }
                    allParentsDisabled = false;
                }
                provisioning = allParentsDisabled ? PlanDescriptor.Provisioning.DISABLED : PlanDescriptor.Provisioning.AUTO;
            }
            return provisioning;
        }
    }
}

