/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.Args;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@Deprecated
public class Starter {
    public static final String VERTX_OPTIONS_PROP_PREFIX = "vertx.options.";
    public static final String DEPLOYMENT_OPTIONS_PROP_PREFIX = "vertx.deployment.options.";
    public static final String METRICS_OPTIONS_PROP_PREFIX = "vertx.metrics.options.";
    private static final String PATH_SEP = System.getProperty("path.separator");
    private static final Logger log = LoggerFactory.getLogger(Starter.class);
    public static List<String> PROCESS_ARGS;
    protected Vertx vertx;
    protected VertxOptions options;
    protected DeploymentOptions deploymentOptions;

    public static void main(String[] sargs) {
        Args args = new Args(sargs);
        String extraCP = args.map.get("-cp");
        if (extraCP != null) {
            String[] parts = extraCP.split(PATH_SEP);
            URL[] urls = new URL[parts.length];
            for (int p = 0; p < parts.length; ++p) {
                String part = parts[p];
                File file = new File(part);
                try {
                    URL url;
                    urls[p] = url = file.toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }
            URLClassLoader icl = new URLClassLoader(urls, Starter.class.getClassLoader());
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(icl);
            try {
                Class<?> clazz = icl.loadClass(Starter.class.getName());
                Object instance = clazz.newInstance();
                Method run = clazz.getMethod("run", Args.class, String[].class);
                run.invoke(instance, args, sargs);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        } else {
            new Starter().run(args, sargs);
        }
    }

    public static void runCommandLine(String commandLine) {
        new Starter().run(commandLine);
    }

    protected void run(String commandLine) {
        String[] sargs = commandLine.split(" ");
        Args args = new Args(sargs);
        this.run(args, sargs);
    }

    protected void run(String[] sargs) {
        this.run(new Args(sargs), sargs);
    }

    public void run(Args args, String[] sargs) {
        PROCESS_ARGS = Collections.unmodifiableList(Arrays.asList(sargs));
        String main = this.readMainVerticleFromManifest();
        if (main != null) {
            this.runVerticle(main, args);
        } else {
            if (sargs.length > 0) {
                String first = sargs[0];
                if (first.equals("-version")) {
                    log.info(this.getVersion());
                    return;
                }
                if (first.equals("run")) {
                    if (sargs.length < 2) {
                        this.displaySyntax();
                        return;
                    }
                    main = sargs[1];
                    this.runVerticle(main, args);
                    return;
                }
                if (first.equals("-ha")) {
                    this.runBare(args);
                    return;
                }
            }
            this.displaySyntax();
        }
    }

    protected void beforeStartingVertx(VertxOptions options) {
    }

    protected void afterStartingVertx() {
    }

    protected void beforeDeployingVerticle(DeploymentOptions deploymentOptions) {
    }

    protected void handleDeployFailed() {
        this.vertx.close();
    }

    private Vertx startVertx(boolean clustered, boolean ha, Args args) {
        MetricsOptions metricsOptions;
        ServiceLoader<VertxMetricsFactory> factories = ServiceLoader.load(VertxMetricsFactory.class);
        if (factories.iterator().hasNext()) {
            VertxMetricsFactory factory = factories.iterator().next();
            metricsOptions = factory.newOptions();
        } else {
            metricsOptions = new MetricsOptions();
        }
        this.configureFromSystemProperties(metricsOptions, METRICS_OPTIONS_PROP_PREFIX);
        this.options = new VertxOptions().setMetricsOptions(metricsOptions);
        this.configureFromSystemProperties(this.options, VERTX_OPTIONS_PROP_PREFIX);
        if (clustered) {
            String clusterHost;
            log.info("Starting clustering...");
            int clusterPort = args.getInt("-cluster-port");
            if (clusterPort == -1) {
                clusterPort = 0;
            }
            if ((clusterHost = args.map.get("-cluster-host")) == null) {
                clusterHost = this.getDefaultAddress();
                if (clusterHost == null) {
                    log.error("Unable to find a default network interface for clustering. Please specify one using -cluster-host");
                    return null;
                }
                log.info("No cluster-host specified so using address " + clusterHost);
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference result = new AtomicReference();
            this.options.setClusterHost(clusterHost).setClusterPort(clusterPort).setClustered(true);
            if (ha) {
                String haGroup = args.map.get("-hagroup");
                int quorumSize = args.getInt("-quorum");
                this.options.setHAEnabled(true);
                if (haGroup != null) {
                    this.options.setHAGroup(haGroup);
                }
                if (quorumSize != -1) {
                    this.options.setQuorumSize(quorumSize);
                }
            }
            this.beforeStartingVertx(this.options);
            Vertx.clusteredVertx(this.options, ar -> {
                result.set(ar);
                latch.countDown();
            });
            try {
                if (!latch.await(2L, TimeUnit.MINUTES)) {
                    log.error("Timed out in starting clustered Vert.x");
                    return null;
                }
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted in startup");
                return null;
            }
            if (((AsyncResult)result.get()).failed()) {
                log.error("Failed to form cluster");
                ((AsyncResult)result.get()).cause().printStackTrace();
                return null;
            }
            this.vertx = (Vertx)((AsyncResult)result.get()).result();
        } else {
            this.beforeStartingVertx(this.options);
            this.vertx = Vertx.vertx(this.options);
        }
        this.addShutdownHook();
        this.afterStartingVertx();
        return this.vertx;
    }

    private void runBare(Args args) {
        Vertx vertx = this.startVertx(true, true, args);
        if (vertx == null) {
            return;
        }
    }

    private void runVerticle(String main, Args args) {
        JsonObject conf;
        int instances;
        Vertx vertx;
        boolean ha;
        block30: {
            String confArg;
            block29: {
                ha = args.map.get("-ha") != null;
                boolean clustered = args.map.get("-cluster") != null || ha;
                vertx = this.startVertx(clustered, ha, args);
                if (vertx == null) {
                    return;
                }
                String sinstances = args.map.get("-instances");
                if (sinstances != null) {
                    try {
                        instances = Integer.parseInt(sinstances);
                        if (instances != -1 && instances < 1) {
                            log.error("Invalid number of instances");
                            this.displaySyntax();
                            return;
                        }
                        break block29;
                    }
                    catch (NumberFormatException e) {
                        this.displaySyntax();
                        return;
                    }
                }
                instances = 1;
            }
            if ((confArg = args.map.get("-conf")) != null) {
                try (Scanner scanner = new Scanner(new File(confArg)).useDelimiter("\\A");){
                    String sconf = scanner.next();
                    try {
                        conf = new JsonObject(sconf);
                        break block30;
                    }
                    catch (DecodeException e) {
                        log.error("Configuration file " + sconf + " does not contain a valid JSON object");
                        if (scanner != null) {
                            if (var11_13 != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable) {
                                    var11_13.addSuppressed(throwable);
                                }
                            } else {
                                scanner.close();
                            }
                        }
                        return;
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        conf = new JsonObject(confArg);
                        break block30;
                    }
                    catch (DecodeException e2) {
                        log.error("-conf option does not point to a file and is not valid JSON: " + confArg);
                        return;
                    }
                }
            }
            conf = null;
        }
        boolean worker = args.map.get("-worker") != null;
        String message = worker ? "deploying worker verticle" : "deploying verticle";
        this.deploymentOptions = new DeploymentOptions();
        this.configureFromSystemProperties(this.deploymentOptions, DEPLOYMENT_OPTIONS_PROP_PREFIX);
        this.deploymentOptions.setConfig(conf).setWorker(worker).setHa(ha).setInstances(instances);
        this.beforeDeployingVerticle(this.deploymentOptions);
        vertx.deployVerticle(main, this.deploymentOptions, this.createLoggingHandler(message, res -> {
            if (res.failed()) {
                this.handleDeployFailed();
            }
        }));
    }

    private <T> AsyncResultHandler<T> createLoggingHandler(String message, Handler<AsyncResult<T>> completionHandler) {
        return res -> {
            if (res.failed()) {
                Throwable cause = res.cause();
                if (cause instanceof VertxException) {
                    VertxException ve = (VertxException)cause;
                    log.error(ve.getMessage());
                    if (ve.getCause() != null) {
                        log.error(ve.getCause());
                    }
                } else {
                    log.error((Object)("Failed in " + message), cause);
                }
            } else {
                log.info("Succeeded in " + message);
            }
            if (completionHandler != null) {
                completionHandler.handle((AsyncResult)res);
            }
        };
    }

    private void configureFromSystemProperties(Object options, String prefix) {
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            Object arg;
            Method setter;
            block10: {
                String propName = (String)e.nextElement();
                String propVal = props.getProperty(propName);
                if (!propName.startsWith(prefix)) continue;
                String fieldName = propName.substring(prefix.length());
                setter = this.getSetter(fieldName, options.getClass());
                if (setter == null) {
                    log.warn("No such property to configure on options: " + options.getClass().getName() + "." + fieldName);
                    continue;
                }
                Class<?> argType = setter.getParameterTypes()[0];
                try {
                    if (argType.equals(String.class)) {
                        arg = propVal;
                        break block10;
                    }
                    if (argType.equals(Integer.TYPE)) {
                        arg = Integer.valueOf(propVal);
                        break block10;
                    }
                    if (argType.equals(Long.TYPE)) {
                        arg = Long.valueOf(propVal);
                        break block10;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        arg = Boolean.valueOf(propVal);
                        break block10;
                    }
                    log.warn("Invalid type for setter: " + argType);
                }
                catch (IllegalArgumentException e2) {
                    log.warn("Invalid argtype:" + argType + " on options: " + options.getClass().getName() + "." + fieldName);
                }
                continue;
            }
            try {
                setter.invoke(options, arg);
            }
            catch (Exception ex) {
                throw new VertxException("Failed to invoke setter: " + setter, ex);
            }
        }
    }

    private Method getSetter(String fieldName, Class<?> clazz) {
        Method[] meths;
        for (Method meth : meths = clazz.getDeclaredMethods()) {
            if (!("set" + fieldName).toLowerCase().equals(meth.getName().toLowerCase())) continue;
            return meth;
        }
        return null;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CountDownLatch latch = new CountDownLatch(1);
                Starter.this.vertx.close(ar -> {
                    if (!ar.succeeded()) {
                        log.error((Object)"Failure in stopping Vert.x", ar.cause());
                    }
                    latch.countDown();
                });
                try {
                    if (!latch.await(2L, TimeUnit.MINUTES)) {
                        log.error("Timed out waiting to undeploy all");
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private String getDefaultAddress() {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (nets.hasMoreElements()) {
            NetworkInterface netinf = nets.nextElement();
            Enumeration<InetAddress> addresses = netinf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isAnyLocalAddress() || address.isMulticastAddress() || address instanceof Inet6Address) continue;
                return address.getHostAddress();
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String getVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readMainVerticleFromManifest() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream stream = null;
                try {
                    String theMainVerticle;
                    stream = resources.nextElement().openStream();
                    Manifest manifest = new Manifest(stream);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass = attributes.getValue("Main-Class");
                    if (!Starter.class.getName().equals(mainClass) || (theMainVerticle = attributes.getValue("Main-Verticle")) == null) continue;
                    String string = theMainVerticle;
                    return string;
                }
                finally {
                    this.closeQuietly(stream);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void closeQuietly(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void displaySyntax() {
        String usage = "    vertx run <main> [-options]                                                \n        runs a verticle called <main> in its own instance of vert.x.         \n\n    valid options are:                                                         \n        -conf <config>         Specifies configuration that should be provided \n                               to the verticle. <config> should reference      \n                               either a text file containing a valid JSON      \n                               object which represents the configuration OR    \n                               be a JSON string.                               \n        -instances <instances> specifies how many instances of the verticle    \n                               will be deployed. Defaults to 1                 \n        -worker                if specified then the verticle is a worker      \n                               verticle.                                       \n        -cp <classpath>        provide an extra classpath to be used for the   \n                               verticle deployment.                            \n        -cluster               if specified then the vert.x instance will form \n                               a cluster with any other vert.x instances on    \n                               the network.                                    \n        -cluster-port          port to use for cluster communication.          \n                               Default is 0 which means choose a spare         \n                               random port.                                    \n        -cluster-host          host to bind to for cluster communication.      \n                               If this is not specified vert.x will attempt    \n                               to choose one from the available interfaces.    \n        -ha                    if specified the verticle will be deployed as a \n                               high availability (HA) deployment.              \n                               This means it can fail over to any other nodes  \n                               in the cluster started with the same HA group   \n        -quorum                used in conjunction with -ha this specifies the \n                               minimum number of nodes in the cluster for any  \n                               HA deploymentIDs to be active. Defaults to 0    \n        -hagroup               used in conjunction with -ha this specifies the \n                               HA group this node will join. There can be      \n                               multiple HA groups in a cluster. Nodes will only\n                               failover to other nodes in the same group.      \n                               Defaults to __DEFAULT__                       \n\n    vertx -version                                                             \n        displays the version";
        log.info(usage);
    }
}

