/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.wan;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.wan.WanNoDelayReplication;
import com.hazelcast.impl.wan.WanReplication;
import com.hazelcast.impl.wan.WanReplicationEndpoint;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Serializer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class WanReplicationService {
    final Node node;
    final Map<String, WanReplication> mapWanReplications = new ConcurrentHashMap<String, WanReplication>(2);
    private final ILogger logger;

    public WanReplicationService(Node node) {
        this.node = node;
        this.logger = node.getLogger(WanReplicationService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WanReplication getWanReplication(String name) {
        WanReplication wr = this.mapWanReplications.get(name);
        if (wr != null) {
            return wr;
        }
        WanReplicationService wanReplicationService = this;
        synchronized (wanReplicationService) {
            wr = this.mapWanReplications.get(name);
            if (wr != null) {
                return wr;
            }
            WanReplicationConfig wanReplicationConfig = this.node.getConfig().getWanReplicationConfig(name);
            if (wanReplicationConfig == null) {
                return null;
            }
            List<WanTargetClusterConfig> targets = wanReplicationConfig.getTargetClusterConfigs();
            WanReplicationEndpoint[] targetClusters = new WanReplicationEndpoint[targets.size()];
            int count = 0;
            for (WanTargetClusterConfig targetClusterConfig : targets) {
                WanReplicationEndpoint target = null;
                if (targetClusterConfig.getReplicationImpl() != null) {
                    try {
                        target = (WanReplicationEndpoint)Serializer.loadClass(targetClusterConfig.getReplicationImpl()).newInstance();
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    target = new WanNoDelayReplication();
                }
                String groupName = targetClusterConfig.getGroupName();
                String password = targetClusterConfig.getGroupPassword();
                String[] addresses = new String[targetClusterConfig.getEndpoints().size()];
                targetClusterConfig.getEndpoints().toArray(addresses);
                target.init(this.node, groupName, password, addresses);
                targetClusters[count++] = target;
            }
            wr = new WanReplication(name, targetClusters);
            this.mapWanReplications.put(name, wr);
            return wr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WanReplicationService wanReplicationService = this;
        synchronized (wanReplicationService) {
            for (WanReplication wanReplication : this.mapWanReplications.values()) {
                WanReplicationEndpoint[] wanReplicationEndpoints = wanReplication.getEndpoints();
                if (wanReplicationEndpoints == null) continue;
                for (WanReplicationEndpoint wanReplicationEndpoint : wanReplicationEndpoints) {
                    if (wanReplicationEndpoint == null) continue;
                    wanReplicationEndpoint.shutdown();
                }
            }
        }
    }
}

