/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.logging.ILogger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;

public class VersionMismatchLogRequest
implements ConsoleRequest {
    private String manCenterVersion;

    public VersionMismatchLogRequest(String manCenterVersion) {
        this.manCenterVersion = manCenterVersion;
    }

    public VersionMismatchLogRequest() {
    }

    public int getType() {
        return 17;
    }

    public Object readResponse(DataInput in) throws IOException {
        return "SUCCESS";
    }

    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        ILogger logger = mcs.getHazelcastInstance().node.getLogger(VersionMismatchLogRequest.class.getName());
        mcs.setVersionMismatch(true);
        String hazelcastVersion = mcs.getHazelcastInstance().node.initializer.getVersion();
        logger.log(Level.SEVERE, "Version Mismatch\n\tmanagement center version : " + this.manCenterVersion + "\n" + "\thazelcast version : " + hazelcastVersion);
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.manCenterVersion);
    }

    public void readData(DataInput in) throws IOException {
        this.manCenterVersion = in.readUTF();
    }
}

