/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.examples.TestApp;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConsoleCommandHandler {
    private final ConsoleApp app;
    private final Lock lock = new ReentrantLock();
    private final StringBuilder buffer = new StringBuilder();

    public ConsoleCommandHandler(HazelcastInstance instance) {
        this.app = new ConsoleApp(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleCommand(String command) throws InterruptedException {
        if ("exit".equals(command) || "quit".equals(command)) {
            return "'" + command + "' is not allowed!";
        }
        if (this.lock.tryLock(1L, TimeUnit.SECONDS)) {
            try {
                String string = this.doHandleCommand(command);
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
        return "'" + command + "' execution is timed out!";
    }

    String doHandleCommand(String command) {
        this.app.handleCommand(command);
        String output = this.buffer.toString();
        this.buffer.setLength(0);
        return output;
    }

    private class ConsoleApp
    extends TestApp {
        public ConsoleApp(HazelcastInstance hazelcast) {
            super(hazelcast);
        }

        protected void handleCommand(String command) {
            super.handleCommand(command);
        }

        protected void handleAddListener(String[] args) {
            this.println("Listener commands are not allowed!");
        }

        protected void handleRemoveListener(String[] args) {
            this.println("Listener commands are not allowed!");
        }

        public void println(Object obj) {
            this.print(obj);
            this.print(Character.valueOf('\n'));
        }

        public void print(Object obj) {
            ConsoleCommandHandler.this.buffer.append(String.valueOf(obj));
        }
    }
}

