/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;

class ByteArrayMessage
extends BaseMessage<byte[]> {
    ByteArrayMessage(boolean send, String address, byte[] body) {
        super(send, address, body);
    }

    public ByteArrayMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            int buffLength = readBuff.getInt(++pos);
            this.body = readBuff.getBytes(pos += 4, pos + buffLength);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendInt(((byte[])this.body).length);
            buff.appendBytes((byte[])this.body);
        }
    }

    @Override
    protected int getBodyLength() {
        return this.body == null ? 1 : 5 + ((byte[])this.body).length;
    }

    @Override
    protected Message<byte[]> copy() {
        byte[] bod;
        if (this.body != null) {
            bod = new byte[((byte[])this.body).length];
            System.arraycopy(this.body, 0, bod, 0, bod.length);
        } else {
            bod = null;
        }
        ByteArrayMessage copied = new ByteArrayMessage(this.send, this.address, bod);
        copied.replyAddress = this.replyAddress;
        copied.bus = this.bus;
        copied.sender = this.sender;
        return copied;
    }

    @Override
    protected byte type() {
        return 3;
    }
}

