/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.StatColumn;

public enum TestcaseMetric implements IMetricEnum
{
    LINES_OF_CODE("Lines of code", "Number of lines in the testcase body"),
    CYCLOMATIC_COMPLEXITY("Cyclomatic complexity", "Cyclomatic (or McCabe) complexity"),
    NESTING("Nesting", "Maximal number of nested blocks in a testcase"),
    NUMBER_OF_PARAMETERS("Number of parameters", "Number of parameters in the testcase declaration", EnumSet.of(StatColumn.MAX, StatColumn.MEAN, StatColumn.DEV)),
    IN_ENVY("External feature envy", "Number of references to entities inside the module of this testcase"),
    OUT_ENVY("Internal feature envy", "Number of references to entities outside the module of this testcase");

    public static final String GROUP_NAME = "Testcase";
    private String displayName;
    private String hint;
    private Set<StatColumn> requestedStatistics;
    private boolean isInteger;

    private TestcaseMetric(String name, String hint) {
        this(name, hint, EnumSet.allOf(StatColumn.class), true);
    }

    private TestcaseMetric(String name, String hint, Set<StatColumn> requestedStatistics) {
        this(name, hint, requestedStatistics, true);
    }

    private TestcaseMetric(String name, String hint, Set<StatColumn> requestedStatistics, boolean isInteger) {
        this.displayName = name;
        this.hint = hint;
        this.requestedStatistics = requestedStatistics;
        this.isInteger = isInteger;
    }

    @Override
    public String id() {
        return "Testcase." + this.name();
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public Set<StatColumn> requestedStatistics() {
        return this.requestedStatistics;
    }

    @Override
    public boolean isInteger() {
        return this.isInteger;
    }

    @Override
    public String groupName() {
        return GROUP_NAME;
    }
}

