/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.Log_Statement;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.logging.ContextFinder;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.context.Context;

class ChangeCreator {
    private final ContextLoggingRefactoring.Settings settings;
    private final IFile file;
    private final ITextSelection textSelection;
    private TextFileChange change;

    ChangeCreator(IFile file, ContextLoggingRefactoring.Settings settings) {
        this.file = file;
        this.textSelection = null;
        this.settings = settings;
    }

    ChangeCreator(IFile file, ITextSelection textSelection, ContextLoggingRefactoring.Settings settings) {
        this.file = file;
        this.textSelection = textSelection;
        this.settings = settings;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.file == null) {
            return;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)this.file.getProject());
        Module module = sourceParser.containedModule(this.file);
        if (module == null) {
            return;
        }
        if (this.textSelection != null) {
            this.performOnSelectionOnly(module);
        } else {
            this.performOnWholeModule(module);
        }
    }

    private void performOnWholeModule(Module module) {
        ContextFinder vis = new ContextFinder(this.settings);
        module.accept((ASTVisitor)vis);
        Map<Log_Statement, Context> res = vis.getResult();
        MultiTextEdit rootEdit = new MultiTextEdit();
        for (Map.Entry<Log_Statement, Context> e : res.entrySet()) {
            TextEdit edit = this.createTextEdit(e.getKey(), e.getValue());
            if (edit == null) continue;
            rootEdit.addChild(edit);
        }
        if (rootEdit.hasChildren()) {
            this.change = new TextFileChange("Context logging", this.file);
            this.change.setEdit((TextEdit)rootEdit);
        }
    }

    private void performOnSelectionOnly(Module module) {
        Location selLoc = new Location((IResource)this.file, this.textSelection.getStartLine(), this.textSelection.getOffset(), this.textSelection.getOffset() + this.textSelection.getLength());
        SelectionVisitor vis = new SelectionVisitor(selLoc);
        module.accept((ASTVisitor)vis);
        Map<Log_Statement, Context> res = vis.getResult();
        MultiTextEdit rootEdit = new MultiTextEdit();
        for (Map.Entry<Log_Statement, Context> e : res.entrySet()) {
            TextEdit edit = this.createTextEdit(e.getKey(), e.getValue());
            if (edit == null) continue;
            rootEdit.addChild(edit);
        }
        if (rootEdit.hasChildren()) {
            this.change = new TextFileChange("Context logging", this.file);
            this.change.setEdit((TextEdit)rootEdit);
        }
    }

    private TextEdit createTextEdit(Log_Statement toEdit, Context toAdd) {
        Set<String> varsAlreadyPresent;
        Context bottomContext;
        LogInsertLocationFinder vis = new LogInsertLocationFinder();
        toEdit.accept((ASTVisitor)vis);
        int insertOffset = vis.calculateEndOffset();
        if (insertOffset < 0) {
            ErrorReporter.logError((String)"ChangeCreator.createTextEdit(): Warning! No arguments in log statement! ");
            insertOffset = toEdit.getLocation().getEndOffset() - 1;
        }
        if ((bottomContext = toAdd.getBottom()).getNode() instanceof Log_Statement) {
            LoggedVariableFinder vis2 = new LoggedVariableFinder();
            Log_Statement logst = (Log_Statement)bottomContext.getNode();
            logst.accept((ASTVisitor)vis2);
            varsAlreadyPresent = vis2.getVarsAlreadyPresent();
        } else {
            varsAlreadyPresent = new HashSet<String>();
        }
        toAdd.process();
        List<String> contextInfos = toAdd.createLogParts(varsAlreadyPresent);
        int len = Math.min(contextInfos.size(), toAdd.getVarCountLimitOption());
        if (len == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(contextInfos.get(i));
        }
        return new InsertEdit(insertOffset, sb.toString());
    }

    private static class LoggedVariableFinder
    extends ASTVisitor {
        private final Set<String> varsAlreadyPresent = new HashSet<String>();

        private LoggedVariableFinder() {
        }

        Set<String> getVarsAlreadyPresent() {
            return this.varsAlreadyPresent;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                this.varsAlreadyPresent.add(((Reference)node).getDisplayName());
                return 1;
            }
            return 3;
        }
    }

    private static class LogInsertLocationFinder
    extends ASTVisitor {
        private final List<LogArgument> args = new ArrayList<LogArgument>();

        private LogInsertLocationFinder() {
        }

        private int calculateEndOffset() {
            int endOffset = -1;
            for (LogArgument la : this.args) {
                if (la.getLocation().getEndOffset() <= endOffset) continue;
                endOffset = la.getLocation().getEndOffset();
            }
            return endOffset;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof LogArgument) {
                this.args.add((LogArgument)node);
                return 1;
            }
            return 3;
        }
    }

    private class SelectionVisitor
    extends ContextFinder {
        private final Location selection;

        SelectionVisitor(Location selection) {
            super(ChangeCreator.this.settings);
            this.selection = selection;
        }

        @Override
        public int visit(IVisitableNode node) {
            if (node instanceof ILocateableNode) {
                Location loc = ((ILocateableNode)node).getLocation();
                if (loc.getFile() == null) {
                    return 1;
                }
                if (!this.isOverlapping(loc, this.selection)) {
                    return 1;
                }
            }
            return super.visit(node);
        }

        private boolean isOverlapping(Location l1, Location l2) {
            if (!l1.getFile().equals((Object)l2.getFile())) {
                return false;
            }
            return l1.getOffset() <= l2.getEndOffset() && l1.getEndOffset() >= l2.getOffset();
        }
    }
}

