/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.text.table;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.models.TimeInterval;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.MSCFilterDialog;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.ui.progress.IProgressConstants;

class FilterAction
extends Action {
    private final TextTableView textTableView;
    private volatile boolean isFilterRunning = false;

    public FilterAction(TextTableView textTableView) {
        super("Filter", ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/filter2.gif")));
        this.textTableView = textTableView;
        this.setId("filterTextTable");
    }

    public void run() {
        MSCFilterDialog dialog;
        if (this.isFilterRunning) {
            MessageBox msgBox = new MessageBox(this.textTableView.getSite().getShell());
            msgBox.setMessage("The filter is already running!");
            msgBox.setText("Filter");
            msgBox.open();
            return;
        }
        this.isFilterRunning = true;
        if (this.textTableView.getFilterPattern() == null) {
            this.textTableView.setFilterPattern(new FilterPattern(new TimeInterval("", "", this.textTableView.getLogFileMetaData().getTimeStampFormat())));
            TreeMap<String, Boolean> eventsToFilter = new TreeMap<String, Boolean>();
            for (Map.Entry<String, String[]> entry : Constants.EVENT_CATEGORIES.entrySet()) {
                eventsToFilter.put(entry.getKey(), true);
            }
            this.textTableView.getFilterPattern().setEventsToFilter(eventsToFilter, true, false);
        }
        if ((dialog = new MSCFilterDialog(this.textTableView.getSite().getShell(), this.textTableView.getFilterPattern())).open() == 0 && dialog.getChanged() && !dialog.getFilterPattern().equals(this.textTableView.getFilterPattern())) {
            final FilterPattern tmpFilterPattern = dialog.getFilterPattern();
            WorkspaceJob op = new WorkspaceJob("Filtering"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        FilterAction.this.textTableView.getFilteredLogReader().runFilter(tmpFilterPattern, monitor);
                    }
                    catch (IOException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                        TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.6") + e.getMessage()));
                        monitor.setCanceled(true);
                    }
                    catch (ParseException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                        TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.7") + e.getMessage()));
                        monitor.setCanceled(true);
                    }
                    if (monitor.isCanceled()) {
                        monitor.done();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FilterAction.this.isFilterRunning = false;
                                FilterAction.this.textTableView.getTable().setEnabled(true);
                            }
                        });
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    monitor.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FilterAction.this.textTableView.setFilterPattern(tmpFilterPattern);
                            FilterAction.this.textTableView.refreshTable();
                            FilterAction.this.isFilterRunning = false;
                            FilterAction.this.textTableView.getTable().setEnabled(true);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(false);
            op.setUser(true);
            op.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)Activator.getImageDescriptor("titan.gif"));
            this.textTableView.getTable().setEnabled(false);
            op.schedule();
        } else {
            this.isFilterRunning = false;
        }
    }
}

