/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.actions;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.SourceInformation;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ValueReader;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.MSCView;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.titan.log.viewer.views.msc.model.IEventObject;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.DelayedSelectable;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.DelayedSelector;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.FileFinder;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OpenSourceAction
extends SelectionProviderAction
implements DelayedSelectable {
    private MSCView mscView;
    private Integer selectedLine;
    private final boolean silent;
    private final boolean forceEditorOpening;
    private static String lastFilename = null;
    private static URI lastPath = null;
    private ISelection delayedSelection = null;
    private DelayedSelector runnable = new DelayedSelector(this);

    public OpenSourceAction(MSCView view, boolean silent, boolean forceEditorOpening) {
        super((ISelectionProvider)view.getMSCWidget(), "Open Source");
        this.mscView = view;
        this.silent = silent;
        this.forceEditorOpening = forceEditorOpening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        this.runnable.setShouldRun(false);
        Object object = this.runnable.getLock();
        synchronized (object) {
            this.runnable.getLock().notify();
        }
        this.runnable = null;
        this.mscView = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedRun(ISelection selection) {
        this.setDelayedSelection(selection);
        if (!this.runnable.isAlive()) {
            this.runnable.setPriority(1);
            this.runnable.setDaemon(true);
            this.runnable.start();
        }
        Object object = this.runnable.getLock();
        synchronized (object) {
            this.runnable.getLock().notify();
        }
    }

    @Override
    public void run() {
        IFile targetFile;
        if (this.selectedLineInvalid()) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return;
        }
        LogFileMetaData logFileMetaData = this.mscView.getLogFileMetaData();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(logFileMetaData.getProjectName());
        IFile logFile = project.getFile(logFileMetaData.getProjectRelativePath().substring(logFileMetaData.getProjectName().length() + 1));
        if (!logFile.exists()) {
            IViewReference[] viewReferences = activePage.getViewReferences();
            ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
            TitanLogExceptionHandler.handleException(new UserException(Messages.getString("OpenValueViewAction.1")));
            return;
        }
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        ExecutionModel model = this.mscView.getModel();
        String testCase = model.getTestCase().getTestCaseName();
        int actualLine = this.selectedLine;
        SourceInformation sourceInformation = null;
        while (sourceInformation == null && actualLine > 2) {
            LogRecord logrecord;
            IEventObject ieventObject = model.getEvent(actualLine - 2);
            if (!(ieventObject instanceof EventObject)) {
                --actualLine;
                continue;
            }
            EventObject eventObject = (EventObject)ieventObject;
            if (testCase == null || eventObject.getRecordNumber() == 0) {
                return;
            }
            try {
                logrecord = ValueReader.getInstance().readLogRecordFromLogFileCached(this.mscView.getLogFileMetaData().getFilePath(), eventObject);
            }
            catch (IOException valueException) {
                ErrorReporter.logExceptionStackTrace((Exception)valueException);
                ErrorReporter.INTERNAL_ERROR((String)Messages.getString("OpenValueViewAction.3"));
                return;
            }
            catch (ParseException valueException) {
                ErrorReporter.logExceptionStackTrace((Exception)valueException);
                ErrorReporter.INTERNAL_ERROR((String)Messages.getString("OpenValueViewAction.3"));
                return;
            }
            try {
                sourceInformation = SourceInformation.createInstance(logrecord.getSourceInformation());
            }
            catch (SourceInformation.InvalidSourceInformationException valueException) {
                // empty catch block
            }
            --actualLine;
        }
        if (sourceInformation == null) {
            if (!this.silent) {
                String setting = logFileMetaData.getOptionsSettings("SourceInfoFormat");
                if (setting == null) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error opening source", (String)"This log file is not generated with source location information inserted. And it really does not seem to contain source location information");
                } else {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error opening source", (String)"This log record does not seem to contain source location information");
                }
            }
            return;
        }
        if (sourceInformation.getSourceFileName() == null) {
            this.mscView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The name of the target file could not be extracted");
            return;
        }
        String fileName = sourceInformation.getSourceFileName();
        if (lastFilename != null && lastFilename.equals(fileName) && lastPath != null) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(lastPath);
            if (files.length == 0) {
                this.mscView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The file `" + lastFilename + "' could not be found");
                OpenSourceAction.setLastFilename(null);
                return;
            }
            targetFile = files[0];
        } else {
            targetFile = OpenSourceAction.findSourceFile(project, fileName);
            if (targetFile == null) {
                this.mscView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The file `" + fileName + "' could not be found");
                return;
            }
            OpenSourceAction.setLastFilename(fileName);
            OpenSourceAction.setLastPath(targetFile.getLocationURI());
        }
        OpenSourceAction.openEditor(targetFile, sourceInformation.getLineNumber(), (IViewPart)this.mscView, this.forceEditorOpening);
    }

    private boolean selectedLineInvalid() {
        return this.selectedLine == null || this.selectedLine < 3 || this.mscView == null || this.mscView.getModel() == null || this.selectedLine - 2 >= this.mscView.getModel().getNumberOfEvents();
    }

    @Override
    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectedLine = (Integer)selection.getFirstElement();
    }

    public static void openEditor(IFile targetFile, int lineNumber, IViewPart logView, boolean forceEditorOpening) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(targetFile.getName());
        if (desc == null && (desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor")) == null) {
            logView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The editor could not be found");
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return;
        }
        try {
            FileEditorInput editorInput = new FileEditorInput(targetFile);
            IEditorPart editorPart = activePage.findEditor((IEditorInput)editorInput);
            if (editorPart == null) {
                if (!forceEditorOpening) {
                    return;
                }
                editorPart = activePage.openEditor((IEditorInput)editorInput, desc.getId());
            }
            if (!(editorPart instanceof AbstractTextEditor)) {
                logView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("Could not jump to the target position");
                return;
            }
            AbstractTextEditor textEditor = (AbstractTextEditor)editorPart;
            IDocument targetDocument = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            if (targetDocument == null) {
                logView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The target document does not exist");
                return;
            }
            if (lineNumber >= targetDocument.getNumberOfLines()) {
                logView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("The position is after the last line in the source code.");
                return;
            }
            IRegion lineRegion = targetDocument.getLineInformation(lineNumber - 1);
            activePage.bringToTop((IWorkbenchPart)textEditor);
            textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public static IFile findSourceFile(IProject project, String fileName) {
        return OpenSourceAction.findSourceFile(project, fileName, new ArrayList<IProject>());
    }

    private static IFile findSourceFile(IProject project, String fileName, List<IProject> chain) {
        try {
            IProject[] referencedProjects;
            IResource[] members;
            FileFinder fileFinder = new FileFinder(fileName);
            for (IResource resource : members = project.members()) {
                if (resource.isDerived(512)) continue;
                resource.accept((IResourceVisitor)fileFinder);
            }
            chain.add(project);
            if (fileFinder.getTargetFile() != null) {
                return fileFinder.getTargetFile();
            }
            for (IProject referencedProject : referencedProjects = project.getReferencedProjects()) {
                IFile file;
                if (chain.contains(referencedProject) || (file = OpenSourceAction.findSourceFile(referencedProject, fileName)) == null) continue;
                return file;
            }
            return null;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
    }

    @Override
    public ISelection getDelayedSelection() {
        return this.delayedSelection;
    }

    @Override
    public void setDelayedSelection(ISelection delayedSelection) {
        this.delayedSelection = delayedSelection;
    }

    private static synchronized void setLastFilename(String lastFilename) {
        OpenSourceAction.lastFilename = lastFilename;
    }

    public static synchronized void setLastPath(URI lastPath) {
        OpenSourceAction.lastPath = lastPath;
    }
}

