/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.actions;

import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.DelayedSelectable;

class DelayedSelector
extends Thread {
    private final DelayedSelectable selectable;
    private volatile boolean shouldRun = true;
    private final Object lock = new Object();

    public DelayedSelector(DelayedSelectable selectable) {
        this.selectable = selectable;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.shouldRun) {
            if (this.selectable.getDelayedSelection() == null) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            }
            this.selectable.selectionChanged(this.selectable.getDelayedSelection());
            this.selectable.setDelayedSelection(null);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DelayedSelector.this.selectable.run();
                }
            });
            try {
                DelayedSelector.sleep(100L);
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
    }
}

