/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.model;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Vector;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.parsers.Parser;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.IEventObject;
import org.eclipse.titan.log.viewer.views.msc.model.TestComponent;

public class ExecutionModel
extends Observable {
    private FilterPattern filterPattern;
    private Map<String, Integer> ignoredComponents;
    private Map<String, Integer> ignoredSignals;
    private Map<String, Integer> ignoredFunctions;
    private final Map<String, TestComponent> components = new HashMap<String, TestComponent>();
    private TestCase containedTestCase;
    private final Map<String, String> componentNames = new HashMap<String, String>();
    private int[] setverdict;
    private String sutName;
    private final Parser parser;
    private final List<EventObject> lifeLineInfo;

    public ExecutionModel(Parser parser) {
        this.parser = parser;
        this.lifeLineInfo = new Vector<EventObject>();
    }

    public TestCase getTestCase() {
        return this.containedTestCase;
    }

    public Map<String, TestComponent> getComponents() {
        return this.components;
    }

    public IEventObject getEvent(int index) {
        List<IEventObject> result = this.getEvents(index, index);
        return result.get(3);
    }

    public int getRecordsPosition(int recordNumber) {
        if (recordNumber < 0 || recordNumber > this.containedTestCase.getEndRecordNumber()) {
            return -1;
        }
        int min = 0;
        int max = this.getNumberOfEvents() - 1;
        int mid = (min + max) / 2;
        while (min <= max) {
            IEventObject element = this.getEvent(mid);
            if (recordNumber > element.getRecordNumber()) {
                min = mid + 1;
            } else if (recordNumber < element.getRecordNumber()) {
                max = mid - 1;
            } else {
                return mid;
            }
            mid = (min + max) / 2;
        }
        return -1;
    }

    public boolean getMTCTerminated() {
        return this.parser.getMTCTerminated();
    }

    public void addLifeLineInfo(EventObject event) {
        this.lifeLineInfo.add(event);
    }

    public List<EventObject> getLifelineInformation() {
        return this.lifeLineInfo;
    }

    public List<IEventObject> getEvents(int startIndex, int endIndex) {
        int end = endIndex > this.getNumberOfEvents() ? this.getNumberOfEvents() : endIndex;
        try {
            return new ArrayList<IEventObject>(this.parser.parseRegion(startIndex, end, null));
        }
        catch (ParseException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new ArrayList<IEventObject>();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new ArrayList<IEventObject>();
        }
    }

    public int getNumberOfEvents() {
        if (this.parser == null) {
            return 0;
        }
        return this.parser.getNumberOfEvents();
    }

    public FilterPattern getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(FilterPattern filterPattern) {
        this.filterPattern = filterPattern;
    }

    private String getAlternativeComponent(String name) {
        if (this.ignoredComponents == null) {
            return null;
        }
        if (name.contentEquals(this.sutName) || name.contentEquals("Main Test Component")) {
            return null;
        }
        Set<String> filteredComp = this.ignoredComponents.keySet();
        for (String currComp : filteredComp) {
            int filterType = this.ignoredComponents.get(currComp);
            switch (filterType) {
                case 0: {
                    if (!name.contentEquals(currComp)) break;
                    return "system";
                }
                case 1: {
                    if (!name.startsWith(currComp)) break;
                    return "system";
                }
                case 2: {
                    if (!name.endsWith(currComp)) break;
                    return "system";
                }
                case 3: {
                    if (!name.contains(currComp)) break;
                    return "system";
                }
            }
        }
        return null;
    }

    public boolean isComponentIgnored(String reference) {
        if (this.filterPattern != null) {
            return false;
        }
        if (this.components == null) {
            return false;
        }
        TestComponent component = this.components.get(reference);
        return component != null && component.getAlternative() != null;
    }

    public boolean isSignalIgnored(String signal) {
        if (this.filterPattern != null) {
            return false;
        }
        if (this.ignoredSignals == null) {
            return false;
        }
        String tempSignal = signal.trim();
        Set<String> filteredSignal = this.ignoredSignals.keySet();
        for (String currSignal : filteredSignal) {
            int filterType = this.ignoredSignals.get(currSignal);
            switch (filterType) {
                case 0: {
                    if (!tempSignal.contentEquals(currSignal)) break;
                    return true;
                }
                case 1: {
                    if (!tempSignal.startsWith(currSignal)) break;
                    return true;
                }
                case 2: {
                    if (!tempSignal.endsWith(currSignal)) break;
                    return true;
                }
                case 3: {
                    if (!tempSignal.contains(currSignal)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEventIgnored(String event) {
        return this.filterPattern != null && this.filterPattern.isEventIgnored(event);
    }

    public boolean isFunctionIgnored(String function) {
        if (this.filterPattern != null) {
            return false;
        }
        if (this.ignoredFunctions == null) {
            return false;
        }
        Set<String> filteredFunc = this.ignoredFunctions.keySet();
        for (String currFunction : filteredFunc) {
            int filterType = this.ignoredFunctions.get(currFunction);
            switch (filterType) {
                case 0: {
                    if (!function.contentEquals(currFunction)) break;
                    return true;
                }
                case 1: {
                    if (!function.startsWith(currFunction)) break;
                    return true;
                }
                case 2: {
                    if (!function.endsWith(currFunction)) break;
                    return true;
                }
                case 3: {
                    if (!function.contains(currFunction)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void addComponent(EventObject event) {
        String reference = event.getReference();
        String name = event.getName();
        if (name.length() == 0) {
            name = reference;
        }
        String alternative = this.getAlternativeComponent(name);
        this.components.put(reference, new TestComponent(event, alternative));
        String componentName = event.getName();
        if (componentName != null && !componentName.trim().isEmpty()) {
            this.componentNames.put(event.getName(), reference);
        }
    }

    public void addPortMapping(String sourceRef, String sourcePort, String targetRef, String targetPort) {
        if (this.components != null) {
            TestComponent targetComponent;
            TestComponent sourceComponent = this.components.get(sourceRef);
            if (sourceComponent != null) {
                sourceComponent.addFromEntry(targetPort, targetRef);
            }
            if ((targetComponent = this.components.get(targetRef)) != null) {
                targetComponent.addFromEntry(sourcePort, sourceRef);
            }
        }
    }

    public void notifyChange() {
        this.setChanged();
        this.notifyObservers();
    }

    public TestCase getContainedTestCase() {
        return this.containedTestCase;
    }

    public void setContainedTestCase(TestCase containedTestCase) {
        this.containedTestCase = containedTestCase;
    }

    public void addIgnoredComponent(Map<String, Integer> ignoredComponents) {
        this.ignoredComponents = ignoredComponents;
    }

    public void addIgnoredSignals(Map<String, Integer> ignoredSignals) {
        this.ignoredSignals = ignoredSignals;
    }

    public void addIgnoredFunctions(Map<String, Integer> ignoredFunctions) {
        this.ignoredFunctions = ignoredFunctions;
    }

    public boolean componentNameExists(String componentName) {
        return this.componentNames != null && this.componentNames.containsKey(componentName);
    }

    public String getComponentRefFromName(String componentName) {
        if (this.componentNames == null) {
            return null;
        }
        return this.componentNames.get(componentName);
    }

    public int[] getSetverdict() {
        return this.setverdict;
    }

    public void setSetverdict(int[] setverdict) {
        this.setverdict = setverdict;
    }

    public void setSutName(String sutName) {
        this.sutName = sutName;
    }

    public boolean setDecipheringRuleset(String name) {
        return this.parser.setDecipheringRuleset(name);
    }
}

