/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.ILogViewerView;
import org.eclipse.titan.log.viewer.views.details.DetailData;
import org.eclipse.titan.log.viewer.views.details.TextViewComposite;
import org.eclipse.titan.log.viewer.views.details.TreeViewComposite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class DetailsView
extends ViewPart
implements ILogViewerView {
    private DetailData currentEventObject;
    private URI fullPath;
    private String projectName;
    private String testCaseName;
    private IMemento memento;
    private static ImageDescriptor imgTextView = Activator.getDefault().getCachedImageDescriptor("icons/text_view.gif");
    private static ImageDescriptor imgTreeView = Activator.getDefault().getCachedImageDescriptor("icons/tree_view.gif");
    private Composite stackComposite;
    private final FillLayout fillLayout = new FillLayout();
    private final StackLayout layout = new StackLayout();
    private TreeViewComposite treeView;
    private TextViewComposite textView;
    private boolean useFormatting = false;
    private boolean treeVisible;
    private boolean viewModeChanged = false;
    private IAction setTreeModeAction;
    private IAction setTextModeAction;
    private LogFileMetaData logFileMetaData;

    public void createPartControl(Composite parent) {
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createToolbar();
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setBackground(Display.getCurrent().getSystemColor(7));
        this.stackComposite.setLayout((Layout)this.layout);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.layout.topControl = this.getComposite();
        this.restoreState();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.currentEventObject == null) {
            return;
        }
        try {
            IMemento childMemento = memento.createChild("selection");
            IMemento mementoEventObject = childMemento.createChild("eventObject");
            mementoEventObject.putString("name", this.currentEventObject.getName());
            mementoEventObject.putString("port", this.currentEventObject.getPort());
            mementoEventObject.putString("line", this.currentEventObject.getLine());
            mementoEventObject.putString("projectName", this.logFileMetaData.getProjectName());
            mementoEventObject.putString("fullPath", this.logFileMetaData.getFilePath().toString());
            mementoEventObject.putString("testCaseName", this.currentEventObject.getTestCaseName());
            mementoEventObject.putString("eventType", this.currentEventObject.getEventType());
            mementoEventObject.putString("sourceInfo", this.currentEventObject.getSourceInfo());
            mementoEventObject.putInteger("isSilentEvent", this.useFormatting ? 1 : 0);
            Path filePath = new Path(this.logFileMetaData.getProjectRelativePath());
            IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            if (logFile != null && logFile.exists()) {
                File aLogFile = logFile.getLocation().toFile();
                mementoEventObject.putString("propertyFile", LogFileCacheHandler.getPropertyFileForLogFile(logFile).getAbsolutePath());
                mementoEventObject.putString("fileSize", String.valueOf(aLogFile.length()));
                mementoEventObject.putString("fileModification", String.valueOf(aLogFile.lastModified()));
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    public URI getFullPath() {
        return this.fullPath;
    }

    public void setData(DetailData newEventObject, boolean useFormatting) {
        if (newEventObject != null) {
            this.currentEventObject = newEventObject;
            this.fullPath = this.logFileMetaData.getFilePath();
            this.projectName = this.logFileMetaData.getProjectName();
            this.testCaseName = newEventObject.getTestCaseName();
        } else {
            this.currentEventObject = null;
        }
        this.useFormatting = useFormatting;
        this.textView = this.getTextView();
        if (this.useFormatting) {
            this.textView.setUseFormatting(false);
            this.setTextModeAction.run();
            this.setTreeModeAction.setEnabled(false);
        } else {
            this.textView.setUseFormatting(true);
            if (this.isTreeVisibleNow()) {
                this.setTreeModeAction.run();
            } else {
                this.setTextModeAction.run();
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public void dispose() {
        if (this.treeView != null && !this.treeView.isDisposed()) {
            this.treeView.dispose();
        }
        if (this.textView != null && !this.textView.isDisposed()) {
            this.textView.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
    }

    private void createToolbar() {
        this.setTreeModeAction = new Action(){

            public void run() {
                DetailsView.this.treeView = DetailsView.this.getTreeView();
                ((DetailsView)DetailsView.this).layout.topControl = DetailsView.this.treeView;
                DetailsView.this.stackComposite.layout();
                DetailsView.this.viewModeChanged = true;
                DetailsView.this.treeVisible = true;
                DetailsView.this.setTreeModeAction.setEnabled(false);
                DetailsView.this.setTextModeAction.setEnabled(true);
                DetailsView.this.treeView.inputChanged(DetailsView.this.currentEventObject);
                DetailsView.this.updateHeader();
            }
        };
        this.setTreeModeAction.setToolTipText(Messages.getString("DetailsView.0"));
        this.setTreeModeAction.setImageDescriptor(imgTreeView);
        this.setTreeModeAction.setEnabled(!this.treeVisible);
        this.setTextModeAction = new Action(){

            public void run() {
                DetailsView.this.textView = DetailsView.this.getTextView();
                ((DetailsView)DetailsView.this).layout.topControl = DetailsView.this.textView;
                DetailsView.this.stackComposite.layout();
                DetailsView.this.viewModeChanged = true;
                DetailsView.this.treeVisible = false;
                DetailsView.this.setTextModeAction.setEnabled(false);
                DetailsView.this.setTreeModeAction.setEnabled(true);
                DetailsView.this.textView.setLogFileMetaData(DetailsView.this.logFileMetaData);
                DetailsView.this.textView.inputChanged(DetailsView.this.currentEventObject);
                DetailsView.this.updateHeader();
            }
        };
        this.setTextModeAction.setToolTipText(Messages.getString("DetailsView.1"));
        this.setTextModeAction.setImageDescriptor(imgTextView);
        this.setTextModeAction.setEnabled(this.treeVisible);
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add(this.setTreeModeAction);
        mgr.add(this.setTextModeAction);
    }

    private Composite getComposite() {
        if (this.isTreeVisibleNow()) {
            return this.getTreeView();
        }
        return this.getTextView();
    }

    private TreeViewComposite getTreeView() {
        if (this.treeView == null) {
            this.treeView = new TreeViewComposite(this.stackComposite, this.getViewSite());
            this.treeView.setLayout((Layout)this.fillLayout);
            this.treeView.setLayoutData(new GridData(4, 128, true, true));
        }
        return this.treeView;
    }

    private TextViewComposite getTextView() {
        if (this.textView == null) {
            this.textView = new TextViewComposite(this.stackComposite);
            this.textView.setLogFileMetaData(this.logFileMetaData);
            this.textView.setLayout((Layout)this.fillLayout);
            this.textView.setLayoutData(new GridData(4, 128, true, true));
        }
        return this.textView;
    }

    private void updateHeader() {
        if (this.currentEventObject != null) {
            String eventType;
            String name;
            String header = this.logFileMetaData.getProjectRelativePath();
            String testCaseName = this.currentEventObject.getTestCaseName();
            if (testCaseName.length() > 0) {
                header = header + "  -  " + testCaseName;
            }
            if ((name = this.currentEventObject.getName()) != null && !name.trim().isEmpty()) {
                header = header + " - " + name;
            }
            if ((eventType = this.currentEventObject.getEventType()) != null && !eventType.trim().isEmpty()) {
                header = header + " - " + eventType;
            }
            this.setContentDescription(header);
        } else {
            this.setContentDescription("");
        }
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        this.memento = this.memento.getChild("selection");
        if (this.memento != null) {
            DetailData detailObject = new DetailData();
            try {
                IProject project;
                IMemento mementoEventObject = this.memento.getChild("eventObject");
                detailObject.setName(mementoEventObject.getString("name"));
                detailObject.setPort(mementoEventObject.getString("port"));
                detailObject.setLine(mementoEventObject.getString("line"));
                detailObject.setTestCase(mementoEventObject.getString("testCaseName"));
                detailObject.setEventType(mementoEventObject.getString("eventType"));
                detailObject.setSourceInfo(mementoEventObject.getString("sourceInfo"));
                String propertyFilePath = mementoEventObject.getString("propertyFile");
                if (propertyFilePath != null) {
                    File propertyFile = new File(propertyFilePath);
                    if (!propertyFile.exists()) {
                        return;
                    }
                    this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
                }
                if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.logFileMetaData.getProjectName())) != null && project.exists() && project.isOpen()) {
                    Path path = new Path(this.logFileMetaData.getProjectRelativePath());
                    IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    if (logFile != null && logFile.getProject().getName().equals(project.getName()) && logFile.exists()) {
                        long fileSize = Long.parseLong(mementoEventObject.getString("fileSize"));
                        long fileModification = Long.parseLong(mementoEventObject.getString("fileModification"));
                        File file = logFile.getLocation().toFile();
                        if (file.lastModified() == fileModification && file.length() == fileSize) {
                            Integer silentEvent = mementoEventObject.getInteger("isSilentEvent");
                            this.textView = this.getTextView();
                            if (silentEvent == 1) {
                                this.useFormatting = true;
                                this.textView.setUseFormatting(false);
                            } else {
                                this.useFormatting = false;
                                this.textView.setUseFormatting(true);
                            }
                            this.setData(detailObject, this.useFormatting);
                        }
                    }
                }
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            catch (ClassNotFoundException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        this.memento = null;
    }

    private boolean isTreeVisibleNow() {
        if (this.viewModeChanged) {
            return this.treeVisible;
        }
        return this.isTreeViewPreferred();
    }

    private boolean isTreeViewPreferred() {
        String selectedView = null;
        if (this.logFileMetaData != null) {
            String currProjName = this.logFileMetaData.getProjectName();
            selectedView = PreferencesHandler.getInstance().getPreferences(currProjName).getSelectedValueContentType();
        }
        if (selectedView == null) {
            return true;
        }
        return selectedView.contentEquals("tree");
    }

    public void setLogFileMetaData(LogFileMetaData logFileMetaData) {
        this.logFileMetaData = logFileMetaData;
    }

    @Override
    public LogFileMetaData getLogFileMetaData() {
        return this.logFileMetaData;
    }

    @Override
    public String getName() {
        return "Details View";
    }
}

