/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.fieldeditors;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.common.utils.preferences.PreferenceUtils;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.TitanListEditor;
import org.eclipse.titan.log.viewer.utils.Messages;

public class StringListEditor
extends TitanListEditor {
    private IInputValidator inputValidator;

    protected StringListEditor() {
    }

    public StringListEditor(String name, String labelText, Composite parent, boolean showUpAndDown) {
        super(name, labelText, parent, showUpAndDown);
    }

    public StringListEditor(String name, String labelText, Composite parent, boolean showUpAndDown, boolean hideColor) {
        super(name, labelText, parent, showUpAndDown, hideColor);
    }

    protected void init(String name, String text) {
        super.init(name, text);
        this.inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                String[] elements;
                String tempText = newText.trim();
                if ("Main Test Component".equals(tempText)) {
                    return Messages.getString("StringListEditor.5");
                }
                if ("System Under Test".equals(tempText)) {
                    return Messages.getString("StringListEditor.5");
                }
                if (tempText.length() > 255) {
                    return Messages.getString("StringListEditor.3");
                }
                if ("".equals(tempText)) {
                    return "";
                }
                for (String element : elements = StringListEditor.this.getElements()) {
                    if (!element.contentEquals(tempText)) continue;
                    return Messages.getString("StringListEditor.6");
                }
                return null;
            }
        };
    }

    public void setInputValidator(IInputValidator inputValidator) {
        this.inputValidator = inputValidator;
    }

    @Override
    protected String createList(String[] items) {
        return PreferenceUtils.serializeToString(Arrays.asList(items));
    }

    @Override
    protected String getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("StringListEditor.0"), Messages.getString("StringListEditor.1"), Messages.getString("StringListEditor.2"), this.inputValidator);
        dialog.open();
        return dialog.getValue();
    }

    @Override
    protected String[] parseString(String stringList) {
        List tmp = PreferenceUtils.deserializeFromString((String)stringList);
        return tmp.toArray(new String[tmp.size()]);
    }
}

