/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.console;

import java.io.Closeable;
import java.io.IOException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.parsers.Parser;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class ConsoleWriter {
    private static ConsoleWriter instance;
    private final MessageConsole console = this.findConsole("org.eclipse.ui.console.ConsoleView");
    private MessageConsoleStream out;

    private ConsoleWriter() {
        if (this.console != null) {
            this.out = this.console.newMessageStream();
            this.out.setActivateOnWrite(true);
        }
    }

    public static synchronized ConsoleWriter getInstance() {
        if (instance == null) {
            instance = new ConsoleWriter();
            ConsoleWriter.instance.out.setActivateOnWrite(false);
        }
        return instance;
    }

    public void writeToConsole(String msg, String projectName) {
        PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(projectName);
        if (preferences.getVerbosePrintoutsEnabled()) {
            try {
                this.out.println(msg);
                this.out.flush();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("ConsoleWriter.0") + e.getMessage()));
            }
        }
    }

    public void dispose() {
        IOUtils.closeQuietly((Closeable)this.out);
    }

    private MessageConsole findConsole(String name) {
        IConsole[] existing;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        IConsoleManager conMan = plugin.getConsoleManager();
        for (IConsole anExisting : existing = conMan.getConsoles()) {
            if (!name.equals(anExisting.getName())) continue;
            return (MessageConsole)anExisting;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public void writeModelData(String projectName, Parser parser, ExecutionModel model, String filepath) {
        this.writeToConsole(Messages.getString("ExecutionModel.0") + filepath, projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.1") + parser.getTestCaseRecords(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.2") + model.getNumberOfEvents(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.3") + parser.getPtcs(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.4") + parser.getMaps(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.5") + parser.getCons(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.6") + parser.getSends(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.7") + parser.getRecs(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.10") + parser.getEnqs(), projectName);
        this.writeToConsole(Messages.getString("ExecutionModel.8") + (float)(parser.getEnd() - parser.getStart()) / 1000.0f + Messages.getString("ExecutionModel.9"), projectName);
        if (parser.wasCanceled()) {
            this.writeToConsole("The loading of the log data was canceled", projectName);
        }
        this.writeToConsole("", projectName);
    }
}

