/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.view;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.MetricGroup;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.utils.RiskLevel;
import org.eclipse.titanium.metrics.view.CNComparator;
import org.eclipse.titanium.metrics.view.IContentNode;
import org.eclipse.titanium.metrics.view.ProjectStatNode;

public class XLSExporter {
    private File file;
    private final MetricData data;

    public XLSExporter(MetricData data) {
        this.data = data;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void write(RiskLevel r) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            for (MetricGroup type : new MetricGroup[]{MetricGroup.MODULE, MetricGroup.ALTSTEP, MetricGroup.FUNCTION, MetricGroup.TESTCASE}) {
                for (IMetricEnum metric : type.getMetrics()) {
                    ProjectStatNode pn;
                    if (!PreferenceManager.isEnabledOnView(metric) || !(pn = new ProjectStatNode(metric)).hasChildren(this.data) || pn.getRiskLevel(this.data).compareTo(r) < 0) continue;
                    HSSFSheet sheet = workbook.createSheet(this.getSheetName(metric));
                    this.printChildren((Sheet)sheet, pn, 0, 0);
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            workbook.write((OutputStream)fileOutputStream);
            IOUtils.closeQuietly((Closeable)fileOutputStream);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while exporting to excel", (Throwable)e);
        }
    }

    private String getSheetName(IMetricEnum metric) {
        StringBuilder builder = new StringBuilder(metric.getName());
        builder.append(" (").append(metric.groupName()).append(')');
        return builder.length() > 31 ? builder.substring(0, 31) : builder.toString();
    }

    protected int printChildren(Sheet sheet, IContentNode n, int col, int line) {
        Object[] objs = n.getChildren(this.data);
        ArrayList<IContentNode> cns = new ArrayList<IContentNode>();
        for (Object o : objs) {
            cns.add((IContentNode)o);
        }
        Collections.sort(cns, new CNComparator(this.data));
        int currentRow = line;
        for (IContentNode c : cns) {
            Row row = sheet.createRow(currentRow++);
            Cell cell = row.createCell(col);
            cell.setCellValue(c.getColumnText(this.data, 0));
            if (c.hasChildren(this.data)) {
                currentRow = this.printChildren(sheet, c, col + 1, currentRow);
                continue;
            }
            Cell number = row.createCell(col + 1);
            number.setCellValue(Double.parseDouble(c.getColumnText(this.data, 1)));
        }
        return currentRow;
    }
}

