/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Check_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Check_Receive_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Invoke_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Operation_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Receive_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Referenced_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AllComponentAliveExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AllComponentRunningExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AllPortCheckSateExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AnyComponentAliveExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AnyComponentRunningExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AnyPortCheckStateExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AnyTimerRunningExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.CheckStateExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ComponentAliveExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ComponentRunningExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.RNDExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.RNDWithValueExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.TimerReadExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.TimerRunningExpression;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class InvokingFunctionsFromSpecificPlaces
extends BaseModuleCodeSmellSpotter {
    public InvokingFunctionsFromSpecificPlaces() {
        super(CodeSmellType.INVOKING_FUNCTIONS_FROM_SPECIFIC_PLACES);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        AltGuard altGuard;
        FunctionVisitor visitor = new FunctionVisitor(problems);
        if (node instanceof AltGuard && (altGuard = (AltGuard)node).getGuardExpression() != null) {
            altGuard.getGuardExpression().accept((ASTVisitor)visitor);
        }
        if (node instanceof Receive_Port_Statement || node instanceof Check_Receive_Port_Statement || node instanceof Check_Port_Statement) {
            node.accept((ASTVisitor)visitor);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(6);
        ret.add(Operation_Altguard.class);
        ret.add(Invoke_Altguard.class);
        ret.add(Referenced_Altguard.class);
        ret.add(Receive_Port_Statement.class);
        ret.add(Check_Receive_Port_Statement.class);
        ret.add(Check_Port_Statement.class);
        return ret;
    }

    protected static class FunctionVisitor
    extends ASTVisitor {
        protected final BaseCodeSmellSpotter.Problems problems;

        public FunctionVisitor(BaseCodeSmellSpotter.Problems problems) {
            this.problems = problems;
        }

        public int visit(IVisitableNode node) {
            Expression_Value exp;
            Referenced_Value value;
            Assignment.Assignment_type asst;
            if (node instanceof Referenced_Value && ((asst = (value = (Referenced_Value)node).getReference().getAssOld().getAssignmentType()) == Assignment.Assignment_type.A_FUNCTION_RVAL || asst == Assignment.Assignment_type.A_EXT_FUNCTION_RVAL || asst == Assignment.Assignment_type.A_FUNCTION_RTEMP || asst == Assignment.Assignment_type.A_EXT_FUNCTION_RTEMP)) {
                this.problems.report(value.getLocation(), "Invoking function may change the actual snapshot");
            }
            if (node instanceof RNDExpression || node instanceof RNDWithValueExpression) {
                exp = (Expression_Value)node;
                this.problems.report(exp.getLocation(), "Random number generation change the actual snapshot");
            }
            if (node instanceof AllComponentAliveExpression || node instanceof AllComponentRunningExpression || node instanceof AnyComponentAliveExpression || node instanceof AnyComponentRunningExpression || node instanceof ComponentAliveExpression || node instanceof ComponentRunningExpression) {
                exp = (Expression_Value)node;
                this.problems.report(exp.getLocation(), "State of component may change during the actual snapshot");
            }
            if (node instanceof AnyPortCheckStateExpression || node instanceof AllPortCheckSateExpression || node instanceof CheckStateExpression) {
                exp = (Expression_Value)node;
                this.problems.report(exp.getLocation(), "State of port may change during the actual snapshot");
            }
            if (node instanceof AnyTimerRunningExpression || node instanceof TimerRunningExpression || node instanceof TimerReadExpression) {
                exp = (Expression_Value)node;
                this.problems.report(exp.getLocation(), "State of timer may change during the actual snapshot");
            }
            return 3;
        }
    }
}

