/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.generators;

import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Connect_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Function_Instance_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Map_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Start_Component_Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ComponentCreateExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.error.ErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.GraphGenerator;

public class ComponentFinderGraphGenerator
extends GraphGenerator {
    private final IFile selectedFile;

    public ComponentFinderGraphGenerator(IFile selectedFile, IProject project, ErrorHandler eHandler) {
        super(project, eHandler);
        this.selectedFile = selectedFile;
    }

    @Override
    protected void createGraph() {
        TestcaseCollector tcc = new TestcaseCollector();
        IProject sourceProj = this.selectedFile.getProject();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)sourceProj);
        Module selectedModule = projectSourceParser.containedModule(this.selectedFile);
        selectedModule.accept((ASTVisitor)tcc);
        for (Def_Testcase tc : tcc.getTestcases()) {
            HashMap<Component_Type, List<Component_Type>> components = new HashMap<Component_Type, List<Component_Type>>();
            Component_Type ct = tc.getRunsOnType(CompilationTimeStamp.getBaseTimestamp());
            components.put(ct, new ArrayList());
            TestcaseVisitor vis = new TestcaseVisitor(new ArrayList<Def_Function>(), components, ct);
            tc.accept((ASTVisitor)vis);
            for (Map.Entry entry : vis.getComponents().entrySet()) {
                for (Object object : (List)entry.getValue()) {
                }
            }
            NodeDescriptor node = new NodeDescriptor(tc.getFullName() + "\n" + ct.getFullName(), tc.getFullName() + "\n" + ct.getFullName(), NodeColours.DARK_RED, this.project, false, ct.getLocation());
            this.graph.addVertex((Object)node);
            this.labels.put(node.getName(), node);
            for (Map.Entry entry : vis.getComponents().entrySet()) {
                if (!ct.equals(entry.getKey()) && !this.graph.containsVertex((Object)(node = new NodeDescriptor(((Component_Type)entry.getKey()).getFullName(), tc.getFullName() + "\n" + ((Component_Type)entry.getKey()).getFullName(), NodeColours.LIGHT_GREEN, this.project, false, ((Component_Type)entry.getKey()).getLocation())))) {
                    this.graph.addVertex((Object)node);
                    this.labels.put(node.getName(), node);
                }
                for (Component_Type ct2 : (List)entry.getValue()) {
                    EdgeDescriptor edge;
                    NodeDescriptor node2 = new NodeDescriptor(ct2.getFullName(), tc.getFullName() + "\n" + ct2.getFullName(), NodeColours.LIGHT_GREEN, this.project, false, ct2.getLocation());
                    if (!this.graph.containsVertex((Object)node2)) {
                        this.graph.addVertex((Object)node2);
                        this.labels.put(node2.getName(), node2);
                    }
                    if (this.graph.containsEdge((Object)(edge = new EdgeDescriptor(tc.getFullName() + "\n" + ((Component_Type)entry.getKey()).getFullName() + "->" + ct2.getFullName(), Color.black)))) continue;
                    this.graph.addEdge((Object)edge, (Object)((NodeDescriptor)this.labels.get(tc.getFullName() + "\n" + ((Component_Type)entry.getKey()).getFullName())), (Object)((NodeDescriptor)this.labels.get(tc.getFullName() + "\n" + ct2.getFullName())), EdgeType.DIRECTED);
                }
            }
        }
    }

    private static class TestcaseCollector
    extends ASTVisitor {
        private final List<Def_Testcase> tcs = new ArrayList<Def_Testcase>();

        TestcaseCollector() {
        }

        private List<Def_Testcase> getTestcases() {
            return this.tcs;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Def_Testcase) {
                this.tcs.add((Def_Testcase)node);
            }
            return 3;
        }
    }

    private static class ModuleVisitor
    extends ASTVisitor {
        private final List<Component_Type> comps = new ArrayList<Component_Type>();
        private final Def_Port port;

        ModuleVisitor(Def_Port port) {
            this.port = port;
        }

        private List<Component_Type> getComponents() {
            return this.comps;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Component_Type) {
                Component_Type ct = (Component_Type)node;
                List defs = ct.getComponentBody().getDefinitions();
                for (Definition def : defs) {
                    if (def == null || !def.equals(this.port)) continue;
                    this.comps.add(ct);
                    return 2;
                }
            }
            return 3;
        }
    }

    private static class TestcaseVisitor
    extends ASTVisitor {
        private final HashMap<Component_Type, List<Component_Type>> components = new HashMap();
        private final List<Def_Function> checkedFunctions;
        private int counter;
        private boolean cce;
        private final Component_Type comp;

        TestcaseVisitor(List<Def_Function> checkedFunctions, HashMap<Component_Type, List<Component_Type>> components, Component_Type comp) {
            this.components.putAll(components);
            this.checkedFunctions = checkedFunctions;
            this.counter = -1;
            this.cce = false;
            this.comp = comp;
        }

        private HashMap<Component_Type, List<Component_Type>> getComponents() {
            return this.components;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Connect_Statement || node instanceof Map_Statement) {
                this.counter = 0;
            } else if (node instanceof PortReference && (this.counter == 0 || this.counter == 1)) {
                ++this.counter;
                PortReference pr = (PortReference)node;
                Assignment as = pr.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (as != null && as instanceof Def_Port) {
                    Def_Port dp = (Def_Port)as;
                    ModuleVisitor mv = new ModuleVisitor(dp);
                    Module m = dp.getMyScope().getModuleScope();
                    m.accept((ASTVisitor)mv);
                    for (Component_Type ct : mv.getComponents()) {
                        if (!this.components.containsKey(this.comp)) {
                            this.components.put(this.comp, new ArrayList());
                        }
                        if (this.components.get(this.comp).contains(ct) || this.comp.equals(ct)) continue;
                        this.components.get(this.comp).add(ct);
                    }
                }
            } else if (node instanceof Function_Instance_Statement) {
                Function_Instance_Statement fis = (Function_Instance_Statement)node;
                Assignment as = fis.getReference().getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                this.analyzeFunction(as, this.comp);
            } else if (node instanceof ComponentCreateExpression) {
                this.cce = true;
            } else if (node instanceof Reference && this.cce) {
                this.cce = false;
                Reference ref = (Reference)node;
                Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                if (as.getType(CompilationTimeStamp.getBaseTimestamp()) instanceof Component_Type) {
                    Component_Type ct = (Component_Type)as.getType(CompilationTimeStamp.getBaseTimestamp());
                    if (!this.components.containsKey(this.comp)) {
                        this.components.put(this.comp, new ArrayList());
                    }
                    if (!this.components.get(this.comp).contains(ct) && !this.comp.equals(ct)) {
                        this.components.get(this.comp).add(ct);
                    }
                }
            } else if (node instanceof Start_Component_Statement) {
                Assignment as = ((Start_Component_Statement)node).getFunctionInstanceReference().getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                this.analyzeFunction(as, this.comp);
            }
            return 3;
        }

        public void analyzeFunction(Assignment assignment, Component_Type component) {
            Def_Function df;
            if (assignment != null && assignment instanceof Def_Function && !this.checkedFunctions.contains(df = (Def_Function)assignment)) {
                this.checkedFunctions.add(df);
                TestcaseVisitor tv = null;
                if (df.getRunsOnType(CompilationTimeStamp.getBaseTimestamp()) != null) {
                    Component_Type fComp = df.getRunsOnType(CompilationTimeStamp.getBaseTimestamp());
                    if (!this.components.containsKey(this.comp)) {
                        this.components.put(this.comp, new ArrayList());
                    }
                    if (!fComp.equals(component) && !this.components.get(component).contains(fComp)) {
                        this.components.get(component).add(fComp);
                        this.components.put(fComp, new ArrayList());
                    }
                    tv = new TestcaseVisitor(this.checkedFunctions, this.components, fComp);
                } else {
                    tv = new TestcaseVisitor(this.checkedFunctions, this.components, component);
                }
                df.accept((ASTVisitor)tv);
                this.components.putAll(tv.getComponents());
            }
        }
    }
}

