/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import org.eclipse.core.resources.IProject;
import org.eclipse.titanium.error.ConsoleErrorHandler;
import org.eclipse.titanium.graph.clustering.AutomaticCluster;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.clustering.FolderNameCluster;
import org.eclipse.titanium.graph.clustering.FullModuleNameCluster;
import org.eclipse.titanium.graph.clustering.LinkedFileCluster;
import org.eclipse.titanium.graph.clustering.ModuleLocationCluster;
import org.eclipse.titanium.graph.clustering.ModuleNameCluster;
import org.eclipse.titanium.graph.clustering.RegexpCluster;
import org.eclipse.titanium.graph.clustering.SparseModuleNameCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class ClustererBuilder {
    private String clusterName = "";
    private DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> originalGraph;
    private IProject project;

    public ClustererBuilder setAlgorithm(String algorithm) {
        this.clusterName = algorithm;
        return this;
    }

    public ClustererBuilder setGraph(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph) {
        this.originalGraph = graph;
        return this;
    }

    public ClustererBuilder setProject(IProject project) {
        this.project = project;
        return this;
    }

    public BaseCluster build() throws IllegalArgumentException {
        if (this.originalGraph == null) {
            throw new IllegalArgumentException("The graph parameter wasn't set for the builder");
        }
        ConsoleErrorHandler errorHandler = new ConsoleErrorHandler();
        BaseCluster clusterer = null;
        if ("modulelocation".equalsIgnoreCase(this.clusterName)) {
            clusterer = new ModuleLocationCluster(this.originalGraph, this.project);
        } else if ("foldername".equalsIgnoreCase(this.clusterName)) {
            clusterer = new FolderNameCluster(this.originalGraph, this.project);
        } else if ("linkedlocation".equalsIgnoreCase(this.clusterName)) {
            clusterer = new LinkedFileCluster(this.originalGraph, this.project);
        } else if ("regularexpression".equalsIgnoreCase(this.clusterName)) {
            clusterer = new RegexpCluster(this.originalGraph);
        } else if ("modulename".equalsIgnoreCase(this.clusterName)) {
            clusterer = new ModuleNameCluster(this.originalGraph);
        } else if ("fullmodulenametree".equalsIgnoreCase(this.clusterName)) {
            clusterer = new FullModuleNameCluster(this.originalGraph);
        } else if ("sparsemodulenametree".equalsIgnoreCase(this.clusterName)) {
            clusterer = new SparseModuleNameCluster(this.originalGraph);
        } else if ("automatic".equalsIgnoreCase(this.clusterName)) {
            clusterer = new AutomaticCluster(this.originalGraph, this.project);
        } else {
            errorHandler.reportInformation("Usage: <output path> [-c<clustering algorithm name>]");
            errorHandler.reportInformation("The possible clustering algorithms are: ");
            errorHandler.reportInformation("\tModuleLocation\n\tFolderName\n\tLinkedLocation\n\tRegularExpression\n\tModuleName\n\tFullModuleNameTree\n\tSparseModuleNameTree");
            throw new IllegalArgumentException("The algorithm doesn't exist!");
        }
        return clusterer;
    }
}

