/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.notification;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.views.executormonitor.LaunchElement;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.titan.executor.views.notification.Notification;
import org.eclipse.titan.executor.views.notification.NotificationContentProvider;
import org.eclipse.titan.executor.views.notification.NotificationLabelProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public final class NotificationView
extends ViewPart
implements ISelectionListener {
    public static final String NOTIFICATIONVIEW = "org.eclipse.titan.executor.views.notification.NotificationView";
    private Table table;
    private TableViewer viewer;
    private NotificationContentProvider contentProvider;
    private NotificationLabelProvider labelProvider;
    private ITreeLeaf actualInput;
    private Action clearAction;
    private Action saveAsAction;
    private Action followLastRecord;
    private boolean isFollowing = true;

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66308);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText("Info");
        column.setWidth(300);
        column.setImage(ImageCache.getImage("information2.gif"));
        column.setMoveable(true);
        column = new TableColumn(this.table, 16384, 0);
        column.setText("Component");
        column.setImage(ImageCache.getImage("information2.gif"));
        column.setMoveable(true);
        column.setWidth(50);
        column = new TableColumn(this.table, 16384, 0);
        column.setText("Type");
        column.setImage(ImageCache.getImage("information2.gif"));
        column.setMoveable(true);
        column.setWidth(50);
        column = new TableColumn(this.table, 16384, 0);
        column.setText("Timestamp");
        column.setWidth(164);
        column.setMoveable(true);
        column.setImage(ImageCache.getImage("clock.gif"));
        this.viewer = new TableViewer(this.table);
        this.viewer.setColumnProperties(new String[]{"Timestamp", "Type", "Component", "Info"});
        this.contentProvider = new NotificationContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new NotificationLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.actualInput = this.getInitialInput();
        this.viewer.setInput((Object)this.actualInput);
        this.createActions();
        this.createToolBar();
        this.createMenu();
        this.getSite().getPage().addSelectionListener("org.eclipse.titan.executor.views.executorMonitor.ExecutorMonitorView", (ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.clearAction = null;
        this.saveAsAction = null;
        this.followLastRecord = null;
        super.dispose();
    }

    private ITreeLeaf getInitialInput() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.titan.executor.views.executorMonitor.ExecutorMonitorView");
        if (null == selection || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        ITreeLeaf element = (ITreeLeaf)structuredSelection.getFirstElement();
        if (null != element) {
            while (!(element instanceof LaunchElement)) {
                element = element.parent();
            }
        }
        return element;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(part) || !(selection instanceof IStructuredSelection) || null == this.viewer.getContentProvider()) {
            return;
        }
        ITreeLeaf selectedElement = selection.isEmpty() ? null : (ITreeLeaf)((IStructuredSelection)selection).getFirstElement();
        if (null != selectedElement) {
            while (!(selectedElement instanceof LaunchElement)) {
                selectedElement = selectedElement.parent();
            }
        }
        if (null != this.actualInput && this.actualInput.equals(selectedElement)) {
            this.viewer.refresh(false);
        } else {
            this.viewer.setInput((Object)selectedElement);
            this.actualInput = selectedElement;
        }
        if (null == selectedElement) {
            this.setTitleToolTip(null);
            this.clearAction.setEnabled(false);
            this.saveAsAction.setEnabled(false);
        } else {
            this.setTitleToolTip(selectedElement.name());
            this.clearAction.setEnabled(true);
            this.saveAsAction.setEnabled(true);
        }
        if (this.isFollowing && null != this.actualInput && this.actualInput instanceof LaunchElement) {
            List<ITreeLeaf> children = ((LaunchElement)this.actualInput).children();
            for (ITreeLeaf aChildren : children) {
                BaseExecutor executor = ((MainControllerElement)aChildren).executor();
                if (null == executor || executor.notifications().isEmpty()) continue;
                this.viewer.reveal((Object)executor.notifications().get(executor.notifications().size() - 1));
            }
        }
    }

    private void createActions() {
        this.clearAction = new Action("Clear"){

            public void run() {
                if (null != NotificationView.this.actualInput && NotificationView.this.actualInput instanceof LaunchElement) {
                    List<ITreeLeaf> children = ((LaunchElement)NotificationView.this.actualInput).children();
                    for (ITreeLeaf aChildren : children) {
                        BaseExecutor executor = ((MainControllerElement)aChildren).executor();
                        if (null == executor) continue;
                        executor.notifications().clear();
                        NotificationView.this.viewer.refresh();
                    }
                }
            }
        };
        this.clearAction.setToolTipText("Clear");
        this.clearAction.setImageDescriptor(ImageCache.getImageDescriptor("trash_enabled.gif"));
        this.clearAction.setDisabledImageDescriptor(ImageCache.getImageDescriptor("trash_disabled.gif"));
        this.clearAction.setEnabled(false);
        this.saveAsAction = new Action("Save As"){

            public void run() {
                NotificationView.this.saveAs();
            }
        };
        this.saveAsAction.setToolTipText("Save As");
        this.saveAsAction.setImageDescriptor(ImageCache.getImageDescriptor("saveas_edit.gif"));
        this.saveAsAction.setEnabled(false);
        this.followLastRecord = new Action("Follow the last record"){

            public void run() {
                NotificationView.this.isFollowing = NotificationView.this.followLastRecord.isChecked();
            }
        };
        this.followLastRecord.setToolTipText("Toggles the follow the last line behavior");
        this.followLastRecord.setEnabled(true);
        this.followLastRecord.setChecked(this.isFollowing);
    }

    private void createToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.clearAction);
        toolbarManager.add((IAction)this.saveAsAction);
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)this.followLastRecord);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void saveAs() {
        NotificationView.saveLaunchElementAs(this.getSite().getShell(), this.actualInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLaunchElementAs(Shell shell, ITreeLeaf actualInput) {
        FileDialog dialog = new FileDialog(shell, 0);
        dialog.setFilterExtensions(new String[]{"log"});
        String filePath = dialog.open();
        if (null == filePath) {
            return;
        }
        File file = new File(filePath);
        if (file.exists()) {
            if (!file.canWrite()) {
                ErrorDialog.openError((Shell)shell, (String)"Read-only file", (String)"The file is read-only, please choose another file", (IStatus)Status.OK_STATUS);
                return;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)shell, (String)"Can not create file", (String)"The file could not be created and will not be saved", (IStatus)Status.OK_STATUS);
                return;
            }
        }
        if (null == actualInput || !(actualInput instanceof LaunchElement)) {
            return;
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            List<ITreeLeaf> children = ((LaunchElement)actualInput).children();
            for (ITreeLeaf aChildren : children) {
                BaseExecutor executor = ((MainControllerElement)aChildren).executor();
                if (null == executor) continue;
                LinkedList<Notification> tempList = executor.notifications();
                for (Notification aTempList : tempList) {
                    out.println(aTempList.toString());
                }
            }
        }
        catch (IOException e) {
            try {
                ErrorDialog.openError((Shell)shell, (String)"Can not write the file", (String)("An error occured while writing to the file\n" + filePath), (IStatus)Status.OK_STATUS);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)out);
            return;
        }
        IOUtils.closeQuietly((Closeable)out);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] outputFiles = root.findFilesForLocationURI(URIUtil.toURI((String)filePath));
        ResourceUtils.refreshResources(Arrays.asList(outputFiles));
    }
}

