/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.executor.executors.LaunchConfigurationUtil;
import org.eclipse.titan.executor.tabpages.hostcontrollers.HostControllersTab;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class LaunchShortcut
implements ILaunchShortcut {
    protected abstract String getConfigurationId();

    protected abstract String getDialogTitle();

    protected abstract String getLaunchConfigurationType();

    public abstract boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy var1, IProject var2, String var3);

    protected ILaunchConfigurationWorkingCopy getWorkingCopy(IProject project, IFile file, String mode) {
        try {
            ILaunchConfigurationType configurationType = LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurationType(this.getConfigurationId());
            ILaunchConfiguration[] configurations = LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations(configurationType);
            ArrayList<ILaunchConfiguration> candidateConfigurations = new ArrayList<ILaunchConfiguration>();
            for (ILaunchConfiguration configuration : configurations) {
                IResource[] resources = configuration.getMappedResources();
                if (resources == null || resources.length < 2) continue;
                boolean found = false;
                for (IResource resource : resources) {
                    if (!resource.equals((Object)project)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    found = false;
                    for (IResource resource : resources) {
                        if (!file.equals(resource)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                candidateConfigurations.add(configuration);
            }
            if (1 == candidateConfigurations.size()) {
                this.performLaunch((ILaunchConfiguration)candidateConfigurations.get(0), mode);
                return null;
            }
            if (candidateConfigurations.size() > 1) {
                IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
                dialog.setTitle(this.getDialogTitle());
                dialog.setMessage("Select existing configuration:");
                dialog.setElements((Object[])candidateConfigurations.toArray(new ILaunchConfiguration[candidateConfigurations.size()]));
                if (dialog.open() == 0) {
                    ILaunchConfiguration result = (ILaunchConfiguration)dialog.getFirstResult();
                    this.performLaunch(result, mode);
                    labelProvider.dispose();
                    return null;
                }
                labelProvider.dispose();
            }
            String configurationName = file.getFullPath().toString().substring(1).replace("/", "-") + "-" + this.getLaunchConfigurationType();
            ILaunchConfiguration config = LaunchConfigurationUtil.findLaunchConfigurationByName(configurationName, configurationType);
            ILaunchConfigurationWorkingCopy wc = null;
            wc = config != null ? config.getWorkingCopy() : configurationType.newInstance(null, LaunchConfigurationUtil.getLaunchManager().generateLaunchConfigurationName(configurationName));
            wc.setMappedResources(new IResource[]{project, file});
            wc.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", true);
            return wc;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
    }

    protected void performLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (configuration.isWorkingCopy()) {
            configuration = ((ILaunchConfigurationWorkingCopy)configuration).doSave();
        }
        configuration.launch(mode, null);
    }

    public final void launch(IEditorPart editor, String mode) {
        ErrorReporter.INTERNAL_ERROR((String)"LaunchShortcut.launch called from an editor even though it is no registered to support such calls.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void launch(ISelection selection, String mode) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] selections = ((IStructuredSelection)selection).toArray();
        if (1 != selections.length) {
            return;
        }
        IFile cfgFile = null;
        IProject project = null;
        if (!(selections[0] instanceof IProject)) return;
        project = (IProject)selections[0];
        List cfgFiles = ProjectFileHandler.getCfgFiles((IProject)project);
        if (cfgFiles.size() == 1) {
            cfgFile = (IFile)cfgFiles.get(0);
        } else if (cfgFiles.size() > 1) {
            IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
            dialog.setTitle("Config File Selection");
            dialog.setMessage("Select existing cfg file:");
            dialog.setElements((Object[])cfgFiles.toArray(new IFile[cfgFiles.size()]));
            if (dialog.open() == 0) {
                cfgFile = (IFile)dialog.getFirstResult();
            }
        } else {
            ErrorReporter.logError((String)"Config file not found");
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("Error while creating the default launch configuration for project " + project.getName()), (String)("Config file not found in project " + project.getName()));
            return;
        }
        if (project == null || cfgFile == null) {
            return;
        }
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(project, cfgFile, mode);
        if (wc == null) {
            return;
        }
        boolean result = this.initLaunchConfiguration(wc, project, PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)cfgFile.getLocation().toOSString()));
        if (result) {
            result = HostControllersTab.initLaunchConfiguration(wc);
        }
        try {
            if (!result) return;
            wc.setMappedResources(new IResource[]{project, cfgFile});
            wc.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", true);
            this.performLaunch((ILaunchConfiguration)wc, mode);
            return;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

