/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.mctr;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.titan.runtime.core.NetworkHandler;
import org.eclipse.titan.runtime.core.TTCN_Communication;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.mctr.Timeval;
import org.eclipse.titan.runtime.core.mctr.UserInterface;

public class MainController {
    private static final int MSG_ERROR = 0;
    private static final int MSG_LOG = 1;
    private static final int MSG_VERSION = 2;
    private static final int MSG_MTC_CREATED = 3;
    private static final int MSG_PTC_CREATED = 4;
    private static final int MSG_CREATE_MTC = 2;
    private static final int MSG_CREATE_PTC = 3;
    private static final int MSG_KILL_PROCESS = 4;
    private static final int MSG_EXIT_HC = 5;
    private static final int MSG_CREATE_NAK = 4;
    private static final int MSG_HC_READY = 5;
    private static final int MSG_CREATE_ACK = 1;
    private static final int MSG_START_ACK = 2;
    private static final int MSG_STOP = 3;
    private static final int MSG_STOP_ACK = 4;
    private static final int MSG_KILL_ACK = 5;
    private static final int MSG_RUNNING = 6;
    private static final int MSG_ALIVE = 7;
    private static final int MSG_DONE_ACK = 8;
    private static final int MSG_KILLED_ACK = 9;
    private static final int MSG_CANCEL_DONE = 10;
    private static final int MSG_COMPONENT_STATUS = 11;
    private static final int MSG_CONNECT_LISTEN = 12;
    private static final int MSG_CONNECT = 13;
    private static final int MSG_CONNECT_ACK = 14;
    private static final int MSG_DISCONNECT = 15;
    private static final int MSG_DISCONNECT_ACK = 16;
    private static final int MSG_MAP = 17;
    private static final int MSG_MAP_ACK = 18;
    private static final int MSG_UNMAP = 19;
    private static final int MSG_UNMAP_ACK = 20;
    private static final int MSG_EXECUTE_CONTROL = 21;
    private static final int MSG_EXECUTE_TESTCASE = 22;
    private static final int MSG_PTC_VERDICT = 23;
    private static final int MSG_CONTINUE = 24;
    private static final int MSG_EXIT_MTC = 25;
    private static final int MSG_START = 21;
    private static final int MSG_KILL = 22;
    private static final int MSG_CREATE_REQ = 2;
    private static final int MSG_START_REQ = 3;
    private static final int MSG_STOP_REQ = 4;
    private static final int MSG_KILL_REQ = 5;
    private static final int MSG_IS_RUNNING = 6;
    private static final int MSG_IS_ALIVE = 7;
    private static final int MSG_DONE_REQ = 8;
    private static final int MSG_KILLED_REQ = 9;
    private static final int MSG_CANCEL_DONE_ACK = 10;
    private static final int MSG_CONNECT_REQ = 11;
    private static final int MSG_CONNECT_LISTEN_ACK = 12;
    private static final int MSG_CONNECTED = 13;
    private static final int MSG_CONNECT_ERROR = 14;
    private static final int MSG_DISCONNECT_REQ = 15;
    private static final int MSG_DISCONNECTED = 16;
    private static final int MSG_MAP_REQ = 17;
    private static final int MSG_MAPPED = 18;
    private static final int MSG_UNMAP_REQ = 19;
    private static final int MSG_UNMAPPED = 20;
    private static final int MSG_DEBUG_HALT_REQ = 101;
    private static final int MSG_DEBUG_CONTINUE_REQ = 102;
    private static final int MSG_DEBUG_BATCH = 103;
    private static final int MSG_TESTCASE_STARTED = 21;
    private static final int MSG_TESTCASE_FINISHED = 22;
    private static final int MSG_MTC_READY = 23;
    private static final int MSG_STOPPED = 21;
    private static final int MSG_STOPPED_KILLED = 22;
    private static final int MSG_KILLED = 23;
    private static final int MSG_DEBUG_COMMAND = 100;
    private static final int MSG_DEBUG_RETURN_VALUE = 100;
    private static final int MSG_CONFIGURE = 200;
    private static final int MSG_CONFIGURE_ACK = 200;
    private static final int MSG_CONFIGURE_NAK = 201;
    private static final String MESSAGE_WAS_NOT_UNDERSTOOD = "The received message was not understood by the MC.";
    private UserInterface ui;
    private final NetworkHandler nh = new NetworkHandler();
    private mcStateEnum mc_state;
    private String mc_hostname;
    private ServerSocketChannel mc_channel;
    private Selector mc_selector;
    private final ConcurrentHashMap<SelectableChannel, channel_table_struct> channel_table = new ConcurrentHashMap();
    private String config_str;
    private final List<module_version_info> modules = new ArrayList<module_version_info>();
    private volatile boolean any_component_done_requested;
    private volatile boolean any_component_done_sent;
    private volatile boolean all_component_done_requested;
    private volatile boolean any_component_killed_requested;
    private volatile boolean all_component_killed_requested;
    private long testcase_start_time_seconds;
    private int testcase_start_time_microseconds;
    private volatile boolean stop_requested;
    private volatile boolean stop_after_tc;
    private int next_comp_ref;
    private int tc_first_comp_ref;
    private final List<Host> hosts = new ArrayList<Host>();
    private final List<HostGroupStruct> host_groups = new ArrayList<HostGroupStruct>();
    private List<String> assigned_components = new ArrayList<String>();
    private volatile boolean all_components_assigned;
    private final Deque<unknown_connection> unknown_connections = new LinkedList<unknown_connection>();
    private int n_active_ptcs = 0;
    private int max_ptcs = -1;
    public List<ComponentStruct> components = new ArrayList<ComponentStruct>();
    private double kill_timer = 0.0;
    private final ReentrantLock mutex = new ReentrantLock();
    private ComponentStruct mtc;
    private ComponentStruct system;
    private wakeup_reason_t wakeup_reason;
    private final LinkedList<timer_struct> timers = new LinkedList();

    public void initialize(UserInterface par_ui, int par_max_ptcs) {
        this.ui = par_ui;
        this.max_ptcs = par_max_ptcs;
        this.mc_state = mcStateEnum.MC_INACTIVE;
        try {
            this.mc_hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new TtcnError(e);
        }
        this.mc_hostname = String.format("MC@%s", this.mc_hostname);
        this.all_components_assigned = false;
        this.config_str = null;
        this.mtc = null;
        this.system = null;
        this.next_comp_ref = 3;
        this.stop_after_tc = false;
        this.stop_requested = false;
        this.kill_timer = 10.0;
        this.wakeup_reason = wakeup_reason_t.REASON_NOTHING;
    }

    public void terminate() {
        this.clean_up();
        this.destroy_host_groups();
    }

    private void lock() {
        this.mutex.lock();
    }

    private void unlock() {
        this.mutex.unlock();
    }

    private static double time_now() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    private void register_timer(timer_struct timer) {
        if (this.timers.isEmpty()) {
            this.timers.add(timer);
            return;
        }
        ListIterator<timer_struct> iterator = this.timers.listIterator();
        while (iterator.hasNext()) {
            timer_struct listItem = (timer_struct)iterator.next();
            if (!(listItem.expiration > timer.expiration)) continue;
            iterator.previous();
            iterator.add(timer);
            return;
        }
        this.timers.add(timer);
    }

    private void cancel_timer(timer_struct timer) {
        this.timers.remove(timer);
    }

    private int get_poll_timeout() {
        timer_struct timer_head = this.timers.peek();
        if (timer_head == null) {
            return -1;
        }
        double offset = timer_head.expiration - MainController.time_now();
        if (offset > 0.0) {
            return (int)(1000.0 * offset);
        }
        return 0;
    }

    private void handle_expired_timers() {
        if (this.timers.isEmpty()) {
            return;
        }
        double now = MainController.time_now();
        timer_struct head = this.timers.peek();
        while (head != null && head.expiration < now) {
            this.handle_kill_timer(head);
            head = this.timers.peek();
        }
    }

    private void start_kill_timer(ComponentStruct tc) {
        if (this.kill_timer > 0.0) {
            timer_struct timer = new timer_struct();
            timer.expiration = MainController.time_now() + this.kill_timer;
            timer.component = tc;
            tc.kill_timer = timer;
            this.register_timer(timer);
        } else {
            tc.kill_timer = null;
        }
    }

    private void init_connections(ComponentStruct tc) {
        tc.conn_head_list = new ArrayList<PortConnection>();
        tc.conn_tail_list = new ArrayList<PortConnection>();
    }

    private void handle_kill_timer(timer_struct timer) {
        ComponentStruct tc = timer.component;
        Host host = tc.comp_location;
        boolean kill_process = false;
        switch (tc.tc_state) {
            case TC_EXITED: {
                break;
            }
            case TC_EXITING: {
                if (tc == this.mtc) {
                    this.error(MessageFormat.format("MTC on host {0} did not close its control connection in time. Trying to kill it using its HC.", host.hostname));
                } else {
                    this.notify(MessageFormat.format("PTC {0} on host {1} did not close its control connection in time. Trying to kill it using its HC.", tc.comp_ref, host.hostname));
                }
                kill_process = true;
                break;
            }
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                if (tc != this.mtc) {
                    this.notify(MessageFormat.format("PTC {0} on host {1} is not responding. Trying to kill it using its HC.", tc.comp_ref, host.hostname));
                    kill_process = true;
                    break;
                }
            }
            default: {
                if (tc == this.mtc) {
                    this.error(MessageFormat.format("MTC on host {0} is not responding. Trying to kill it using its HC. This will abort test execution.", host.hostname));
                    kill_process = true;
                    break;
                }
                this.error(MessageFormat.format("PTC {0} is in invalid state when its kill timer expired.", tc.comp_ref));
            }
        }
        if (kill_process) {
            if (host.hc_state == hc_state_enum.HC_ACTIVE) {
                this.send_kill_process(host, tc.comp_ref);
                tc.process_killed = true;
            } else {
                this.error(MessageFormat.format("Test Component {0} cannot be killed because the HC on host {1} is not in active state. Kill the process manually or the test system may get into a deadlock.", tc.comp_ref, host.hostname));
            }
        }
        this.cancel_timer(timer);
        tc.kill_timer = null;
    }

    private void error(String message) {
        this.unlock();
        this.ui.error(0, message);
        this.lock();
    }

    private void notify(String message) {
        long timestamp = System.currentTimeMillis();
        this.notify(new Timeval(timestamp / 1000L, timestamp % 1000L), this.mc_hostname, TTCN_Logger.Severity.EXECUTOR_UNQUALIFIED.ordinal(), message);
    }

    private void notify(Timeval timestamp, String source, int severity, String message) {
        this.unlock();
        this.ui.notify(timestamp, source, severity, message);
        this.lock();
    }

    private void status_change() {
        this.unlock();
        this.ui.status_change();
        this.lock();
    }

    private void fatal_error(String message) {
    }

    private void add_component(ComponentStruct component) {
        int component_reference = component.comp_ref;
        if (this.lookup_component(component_reference) != null) {
            this.fatal_error(MessageFormat.format("MainController.add_component: duplicate component reference {0}.", component_reference));
        }
        while (this.components.size() < component_reference) {
            this.components.add(null);
        }
        this.components.add(component_reference, component);
    }

    private ComponentStruct lookup_component(int component_reference) {
        if (component_reference > 0 && component_reference < this.components.size()) {
            return this.components.get(component_reference);
        }
        return null;
    }

    private void destroy_all_components() {
        for (ComponentStruct component : this.components) {
            if (component == null) continue;
            this.close_tc_connection(component);
            MainController.remove_component_from_host(component);
            component.comp_type = new QualifiedName("", "");
            component.tc_fn_name = new QualifiedName("", "");
            component.comp_name = null;
            component.return_type = null;
            component.return_value = null;
            component.verdict_reason = null;
            switch (component.tc_state) {
                case TC_INITIAL: {
                    component.location_str = null;
                    break;
                }
                case PTC_STARTING: {
                    MainController.free_requestors(component.cancel_done_sent_to);
                    break;
                }
                case TC_STOPPING: 
                case PTC_STOPPING_KILLING: 
                case PTC_KILLING: {
                    MainController.free_requestors(component.stop_requestors);
                    MainController.free_requestors(component.kill_requestors);
                    break;
                }
            }
            MainController.free_requestors(component.done_requestors);
            MainController.free_requestors(component.killed_requestors);
            MainController.free_requestors(component.cancel_done_sent_for);
            this.remove_all_connections(component.comp_ref);
        }
        this.components.clear();
        this.n_active_ptcs = 0;
        this.mtc = null;
        this.system = null;
        for (Host host : this.hosts) {
            host.n_active_components = 0;
        }
        this.next_comp_ref = 3;
        this.any_component_done_requested = false;
        this.any_component_done_sent = false;
        this.all_component_done_requested = false;
        this.any_component_killed_requested = false;
        this.all_component_killed_requested = false;
    }

    private unknown_connection new_unknown_connection() {
        unknown_connection temp = new unknown_connection();
        this.unknown_connections.add(temp);
        return temp;
    }

    private void delete_unknown_connection(unknown_connection connection) {
        this.unknown_connections.remove(connection);
    }

    private void close_unknown_connection(unknown_connection connection) {
        try {
            connection.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.channel_table.remove(connection.channel);
        this.delete_unknown_connection(connection);
    }

    private void thread_main() {
        this.lock();
        block6: while (this.mc_state != mcStateEnum.MC_INACTIVE) {
            this.unlock();
            try {
                int timeout = this.get_poll_timeout();
                int selectReturn = timeout > 0 ? this.mc_selector.select(timeout) : (timeout < 0 ? this.mc_selector.select(0L) : this.mc_selector.selectNow());
                this.lock();
                switch (this.wakeup_reason) {
                    case REASON_NOTHING: 
                    case REASON_MTC_KILL_TIMER: {
                        break;
                    }
                    case REASON_SHUTDOWN: {
                        this.wakeup_reason = wakeup_reason_t.REASON_NOTHING;
                        this.perform_shutdown();
                        continue block6;
                    }
                    default: {
                        this.error(MessageFormat.format("Invalid wakeup reason ({0}) was set.", new Object[]{this.wakeup_reason}));
                        this.wakeup_reason = wakeup_reason_t.REASON_NOTHING;
                    }
                }
                if (selectReturn > 0) {
                    Set<SelectionKey> selectedKeys = this.mc_selector.selectedKeys();
                    for (SelectionKey key : selectedKeys) {
                        SelectableChannel keyChannel = key.channel();
                        this.dispatch_socket_event(keyChannel);
                    }
                    selectedKeys.clear();
                    continue;
                }
                if (selectReturn != 0) continue;
                this.handle_expired_timers();
            }
            catch (IOException e) {
                return;
            }
        }
        this.clean_up();
        this.notify("Shutdown complete.");
        this.unlock();
        this.ui.status_change();
    }

    private void dispatch_socket_event(SelectableChannel channel) {
        if (!this.channel_table.containsKey(channel)) {
            return;
        }
        channel_table_struct temp_struct = this.channel_table.get(channel);
        switch (temp_struct.channel_type) {
            case CHANNEL_SERVER: {
                this.handle_incoming_connection((ServerSocketChannel)channel);
                break;
            }
            case CHANNEL_UNKNOWN: {
                this.handle_unknown_data(temp_struct.unknown);
                break;
            }
            case CHANNEL_HC: {
                this.handle_hc_data(temp_struct.host, true);
                break;
            }
            case CHANNEL_TC: {
                this.handle_tc_data(temp_struct.component, true);
                break;
            }
            default: {
                this.fatal_error(MessageFormat.format("Invalid connection type ({0}) for channel {1}.", new Object[]{temp_struct.channel_type, channel}));
            }
        }
    }

    private void wakeup_thread(wakeup_reason_t reason) {
        this.wakeup_reason = reason;
        this.mc_selector.wakeup();
    }

    private void handle_incoming_connection(ServerSocketChannel channel) {
        try {
            SocketChannel sc = channel.accept();
            sc.configureBlocking(false);
            unknown_connection new_connection = this.new_unknown_connection();
            new_connection.channel = sc;
            new_connection.ip_address = sc.socket().getInetAddress();
            new_connection.text_buf = new Text_Buf();
            channel_table_struct new_struct = new channel_table_struct();
            new_struct.channel_type = channel_type_enum.CHANNEL_UNKNOWN;
            new_struct.unknown = new_connection;
            this.channel_table.put(sc, new_struct);
            try {
                sc.register(this.mc_selector, 1);
            }
            catch (ClosedChannelException e) {
                this.error(MessageFormat.format("Selector registration failed: {0}.", e.getMessage()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handle_unknown_data(unknown_connection connection) {
        Text_Buf text_buf = connection.text_buf;
        int recv_len = MainController.receive_to_buffer(connection.channel, text_buf, true);
        boolean error_flag = false;
        if (recv_len > 0) {
            try {
                while (text_buf.is_message()) {
                    int msg_len = text_buf.pull_int().get_int();
                    int msg_type = text_buf.pull_int().get_int();
                    boolean process_more_messages = false;
                    switch (msg_type) {
                        case 0: {
                            this.process_error(connection);
                            process_more_messages = true;
                            break;
                        }
                        case 1: {
                            this.process_log(connection);
                            process_more_messages = true;
                            break;
                        }
                        case 2: {
                            this.process_version(connection);
                            break;
                        }
                        case 3: {
                            this.process_mtc_created(connection);
                            break;
                        }
                        case 4: {
                            this.process_ptc_created(connection);
                            break;
                        }
                        default: {
                            this.error(MessageFormat.format("Invalid message type ({0}) was received on an unknown connection from {1} [{2}].", msg_type, connection.ip_address.getHostName(), connection.ip_address.getHostAddress()));
                            error_flag = true;
                        }
                    }
                    if (process_more_messages) {
                        text_buf.cut_message();
                        continue;
                    }
                    break;
                }
            }
            catch (TtcnError tc_error) {
                this.error(MessageFormat.format("Maleformed message was received on an unknown connection from {0} [{1}].", connection.ip_address.getHostName(), connection.ip_address.getHostAddress()));
                error_flag = true;
            }
            if (error_flag) {
                this.send_error_str(connection.channel, MESSAGE_WAS_NOT_UNDERSTOOD);
            }
        } else if (recv_len == 0) {
            this.error(MessageFormat.format("Unexpected end of an unknown connection from {0} [{1}].", connection.ip_address.getHostName(), connection.ip_address.getHostAddress()));
            error_flag = true;
        } else {
            this.error(MessageFormat.format("Receiving of data failed on an unknown connection from {0} [{1}].", connection.ip_address.getHostName(), connection.ip_address.getHostAddress()));
            error_flag = true;
        }
        if (error_flag) {
            this.close_unknown_connection(connection);
        }
    }

    public void add_host(String group_name, String host_name) {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_INACTIVE) {
            this.error("MainController.add_host: called in wrong state.");
            this.unlock();
            return;
        }
        HostGroupStruct group = this.add_host_group(group_name);
        if (host_name != null) {
            if (group.has_all_hosts) {
                this.error(MessageFormat.format("Redundant member `{0}'' was ignored in host group `{1}''. All hosts (`*'') are already the members of the group.", host_name, group_name));
            } else if (group.host_members.contains(host_name)) {
                this.error(MessageFormat.format("Duplicate member `{0}'' was ignored in host group `{1}''.", host_name, group_name));
            } else {
                group.host_members.add(host_name);
            }
        } else if (group.has_all_hosts) {
            this.error(MessageFormat.format("Duplicate member `*'' was ignored in host group `{0}''.", group_name));
        } else {
            for (String group_member : group.host_members) {
                this.error(MessageFormat.format("Redundant member `{0}'' was ignored in host group `{1}''. All hosts (`*'') are already the members of the group.", group_member, group_name));
            }
            group.host_members.clear();
            group.has_all_hosts = true;
        }
        this.unlock();
    }

    private HostGroupStruct add_host_group(String group_name) {
        for (HostGroupStruct current_group : this.host_groups) {
            if (!current_group.group_name.equals(group_name)) continue;
            return current_group;
        }
        HostGroupStruct new_group = new HostGroupStruct();
        new_group.group_name = group_name;
        new_group.has_all_hosts = false;
        new_group.has_all_components = false;
        new_group.host_members = new ArrayList<String>();
        new_group.assigned_components = new ArrayList<String>();
        this.host_groups.add(new_group);
        return new_group;
    }

    private HostGroupStruct lookup_host_group(String group_name) {
        for (HostGroupStruct group : this.host_groups) {
            if (!group.group_name.equals(group_name)) continue;
            return group;
        }
        return null;
    }

    private static boolean is_similar_hostname(String host1, String host2) {
        String host1Lower = host1.toLowerCase();
        String host2lower = host2.toLowerCase();
        for (int i = 0; i < Math.min(host1.length(), host2.length()); ++i) {
            if (host1Lower.charAt(i) == host2lower.charAt(i)) continue;
            return false;
        }
        if (host1.length() == host2.length()) {
            return true;
        }
        if (host1.length() < host2.length()) {
            return host2.charAt(host1.length()) == '.';
        }
        return host1.charAt(host2.length()) == '.';
    }

    private static boolean host_has_name(Host host, String name) {
        if (MainController.is_similar_hostname(host.hostname, name)) {
            return true;
        }
        return MainController.is_similar_hostname(host.hostname_local, name);
    }

    private static boolean member_of_group(Host host, HostGroupStruct group) {
        if (group.has_all_hosts) {
            return true;
        }
        if (group.host_members.isEmpty()) {
            return MainController.host_has_name(host, group.group_name);
        }
        for (int i = 0; i < group.host_members.size(); ++i) {
            String member_name = group.host_members.get(i);
            if (!MainController.host_has_name(host, member_name)) continue;
            return true;
        }
        return false;
    }

    private void add_allowed_components(Host host) {
        host.all_components_allowed = false;
        for (HostGroupStruct group : this.host_groups) {
            String component_id;
            if (MainController.member_of_group(host, group)) continue;
            for (int j = 0; j < group.assigned_components.size() && (component_id = group.assigned_components.get(j)) != null; ++j) {
                host.allowed_components.add(component_id);
            }
            if (!group.has_all_components) continue;
            host.all_components_allowed = true;
        }
    }

    public void assign_component(String host_or_group, String component_id) {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_INACTIVE) {
            this.error("MainController.assign_component: called in wrong state.");
            this.unlock();
            return;
        }
        HostGroupStruct group = this.add_host_group(host_or_group);
        if (component_id == null) {
            if (this.all_components_assigned) {
                for (HostGroupStruct hostGroup : this.host_groups) {
                    if (!hostGroup.has_all_components) continue;
                    this.error(MessageFormat.format("Duplicate assignment of all components (*) to host group `{0}''. Previous assignment to group `{1}'' is ignored.", host_or_group, hostGroup.group_name));
                    hostGroup.has_all_components = false;
                }
            } else {
                this.all_components_assigned = true;
            }
            group.has_all_components = true;
        } else {
            if (this.assigned_components.contains(component_id)) {
                for (HostGroupStruct hostGroup : this.host_groups) {
                    if (!hostGroup.assigned_components.contains(component_id)) continue;
                    this.error(MessageFormat.format("Duplicate assignment of component `{0}'' to host group `{1}''. Previous assignment to group `{2}'' is ignored.", component_id, host_or_group, hostGroup.group_name));
                    hostGroup.assigned_components.remove(component_id);
                }
            } else {
                this.assigned_components.add(component_id);
            }
            group.assigned_components.add(component_id);
        }
        this.unlock();
    }

    public void destroy_host_groups() {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_INACTIVE) {
            this.error("MainController.destroy_host_groups: called in wrong state.");
        } else {
            for (HostGroupStruct hostGroup : this.host_groups) {
                hostGroup.host_members.clear();
                hostGroup.assigned_components.clear();
            }
            this.host_groups.clear();
            this.assigned_components.clear();
            this.all_components_assigned = false;
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int start_session(String local_address, int tcp_port) {
        this.lock();
        try {
            if (this.mc_state != mcStateEnum.MC_INACTIVE) {
                this.error("MainController.start_session: called in wrong state.");
                int n = 0;
                return n;
            }
            try {
                this.mc_selector = Selector.open();
            }
            catch (IOException e) {
                this.error(MessageFormat.format("Selector opening failed: {0}.", e.getMessage()));
                this.clean_up();
                this.unlock();
                int n = 0;
                this.unlock();
                return n;
            }
            this.nh.set_family(local_address, tcp_port);
            try {
                this.mc_channel = ServerSocketChannel.open();
                this.mc_channel.configureBlocking(false);
            }
            catch (IOException e) {
                this.error(MessageFormat.format("Server socket creation failed: {0}\n", e.getMessage()));
                this.clean_up();
                int n = 0;
                this.unlock();
                return n;
            }
            try {
                this.mc_channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            }
            catch (IOException e) {
                this.error(MessageFormat.format("SO_REUSEADDR failed on server socket: {0}", e.getMessage()));
                this.clean_up();
                int n = 0;
                this.unlock();
                return n;
            }
            try {
                this.mc_channel.bind(this.nh.get_addr(), 10);
            }
            catch (IOException e) {
                if (local_address == null || local_address.isEmpty()) {
                    this.error(MessageFormat.format("Binding server socket to TCP port {0,number,#} failed: {1}\n", tcp_port, e.getMessage()));
                    this.clean_up();
                    int n = 0;
                    this.unlock();
                    return n;
                }
                this.error(MessageFormat.format("Binding server socket to IP address {0} and TCP port {1,number,#} failed: {2}\n", local_address, tcp_port, e.getMessage()));
                this.clean_up();
                int n = 0;
                this.unlock();
                return n;
            }
            try {
                channel_table_struct server_struct = new channel_table_struct();
                server_struct.channel_type = channel_type_enum.CHANNEL_SERVER;
                this.channel_table.put(this.mc_channel, server_struct);
                this.mc_channel.register(this.mc_selector, 16);
            }
            catch (ClosedChannelException e) {
                this.error(MessageFormat.format("Selector registration failed: {0}.", e.getMessage()));
                this.clean_up();
                this.unlock();
                int n = 0;
                this.unlock();
                return n;
            }
            this.wakeup_reason = wakeup_reason_t.REASON_NOTHING;
            this.mc_state = mcStateEnum.MC_LISTENING;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    MainController.this.thread_main();
                }
            };
            thread.start();
            try {
                tcp_port = ((InetSocketAddress)this.mc_channel.getLocalAddress()).getPort();
                this.notify(MessageFormat.format("Listening on IP address {0} and TCP port {1,number,#}.\n", ((InetSocketAddress)this.mc_channel.getLocalAddress()).getAddress().getHostAddress(), ((InetSocketAddress)this.mc_channel.getLocalAddress()).getPort()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ui.status_change();
            int n = tcp_port;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void set_kill_timer(Double timer_val) {
        this.lock();
        switch (this.mc_state) {
            case MC_INACTIVE: 
            case MC_LISTENING: 
            case MC_HC_CONNECTED: 
            case MC_RECONFIGURING: {
                if (timer_val < 0.0) {
                    this.error("MainController.set_kill_timer: setting a negative kill timer value.");
                    break;
                }
                this.kill_timer = timer_val;
                break;
            }
            default: {
                this.error("MainController.set_kill_timer: called in wrong state.");
            }
        }
        this.unlock();
    }

    public mcStateEnum get_state() {
        this.lock();
        mcStateEnum ret_val = this.mc_state;
        this.unlock();
        return ret_val;
    }

    public boolean get_stop_after_testcase() {
        this.lock();
        boolean ret_val = this.stop_after_tc;
        this.unlock();
        return ret_val;
    }

    public int get_nof_hosts() {
        this.lock();
        int ret_val = this.hosts.size();
        this.unlock();
        return ret_val;
    }

    public Host get_host_data(int host_index) {
        this.lock();
        return this.hosts.get(host_index);
    }

    public ComponentStruct get_component_data(int component_reference) {
        this.lock();
        return this.lookup_component(component_reference);
    }

    public void release_data() {
        this.unlock();
    }

    public static String get_mc_state_name(mcStateEnum state) {
        switch (state) {
            case MC_INACTIVE: {
                return "inactive";
            }
            case MC_LISTENING: {
                return "listening";
            }
            case MC_LISTENING_CONFIGURED: {
                return "listening (configured)";
            }
            case MC_HC_CONNECTED: {
                return "HC connected";
            }
            case MC_CONFIGURING: {
                return "configuring...";
            }
            case MC_ACTIVE: {
                return "active";
            }
            case MC_CREATING_MTC: {
                return "creating MTC...";
            }
            case MC_TERMINATING_MTC: {
                return "terminating MTC...";
            }
            case MC_READY: {
                return "ready";
            }
            case MC_EXECUTING_CONTROL: {
                return "executing control part";
            }
            case MC_EXECUTING_TESTCASE: {
                return "executing testcase";
            }
            case MC_TERMINATING_TESTCASE: {
                return "terminating testcase...";
            }
            case MC_PAUSED: {
                return "paused after testcase";
            }
            case MC_SHUTDOWN: {
                return "shutting down...";
            }
        }
        return "unknown/transient";
    }

    public static String get_hc_state_name(hc_state_enum state) {
        switch (state) {
            case HC_IDLE: {
                return "not configured";
            }
            case HC_CONFIGURING: 
            case HC_CONFIGURING_OVERLOADED: {
                return "being configured";
            }
            case HC_ACTIVE: {
                return "ready";
            }
            case HC_OVERLOADED: {
                return "overloaded";
            }
            case HC_DOWN: {
                return "down";
            }
        }
        return "unknown/transient";
    }

    public static String get_tc_state_name(tc_state_enum state) {
        switch (state) {
            case TC_INITIAL: {
                return "being created";
            }
            case TC_IDLE: {
                return "inactive - waiting for start";
            }
            case TC_CREATE: {
                return "executing create operation";
            }
            case TC_START: {
                return "executing component start operation";
            }
            case TC_STOP: 
            case MTC_ALL_COMPONENT_STOP: {
                return "executing component stop operation";
            }
            case TC_KILL: 
            case MTC_ALL_COMPONENT_KILL: {
                return "executing kill operation";
            }
            case TC_CONNECT: {
                return "executing connect operation";
            }
            case TC_DISCONNECT: {
                return "executing disconnect operation";
            }
            case TC_MAP: {
                return "executing map operation";
            }
            case TC_UNMAP: {
                return "executing unmap operation";
            }
            case TC_STOPPING: {
                return "being stopped";
            }
            case TC_EXITING: {
                return "terminated";
            }
            case TC_EXITED: {
                return "exited";
            }
            case MTC_CONTROLPART: {
                return "executing control part";
            }
            case MTC_TESTCASE: {
                return "executing testcase";
            }
            case MTC_TERMINATING_TESTCASE: {
                return "terminating testcase";
            }
            case MTC_PAUSED: {
                return "paused";
            }
            case PTC_FUNCTION: {
                return "executing function";
            }
            case PTC_STARTING: {
                return "being started";
            }
            case PTC_STOPPED: {
                return "stopped - waiting for re-start";
            }
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                return "being killed";
            }
        }
        return "unknown/transient";
    }

    public List<Host> get_hosts() {
        return this.hosts;
    }

    public synchronized boolean start_reconfiguring() {
        switch (this.mc_state) {
            case MC_READY: {
                this.mc_state = mcStateEnum.MC_RECONFIGURING;
                return true;
            }
            case MC_LISTENING: 
            case MC_HC_CONNECTED: {
                return true;
            }
        }
        this.lock();
        this.error("MainController.start_reconfiguring: called in wrong state.");
        this.unlock();
        return false;
    }

    public synchronized void create_mtc(Host host) {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_ACTIVE) {
            this.error("MainController.create_mtc: called in wrong state.");
            this.unlock();
            return;
        }
        switch (host.hc_state) {
            case HC_OVERLOADED: {
                this.notify(MessageFormat.format("HC on host {0} reported overload. Trying to create MTC there anyway.", host.hostname));
                break;
            }
            case HC_ACTIVE: {
                break;
            }
            default: {
                this.error(MessageFormat.format("MTC cannot be created on {0}: HC is not active.", host.hostname));
                this.unlock();
                return;
            }
        }
        this.notify(MessageFormat.format("Creating MTC on host {0}.", host.hostname));
        this.send_create_mtc(host);
        this.mtc = new ComponentStruct();
        this.mtc.comp_ref = 1;
        this.mtc.comp_name = "MTC";
        this.mtc.tc_state = tc_state_enum.TC_INITIAL;
        this.mtc.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
        this.mtc.verdict_reason = null;
        this.mtc.text_buf = null;
        this.mtc.return_type = null;
        this.mtc.return_value = null;
        this.mtc.is_alive = false;
        this.mtc.stop_requested = false;
        this.mtc.process_killed = false;
        this.mtc.create_requestor = null;
        this.mtc.location_str = null;
        this.mtc.done_requestors = MainController.init_requestors(null);
        this.mtc.killed_requestors = MainController.init_requestors(null);
        this.mtc.cancel_done_sent_for = MainController.init_requestors(null);
        this.mtc.kill_timer = null;
        this.init_connections(this.mtc);
        this.add_component(this.mtc);
        this.add_component_to_host(host, this.mtc);
        ++host.n_active_components;
        this.system = new ComponentStruct();
        this.system.comp_ref = 2;
        this.system.comp_name = "SYSTEM";
        this.system.log_source = null;
        this.system.comp_location = null;
        this.system.tc_state = tc_state_enum.TC_SYSTEM;
        this.system.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
        this.system.verdict_reason = null;
        this.system.text_buf = null;
        this.system.return_type = null;
        this.system.return_value = null;
        this.system.is_alive = false;
        this.system.stop_requested = false;
        this.system.process_killed = false;
        this.system.done_requestors = MainController.init_requestors(null);
        this.system.killed_requestors = MainController.init_requestors(null);
        this.system.cancel_done_sent_for = MainController.init_requestors(null);
        this.system.kill_timer = null;
        this.init_connections(this.system);
        this.add_component(this.system);
        this.mc_state = mcStateEnum.MC_CREATING_MTC;
        this.status_change();
        this.unlock();
    }

    private void process_error(unknown_connection connection) {
        Text_Buf text_buf = connection.text_buf;
        String reason = text_buf.pull_string();
        this.error(MessageFormat.format("Error message was received on an unknown connection from {0} [{1}]: {2}", connection.ip_address.getHostName(), connection.ip_address.getHostAddress(), reason));
        text_buf.cut_message();
        this.status_change();
    }

    private void process_error(ComponentStruct tc) {
        Text_Buf text_buf = tc.text_buf;
        String reason = text_buf.pull_string();
        if (tc.equals(this.mtc)) {
            this.error(MessageFormat.format("Error message was received from the MTC at {0} [{1}]: {2}", this.mtc.comp_location.hostname, this.mtc.comp_location.ip_address.getHostAddress(), reason));
        } else {
            this.notify(MessageFormat.format("Error message was received from PTC {0} at {1} [{2}]: {3}", tc.comp_ref, tc.comp_location.hostname, tc.comp_location.ip_address.getHostAddress(), reason));
        }
    }

    private void process_error(Host hc) {
        Text_Buf text_buf = hc.text_buf;
        String reason = text_buf.pull_string();
        this.error(MessageFormat.format("Error message was received from HC at {0} [{1}]: {2}", hc.hostname, hc.ip_address.getHostAddress(), reason));
    }

    private void send_create_mtc(Host host) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(2);
        this.send_message(host.socket, text_buf);
    }

    private void handle_hc_data(Host hc, boolean receive_from_socket) {
        Text_Buf text_buf = hc.text_buf;
        boolean error_flag = false;
        int recv_len = MainController.receive_to_buffer(hc.socket, text_buf, receive_from_socket);
        if (recv_len >= 0) {
            try {
                while (text_buf.is_message()) {
                    int msg_len = text_buf.pull_int().get_int();
                    int msg_type = text_buf.pull_int().get_int();
                    switch (msg_type) {
                        case 0: {
                            this.process_error(hc);
                            break;
                        }
                        case 1: {
                            this.process_log(hc);
                            break;
                        }
                        case 200: {
                            this.process_configure_ack(hc);
                            break;
                        }
                        case 201: {
                            this.process_configure_nak(hc);
                            break;
                        }
                        case 4: {
                            this.process_create_nak(hc);
                            break;
                        }
                        case 5: {
                            this.process_hc_ready(hc);
                            break;
                        }
                        case 100: {
                            break;
                        }
                        default: {
                            this.error(MessageFormat.format("Invalid message type ({0}) was received on HC connection from {1} [{2}].", msg_type, hc.hostname, hc.ip_address.getHostAddress()));
                            error_flag = true;
                        }
                    }
                    if (!error_flag) {
                        text_buf.cut_message();
                        continue;
                    }
                    break;
                }
            }
            catch (TtcnError tc_error) {
                this.error(MessageFormat.format("Malformed message was received on HC connection from {0} [{1}].", hc.hostname, hc.ip_address.getHostAddress()));
                error_flag = true;
            }
            if (error_flag) {
                this.send_error_str(hc.socket, MESSAGE_WAS_NOT_UNDERSTOOD);
            }
        } else if (recv_len == -1) {
            if (hc.hc_state == hc_state_enum.HC_EXITING) {
                this.close_hc_connection(hc);
                if (this.mc_state == mcStateEnum.MC_SHUTDOWN && this.all_hc_in_state(hc_state_enum.HC_DOWN)) {
                    this.mc_state = mcStateEnum.MC_INACTIVE;
                } else {
                    this.error(MessageFormat.format("Unexpected end of HC connection from {0} [{1}].", hc.hostname, hc.ip_address.getHostAddress()));
                    error_flag = true;
                }
            }
        } else {
            this.error(MessageFormat.format("Receiving of data failed on HC connection from {0} [{1}].", hc.hostname, hc.ip_address.getHostAddress()));
            error_flag = true;
        }
        if (error_flag) {
            this.close_hc_connection(hc);
            switch (this.mc_state) {
                case MC_INACTIVE: 
                case MC_LISTENING: 
                case MC_LISTENING_CONFIGURED: {
                    this.fatal_error("MC is in invalid state when a HC connection terminated.");
                    break;
                }
                case MC_HC_CONNECTED: {
                    if (!this.all_hc_in_state(hc_state_enum.HC_DOWN)) break;
                    this.mc_state = mcStateEnum.MC_LISTENING;
                    break;
                }
                case MC_RECONFIGURING: 
                case MC_CONFIGURING: {
                    this.check_all_hc_configured();
                    break;
                }
                case MC_ACTIVE: {
                    if (this.all_hc_in_state(hc_state_enum.HC_DOWN)) {
                        this.mc_state = mcStateEnum.MC_LISTENING_CONFIGURED;
                        break;
                    }
                    if (this.is_hc_in_state(hc_state_enum.HC_ACTIVE) || this.is_hc_in_state(hc_state_enum.HC_OVERLOADED)) break;
                    this.mc_state = mcStateEnum.MC_HC_CONNECTED;
                    break;
                }
                default: {
                    if (this.is_hc_in_state(hc_state_enum.HC_ACTIVE)) break;
                    this.notify("There is no active HC connection. Further create operations will fail.");
                }
            }
            this.status_change();
        }
    }

    private void process_configure_nak(Host hc) {
        switch (hc.hc_state) {
            case HC_CONFIGURING: 
            case HC_CONFIGURING_OVERLOADED: {
                hc.hc_state = hc_state_enum.HC_IDLE;
                break;
            }
            default: {
                this.send_error_str(hc.socket, "Unexpected message CONFIGURE_NAK was received.");
                return;
            }
        }
        if (this.mc_state == mcStateEnum.MC_CONFIGURING || this.mc_state == mcStateEnum.MC_RECONFIGURING) {
            this.check_all_hc_configured();
        } else {
            this.notify(MessageFormat.format("Processing of configuration file failed on host {0}.", hc.hostname));
        }
        this.status_change();
    }

    private void process_create_nak(Host hc) {
        switch (this.mc_state) {
            case MC_CREATING_MTC: 
            case MC_EXECUTING_TESTCASE: 
            case MC_TERMINATING_TESTCASE: {
                break;
            }
            default: {
                this.send_error(hc.socket, "Message CREATE_NAK arrived in invalid state.");
                return;
            }
        }
        switch (hc.hc_state) {
            case HC_ACTIVE: {
                this.notify(MessageFormat.format("Host {0} is overloaded. New components will not be created there until further notice.", hc.hostname));
            }
            case HC_OVERLOADED: {
                break;
            }
            default: {
                this.send_error(hc.socket, "Unexpected message CREATE_NAK was received: the sender is in invalid state.");
                return;
            }
        }
        Text_Buf text_buf = hc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(hc.socket, "Message CREATE_NAK refers to the null component reference.");
                return;
            }
            case 2: {
                this.send_error(hc.socket, "Message CREATE_NAK refers to the component reference of the system.");
                return;
            }
            case -1: {
                this.send_error(hc.socket, "Message CREATE_NAK refers to 'any component'.");
                return;
            }
            case -2: {
                this.send_error(hc.socket, "Message CREATE_NAK refers to 'all component'.");
                return;
            }
        }
        ComponentStruct tc = this.lookup_component(component_reference);
        if (tc == null) {
            this.send_error(hc.socket, MessageFormat.format("Message CREATE_NAK refers to invalid component reference {0}.", component_reference));
            return;
        }
        if (tc.tc_state != tc_state_enum.TC_INITIAL) {
            this.send_error(hc.socket, MessageFormat.format("Message CREATE_NAK refers to test component {0}, which is not being created.", component_reference));
            return;
        }
        if (tc.comp_location != hc) {
            this.send_error(hc.socket, MessageFormat.format("Message CREATE_NAK refers to test component {0}, which was assigned to a different host ({1}).", component_reference, tc.comp_location.hostname));
            return;
        }
        MainController.remove_component_from_host(tc);
        --hc.n_active_components;
        String reason = text_buf.pull_string();
        if (tc == this.mtc) {
            if (this.mc_state != mcStateEnum.MC_CREATING_MTC) {
                this.fatal_error("MainController::process_create_nak: MC is in unexpected state when CREATE_NAK refers to MTC.");
            }
            this.error(MessageFormat.format("Creation of MTC failed on host {0}: {1}.", hc.hostname, reason));
            this.destroy_all_components();
            this.mc_state = mcStateEnum.MC_ACTIVE;
        } else {
            Host new_host = this.choose_ptc_location(tc.comp_type.definition_name, tc.comp_name, tc.location_str);
            if (new_host != null) {
                this.send_create_ptc(new_host, component_reference, tc.comp_type.module_name, tc.comp_type.definition_name, this.system.comp_type, tc.comp_name, tc.is_alive ? 1 : 0, this.mtc.tc_fn_name);
                this.notify(MessageFormat.format("PTC with component reference {0} was relocated from host {1} to {2} because of overload: {3}.", component_reference, hc.hostname, new_host.hostname, reason));
                this.add_component_to_host(new_host, tc);
                ++new_host.n_active_components;
            } else {
                String component_data = MessageFormat.format("component type: {0}.{1}", tc.comp_type.module_name, tc.comp_type.definition_name);
                if (tc.comp_name != null) {
                    component_data = component_data + MessageFormat.format(", name: {0}", tc.comp_name);
                }
                if (tc.location_str != null && tc.location_str.startsWith("\u0000")) {
                    component_data = component_data + MessageFormat.format(", location: {0}", tc.location_str);
                }
                ComponentStruct create_requestor = tc.create_requestor;
                if (create_requestor.tc_state == tc_state_enum.TC_CREATE) {
                    this.send_error(tc.socket, MessageFormat.format("Creation of the new PTC ({0}) failed on host {1}: {2}. Other suitable hosts to relocate the component are not available.", component_data, hc.hostname, reason));
                    create_requestor.tc_state = create_requestor == this.mtc ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
                }
                tc.location_str = null;
                tc.tc_state = tc_state_enum.PTC_STALE;
                --this.n_active_ptcs;
                switch (this.mtc.tc_state) {
                    case MTC_TERMINATING_TESTCASE: {
                        if (!this.ready_to_finish_testcase()) break;
                        this.finish_testcase();
                        break;
                    }
                    case MTC_ALL_COMPONENT_KILL: {
                        this.check_all_component_kill();
                        break;
                    }
                    case MTC_ALL_COMPONENT_STOP: {
                        this.check_all_component_stop();
                        break;
                    }
                }
                this.notify(MessageFormat.format("Creation of a PTC ({0}) failed on host {1}: {2}. Relocation to other suitable host is not possible.", component_data, hc.hostname, reason));
            }
        }
        this.status_change();
    }

    private void process_hc_ready(Host hc) {
        switch (hc.hc_state) {
            case HC_OVERLOADED: {
                hc.hc_state = hc_state_enum.HC_ACTIVE;
                break;
            }
            case HC_CONFIGURING_OVERLOADED: {
                hc.hc_state = hc_state_enum.HC_CONFIGURING;
                break;
            }
            default: {
                this.send_error(hc.socket, "Unexpected message HC_READY was received.");
                return;
            }
        }
        this.notify(MessageFormat.format("Host {0} is no more overloaded.", hc.hostname));
        this.status_change();
    }

    private void send_error(SocketChannel channel, String reason) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(0);
        text_buf.push_string(reason);
        this.send_message(channel, text_buf);
    }

    private void send_error_str(SocketChannel channel, String reason) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(0);
        text_buf.push_string(reason);
        this.send_message(channel, text_buf);
    }

    private void process_create_req(ComponentStruct tc) {
        if (!this.request_allowed(this.mtc, "CREATE_REQ")) {
            return;
        }
        if (this.max_ptcs >= 0 && this.n_active_ptcs >= this.max_ptcs) {
            this.send_error(tc.socket, MessageFormat.format("The license key does not allow more than {0} simultaneously active PTCs.", this.max_ptcs));
        }
        Text_Buf text_buf = tc.text_buf;
        String componentTypeModule = text_buf.pull_string();
        String componentTypeName = text_buf.pull_string();
        String componentName = text_buf.pull_string();
        String componentLocation = text_buf.pull_string();
        int isAlive = text_buf.pull_int().get_int();
        int upper_int = text_buf.pull_int().get_int();
        int lower_int = text_buf.pull_int().get_int();
        this.testcase_start_time_seconds = upper_int * -1 + lower_int;
        this.testcase_start_time_microseconds = text_buf.pull_int().get_int();
        Host ptcLoc = this.choose_ptc_location(componentTypeName, componentName, componentLocation);
        if (ptcLoc == null) {
            if (!this.is_hc_in_state(hc_state_enum.HC_ACTIVE)) {
                this.send_error(tc.socket, "There is no active HC connection. Create operation cannot be performed.");
            } else {
                String compData = "component type: " + componentTypeModule + "." + componentTypeName;
                if (componentName != null) {
                    compData = compData + ", name: " + componentName;
                }
                if (componentLocation != null) {
                    compData = compData + ", location: " + componentLocation;
                }
                this.send_error(tc.socket, MessageFormat.format("No suitable host was found to create a new PTC ({0}).", compData));
            }
            return;
        }
        int comp_ref = this.next_comp_ref++;
        this.send_create_ptc(ptcLoc, comp_ref, componentTypeModule, componentTypeName, this.system.comp_type, componentName, isAlive, this.mtc.tc_fn_name);
        tc.tc_state = tc_state_enum.TC_CREATE;
        ComponentStruct new_ptc = new ComponentStruct();
        new_ptc.comp_ref = comp_ref;
        new_ptc.comp_type = new QualifiedName(componentTypeModule, componentTypeName);
        new_ptc.comp_name = componentName;
        new_ptc.comp_location = ptcLoc;
        new_ptc.tc_state = tc_state_enum.TC_INITIAL;
        new_ptc.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
        new_ptc.verdict_reason = null;
        new_ptc.socket = null;
        new_ptc.text_buf = null;
        new_ptc.tc_fn_name = new QualifiedName("", "");
        new_ptc.return_type = null;
        new_ptc.return_value = null;
        new_ptc.is_alive = isAlive == 1;
        new_ptc.stop_requested = false;
        new_ptc.process_killed = false;
        new_ptc.create_requestor = tc;
        new_ptc.location_str = componentLocation;
        new_ptc.done_requestors = MainController.init_requestors(null);
        new_ptc.killed_requestors = MainController.init_requestors(null);
        new_ptc.cancel_done_sent_for = MainController.init_requestors(null);
        new_ptc.kill_timer = null;
        this.init_connections(new_ptc);
        this.add_component(new_ptc);
        this.add_component_to_host(ptcLoc, new_ptc);
        ++ptcLoc.n_active_components;
        ++this.n_active_ptcs;
        this.status_change();
    }

    private Host choose_ptc_location(String componentTypeName, String componentName, String componentLocation) {
        Host best_candidate = null;
        int load_on_best_candidate = 0;
        boolean has_constraint = this.assigned_components.contains(componentTypeName) || this.assigned_components.contains(componentName);
        HostGroupStruct group = componentLocation != null && !componentLocation.isEmpty() ? this.lookup_host_group(componentLocation) : null;
        for (Host host : this.hosts) {
            if (host.hc_state != hc_state_enum.HC_ACTIVE || best_candidate != null && host.n_active_components >= load_on_best_candidate || (componentLocation != null && !componentLocation.isEmpty() ? (group != null ? !MainController.member_of_group(host, group) : !MainController.host_has_name(host, componentLocation)) : (has_constraint ? !host.allowed_components.contains(componentTypeName) && !host.allowed_components.contains(componentName) : this.all_components_assigned && !host.all_components_allowed))) continue;
            best_candidate = host;
            load_on_best_candidate = host.n_active_components;
        }
        return best_candidate;
    }

    private void send_create_ptc(Host host, int comp_ref, String componentTypeModule, String componentTypeName, QualifiedName comp_type, String componentName, int isAlive, QualifiedName tc_fn_name) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(3);
        text_buf.push_int(comp_ref);
        text_buf.push_string(componentTypeModule);
        text_buf.push_string(componentTypeName);
        text_buf.push_string(comp_type.module_name);
        text_buf.push_string(comp_type.definition_name);
        text_buf.push_string(componentName);
        text_buf.push_int(isAlive);
        text_buf.push_string(this.mtc.tc_fn_name.module_name);
        text_buf.push_string(this.mtc.tc_fn_name.definition_name);
        int upper_int = (int)(this.testcase_start_time_seconds / -1L);
        int lower_int = (int)(this.testcase_start_time_seconds % -1L);
        text_buf.push_int(upper_int);
        text_buf.push_int(lower_int);
        text_buf.push_int(this.testcase_start_time_microseconds);
        this.send_message(host.socket, text_buf);
    }

    private void process_configure_ack(Host hc) {
        switch (hc.hc_state) {
            case HC_CONFIGURING: {
                hc.hc_state = hc_state_enum.HC_ACTIVE;
                break;
            }
            case HC_CONFIGURING_OVERLOADED: {
                hc.hc_state = hc_state_enum.HC_OVERLOADED;
                break;
            }
            default: {
                this.send_error_str(hc.socket, "Unexpected message CONFIGURE_ACK was received.");
            }
        }
        if (this.mc_state == mcStateEnum.MC_CONFIGURING || this.mc_state == mcStateEnum.MC_RECONFIGURING) {
            this.check_all_hc_configured();
        } else {
            this.notify(MessageFormat.format("Host {0} was configured successfully.", hc.hostname));
        }
        this.status_change();
    }

    private void check_all_hc_configured() {
        boolean reconf;
        boolean bl = reconf = this.mc_state == mcStateEnum.MC_RECONFIGURING;
        if (this.is_hc_in_state(hc_state_enum.HC_CONFIGURING) || this.is_hc_in_state(hc_state_enum.HC_CONFIGURING_OVERLOADED)) {
            return;
        }
        if (this.is_hc_in_state(hc_state_enum.HC_IDLE)) {
            this.error("There were errors during configuring HCs.");
            this.mc_state = reconf ? mcStateEnum.MC_READY : mcStateEnum.MC_HC_CONNECTED;
        } else if (this.is_hc_in_state(hc_state_enum.HC_ACTIVE) || this.is_hc_in_state(hc_state_enum.HC_OVERLOADED)) {
            this.notify("Configuration file was processed on all HCs.");
            this.mc_state = reconf ? mcStateEnum.MC_READY : mcStateEnum.MC_ACTIVE;
        } else {
            this.error("There is no HC connection after processing the configuration file.");
            this.mc_state = mcStateEnum.MC_LISTENING;
        }
    }

    private void add_component_to_host(Host host, ComponentStruct component) {
        int i;
        component.log_source = component.comp_ref == 1 ? MessageFormat.format("MTC@{0}", host.hostname_local) : (component.comp_name != null ? MessageFormat.format("{0}({1})@{2}", component.comp_name, component.comp_ref, host.hostname_local) : MessageFormat.format("{0}@{1}", component.comp_ref, host.hostname_local));
        component.comp_location = host;
        for (i = host.components.size(); i > 0 && host.components.get(i - 1) >= component.comp_ref; --i) {
            if (host.components.get(i - 1) != component.comp_ref) continue;
            return;
        }
        host.components.add(i, component.comp_ref);
    }

    private static void remove_component_from_host(ComponentStruct component) {
        component.log_source = null;
        Host host = component.comp_location;
        if (host != null) {
            int i;
            for (i = host.components.size() - 1; i >= 0 && host.components.get(i) != component.comp_ref; --i) {
                if (host.components.get(i) >= component.comp_ref) continue;
                return;
            }
            if (i < 0) {
                return;
            }
            host.components.remove(i);
        }
    }

    private void close_hc_connection(Host hc) {
        if (hc.hc_state != hc_state_enum.HC_DOWN) {
            try {
                hc.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel_table.remove(hc.socket);
            hc.socket = null;
            hc.text_buf = null;
            hc.hc_state = hc_state_enum.HC_DOWN;
        }
    }

    private boolean is_hc_in_state(hc_state_enum checked_state) {
        for (Host host : this.hosts) {
            if (host.hc_state != checked_state) continue;
            return true;
        }
        return false;
    }

    private boolean all_hc_in_state(hc_state_enum checked_state) {
        for (Host host : this.hosts) {
            if (host.hc_state == checked_state) continue;
            return false;
        }
        return true;
    }

    private static int receive_to_buffer(SocketChannel channel, Text_Buf text_buf, boolean receive_from_socket) {
        if (!receive_from_socket) {
            return 1;
        }
        AtomicInteger buf_ptr = new AtomicInteger();
        AtomicInteger buf_len = new AtomicInteger();
        text_buf.get_end(buf_ptr, buf_len);
        ByteBuffer tempbuffer = ByteBuffer.allocate(1024);
        int recv_len = 0;
        try {
            recv_len = channel.read(tempbuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TtcnError(e);
        }
        if (recv_len > 0) {
            text_buf.push_raw(recv_len, tempbuffer.array());
        }
        return recv_len;
    }

    private boolean check_version(unknown_connection connection) {
        Text_Buf text_buf = connection.text_buf;
        int version_major = text_buf.pull_int().get_int();
        int version_minor = text_buf.pull_int().get_int();
        int version_patchlevel = text_buf.pull_int().get_int();
        if (version_major != 11 || version_minor != 1 || version_patchlevel != 0) {
            this.send_error(connection.channel, MessageFormat.format("Version mismatch: The TTCN-3 Main Controller has version {0}, but the ETS was built with version {1}.{2}.pl{3}.", "11.1.0", version_major, version_minor, version_patchlevel));
            return true;
        }
        int version_build_number = text_buf.pull_int().get_int();
        if (version_build_number != 0) {
            if (version_build_number > 0) {
                this.send_error(connection.channel, MessageFormat.format("Build number mismatch: The TTCN-3 Main Controller has version {0}, but the ETS was built with {1}.{2}.pre{3} build {4}.", "11.1.0", version_major, version_minor, version_patchlevel, version_build_number));
            } else {
                this.send_error(connection.channel, MessageFormat.format("Build number mismatch: The TTCN-3 Main Controller has version {0}, but the ETS was built with {1}.{2}.pl{3}.", "11.1.0", version_major, version_minor, version_patchlevel));
            }
            return true;
        }
        if (!this.modules.isEmpty()) {
            int new_modules_size = text_buf.pull_int().get_int();
            if (this.modules.size() != new_modules_size) {
                this.send_error(connection.channel, MessageFormat.format("The number of modules in this ETS ({0}) differs from the number of modules in the firstly connected ETS ({1}).", new_modules_size, this.modules.size()));
                return true;
            }
            for (int i = 0; i < new_modules_size; ++i) {
                byte[] module_checksum;
                String module_name = text_buf.pull_string();
                module_version_info other_module = null;
                for (int j = 0; j < this.modules.size(); ++j) {
                    if (!module_name.equals(this.modules.get((int)j).module_name)) continue;
                    other_module = this.modules.get(j);
                    break;
                }
                if (other_module == null) {
                    this.send_error(connection.channel, MessageFormat.format("The module number {0} in this ETS ({1}) has different name than any other module in the firstly connected ETS.", i, module_name));
                    return true;
                }
                boolean checksum_differs = false;
                int checksum_length = text_buf.pull_int().get_int();
                if (checksum_length > 0) {
                    module_checksum = new byte[checksum_length];
                    text_buf.pull_raw(checksum_length, module_checksum);
                } else {
                    module_checksum = null;
                }
                if (checksum_length != other_module.module_checksum.length) {
                    this.send_error(connection.channel, MessageFormat.format("The checksum of module {0} in this ETS has different length ({1}) than that of the firstly connected ETS ({2}).", module_name, checksum_length, other_module.module_checksum.length));
                    return true;
                }
                if (!Arrays.equals(module_checksum, other_module.module_checksum)) {
                    for (int j = 0; j < checksum_length; ++j) {
                        if (module_checksum[j] == other_module.module_checksum[j]) continue;
                        this.send_error(connection.channel, MessageFormat.format("At index {0} the checksum of module {1} in this ETS is different ({2}) than that of the firstly connected ETS ({3}).", j, module_name, module_checksum[j], other_module.module_checksum[j]));
                        checksum_differs = true;
                    }
                    if (checksum_differs) {
                        this.send_error(connection.channel, MessageFormat.format("The checksum of module {0} in this ETS is different than that of the firstly connected ETS.", module_name));
                    }
                }
                if (!checksum_differs) continue;
                return true;
            }
        } else {
            int modules_size = text_buf.pull_int().get_int();
            for (int i = 0; i < modules_size; ++i) {
                module_version_info temp_info = new module_version_info();
                temp_info.module_name = text_buf.pull_string();
                int checksum_length = text_buf.pull_int().get_int();
                if (checksum_length > 0) {
                    temp_info.module_checksum = new byte[checksum_length];
                    text_buf.pull_raw(checksum_length, temp_info.module_checksum);
                } else {
                    temp_info.module_checksum = new byte[0];
                }
                this.modules.add(temp_info);
            }
        }
        return false;
    }

    private void process_version(unknown_connection connection) {
        if (this.check_version(connection)) {
            this.error(MessageFormat.format("HC connection from {0} [{1}] was refused because of incorrect version.", connection.ip_address.getCanonicalHostName(), connection.ip_address.getHostAddress()));
            this.close_unknown_connection(connection);
            return;
        }
        Host hc = this.add_new_host(connection);
        switch (this.mc_state) {
            case MC_LISTENING: {
                this.mc_state = mcStateEnum.MC_HC_CONNECTED;
                break;
            }
            case MC_HC_CONNECTED: {
                break;
            }
            case MC_LISTENING_CONFIGURED: 
            case MC_ACTIVE: {
                this.configure_host(hc, true);
                this.mc_state = mcStateEnum.MC_CONFIGURING;
                break;
            }
            case MC_SHUTDOWN: {
                this.send_exit_hc(hc);
                hc.hc_state = hc_state_enum.HC_EXITING;
                break;
            }
            default: {
                this.configure_host(hc, true);
            }
        }
        this.handle_hc_data(hc, false);
        this.status_change();
    }

    private Host add_new_host(unknown_connection connection) {
        Text_Buf text_buf = connection.text_buf;
        SocketChannel channel = connection.channel;
        Host hc = new Host();
        hc.ip_address = channel.socket().getInetAddress();
        hc.hostname = hc.ip_address.getCanonicalHostName();
        hc.hostname_local = text_buf.pull_string();
        hc.machine_type = text_buf.pull_string();
        hc.system_name = text_buf.pull_string();
        hc.system_release = text_buf.pull_string();
        hc.system_version = text_buf.pull_string();
        for (int i = 0; i < TTCN_Communication.transport_type_enum.TRANSPORT_NUM.ordinal(); ++i) {
            hc.transport_supported[i] = false;
        }
        int n_supported_transports = text_buf.pull_int().get_int();
        for (int i = 0; i < n_supported_transports; ++i) {
            int transport_type = text_buf.pull_int().get_int();
            if (transport_type >= 0 && transport_type < TTCN_Communication.transport_type_enum.TRANSPORT_NUM.ordinal()) {
                if (hc.transport_supported[transport_type]) {
                    this.send_error(channel, MessageFormat.format("Malformed VERSION message was received: Transport type {0}  was specified more than once.", TTCN_Communication.transport_type_enum.values()[transport_type].toString()));
                    continue;
                }
                hc.transport_supported[transport_type] = true;
                continue;
            }
            this.send_error(channel, MessageFormat.format("Malformed VERSION message was received: Transport type code {0} is invalid.", transport_type));
        }
        if (!hc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL.ordinal()]) {
            this.send_error(channel, MessageFormat.format("Malformed VERSION message was received: Transport type {0}  must be supported anyway.", TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL.toString()));
        }
        if (!hc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM.ordinal()]) {
            this.send_error(channel, MessageFormat.format("Malformed VERSION message was received: Transport type {0}  must be supported anyway.", TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM.toString()));
        }
        if (hc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_UNIX_STREAM.ordinal()]) {
            hc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_UNIX_STREAM.ordinal()] = false;
        }
        hc.log_source = MessageFormat.format("HC@{0}", hc.hostname_local);
        hc.hc_state = hc_state_enum.HC_IDLE;
        hc.socket = channel;
        hc.text_buf = text_buf;
        this.add_allowed_components(hc);
        hc.n_active_components = 0;
        text_buf.cut_message();
        this.delete_unknown_connection(connection);
        this.hosts.add(hc);
        channel_table_struct new_struct = new channel_table_struct();
        new_struct.channel_type = channel_type_enum.CHANNEL_HC;
        new_struct.host = hc;
        this.channel_table.put(channel, new_struct);
        this.notify(MessageFormat.format("New HC connected from {0} [{1}]. {2}: {3} {4} on {5}.", hc.hostname, hc.ip_address.getHostAddress(), hc.hostname_local, hc.system_name, hc.system_release, hc.machine_type));
        return hc;
    }

    public void configure(String config_file_content) {
        this.lock();
        switch (this.mc_state) {
            case MC_HC_CONNECTED: 
            case MC_ACTIVE: {
                this.mc_state = mcStateEnum.MC_CONFIGURING;
                break;
            }
            case MC_LISTENING: 
            case MC_LISTENING_CONFIGURED: {
                this.mc_state = mcStateEnum.MC_LISTENING_CONFIGURED;
                break;
            }
            case MC_RECONFIGURING: {
                break;
            }
            default: {
                this.error("MainController::configure: called in wrong state.");
                this.unlock();
                return;
            }
        }
        this.config_str = config_file_content;
        if (this.mc_state == mcStateEnum.MC_CONFIGURING || this.mc_state == mcStateEnum.MC_RECONFIGURING) {
            this.notify("Downloading configuration file to all HCs.");
            for (Host host : this.hosts) {
                this.configure_host(host, false);
            }
        }
        if (this.mc_state == mcStateEnum.MC_RECONFIGURING) {
            this.notify("Downloading configuration file to the MTC.");
            this.configure_mtc();
        }
        this.status_change();
        this.unlock();
    }

    private void configure_mtc() {
        if (this.config_str == null) {
            this.fatal_error("MainController.configure_mtc: no config file");
        }
        if (this.mtc.tc_state == tc_state_enum.TC_IDLE) {
            this.error("MainController.configure_mtc(): MTC is in wrong state.");
        } else {
            this.mtc.tc_state = tc_state_enum.MTC_CONFIGURING;
            this.send_configure_mtc(this.config_str);
        }
    }

    private void send_configure_mtc(String config) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(200);
        text_buf.push_string(config);
        this.send_message(this.mtc.socket, text_buf);
    }

    private void configure_host(Host host, boolean should_notify) {
        hc_state_enum next_state = hc_state_enum.HC_CONFIGURING;
        switch (host.hc_state) {
            case HC_CONFIGURING: 
            case HC_CONFIGURING_OVERLOADED: 
            case HC_EXITING: {
                this.fatal_error(MessageFormat.format("MainController.configure_host(): host {0} is in wrong state.", host.hostname));
                break;
            }
            case HC_DOWN: {
                break;
            }
            case HC_OVERLOADED: {
                next_state = hc_state_enum.HC_CONFIGURING_OVERLOADED;
            }
            default: {
                host.hc_state = next_state;
                if (should_notify) {
                    this.notify(MessageFormat.format("Downloading configuration file to HC on host {0}.", host.hostname));
                }
                this.send_configure(host);
                if (this.mc_state == mcStateEnum.MC_RECONFIGURING) break;
            }
        }
    }

    private void send_configure(Host hc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(200);
        text_buf.push_string(this.config_str);
        this.send_message(hc.socket, text_buf);
    }

    private void send_message(SocketChannel channel, Text_Buf text_buf) {
        text_buf.calculate_length();
        byte[] msg_ptr = text_buf.get_data();
        int msg_len = text_buf.get_len();
        ByteBuffer buffer = ByteBuffer.wrap(msg_ptr, text_buf.get_begin(), msg_len);
        try {
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
        }
        catch (IOException e) {
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            this.error(MessageFormat.format("Sending of message failed:  {0}", error));
        }
    }

    private void process_mtc_created(unknown_connection connection) {
        if (this.mc_state != mcStateEnum.MC_CREATING_MTC) {
            this.send_error(connection.channel, "Message MTC_CREATED arrived in invalid state.");
            this.close_unknown_connection(connection);
            return;
        }
        if (this.mtc == null || this.mtc.tc_state != tc_state_enum.TC_INITIAL) {
            this.fatal_error("MainController::process_mtc_created: MTC is in invalid state.");
            this.close_unknown_connection(connection);
            return;
        }
        this.mc_state = mcStateEnum.MC_READY;
        this.mtc.tc_state = tc_state_enum.TC_IDLE;
        this.mtc.socket = connection.channel;
        channel_table_struct new_struct = new channel_table_struct();
        new_struct.channel_type = channel_type_enum.CHANNEL_TC;
        new_struct.component = this.mtc;
        Text_Buf text_buf = connection.text_buf;
        text_buf.cut_message();
        this.mtc.text_buf = text_buf;
        this.channel_table.put(connection.channel, new_struct);
        this.delete_unknown_connection(connection);
        this.notify("MTC is created.");
        this.handle_tc_data(this.mtc, false);
        this.status_change();
    }

    private void handle_tc_data(ComponentStruct tc, boolean receive_from_socket) {
        Text_Buf text_buf = tc.text_buf;
        boolean close_connection = false;
        int recv_len = MainController.receive_to_buffer(tc.socket, text_buf, receive_from_socket);
        if (recv_len >= 0) {
            try {
                while (text_buf.is_message()) {
                    int msg_len = text_buf.pull_int().get_int();
                    int msg_end = text_buf.get_pos() + msg_len;
                    int msg_type = text_buf.pull_int().get_int();
                    block1 : switch (msg_type) {
                        case 0: {
                            this.process_error(tc);
                            break;
                        }
                        case 1: {
                            this.process_log(tc);
                            break;
                        }
                        case 2: {
                            this.process_create_req(tc);
                            break;
                        }
                        case 3: {
                            this.process_start_req(tc);
                            break;
                        }
                        case 4: {
                            this.process_stop_req(tc);
                            break;
                        }
                        case 5: {
                            this.process_kill_req(tc);
                            break;
                        }
                        case 6: {
                            this.process_is_running(tc);
                            break;
                        }
                        case 7: {
                            this.process_is_alive(tc);
                            break;
                        }
                        case 8: {
                            this.process_done_req(tc);
                            break;
                        }
                        case 9: {
                            this.process_killed_req(tc);
                            break;
                        }
                        case 10: {
                            this.process_cancel_done_ack(tc);
                            break;
                        }
                        case 11: {
                            this.process_connect_req(tc);
                            break;
                        }
                        case 12: {
                            this.process_connect_listen_ack(tc, msg_end);
                            break;
                        }
                        case 13: {
                            this.process_connected(tc);
                            break;
                        }
                        case 14: {
                            this.process_connect_error(tc);
                            break;
                        }
                        case 15: {
                            this.process_disconnect_req(tc);
                            break;
                        }
                        case 16: {
                            this.process_disconnected(tc);
                            break;
                        }
                        case 17: {
                            this.process_map_req(tc);
                            break;
                        }
                        case 18: {
                            this.process_mapped(tc);
                            break;
                        }
                        case 19: {
                            this.process_unmap_req(tc);
                            break;
                        }
                        case 20: {
                            this.process_unmapped(tc);
                            break;
                        }
                        case 100: {
                            break;
                        }
                        case 101: {
                            break;
                        }
                        case 102: {
                            break;
                        }
                        case 103: {
                            break;
                        }
                        default: {
                            if (tc == this.mtc) {
                                switch (msg_type) {
                                    case 21: {
                                        this.process_testcase_started();
                                        break block1;
                                    }
                                    case 22: {
                                        this.process_testcase_finished();
                                        break block1;
                                    }
                                    case 23: {
                                        this.process_mtc_ready();
                                        break block1;
                                    }
                                    case 200: {
                                        this.process_configure_ack_mtc();
                                        break block1;
                                    }
                                    case 201: {
                                        this.process_configure_nak_mtc();
                                        break block1;
                                    }
                                }
                                this.error(MessageFormat.format("Invalid message type ({0}) was received from the MTC at {1} [{2}].", msg_type, this.mtc.comp_location.hostname, this.mtc.comp_location.ip_address.getHostAddress()));
                                close_connection = true;
                                break;
                            }
                            switch (msg_type) {
                                case 21: {
                                    this.process_stopped(tc, msg_end);
                                    break block1;
                                }
                                case 22: {
                                    this.process_stopped_killed(tc, msg_end);
                                    break block1;
                                }
                                case 23: {
                                    this.process_killed(tc);
                                    break block1;
                                }
                            }
                            this.notify(MessageFormat.format("Invalid message type ({0}) was received from PTC {1} at {2} [{3}].", msg_type, tc.comp_ref, tc.comp_location.hostname, tc.comp_location.ip_address.getHostAddress()));
                            close_connection = true;
                        }
                    }
                    if (!close_connection) {
                        text_buf.cut_message();
                        continue;
                    }
                    break;
                }
            }
            catch (TtcnError e) {
                if (tc == this.mtc) {
                    this.error(MessageFormat.format("Malformed message was received from the MTC at {0} [{1}].", this.mtc.comp_location.hostname, this.mtc.comp_location.ip_address.getHostAddress()));
                } else {
                    this.notify(MessageFormat.format("Malformed message was received from PTC {0} at {1} [{2}].", tc.comp_ref, tc.comp_location.hostname, tc.comp_location.ip_address.getHostAddress()));
                }
                close_connection = true;
            }
            if (close_connection) {
                this.send_error(tc.socket, MESSAGE_WAS_NOT_UNDERSTOOD);
            }
        } else if (recv_len == -1) {
            if (tc.tc_state != tc_state_enum.TC_EXITING && !tc.process_killed) {
                if (tc == this.mtc) {
                    this.error(MessageFormat.format("Unexpected end of MTC connection from {0} [{1}].", this.mtc.comp_location.hostname, this.mtc.comp_location.ip_address.getHostAddress()));
                } else {
                    this.notify(MessageFormat.format("Unexpected end of PTC connection {0} from {1} [{2}].", tc.comp_ref, tc.comp_location.hostname, tc.comp_location.ip_address.getHostAddress()));
                }
            }
            close_connection = true;
        } else {
            if (tc == this.mtc) {
                this.error(MessageFormat.format("Receiving of data failed from the MTC at {0} [{1}]", this.mtc.comp_location.hostname, this.mtc.comp_location.ip_address.getHostAddress()));
            } else {
                this.notify(MessageFormat.format("Receiving of data failed from PTC {0} at {1} [{2}]", tc.comp_ref, tc.comp_location.hostname, tc.comp_location.ip_address.getHostAddress()));
            }
            close_connection = true;
        }
        if (close_connection) {
            this.close_tc_connection(tc);
            MainController.remove_component_from_host(tc);
            if (tc == this.mtc) {
                if (this.mc_state != mcStateEnum.MC_TERMINATING_MTC) {
                    this.notify("The control connection to MTC is lost. Destroying all PTC connections.");
                }
                this.destroy_all_components();
                this.notify("MTC terminated");
                this.mc_state = this.is_hc_in_state(hc_state_enum.HC_CONFIGURING) ? mcStateEnum.MC_CONFIGURING : (this.is_hc_in_state(hc_state_enum.HC_IDLE) ? mcStateEnum.MC_HC_CONNECTED : (this.is_hc_in_state(hc_state_enum.HC_ACTIVE) || this.is_hc_in_state(hc_state_enum.HC_OVERLOADED) ? mcStateEnum.MC_ACTIVE : mcStateEnum.MC_LISTENING_CONFIGURED));
                this.stop_requested = false;
            } else {
                if (tc.tc_state != tc_state_enum.TC_EXITING) {
                    tc.local_verdict = TitanVerdictType.VerdictTypeEnum.ERROR;
                    this.component_terminated(tc);
                }
                tc.tc_state = tc_state_enum.TC_EXITED;
                if (this.mc_state == mcStateEnum.MC_TERMINATING_TESTCASE && this.ready_to_finish_testcase()) {
                    this.finish_testcase();
                }
            }
            this.status_change();
        }
    }

    private void close_tc_connection(ComponentStruct component) {
        if (component.socket != null) {
            try {
                component.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel_table.remove(component.socket);
            component.socket = null;
            component.text_buf = null;
        }
        if (component.kill_timer != null) {
            this.cancel_timer(component.kill_timer);
            component.kill_timer = null;
        }
    }

    private boolean ready_to_finish_testcase() {
        block3: for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            switch (comp.tc_state) {
                case TC_EXITED: 
                case PTC_STALE: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void process_stopped(ComponentStruct tc, int msg_end) {
        switch (tc.tc_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_FUNCTION: {
                if (tc.is_alive) break;
            }
            default: {
                this.send_error(tc.socket, "Unexpected message STOPPED was received.");
                return;
            }
        }
        Text_Buf text_buf = tc.text_buf;
        tc.local_verdict = TitanVerdictType.VerdictTypeEnum.values()[text_buf.pull_int().get_int()];
        tc.verdict_reason = text_buf.pull_string();
        tc.return_type = text_buf.pull_string();
        tc.return_value = new byte[msg_end - text_buf.get_pos()];
        text_buf.pull_raw(tc.return_value.length, tc.return_value);
        tc.tc_fn_name = new QualifiedName("", "");
        this.component_stopped(tc);
        this.status_change();
    }

    private void component_stopped(ComponentStruct tc) {
        ComponentStruct requestor;
        tc_state_enum old_state = tc.tc_state;
        if (old_state == tc_state_enum.PTC_STOPPING_KILLING) {
            tc.tc_state = tc_state_enum.PTC_KILLING;
        } else {
            tc.tc_state = tc_state_enum.PTC_STOPPED;
            if (tc.kill_timer != null) {
                this.cancel_timer(tc.kill_timer);
                tc.kill_timer = null;
            }
        }
        switch (this.mc_state) {
            case MC_EXECUTING_TESTCASE: {
                break;
            }
            case MC_TERMINATING_TESTCASE: {
                return;
            }
            default: {
                this.error(MessageFormat.format("PTC {0} stopped in invalid MC state.", tc.comp_ref));
                return;
            }
        }
        if (!tc.is_alive) {
            this.send_error(tc.socket, "Message STOPPED can only be sent by alive PTCs.");
            return;
        }
        boolean send_status_to_mtc = false;
        boolean send_done_to_mtc = false;
        int i = 0;
        while ((requestor = MainController.get_requestor(tc.done_requestors, i)) != null) {
            if (requestor.equals(this.mtc)) {
                send_status_to_mtc = true;
                send_done_to_mtc = true;
            } else {
                this.send_component_status_to_requestor(tc, requestor, true, false);
            }
            ++i;
        }
        if (this.any_component_done_requested) {
            send_status_to_mtc = true;
        }
        boolean all_done_checked = false;
        boolean all_done_result = false;
        if (this.all_component_done_requested) {
            all_done_checked = true;
            boolean bl = all_done_result = !this.is_any_component_running();
            if (all_done_result) {
                send_status_to_mtc = true;
            }
        }
        if (send_status_to_mtc) {
            if (!all_done_checked) {
                boolean bl = all_done_result = !this.is_any_component_running();
            }
            if (send_done_to_mtc) {
                this.send_component_status_mtc(tc.comp_ref, true, false, this.any_component_done_requested, all_done_result, false, false, tc.local_verdict, tc.return_type, tc.return_value);
            } else {
                this.send_component_status_mtc(0, false, false, this.any_component_done_requested, all_done_result, false, false, TitanVerdictType.VerdictTypeEnum.NONE, null, null);
            }
            if (this.any_component_done_requested) {
                this.any_component_done_requested = false;
                this.any_component_done_sent = true;
            }
            if (all_done_result) {
                this.all_component_done_requested = false;
            }
        }
        if (old_state != tc_state_enum.PTC_FUNCTION && this.mtc.tc_state != tc_state_enum.MTC_ALL_COMPONENT_KILL) {
            if (this.mtc.tc_state == tc_state_enum.MTC_ALL_COMPONENT_STOP) {
                this.check_all_component_stop();
            } else {
                this.send_stop_ack_to_requestors(tc);
            }
        }
    }

    private void process_unmapped(ComponentStruct tc) {
        if (!this.message_expected(tc, "UNMAPPED")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        boolean translation = text_buf.pull_int().get_int() != 0;
        String sourcePort = text_buf.pull_string();
        String systemPort = text_buf.pull_string();
        int nof_params = text_buf.pull_int().get_int();
        TitanPort.Map_Params params = new TitanPort.Map_Params(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = text_buf.pull_string();
            params.set_param(i, new TitanCharString(par));
        }
        PortConnection conn = null;
        conn = !translation ? this.find_connection(tc.comp_ref, sourcePort, 2, systemPort) : this.find_connection(2, sourcePort, tc.comp_ref, systemPort);
        if (conn != null) {
            switch (conn.conn_state) {
                case CONN_MAPPING: 
                case CONN_MAPPED: 
                case CONN_UNMAPPING: {
                    this.destroy_mapping(conn, nof_params, params, null);
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("Unexpected MAPPED message was received for port mapping {0}:{1} - system:{2}.", tc.comp_ref, sourcePort, systemPort));
                }
            }
        }
        this.status_change();
    }

    private void process_unmap_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "UNMAP_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int sourceComponent = text_buf.pull_int().get_int();
        boolean translation = text_buf.pull_int().get_int() != 0;
        String sourcePort = text_buf.pull_string();
        String systemPort = text_buf.pull_string();
        if (!this.valid_endpoint(sourceComponent, false, tc, "unmap")) {
            return;
        }
        int nof_params = text_buf.pull_int().get_int();
        TitanPort.Map_Params params = new TitanPort.Map_Params(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = text_buf.pull_string();
            params.set_param(i, new TitanCharString(par));
        }
        PortConnection conn = this.find_connection(sourceComponent, sourcePort, 2, systemPort);
        if (conn == null) {
            this.send_unmap_ack(tc, nof_params, params);
        } else {
            switch (conn.conn_state) {
                case CONN_MAPPED: {
                    this.send_unmap(this.components.get(sourceComponent), sourcePort, systemPort, nof_params, params, translation);
                    conn.conn_state = conn_state_enum.CONN_UNMAPPING;
                }
                case CONN_UNMAPPING: {
                    this.add_requestor(conn.requestors, tc);
                    tc.tc_state = tc_state_enum.TC_UNMAP;
                    this.status_change();
                    break;
                }
                case CONN_MAPPING: {
                    this.send_error(tc.socket, MessageFormat.format("The port mapping {0}:{1} - system:{2} cannot be destroyed because a map operation is in progress on it.", sourceComponent, sourcePort, systemPort));
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("The port mapping {0}:{1} - system:{2} is in invalid state.", sourceComponent, sourcePort, systemPort));
                }
            }
        }
    }

    private void send_unmap(ComponentStruct tc, String sourcePort, String systemPort, int nof_params, TitanPort.Map_Params params, boolean translation) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(19);
        text_buf.push_int(translation ? 1 : 0);
        text_buf.push_string(sourcePort);
        text_buf.push_string(systemPort);
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        this.send_message(tc.socket, text_buf);
    }

    private void process_killed_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "KILLED_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Killed operation was requested on the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Killed operation was requested on the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Killed operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                if (tc.equals(this.mtc)) {
                    boolean answer2 = !this.is_all_component_alive();
                    this.send_killed_ack(this.mtc, answer2);
                    if (!answer2) {
                        this.any_component_killed_requested = true;
                    }
                } else {
                    this.send_error(tc.socket, "Operation 'any component.killed' can only be performed on the MTC.");
                }
                return;
            }
            case -2: {
                if (tc == this.mtc) {
                    boolean answer3 = !this.is_any_component_alive();
                    this.send_killed_ack(this.mtc, answer3);
                    if (!answer3) {
                        this.all_component_killed_requested = true;
                    }
                } else {
                    this.send_error(tc.socket, "Operation 'all component.killed' can only be performed on the MTC.");
                }
                return;
            }
        }
        ComponentStruct comp = this.lookup_component(component_reference);
        if (comp == null) {
            this.send_error(tc.socket, MessageFormat.format("The argument of killed operation is an invalid component reference: {0}.", component_reference));
            return;
        }
        switch (comp.tc_state) {
            case TC_EXITED: 
            case TC_EXITING: {
                this.send_killed_ack(tc, true);
                break;
            }
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: 
            case PTC_STOPPED: {
                this.send_killed_ack(tc, false);
                this.add_requestor(comp.killed_requestors, tc);
                break;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of killed operation ({0}) is a component reference that belongs to an earlier testcase.", component_reference));
                break;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("The test component that the killed operation refers to ({0}) is in invalid state.", component_reference));
            }
        }
    }

    private void send_killed_ack(ComponentStruct tc, boolean answer2) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(9);
        text_buf.push_int(answer2 ? 1 : 0);
        this.send_message(tc.socket, text_buf);
    }

    private void process_done_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "DONE_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Done operation was requested on the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Done operation was requested on the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Done operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                if (tc.equals(this.mtc)) {
                    boolean answer2 = this.is_any_component_done();
                    this.send_done_ack(this.mtc, answer2, TitanVerdictType.VerdictTypeEnum.NONE, null, null);
                    if (answer2) {
                        this.any_component_done_sent = true;
                    } else {
                        this.any_component_done_requested = true;
                    }
                } else {
                    this.send_error(tc.socket, "Operation 'any component.done' can only be performed on the MTC.");
                }
                return;
            }
            case -2: {
                if (tc.equals(this.mtc)) {
                    boolean answer3 = !this.is_any_component_running();
                    this.send_done_ack(this.mtc, answer3, TitanVerdictType.VerdictTypeEnum.NONE, null, null);
                    if (!answer3) {
                        this.all_component_done_requested = true;
                    }
                } else {
                    this.send_error(tc.socket, "Operation 'all component.done' can only be performed on the MTC.");
                }
                return;
            }
        }
        ComponentStruct comp = this.lookup_component(component_reference);
        if (comp == null) {
            this.send_error(tc.socket, MessageFormat.format("The argument of done operation is an invalid component reference: {0}.", component_reference));
            return;
        }
        switch (comp.tc_state) {
            case PTC_STOPPED: {
                this.add_requestor(comp.done_requestors, tc);
            }
            case TC_EXITED: 
            case TC_EXITING: 
            case PTC_KILLING: {
                this.send_done_ack(tc, true, comp.local_verdict, comp.return_type, comp.return_value);
                break;
            }
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                this.send_done_ack(tc, false, TitanVerdictType.VerdictTypeEnum.NONE, null, null);
                this.add_requestor(comp.done_requestors, tc);
                break;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of done operation ({0}) is a component reference that belongs to an earlier testcase.", component_reference));
                break;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("The test component that the done operation refers to ({0}) is in invalid state.", component_reference));
            }
        }
    }

    private void send_done_ack(ComponentStruct tc, boolean answer2, TitanVerdictType.VerdictTypeEnum verdict, String return_type, byte[] return_value) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(8);
        text_buf.push_int(answer2 ? 1 : 0);
        text_buf.push_int(verdict.getValue());
        text_buf.push_string(return_type);
        if (return_value != null) {
            text_buf.push_raw(return_value.length, return_value);
        }
        this.send_message(tc.socket, text_buf);
    }

    private void process_cancel_done_ack(ComponentStruct tc) {
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Message CANCEL_DONE_ACK refers to the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Message CANCEL_DONE_ACK refers to the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Message CANCEL_DONE_ACK refers to the component reference of the system.");
                return;
            }
            case -1: {
                this.send_error(tc.socket, "Message CANCEL_DONE_ACK refers to 'any component'.");
                return;
            }
            case -2: {
                this.send_error(tc.socket, "Message CANCEL_DONE_ACK refers to 'all component'.");
                return;
            }
        }
        ComponentStruct started_tc = this.lookup_component(component_reference);
        if (started_tc == null) {
            this.send_error(tc.socket, MessageFormat.format("Message CANCEL_DONE_ACK refers to an invalid component reference: {0}.", component_reference));
            return;
        }
        this.done_cancelled(tc, started_tc);
        this.remove_requestor(tc.cancel_done_sent_for, started_tc);
    }

    private void process_is_alive(ComponentStruct tc) {
        if (!this.request_allowed(tc, "IS_ALIVE")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Alive operation was requested on the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Alive operation was requested on the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Alive operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                if (tc.equals(this.mtc)) {
                    this.send_alive(this.mtc, this.is_any_component_alive());
                } else {
                    this.send_error(tc.socket, "Operation 'any component.alive' can only be performed on the MTC.");
                }
                return;
            }
            case -2: {
                if (tc.equals(this.mtc)) {
                    this.send_alive(this.mtc, this.is_all_component_alive());
                } else {
                    this.send_error(tc.socket, "Operation 'all component.alive' can only be performed on the MTC.");
                }
                return;
            }
        }
        ComponentStruct comp = this.lookup_component(component_reference);
        if (comp == null) {
            this.send_error(tc.socket, MessageFormat.format("The argument of alive operation is an invalid component reference: {0}.", component_reference));
            return;
        }
        switch (comp.tc_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: 
            case PTC_STOPPED: {
                this.send_alive(tc, true);
                break;
            }
            case TC_EXITED: 
            case TC_EXITING: {
                this.send_alive(tc, false);
                break;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of alive operation ({0}) is a component reference that belongs to an earlier testcase.", component_reference));
                break;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("The test component that the alive operation referes to ({0}) is in invalid state.", component_reference));
            }
        }
    }

    private boolean is_all_component_alive() {
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            if (this.component_is_alive(comp)) continue;
            return false;
        }
        return true;
    }

    private void send_alive(ComponentStruct tc, boolean answer2) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(7);
        text_buf.push_int(answer2 ? 1 : 0);
        this.send_message(tc.socket, text_buf);
    }

    private void process_is_running(ComponentStruct tc) {
        if (!this.request_allowed(tc, "IS_RUNNING")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Running operation was requested on the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Running operation was requested on the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Running operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                if (tc.equals(this.mtc)) {
                    this.send_running(this.mtc, this.is_any_component_running());
                } else {
                    this.send_error(tc.socket, "Operation 'any component.running' can only be performed on the MTC.");
                }
                return;
            }
            case -2: {
                if (tc.equals(this.mtc)) {
                    this.send_running(this.mtc, this.is_all_component_running());
                } else {
                    this.send_error(tc.socket, "Operation 'all component.running' can only be performed on the MTC.");
                }
                return;
            }
        }
        ComponentStruct comp = this.lookup_component(component_reference);
        if (comp == null) {
            this.send_error(tc.socket, MessageFormat.format("The argument of running operation is an invalid component reference: {0}.", component_reference));
            return;
        }
        switch (comp.tc_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_STARTING: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                this.send_running(tc, true);
                break;
            }
            case TC_EXITED: 
            case TC_EXITING: 
            case PTC_KILLING: 
            case TC_IDLE: 
            case PTC_STOPPED: {
                this.send_running(tc, false);
                break;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of running operation ({0}) is a component reference that belongs to an earlier testcase.", component_reference));
                break;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("The test component that the running operation refers to ({0}) is in invalid state.", component_reference));
            }
        }
    }

    private boolean is_all_component_running() {
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct tc = this.components.get(i);
            if (tc.stop_requested) continue;
            switch (tc.tc_state) {
                case TC_EXITED: 
                case TC_EXITING: 
                case PTC_STOPPED: {
                    return false;
                }
            }
        }
        return true;
    }

    private void send_running(ComponentStruct tc, boolean answer2) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(6);
        text_buf.push_int(answer2 ? 1 : 0);
        this.send_message(tc.socket, text_buf);
    }

    private void process_mapped(ComponentStruct tc) {
        if (!this.message_expected(tc, "MAPPED")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        boolean translation = text_buf.pull_int().get_int() != 0;
        String localPort = text_buf.pull_string();
        String systemPort = text_buf.pull_string();
        int nof_params = text_buf.pull_int().get_int();
        TitanPort.Map_Params params = new TitanPort.Map_Params(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = text_buf.pull_string();
            params.set_param(i, new TitanCharString(par));
        }
        PortConnection conn = null;
        conn = !translation ? this.find_connection(tc.comp_ref, localPort, 2, systemPort) : this.find_connection(2, localPort, tc.comp_ref, systemPort);
        if (conn == null) {
            this.send_error(tc.socket, MessageFormat.format("The MAPPED message refers to a non-existent port mapping {0}:{1} - system:{2}.", tc.comp_ref, localPort, systemPort));
        } else if (conn.conn_state != conn_state_enum.CONN_MAPPING && conn.conn_state != conn_state_enum.CONN_MAPPED && translation) {
            this.send_error(tc.socket, MessageFormat.format("Unexpected MAPPED message was received for mapping {0}:{1} - system:{2}.", tc.comp_ref, localPort, systemPort));
        } else {
            ComponentStruct comp;
            int i = 0;
            while ((comp = MainController.get_requestor(conn.requestors, i)) != null) {
                if (comp.tc_state == tc_state_enum.TC_MAP) {
                    this.send_map_ack(comp, nof_params, params);
                    comp.tc_state = comp.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
                }
                ++i;
            }
            MainController.free_requestors(conn.requestors);
            conn.conn_state = conn_state_enum.CONN_MAPPED;
            this.status_change();
        }
    }

    private void process_killed(ComponentStruct tc) {
        switch (tc.tc_state) {
            case PTC_KILLING: 
            case TC_IDLE: 
            case PTC_STOPPED: {
                break;
            }
            default: {
                this.send_error(tc.socket, "Unexpected message KILLED was received.");
                this.notify(MessageFormat.format("Unexpected message KILLED was received from PTC {0}.", tc.comp_ref));
                return;
            }
        }
        Text_Buf text_buf = tc.text_buf;
        tc.local_verdict = TitanVerdictType.VerdictTypeEnum.values()[text_buf.pull_int().get_int()];
        tc.verdict_reason = text_buf.pull_string();
        if (tc.tc_state != tc_state_enum.PTC_KILLING) {
            this.start_kill_timer(tc);
        }
        this.component_terminated(tc);
        this.status_change();
    }

    private void process_configure_nak_mtc() {
        if (this.mtc.tc_state != tc_state_enum.MTC_CONFIGURING) {
            this.send_error(this.mtc.socket, "Unexpected message CONFIGURE_NAK was received.");
            return;
        }
        this.mtc.tc_state = tc_state_enum.TC_IDLE;
        this.notify("Processing of configuration file failed on the MTC.");
    }

    private void process_configure_ack_mtc() {
        if (this.mtc.tc_state != tc_state_enum.MTC_CONFIGURING) {
            this.send_error(this.mtc.socket, "Unexpected message CONFIGURE_ACK was received.");
            return;
        }
        this.mtc.tc_state = tc_state_enum.TC_IDLE;
        this.notify("Configuration file was processed on the MTC.");
    }

    private void process_map_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "MAP_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int sourceComponent = text_buf.pull_int().get_int();
        boolean translation = text_buf.pull_int().get_int() != 0;
        String sourcePort = text_buf.pull_string();
        String systemPort = text_buf.pull_string();
        int nof_params = text_buf.pull_int().get_int();
        if (!this.valid_endpoint(sourceComponent, true, tc, "map")) {
            return;
        }
        TitanPort.Map_Params params = new TitanPort.Map_Params(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = text_buf.pull_string();
            params.set_param(i, new TitanCharString(par));
        }
        PortConnection conn = this.find_connection(sourceComponent, sourcePort, 2, systemPort);
        if (conn == null) {
            this.send_map(this.components.get(sourceComponent), sourcePort, systemPort, nof_params, params, translation);
            conn = new PortConnection();
            conn.headComp = sourceComponent;
            conn.headPort = sourcePort;
            conn.tailComp = 2;
            conn.tailPort = systemPort;
            conn.requestors = MainController.init_requestors(tc);
            conn.conn_state = conn_state_enum.CONN_MAPPING;
            this.add_connection(conn);
            tc.tc_state = tc_state_enum.TC_MAP;
            this.status_change();
        } else {
            switch (conn.conn_state) {
                case CONN_MAPPING: {
                    this.add_requestor(conn.requestors, tc);
                    tc.tc_state = tc_state_enum.TC_MAP;
                    this.status_change();
                    break;
                }
                case CONN_MAPPED: {
                    this.send_map_ack(tc, nof_params, params);
                    break;
                }
                case CONN_UNMAPPING: {
                    this.send_error(tc.socket, MessageFormat.format("The port mapping {0}:{1} - system:{2} cannot be established because an unmap operation is in progress on it.", sourceComponent, sourcePort, systemPort));
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("The port mapping {0}:{1} - system:{2} is in invalid state.", sourceComponent, sourcePort, systemPort));
                }
            }
        }
    }

    private void send_map_ack(ComponentStruct tc, int nof_params, TitanPort.Map_Params params) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(18);
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        this.send_message(tc.socket, text_buf);
    }

    private void send_map(ComponentStruct tc, String sourcePort, String systemPort, int nof_params, TitanPort.Map_Params params, boolean translation) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(17);
        text_buf.push_int(translation ? 1 : 0);
        text_buf.push_string(sourcePort);
        text_buf.push_string(systemPort);
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        this.send_message(tc.socket, text_buf);
    }

    private void process_kill_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "KILL_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Kill operation was requested on the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Kill operation was requested on the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Kill operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                this.send_error(tc.socket, "Kill operation was requested on 'any component'.");
                return;
            }
            case -2: {
                if (tc.equals(this.mtc)) {
                    if (this.kill_all_components(false)) {
                        this.send_kill_ack(this.mtc);
                    } else {
                        this.mtc.tc_state = tc_state_enum.MTC_ALL_COMPONENT_KILL;
                        this.status_change();
                    }
                } else {
                    this.send_error(tc.socket, "Operation 'all component.kill' can only be performed on the MTC.");
                }
                return;
            }
        }
        ComponentStruct target = this.lookup_component(component_reference);
        if (target == null) {
            this.send_error(tc.socket, MessageFormat.format("The argument of kill operation is an invalid component reference: {0}.", component_reference));
            return;
        }
        if (target.equals(tc)) {
            this.send_error(tc.socket, "Kill operation was requested on the requestor component itself.");
            return;
        }
        boolean target_inactive = false;
        switch (target.tc_state) {
            case PTC_STOPPED: {
                MainController.free_requestors(target.done_requestors);
            }
            case TC_IDLE: {
                target_inactive = true;
            }
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                this.send_kill(target);
                if (target_inactive) {
                    target.tc_state = tc_state_enum.PTC_KILLING;
                    if (!target.is_alive) {
                        target.stop_requested = true;
                    }
                } else {
                    target.tc_state = tc_state_enum.PTC_STOPPING_KILLING;
                    target.stop_requested = true;
                }
                target.stop_requestors = MainController.init_requestors(null);
                target.kill_requestors = MainController.init_requestors(tc);
                this.start_kill_timer(target);
                tc.tc_state = tc_state_enum.TC_KILL;
                this.status_change();
                break;
            }
            case TC_STOPPING: {
                this.send_kill(target);
                target.tc_state = tc_state_enum.PTC_STOPPING_KILLING;
                if (target.kill_timer != null) {
                    this.cancel_timer(target.kill_timer);
                }
                this.start_kill_timer(target);
            }
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                this.add_requestor(target.kill_requestors, tc);
                tc.tc_state = tc_state_enum.TC_KILL;
                this.status_change();
                break;
            }
            case TC_EXITED: 
            case TC_EXITING: {
                this.send_kill_ack(tc);
                break;
            }
            case PTC_STARTING: {
                this.send_error(tc.socket, MessageFormat.format("PTC with component reference {0} cannot be killed because it is currently being started.", component_reference));
                break;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of kill operation ({0}) is a component reference that belongs to an earlier testcase.", component_reference));
                break;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("The test component that the kill operation refers to ({0}) is in invalid state.", component_reference));
            }
        }
    }

    private void process_stopped_killed(ComponentStruct tc, int msg_end) {
        switch (tc.tc_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                break;
            }
            default: {
                this.send_error(tc.socket, "Unexpected message STOPPED_KILLED was received.");
                this.notify(MessageFormat.format("Unexpected message STOPPED_KILLED was received from PTC {0}.", tc.comp_ref));
                return;
            }
        }
        Text_Buf text_buf = tc.text_buf;
        tc.local_verdict = TitanVerdictType.VerdictTypeEnum.values()[text_buf.pull_int().get_int()];
        tc.verdict_reason = text_buf.pull_string();
        tc.return_type = text_buf.pull_string();
        tc.return_value = new byte[msg_end - text_buf.get_pos()];
        text_buf.pull_raw(tc.return_value.length, tc.return_value);
        if (tc.tc_state != tc_state_enum.PTC_STOPPING_KILLING) {
            this.start_kill_timer(tc);
        }
        this.component_terminated(tc);
        this.status_change();
    }

    private void component_terminated(ComponentStruct tc) {
        PortConnection conn;
        ComponentStruct comp;
        ComponentStruct requestor;
        tc_state_enum old_state = tc.tc_state;
        tc.tc_state = tc_state_enum.TC_EXITING;
        --this.n_active_ptcs;
        --tc.comp_location.n_active_components;
        switch (this.mc_state) {
            case MC_EXECUTING_TESTCASE: {
                break;
            }
            case MC_TERMINATING_TESTCASE: {
                return;
            }
            default: {
                this.error(MessageFormat.format("PTC {0} terminated in invalid MC state.", tc.comp_ref));
                return;
            }
        }
        boolean send_status_to_mtc = false;
        boolean send_done_to_mtc = true;
        int i = 0;
        while ((requestor = MainController.get_requestor(tc.done_requestors, i)) != null) {
            if (requestor.equals(this.mtc)) {
                send_status_to_mtc = true;
                send_done_to_mtc = true;
            } else {
                this.send_component_status_to_requestor(tc, requestor, true, true);
            }
            ++i;
        }
        i = 0;
        while ((requestor = MainController.get_requestor(tc.killed_requestors, i)) != null) {
            if (requestor.equals(this.mtc)) {
                send_status_to_mtc = true;
            } else if (!MainController.has_requestor(tc.done_requestors, requestor)) {
                this.send_component_status_to_requestor(tc, requestor, false, true);
            }
            ++i;
        }
        MainController.free_requestors(tc.done_requestors);
        MainController.free_requestors(tc.killed_requestors);
        if (this.any_component_done_requested || this.any_component_killed_requested) {
            send_status_to_mtc = true;
        }
        boolean all_done_checked = false;
        boolean all_done_result = false;
        if (this.all_component_done_requested) {
            all_done_checked = true;
            boolean bl = all_done_result = !this.is_any_component_running();
            if (all_done_result) {
                send_status_to_mtc = true;
            }
        }
        boolean all_killed_checked = false;
        boolean all_killed_result = false;
        if (this.all_component_killed_requested) {
            all_killed_checked = true;
            boolean bl = all_killed_result = !this.is_any_component_alive();
            if (all_killed_result) {
                send_status_to_mtc = true;
            }
        }
        if (send_status_to_mtc) {
            if (!all_done_checked) {
                boolean bl = all_done_result = !this.is_any_component_running();
            }
            if (!all_killed_checked) {
                boolean bl = all_killed_result = !this.is_any_component_alive();
            }
            if (send_done_to_mtc) {
                this.send_component_status_mtc(tc.comp_ref, true, true, true, all_done_result, true, all_killed_result, tc.local_verdict, tc.return_type, tc.return_value);
            } else {
                this.send_component_status_mtc(tc.comp_ref, false, true, true, all_done_result, true, all_killed_result, TitanVerdictType.VerdictTypeEnum.NONE, null, null);
            }
            this.any_component_done_requested = false;
            this.any_component_done_sent = true;
            this.any_component_killed_requested = false;
            if (all_done_result) {
                this.all_component_done_requested = false;
            }
            if (all_killed_result) {
                this.all_component_killed_requested = false;
            }
        }
        switch (old_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                if (this.mtc.tc_state == tc_state_enum.MTC_ALL_COMPONENT_KILL) {
                    this.check_all_component_kill();
                    break;
                }
                if (this.mtc.tc_state == tc_state_enum.MTC_ALL_COMPONENT_STOP) {
                    this.check_all_component_stop();
                    break;
                }
                this.send_stop_ack_to_requestors(tc);
                this.send_kill_ack_to_requestors(tc);
                break;
            }
        }
        int i2 = 0;
        while ((comp = MainController.get_requestor(tc.cancel_done_sent_for, i2)) != null) {
            this.done_cancelled(tc, comp);
            ++i2;
        }
        MainController.free_requestors(tc.cancel_done_sent_for);
        Iterator<PortConnection> it = tc.conn_head_list.iterator();
        while (it.hasNext()) {
            conn = it.next();
            if (conn.tailComp == 2) {
                this.destroy_mapping(conn, 0, null, it);
            } else {
                this.destroy_connection(conn, tc, it);
            }
            tc.conn_tail_list.remove(conn);
        }
        it = tc.conn_tail_list.iterator();
        while (it.hasNext()) {
            conn = it.next();
            if (conn.headComp == 2) {
                this.destroy_mapping(conn, 0, null, it);
            } else {
                this.destroy_connection(conn, tc, it);
            }
            tc.conn_head_list.remove(conn);
        }
        tc.tc_fn_name = new QualifiedName("", "");
    }

    private void destroy_connection(PortConnection conn, ComponentStruct tc, Iterator<PortConnection> it) {
        switch (conn.conn_state) {
            case CONN_LISTENING: 
            case CONN_CONNECTING: {
                if (conn.transport_type != TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL && conn.headComp != tc.comp_ref) {
                    this.send_disconnect_to_server(conn);
                }
                this.send_error_to_connect_requestors(conn, "test component " + tc.comp_ref + " has terminated during connection setup.");
                break;
            }
            case CONN_CONNECTED: {
                break;
            }
            case CONN_DISCONNECTING: {
                this.send_disconnect_ack_to_requestors(conn);
                break;
            }
            default: {
                this.error(MessageFormat.format("The port connection {0}:{1} - {2}:{3} is in invalid state when test component {4} has terminated.", conn.headComp, conn.headPort, conn.tailComp, conn.tailPort, tc.comp_ref));
            }
        }
        it.remove();
    }

    private void destroy_mapping(PortConnection conn, int nof_params, TitanPort.Map_Params params, Iterator<PortConnection> it) {
        String system_port;
        String tc_port;
        int tc_compref;
        if (conn.headComp == 2) {
            tc_compref = conn.tailComp;
            tc_port = conn.tailPort;
            system_port = conn.headPort;
        } else {
            tc_compref = conn.headComp;
            tc_port = conn.headPort;
            system_port = conn.tailPort;
        }
        switch (conn.conn_state) {
            case CONN_UNMAPPING: {
                ComponentStruct comp;
                int i = 0;
                while ((comp = MainController.get_requestor(conn.requestors, i)) != null) {
                    if (comp.tc_state == tc_state_enum.TC_UNMAP) {
                        this.send_unmap_ack(comp, nof_params, params);
                        comp.tc_state = comp.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
                    }
                    ++i;
                }
                break;
            }
            case CONN_MAPPING: {
                ComponentStruct comp;
                int i = 0;
                while ((comp = MainController.get_requestor(conn.requestors, i)) != null) {
                    if (comp.tc_state == tc_state_enum.TC_MAP) {
                        this.send_error(comp.socket, MessageFormat.format("Establishment of port mapping {0}:{1} - system:{2} failed because the test component endpoint has terminated.", tc_compref, tc_port, system_port));
                        comp.tc_state = comp.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
                    }
                    ++i;
                }
                break;
            }
        }
        if (it != null) {
            it.remove();
        } else {
            this.remove_connection(conn);
        }
    }

    private void send_unmap_ack(ComponentStruct tc, int nof_params, TitanPort.Map_Params params) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(20);
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        this.send_message(tc.socket, text_buf);
    }

    private void done_cancelled(ComponentStruct from, ComponentStruct started_tc) {
        if (started_tc.tc_state != tc_state_enum.PTC_STARTING) {
            return;
        }
        this.remove_requestor(started_tc.cancel_done_sent_to, from);
        if (MainController.get_requestor(started_tc.cancel_done_sent_to, 0) != null) {
            return;
        }
        this.send_start(started_tc, started_tc.tc_fn_name, started_tc.arg);
        ComponentStruct start_requestor = started_tc.start_requestor;
        if (start_requestor.tc_state == tc_state_enum.TC_START) {
            this.send_start_ack(start_requestor);
            start_requestor.tc_state = start_requestor.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
        }
        started_tc.arg = null;
        MainController.free_requestors(started_tc.cancel_done_sent_to);
        started_tc.tc_state = tc_state_enum.PTC_FUNCTION;
        this.status_change();
    }

    private void remove_requestor(RequestorStruct reqs, ComponentStruct tc) {
        reqs.components.remove(tc);
    }

    private void send_kill_ack_to_requestors(ComponentStruct tc) {
        ComponentStruct requestor;
        int i = 0;
        while ((requestor = MainController.get_requestor(tc.kill_requestors, i)) != null) {
            if (requestor.tc_state == tc_state_enum.TC_KILL) {
                this.send_kill_ack(requestor);
                requestor.tc_state = requestor.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
            }
            ++i;
        }
        MainController.free_requestors(tc.kill_requestors);
    }

    private void send_stop_ack_to_requestors(ComponentStruct tc) {
        ComponentStruct requestor;
        int i = 0;
        while ((requestor = MainController.get_requestor(tc.stop_requestors, i)) != null) {
            if (requestor.tc_state == tc_state_enum.TC_STOP) {
                this.send_stop_ack(requestor);
                requestor.tc_state = requestor.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
            }
            ++i;
        }
        MainController.free_requestors(tc.stop_requestors);
    }

    private void check_all_component_stop() {
        boolean ready_for_ack = true;
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            switch (comp.tc_state) {
                case PTC_KILLING: 
                case TC_INITIAL: {
                    if (comp.is_alive) break;
                    ready_for_ack = false;
                    break;
                }
                case TC_STOPPING: 
                case PTC_STOPPING_KILLING: {
                    ready_for_ack = false;
                    break;
                }
                case TC_EXITED: 
                case TC_EXITING: 
                case PTC_STOPPED: 
                case PTC_STALE: {
                    break;
                }
                case TC_IDLE: {
                    if (comp.is_alive) break;
                }
                default: {
                    this.error(MessageFormat.format("PTC {0} is in invalid state when performing ''all component.stop'' operation.", comp.comp_ref));
                }
            }
            if (!ready_for_ack) break;
        }
        if (ready_for_ack) {
            this.send_stop_ack(this.mtc);
            this.mtc.tc_state = tc_state_enum.MTC_TESTCASE;
        }
    }

    private void check_all_component_kill() {
        boolean ready_for_ack = true;
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            switch (comp.tc_state) {
                case PTC_STOPPING_KILLING: 
                case PTC_KILLING: 
                case TC_INITIAL: {
                    ready_for_ack = false;
                }
                case TC_EXITED: 
                case TC_EXITING: 
                case PTC_STALE: {
                    break;
                }
                default: {
                    this.error(MessageFormat.format("PTC {0} is in invalid state when performing ''all component.kill'' operation.", comp.comp_ref));
                }
            }
            if (!ready_for_ack) break;
        }
        if (ready_for_ack) {
            this.send_kill_ack(this.mtc);
            this.mtc.tc_state = tc_state_enum.MTC_TESTCASE;
        }
    }

    private void send_kill_ack(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(5);
        this.send_message(tc.socket, text_buf);
    }

    private void send_component_status_mtc(int comp_ref, boolean is_done, boolean is_killed, boolean is_any_done, boolean is_all_done, boolean is_any_killed, boolean is_all_killed, TitanVerdictType.VerdictTypeEnum local_verdict, String return_type, byte[] return_value) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(11);
        text_buf.push_int(comp_ref);
        text_buf.push_int(is_done ? 1 : 0);
        text_buf.push_int(is_killed ? 1 : 0);
        text_buf.push_int(is_any_done ? 1 : 0);
        text_buf.push_int(is_all_done ? 1 : 0);
        text_buf.push_int(is_any_killed ? 1 : 0);
        text_buf.push_int(is_all_killed ? 1 : 0);
        text_buf.push_int(local_verdict.getValue());
        text_buf.push_string(return_type);
        if (return_value != null) {
            text_buf.push_raw(return_value);
        }
        this.send_message(this.mtc.socket, text_buf);
    }

    private boolean is_any_component_alive() {
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            if (!this.component_is_alive(comp)) continue;
            return true;
        }
        return false;
    }

    private boolean component_is_alive(ComponentStruct tc) {
        switch (tc.tc_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: 
            case TC_INITIAL: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: 
            case PTC_STOPPED: {
                return true;
            }
            case TC_EXITED: 
            case TC_EXITING: {
                return false;
            }
        }
        this.error(MessageFormat.format("PTC {0} is in invalid state when checking whether it is alive.", tc.comp_ref));
        return false;
    }

    private boolean is_any_component_running() {
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            if (!this.component_is_running(comp)) continue;
            return true;
        }
        return false;
    }

    private boolean component_is_running(ComponentStruct tc) {
        switch (tc.tc_state) {
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_STARTING: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                return true;
            }
            case TC_EXITED: 
            case TC_EXITING: 
            case PTC_KILLING: 
            case TC_INITIAL: 
            case TC_IDLE: 
            case PTC_STOPPED: {
                return false;
            }
        }
        this.error(MessageFormat.format("PTC {0} is in invalid state when checking whether it is running.", tc.comp_ref));
        return false;
    }

    private void send_component_status_to_requestor(ComponentStruct tc, ComponentStruct requestor, boolean done_status, boolean killed_status) {
        switch (requestor.tc_state) {
            case TC_STOPPING: 
            case PTC_STARTING: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: 
            case PTC_STOPPED: {
                if (done_status) {
                    this.send_component_status_ptc(requestor, tc.comp_ref, true, killed_status, tc.local_verdict, tc.return_type, tc.return_value);
                    break;
                }
                this.send_component_status_ptc(requestor, tc.comp_ref, false, killed_status, tc.local_verdict, null, null);
                break;
            }
            case TC_EXITED: 
            case TC_EXITING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                break;
            }
            default: {
                this.error(MessageFormat.format("PTC {0} is in invalid state when sending out COMPONENT_STATUS message about PTC {1}.", requestor.comp_ref, tc.comp_ref));
            }
        }
    }

    private void send_component_status_ptc(ComponentStruct tc, int comp_ref, boolean is_done, boolean is_killed, TitanVerdictType.VerdictTypeEnum local_verdict, String return_type, byte[] return_value) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(11);
        text_buf.push_int(comp_ref);
        text_buf.push_int(is_done ? 1 : 0);
        text_buf.push_int(is_killed ? 1 : 0);
        text_buf.push_int(local_verdict.getValue());
        text_buf.push_string(return_type);
        if (tc.return_value != null) {
            text_buf.push_raw(tc.return_value);
        }
        this.send_message(tc.socket, text_buf);
    }

    private void process_stop_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "STOP_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Stop operation was requested on the null component reference.");
                return;
            }
            case 1: {
                if (!tc.equals(this.mtc)) {
                    if (!this.mtc.stop_requested) {
                        this.send_stop(this.mtc);
                        this.kill_all_components(true);
                        this.mtc.stop_requested = true;
                        this.start_kill_timer(this.mtc);
                        this.notify(MessageFormat.format("Test Component {0} had requested to stop MTC. Terminating current testcase execution.", tc.comp_ref));
                        this.status_change();
                    }
                } else {
                    this.send_error(tc.socket, "MTC has requested to stop itself.");
                }
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Stop operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                this.send_error(tc.socket, "Stop operation was requested on 'any component'.");
                return;
            }
            case -2: {
                if (tc.equals(this.mtc)) {
                    if (this.stop_all_components()) {
                        this.send_stop_ack(this.mtc);
                    } else {
                        this.mtc.tc_state = tc_state_enum.MTC_ALL_COMPONENT_STOP;
                        this.status_change();
                    }
                } else {
                    this.send_error(tc.socket, "Operation 'all component.stop' can only be performed on the MTC.");
                }
                return;
            }
        }
        ComponentStruct target = this.lookup_component(component_reference);
        if (target == null) {
            this.send_error(tc.socket, MessageFormat.format("The argument of stop operation is an invalid component reference {0}.", component_reference));
            return;
        }
        if (target.equals(tc)) {
            this.send_error(tc.socket, "Stop operation was requested on the requestor component itself.");
            return;
        }
        boolean target_inactive = false;
        switch (target.tc_state) {
            case PTC_STOPPED: {
                if (!target.is_alive) {
                    this.error(MessageFormat.format("PTC {0} cannot be in state STOPPED because it is not an alive type PTC.", component_reference));
                }
            }
            case TC_IDLE: {
                target_inactive = true;
            }
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                if (target.is_alive) {
                    if (target_inactive) {
                        this.send_stop_ack(tc);
                        break;
                    }
                    this.send_stop(target);
                    target.tc_state = tc_state_enum.TC_STOPPING;
                } else {
                    this.send_kill(target);
                    target.tc_state = target_inactive ? tc_state_enum.PTC_KILLING : tc_state_enum.PTC_STOPPING_KILLING;
                }
                target.stop_requested = true;
                target.stop_requestors = MainController.init_requestors(tc);
                target.kill_requestors = MainController.init_requestors(null);
                this.start_kill_timer(target);
                tc.tc_state = tc_state_enum.TC_STOP;
                this.status_change();
                break;
            }
            case PTC_KILLING: {
                if (target.is_alive) {
                    this.send_stop_ack(tc);
                    break;
                }
            }
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: {
                this.add_requestor(target.stop_requestors, tc);
                tc.tc_state = tc_state_enum.TC_STOP;
                this.status_change();
                break;
            }
            case TC_EXITED: 
            case TC_EXITING: {
                this.send_stop_ack(tc);
                break;
            }
            case PTC_STARTING: {
                this.send_error(tc.socket, MessageFormat.format("PTC with component reference {0} cannot be stopped because it is currently being started.", component_reference));
                break;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of stop operation ({0}) is a component reference that belongs to an earlier testcase.", component_reference));
                break;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("The test component that the stop operation refers to ({0}) is in invalid state.", component_reference));
            }
        }
    }

    private void send_stop_ack(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(4);
        this.send_message(tc.socket, text_buf);
    }

    private boolean stop_all_components() {
        boolean ready_for_ack = true;
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct tc = this.components.get(i);
            switch (tc.tc_state) {
                case TC_INITIAL: {
                    if (tc.is_alive) break;
                    ready_for_ack = false;
                    break;
                }
                case TC_IDLE: {
                    if (tc.is_alive) break;
                    this.send_kill(tc);
                    tc.tc_state = tc_state_enum.PTC_KILLING;
                    tc.stop_requested = true;
                    tc.stop_requestors = MainController.init_requestors(null);
                    tc.kill_requestors = MainController.init_requestors(null);
                    this.start_kill_timer(tc);
                    ready_for_ack = false;
                    break;
                }
                case TC_CREATE: 
                case TC_START: 
                case TC_STOP: 
                case TC_KILL: 
                case TC_CONNECT: 
                case TC_DISCONNECT: 
                case TC_MAP: 
                case TC_UNMAP: 
                case PTC_FUNCTION: {
                    if (tc.is_alive) {
                        this.send_stop(tc);
                        tc.tc_state = tc_state_enum.TC_STOPPING;
                    } else {
                        this.send_kill(tc);
                        tc.tc_state = tc_state_enum.PTC_STOPPING_KILLING;
                    }
                    tc.stop_requested = true;
                    tc.stop_requestors = MainController.init_requestors(null);
                    tc.kill_requestors = MainController.init_requestors(null);
                    this.start_kill_timer(tc);
                    ready_for_ack = false;
                    break;
                }
                case PTC_STARTING: {
                    tc.tc_fn_name = new QualifiedName("", "");
                    tc.arg = null;
                    MainController.free_requestors(tc.cancel_done_sent_to);
                    tc.tc_state = tc_state_enum.PTC_STOPPED;
                    break;
                }
                case TC_STOPPING: 
                case PTC_STOPPING_KILLING: {
                    MainController.free_requestors(tc.stop_requestors);
                    MainController.free_requestors(tc.kill_requestors);
                    ready_for_ack = false;
                    break;
                }
                case PTC_KILLING: {
                    MainController.free_requestors(tc.stop_requestors);
                    MainController.free_requestors(tc.kill_requestors);
                    if (tc.is_alive) break;
                    ready_for_ack = false;
                    break;
                }
                case TC_EXITED: 
                case TC_EXITING: 
                case PTC_STOPPED: 
                case PTC_STALE: {
                    break;
                }
                default: {
                    this.error(MessageFormat.format("Test Component {0} is in invalid state when stopping all components.", tc.comp_ref));
                }
            }
            boolean mtc_requested_done = MainController.has_requestor(tc.done_requestors, this.mtc);
            MainController.free_requestors(tc.done_requestors);
            if (mtc_requested_done) {
                this.add_requestor(tc.done_requestors, this.mtc);
            }
            boolean mtc_requested_killed = MainController.has_requestor(tc.killed_requestors, this.mtc);
            MainController.free_requestors(tc.kill_requestors);
            if (mtc_requested_killed) {
                this.add_requestor(tc.killed_requestors, this.mtc);
            }
            MainController.free_requestors(tc.cancel_done_sent_for);
        }
        return ready_for_ack;
    }

    private boolean kill_all_components(boolean testcase_ends) {
        boolean ready_for_ack = true;
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct tc = this.components.get(i);
            boolean is_inactive = false;
            switch (tc.tc_state) {
                case TC_INITIAL: {
                    ready_for_ack = false;
                    break;
                }
                case PTC_STARTING: {
                    tc.tc_fn_name = new QualifiedName("", "");
                    tc.arg = null;
                    MainController.free_requestors(tc.cancel_done_sent_to);
                }
                case TC_IDLE: 
                case PTC_STOPPED: {
                    is_inactive = true;
                }
                case TC_CREATE: 
                case TC_START: 
                case TC_STOP: 
                case TC_KILL: 
                case TC_CONNECT: 
                case TC_DISCONNECT: 
                case TC_MAP: 
                case TC_UNMAP: 
                case PTC_FUNCTION: {
                    this.send_kill(tc);
                    if (is_inactive) {
                        tc.tc_state = tc_state_enum.PTC_KILLING;
                        if (!tc.is_alive) {
                            tc.stop_requested = true;
                        }
                    } else {
                        tc.tc_state = tc_state_enum.PTC_STOPPING_KILLING;
                        tc.stop_requested = true;
                    }
                    tc.stop_requestors = MainController.init_requestors(null);
                    tc.kill_requestors = MainController.init_requestors(null);
                    this.start_kill_timer(tc);
                    ready_for_ack = false;
                    break;
                }
                case TC_STOPPING: {
                    this.send_kill(tc);
                    tc.tc_state = tc_state_enum.PTC_STOPPING_KILLING;
                    if (tc.kill_timer != null) {
                        this.cancel_timer(tc.kill_timer);
                    }
                    this.start_kill_timer(tc);
                }
                case PTC_STOPPING_KILLING: 
                case PTC_KILLING: {
                    MainController.free_requestors(tc.stop_requestors);
                    MainController.free_requestors(tc.kill_requestors);
                    ready_for_ack = false;
                    break;
                }
                case TC_EXITING: {
                    if (testcase_ends) {
                        ready_for_ack = false;
                    }
                }
                case TC_EXITED: 
                case PTC_STALE: {
                    break;
                }
                default: {
                    this.error(MessageFormat.format("Test Component {0} is in invalid state when killing all components.", tc.comp_ref));
                }
            }
            if (testcase_ends) {
                MainController.free_requestors(tc.done_requestors);
                MainController.free_requestors(tc.killed_requestors);
            } else {
                boolean mtc_requested_done = MainController.has_requestor(tc.done_requestors, this.mtc);
                MainController.free_requestors(tc.done_requestors);
                if (mtc_requested_done) {
                    this.add_requestor(tc.done_requestors, this.mtc);
                }
                boolean mtc_requested_killed = MainController.has_requestor(tc.killed_requestors, this.mtc);
                MainController.free_requestors(tc.killed_requestors);
                if (mtc_requested_killed) {
                    this.add_requestor(tc.killed_requestors, this.mtc);
                }
            }
            MainController.free_requestors(tc.cancel_done_sent_for);
        }
        return ready_for_ack;
    }

    private static boolean has_requestor(RequestorStruct reqs, ComponentStruct tc) {
        return reqs.components.contains(tc);
    }

    private void send_stop(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(3);
        this.send_message(tc.socket, text_buf);
    }

    private void process_disconnected(ComponentStruct tc) {
        String remotePort;
        int remoteComponent;
        if (!this.message_expected(tc, "DISCONNECTED")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        String sourcePort = text_buf.pull_string();
        PortConnection conn = this.find_connection(tc.comp_ref, sourcePort, remoteComponent = text_buf.pull_int().get_int(), remotePort = text_buf.pull_string());
        if (conn != null) {
            switch (conn.conn_state) {
                case CONN_LISTENING: {
                    if (conn.headComp != tc.comp_ref || !conn.headPort.equals(sourcePort)) {
                        this.send_error(tc.socket, MessageFormat.format("Unexpected message DISCONNECTED was received for port connection {0}:{1} - {2}:{3}.", tc.comp_ref, sourcePort, remoteComponent, remotePort));
                        break;
                    }
                }
                case CONN_CONNECTING: {
                    this.send_error_to_connect_requestors(conn, "test component " + tc.comp_ref + " reported end of the connection during connection setup.");
                    this.remove_connection(conn);
                    this.status_change();
                    break;
                }
                case CONN_CONNECTED: {
                    this.remove_connection(conn);
                    this.status_change();
                    break;
                }
                case CONN_DISCONNECTING: {
                    this.send_disconnect_ack_to_requestors(conn);
                    this.remove_connection(conn);
                    this.status_change();
                    break;
                }
                default: {
                    this.error(MessageFormat.format("The port connection {0}:{1} - {2}:{3} is in invalid state when MC was notified about its termination.", tc.comp_ref, sourcePort, remoteComponent, remotePort));
                }
            }
        }
        this.status_change();
    }

    private void send_disconnect_ack_to_requestors(PortConnection conn) {
        ComponentStruct comp;
        int i = 0;
        while ((comp = MainController.get_requestor(conn.requestors, i)) != null) {
            if (comp.tc_state == tc_state_enum.TC_DISCONNECT) {
                this.send_disconnect_ack(comp);
                comp.tc_state = comp.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
            }
            ++i;
        }
        MainController.free_requestors(conn.requestors);
    }

    private void process_disconnect_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "DISCONNECT_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int sourceComponent = text_buf.pull_int().get_int();
        String sourcePort = text_buf.pull_string();
        int destinationComponent = text_buf.pull_int().get_int();
        String destinationPort = text_buf.pull_string();
        if (!this.valid_endpoint(sourceComponent, false, tc, "disconnect") || !this.valid_endpoint(destinationComponent, false, tc, "disconnect")) {
            return;
        }
        PortConnection conn = this.find_connection(sourceComponent, sourcePort, destinationComponent, destinationPort);
        if (conn != null) {
            switch (conn.conn_state) {
                case CONN_LISTENING: 
                case CONN_CONNECTING: {
                    this.send_error(tc.socket, MessageFormat.format("The port connection {0}:{1} - {2}:{3} cannot be destroyed because a connect operation is in progress on it.", sourceComponent, sourcePort, destinationComponent, destinationPort));
                    break;
                }
                case CONN_CONNECTED: {
                    this.send_disconnect(this.components.get(conn.tailComp), conn.tailPort, conn.headComp, conn.headPort);
                    conn.conn_state = conn_state_enum.CONN_DISCONNECTING;
                }
                case CONN_DISCONNECTING: {
                    this.add_requestor(conn.requestors, tc);
                    tc.tc_state = tc_state_enum.TC_DISCONNECT;
                    this.status_change();
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("The port connection {0}:{1} - {2}:{3} cannot be destroyed due to an internal error in the MC.", sourceComponent, sourcePort, destinationComponent, destinationPort));
                    this.error(MessageFormat.format("The port connection {0}:{1} - {2}:{3} is in invalid state when a disconnect operation was requested on it.", sourceComponent, sourcePort, destinationComponent, destinationPort));
                    break;
                }
            }
        } else {
            this.send_disconnect_ack(tc);
        }
    }

    private void send_disconnect_ack(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(16);
        this.send_message(tc.socket, text_buf);
    }

    private void send_disconnect(ComponentStruct tc, String tailPort, int headComp, String headPort) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(15);
        text_buf.push_string(tailPort);
        text_buf.push_int(headComp);
        text_buf.push_string(headPort);
        this.send_message(tc.socket, text_buf);
    }

    private void process_start_req(ComponentStruct tc) {
        ComponentStruct comp;
        int i;
        if (!this.request_allowed(tc, "START_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        String module_name = text_buf.pull_string();
        String function_name = text_buf.pull_string();
        switch (component_reference) {
            case 0: {
                this.send_error(tc.socket, "Start operation was requested on the null component reference.");
                return;
            }
            case 1: {
                this.send_error(tc.socket, "Start operation was requested on the component reference of the MTC.");
                return;
            }
            case 2: {
                this.send_error(tc.socket, "Start operation was requested on the component reference of the system.");
                return;
            }
            case -1: {
                this.send_error(tc.socket, "Start operation was requested on 'any component'.");
                return;
            }
            case -2: {
                this.send_error(tc.socket, "Start operation was requested on 'all component'.");
                return;
            }
        }
        ComponentStruct target = this.lookup_component(component_reference);
        if (target == null) {
            this.send_error(tc.socket, MessageFormat.format("Start operation was requested on invalid component reference: {0}.", component_reference));
            return;
        }
        switch (target.tc_state) {
            case TC_IDLE: 
            case PTC_STOPPED: {
                break;
            }
            case PTC_STARTING: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                this.send_error(tc.socket, MessageFormat.format("PTC with component reference {0} cannot be started because it is already executing function {1}.{2}.", component_reference, target.tc_fn_name.module_name, target.tc_fn_name.definition_name));
                return;
            }
            case TC_STOPPING: {
                this.send_error(tc.socket, MessageFormat.format("PTC with component reference {0} cannot be started because its function {1}.{2} is currently being stopped on it.", component_reference, target.tc_fn_name.module_name, target.tc_fn_name.definition_name));
                return;
            }
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                this.send_error(tc.socket, MessageFormat.format("PTC with component reference {0} cannot be started because it is currently being killed.", component_reference));
                return;
            }
            case TC_EXITED: 
            case TC_EXITING: {
                this.send_error(tc.socket, MessageFormat.format("PTC with component reference {0} cannot be started because it is not alive anymore.", component_reference));
                return;
            }
            case PTC_STALE: {
                this.send_error(tc.socket, MessageFormat.format("The argument of starte operation ({0}) is a component reference that belongs to an earlier state.", component_reference));
                return;
            }
            default: {
                this.send_error(tc.socket, MessageFormat.format("Start operation was requested on component reference {0}, which is in invalid state.", component_reference));
                return;
            }
        }
        target.tc_fn_name = new QualifiedName(module_name, function_name);
        target.stop_requested = false;
        boolean send_cancel_done = false;
        boolean cancel_any_component_done = false;
        byte[] arg = new byte[text_buf.get_len() - text_buf.get_pos()];
        text_buf.pull_raw(text_buf.get_len() - text_buf.get_pos(), arg);
        if (target.tc_state == tc_state_enum.PTC_STOPPED) {
            target.tc_state = tc_state_enum.PTC_STARTING;
            target.return_type = null;
            target.return_value = null;
            target.cancel_done_sent_to = MainController.init_requestors(null);
            i = 0;
            while ((comp = MainController.get_requestor(target.done_requestors, i)) != null) {
                if (!comp.equals(tc)) {
                    switch (comp.tc_state) {
                        case TC_STOPPING: 
                        case PTC_STARTING: 
                        case TC_CREATE: 
                        case TC_START: 
                        case TC_STOP: 
                        case TC_KILL: 
                        case TC_CONNECT: 
                        case TC_DISCONNECT: 
                        case TC_MAP: 
                        case TC_UNMAP: 
                        case MTC_TESTCASE: 
                        case PTC_FUNCTION: 
                        case PTC_STOPPED: {
                            send_cancel_done = true;
                            this.add_requestor(target.cancel_done_sent_to, comp);
                            break;
                        }
                        case TC_EXITED: 
                        case TC_EXITING: 
                        case PTC_STOPPING_KILLING: 
                        case PTC_KILLING: {
                            break;
                        }
                        default: {
                            this.error(MessageFormat.format("Test Component {0} is in invalid state when starting PTC {1}.", comp.comp_ref, component_reference));
                        }
                    }
                }
                ++i;
            }
            if (this.any_component_done_sent && !this.is_any_component_done()) {
                send_cancel_done = true;
                cancel_any_component_done = true;
                this.any_component_done_sent = false;
                this.add_requestor(target.cancel_done_sent_to, this.mtc);
            }
            MainController.free_requestors(target.done_requestors);
        }
        if (send_cancel_done) {
            i = 0;
            while ((comp = MainController.get_requestor(target.cancel_done_sent_to, i)) != null) {
                if (comp.equals(this.mtc)) {
                    this.send_cancel_done_mtc(component_reference, cancel_any_component_done);
                } else {
                    this.send_cancel_done_ptc(comp, component_reference);
                }
                this.add_requestor(comp.cancel_done_sent_for, target);
                ++i;
            }
            target.start_requestor = tc;
            tc.tc_state = tc_state_enum.TC_START;
            target.arg = arg;
        } else {
            this.send_start(target, target.tc_fn_name, arg);
            this.send_start_ack(tc);
            target.tc_state = tc_state_enum.PTC_FUNCTION;
        }
        this.status_change();
    }

    private void send_start_ack(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(2);
        this.send_message(tc.socket, text_buf);
    }

    private void send_start(ComponentStruct target, QualifiedName tc_fn_name, byte[] arg) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(21);
        text_buf.push_string(tc_fn_name.module_name);
        text_buf.push_string(tc_fn_name.definition_name);
        text_buf.push_raw(arg);
        this.send_message(target.socket, text_buf);
    }

    private void send_cancel_done_ptc(ComponentStruct comp, int component_reference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(10);
        text_buf.push_int(component_reference);
        this.send_message(comp.socket, text_buf);
    }

    private void send_cancel_done_mtc(int component_reference, boolean cancel_any_component_done) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(10);
        text_buf.push_int(component_reference);
        text_buf.push_int(cancel_any_component_done ? 1 : 0);
        this.send_message(this.mtc.socket, text_buf);
    }

    private boolean is_any_component_done() {
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            if (!this.component_is_done(comp)) continue;
            return true;
        }
        return false;
    }

    private boolean component_is_done(ComponentStruct tc) {
        switch (tc.tc_state) {
            case TC_EXITED: 
            case TC_EXITING: 
            case PTC_STOPPED: {
                return true;
            }
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: 
            case TC_INITIAL: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case PTC_FUNCTION: {
                return false;
            }
        }
        this.error(MessageFormat.format("PTC {0} is in invalid state when checking whether it is done.", tc.comp_ref));
        return false;
    }

    private void process_connected(ComponentStruct tc) {
        String remote_port;
        int remote_component;
        if (!this.message_expected(tc, "CONNECTED")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        String local_port = text_buf.pull_string();
        PortConnection conn = this.find_connection(tc.comp_ref, local_port, remote_component = text_buf.pull_int().get_int(), remote_port = text_buf.pull_string());
        if (conn != null) {
            if (conn.conn_state == conn_state_enum.CONN_CONNECTING && conn.headComp == tc.comp_ref && conn.headPort.equals(local_port)) {
                this.send_connect_ack_to_requestors(conn);
                conn.conn_state = conn_state_enum.CONN_CONNECTED;
                this.status_change();
            } else {
                this.send_error(tc.socket, MessageFormat.format("Unexpected CONNECTED message was received for port connection {0}:{1} - {2}:{3}.", tc.comp_ref, local_port, remote_component, remote_port));
            }
        }
    }

    private void send_connect_ack_to_requestors(PortConnection conn) {
        ComponentStruct comp;
        int i = 0;
        while ((comp = MainController.get_requestor(conn.requestors, i)) != null) {
            if (comp.tc_state == tc_state_enum.TC_CONNECT) {
                this.send_connect_ack(comp);
                comp.tc_state = comp.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
            }
            ++i;
        }
        MainController.free_requestors(conn.requestors);
    }

    private void process_connect_listen_ack(ComponentStruct tc, int msg_end) {
        byte[] addr;
        if (!this.message_expected(tc, "CONNECT_LISTEN_ACK")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        String local_port = text_buf.pull_string();
        int remote_component = text_buf.pull_int().get_int();
        String remote_port = text_buf.pull_string();
        int transport_type = text_buf.pull_int().get_int();
        byte[] temp = new byte[2];
        byte[] local_port_number = new byte[2];
        text_buf.pull_raw(2, temp);
        text_buf.pull_raw(2, local_port_number);
        int local_addr_begin = text_buf.get_pos();
        int local_addr_len = msg_end - local_addr_begin;
        if (local_addr_len == 12) {
            addr = new byte[4];
            text_buf.pull_raw(4, addr);
            byte[] zero = new byte[8];
            text_buf.pull_raw(8, zero);
        } else {
            addr = new byte[16];
            text_buf.pull_raw(16, addr);
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        PortConnection conn = this.find_connection(tc.comp_ref, local_port, remote_component, remote_port);
        if (conn != null) {
            if (conn.conn_state != conn_state_enum.CONN_LISTENING || conn.headComp != tc.comp_ref || conn.headPort.compareTo(local_port) != 0) {
                this.send_error(tc.socket, MessageFormat.format("Unexpected message CONNECT_LISTEN_ACK was received for port connection {0}:{1} - {2}:{3}.", tc.comp_ref, local_port, remote_component, remote_port));
                return;
            }
            if (conn.transport_type.ordinal() != transport_type) {
                this.send_error(tc.socket, MessageFormat.format("Message CONNECT_LISTEN_ACK for port connection {0}:{1} - {2}:{3} contains wrong transport type: {4} was expected instead of {5}.", new Object[]{tc.comp_ref, local_port, remote_component, remote_port, conn.transport_type, TTCN_Communication.transport_type_enum.values()[transport_type]}));
                return;
            }
            ComponentStruct dst_comp = this.components.get(remote_component);
            switch (dst_comp.tc_state) {
                case TC_STOPPING: 
                case PTC_STARTING: 
                case TC_IDLE: 
                case TC_CREATE: 
                case TC_START: 
                case TC_STOP: 
                case TC_KILL: 
                case TC_CONNECT: 
                case TC_DISCONNECT: 
                case TC_MAP: 
                case TC_UNMAP: 
                case MTC_TESTCASE: 
                case PTC_FUNCTION: 
                case PTC_STOPPED: {
                    if (tc.comp_ref != 1 && tc.comp_ref != remote_component) {
                        this.send_connect(dst_comp, remote_port, tc.comp_ref, tc.comp_name, local_port, TTCN_Communication.transport_type_enum.values()[transport_type], address, local_port_number);
                    } else {
                        this.send_connect(dst_comp, remote_port, tc.comp_ref, null, local_port, TTCN_Communication.transport_type_enum.values()[transport_type], address, local_port_number);
                    }
                    conn.conn_state = conn_state_enum.CONN_CONNECTING;
                    break;
                }
                default: {
                    this.send_disconnect_to_server(conn);
                    this.send_error_to_connect_requestors(conn, "test component " + dst_comp + " has terminated during connection setup.");
                    this.remove_connection(conn);
                }
            }
            this.status_change();
        } else {
            switch (TTCN_Communication.transport_type_enum.values()[transport_type]) {
                case TRANSPORT_LOCAL: {
                    this.send_error(tc.socket, MessageFormat.format("Message CONNECT_LISTEN_ACK for port connection {0}:{1} - {2}:{3} cannot refer to transport type {4}.", tc.comp_ref, local_port, remote_component, remote_port, TTCN_Communication.transport_type_enum.values()[transport_type].toString()));
                    break;
                }
                case TRANSPORT_INET_STREAM: {
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("Message CONNECT_LISTEN_ACK for port connection {0}:{1} - {2}:{3} refers to invalid transport type {4}.", tc.comp_ref, local_port, remote_component, remote_port, TTCN_Communication.transport_type_enum.values()[transport_type].toString()));
                }
            }
        }
    }

    private void send_error_to_connect_requestors(PortConnection conn, String msg) {
        ComponentStruct comp;
        String reason = "Establishment of port connection " + conn.headComp + ":" + conn.headPort + " - " + conn.tailComp + ":" + conn.tailPort + " failed because " + msg;
        int i = 0;
        while ((comp = MainController.get_requestor(conn.requestors, i)) != null) {
            if (comp.tc_state == tc_state_enum.TC_CONNECT) {
                this.send_error(comp.socket, reason);
                comp.tc_state = comp.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
            }
            ++i;
        }
    }

    private static ComponentStruct get_requestor(RequestorStruct reqs, int index) {
        if (index >= 0 && index < reqs.components.size()) {
            return reqs.components.get(index);
        }
        return null;
    }

    private static void free_requestors(RequestorStruct requestor) {
        requestor.components.clear();
    }

    private void process_connect_error(ComponentStruct tc) {
        if (!this.message_expected(tc, "CONNECT_ERROR")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        String localPort = text_buf.pull_string();
        int remote_comp = text_buf.pull_int().get_int();
        String remote_port = text_buf.pull_string();
        String message = text_buf.pull_string();
        PortConnection conn = this.find_connection(tc.comp_ref, localPort, remote_comp, remote_port);
        if (conn != null) {
            switch (conn.conn_state) {
                case CONN_CONNECTING: {
                    if (conn.transport_type == TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL || conn.tailComp != tc.comp_ref || !conn.tailPort.equals(localPort)) break;
                    this.send_disconnect_to_server(conn);
                    break;
                }
                case CONN_LISTENING: {
                    if (conn.headComp == tc.comp_ref && conn.headPort.equals(localPort)) break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("Unexpected message CONNECT_ERROR was received for port connection {0}:{1} - {2}:{3}.", tc.comp_ref, localPort, remote_comp, remote_port));
                    return;
                }
            }
            this.send_error_to_connect_requestors(conn, "test component " + tc.comp_ref + " reported error: " + message);
            this.remove_connection(conn);
            this.status_change();
        }
    }

    private void remove_connection(PortConnection c) {
        ComponentStruct tail_component;
        ComponentStruct head_component = this.lookup_component(c.headComp);
        if (head_component != null) {
            head_component.conn_head_list.remove(c);
        }
        if ((tail_component = this.lookup_component(c.tailComp)) != null) {
            tail_component.conn_tail_list.remove(c);
        }
        MainController.free_requestors(c.requestors);
    }

    private void send_disconnect_to_server(PortConnection conn) {
        ComponentStruct comp = this.components.get(conn.headComp);
        switch (comp.tc_state) {
            case TC_STOPPING: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case MTC_TESTCASE: 
            case PTC_FUNCTION: 
            case PTC_STOPPED: {
                this.send_disconnect(comp, conn.headPort, conn.tailComp, conn.tailPort);
                break;
            }
        }
    }

    private void process_connect_req(ComponentStruct tc) {
        if (!this.request_allowed(tc, "CONNECT_REQ")) {
            return;
        }
        Text_Buf text_buf = tc.text_buf;
        int sourceComponent = text_buf.pull_int().get_int();
        String sourcePort = text_buf.pull_string();
        int destinationComponent = text_buf.pull_int().get_int();
        String destinationPort = text_buf.pull_string();
        if (!this.valid_endpoint(sourceComponent, true, tc, "connect") || !this.valid_endpoint(destinationComponent, true, tc, "connect")) {
            return;
        }
        PortConnection conn = this.find_connection(sourceComponent, sourcePort, destinationComponent, destinationPort);
        if (conn == null) {
            conn = new PortConnection();
            conn.transport_type = this.choose_port_connection_transport(sourceComponent, destinationComponent);
            conn.headComp = sourceComponent;
            conn.headPort = sourcePort;
            conn.tailComp = destinationComponent;
            conn.tailPort = destinationPort;
            conn.requestors = MainController.init_requestors(tc);
            this.add_connection(conn);
            switch (conn.transport_type) {
                case TRANSPORT_LOCAL: {
                    this.send_connect(this.components.get(conn.headComp), conn.headPort, conn.tailComp, null, conn.tailPort, conn.transport_type, null, null);
                    conn.conn_state = conn_state_enum.CONN_CONNECTING;
                    break;
                }
                case TRANSPORT_INET_STREAM: {
                    if (conn.tailComp != 1 && conn.tailComp != conn.headComp) {
                        this.send_connect_listen(this.components.get(conn.headComp), conn.headPort, conn.tailComp, this.components.get((int)conn.tailComp).comp_name, conn.tailPort, conn.transport_type);
                    } else {
                        this.send_connect_listen(this.components.get(conn.headComp), conn.headPort, conn.tailComp, null, conn.tailPort, conn.transport_type);
                    }
                    conn.conn_state = conn_state_enum.CONN_LISTENING;
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("The port connection {0}:{1} - {2}:{3} cannot be established because no suitable transport mechanism is available on the corrensponding host(s).", sourceComponent, sourcePort, destinationComponent, destinationPort));
                    this.remove_connection(conn);
                    return;
                }
            }
            tc.tc_state = tc_state_enum.TC_CONNECT;
            this.status_change();
        } else {
            switch (conn.conn_state) {
                case CONN_LISTENING: 
                case CONN_CONNECTING: {
                    this.add_requestor(conn.requestors, tc);
                    tc.tc_state = tc_state_enum.TC_CONNECT;
                    this.status_change();
                    break;
                }
                case CONN_CONNECTED: {
                    this.send_connect_ack(tc);
                    break;
                }
                case CONN_DISCONNECTING: {
                    this.send_error(tc.socket, MessageFormat.format("The port connection {0}:{1} - {2}:{3} cannot be established because a disconnect operation is in progress on it.", sourceComponent, sourcePort, destinationComponent, destinationPort));
                    break;
                }
                default: {
                    this.send_error(tc.socket, MessageFormat.format("The port connection {0}:{1} - {2}:{3} cannot be established due to an internal error in the MC.", sourceComponent, sourcePort, destinationComponent, destinationPort));
                    this.error(MessageFormat.format("The port connection {0}:{1} - {2}:{3} is in invalid state when a connect operation was requested on it.", sourceComponent, sourcePort, destinationComponent, destinationPort));
                }
            }
        }
    }

    private void add_requestor(RequestorStruct reqs, ComponentStruct tc) {
        if (reqs.components.contains(tc)) {
            return;
        }
        reqs.components.add(tc);
    }

    private void send_connect_listen(ComponentStruct tc, String headPort, int tailComp, String comp_name, String tailPort, TTCN_Communication.transport_type_enum transport_type) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(12);
        text_buf.push_string(headPort);
        text_buf.push_int(tailComp);
        text_buf.push_string(comp_name);
        text_buf.push_string(tailPort);
        text_buf.push_int(transport_type.ordinal());
        this.send_message(tc.socket, text_buf);
    }

    private void send_connect(ComponentStruct tc, String headPort, int tailComp, String compName, String tailPort, TTCN_Communication.transport_type_enum transport_type, InetAddress address, byte[] local_port_number) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(13);
        text_buf.push_string(headPort);
        text_buf.push_int(tailComp);
        text_buf.push_string(compName);
        text_buf.push_string(tailPort);
        text_buf.push_int(transport_type.ordinal());
        if (address != null) {
            if (address instanceof Inet4Address) {
                byte[] temp = address.getAddress();
                text_buf.push_raw(2, new byte[]{2, 0});
                text_buf.push_raw(local_port_number.length, local_port_number);
                text_buf.push_raw(temp.length, temp);
                text_buf.push_raw(8, new byte[8]);
            } else if (address instanceof Inet6Address) {
                Inet6Address localipv6_address = (Inet6Address)address;
                byte[] temp = localipv6_address.getAddress();
                text_buf.push_raw(2, new byte[]{2, 3});
                text_buf.push_raw(local_port_number.length, local_port_number);
                text_buf.push_raw(temp.length, temp);
                text_buf.push_int(localipv6_address.getScopeId());
            }
        }
        this.send_message(tc.socket, text_buf);
    }

    private void send_connect_ack(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(14);
        this.send_message(tc.socket, text_buf);
    }

    private TTCN_Communication.transport_type_enum choose_port_connection_transport(int sourceComponent, int destinationComponent) {
        Host headLoc = this.components.get((int)sourceComponent).comp_location;
        if (sourceComponent == destinationComponent && headLoc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL.ordinal()]) {
            return TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL;
        }
        Host tailLoc = this.components.get((int)destinationComponent).comp_location;
        if (headLoc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM.ordinal()] && tailLoc.transport_supported[TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM.ordinal()]) {
            return TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM;
        }
        return TTCN_Communication.transport_type_enum.TRANSPORT_NUM;
    }

    private PortConnection find_connection(int sourceComponent, String sourcePort, int destinationComponent, String destinationPort) {
        if (sourceComponent > destinationComponent) {
            int tmp_comp = sourceComponent;
            sourceComponent = destinationComponent;
            destinationComponent = tmp_comp;
            String tmp_port = sourcePort;
            sourcePort = destinationPort;
            destinationPort = tmp_port;
        } else if (sourceComponent == destinationComponent && sourcePort.compareTo(destinationPort) > 0) {
            String tmp_port = sourcePort;
            sourcePort = destinationPort;
            destinationPort = tmp_port;
        }
        ComponentStruct headComp = this.lookup_component(sourceComponent);
        if (headComp == null) {
            return null;
        }
        List<PortConnection> headConn = headComp.conn_head_list;
        if (headConn == null) {
            return null;
        }
        ComponentStruct tailComp = this.lookup_component(destinationComponent);
        if (tailComp == null) {
            return null;
        }
        List<PortConnection> tailConn = tailComp.conn_tail_list;
        if (tailConn == null) {
            return null;
        }
        if (headComp.conn_head_list.size() <= tailComp.conn_tail_list.size()) {
            for (PortConnection pc : headConn) {
                if (pc.tailComp != destinationComponent || !pc.headPort.equals(sourcePort) || !pc.tailPort.equals(destinationPort)) continue;
                return pc;
            }
            return null;
        }
        for (PortConnection pc : tailConn) {
            if (pc.headComp != sourceComponent || !pc.headPort.equals(sourcePort) || !pc.tailPort.equals(destinationPort)) continue;
            return pc;
        }
        return null;
    }

    private void remove_all_connections(int head_or_tail) {
        ComponentStruct component = this.lookup_component(head_or_tail);
        if (component == null) {
            return;
        }
        while (component.conn_head_list != null && !component.conn_head_list.isEmpty()) {
            this.remove_connection(component.conn_head_list.get(0));
        }
        while (component.conn_tail_list != null && !component.conn_tail_list.isEmpty()) {
            this.remove_connection(component.conn_tail_list.get(0));
        }
    }

    private void add_connection(PortConnection pc) {
        ComponentStruct tailComp;
        if (pc.headComp > pc.tailComp) {
            int tmp_comp = pc.headComp;
            pc.headComp = pc.tailComp;
            pc.tailComp = tmp_comp;
            String tmp_port = pc.headPort;
            pc.headPort = pc.tailPort;
            pc.tailPort = tmp_port;
        } else if (pc.headComp == pc.tailComp && pc.headPort.compareTo(pc.tailPort) > 0) {
            String tmp_port = pc.headPort;
            pc.headPort = pc.tailPort;
            pc.tailPort = tmp_port;
        }
        ComponentStruct headComp = this.lookup_component(pc.headComp);
        if (headComp != null) {
            if (headComp.conn_head_list == null) {
                headComp.conn_head_list = new ArrayList<PortConnection>();
            }
            headComp.conn_head_list.add(pc);
        }
        if ((tailComp = this.lookup_component(pc.tailComp)) != null) {
            if (tailComp.conn_tail_list == null) {
                tailComp.conn_tail_list = new ArrayList<PortConnection>();
            }
            tailComp.conn_tail_list.add(pc);
        }
    }

    private boolean valid_endpoint(int component_reference, boolean new_connection, ComponentStruct requestor, String operation) {
        switch (component_reference) {
            case 0: {
                this.send_error(requestor.socket, MessageFormat.format("The {0} refers to the null component reference.", operation));
                return false;
            }
            case 2: {
                this.send_error(requestor.socket, MessageFormat.format("The {0} refers to the system component reference.", operation));
                return false;
            }
            case -1: {
                this.send_error(requestor.socket, MessageFormat.format("The {0} refers to ''any component''.", operation));
                return false;
            }
            case -2: {
                this.send_error(requestor.socket, "The " + operation + " refers to ''all component''.");
                this.send_error(requestor.socket, MessageFormat.format("The {0} refers to ''all component''.", operation));
                return false;
            }
        }
        ComponentStruct comp = this.lookup_component(component_reference);
        if (comp == null) {
            this.send_error(requestor.socket, MessageFormat.format("The {0} refers to invalid component reference {1}.", operation, component_reference));
            return false;
        }
        switch (comp.tc_state) {
            case TC_STOPPING: 
            case PTC_STARTING: 
            case TC_IDLE: 
            case TC_CREATE: 
            case TC_START: 
            case TC_STOP: 
            case TC_KILL: 
            case TC_CONNECT: 
            case TC_DISCONNECT: 
            case TC_MAP: 
            case TC_UNMAP: 
            case MTC_TESTCASE: 
            case PTC_FUNCTION: 
            case PTC_STOPPED: {
                return true;
            }
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                if (new_connection) {
                    this.send_error(requestor.socket, MessageFormat.format("The {0} refers to test component with component reference {1}, which is currently being terminated.", operation, component_reference));
                    return false;
                }
                return true;
            }
            case TC_EXITED: 
            case TC_EXITING: {
                if (new_connection) {
                    this.send_error(requestor.socket, MessageFormat.format("The {0} refers to test component with component reference {1}, which has already terminated.", operation, component_reference));
                    return false;
                }
                return true;
            }
            case PTC_STALE: {
                this.send_error(requestor.socket, MessageFormat.format("The {0} refers to component reference {1} , which belongs to an earlier test case.", operation, component_reference));
                return false;
            }
        }
        this.send_error(requestor.socket, MessageFormat.format("The {0} refers to component reference {1} , which is in invalid state.", operation, component_reference));
        return false;
    }

    private void process_mtc_ready() {
        if (this.mc_state != mcStateEnum.MC_EXECUTING_CONTROL || this.mtc.tc_state != tc_state_enum.MTC_CONTROLPART) {
            this.send_error(this.mtc.socket, "Unexpected message MTC_READY was received.");
            return;
        }
        this.mc_state = mcStateEnum.MC_READY;
        this.mtc.tc_state = tc_state_enum.TC_IDLE;
        this.mtc.stop_requested = false;
        if (this.mtc.kill_timer != null) {
            this.cancel_timer(this.mtc.kill_timer);
            this.mtc.kill_timer = null;
        }
        this.stop_requested = false;
        this.notify("Test execution finished.");
        this.status_change();
    }

    public void shutdown_session() {
        this.lock();
        switch (this.mc_state) {
            case MC_INACTIVE: {
                this.status_change();
                break;
            }
            case MC_SHUTDOWN: {
                break;
            }
            case MC_LISTENING: 
            case MC_HC_CONNECTED: 
            case MC_LISTENING_CONFIGURED: 
            case MC_ACTIVE: {
                this.notify("Shutting down session.");
                this.wakeup_thread(wakeup_reason_t.REASON_SHUTDOWN);
                break;
            }
            default: {
                this.error("MainController::shutdown_session: called in wrong state.");
            }
        }
        this.unlock();
    }

    private void process_ptc_created(unknown_connection connection) {
        switch (this.mc_state) {
            case MC_EXECUTING_TESTCASE: 
            case MC_TERMINATING_TESTCASE: {
                break;
            }
            default: {
                this.send_error(connection.channel, "Message PTC_CREATED arrived in invalid state.");
                this.close_unknown_connection(connection);
                return;
            }
        }
        Text_Buf text_buf = connection.text_buf;
        int component_reference = text_buf.pull_int().get_int();
        switch (component_reference) {
            case 0: {
                this.send_error(connection.channel, "Message PTC_CREATED refers to the null component reference.");
                this.close_unknown_connection(connection);
                return;
            }
            case 1: {
                this.send_error(connection.channel, "Message PTC_CREATED refers to the component reference of the MTC.");
                this.close_unknown_connection(connection);
                return;
            }
            case 2: {
                this.send_error(connection.channel, "Message PTC_CREATED refers to the component reference of the system.");
                this.close_unknown_connection(connection);
                return;
            }
            case -1: {
                this.send_error(connection.channel, "Message PTC_CREATED refers to 'any component'.");
                this.close_unknown_connection(connection);
                return;
            }
            case -2: {
                this.send_error(connection.channel, "Message PTC_CREATED refers to 'all component'.");
                this.close_unknown_connection(connection);
                return;
            }
        }
        ComponentStruct tc = this.lookup_component(component_reference);
        if (tc == null) {
            this.send_error(connection.channel, MessageFormat.format("Message PTC_CREATED referes to invalid component reference {0}.", component_reference));
            this.close_unknown_connection(connection);
            return;
        }
        if (tc.tc_state != tc_state_enum.TC_INITIAL) {
            this.send_error(connection.channel, MessageFormat.format("Message PTC_CREATED refers to test component {0}, which is not being created.", component_reference));
            this.close_unknown_connection(connection);
            return;
        }
        tc.tc_state = tc_state_enum.TC_IDLE;
        tc.socket = connection.channel;
        channel_table_struct new_struct = new channel_table_struct();
        new_struct.channel_type = channel_type_enum.CHANNEL_TC;
        new_struct.component = tc;
        this.channel_table.put(connection.channel, new_struct);
        text_buf.cut_message();
        tc.text_buf = text_buf;
        this.delete_unknown_connection(connection);
        if (this.mc_state == mcStateEnum.MC_TERMINATING_TESTCASE || this.mtc.stop_requested || this.mtc.tc_state == tc_state_enum.MTC_ALL_COMPONENT_KILL || this.mtc.tc_state == tc_state_enum.MTC_ALL_COMPONENT_STOP && !tc.is_alive) {
            this.send_kill(tc);
            tc.tc_state = tc_state_enum.PTC_KILLING;
            if (!tc.is_alive) {
                tc.stop_requested = true;
            }
            tc.stop_requestors = MainController.init_requestors(null);
            tc.kill_requestors = MainController.init_requestors(null);
            this.start_kill_timer(tc);
        } else if (tc.create_requestor.tc_state == tc_state_enum.TC_CREATE) {
            this.send_create_ack(tc.create_requestor, component_reference);
            tc.create_requestor.tc_state = tc.create_requestor.equals(this.mtc) ? tc_state_enum.MTC_TESTCASE : tc_state_enum.PTC_FUNCTION;
        }
        this.handle_tc_data(tc, false);
        this.status_change();
    }

    private void send_kill(ComponentStruct tc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(22);
        this.send_message(tc.socket, text_buf);
    }

    private void send_kill_process(Host hc, int component_reference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(4);
        text_buf.push_int(component_reference);
        this.send_message(hc.socket, text_buf);
    }

    private void send_create_ack(ComponentStruct create_requestor, int component_reference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(1);
        text_buf.push_int(component_reference);
        this.send_message(create_requestor.socket, text_buf);
    }

    public boolean request_allowed(ComponentStruct from, String message_name) {
        if (!this.message_expected(from, message_name)) {
            return false;
        }
        switch (from.tc_state) {
            case MTC_TESTCASE: {
                if (!from.equals(this.mtc)) break;
                return true;
            }
            case PTC_FUNCTION: {
                if (from.equals(this.mtc)) break;
                return true;
            }
            case TC_STOPPING: 
            case PTC_STOPPING_KILLING: 
            case PTC_KILLING: {
                return false;
            }
        }
        this.notify(MessageFormat.format("The sender of message {0} is in unexpected state: {1}.", new Object[]{message_name, from.tc_state}));
        this.send_error(from.socket, MessageFormat.format("The sender of message {0} is in unexpected state.", message_name));
        return false;
    }

    private boolean message_expected(ComponentStruct from, String message_name) {
        switch (this.mc_state) {
            case MC_EXECUTING_TESTCASE: {
                switch (this.mtc.tc_state) {
                    case MTC_ALL_COMPONENT_STOP: 
                    case MTC_ALL_COMPONENT_KILL: {
                        return false;
                    }
                }
                return true;
            }
            case MC_TERMINATING_TESTCASE: {
                return false;
            }
        }
        this.send_error(from.socket, MessageFormat.format("Unexpected message {0} was received.", message_name));
        return false;
    }

    private void close_connection(Host hc) {
        try {
            hc.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hosts.remove(hc);
    }

    private void process_testcase_finished() {
        if (this.mc_state != mcStateEnum.MC_EXECUTING_TESTCASE) {
            this.send_error(this.mtc.socket, "Unexpected message TESTCASE_FINISHED was received.");
            return;
        }
        boolean ready_to_finish = this.kill_all_components(true);
        Text_Buf local_incoming_buf = this.mtc.text_buf;
        this.mc_state = mcStateEnum.MC_TERMINATING_TESTCASE;
        this.mtc.tc_state = tc_state_enum.MTC_TERMINATING_TESTCASE;
        int verdict = local_incoming_buf.pull_int().get_int();
        String reason = local_incoming_buf.pull_string();
        this.mtc.local_verdict = TitanVerdictType.VerdictTypeEnum.values()[verdict];
        this.mtc.verdict_reason = reason;
        this.mtc.stop_requested = false;
        if (this.mtc.kill_timer != null) {
            this.cancel_timer(this.mtc.kill_timer);
            this.mtc.kill_timer = null;
        }
        this.any_component_done_requested = false;
        this.any_component_done_sent = false;
        this.all_component_done_requested = false;
        this.any_component_killed_requested = false;
        this.all_component_killed_requested = false;
        if (ready_to_finish) {
            this.finish_testcase();
        }
        this.status_change();
    }

    private void finish_testcase() {
        if (this.stop_requested) {
            this.send_ptc_verdict(false);
            this.send_stop(this.mtc);
            this.mtc.tc_state = tc_state_enum.MTC_CONTROLPART;
            this.mtc.stop_requested = true;
            this.start_kill_timer(this.mtc);
            this.mc_state = mcStateEnum.MC_EXECUTING_CONTROL;
        } else if (this.stop_after_tc) {
            this.send_ptc_verdict(false);
            this.mtc.tc_state = tc_state_enum.MTC_PAUSED;
            this.mc_state = mcStateEnum.MC_PAUSED;
            this.notify("Execution has been paused.");
        } else {
            this.send_ptc_verdict(true);
            this.mtc.tc_state = tc_state_enum.MTC_CONTROLPART;
            this.mc_state = mcStateEnum.MC_EXECUTING_CONTROL;
        }
        for (int i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            ComponentStruct comp = this.components.get(i);
            comp.tc_state = tc_state_enum.PTC_STALE;
        }
        this.mtc.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
        this.mtc.comp_type = new QualifiedName("", "");
        this.mtc.tc_fn_name = new QualifiedName("", "");
        this.system.comp_type = new QualifiedName("", "");
    }

    private void send_ptc_verdict(boolean continue_execution) {
        ComponentStruct comp;
        int i;
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(23);
        int n_ptcs = 0;
        for (i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            comp = this.components.get(i);
            if (comp.tc_state == tc_state_enum.PTC_STALE) continue;
            ++n_ptcs;
        }
        text_buf.push_int(n_ptcs);
        for (i = this.tc_first_comp_ref; i < this.components.size(); ++i) {
            comp = this.components.get(i);
            if (comp.tc_state == tc_state_enum.PTC_STALE) continue;
            text_buf.push_int(comp.comp_ref);
            text_buf.push_string(comp.comp_name);
            text_buf.push_int(comp.local_verdict.getValue());
            text_buf.push_string(comp.verdict_reason);
        }
        text_buf.push_int(continue_execution ? 1 : 0);
        this.send_message(this.mtc.socket, text_buf);
    }

    private void process_testcase_started() {
        if (this.mc_state != mcStateEnum.MC_EXECUTING_CONTROL) {
            this.send_error(this.mtc.socket, "Unexpected message TESTCASE_STARTED was received.");
            return;
        }
        Text_Buf text_buf = this.mtc.text_buf;
        this.mtc.tc_fn_name = new QualifiedName(text_buf.pull_string(), text_buf.pull_string());
        this.mtc.comp_type = new QualifiedName(text_buf.pull_string(), text_buf.pull_string());
        this.system.comp_type = new QualifiedName(text_buf.pull_string(), text_buf.pull_string());
        this.mtc.tc_state = tc_state_enum.MTC_TESTCASE;
        this.mc_state = mcStateEnum.MC_EXECUTING_TESTCASE;
        this.tc_first_comp_ref = this.next_comp_ref;
        this.any_component_done_requested = false;
        this.any_component_done_sent = false;
        this.all_component_done_requested = false;
        this.any_component_killed_requested = false;
        this.all_component_killed_requested = false;
        this.status_change();
    }

    private void process_log(unknown_connection connection) {
        Text_Buf text_buf = connection.text_buf;
        int upper_int = text_buf.pull_int().get_int();
        int lower_int = text_buf.pull_int().get_int();
        long seconds = upper_int * -1 + lower_int;
        int microseconds = text_buf.pull_int().get_int();
        String source = MessageFormat.format("<unknown>@{0}", connection.ip_address.getHostAddress());
        int severity = text_buf.pull_int().get_int();
        int length = text_buf.pull_int().get_int();
        byte[] messageBytes = new byte[length];
        text_buf.pull_raw(length, messageBytes);
        this.notify(new Timeval(seconds, microseconds), source, severity, new String(messageBytes));
    }

    private void process_log(Host hc) {
        Text_Buf text_buf = hc.text_buf;
        int upper_int = text_buf.pull_int().get_int();
        int lower_int = text_buf.pull_int().get_int();
        long seconds = upper_int * -1 + lower_int;
        int microseconds = text_buf.pull_int().get_int();
        int severity = text_buf.pull_int().get_int();
        int length = text_buf.pull_int().get_int();
        byte[] messageBytes = new byte[length];
        text_buf.pull_raw(length, messageBytes);
        this.notify(new Timeval(seconds, microseconds), hc.log_source, severity, new String(messageBytes));
    }

    private void process_log(ComponentStruct tc) {
        Text_Buf text_buf = tc.text_buf;
        int upper_int = text_buf.pull_int().get_int();
        int lower_int = text_buf.pull_int().get_int();
        long seconds = upper_int * -1 + lower_int;
        int microseconds = text_buf.pull_int().get_int();
        int severity = text_buf.pull_int().get_int();
        int length = text_buf.pull_int().get_int();
        byte[] messageBytes = new byte[length];
        text_buf.pull_raw(length, messageBytes);
        this.notify(new Timeval(seconds, microseconds), tc.log_source, severity, new String(messageBytes));
    }

    public void execute_testcase(String moduleName, String testcaseName) {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_READY) {
            this.error("MainController::execute_testcase: called in wrong state.");
            this.unlock();
            return;
        }
        this.send_execute_testcase(moduleName, testcaseName);
        this.mc_state = mcStateEnum.MC_EXECUTING_CONTROL;
        this.mtc.tc_state = tc_state_enum.MTC_CONTROLPART;
        this.status_change();
        this.unlock();
    }

    public void stop_after_testcase(boolean newState) {
        this.lock();
        this.stop_after_tc = newState;
        if (this.mc_state == mcStateEnum.MC_PAUSED && !this.stop_after_tc) {
            this.unlock();
            this.continue_testcase();
        } else {
            this.unlock();
        }
    }

    public void continue_testcase() {
        this.lock();
        if (this.mc_state == mcStateEnum.MC_PAUSED) {
            this.notify("Resuming execution.");
            this.send_continue();
            this.mtc.tc_state = tc_state_enum.MTC_CONTROLPART;
            this.mc_state = mcStateEnum.MC_EXECUTING_CONTROL;
            this.ui.status_change();
        } else {
            this.error("MainController::continue_testcase: called in wrong state.");
        }
        this.unlock();
    }

    private void send_continue() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(24);
        this.send_message(this.mtc.socket, text_buf);
    }

    public void stop_execution() {
        this.lock();
        if (!this.stop_requested) {
            this.notify("Stopping execution.");
            switch (this.mc_state) {
                case MC_PAUSED: {
                    this.mc_state = mcStateEnum.MC_EXECUTING_CONTROL;
                    this.mtc.tc_state = tc_state_enum.MTC_CONTROLPART;
                }
                case MC_EXECUTING_CONTROL: {
                    this.send_stop(this.mtc);
                    this.mtc.stop_requested = true;
                    this.start_kill_timer(this.mtc);
                    this.wakeup_thread(wakeup_reason_t.REASON_MTC_KILL_TIMER);
                    break;
                }
                case MC_EXECUTING_TESTCASE: {
                    if (!this.mtc.stop_requested) {
                        this.send_stop(this.mtc);
                        this.kill_all_components(true);
                        this.mtc.stop_requested = true;
                        this.start_kill_timer(this.mtc);
                        this.wakeup_thread(wakeup_reason_t.REASON_MTC_KILL_TIMER);
                    }
                }
                case MC_READY: 
                case MC_TERMINATING_TESTCASE: {
                    break;
                }
                default: {
                    this.error("MainController::stop_execution: called in wrong state.");
                    this.unlock();
                    return;
                }
            }
            this.stop_requested = true;
            this.status_change();
        } else {
            this.notify("Stop was already requested. Operation ignored.");
        }
        this.unlock();
    }

    private void send_execute_testcase(String moduleName, String testcaseName) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(22);
        text_buf.push_string(moduleName);
        text_buf.push_string(testcaseName);
        this.send_message(this.mtc.socket, text_buf);
    }

    public void execute_control(String module_name) {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_READY) {
            this.error("MainController::execute_control: called in wrong state.");
            this.unlock();
            return;
        }
        this.send_execute_control(module_name);
        this.mc_state = mcStateEnum.MC_EXECUTING_CONTROL;
        this.mtc.tc_state = tc_state_enum.MTC_CONTROLPART;
        this.status_change();
        this.unlock();
    }

    private void send_execute_control(String module_name) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(21);
        text_buf.push_string(module_name);
        this.send_message(this.mtc.socket, text_buf);
    }

    private static RequestorStruct init_requestors(ComponentStruct tc) {
        RequestorStruct requestors = new RequestorStruct();
        if (tc != null) {
            requestors.components.add(tc);
        }
        return requestors;
    }

    public void exit_mtc() {
        this.lock();
        if (this.mc_state != mcStateEnum.MC_READY && this.mc_state != mcStateEnum.MC_RECONFIGURING) {
            this.error("MainController::exit_mtc: called in wrong state.");
            this.unlock();
            return;
        }
        this.notify("Terminating MTC.");
        this.send_exit_mtc();
        this.mtc.tc_state = tc_state_enum.TC_EXITING;
        --this.mtc.comp_location.n_active_components;
        this.mc_state = mcStateEnum.MC_TERMINATING_MTC;
        this.start_kill_timer(this.mtc);
        this.status_change();
        this.unlock();
    }

    private void send_exit_mtc() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(25);
        this.send_message(this.mtc.socket, text_buf);
    }

    private void shutdown_server() {
        if (this.mc_channel != null) {
            try {
                this.mc_channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel_table.remove(this.mc_channel);
            this.mc_channel = null;
        }
    }

    private void perform_shutdown() {
        boolean shutdown_complete = true;
        switch (this.mc_state) {
            case MC_HC_CONNECTED: 
            case MC_ACTIVE: {
                for (Host host : this.hosts) {
                    if (host.hc_state == hc_state_enum.HC_DOWN) continue;
                    this.send_exit_hc(host);
                    host.hc_state = hc_state_enum.HC_EXITING;
                    shutdown_complete = false;
                }
            }
            case MC_LISTENING: 
            case MC_LISTENING_CONFIGURED: {
                this.shutdown_server();
                if (shutdown_complete) {
                    this.mc_state = mcStateEnum.MC_INACTIVE;
                    break;
                }
                this.mc_state = mcStateEnum.MC_SHUTDOWN;
                this.status_change();
                break;
            }
            default: {
                this.fatal_error("MainController::perform_shutdown: called in wrong state.");
            }
        }
    }

    private void send_exit_hc(Host hc) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(5);
        this.send_message(hc.socket, text_buf);
    }

    private void clean_up() {
        this.shutdown_server();
        while (!this.unknown_connections.isEmpty()) {
            unknown_connection connection = this.unknown_connections.getFirst();
            this.close_unknown_connection(connection);
        }
        this.destroy_all_components();
        for (Host hc : this.hosts) {
            this.close_hc_connection(hc);
            hc.components.clear();
            hc.allowed_components.clear();
        }
        this.hosts.clear();
        this.config_str = null;
        while (!this.timers.isEmpty()) {
            this.cancel_timer(this.timers.peek());
        }
        this.modules.clear();
        try {
            this.mc_selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.channel_table.clear();
        this.mc_state = mcStateEnum.MC_INACTIVE;
    }

    public static class timer_struct {
        double expiration;
        ComponentStruct component;
    }

    private static class module_version_info {
        public String module_name;
        public byte[] module_checksum;

        private module_version_info() {
        }
    }

    private static class channel_table_struct {
        public channel_type_enum channel_type;
        public unknown_connection unknown;
        public Host host;
        public ComponentStruct component;

        private channel_table_struct() {
        }
    }

    private static enum channel_type_enum {
        CHANNEL_UNUSED,
        CHANNEL_SERVER,
        CHANNEL_UNKNOWN,
        CHANNEL_HC,
        CHANNEL_TC;

    }

    private static class RequestorStruct {
        List<ComponentStruct> components = new ArrayList<ComponentStruct>();

        private RequestorStruct() {
        }
    }

    private static class TimerStruct {
        double expiration;
        ComponentStruct component;

        private TimerStruct() {
        }
    }

    public static class ComponentStruct {
        public int comp_ref;
        public QualifiedName comp_type;
        public String comp_name;
        String log_source;
        Host comp_location;
        public tc_state_enum tc_state;
        public TitanVerdictType.VerdictTypeEnum local_verdict;
        String verdict_reason;
        SocketChannel socket;
        Text_Buf text_buf;
        public QualifiedName tc_fn_name;
        String return_type;
        byte[] return_value;
        boolean is_alive;
        boolean stop_requested;
        boolean process_killed;
        ComponentStruct create_requestor;
        String location_str;
        ComponentStruct start_requestor;
        byte[] arg;
        RequestorStruct cancel_done_sent_to;
        RequestorStruct stop_requestors;
        RequestorStruct kill_requestors;
        List<PortConnection> conn_head_list;
        List<PortConnection> conn_tail_list;
        RequestorStruct done_requestors;
        RequestorStruct killed_requestors;
        RequestorStruct cancel_done_sent_for;
        timer_struct kill_timer;
    }

    public static class QualifiedName {
        public String module_name;
        public String definition_name;

        public QualifiedName(String module_name, String definition_name) {
            this.module_name = module_name;
            this.definition_name = definition_name;
        }
    }

    public static class Host {
        public InetAddress ip_address;
        public String hostname;
        public String hostname_local;
        String machine_type;
        public String system_name;
        public String system_release;
        public String system_version;
        boolean[] transport_supported = new boolean[TTCN_Communication.transport_type_enum.TRANSPORT_NUM.ordinal()];
        String log_source;
        public hc_state_enum hc_state;
        SocketChannel socket;
        public Text_Buf text_buf;
        public List<Integer> components = new ArrayList<Integer>();
        public List<String> allowed_components = new ArrayList<String>();
        public boolean all_components_allowed;
        public int n_active_components;

        Host() {
        }
    }

    private static class HostGroupStruct {
        String group_name;
        boolean has_all_hosts;
        boolean has_all_components;
        List<String> host_members;
        List<String> assigned_components;

        private HostGroupStruct() {
        }
    }

    private static class unknown_connection {
        public SocketChannel channel;
        InetAddress ip_address;
        public Text_Buf text_buf;

        private unknown_connection() {
        }
    }

    private static class PortConnection {
        conn_state_enum conn_state;
        TTCN_Communication.transport_type_enum transport_type;
        int headComp;
        String headPort;
        int tailComp;
        String tailPort;
        RequestorStruct requestors;

        private PortConnection() {
        }
    }

    private static enum wakeup_reason_t {
        REASON_NOTHING,
        REASON_SHUTDOWN,
        REASON_MTC_KILL_TIMER;

    }

    public static enum tc_state_enum {
        TC_INITIAL,
        TC_IDLE,
        TC_CREATE,
        TC_START,
        TC_STOP,
        TC_KILL,
        TC_CONNECT,
        TC_DISCONNECT,
        TC_MAP,
        TC_UNMAP,
        TC_STOPPING,
        TC_EXITING,
        TC_EXITED,
        MTC_CONTROLPART,
        MTC_TESTCASE,
        MTC_ALL_COMPONENT_STOP,
        MTC_ALL_COMPONENT_KILL,
        MTC_TERMINATING_TESTCASE,
        MTC_PAUSED,
        PTC_FUNCTION,
        PTC_STARTING,
        PTC_STOPPED,
        PTC_KILLING,
        PTC_STOPPING_KILLING,
        PTC_STALE,
        TC_SYSTEM,
        MTC_CONFIGURING;

    }

    private static enum conn_state_enum {
        CONN_LISTENING,
        CONN_CONNECTING,
        CONN_CONNECTED,
        CONN_DISCONNECTING,
        CONN_MAPPING,
        CONN_MAPPED,
        CONN_UNMAPPING;

    }

    private static enum hc_state_enum {
        HC_IDLE,
        HC_CONFIGURING,
        HC_ACTIVE,
        HC_OVERLOADED,
        HC_CONFIGURING_OVERLOADED,
        HC_EXITING,
        HC_DOWN;

    }

    public static enum mcStateEnum {
        MC_INACTIVE,
        MC_LISTENING,
        MC_LISTENING_CONFIGURED,
        MC_HC_CONNECTED,
        MC_CONFIGURING,
        MC_ACTIVE,
        MC_SHUTDOWN,
        MC_CREATING_MTC,
        MC_READY,
        MC_TERMINATING_MTC,
        MC_EXECUTING_CONTROL,
        MC_EXECUTING_TESTCASE,
        MC_TERMINATING_TESTCASE,
        MC_PAUSED,
        MC_RECONFIGURING;

    }
}

