/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.cfgparser.CFGListener;
import org.eclipse.titan.runtime.core.cfgparser.CfgPreProcessor;
import org.eclipse.titan.runtime.core.cfgparser.ComponentSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.ConfigCharsetDetector;
import org.eclipse.titan.runtime.core.cfgparser.ExecuteSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.GroupSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.IOUtils;
import org.eclipse.titan.runtime.core.cfgparser.MCSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.RuntimeCfgLexer;
import org.eclipse.titan.runtime.core.cfgparser.RuntimeCfgParser;

public final class CfgAnalyzer {
    static final String TEMP_CFG_FILENAME = "temp.cfg";
    private ExecuteSectionHandler executeSectionHandler = null;
    private MCSectionHandler mcSectionHandler = null;
    private GroupSectionHandler groupSectionHandler = null;
    private ComponentSectionHandler componentSectionHandler = null;

    public ExecuteSectionHandler getExecuteSectionHandler() {
        return this.executeSectionHandler;
    }

    public boolean parse(File file) {
        String fileName = "<unknown file>";
        if (file != null) {
            fileName = file.getName();
        }
        return this.directParse(file, fileName, null);
    }

    public boolean parse(String code) {
        String fileName = "<unknown file>";
        return this.directParse(null, "<unknown file>", code);
    }

    static RuntimeCfgLexer createLexer(Reader reader, CFGListener lexerListener) {
        UnbufferedCharStream charStream = new UnbufferedCharStream(reader);
        RuntimeCfgLexer lexer = new RuntimeCfgLexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        if (lexerListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)lexerListener);
        }
        return lexer;
    }

    static CommonTokenStream createTokenStream(Reader reader, CFGListener lexerListener) {
        RuntimeCfgLexer lexer = CfgAnalyzer.createLexer(reader, lexerListener);
        return new CommonTokenStream((TokenSource)lexer);
    }

    private boolean directParse(File file, String fileName, String code) {
        Reader reader;
        CFGListener preparseListener = new CFGListener(fileName);
        boolean config_preproc_error = false;
        if (null != code) {
            reader = new StringReader(code);
        } else if (null != file) {
            try {
                File preparsedFile = new File(file.getParent(), TEMP_CFG_FILENAME);
                CfgPreProcessor preprocessor = new CfgPreProcessor();
                if (preprocessor.preparse(file, preparsedFile, preparseListener)) {
                    file = preparsedFile;
                }
                config_preproc_error = preprocessor.get_error_flag();
                ConfigCharsetDetector detector = new ConfigCharsetDetector(file);
                String detectedCharset = detector.detectCharSet();
                if (detectedCharset == null) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), detectedCharset));
            }
            catch (FileNotFoundException e) {
                throw new TtcnError(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new TtcnError(e);
            }
        } else {
            throw new TtcnError("CfgAnalyzer.directParse(): nothing to parse");
        }
        if (preparseListener.encounteredError() || config_preproc_error) {
            return true;
        }
        CFGListener lexerListener = new CFGListener(fileName);
        CommonTokenStream tokenStream = CfgAnalyzer.createTokenStream(reader, lexerListener);
        RuntimeCfgParser parser = new RuntimeCfgParser((TokenStream)tokenStream);
        RuntimeCfgParser.reset_configuration_options();
        parser.setActualFile(file);
        parser.removeErrorListeners();
        CFGListener parserListener = new CFGListener(fileName);
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        parser.setBuildParseTree(false);
        parser.pr_ConfigFile();
        this.executeSectionHandler = parser.getExecuteSectionHandler();
        this.mcSectionHandler = parser.getMcSectionHandler();
        this.groupSectionHandler = parser.getGroupSectionHandler();
        this.componentSectionHandler = parser.getComponentSectionHandler();
        IOUtils.closeQuietly((Closeable)reader);
        boolean config_process_error = parser.get_error_flag();
        return lexerListener.encounteredError() || parserListener.encounteredError() || config_process_error;
    }

    public MCSectionHandler getMcSectionHandler() {
        return this.mcSectionHandler;
    }

    public GroupSectionHandler getGroupSectionHandler() {
        return this.groupSectionHandler;
    }

    public ComponentSectionHandler getComponentSectionHandler() {
        return this.componentSectionHandler;
    }
}

