/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanHexString;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanOctetString_Element;
import org.eclipse.titan.runtime.core.TitanString_Utils;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanOctetString
extends Base_Type {
    private static final BER.ASN_Tag[] TitanOctetString_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 4)};
    public static final BER.ASN_BERdescriptor TitanOctetString_Ber_ = new BER.ASN_BERdescriptor(1, TitanOctetString_tag_);
    public static final RAW.TTCN_RAWdescriptor TitanOctetString_raw_ = new RAW.TTCN_RAWdescriptor(0, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_MSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanOctetString_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanOctetString_descr_ = new Base_Type.TTCN_Typedescriptor("OCTET STRING", TitanOctetString_Ber_, TitanOctetString_raw_, TitanOctetString_json_, null);
    public static final String HEX_DIGITS = "0123456789ABCDEF";
    private byte[] val_ptr;

    public TitanOctetString() {
    }

    public TitanOctetString(byte[] otherValue) {
        this.val_ptr = TitanString_Utils.copy_byte_list(otherValue);
    }

    public TitanOctetString(TitanOctetString otherValue) {
        otherValue.must_bound("Copying an unbound octetstring value.");
        this.val_ptr = TitanString_Utils.copy_byte_list(otherValue.val_ptr);
    }

    public TitanOctetString(TitanOctetString_Element otherValue) {
        otherValue.must_bound("Copying an unbound octetstring element.");
        this.val_ptr = new byte[1];
        this.val_ptr[0] = otherValue.get_nibble();
    }

    public TitanOctetString(byte value) {
        this.val_ptr = new byte[1];
        this.val_ptr[0] = value;
    }

    public TitanOctetString(String value) {
        this.val_ptr = TitanOctetString.octetstr2bytelist(value);
    }

    private static byte[] octetstr2bytelist(String aHexString) {
        int len = aHexString.length();
        byte[] result = new byte[(len + 1) / 2];
        for (int i = 0; i < len; i += 2) {
            byte value;
            char hexDigit1 = aHexString.charAt(i);
            char hexDigit2 = aHexString.charAt(i + 1);
            result[i / 2] = value = TitanOctetString.octet2value(hexDigit1, hexDigit2);
        }
        return result;
    }

    private static byte octet2value(char aHexDigit1, char aHexDigit2) {
        return (byte)(16 * TitanHexString.hexdigit2byte(aHexDigit1) + TitanHexString.hexdigit2byte(aHexDigit2));
    }

    public byte get_nibble(int nibble_index) {
        return this.val_ptr[nibble_index];
    }

    public void set_nibble(int nibble_index, byte new_value) {
        this.val_ptr[nibble_index] = new_value;
    }

    public byte[] get_value() {
        return this.val_ptr;
    }

    public void set_value(byte[] other_value) {
        this.val_ptr = other_value;
    }

    public TitanOctetString operator_assign(TitanOctetString otherValue) {
        otherValue.must_bound("Assignment of an unbound octetstring value.");
        if (otherValue != this) {
            this.val_ptr = otherValue.val_ptr;
        }
        return this;
    }

    public TitanOctetString operator_assign(TitanOctetString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound octetstring element to an octetstring.");
        this.val_ptr = new byte[1];
        this.val_ptr[0] = otherValue.get_nibble();
        return this;
    }

    public TitanOctetString operator_assign(TitanInteger otherValue) {
        return this.operator_assign(AdditionalFunctions.int2oct(otherValue, this.val_ptr.length));
    }

    @Override
    public TitanOctetString operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanOctetString) {
            return this.operator_assign((TitanOctetString)otherValue);
        }
        if (otherValue instanceof TitanInteger) {
            return this.operator_assign((TitanInteger)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to octetstring", otherValue));
    }

    @Override
    public boolean is_bound() {
        return this.val_ptr != null;
    }

    @Override
    public boolean is_value() {
        return this.val_ptr != null;
    }

    public TitanInteger lengthof() {
        this.must_bound("Performing lengthof operation on an unbound octetstring value.");
        return new TitanInteger(this.val_ptr.length);
    }

    public boolean operator_equals(TitanOctetString otherValue) {
        this.must_bound("Unbound left operand of octetstring comparison.");
        otherValue.must_bound("Unbound right operand of octetstring comparison.");
        return Arrays.equals(this.val_ptr, otherValue.val_ptr);
    }

    public boolean operator_equals(TitanOctetString_Element otherValue) {
        this.must_bound("Unbound left operand of octetstring comparison.");
        otherValue.must_bound("Unbound right operand of octetstring comparison.");
        return otherValue.operator_equals(this);
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanOctetString) {
            return this.operator_equals((TitanOctetString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to octetstring", otherValue));
    }

    public boolean operator_not_equals(TitanOctetString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanOctetString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(Base_Type otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public void clean_up() {
        this.val_ptr = null;
    }

    public TitanOctetString_Element get_at(int index_value) {
        if (this.val_ptr == null && index_value == 0) {
            this.val_ptr = new byte[1];
            return new TitanOctetString_Element(false, this, 0);
        }
        this.must_bound("Accessing an element of an unbound octetstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an octetstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.val_ptr.length;
        if (index_value > n_nibbles) {
            throw new TtcnError("Index overflow when accessing a octetstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " hexadecimal digits.");
        }
        if (index_value == n_nibbles) {
            byte[] temp = new byte[this.val_ptr.length + 1];
            System.arraycopy(this.val_ptr, 0, temp, 0, this.val_ptr.length);
            this.val_ptr = temp;
            return new TitanOctetString_Element(false, this, index_value);
        }
        return new TitanOctetString_Element(true, this, index_value);
    }

    public TitanOctetString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a octetstring value with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public final TitanOctetString_Element constGet_at(int index_value) {
        this.must_bound("Accessing an element of an unbound octetstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an octetstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.val_ptr.length;
        if (index_value >= n_nibbles) {
            throw new TtcnError("Index overflow when accessing a octetstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " hexadecimal digits.");
        }
        return new TitanOctetString_Element(true, this, index_value);
    }

    public final TitanOctetString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a octetstring value with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    @Override
    public void log() {
        if (this.val_ptr != null) {
            int i;
            boolean onlyPrintable = true;
            TTCN_Logger.log_char('\'');
            for (i = 0; i < this.val_ptr.length; ++i) {
                byte octet = this.val_ptr[i];
                TTCN_Logger.log_octet(octet);
                if (!onlyPrintable || TTCN_Logger.is_printable((char)octet)) continue;
                onlyPrintable = false;
            }
            TTCN_Logger.log_event_str("'O");
            if (onlyPrintable && this.val_ptr.length > 0) {
                TTCN_Logger.log_event_str("(\"");
                for (i = 0; i < this.val_ptr.length; ++i) {
                    TTCN_Logger.log_char_escaped((char)this.val_ptr[i]);
                }
                TTCN_Logger.log_event_str("\")");
            }
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "octetstring value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Octetstring: {
                switch (param.get_operation_type()) {
                    case OT_ASSIGN: {
                        this.clean_up();
                        this.val_ptr = new byte[param.get_string_size()];
                        System.arraycopy((byte[])param.get_string_data(), 0, this.val_ptr, 0, param.get_string_size());
                        break block0;
                    }
                    case OT_CONCAT: {
                        TitanOctetString temp = new TitanOctetString((byte[])param.get_string_data());
                        if (this.is_bound()) {
                            this.operator_assign(this.operator_concatenate(temp));
                            break block0;
                        }
                        this.operator_assign(temp);
                        break block0;
                    }
                }
                throw new TtcnError("Internal error: TitanOctetString.set_param()");
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanOctetString operand1 = new TitanOctetString();
                    TitanOctetString operand2 = new TitanOctetString();
                    operand1.set_param(param.get_operand1());
                    operand2.set_param(param.get_operand2());
                    if (param.get_operation_type() == Param_Types.Module_Parameter.operation_type_t.OT_CONCAT) {
                        this.operator_assign(this.operator_concatenate(operand1).operator_concatenate(operand2));
                        break;
                    }
                    this.operator_assign(operand1.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a octetstring");
                break;
            }
            default: {
                param.type_error("octetstring value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Octetstring(this);
    }

    public String toString() {
        if (this.val_ptr == null) {
            return "<unbound>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        for (byte digit : this.val_ptr) {
            sb.append(HEX_DIGITS.charAt((digit & 0xF0) >> 4));
            sb.append(HEX_DIGITS.charAt(digit & 0xF));
        }
        sb.append("'O");
        return sb.toString();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound octetstring value.");
        int octets = this.val_ptr.length;
        text_buf.push_int(octets);
        if (octets > 0) {
            text_buf.push_raw(this.val_ptr);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        int n_octets = text_buf.pull_int().get_int();
        if (n_octets < 0) {
            throw new TtcnError("Text decoder: Invalid length was received for an octetstring.");
        }
        this.val_ptr = new byte[n_octets];
        if (n_octets > 0) {
            text_buf.pull_raw(n_octets, this.val_ptr);
        }
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    public TitanOctetString operator_concatenate(TitanOctetString other_value) {
        this.must_bound("Unbound left operand of octetstring concatenation.");
        other_value.must_bound("Unbound right operand of octetstring concatenation.");
        if (this.val_ptr.length == 0) {
            return new TitanOctetString(other_value);
        }
        if (other_value.val_ptr.length == 0) {
            return new TitanOctetString(this);
        }
        TitanOctetString result = new TitanOctetString();
        result.val_ptr = new byte[this.val_ptr.length + other_value.val_ptr.length];
        System.arraycopy(this.val_ptr, 0, result.val_ptr, 0, this.val_ptr.length);
        System.arraycopy(other_value.val_ptr, 0, result.val_ptr, this.val_ptr.length, other_value.val_ptr.length);
        return result;
    }

    public TitanOctetString operator_concatenate(TitanOctetString_Element other_value) {
        this.must_bound("Unbound left operand of octetstring concatenation.");
        other_value.must_bound("Unbound right operand of octetstring element concatenation.");
        TitanOctetString result = new TitanOctetString();
        result.val_ptr = new byte[this.val_ptr.length + 1];
        System.arraycopy(this.val_ptr, 0, result.val_ptr, 0, this.val_ptr.length);
        result.val_ptr[this.val_ptr.length] = other_value.get_nibble();
        return result;
    }

    public TitanOctetString not4b() {
        this.must_bound("Unbound octetstring operand of operator not4b.");
        TitanOctetString result = new TitanOctetString();
        result.val_ptr = new byte[this.val_ptr.length];
        for (int i = 0; i < this.val_ptr.length; ++i) {
            int act_octet = this.val_ptr[i] & 0xFF;
            int digit1 = act_octet / 16;
            int digit2 = act_octet % 16;
            int negDigit1 = ~digit1 & 0xF;
            int negDigit2 = ~digit2 & 0xF;
            result.val_ptr[i] = (byte)((negDigit1 << 4) + negDigit2);
        }
        return result;
    }

    public TitanOctetString and4b(TitanOctetString otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound octetstring value.");
        otherValue.must_bound("Right operand of operator and4b is an unbound octetstring value.");
        if (this.val_ptr.length != otherValue.val_ptr.length) {
            throw new TtcnError("The octetstring operands of operator and4b must have the same length.");
        }
        TitanOctetString result = new TitanOctetString();
        result.val_ptr = new byte[this.val_ptr.length];
        for (int i = 0; i < this.val_ptr.length; ++i) {
            result.val_ptr[i] = (byte)(this.val_ptr[i] & otherValue.val_ptr[i]);
        }
        return result;
    }

    public TitanOctetString and4b(TitanOctetString_Element otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound octetstring value.");
        otherValue.must_bound("Right operand of operator and4b is an unbound octetstring value.");
        if (this.val_ptr.length != 1) {
            throw new TtcnError("The octetstring operands of operator and4b must have the same length.");
        }
        return new TitanOctetString((byte)(this.val_ptr[0] & otherValue.get_nibble()));
    }

    public TitanOctetString or4b(TitanOctetString otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound octetstring value.");
        otherValue.must_bound("Right operand of operator or4b is an unbound octetstring value.");
        if (this.val_ptr.length != otherValue.val_ptr.length) {
            throw new TtcnError("The octetstring operands of operator or4b must have the same length.");
        }
        TitanOctetString result = new TitanOctetString();
        result.val_ptr = new byte[this.val_ptr.length];
        for (int i = 0; i < this.val_ptr.length; ++i) {
            result.val_ptr[i] = (byte)(this.val_ptr[i] | otherValue.val_ptr[i]);
        }
        return result;
    }

    public TitanOctetString or4b(TitanOctetString_Element otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound octetstring value.");
        otherValue.must_bound("Right operand of operator or4b is an unbound octetstring value.");
        if (this.val_ptr.length != 1) {
            throw new TtcnError("The octetstring operands of operator or4b must have the same length.");
        }
        return new TitanOctetString((byte)(this.val_ptr[0] | otherValue.get_nibble()));
    }

    public TitanOctetString xor4b(TitanOctetString otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound octetstring value.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound octetstring value.");
        if (this.val_ptr.length != otherValue.val_ptr.length) {
            throw new TtcnError("The octetstring operands of operator xor4b must have the same length.");
        }
        TitanOctetString result = new TitanOctetString();
        result.val_ptr = new byte[this.val_ptr.length];
        for (int i = 0; i < this.val_ptr.length; ++i) {
            result.val_ptr[i] = (byte)(this.val_ptr[i] ^ otherValue.val_ptr[i]);
        }
        return result;
    }

    public TitanOctetString xor4b(TitanOctetString_Element otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound octetstring value.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound octetstring element.");
        if (this.val_ptr.length != 1) {
            throw new TtcnError("The octetstring operands of operator xor4b must have the same length.");
        }
        return new TitanOctetString((byte)(this.val_ptr[0] ^ otherValue.get_nibble()));
    }

    public TitanOctetString shift_left(int shift_count) {
        this.must_bound("Unbound octetstring operand of shift left operator.");
        if (shift_count > 0) {
            if (this.val_ptr.length == 0) {
                return new TitanOctetString(this);
            }
            TitanOctetString result = new TitanOctetString();
            result.val_ptr = new byte[this.val_ptr.length];
            if (shift_count > this.val_ptr.length) {
                shift_count = this.val_ptr.length;
            }
            System.arraycopy(this.val_ptr, shift_count, result.val_ptr, 0, this.val_ptr.length - shift_count);
            for (int i = this.val_ptr.length - shift_count; i < this.val_ptr.length; ++i) {
                result.val_ptr[i] = 0;
            }
            return result;
        }
        if (shift_count == 0) {
            return new TitanOctetString(this);
        }
        return this.shift_right(-shift_count);
    }

    public TitanOctetString shift_left(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of octetstring shift left operator.");
        return this.shift_left(shift_count.get_int());
    }

    public TitanOctetString shift_right(int shift_count) {
        this.must_bound("Unbound octetstring operand of shift right operator.");
        if (shift_count > 0) {
            if (this.val_ptr.length == 0) {
                return new TitanOctetString(this);
            }
            TitanOctetString result = new TitanOctetString();
            result.val_ptr = new byte[this.val_ptr.length];
            if (shift_count > this.val_ptr.length) {
                shift_count = this.val_ptr.length;
            }
            for (int i = 0; i < shift_count; ++i) {
                result.val_ptr[i] = 0;
            }
            System.arraycopy(this.val_ptr, 0, result.val_ptr, shift_count, this.val_ptr.length - shift_count);
            return result;
        }
        if (shift_count == 0) {
            return new TitanOctetString(this);
        }
        return this.shift_left(-shift_count);
    }

    public TitanOctetString shift_right(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of octetstring shift right operator.");
        return this.shift_right(shift_count.get_int());
    }

    public TitanOctetString rotate_left(int rotate_count) {
        this.must_bound("Unbound octetstring operand of rotate left operator.");
        if (this.val_ptr.length == 0) {
            return new TitanOctetString(this);
        }
        if (rotate_count >= 0) {
            if ((rotate_count %= this.val_ptr.length) == 0) {
                return this;
            }
            TitanOctetString result = new TitanOctetString();
            result.val_ptr = new byte[this.val_ptr.length];
            System.arraycopy(this.val_ptr, rotate_count, result.val_ptr, 0, this.val_ptr.length - rotate_count);
            System.arraycopy(this.val_ptr, 0, result.val_ptr, this.val_ptr.length - rotate_count, rotate_count);
            return result;
        }
        return this.rotate_right(-rotate_count);
    }

    public TitanOctetString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of octetstring rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanOctetString rotate_right(int rotate_count) {
        this.must_bound("Unbound octetstring operand of rotate right operator.");
        if (this.val_ptr.length == 0) {
            return new TitanOctetString(this);
        }
        if (rotate_count >= 0) {
            if ((rotate_count %= this.val_ptr.length) == 0) {
                return new TitanOctetString(this);
            }
            TitanOctetString result = new TitanOctetString();
            result.val_ptr = new byte[this.val_ptr.length];
            if (rotate_count > this.val_ptr.length) {
                rotate_count = this.val_ptr.length;
            }
            System.arraycopy(this.val_ptr, this.val_ptr.length - rotate_count, result.val_ptr, 0, rotate_count);
            System.arraycopy(this.val_ptr, 0, result.val_ptr, rotate_count, this.val_ptr.length - rotate_count);
            return result;
        }
        return this.rotate_left(-rotate_count);
    }

    public TitanOctetString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of octetstring rotate left operator.");
        return this.rotate_right(rotate_count.get_int());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type '{0}'", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
        }
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            byte[] bc = new byte[this.val_ptr.length];
            int bl = this.val_ptr.length * 8;
            int align_length = p_td.raw.fieldlength != 0 ? p_td.raw.fieldlength - bl : 0;
            int blength = this.val_ptr.length;
            if (bl + align_length < this.val_ptr.length * 8) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There are insufficient bits to encode '%s' : ", p_td.name);
                blength = p_td.raw.fieldlength / 8;
                bl = p_td.raw.fieldlength;
                align_length = 0;
            }
            if (p_td.raw.extension_bit != RAW.ext_bit_t.EXT_BIT_NO && myleaf.coding_par.bitorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                if (blength > 4) {
                    myleaf.data_array = new byte[blength];
                } else {
                    bc = myleaf.data_array;
                }
                for (int a = 0; a < blength; ++a) {
                    bc[a] = (byte)(this.val_ptr[a] << 1);
                }
            } else {
                myleaf.data_array = new byte[this.val_ptr.length];
                System.arraycopy(this.val_ptr, 0, myleaf.data_array, 0, this.val_ptr.length);
            }
            myleaf.align = p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB ? align_length : -align_length;
            myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
            int n = myleaf.length = bl + align_length;
            return n;
        }
        finally {
            errorcontext.leave_context();
        }
    }

    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
        int decode_length = p_td.raw.fieldlength == 0 ? (limit -= prepaddlength) / 8 * 8 : p_td.raw.fieldlength;
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            boolean orders;
            if (decode_length > limit || decode_length > buff.unread_len_bit()) {
                if (no_err) {
                    int n = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is not enough bits in the buffer to decode type '%s'.", p_td.name);
                decode_length = (limit > buff.unread_len_bit() ? buff.unread_len_bit() : limit) / 8 * 8;
            }
            RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
            boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.fieldorder = p_td.raw.fieldorder;
            cp.hexorder = TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.csn1lh = p_td.raw.csn1lh;
            if (p_td.raw.extension_bit != RAW.ext_bit_t.EXT_BIT_NO) {
                int rot;
                byte[] data = buff.get_read_data();
                int count = 1;
                int n = rot = top_bit_ord == TTCN_EncDec.raw_order_t.ORDER_LSB ? 0 : 7;
                if (p_td.raw.extension_bit == RAW.ext_bit_t.EXT_BIT_YES) {
                    while ((data[count - 1] >> rot & 1) == 0 && count * 8 < decode_length) {
                        ++count;
                    }
                } else {
                    while ((data[count - 1] >> rot & 1) == 1 && count * 8 < decode_length) {
                        ++count;
                    }
                }
                decode_length = count * 8;
            }
            this.val_ptr = new byte[decode_length / 8];
            buff.get_b(decode_length, this.val_ptr, cp, top_bit_ord);
            if (p_td.raw.length_restrition != -1 && decode_length > p_td.raw.length_restrition && p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                System.arraycopy(this.val_ptr, decode_length / 8 - this.val_ptr.length, this.val_ptr, 0, this.val_ptr.length);
            }
            if (p_td.raw.extension_bit != RAW.ext_bit_t.EXT_BIT_NO && cp.bitorder == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                for (int a = 0; a < decode_length / 8; ++a) {
                    this.val_ptr[a] = (byte)(this.val_ptr[a] >> 1 | this.val_ptr[a] << 7);
                }
            }
        }
        finally {
            errorcontext.leave_context();
        }
        return (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound pctetstring value.", new Object[0]);
            return -1;
        }
        StringBuilder tmp_str = new StringBuilder();
        tmp_str.append('\"');
        for (int i = 0; i < this.val_ptr.length; ++i) {
            tmp_str.append(AdditionalFunctions.hexdigit_to_char((this.val_ptr[i] & 0xF0) >> 4));
            tmp_str.append(AdditionalFunctions.hexdigit_to_char(this.val_ptr[i] & 0xF));
        }
        tmp_str.append('\"');
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str.toString());
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        boolean error = false;
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            if (value_len.get() >= 2 && value.charAt(0) == '\"' && value.charAt(value_len.get() - 1) == '\"') {
                String valueWithoutQuotes = value.substring(1, value.length() - 1);
                value.setLength(0);
                value.append(valueWithoutQuotes);
                value_len.set(value.length());
                int nibbles = value_len.get();
                for (int i = 0; i < value_len.get(); ++i) {
                    if (value.charAt(i) == ' ') {
                        --nibbles;
                        continue;
                    }
                    if (!TitanHexString.isxdigit(value.charAt(i)) || i + 1 == value_len.get() || !TitanHexString.isxdigit(value.charAt(i + 1))) {
                        if (value.charAt(i) == '\\' && i + 1 < value_len.get() && (value.charAt(i + 1) == 'n' || value.charAt(i + 1) == 'r' || value.charAt(i + 1) == 't')) {
                            ++i;
                            nibbles -= 2;
                            continue;
                        }
                        error = true;
                        break;
                    }
                    ++i;
                }
                if (!error) {
                    this.init_struct(nibbles / 2);
                    int octet_index = 0;
                    for (int i = 0; i < value_len.get() - 1; ++i) {
                        if (!TitanHexString.isxdigit(value.charAt(i)) || !TitanHexString.isxdigit(value.charAt(i + 1))) continue;
                        byte upper_nibble = AdditionalFunctions.char_to_hexdigit(value.charAt(i));
                        byte lower_nibble = AdditionalFunctions.char_to_hexdigit(value.charAt(i + 1));
                        this.val_ptr[octet_index] = (byte)(upper_nibble << 4 | lower_nibble);
                        ++octet_index;
                        ++i;
                    }
                }
            } else {
                error = true;
            }
        } else {
            return -1;
        }
        if (error) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "octetstring");
            }
            return -2;
        }
        return dec_len;
    }

    private void init_struct(int n_nibbles) {
        if (n_nibbles < 0) {
            this.val_ptr = null;
            throw new TtcnError("Initializing a hexstring with a negative length.");
        }
        this.val_ptr = n_nibbles == 0 ? new byte[0] : new byte[n_nibbles];
    }

    public static TitanOctetString convert_to_OctetString(TitanOctetString otherValue) {
        return otherValue;
    }

    public static TitanOctetString convert_to_OctetString(TitanOctetString_Element otherValue) {
        return new TitanOctetString(otherValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitanInteger convert_to_Integer(Base_Type.TTCN_Typedescriptor p_td) {
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While converting to integer type '%s': ", p_td.name);
        try {
            TTCN_Buffer ttcnBuffer = new TTCN_Buffer(this);
            TTCN_EncDec.raw_order_t order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
            TitanInteger integer = new TitanInteger();
            integer.RAW_decode(p_td, ttcnBuffer, ttcnBuffer.get_len() * 8, order);
            TitanInteger titanInteger = integer;
            return titanInteger;
        }
        finally {
            errorContext.leave_context();
        }
    }
}

