/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanBoolean;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.Ttcn3Float;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanFloat
extends Base_Type {
    private static final BER.ASN_Tag[] TitanReal_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 9)};
    public static final BER.ASN_BERdescriptor TitanFloat_Ber_ = new BER.ASN_BERdescriptor(1, TitanReal_tag_);
    public static final RAW.TTCN_RAWdescriptor TitanFloat_raw_ = new RAW.TTCN_RAWdescriptor(64, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanFloat_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanFloat_descr_ = new Base_Type.TTCN_Typedescriptor("REAL", TitanFloat_Ber_, TitanFloat_raw_, TitanFloat_json_, null);
    private Ttcn3Float float_value;
    public static final double PLUS_INFINITY = Double.POSITIVE_INFINITY;
    public static final double MINUS_INFINITY = Double.NEGATIVE_INFINITY;
    public static final double NOT_A_NUMBER = Double.NaN;
    public static final double MIN_DECIMAL_FLOAT = 1.0E-4;
    public static final double MAX_DECIMAL_FLOAT = 1.0E10;
    private static final String POS_INF_STR = "\"infinity\"";
    private static final String NEG_INF_STR = "\"-infinity\"";
    private static final String NAN_STR = "\"not_a_number\"";

    public TitanFloat() {
    }

    public TitanFloat(double otherValue) {
        this.float_value = new Ttcn3Float(otherValue);
    }

    public TitanFloat(Ttcn3Float otherValue) {
        this.float_value = otherValue;
    }

    public TitanFloat(TitanFloat otherValue) {
        otherValue.must_bound("Copying an unbound float value.");
        this.float_value = otherValue.float_value;
    }

    public Double get_value() {
        this.must_bound("Using the value of an unbound float variable.");
        return this.float_value.getValue();
    }

    public TitanFloat operator_assign(double otherValue) {
        this.float_value = new Ttcn3Float(otherValue);
        return this;
    }

    public TitanFloat operator_assign(Ttcn3Float otherValue) {
        this.float_value = otherValue;
        return this;
    }

    public TitanFloat operator_assign(TitanFloat otherValue) {
        otherValue.must_bound("Assignment of an unbound float value.");
        if (otherValue != this) {
            this.float_value = otherValue.float_value;
        }
        return this;
    }

    @Override
    public TitanFloat operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanFloat) {
            return this.operator_assign((TitanFloat)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to float", otherValue));
    }

    @Override
    public boolean is_bound() {
        return this.float_value != null;
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_value() {
        return this.float_value != null;
    }

    public static TitanBoolean is_special(double other_value) {
        return new TitanBoolean(other_value == Double.POSITIVE_INFINITY || other_value == Double.NEGATIVE_INFINITY || Double.isNaN(other_value));
    }

    public static void check_numeric(double float_value, String error_msg) {
        if (TitanFloat.is_special(float_value).get_value().booleanValue()) {
            throw new TtcnError(MessageFormat.format("{0} must be a numeric value instead of {1}", error_msg, float_value));
        }
    }

    public TitanFloat add() {
        this.must_bound("Unbound float operand of unary + operator.");
        return new TitanFloat(this.float_value);
    }

    public TitanFloat add(double other_value) {
        this.must_bound("Unbound left operand of float addition.");
        return new TitanFloat(this.float_value.add(other_value));
    }

    public TitanFloat add(Ttcn3Float other_value) {
        this.must_bound("Unbound left operand of float addition.");
        return new TitanFloat(this.float_value.add(other_value.getValue()));
    }

    public TitanFloat add(TitanFloat other_value) {
        this.must_bound("Unbound left operand of float addition.");
        other_value.must_bound("Unbound right operand of float addition.");
        return new TitanFloat(this.float_value.add(other_value.float_value.getValue()));
    }

    public TitanFloat sub() {
        this.must_bound("Unbound float operand of unary - operator (negation).");
        return new TitanFloat(-this.float_value.getValue());
    }

    public TitanFloat sub(double other_value) {
        this.must_bound("Unbound left operand of float subtraction.");
        return new TitanFloat(this.float_value.sub(other_value));
    }

    public TitanFloat sub(Ttcn3Float other_value) {
        this.must_bound("Unbound left operand of float subtraction.");
        return new TitanFloat(this.float_value.sub(other_value.getValue()));
    }

    public TitanFloat sub(TitanFloat other_value) {
        this.must_bound("Unbound left operand of float subtraction.");
        other_value.must_bound("Unbound right operand of float subtraction.");
        return new TitanFloat(this.float_value.sub(other_value.float_value.getValue()));
    }

    public TitanFloat mul(double other_value) {
        this.must_bound("Unbound left operand of float multiplication.");
        return new TitanFloat(this.float_value.mul(other_value));
    }

    public TitanFloat mul(Ttcn3Float other_value) {
        this.must_bound("Unbound left operand of float multiplication.");
        return new TitanFloat(this.float_value.mul(other_value.getValue()));
    }

    public TitanFloat mul(TitanFloat other_value) {
        this.must_bound("Unbound left operand of float multiplication.");
        other_value.must_bound("Unbound right operand of float multiplication.");
        return new TitanFloat(this.float_value.mul(other_value.float_value.getValue()));
    }

    public TitanFloat div(double other_value) {
        this.must_bound("Unbound left operand of float division.");
        if (other_value == 0.0) {
            throw new TtcnError("Float division by zero.");
        }
        return new TitanFloat(this.float_value.div(other_value));
    }

    public TitanFloat div(Ttcn3Float other_value) {
        this.must_bound("Unbound left operand of float division.");
        if (other_value.getValue() == 0.0) {
            throw new TtcnError("Float division by zero.");
        }
        return new TitanFloat(this.float_value.div(other_value.getValue()));
    }

    public TitanFloat div(TitanFloat other_value) {
        this.must_bound("Unbound left operand of float division.");
        other_value.must_bound("Unbound right operand of float division.");
        double otherValue = other_value.float_value.getValue();
        if (otherValue == 0.0) {
            throw new TtcnError("Float division by zero.");
        }
        return new TitanFloat(this.float_value.div(otherValue));
    }

    public boolean operator_equals(double otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        return this.float_value.operator_equals(otherValue);
    }

    public boolean operator_equals(Ttcn3Float otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        return this.float_value.operator_equals(otherValue.getValue());
    }

    public boolean operator_equals(TitanFloat otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        otherValue.must_bound("Unbound right operand of float comparison.");
        return this.float_value.operator_equals(otherValue.float_value.getValue());
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanFloat) {
            return this.operator_equals((TitanFloat)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", otherValue));
    }

    public boolean operator_not_equals(double otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(Ttcn3Float otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanFloat otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean is_less_than(double otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        return this.float_value.is_less_than(otherValue);
    }

    public boolean is_less_than(Ttcn3Float otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        return this.float_value.is_less_than(otherValue.getValue());
    }

    public boolean is_less_than(TitanFloat otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        otherValue.must_bound("Unbound right operand of float comparison.");
        return this.float_value.is_less_than(otherValue.float_value.getValue());
    }

    public boolean is_greater_than(double otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        return this.float_value.is_greater_than(otherValue);
    }

    public boolean is_greater_than(Ttcn3Float otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        return this.float_value.is_greater_than(otherValue.getValue());
    }

    public boolean is_greater_than(TitanFloat otherValue) {
        this.must_bound("Unbound left operand of float comparison.");
        otherValue.must_bound("Unbound right operand of float comparison.");
        return this.float_value.is_greater_than(otherValue.float_value.getValue());
    }

    public boolean is_less_than_or_equal(double otherValue) {
        return !this.is_greater_than(otherValue);
    }

    public boolean is_less_than_or_equal(Ttcn3Float otherValue) {
        return !this.is_greater_than(otherValue);
    }

    public boolean is_less_than_or_equal(TitanFloat otherValue) {
        return !this.is_greater_than(otherValue);
    }

    public boolean is_greater_than_or_equal(double otherValue) {
        return !this.is_less_than(otherValue);
    }

    public boolean is_greater_than_or_equal(Ttcn3Float otherValue) {
        return !this.is_less_than(otherValue);
    }

    public boolean is_greater_than_or_equal(TitanFloat otherValue) {
        return !this.is_less_than(otherValue);
    }

    @Override
    public void log() {
        if (this.float_value != null) {
            TitanFloat.log_float(this.float_value.getValue());
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void clean_up() {
        this.float_value = null;
    }

    static void log_float(double float_val) {
        if (float_val > -1.0E10 && float_val <= -1.0E-4 || float_val >= 1.0E-4 && float_val < 1.0E10 || float_val == 0.0) {
            TTCN_Logger.log_event("%f", float_val);
        } else if (float_val == Double.POSITIVE_INFINITY) {
            TTCN_Logger.log_event_str("infinity");
        } else if (float_val == Double.NEGATIVE_INFINITY) {
            TTCN_Logger.log_event_str("-infinity");
        } else if (float_val != float_val) {
            TTCN_Logger.log_event_str("not_a_number");
        } else {
            TTCN_Logger.log_event("%e", float_val);
        }
    }

    public String toString() {
        if (this.float_value == null) {
            return "<unbound>";
        }
        return this.float_value.toString();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound float value.");
        text_buf.push_double(this.float_value.getValue());
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.operator_assign(text_buf.pull_double());
    }

    public static TitanFloat add(double double_value, TitanFloat other_value) {
        other_value.must_bound("Unbound right operand of float addition.");
        return new TitanFloat(other_value.add(double_value));
    }

    public static TitanFloat sub(double double_value, TitanFloat other_value) {
        other_value.must_bound("Unbound right operand of float subtraction.");
        return new TitanFloat(double_value - other_value.get_value());
    }

    public static TitanFloat mul(double double_value, TitanFloat other_value) {
        other_value.must_bound("Unbound right operand of float multiplication.");
        return new TitanFloat(other_value.mul(double_value));
    }

    public static TitanFloat div(double double_value, TitanFloat other_value) {
        other_value.must_bound("Unbound right operand of float division.");
        double value = other_value.float_value.getValue();
        if (value == 0.0) {
            throw new TtcnError("Float division by zero.");
        }
        return new TitanFloat(double_value / other_value.get_value());
    }

    public static boolean operator_equals(double doubleValue, TitanFloat otherValue) {
        otherValue.must_bound("Unbound right operand of float comparison.");
        return otherValue.operator_equals(doubleValue);
    }

    public static boolean operator_not_equals(double doubleValue, TitanFloat otherValue) {
        otherValue.must_bound("Unbound right operand of float comparison.");
        return otherValue.operator_not_equals(doubleValue);
    }

    public static boolean is_less_than(double doubleValue, TitanFloat otherValue) {
        otherValue.must_bound("Unbound right operand of float comparison.");
        return otherValue.is_greater_than(doubleValue);
    }

    public static boolean is_greater_than(double doubleValue, TitanFloat otherValue) {
        otherValue.must_bound("Unbound right operand of float comparison.");
        return otherValue.is_less_than(doubleValue);
    }

    public static TitanBoolean is_less_than_or_equal(double doubleValue, TitanFloat otherValue) {
        otherValue.must_bound("Unbound right operand of float comparison.");
        return new TitanBoolean(otherValue.is_greater_than_or_equal(new TitanFloat(doubleValue)));
    }

    public static TitanBoolean is_greater_than_or_equal(double doubleValue, TitanFloat otherValue) {
        otherValue.must_bound("Unbound right operand of float comparison.");
        return new TitanBoolean(otherValue.is_less_than_or_equal(new TitanFloat(doubleValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_ANY, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        byte[] bc;
        int length = p_td.raw.fieldlength / 8;
        double tmp = this.float_value.getValue();
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
            tmp = 0.0;
        }
        if (Double.isNaN(tmp)) {
            TTCN_EncDec_ErrorContext.error_internal("Value is NaN.", new Object[0]);
        }
        if (length > 4) {
            myleaf.data_array = bc = new byte[length];
        } else {
            bc = myleaf.data_array;
        }
        if (length == 8) {
            byte[] dv = new byte[8];
            ByteBuffer.wrap(dv).putDouble(tmp);
            int i = 0;
            int k = 7;
            while (i < 8) {
                bc[i] = dv[k];
                ++i;
                --k;
            }
        } else if (length == 4) {
            if (tmp == 0.0) {
                for (int i = 0; i < 4; ++i) {
                    bc[i] = 0;
                }
            } else if (tmp == -0.0) {
                for (int i = 0; i < 4; ++i) {
                    bc[i] = 0;
                }
                bc[0] = (byte)(bc[0] | 0x80);
            } else {
                int index = 0;
                boolean adj = true;
                byte[] dv = new byte[8];
                ByteBuffer.wrap(dv).putDouble(tmp);
                bc[0] = (byte)(dv[index] & 0x80);
                int exponent = dv[index] & 0x7F;
                exponent <<= 4;
                exponent += (dv[++index] & 0xF0) >> 4;
                if ((exponent -= 1023) > 127) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "The float value %f is out of the range of the single precision: %s", this.float_value.getValue(), p_td.name);
                    tmp = 0.0;
                    exponent = 0;
                } else if (exponent < -127) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_FLOAT_TR, "The float value %f is too small to represent it in single precision: %s", this.float_value.getValue(), p_td.name);
                    tmp = 0.0;
                    exponent = 0;
                } else {
                    exponent += 127;
                }
                bc[0] = (byte)(bc[0] | exponent >> 1 & 0x7F);
                bc[1] = (byte)(exponent << 7 & 0x80 | (dv[index] & 0xF) << 3 | (dv[index + 1] & 0xE0) >> 5);
                bc[2] = (byte)((dv[++index] & 0x1F) << 3 | (dv[index + 1] & 0xE0) >> 5);
                bc[3] = (byte)((dv[++index] & 0x1F) << 3 | (dv[index + 1] & 0xE0) >> 5);
            }
        } else {
            TTCN_EncDec_ErrorContext.error_internal("Invalid FLOAT length {0}", length);
        }
        myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        myleaf.length = p_td.raw.fieldlength;
        return myleaf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
        limit -= prepaddlength;
        int decode_length = p_td.raw.fieldlength;
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            boolean orders;
            if (p_td.raw.fieldlength > limit || p_td.raw.fieldlength > buff.unread_len_bit()) {
                if (no_err) {
                    int n = -1;
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is not enough bits in the buffer to decode type %s.", p_td.name);
                decode_length = limit > buff.unread_len_bit() ? buff.unread_len_bit() : limit;
                this.float_value = new Ttcn3Float(0.0);
                int n = (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
                return n;
            }
            double tmp = 0.0;
            byte[] data = new byte[16];
            RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
            boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.fieldorder = p_td.raw.fieldorder;
            cp.hexorder = TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.csn1lh = p_td.raw.csn1lh;
            buff.get_b(decode_length, data, cp, top_bit_ord);
            if (decode_length == 64) {
                byte[] dv = new byte[8];
                int i = 0;
                int k = 7;
                while (i < 8) {
                    dv[i] = data[k];
                    ++i;
                    --k;
                }
                tmp = ByteBuffer.wrap(dv).getDouble();
                if (Double.isNaN(tmp)) {
                    if (no_err) {
                        i = -1;
                        return i;
                    }
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "Not a Number received for type %s.", p_td.name);
                    tmp = 0.0;
                }
            } else if (decode_length == 32) {
                int sign = (data[0] & 0x80) >> 7;
                int exponent = (data[0] & 0x7F) << 1 | (data[1] & 0x80) >> 7;
                int fraction = (data[1] & 0x7F) << 1 | (data[2] & 0x80) >> 7;
                fraction <<= 8;
                fraction += (data[2] & 0x7F) << 1 | (data[3] & 0x80) >> 7;
                fraction <<= 7;
                if (exponent == 0 && (fraction += data[3] & 0x7F) == 0) {
                    tmp = sign != 0 ? -0.0 : 0.0;
                } else if (exponent == 255 && fraction != 0) {
                    if (no_err) {
                        int n = -1;
                        return n;
                    }
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "Not a Number received for type %s.", p_td.name);
                    tmp = 0.0;
                } else if (exponent == 0 && fraction != 0) {
                    double sign_v = sign != 0 ? -1.0 : 1.0;
                    tmp = sign_v * ((double)fraction / 8388608.0) * Math.pow(2.0, -126.0);
                } else {
                    double sign_v = sign != 0 ? -1.0 : 1.0;
                    tmp = sign_v * (1.0 + (double)fraction / 8388608.0) * Math.pow(2.0, exponent -= 127);
                }
            }
            this.float_value = new Ttcn3Float(tmp);
        }
        finally {
            errorcontext.leave_context();
        }
        return (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "float value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Float: {
                this.operator_assign(param.get_float());
                break;
            }
            case MP_Expression: {
                switch (param.get_expr_type()) {
                    case EXPR_NEGATE: {
                        TitanFloat operand = new TitanFloat();
                        operand.set_param(param.get_operand1());
                        this.operator_assign(operand.sub());
                        break block0;
                    }
                    case EXPR_ADD: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.add(operand2));
                        break block0;
                    }
                    case EXPR_SUBTRACT: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.sub(operand2));
                        break block0;
                    }
                    case EXPR_MULTIPLY: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.mul(operand2));
                        break block0;
                    }
                    case EXPR_DIVIDE: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        if (operand2.operator_equals(0.0)) {
                            param.error("Floating point division by zero.", new Object[0]);
                        }
                        this.operator_assign(operand1.div(operand2));
                        break block0;
                    }
                }
                param.expr_type_error("a float");
                break;
            }
            default: {
                param.type_error("float value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Float(this.float_value.getValue());
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor cborFloatDescr, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        Pattern pattern;
        Matcher matcher;
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound float value.", new Object[0]);
            return -1;
        }
        double value = this.float_value.getValue();
        if (Double.POSITIVE_INFINITY == value) {
            return p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, POS_INF_STR);
        }
        if (Double.NEGATIVE_INFINITY == value) {
            return p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, NEG_INF_STR);
        }
        if (Double.isNaN(value)) {
            return p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, NAN_STR);
        }
        boolean decimal_repr = value == 0.0 || value > -1.0E10 && value <= -1.0E-4 || value >= 1.0E-4 && value < 1.0E10;
        String tmp_str = "";
        tmp_str = decimal_repr ? String.format(Locale.US, "%f", value) : ((matcher = (pattern = Pattern.compile("^[-]?\\d+[.](\\d+)[eE].*$")).matcher(String.valueOf(value))).matches() ? String.format(Locale.US, "%." + matcher.group(1).length() + "e", value) : String.format(Locale.US, "%e", value));
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str);
        return enc_len;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        int dec_len = p_tok.get_next_token(token, value, value_len);
        String valueStr = value.toString();
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (p_silent) return -2;
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING != token.get()) {
            if (JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER != token.get()) return -1;
            this.float_value = new Ttcn3Float(Double.parseDouble(valueStr));
            return dec_len;
        }
        if (POS_INF_STR.equals(valueStr)) {
            this.float_value = new Ttcn3Float(Double.POSITIVE_INFINITY);
            return dec_len;
        }
        if (NEG_INF_STR.equals(valueStr)) {
            this.float_value = new Ttcn3Float(Double.NEGATIVE_INFINITY);
            return dec_len;
        }
        if (NAN_STR.equals(valueStr)) {
            this.float_value = new Ttcn3Float(Double.NaN);
            return dec_len;
        }
        String spec_val = MessageFormat.format("float ({0}, {1} or {2})", POS_INF_STR, NEG_INF_STR, NAN_STR);
        if (!p_silent) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", spec_val);
        }
        this.float_value = null;
        return -2;
    }
}

